#include "tbasesstore_other.h"

//******************************************************************************************
//                                 TChangeProperties
//******************************************************************************************

TChangeProperties::TChangeProperties()
{
   suminfo.AddBanTime           = 0;
   suminfo.RepeaterBase         = 0;
}

TChangeProperties::~TChangeProperties()
{

}

void TChangeProperties::Lock()
{
   m_Mutex.Acquire();
}

void TChangeProperties::UnLock()
{
   m_Mutex.Release();
}

bool TChangeProperties::SetAddBanTime(ui16 AddBanTimeA)
{
   Lock();
   suminfo.AddBanTime = AddBanTimeA;
   UnLock();

   return true;
}

ui16 TChangeProperties::GetAddBanTime()
{
   ui16 res = 0;

   Lock();
   res = suminfo.AddBanTime;
   UnLock();

   return res;
}

bool TChangeProperties::SetRepeaterBase(ui16 RepeaterBaseA)
{
   Lock();
   suminfo.RepeaterBase = RepeaterBaseA;
   UnLock();

   return true;
}

ui16 TChangeProperties::GetRepeaterBase()
{
   ui16 res = 0;

   Lock();
   res = suminfo.RepeaterBase;
   UnLock();

   return res;
}

void TChangeProperties::SetWriteMailNumber(bool mailnumberA)
{
   Lock();
   suminfo.WriteMailNumber = mailnumberA;
   UnLock();
}

bool TChangeProperties::GetWriteMailNumber()
{
   bool res = false;

   Lock();
   res = suminfo.WriteMailNumber;
   UnLock();

   return res;
}

TChPropSummaryInfo TChangeProperties::GetSummaryInfo()
{
   TChPropSummaryInfo res;

   memset(&res, 0, sizeof(res));
   Lock();
   res = suminfo;
   UnLock();

   return res;
}

//**********************************************************************************
//                                     TBanStat
//**********************************************************************************

TBanStat::TBanStat()
{
      m_LastBanTime     = 0;
      m_LastIpListCheck = 0;
      m_ReturnCount     = 0;
      m_BanCount        = 0;
      m_SizeBanList     = 0;
      m_uniqip_cps      = 0;
};

TBanStat::TBanStat(const TBanStat &r)
{
      this->m_LastBanTime     = r.m_LastBanTime;
      this->m_LastIpListCheck = r.m_LastIpListCheck;
      this->m_ReturnCount     = r.m_ReturnCount;
      this->m_BanCount        = r.m_BanCount;
      this->m_SizeBanList     = r.m_SizeBanList;
      this->m_uniqip_cps      = r.m_uniqip_cps;
}

TBanStat &TBanStat::operator=(const TBanStat &r)
{
      this->m_LastBanTime     = r.m_LastBanTime;
      this->m_LastIpListCheck = r.m_LastIpListCheck;
      this->m_ReturnCount     = r.m_ReturnCount;
      this->m_BanCount        = r.m_BanCount;
      this->m_SizeBanList     = r.m_SizeBanList;
      this->m_uniqip_cps      = r.m_uniqip_cps;

      return *this;
}

TString TBanStat::GetLastBanTime()
{
      tm      ttime;
      char    tbuff[32];
      TString  res = "";
      time_t  vt  = 0;

      vt = m_LastBanTime;
      if (m_LastBanTime == 0)
         res = "-";
      else
      {
         memset(tbuff, 0, sizeof(tbuff));
         ttime = *localtime( /*( time_t* )&m_LastBanTime*/&vt);
         strftime(tbuff, sizeof(tbuff) - 1, "%Y.%m.%d %H:%M:%S", &ttime);

         res = TString(tbuff);
      }

      return res;
}

TString TBanStat::GetLastIpListCheck()
{
      tm      ttime;
      char    tbuff[32];
      time_t  vt  = 0;

      vt = m_LastIpListCheck;
      memset(tbuff, 0, sizeof(tbuff));
      ttime = *localtime( /*( time_t* )&m_LastIpListCheck*/&vt);
      strftime(tbuff, sizeof(tbuff) - 1, "%Y.%m.%d %H:%M:%S", &ttime);

      return TString(tbuff);
}

TString TBanStat::GetReturnCount()
{
      char    tbuff[32];

      memset(tbuff, 0, sizeof(tbuff));
      snprintf(tbuff, sizeof(tbuff) - 1, "%llu", m_ReturnCount);

      return TString(tbuff);
}

TString TBanStat::GetBanCount()
{
      char    tbuff[32];
      ui64    count = m_BanCount;

      memset(tbuff, 0, sizeof(tbuff));
      snprintf(tbuff, sizeof(tbuff) - 1, "%llu", /*m_BanCount*/count);

      return TString(tbuff);
}

TString TBanStat::GetSizeBanList()
{
      char    tbuff[32];

      memset(tbuff, 0, sizeof(tbuff));
      snprintf(tbuff, sizeof(tbuff) - 1, "%lu", m_SizeBanList);

      return TString(tbuff);
}

TString TBanStat::GetBanCPSUniqIP()
{
   return FloatToStr(m_uniqip_cps);
}

//*******************************************************************************************
