#pragma once

#include <library/cpp/deprecated/atomic/atomic.h>
#include <util/generic/string.h>
#include "util/system/mutex.h"
#include <mail/so/spamstop/tools/so-common/kfunc.h>
#include <time.h>

//*******************************************************************************************
//                                  TChangeProperties
//*******************************************************************************************

struct TChPropSummaryInfo
{
   ui16 AddBanTime;            //   
   ui16 RepeaterBase;          // ()  
   bool WriteMailNumber;       //true -     
};

class TChangeProperties
{
private:
      TMutex             m_Mutex;
      TChPropSummaryInfo suminfo;

      void   Lock();
      void   UnLock();
public:
      TChangeProperties();
      ~TChangeProperties();

      bool   SetAddBanTime(ui16 AddBanTimeA);
      ui16   GetAddBanTime();

      bool   SetRepeaterBase(ui16 RepeaterBaseA);
      ui16   GetRepeaterBase();

      void   SetWriteMailNumber(bool mailnumberA);
      bool   GetWriteMailNumber();

      TChPropSummaryInfo GetSummaryInfo();
};

//*******************************************************************************************
//                                     TBanStat
//*******************************************************************************************

struct TBanStat
{
   TAtomic           m_LastBanTime;
   TAtomic           m_LastIpListCheck;
   TAtomic           m_ReturnCount;
   TAtomic           m_BanCount;
   ui32              m_SizeBanList;
   float             m_uniqip_cps;

   TBanStat();
   TBanStat(const TBanStat &r);
   TBanStat &operator=(const TBanStat &r);

   TString GetLastBanTime();
   TString GetLastIpListCheck();
   TString GetReturnCount();
   TString GetBanCount();
   TString GetSizeBanList();
   TString GetBanCPSUniqIP();
};

//*******************************************************************************************


