#pragma once

#include <util/generic/string.h>
#include <util/string/reverse.h>
#include "tstatiptypes.h"
#include "tforwards.h"

#include <mail/so/spamstop/tools/so-common/serializehelper.h>

#define MAX8BITVALUE 250
#define MAX16BITVALUE 65000      //65535
#define MAX32BITVALUE 2000000000 //0xFFFFFFFF

#define SF_FORWARD 0x00000001           // forward spam
#define SF_BAN 0x00000002               // ban today
#define SF_BAN_WOW 0x00000004           // ban today manual
#define SF_OUR_USER 0x00000008          // our user
#define SF_SOURCE_DELIVERY_1 0x00000010 //  SOURCE_LEVEL_1
#define SF_SOURCE_DELIVERY_2 0x00000020 //  SOURCE_LEVEL_2
#define SF_SOURCE_DELIVERY_3 0x00000040 //  __SOURCE_LEVEL_1 __SOURCE_LEVEL_2
#define SF_BAN_500 0x00000080           //  after ban more than 500 mails
#define SF_BAN_REP 0x00000100           //  repeater
#define SF_WHITE 0x00000200             //  whitelist
#define SF_BAN_PROB 0x00000400          //  ban probation
#define SF_DSL 0x00000800               //  dsl
#define SF_SHM 0x00001000               //  SHM_500_1111_...
#define SF_VISIBLE_FRWD1 0x00002000     //  ����� ������� (�� ���� 17 � 19)
#define SF_VISIBLE_FRWD2 0x00004000     //  ����� ������� (������ �� ���� 19)
#define SF_RBL4 0x00008000              //  rbl4
#define SF_WAS_BAN_WOW 0x00010000       //  was ban today manual

#define IS_SF_FORWARD(flag) ((flag)&SF_FORWARD)
#define IS_SF_BAN(flag) ((flag)&SF_BAN)
#define IS_SF_BAN_WOW(flag) ((flag)&SF_BAN_WOW)
#define IS_SF_OUR_USER(flag) ((flag)&SF_OUR_USER)
#define IS_SF_SOURCE_DELIVERY_1(flag) ((flag)&SF_SOURCE_DELIVERY_1)
#define IS_SF_SOURCE_DELIVERY_2(flag) ((flag)&SF_SOURCE_DELIVERY_2)
#define IS_SF_SOURCE_DELIVERY_3(flag) ((flag)&SF_SOURCE_DELIVERY_3)
#define IS_SF_BAN_500(flag) ((flag)&SF_BAN_500)
#define IS_SF_BAN_REP(flag) ((flag)&SF_BAN_REP)
#define IS_SF_WHITE(flag) ((flag)&SF_WHITE)
#define IS_SF_BAN_PROB(flag) ((flag)&SF_BAN_PROB)
#define IS_SF_DSL(flag) ((flag)&SF_DSL)
#define IS_SF_SHM(flag) ((flag)&SF_SHM)
#define IS_SF_VISIBLE_FRWD1(flag) ((flag)&SF_VISIBLE_FRWD1)
#define IS_SF_VISIBLE_FRWD2(flag) ((flag)&SF_VISIBLE_FRWD2)
#define IS_SF_RBL4(flag) ((flag)&SF_RBL4)
#define IS_SF_WAS_BAN_WOW(flag) ((flag)&SF_WAS_BAN_WOW)

#define SET_SF_FORWARD(flag) \
    { (flag) |= SF_FORWARD; }
#define SET_SF_BAN(flag) \
    { (flag) |= SF_BAN; }
#define SET_SF_BAN_WOW(flag) \
    { (flag) |= SF_BAN_WOW; }
#define RESET_SF_BAN(flag) \
    { (flag) = ~SF_BAN & (flag); }
#define RESET_SF_BAN_WOW(flag) \
    { (flag) = ~SF_BAN_WOW & (flag); }
#define SET_SF_OUR_USER(flag) \
    { (flag) |= SF_OUR_USER; }
#define SET_SF_SOURCE_DELIVERY_1(flag) \
    { (flag) |= SF_SOURCE_DELIVERY_1; }
#define SET_SF_SOURCE_DELIVERY_2(flag) \
    { (flag) |= SF_SOURCE_DELIVERY_2; }
#define SET_SF_SOURCE_DELIVERY_3(flag) \
    { (flag) |= SF_SOURCE_DELIVERY_3; }
#define SET_SF_BAN_500(flag) \
    { (flag) |= SF_BAN_500; }
#define SET_SF_BAN_REP(flag) \
    { (flag) |= SF_BAN_REP; }
#define SET_SF_WHITE(flag) \
    { (flag) |= SF_WHITE; }
#define RESET_SF_WHITE(flag) \
    { (flag) = ~SF_WHITE & (flag); }
#define SET_SF_BAN_PROB(flag) \
    { (flag) |= SF_BAN_PROB; }
#define SET_SF_DSL(flag) \
    { (flag) |= SF_DSL; }
#define SET_SF_SHM(flag) \
    { (flag) |= SF_SHM; }
#define SET_SF_VISIBLE_FRWD1(flag) \
    { (flag) |= SF_VISIBLE_FRWD1; }
#define SET_SF_VISIBLE_FRWD2(flag) \
    { (flag) |= SF_VISIBLE_FRWD2; }
#define SET_SF_RBL4(flag) \
    { (flag) |= SF_RBL4; }
#define SET_SF_WAS_BAN_WOW(flag) \
    { (flag) |= SF_WAS_BAN_WOW; }

struct TIpMem {
    bool db_overwriteflag;
    TKIPv6 ip;       //ip for backup
    time_t tLastMes; //���� ��������� �������� ip � ����
    time_t tFixDay;  //���� �������� �����

    ui32 ctSpam;          //� ��� ����� � malicious
    ui32 ctHam;           //dlv or ham
    ui32 ctMalicSpam;     //malicious spam
    ui32 ctSpamMail;      //� ��� ����� � malicious (�� ���-�� ��������� �� id)
    ui32 ctHamMail;       //dlv or ham (�� ���-�� ��������� �� id)
    ui32 ctMalicSpamMail; //malicious spam (�� ���-�� ��������� �� id)
    ui16 cPop3;           //���-�� ����� c�������� �� POP3
    ui16 cDsn;            //���-�� ����� DSN
    ui16 cRejected;       //���������� ����� �������� ����� ���� = pbanip->cMessage
    ui16 cMcount;         //c���� ���� MCOUNT = m_Uwl
    ui32 bMask;           //bit mask (forwards, ...)
    ui16 cWeightSum;      //total messages weight for day (w/o DSN)++
    ui16 cWMess;          //total messages for day (w/o DSN) ++
    TIpForwards forwards; //��������
    ui16 PANNERN_STAT[15];
    time_t cps_otc;
    ui32 cps_tall;
    float cps;
    ui32 malicspam_count; //���-�� ����� � ����������� �������� MALICIOUS_SPAMER
    ui32 ban7count;       //������� ����� �������� �� �������� ban7
    TString rdns;
    float koef2; //��������� ������� �������� ���������� yesterday, ���� ����� �� ���� ������ 24 �����
    ui16 cps5mcount;
    ui16 cps20mcount;
    ui16 cps50mcount;
    ui16 cps100mcount;
    ui16 cpsGreatmcount;
    ui8 SpamMailBoxCount; //���-�� ������, ��� ���� ���� �� ���� �������� ������
    TString geodata;      //���������
    //ui32        ManualBanCount; //������� ��� ������ �������
    ui32 pcmb;
    ui32 manual_ban_count;
    ui32 ban_count;

    TIpMem() {
        db_overwriteflag = false;
        ip = TKIPv6();
        tLastMes = 0;
        tFixDay = 0;
        ctSpam = 0;
        ctHam = 0;
        ctMalicSpam = 0;
        ctSpamMail = 0;
        ctHamMail = 0;
        ctMalicSpamMail = 0;
        cPop3 = 0;
        cDsn = 0;
        cRejected = 0;
        cMcount = 0;
        bMask = 0;
        cWeightSum = 0;
        cWMess = 0;
        forwards.clear();
        memset(PANNERN_STAT, 0, sizeof(PANNERN_STAT));
        cps_otc = 0;
        cps_tall = 0;
        cps = 0;
        malicspam_count = 0;
        ban7count = 0;
        rdns = "";
        koef2 = 1;
        cps5mcount = 0;
        cps20mcount = 0;
        cps50mcount = 0;
        cps100mcount = 0;
        cpsGreatmcount = 0;
        SpamMailBoxCount = 0;
        geodata = "";
        //ManualBanCount  = 0;
        pcmb = 0;
        manual_ban_count = 0;
        ban_count = 0;
    };

    void clear() {
        db_overwriteflag = true;
        //ip - �� �������
        tLastMes = 0;
        tFixDay = 0;
        ctSpam = 0;
        ctHam = 0;
        ctMalicSpam = 0;
        ctSpamMail = 0;
        ctHamMail = 0;
        ctMalicSpamMail = 0;
        cPop3 = 0;
        cDsn = 0;
        cRejected = 0;
        cMcount = 0;
        bMask = 0;
        cWeightSum = 0;
        cWMess = 0;
        forwards.clear();
        memset(PANNERN_STAT, 0, sizeof(PANNERN_STAT));
        cps_otc = 0;
        cps_tall = 0;
        cps = 0;
        malicspam_count = 0;
        ban7count = 0;
        rdns = "";
        koef2 = 1;
        cps5mcount = 0;
        cps20mcount = 0;
        cps50mcount = 0;
        cps100mcount = 0;
        cpsGreatmcount = 0;
        SpamMailBoxCount = 0;
        geodata = "";
        //ManualBanCount  = 0;
        pcmb = 0;
        manual_ban_count = 0;
        ban_count = 0;
    };
};

struct TIpMemCopy //���������� �� TIpMem ���, ��� ������ ������ TIpForwards ���� ������ �� ���������
{
    TKIPv6 ip;       //ip for backup
    time_t tLastMes; //���� ��������� �������� ip � ����
    time_t tFixDay;  //���� �������� �����

    ui32 ctSpam;          //� ��� ����� � malicious
    ui32 ctHam;           //dlv or ham
    ui32 ctMalicSpam;     //malicious spam
    ui32 ctSpamMail;      //� ��� ����� � malicious (�� ���-�� ��������� �� id)
    ui32 ctHamMail;       //dlv or ham (�� ���-�� ��������� �� id)
    ui32 ctMalicSpamMail; //malicious spam (�� ���-�� ��������� �� id)
    ui16 cPop3;           //���-�� ����� c�������� �� POP3
    ui16 cDsn;            //���-�� ����� DSN
    ui16 cRejected;       //���������� ����� �������� ����� ���� = pbanip->cMessage
    ui16 cMcount;         //c���� ���� MCOUNT = m_Uwl
    ui32 bMask;           //bit mask ??
    ui16 cWeightSum;      //total messages weight for day (w/o DSN)++
    ui16 cWMess;          //total messages for day (w/o DSN) ++
    //TFrwdData   frwddata;       //������ �� ���������
    ui16 PANNERN_STAT[15];
    time_t cps_otc;
    ui32 cps_tall;
    float cps;
    ui32 malicspam_count; //���-�� ����� � ����������� �������� MALICIOUS_SPAMER
    ui32 ban7count;       //������� ����� �������� �� �������� ban7
    //TString      rdns;
    char rdns[256];
    float koef2; //��������� ������� �������� ���������� yesterday, ���� ����� �� ���� ������ 24 �����
    ui16 cps5mcount;
    ui16 cps20mcount;
    ui16 cps50mcount;
    ui16 cps100mcount;
    ui16 cpsGreatmcount;
    ui8 SpamMailBoxCount; //���-�� ������, ��� ���� ���� �� ���� �������� ������
    //ui32        cManualBanCount;

    TIpMemCopy() {
        ip = TKIPv6();
        tLastMes = 0;
        tFixDay = 0;
        ctSpam = 0;
        ctHam = 0;
        ctMalicSpam = 0;
        ctSpamMail = 0;
        ctHamMail = 0;
        ctMalicSpamMail = 0;
        cPop3 = 0;
        cDsn = 0;
        cRejected = 0;
        cMcount = 0;
        bMask = 0;
        cWeightSum = 0;
        cWMess = 0;
        //memset(&frwddata, 0, sizeof(frwddata));
        memset(PANNERN_STAT, 0, sizeof(PANNERN_STAT));
        cps_otc = 0;
        cps_tall = 0;
        cps = 0;
        malicspam_count = 0;
        ban7count = 0;
        //rdns            = "";
        memset(rdns, 0, sizeof(rdns));
        koef2 = 1;
        cps5mcount = 0;
        cps20mcount = 0;
        cps50mcount = 0;
        cps100mcount = 0;
        cpsGreatmcount = 0;
        SpamMailBoxCount = 0;
        //cManualBanCount = 0;
    };

    TIpMemCopy(TIpMem& value) {
        ip = value.ip;
        tLastMes = value.tLastMes;
        tFixDay = value.tFixDay;
        ctSpam = value.ctSpam;
        ctHam = value.ctHam;
        ctMalicSpam = value.ctMalicSpam;
        ctSpamMail = value.ctSpamMail;
        ctHamMail = value.ctHamMail;
        ctMalicSpamMail = value.ctMalicSpamMail;
        cPop3 = value.cPop3;
        cDsn = value.cDsn;
        cRejected = value.cRejected;
        cMcount = value.cMcount;
        bMask = value.bMask;
        cWeightSum = value.cWeightSum;
        cWMess = value.cWMess;
        //memset(&frwddata, 0, sizeof(frwddata));
        //frwddata        = value.forwards.GetForwardsData();
        for (int i = 0; i < 15; i++)
            PANNERN_STAT[i] = value.PANNERN_STAT[i];
        cps_otc = value.cps_otc;
        cps_tall = value.cps_tall;
        cps = value.cps;
        malicspam_count = value.malicspam_count;
        ban7count = value.ban7count;
        //rdns            = value.rdns;
        strncpy(rdns, value.rdns.c_str(), sizeof(rdns));
        koef2 = value.koef2;
        cps5mcount = value.cps5mcount;
        cps20mcount = value.cps20mcount;
        cps50mcount = value.cps50mcount;
        cps100mcount = value.cps100mcount;
        cpsGreatmcount = value.cpsGreatmcount;
        SpamMailBoxCount = value.SpamMailBoxCount;
        //cManualBanCount = value.ManualBanCount;
    };

    void clear() {
        //ip - �� �������
        tLastMes = 0;
        tFixDay = 0;
        ctSpam = 0;
        ctHam = 0;
        ctMalicSpam = 0;
        ctSpamMail = 0;
        ctHamMail = 0;
        ctMalicSpamMail = 0;
        cPop3 = 0;
        cDsn = 0;
        cRejected = 0;
        cMcount = 0;
        bMask = 0;
        cWeightSum = 0;
        cWMess = 0;
        //memset(&frwddata, 0, sizeof(frwddata));
        memset(PANNERN_STAT, 0, sizeof(PANNERN_STAT));
        cps_otc = 0;
        cps_tall = 0;
        cps = 0;
        malicspam_count = 0;
        ban7count = 0;
        //rdns            = "";
        memset(rdns, 0, sizeof(rdns));
        koef2 = 1;
        cps5mcount = 0;
        cps20mcount = 0;
        cps50mcount = 0;
        cps100mcount = 0;
        cpsGreatmcount = 0;
        SpamMailBoxCount = 0;
        //cManualBanCount = 0;
    };
};

struct TIpMemY {
    ui32 ctSpam;          //� ��� ����� � malicious
    ui32 ctHam;           //dlv or ham
    ui32 ctMalicSpam;     //malicious spam //??? - ��� ����������?
    ui32 ctSpamMail;      //� ��� ����� � malicious (�� ���-�� ��������� �� id)
    ui32 ctHamMail;       //dlv or ham (�� ���-�� ��������� �� id)
    ui32 ctMalicSpamMail; //malicious spam (�� ���-�� ��������� �� id)
    ui16 cPop3;           //���-�� ����� c�������� �� POP3
    ui16 cDsn;            //���-�� ����� DSN
    ui16 cRejected;       //���������� ����� �������� ����� ���� = pbanip->cMessage
    ui16 cMcount;         //c���� ���� MCOUNT = m_Uwl
    ui32 bMask;           //bit mask ??
    ui16 cWeightSum;      //total messages weight for day (w/o DSN)++
    ui16 cWMess;          //total messages for day (w/o DSN) ++
    //ui32        cManualBanCount;

    TIpMemY() {
        ctSpam = 0;
        ctHam = 0;
        ctMalicSpam = 0;
        ctSpamMail = 0;
        ctHamMail = 0;
        ctMalicSpamMail = 0;
        cPop3 = 0;
        cDsn = 0;
        cRejected = 0;
        cMcount = 0;
        bMask = 0;
        cWeightSum = 0;
        cWMess = 0;
        //cManualBanCount = 0;
    };

    void clear() {
        ctSpam = 0;
        ctHam = 0;
        ctMalicSpam = 0;
        ctSpamMail = 0;
        ctHamMail = 0;
        ctMalicSpamMail = 0;
        cPop3 = 0;
        cDsn = 0;
        cRejected = 0;
        cMcount = 0;
        bMask = 0;
        cWeightSum = 0;
        cWMess = 0;
        //cManualBanCount = 0;
    }
};

struct TIpDisk {
    time_t tFirstDeal; //���� ��������� ip � ���� ++
    time_t tLastMes;   //���� ��������� �������� ip � ���� ++

    ui32 ctSpam; //� ��� ����� � malicious
    ui32 ctHam;  //dlv or ham
    ui32 ctMalicSpam;
    ui16 cDsn; //���-�� ����� DSN

    ui16 cPop3_Auth; //������� ���� ������� ������� POP3_AUTH
    ui16 cDaysRej;   //������� ���� ���������
    ui16 cDaysNoRej; //������� ���� ��������� ��� ���������
    ui16 cFwdDays;   //������� ���� ���������� ��� �������

    ui32 cManualBanCount; //������� ����, � ������� ��� ���� ��� ������� �������
    ui32 unused2;         //**
    ui32 unused3;         //**
    ui32 unused4;         //** tmp
    ui32 crc32;           //crc32

    TIpDisk() {
        tFirstDeal = 0;
        tLastMes = 0;
        ctSpam = 0;
        ctHam = 0;
        ctMalicSpam = 0;
        cDsn = 0;
        cPop3_Auth = 0;
        cDaysRej = 0;
        cDaysNoRej = 0;
        cFwdDays = 0;
        cManualBanCount = 0;
        unused2 = 0;
        unused3 = 0;
        unused4 = 0;
        crc32 = 0;
    };

    ui32 GetCRC32(ui32 cs) {
        ui8 buff[256];
        int n = 0;
        ui32 i = 0, j = 0;

        memset(buff, 0, sizeof(buff));
        memcpy(buff + n, &tFirstDeal, sizeof(tFirstDeal));
        n += sizeof(tFirstDeal);
        memcpy(buff + n, &tLastMes, sizeof(tLastMes));
        n += sizeof(tLastMes);
        memcpy(buff + n, &ctSpam, sizeof(ctSpam));
        n += sizeof(ctSpam);
        memcpy(buff + n, &ctHam, sizeof(ctHam));
        n += sizeof(ctHam);
        memcpy(buff + n, &ctMalicSpam, sizeof(ctMalicSpam));
        n += sizeof(ctMalicSpam);
        memcpy(buff + n, &cDsn, sizeof(cDsn));
        n += sizeof(cDsn);
        memcpy(buff + n, &cPop3_Auth, sizeof(cPop3_Auth));
        n += sizeof(cPop3_Auth);
        memcpy(buff + n, &cDaysRej, sizeof(cDaysRej));
        n += sizeof(cDaysRej);
        memcpy(buff + n, &cDaysNoRej, sizeof(cDaysNoRej));
        n += sizeof(cDaysNoRej);
        memcpy(buff + n, &cFwdDays, sizeof(cFwdDays));
        n += sizeof(cFwdDays);
        memcpy(buff + n, &cManualBanCount, sizeof(cManualBanCount));
        n += sizeof(cManualBanCount);
        memcpy(buff + n, &unused2, sizeof(unused2));
        n += sizeof(unused2);
        memcpy(buff + n, &unused3, sizeof(unused3));
        n += sizeof(unused3);
        memcpy(buff + n, &unused4, sizeof(unused4));
        n += sizeof(unused4);
        for (i = 0, j = 0; i < n; i++, j++) {
            if (j == 4)
                j = 0;

            if (!j)
                cs += (buff[i] & 0xFF);
            else
                cs += (((buff[i] << (8 * j))) & 0xFF);
        }

        return cs;
    }

    void Clear() {
        tFirstDeal = (long)0;
        tLastMes = (long)0;

        ctSpam = 0;
        ctHam = 0;
        ctMalicSpam = 0;
        cDsn = 0;

        cPop3_Auth = 0;
        cDaysRej = 0;
        cDaysNoRej = 0;
        cFwdDays = 0;

        cManualBanCount = 0;
        unused2 = 0;
        unused3 = 0;
        unused4 = 0;
        crc32 = 0;
    }
};

struct TMemRecord {
    bool empty;
    TIpMem today;      //today data
    TIpMemY yesterday; //yesterday data
    TIpDisk history;   //history data

    TMemRecord() {
        Clear();
    }

    void Clear() {
        empty = true;
        today.clear();
        yesterday.clear();
        history.Clear();
    }
};

struct TMemRecordCopy {
    bool m_empty;
    TIpMemCopy today;  //today data
    TIpMemY yesterday; //yesterday data
    TIpDisk history;   //history data

    TMemRecordCopy() {
        Clear();
    }

    void Clear() {
        m_empty = true;
        today.clear();
        yesterday.clear();
        history.Clear();
    }

    bool empty() {
        return m_empty;
    }
};

struct TWeightIPLocalCacheDiff {
    ui32 white_local_cache_diff;
    ui32 white_local_cache_diff_time;
    ui32 m_count;     //���-�� ���������, ������� ���� �������� � ���
    ui32 m_ham_count; //odata.pdld.m_exportdata.m_messclass == spHam, spDeliveryInbox, spDelivery
    ui32 m_ham_mailbox_count;
    ui32 m_spam_count; //spSpam
    ui32 m_spam_mailbox_count;
    ui32 m_malic_count; //malic count
    ui32 m_malic_mailbox_count;
    ui16 m_cWeightSum;
    ui16 m_cWMess;
    ui16 m_cMcount;
    ui16 m_cPop3;
    ui16 m_cDsn;
    ui32 m_malicspam_count;

    TWeightIPLocalCacheDiff() {
        Clear();
    }

    void Clear() {
        white_local_cache_diff_time = 0;
        white_local_cache_diff = 0;
        m_count = 0;
        m_ham_count = 0;
        m_ham_mailbox_count = 0;
        m_spam_count = 0;
        m_spam_mailbox_count = 0;
        m_malic_count = 0;
        m_malic_mailbox_count = 0;
        m_cWeightSum = 0;
        m_cWMess = 0;
        m_cMcount = 0;
        m_cPop3 = 0;
        m_cDsn = 0;
        m_malicspam_count = 0;
    }

    TString toLog() {
        char tbuff[512];

        memset(tbuff, 0, sizeof(tbuff));
        snprintf(tbuff, sizeof(tbuff) - 1, "%u,%u-%u,%u-%u,%u-%u,%d-%d-%d-%d-%d,%u", m_count, m_ham_count, m_ham_mailbox_count, m_spam_count, m_spam_mailbox_count, m_malic_count, m_malic_mailbox_count, m_cWeightSum, m_cWMess, m_cMcount, m_cPop3, m_cDsn, m_malicspam_count);

        return TString(tbuff);
    }
};

enum TWIP_ACTION { WIP_UNKNOWN,
                   WIP_UPDATE_STORAGE,
                   WIP_UPDATE_DIFF };

struct TWeightIPLocalCacheItem {
    TWIP_ACTION last_action;
    ui32 lasttime;
    TWeightIPLocalCacheDiff diff;
    TMemRecordCopy memcopy;

    TWeightIPLocalCacheItem() {
        Clear();
    }

    TWeightIPLocalCacheItem(TWeightIPLocalCacheDiff& diffA) {
        Clear();
        diff = diffA;
    }

    TWeightIPLocalCacheItem(TMemRecordCopy& memcopyA) {
        Clear();
        memcopy = memcopyA;
    }

    void Clear() {
        last_action = WIP_UNKNOWN;
        lasttime = time(NULL);
        diff.Clear();
        memcopy.Clear();
    }
};

struct TWeightIPLocalCacheItemEx {
    TKIPv6 m_ip;
    TWeightIPLocalCacheItem m_value;

    TWeightIPLocalCacheItemEx() = default;

    TWeightIPLocalCacheItemEx(TKIPv6 ip, TWeightIPLocalCacheItem value) {
        m_ip = ip;
        m_value = std::move(value);
    }

    TString toLog() {
        TString res = "";

        res = res + m_ip.toStroka();
        res = res + "[" + m_value.diff.toLog() + "]";

        return res;
    }
};

typedef std::list<TWeightIPLocalCacheItemEx> TWeightIPLocalCacheItemExList;
typedef TWeightIPLocalCacheItemExList::iterator TWeightIPLocalCacheItemExListIt;

/*class TIpForwardsSerialization
{
public:
    static void Deserialize( nosql::HashMap& hash, TIpForwards& data )
    {
        AssignValue( data.summ_500, hash[ "summ_500" ].Long() );
        const TVector< char >& sbox = hash[ "sbox" ].Vector();
        VectorToStoreBox( sbox, *data.sbox );

        for( int i = 0; i < sizeof( data.box_count_mail ) / sizeof( data.box_count_mail[ 0 ] ); i++ )
        {
            char name[ 50 ];
            sprintf( name, "bcm%d", i );

            ui16 value;
            AssignValue( value, hash[ name ].Long() );
            data.box_count_mail[ i ] = kui16( value );
        }

        AssignValue( data.mail_count, hash[ "mail_count" ].Long() );
    }

    static void Serialize( const TIpForwards& data, const TIpForwards& data_prev, nosql::HashMap& incrs, nosql::HashMap& sets, bool overwrite )
    {
        SetElement( sets, "summ_500", data.summ_500, data_prev.summ_500 );
        SetElement( sets, "sbox", StoreBoxToVector( *data.sbox ), StoreBoxToVector( *data_prev.sbox ) );

        if( overwrite )
        {
            for( int i = 0; i < sizeof( data.box_count_mail ) / sizeof( data.box_count_mail[ 0 ] ); i++ )
            {
                char name[ 50 ];
                sprintf( name, "bcm%d", i );
                SetElement( sets, name, data.box_count_mail[ i ], data_prev.box_count_mail[ i ] );
            }

            SetElement( sets, "mail_count", data.mail_count, data_prev.mail_count );
        }
        else
        {
            for( int i = 0; i < sizeof( data.box_count_mail ) / sizeof( data.box_count_mail[ 0 ] ); i++ )
            {
                char name[ 50 ];
                sprintf( name, "bcm%d", i );
                IncrElement( incrs, name, data.box_count_mail[ i ], data_prev.box_count_mail[ i ] );
            }

            IncrElement( incrs, "mail_count", data.mail_count, data_prev.mail_count );
        }
    }
};*/

#define TODAY_IP "ip"
#define TODAY_LASTMES "tLastMes"
#define TODAY_FIXDAY "tFixDay"
#define TODAY_SPAM "ctSpam"
#define TODAY_HAM "ctHam"
#define TODAY_MALICSPAM "ctMalicSpam"
#define TODAY_SPAMMAIL "ctSpamMail"
#define TODAY_HAMMAIL "ctHamMail"
#define TODAY_MALICSPAMMAIL "ctMalicSpamMail"
#define TODAY_POP3 "cPop3"
#define TODAY_DSN "cDsn"
#define TODAY_REJECTED "cRejected"
#define TODAY_MCOUNT "cMcount"
#define TODAY_BMASK "bMask"
#define TODAY_WEIGHTSUM "cWeightSum"
#define TODAY_WMESS "cWMess"
#define TODAY_CPSOTC "cps_otc"
#define TODAY_CPSTALL "cps_tall"
#define TODAY_CPS "cps"
#define TODAY_MALICSPAMCOUNT "malicspam_count"
#define TODAY_BAN7COUNT "ban7count"
#define TODAY_RDNS "rdns"
#define TODAY_KOEF2 "koef2"
#define TODAY_CPS5MCOUNT "cps5mcount"
#define TODAY_CPS20MCOUNT "cps20mcount"
#define TODAY_CPS50MCOUNT "cps50mcount"
#define TODAY_CPS100MCOUNT "cps100mcount"
#define TODAY_CPSGREATMCOUNT "cpsGreatmcount"
#define TODAY_SPAMMAILBOXCOUNT "SpamMailBoxCount"
#define TODAY_GEODATA "geodata"
#define TODAY_PR_CMB "pcmb" //priznak check_mem_basa

#define TODAY_MANUALBANCOUNT "manbancnt"
#define TODAY_BANCOUNT "bancnt"
//#define TODAY_MANUALBANCOUNT     "cManualBanCount"

class TIpMemSerialization {
public:
    static void Deserialize(nosql::HashMap& hash, TIpMem& data) {
        data.ip = TKIPv6(hash[TODAY_IP].String().c_str());
        AssignValue(data.tLastMes, hash[TODAY_LASTMES].Long());
        AssignValue(data.tFixDay, hash[TODAY_FIXDAY].Long());
        AssignValue(data.ctSpam, hash[TODAY_SPAM].Long());
        AssignValue(data.ctHam, hash[TODAY_HAM].Long());
        AssignValue(data.ctMalicSpam, hash[TODAY_MALICSPAM].Long());
        AssignValue(data.ctSpamMail, hash[TODAY_SPAMMAIL].Long());
        AssignValue(data.ctHamMail, hash[TODAY_HAMMAIL].Long());
        AssignValue(data.ctMalicSpamMail, hash[TODAY_MALICSPAMMAIL].Long());
        AssignValue(data.cPop3, hash[TODAY_POP3].Long());
        AssignValue(data.cDsn, hash[TODAY_DSN].Long());
        AssignValue(data.cRejected, hash[TODAY_REJECTED].Long());
        AssignValue(data.cMcount, hash[TODAY_MCOUNT].Long());
        AssignValue(data.bMask, hash[TODAY_BMASK].Long());
        AssignValue(data.cWeightSum, hash[TODAY_WEIGHTSUM].Long());
        AssignValue(data.cWMess, hash[TODAY_WMESS].Long());
        //TIpForwardsSerialization::Deserialize( hash, data.forwards );
        for (int i = 0; i < sizeof(data.PANNERN_STAT) / sizeof(data.PANNERN_STAT[0]); i++) {
            char name[50];
            sprintf(name, "PS%d", i);
            AssignValue(data.PANNERN_STAT[i], hash[name].Long());
        }
        AssignValue(data.cps_otc, hash[TODAY_CPSOTC].Long());
        AssignValue(data.cps_tall, hash[TODAY_CPSTALL].Long());
        AssignValue(data.cps, hash[TODAY_CPS].Double());
        AssignValue(data.malicspam_count, hash[TODAY_MALICSPAMCOUNT].Long());
        AssignValue(data.ban7count, hash[TODAY_BAN7COUNT].Long());
        data.rdns = hash[TODAY_RDNS].String().c_str();

        nosql::HashMap::iterator it = hash.find(TODAY_KOEF2);
        if (it != hash.end())
            AssignValue(data.koef2, hash[TODAY_KOEF2].Double());
        else
            data.koef2 = 1;

        AssignValue(data.cps5mcount, hash[TODAY_CPS5MCOUNT].Long());
        AssignValue(data.cps20mcount, hash[TODAY_CPS20MCOUNT].Long());
        AssignValue(data.cps50mcount, hash[TODAY_CPS50MCOUNT].Long());
        AssignValue(data.cps100mcount, hash[TODAY_CPS100MCOUNT].Long());
        AssignValue(data.cpsGreatmcount, hash[TODAY_CPSGREATMCOUNT].Long());
        AssignValue(data.SpamMailBoxCount, hash[TODAY_SPAMMAILBOXCOUNT].Long());
        data.geodata = hash[TODAY_GEODATA].String().c_str();
        //AssignValue( data.ManualBanCount, hash[ TODAY_MANUALBANCOUNT ].Long() );
        AssignValue(data.pcmb, hash[TODAY_PR_CMB].Long());

        AssignValue(data.manual_ban_count, hash[TODAY_MANUALBANCOUNT].Long());
        AssignValue(data.ban_count, hash[TODAY_BANCOUNT].Long());
    }

    static void Clear(nosql::HashMap& sets, const TIpMem& data) {
        //SetElementWOCheck( sets, TODAY_IP, "" );
        SetElementWOCheck(sets, TODAY_LASTMES, 0);
        SetElementWOCheck(sets, TODAY_FIXDAY, 0);
        SetElementWOCheck(sets, TODAY_SPAM, 0);
        SetElementWOCheck(sets, TODAY_HAM, 0);
        SetElementWOCheck(sets, TODAY_MALICSPAM, 0);
        SetElementWOCheck(sets, TODAY_SPAMMAIL, 0);
        SetElementWOCheck(sets, TODAY_HAMMAIL, 0);
        SetElementWOCheck(sets, TODAY_MALICSPAMMAIL, 0);
        SetElementWOCheck(sets, TODAY_POP3, 0);
        SetElementWOCheck(sets, TODAY_DSN, 0);
        SetElementWOCheck(sets, TODAY_REJECTED, 0);
        SetElementWOCheck(sets, TODAY_MCOUNT, 0);
        SetElementWOCheck(sets, TODAY_BMASK, 0);
        SetElementWOCheck(sets, TODAY_WEIGHTSUM, 0);
        SetElementWOCheck(sets, TODAY_WMESS, 0);
        //TIpForwardsSerialization::Serialize( data.forwards, data_prev.forwards, incrs, sets, data.db_overwriteflag );
        for (int i = 0; i < sizeof(data.PANNERN_STAT) / sizeof(data.PANNERN_STAT[0]); i++) {
            char name[50];
            sprintf(name, "PS%d", i);
            SetElementWOCheck(sets, name, 0);
        }
        SetElementWOCheck(sets, TODAY_CPSOTC, 0);
        SetElementWOCheck(sets, TODAY_CPSTALL, 0);
        SetElementWOCheck(sets, TODAY_CPS, 0);
        SetElementWOCheck(sets, TODAY_MALICSPAMCOUNT, 0);
        SetElementWOCheck(sets, TODAY_BAN7COUNT, 0);
        SetElementWOCheck(sets, TODAY_RDNS, "");
        SetElementWOCheck(sets, TODAY_KOEF2, 1);
        SetElementWOCheck(sets, TODAY_CPS5MCOUNT, 0);
        SetElementWOCheck(sets, TODAY_CPS20MCOUNT, 0);
        SetElementWOCheck(sets, TODAY_CPS50MCOUNT, 0);
        SetElementWOCheck(sets, TODAY_CPS100MCOUNT, 0);
        SetElementWOCheck(sets, TODAY_CPSGREATMCOUNT, 0);
        SetElementWOCheck(sets, TODAY_SPAMMAILBOXCOUNT, 0);
        SetElementWOCheck(sets, TODAY_GEODATA, "");
        //SetElementWOCheck( sets, TODAY_MANUALBANCOUNT, data.ManualBanCount, data_prev.ManualBanCount );
        SetElementWOCheck(sets, TODAY_PR_CMB, 0);

        SetElementWOCheck(sets, TODAY_MANUALBANCOUNT, 0);
        SetElementWOCheck(sets, TODAY_BANCOUNT, 0);
    }

    static void Serialize(const TIpMem& data, const TIpMem& data_prev, nosql::HashMap& incrs, nosql::HashMap& sets) {
        if (data.db_overwriteflag) {
            SetElement(sets, TODAY_IP, data.ip.toStroka(), data_prev.ip.toStroka());
            SetElement(sets, TODAY_LASTMES, static_cast<i64>(data.tLastMes), static_cast<i64>(data_prev.tLastMes));
            SetElement(sets, TODAY_FIXDAY, static_cast<i64>(data.tFixDay), static_cast<i64>(data_prev.tFixDay));
            SetElement(sets, TODAY_SPAM, data.ctSpam, data_prev.ctSpam);
            SetElement(sets, TODAY_HAM, data.ctHam, data_prev.ctHam);
            SetElement(sets, TODAY_MALICSPAM, data.ctMalicSpam, data_prev.ctMalicSpam);
            SetElement(sets, TODAY_SPAMMAIL, data.ctSpamMail, data_prev.ctSpamMail);
            SetElement(sets, TODAY_HAMMAIL, data.ctHamMail, data_prev.ctHamMail);
            SetElement(sets, TODAY_MALICSPAMMAIL, data.ctMalicSpamMail, data_prev.ctMalicSpamMail);
            SetElement(sets, TODAY_POP3, data.cPop3, data_prev.cPop3);
            SetElement(sets, TODAY_DSN, data.cDsn, data_prev.cDsn);
            SetElement(sets, TODAY_REJECTED, data.cRejected, data_prev.cRejected);
            SetElement(sets, TODAY_MCOUNT, data.cMcount, data_prev.cMcount);
            SetElement(sets, TODAY_BMASK, data.bMask, data_prev.bMask);
            SetElement(sets, TODAY_WEIGHTSUM, data.cWeightSum, data_prev.cWeightSum);
            SetElement(sets, TODAY_WMESS, data.cWMess, data_prev.cWMess);
            //TIpForwardsSerialization::Serialize( data.forwards, data_prev.forwards, incrs, sets, data.db_overwriteflag );
            for (int i = 0; i < sizeof(data.PANNERN_STAT) / sizeof(data.PANNERN_STAT[0]); i++) {
                char name[50];
                sprintf(name, "PS%d", i);
                SetElement(sets, name, data.PANNERN_STAT[i], data_prev.PANNERN_STAT[i]);
            }
            SetElement(sets, TODAY_CPSOTC, static_cast<i64>(data.cps_otc), static_cast<i64>(data_prev.cps_otc));
            SetElement(sets, TODAY_CPSTALL, data.cps_tall, data_prev.cps_tall);
            SetElement(sets, TODAY_CPS, data.cps, data_prev.cps);
            SetElement(sets, TODAY_MALICSPAMCOUNT, data.malicspam_count, data_prev.malicspam_count);
            SetElement(sets, TODAY_BAN7COUNT, data.ban7count, data_prev.ban7count);
            SetElement(sets, TODAY_RDNS, data.rdns, data_prev.rdns);
            SetElement(sets, TODAY_KOEF2, data.koef2, data_prev.koef2);
            SetElement(sets, TODAY_CPS5MCOUNT, data.cps5mcount, data_prev.cps5mcount);
            SetElement(sets, TODAY_CPS20MCOUNT, data.cps20mcount, data_prev.cps20mcount);
            SetElement(sets, TODAY_CPS50MCOUNT, data.cps50mcount, data_prev.cps50mcount);
            SetElement(sets, TODAY_CPS100MCOUNT, data.cps100mcount, data_prev.cps100mcount);
            SetElement(sets, TODAY_CPSGREATMCOUNT, data.cpsGreatmcount, data_prev.cpsGreatmcount);
            SetElement(sets, TODAY_SPAMMAILBOXCOUNT, data.SpamMailBoxCount, data_prev.SpamMailBoxCount);
            SetElement(sets, TODAY_GEODATA, data.geodata, data_prev.geodata);
            //SetElement( sets, TODAY_MANUALBANCOUNT, data.ManualBanCount, data_prev.ManualBanCount );
            SetElement(sets, TODAY_PR_CMB, data.pcmb, data_prev.pcmb);

            SetElement(sets, TODAY_MANUALBANCOUNT, data.manual_ban_count, data_prev.manual_ban_count);
            SetElement(sets, TODAY_BANCOUNT, data.ban_count, data_prev.ban_count);
        } else {
            SetElement(sets, TODAY_IP, data.ip.toStroka(), data_prev.ip.toStroka());
            SetElement(sets, TODAY_LASTMES, static_cast<i64>(data.tLastMes), static_cast<i64>(data_prev.tLastMes));
            SetElement(sets, TODAY_FIXDAY, static_cast<i64>(data.tFixDay), static_cast<i64>(data_prev.tFixDay));
            IncrElement(incrs, TODAY_SPAM, data.ctSpam, data_prev.ctSpam);
            IncrElement(incrs, TODAY_HAM, data.ctHam, data_prev.ctHam);
            IncrElement(incrs, TODAY_MALICSPAM, data.ctMalicSpam, data_prev.ctMalicSpam);
            IncrElement(incrs, TODAY_SPAMMAIL, data.ctSpamMail, data_prev.ctSpamMail);
            IncrElement(incrs, TODAY_HAMMAIL, data.ctHamMail, data_prev.ctHamMail);
            IncrElement(incrs, TODAY_MALICSPAMMAIL, data.ctMalicSpamMail, data_prev.ctMalicSpamMail);
            IncrElement(incrs, TODAY_POP3, data.cPop3, data_prev.cPop3);
            IncrElement(incrs, TODAY_DSN, data.cDsn, data_prev.cDsn);
            IncrElement(incrs, TODAY_REJECTED, data.cRejected, data_prev.cRejected);
            IncrElement(incrs, TODAY_MCOUNT, data.cMcount, data_prev.cMcount);
            SetElement(sets, TODAY_BMASK, data.bMask, data_prev.bMask);
            IncrElement(incrs, TODAY_WEIGHTSUM, data.cWeightSum, data_prev.cWeightSum);
            IncrElement(incrs, TODAY_WMESS, data.cWMess, data_prev.cWMess);
            //TIpForwardsSerialization::Serialize( data.forwards, data_prev.forwards, incrs, sets, data.db_overwriteflag );
            for (int i = 0; i < sizeof(data.PANNERN_STAT) / sizeof(data.PANNERN_STAT[0]); i++) {
                char name[50];
                sprintf(name, "PS%d", i);
                IncrElement(incrs, name, data.PANNERN_STAT[i], data_prev.PANNERN_STAT[i]);
            }
            SetElement(sets, TODAY_CPSOTC, static_cast<i64>(data.cps_otc), static_cast<i64>(data_prev.cps_otc));
            SetElement(sets, TODAY_CPSTALL, data.cps_tall, data_prev.cps_tall);
            SetElement(sets, TODAY_CPS, data.cps, data_prev.cps);
            IncrElement(incrs, TODAY_MALICSPAMCOUNT, data.malicspam_count, data_prev.malicspam_count);
            IncrElement(incrs, TODAY_BAN7COUNT, data.ban7count, data_prev.ban7count);
            SetElement(sets, TODAY_RDNS, data.rdns, data_prev.rdns);
            SetElement(sets, TODAY_KOEF2, data.koef2, data_prev.koef2);
            IncrElement(incrs, TODAY_CPS5MCOUNT, data.cps5mcount, data_prev.cps5mcount);
            IncrElement(incrs, TODAY_CPS20MCOUNT, data.cps20mcount, data_prev.cps20mcount);
            IncrElement(incrs, TODAY_CPS50MCOUNT, data.cps50mcount, data_prev.cps50mcount);
            IncrElement(incrs, TODAY_CPS100MCOUNT, data.cps100mcount, data_prev.cps100mcount);
            IncrElement(incrs, TODAY_CPSGREATMCOUNT, data.cpsGreatmcount, data_prev.cpsGreatmcount);
            IncrElement(incrs, TODAY_SPAMMAILBOXCOUNT, data.SpamMailBoxCount, data_prev.SpamMailBoxCount);
            SetElement(sets, TODAY_GEODATA, data.geodata, data_prev.geodata);
            //IncrElement( incrs, TODAY_MANUALBANCOUNT, data.ManualBanCount, data_prev.ManualBanCount );
            SetElement(sets, TODAY_PR_CMB, data.pcmb, data_prev.pcmb);

            SetElement(sets, TODAY_MANUALBANCOUNT, data.manual_ban_count, data_prev.manual_ban_count);
            SetElement(sets, TODAY_BANCOUNT, data.ban_count, data_prev.ban_count);
        }
    }

    static void SerializeWOCheck(const TIpMem& data, nosql::HashMap& sets) {
        SetElementWOCheck(sets, TODAY_IP, data.ip.toStroka());
        SetElementWOCheck(sets, TODAY_LASTMES, static_cast<i64>(data.tLastMes));
        SetElementWOCheck(sets, TODAY_FIXDAY, static_cast<i64>(data.tFixDay));
        SetElementWOCheck(sets, TODAY_SPAM, data.ctSpam);
        SetElementWOCheck(sets, TODAY_HAM, data.ctHam);
        SetElementWOCheck(sets, TODAY_MALICSPAM, data.ctMalicSpam);
        SetElementWOCheck(sets, TODAY_SPAMMAIL, data.ctSpamMail);
        SetElementWOCheck(sets, TODAY_HAMMAIL, data.ctHamMail);
        SetElementWOCheck(sets, TODAY_MALICSPAMMAIL, data.ctMalicSpamMail);
        SetElementWOCheck(sets, TODAY_POP3, data.cPop3);
        SetElementWOCheck(sets, TODAY_DSN, data.cDsn);
        SetElementWOCheck(sets, TODAY_REJECTED, data.cRejected);
        SetElementWOCheck(sets, TODAY_MCOUNT, data.cMcount);
        SetElementWOCheck(sets, TODAY_BMASK, data.bMask);
        SetElementWOCheck(sets, TODAY_WEIGHTSUM, data.cWeightSum);
        SetElementWOCheck(sets, TODAY_WMESS, data.cWMess);
        //TIpForwardsSerialization::Serialize( data.forwards, data_prev.forwards, incrs, sets, data.db_overwriteflag );
        for (int i = 0; i < sizeof(data.PANNERN_STAT) / sizeof(data.PANNERN_STAT[0]); i++) {
            char name[50];
            sprintf(name, "PS%d", i);
            SetElementWOCheck(sets, name, data.PANNERN_STAT[i]);
        }
        SetElementWOCheck(sets, TODAY_CPSOTC, static_cast<i64>(data.cps_otc));
        SetElementWOCheck(sets, TODAY_CPSTALL, data.cps_tall);
        SetElementWOCheck(sets, TODAY_CPS, data.cps);
        SetElementWOCheck(sets, TODAY_MALICSPAMCOUNT, data.malicspam_count);
        SetElementWOCheck(sets, TODAY_BAN7COUNT, data.ban7count);
        SetElementWOCheck(sets, TODAY_RDNS, data.rdns);
        SetElementWOCheck(sets, TODAY_KOEF2, data.koef2);
        SetElementWOCheck(sets, TODAY_CPS5MCOUNT, data.cps5mcount);
        SetElementWOCheck(sets, TODAY_CPS20MCOUNT, data.cps20mcount);
        SetElementWOCheck(sets, TODAY_CPS50MCOUNT, data.cps50mcount);
        SetElementWOCheck(sets, TODAY_CPS100MCOUNT, data.cps100mcount);
        SetElementWOCheck(sets, TODAY_CPSGREATMCOUNT, data.cpsGreatmcount);
        SetElementWOCheck(sets, TODAY_SPAMMAILBOXCOUNT, data.SpamMailBoxCount);
        SetElementWOCheck(sets, TODAY_GEODATA, data.geodata);
        //SetElementWOCheck( sets, TODAY_MANUALBANCOUNT, data.ManualBanCount);
        SetElementWOCheck(sets, TODAY_PR_CMB, data.pcmb);

        SetElementWOCheck(sets, TODAY_MANUALBANCOUNT, data.manual_ban_count);
        SetElementWOCheck(sets, TODAY_BANCOUNT, data.ban_count);
    }
};

#define HISTORY_FIRSTDEAL "htFirstDeal"
#define HISTORY_LASTMES "htLastMes"
#define HISTORY_SPAM "hctSpam"
#define HISTORY_HAM "hctHam"
#define HISTORY_MALICSPAM "hctMalicSpam"
#define HISTORY_DSN "hcDsn"
#define HISTORY_POP3AUTH "hcPop3_Auth"
#define HISTORY_DAYSREJ "hcDaysRej"
#define HISTORY_DAYSNOREJ "hcDaysNoRej"
#define HISTORY_FWDDAYS "hcFwdDays"
#define HISTORY_MANUALBANCOUNT "hManualBanCount"
#define HISTORY_CRC32 "hcrc32"

class TIpDiskSerialization {
public:
    static void Deserialize(nosql::HashMap& hash, TIpDisk& data) {
        AssignValue(data.tFirstDeal, hash[HISTORY_FIRSTDEAL].Long());
        AssignValue(data.tLastMes, hash[HISTORY_LASTMES].Long());
        AssignValue(data.ctSpam, hash[HISTORY_SPAM].Long());
        AssignValue(data.ctHam, hash[HISTORY_HAM].Long());
        AssignValue(data.ctMalicSpam, hash[HISTORY_MALICSPAM].Long());
        AssignValue(data.cDsn, hash[HISTORY_DSN].Long());
        AssignValue(data.cPop3_Auth, hash[HISTORY_POP3AUTH].Long());
        AssignValue(data.cDaysRej, hash[HISTORY_DAYSREJ].Long());
        AssignValue(data.cDaysNoRej, hash[HISTORY_DAYSNOREJ].Long());
        AssignValue(data.cFwdDays, hash[HISTORY_FWDDAYS].Long());
        AssignValue(data.cManualBanCount, hash[HISTORY_MANUALBANCOUNT].Long());
        AssignValue(data.crc32, hash[HISTORY_CRC32].Long());
    }

    static void Serialize(const TIpDisk& data, const TIpDisk& data_prev, nosql::HashMap& incrs, nosql::HashMap& sets) {
        SetElement(sets, HISTORY_FIRSTDEAL, static_cast<i64>(data.tFirstDeal), static_cast<i64>(data_prev.tFirstDeal));
        SetElement(sets, HISTORY_LASTMES, static_cast<i64>(data.tLastMes), static_cast<i64>(data_prev.tLastMes));
        IncrElement(incrs, HISTORY_SPAM, data.ctSpam, data_prev.ctSpam);
        IncrElement(incrs, HISTORY_HAM, data.ctHam, data_prev.ctHam);
        IncrElement(incrs, HISTORY_MALICSPAM, data.ctMalicSpam, data_prev.ctMalicSpam);
        IncrElement(incrs, HISTORY_DSN, data.cDsn, data_prev.cDsn);
        IncrElement(incrs, HISTORY_POP3AUTH, data.cPop3_Auth, data_prev.cPop3_Auth);
        IncrElement(incrs, HISTORY_DAYSREJ, data.cDaysRej, data_prev.cDaysRej);
        IncrElement(incrs, HISTORY_DAYSNOREJ, data.cDaysNoRej, data_prev.cDaysNoRej);
        IncrElement(incrs, HISTORY_FWDDAYS, data.cFwdDays, data_prev.cFwdDays);
        IncrElement(incrs, HISTORY_MANUALBANCOUNT, data.cManualBanCount, data_prev.cManualBanCount);
        IncrElement(incrs, HISTORY_CRC32, data.crc32, data_prev.crc32);
    }

    static void SetSerializeWOCheck(const TIpDisk& data, nosql::HashMap& sets) {
        SetElementWOCheck(sets, HISTORY_FIRSTDEAL, static_cast<i64>(data.tFirstDeal));
        SetElementWOCheck(sets, HISTORY_LASTMES, static_cast<i64>(data.tLastMes));
        SetElementWOCheck(sets, HISTORY_SPAM, data.ctSpam);
        SetElementWOCheck(sets, HISTORY_HAM, data.ctHam);
        SetElementWOCheck(sets, HISTORY_MALICSPAM, data.ctMalicSpam);
        SetElementWOCheck(sets, HISTORY_DSN, data.cDsn);
        SetElementWOCheck(sets, HISTORY_POP3AUTH, data.cPop3_Auth);
        SetElementWOCheck(sets, HISTORY_DAYSREJ, data.cDaysRej);
        SetElementWOCheck(sets, HISTORY_DAYSNOREJ, data.cDaysNoRej);
        SetElementWOCheck(sets, HISTORY_FWDDAYS, data.cFwdDays);
        SetElementWOCheck(sets, HISTORY_MANUALBANCOUNT, data.cManualBanCount);
        SetElementWOCheck(sets, HISTORY_CRC32, data.crc32);
    }
};

#define YESTERDAY_POP3 "ycPop3"
#define YESTERDAY_MCOUNT "ycMcount"
#define YESTERDAY_SPAM "yctSpam"
#define YESTERDAY_DSN "ycDsn"
#define YESTERDAY_BMASK "ybMask"
#define YESTERDAY_REJECTED "ycRejected"
#define YESTERDAY_MALICSPAM "yctMalicSpam"
#define YESTERDAY_HAM "yctHam"
#define YESTERDAY_SPAMMAIL "yctSpamMail"
#define YESTERDAY_HAMMAIL "yctHamMail"
#define YESTERDAY_MALICSPAMMAIL "yctMalicSpamMail"
#define YESTERDAY_WEIGHTSUM "ycWeightSum"
#define YESTERDAY_WMESS "ycWMess"

class TIpMemYSerialization {
public:
    static void Deserialize(nosql::HashMap& hash, TIpMemY& data) {
        AssignValue(data.cPop3, hash[YESTERDAY_POP3].Long());
        AssignValue(data.cMcount, hash[YESTERDAY_MCOUNT].Long());
        AssignValue(data.ctSpam, hash[YESTERDAY_SPAM].Long());
        AssignValue(data.cDsn, hash[YESTERDAY_DSN].Long());
        AssignValue(data.bMask, hash[YESTERDAY_BMASK].Long());
        AssignValue(data.cRejected, hash[YESTERDAY_REJECTED].Long());
        AssignValue(data.ctMalicSpam, hash[YESTERDAY_MALICSPAM].Long());
        AssignValue(data.ctHam, hash[YESTERDAY_HAM].Long());
        AssignValue(data.ctSpamMail, hash[YESTERDAY_SPAMMAIL].Long());
        AssignValue(data.ctHamMail, hash[YESTERDAY_HAMMAIL].Long());
        AssignValue(data.ctMalicSpamMail, hash[YESTERDAY_MALICSPAMMAIL].Long());
        AssignValue(data.cWeightSum, hash[YESTERDAY_WEIGHTSUM].Long());
        AssignValue(data.cWMess, hash[YESTERDAY_WMESS].Long());
        //AssignValue( data.cManualBanCount, hash[ "yManualBanCount" ].Long() );
    }

    static void Clear(nosql::HashMap& sets) {
        SetElementWOCheck(sets, YESTERDAY_POP3, 0);
        SetElementWOCheck(sets, YESTERDAY_MCOUNT, 0);
        SetElementWOCheck(sets, YESTERDAY_SPAM, 0);
        SetElementWOCheck(sets, YESTERDAY_DSN, 0);
        SetElementWOCheck(sets, YESTERDAY_BMASK, 0);
        SetElementWOCheck(sets, YESTERDAY_REJECTED, 0);
        SetElementWOCheck(sets, YESTERDAY_MALICSPAM, 0);
        SetElementWOCheck(sets, YESTERDAY_HAM, 0);
        SetElementWOCheck(sets, YESTERDAY_SPAMMAIL, 0);
        SetElementWOCheck(sets, YESTERDAY_HAMMAIL, 0);
        SetElementWOCheck(sets, YESTERDAY_MALICSPAMMAIL, 0);
        SetElementWOCheck(sets, YESTERDAY_WEIGHTSUM, 0);
        SetElementWOCheck(sets, YESTERDAY_WMESS, 0);
        //SetElementWOCheck( sets, "yManualBanCount", 0 );
    }

    static void Serialize(const TIpMemY& data, const TIpMemY& data_prev, nosql::HashMap& incrs, nosql::HashMap& sets) {
        SetElement(sets, YESTERDAY_POP3, data.cPop3, data_prev.cPop3);
        SetElement(sets, YESTERDAY_MCOUNT, data.cMcount, data_prev.cMcount);
        SetElement(sets, YESTERDAY_SPAM, data.ctSpam, data_prev.ctSpam);
        SetElement(sets, YESTERDAY_DSN, data.cDsn, data_prev.cDsn);
        SetElement(sets, YESTERDAY_BMASK, data.bMask, data_prev.bMask);
        SetElement(sets, YESTERDAY_REJECTED, data.cRejected, data_prev.cRejected);
        SetElement(sets, YESTERDAY_MALICSPAM, data.ctMalicSpam, data_prev.ctMalicSpam);
        SetElement(sets, YESTERDAY_HAM, data.ctHam, data_prev.ctHam);
        SetElement(sets, YESTERDAY_SPAMMAIL, data.ctSpamMail, data_prev.ctSpamMail);
        SetElement(sets, YESTERDAY_HAMMAIL, data.ctHamMail, data_prev.ctHamMail);
        SetElement(sets, YESTERDAY_MALICSPAMMAIL, data.ctMalicSpamMail, data_prev.ctMalicSpamMail);
        SetElement(sets, YESTERDAY_WEIGHTSUM, data.cWeightSum, data_prev.cWeightSum);
        SetElement(sets, YESTERDAY_WMESS, data.cWMess, data_prev.cWMess);
        //SetElement( sets, "yManualBanCount", data.cManualBanCount, data_prev.cManualBanCount );
    }

    static void SerializeWOCheck(const TIpMemY& data, nosql::HashMap& sets) {
        SetElementWOCheck(sets, YESTERDAY_POP3, data.cPop3);
        SetElementWOCheck(sets, YESTERDAY_MCOUNT, data.cMcount);
        SetElementWOCheck(sets, YESTERDAY_SPAM, data.ctSpam);
        SetElementWOCheck(sets, YESTERDAY_DSN, data.cDsn);
        SetElementWOCheck(sets, YESTERDAY_BMASK, data.bMask);
        SetElementWOCheck(sets, YESTERDAY_REJECTED, data.cRejected);
        SetElementWOCheck(sets, YESTERDAY_MALICSPAM, data.ctMalicSpam);
        SetElementWOCheck(sets, YESTERDAY_HAM, data.ctHam);
        SetElementWOCheck(sets, YESTERDAY_SPAMMAIL, data.ctSpamMail);
        SetElementWOCheck(sets, YESTERDAY_HAMMAIL, data.ctHamMail);
        SetElementWOCheck(sets, YESTERDAY_MALICSPAMMAIL, data.ctMalicSpamMail);
        SetElementWOCheck(sets, YESTERDAY_WEIGHTSUM, data.cWeightSum);
        SetElementWOCheck(sets, YESTERDAY_WMESS, data.cWMess);
        //SetElementWOCheck( sets, "yManualBanCount", data.cManualBanCount);
    }
};

class TMemRecordSerialization {
public:
    static void Deserialize(nosql::HashMap& hash, TMemRecord& data) {
        TIpMemYSerialization::Deserialize(hash, data.yesterday);
        TIpMemSerialization::Deserialize(hash, data.today);
        TIpDiskSerialization::Deserialize(hash, data.history);
    }

    static void Serialize(const TMemRecord& data, const TMemRecord& data_prev, nosql::HashMap& incrs, nosql::HashMap& sets) {
        TIpMemYSerialization::Serialize(data.yesterday, data_prev.yesterday, incrs, sets);
        TIpMemSerialization::Serialize(data.today, data_prev.today, incrs, sets);
        TIpDiskSerialization::Serialize(data.history, data_prev.history, incrs, sets);
    }

    static void SerializeWOCheck(const TMemRecord& data, nosql::HashMap& sets) {
        TIpMemYSerialization::SerializeWOCheck(data.yesterday, sets);
        TIpMemSerialization::SerializeWOCheck(data.today, sets);
        TIpDiskSerialization::SetSerializeWOCheck(data.history, sets);
    }

    static TString ConvertToId(const TKIPv6& ip) {
        return ip.AsShingle128();
    }

    static ui64 ConvertToId2(const TKIPv6& ip) {
        return ip.AsShingle64();
    }
};

struct TIpStatOne {
    //today
    bool notfound;
    ui32 Ham;               //dlv or ham
    ui32 Spam;              //� ��� ����� � malicious
    ui32 MalicSpam;         //malicious spam
    ui32 HamMail;           //dlv or ham
    ui32 SpamMail;          //� ��� ����� � malicious
    ui32 MalicSpamMail;     //malicious spam
    ui16 Pop3;              //���-�� ����� c�������� �� POP3
    ui16 Dsn;               //���-�� ����� DSN
    ui16 Rejected;          //���������� ����� �������� ����� ���� = pbanip->cMessage
    ui16 Mcount;            //c���� ���� MCOUNT = m_Uwl
    ui32 bMask;             //bit mask (forwards, ...)
    time_t tLastMes;        //���� ��������� �������� ip � ����
    TString frwds;          //���������� ���������
    time_t tFixDay;         //���� �������� �����
    TString rdns;           //rdns
    ui32 malicspamer_count; //���-�� ����� � MALICIOUS_SPAMER
    float cps;              //mail per second
    ui32 ban7count;         //���-�� �����, ��������� �� �������� ban7
    float prSpamMailBox;    //������� ������, ���������� ���� �� ���� �������� ������
    TString geo;            //���������
    ui32 manual_ban_count;
    ui32 ban_count;
    //ui32        ManualBanCount;
    //yesterday
    ui32 yctSpam;          //� ��� ����� � malicious
    ui32 yctHam;           //dlv or ham
    ui32 yctMalicSpam;     //malicious spam //??? - ��� ����������?
    ui32 yctSpamMail;      //� ��� ����� � malicious
    ui32 yctHamMail;       //dlv or ham
    ui32 yctMalicSpamMail; //malicious spam //??? - ��� ����������?
    ui16 ycPop3;           //���-�� ����� c�������� �� POP3
    ui16 ycDsn;            //���-�� ����� DSN
    ui16 ycRejected;       //���������� ����� �������� ����� ���� = pbanip->cMessage
    ui16 ycMcount;         //c���� ���� MCOUNT = m_Uwl
    ui32 ybMask;           //bit mask ??
    ui16 ycWeightSum;      //total messages weight for day (w/o DSN)++
    ui16 ycWMess;
    //ui32        yManualBanCount;
    //history
    time_t htFirstDeal; //���� ��������� ip � ���� ++
    time_t htLastMes;   //���� ��������� �������� ip � ���� ++
    ui32 hctSpam;       //� ��� ����� � malicious
    ui32 hctHam;        //dlv or ham
    ui32 hctMalicSpam;
    ui16 hcDsn;
    ui16 hPop3_Auth;      //������� ���� ������� ������� POP3_AUTH
    ui16 hDaysRej;        //������� ���� ���������
    ui16 hDaysNoRej;      //������� ���� ��������� ��� ���������
    ui16 hFwdDays;        //������� ���� ���������� ��� �������
    ui32 hManualBanCount; //����, � ������� ������� �����������

    TIpStatOne() {
        notfound = true;
        Ham = 0;
        Spam = 0;
        MalicSpam = 0;
        Pop3 = 0;
        Dsn = 0;
        Rejected = 0;
        Mcount = 0;
        bMask = 0;
        tLastMes = 0;
        frwds = "";
        tFixDay = 0;
        rdns = "";
        malicspamer_count = 0;
        cps = 0;
        ban7count = 0;
        prSpamMailBox = 0;
        geo = "";
        manual_ban_count = 0;
        ban_count = 0;
        //ManualBanCount    = 0;

        yctSpam = 0;
        yctHam = 0;
        yctMalicSpam = 0;
        ycPop3 = 0;
        ycDsn = 0;
        ycRejected = 0;
        ycMcount = 0;
        ybMask = 0;
        ycWeightSum = 0;
        ycWMess = 0;
        //yManualBanCount    = 0;

        htFirstDeal = 0;
        htLastMes = 0;
        hctSpam = 0;
        hctHam = 0;
        hctMalicSpam = 0;
        hcDsn = 0;
        hPop3_Auth = 0;
        hDaysRej = 0;
        hDaysNoRej = 0;
        hFwdDays = 0;
        hManualBanCount = 0;
    }
};

struct TIpStat {
    ui32 ctSpam_today;      //� ��� ����� � malicious
    ui32 ctHam_today;       //dlv or ham
    ui32 ctMalicSpam_today; //malicious spam
    ui32 ctSpam;            //� ��� ����� � malicious
    ui32 ctHam;             //dlv or ham
    ui32 ctMalicSpam;       //malicious spam
    TString rdns;           //host
    TString rdns2;          //host
    TString rdns3;          //host
    time_t last_update;     //time last updata
    time_t last_fix;        //fix time
    float cps;              //mail to sec
    bool forwards;          //�������
    bool frwd_pr1;          //������� ������ ��������
    int white_pr;           //1 - ��������� � "����� ������", 2 - �� ���������
    ui32 pcmb;              //priznak check_mem_basa

    TIpStat() {
        Clear();
    }

    void Clear() {
        ctSpam_today = 0;
        ctHam_today = 0;
        ctMalicSpam_today = 0;
        ctSpam = 0;
        ctHam = 0;
        ctMalicSpam = 0;
        rdns.assign("");
        rdns2.assign("");
        rdns3.assign("");
        last_update = 0;
        last_fix = 0;
        cps = 0;
        forwards = 0;
        frwd_pr1 = false;
        white_pr = 0;
        pcmb = 0;
    }
};

class TIpStatEx {
public:
    ui32 ctSpam_today;      //� ��� ����� � malicious
    ui32 ctHam_today;       //dlv or ham
    ui32 ctMalicSpam_today; //malicious spam
    ui32 ctSpam;            //� ��� ����� � malicious
    ui32 ctHam;             //dlv or ham
    ui32 ctMalicSpam;       //malicious spam
    TString rdns_isx;
    TString rdns;
    TKIPv6 ip;
    ui8 sorttype;
    time_t last_update;
    time_t last_fix;
    TString reverse_rdns;
    float cps;
    bool frwd_pr1;
    int white_pr;
    ui32 pcmb;

public:
    TIpStatEx(const TKIPv6& ipA, TIpStat data, ui8 sorttypeA) {
        Clear();
        ctSpam_today = data.ctSpam_today;
        ctHam_today = data.ctHam_today;
        ctMalicSpam_today = data.ctMalicSpam_today;
        ctSpam = data.ctSpam;
        ctHam = data.ctHam;
        ctMalicSpam = data.ctMalicSpam;
        ip = ipA;
        sorttype = sorttypeA;
        last_update = data.last_update;
        last_fix = data.last_fix;
        if ((!data.rdns3.empty()) && (data.rdns3 != "-"))
            reverse_rdns = data.rdns3;
        else
            reverse_rdns = data.rdns2;
        rdns_isx = data.rdns;
        rdns = reverse_rdns;
        ReverseInPlace(reverse_rdns);

        cps = data.cps;
        frwd_pr1 = data.frwd_pr1;
        white_pr = data.white_pr;
        pcmb = data.pcmb;
    }
    ~TIpStatEx(){};

    void Clear() {
        ctSpam_today = 0;
        ctHam_today = 0;
        ctMalicSpam_today = 0;
        ctSpam = 0;
        ctHam = 0;
        ctMalicSpam = 0;
        rdns_isx = "";
        rdns = "";
        ip = TKIPv6();
        sorttype = 0;
        last_update = 0;
        last_fix = 0;
        reverse_rdns = "";
        cps = 0;
        frwd_pr1 = false;
        white_pr = 0;
        pcmb = 0;
    }

    bool operator<(const TIpStatEx& value) const {
        bool res = false;

        switch (sorttype) {
            case 0:
                res = ctSpam < value.ctSpam;
                break;
            case 1:
                res = ctHam < value.ctHam;
                break;
            case 2:
                res = ctMalicSpam < value.ctMalicSpam;
                break;
            case 3:
                res = (ctSpam + ctHam) < (value.ctSpam + value.ctHam);
                break;
            case 4:
                res = reverse_rdns < value.reverse_rdns;
                break;
            case 5:
                res = cps < value.cps;
                break;
            case 6:
                res = ip.toStroka() > value.ip.toStroka();
                break;
            default:
                res = ctSpam < value.ctSpam;
        };
        return res;
    }
};

#define HEVYSTAT_CTSPAMTODAY "ctSpam_today"
#define HEVYSTAT_CTHAMTODAY "ctHam_today"
#define HEVYSTAT_CTMALICSPAMTODAY "ctMalicSpam_today"
#define HEVYSTAT_CTSPAM "ctSpam"
#define HEVYSTAT_CTHAM "ctHam"
#define HEVYSTAT_CTMALICSPAM "ctMalicSpam"
#define HEVYSTAT_RDNS "rdns"
#define HEVYSTAT_RDNS2 "rdns2"
#define HEVYSTAT_RDNS3 "rdns3"
#define HEVYSTAT_LASTUPDATE "last_update"
#define HEVYSTAT_LASTFIX "last_fix"
#define HEVYSTAT_CPS "cps"
#define HEVYSTAT_FORWARDS "forwards"
#define HEVYSTAT_FRWDPR1 "frwd_pr1"
#define HEVYSTAT_WHITEPR "white_pr"
#define HEVYSTAT_PCMB "hpcmb"

class TIpStatSerialization {
public:
    static void Deserialize(nosql::HashMap& hash, TIpStat& data) {
        AssignValue(data.ctSpam_today, hash[HEVYSTAT_CTSPAMTODAY].Long());
        AssignValue(data.ctHam_today, hash[HEVYSTAT_CTHAMTODAY].Long());
        AssignValue(data.ctMalicSpam_today, hash[HEVYSTAT_CTMALICSPAMTODAY].Long());
        AssignValue(data.ctSpam, hash[HEVYSTAT_CTSPAM].Long());
        AssignValue(data.ctHam, hash[HEVYSTAT_CTHAM].Long());
        AssignValue(data.ctMalicSpam, hash[HEVYSTAT_CTMALICSPAM].Long());
        data.rdns = hash[HEVYSTAT_RDNS].String().c_str();
        data.rdns2 = hash[HEVYSTAT_RDNS2].String().c_str();
        data.rdns3 = hash[HEVYSTAT_RDNS3].String().c_str();
        AssignValue(data.last_update, hash[HEVYSTAT_LASTUPDATE].Long());
        AssignValue(data.last_fix, hash[HEVYSTAT_LASTFIX].Long());
        AssignValue(data.cps, hash[HEVYSTAT_CPS].Double());
        AssignValue(data.forwards, hash[HEVYSTAT_FORWARDS].Long());
        AssignValue(data.frwd_pr1, hash[HEVYSTAT_FRWDPR1].Long());
        AssignValue(data.white_pr, hash[HEVYSTAT_WHITEPR].Long());
        AssignValue(data.pcmb, hash[HEVYSTAT_PCMB].Long());
    }

    static void Serialize(const TIpStat& data, const TIpStat& data_prev, nosql::HashMap& incrs, nosql::HashMap& sets) {
        SetElement(sets, HEVYSTAT_CTSPAMTODAY, data.ctSpam_today, data_prev.ctSpam_today);
        SetElement(sets, HEVYSTAT_CTHAMTODAY, data.ctHam_today, data_prev.ctHam_today);
        SetElement(sets, HEVYSTAT_CTMALICSPAMTODAY, data.ctMalicSpam_today, data_prev.ctMalicSpam_today);
        SetElement(sets, HEVYSTAT_CTSPAM, data.ctSpam, data_prev.ctSpam);
        SetElement(sets, HEVYSTAT_CTHAM, data.ctHam, data_prev.ctHam);
        SetElement(sets, HEVYSTAT_CTMALICSPAM, data.ctMalicSpam, data_prev.ctMalicSpam);
        SetElement(sets, HEVYSTAT_RDNS, data.rdns, data_prev.rdns);
        SetElement(sets, HEVYSTAT_RDNS2, data.rdns2, data_prev.rdns2);
        SetElement(sets, HEVYSTAT_RDNS3, data.rdns3, data_prev.rdns3);
        SetElement(sets, HEVYSTAT_LASTUPDATE, static_cast<i64>(data.last_update), static_cast<i64>(data_prev.last_update));
        SetElement(sets, HEVYSTAT_LASTFIX, static_cast<i64>(data.last_fix), static_cast<i64>(data_prev.last_fix));
        SetElement(sets, HEVYSTAT_CPS, data.cps, data_prev.cps);
        SetElement(sets, HEVYSTAT_FORWARDS, data.forwards, data_prev.forwards);
        SetElement(sets, HEVYSTAT_FRWDPR1, data.frwd_pr1, data_prev.frwd_pr1);
        SetElement(sets, HEVYSTAT_WHITEPR, data.white_pr, data_prev.white_pr);
        SetElement(sets, HEVYSTAT_PCMB, data.pcmb, data_prev.pcmb);
    }

    static void SerializeWOCheck(const TIpStat& data, nosql::HashMap& sets) {
        SetElementWOCheck(sets, HEVYSTAT_CTSPAMTODAY, data.ctSpam_today);
        SetElementWOCheck(sets, HEVYSTAT_CTHAMTODAY, data.ctHam_today);
        SetElementWOCheck(sets, HEVYSTAT_CTMALICSPAMTODAY, data.ctMalicSpam_today);
        SetElementWOCheck(sets, HEVYSTAT_CTSPAM, data.ctSpam);
        SetElementWOCheck(sets, HEVYSTAT_CTHAM, data.ctHam);
        SetElementWOCheck(sets, HEVYSTAT_CTMALICSPAM, data.ctMalicSpam);
        SetElementWOCheck(sets, HEVYSTAT_RDNS, data.rdns);
        SetElementWOCheck(sets, HEVYSTAT_RDNS2, data.rdns2);
        SetElementWOCheck(sets, HEVYSTAT_RDNS3, data.rdns3);
        SetElementWOCheck(sets, HEVYSTAT_LASTUPDATE, static_cast<i64>(data.last_update));
        SetElementWOCheck(sets, HEVYSTAT_LASTFIX, static_cast<i64>(data.last_fix));
        SetElementWOCheck(sets, HEVYSTAT_CPS, data.cps);
        SetElementWOCheck(sets, HEVYSTAT_FORWARDS, data.forwards);
        SetElementWOCheck(sets, HEVYSTAT_FRWDPR1, data.frwd_pr1);
        SetElementWOCheck(sets, HEVYSTAT_WHITEPR, data.white_pr);
        SetElementWOCheck(sets, HEVYSTAT_PCMB, data.pcmb);
    }

    static TString ConvertToId(const TKIPv6& ip) {
        return ip.AsShingle128();
    }

    static ui64 ConvertToId2(const TKIPv6& ip) {
        return ip.AsShingle64();
    }

    static TKIPv6 IdToKey(const TString& id) {
        TKIPv6 ip;
        ip.FromShingle128(id);
        return ip;
    }
};

typedef std::list<TIpStatEx> TMemList;
typedef TMemList::iterator TMemListIt;
typedef TMemList::reverse_iterator TMemListRIt;

typedef THashMap<TKIPv6, TIpStat> TCacheMemStat;
typedef TCacheMemStat::iterator TCacheMemStatIt;

typedef std::list<TIpStatEx> TMemList;
typedef TMemList::iterator TMemListIt;
typedef TMemList::reverse_iterator TMemListRIt;
