#include "tblackhashipv6.h"
#include "baniplist.h"

//*********************************************************************************************************************
//                                                 TBlackIPv6
//*********************************************************************************************************************

TBlackIPv6::TBlackIPv6()
    : kipv6::THashIPv6(__FUNCTION__) {
    BanIPList = NULL;
    data = NULL;
    data_temp = NULL;
}

TBlackIPv6::~TBlackIPv6() {
    ClearData();
}

void TBlackIPv6::Init(const TString& filename, TLogsGroup* LogsGroupA, void* BanIPListA) {
    BanIPList = BanIPListA;
    InitBase("BLACKIP", filename, LogsGroupA, true);
}

void TBlackIPv6::ClearData() {
    if (data_temp != NULL) {
        delete data_temp;
        data_temp = NULL;
    }
    if (data != NULL) {
        delete data;
        data = NULL;
    }
}

void TBlackIPv6::ParseItem(const char* str, kipv6::THashStat& stat) {
    if ((str != NULL) && (data_temp != NULL)) {
        int len = strlen(str);
        char buff[2][100];

        memset(buff, 0, sizeof(buff));
        if (len > 0) {
            sscanf(str, " %s %s ", buff[0], buff[1]);
            if (buff[0][0] == '#') {
            } else {
                TKIPv6 ip = TKIPv6(buff[0]);
                if (!ip.Undefined()) {
                    if (data_temp->contains(ip)) {
                        stat.dublicat_count = IncMax32(stat.dublicat_count, 1);
#ifndef K_PRINT_ONLY_STAT
                        if ((LogsGroup != NULL) && (LogsGroup->ActionLog() != NULL))
                            LogsGroup->ActionLog()->WriteMessageAndDataStatus(KWARNING, "%s:   ip doubling '%s'", m_ident.c_str(), ip.toStroka().c_str());
#endif
                    } else {
                        data_temp->emplace(ip, 0);
                        stat.no_trace_count = IncMax32(stat.no_trace_count, 1);
                    }

                } else {
                    stat.bad_count = IncMax32(stat.bad_count, 1);

#ifndef K_PRINT_ONLY_STAT
                    if ((LogsGroup != NULL) && (LogsGroup->ActionLog() != NULL))
                        LogsGroup->ActionLog()->WriteMessageAndDataStatus(KERROR, "%s:   bad ip '%s'", m_ident.c_str(), buff[0]);
#endif
                }
            }
        }
    }
}

TString TBlackIPv6::GetResultPrint(kipv6::THashStat& stat, ui32 timedelay) {
    TString res = "";
    ui32 all = 0;

    all = IncMax32(all, stat.no_trace_count);
    all = IncMax32(all, stat.bad_count);
    all = IncMax32(all, stat.dublicat_count);
    res = m_ident + ":   Read list (" + IntToStroka(timedelay) + " ms), records: " + IntToStroka(all) + " (good=" + IntToStroka(stat.no_trace_count) + ", bad=" + IntToStroka(stat.bad_count) + ", dublicat=" + IntToStroka(stat.dublicat_count) + ")";

    return res;
}

void TBlackIPv6::TriggerFunction() {
    bool exists = false;
    int AddBanTime = 24;
    TKIPv6 ip;
    ui32 value = 0;
    ui32 sendtorbl = 0;

    if ((BanIPList != NULL) && (data != NULL)) {
        TBanIPListGeneral* banlist = (TBanIPListGeneral*)BanIPList;

        for (const auto &[ip, value] : *data) {
            if (!ip.Undefined()) {
                if (banlist != NULL)
                    exists = banlist->AddBanIpWOW(ip, 24, 0, false, true, false, "", false, sendtorbl);
                else
                    exists = false;
                if ((LogsGroup != NULL) && (((TLogsGroup*)LogsGroup)->ProtokolLog() != NULL)) {
                    if (exists)
                        ((TLogsGroup*)LogsGroup)->ProtokolLog()->WriteMessageAndData("Ban=24 cr=blacklist %s (%d) - already exists, strbl=%u", ip.toStroka().c_str(), AddBanTime, sendtorbl);
                    else
                        ((TLogsGroup*)LogsGroup)->ProtokolLog()->WriteMessageAndData("Ban=24 cr=blacklist %s (%d), strbl=%u", ip.toStroka().c_str(), AddBanTime, sendtorbl);
                }
            }
        }
    }
}

void TBlackIPv6::PrefixFunction() {
    data_temp = new kipv6::TKIPv6Hash();
}

void TBlackIPv6::PostfixFunction() {
    kipv6::TKIPv6Hash* data_t = NULL;

    //��������� ������� ����� �� ���������, ���� ��������� ������
    Lock();

    data_t = data;
    data = data_temp;
    data_temp = NULL;

    UnLock();

    //������� ������ ������
    if (data_t != NULL) {
        delete data_t;
        data_t = NULL;
    }
}

//*********************************************************************************************************************
