#include <util/system/tls.h>
#include <util/stream/format.h>
#include "tdatabasa_mongo_v3.h"

//*********************************************************************************************************************************
//                                                       TDataBasaMongoV3
//*********************************************************************************************************************************

TDataBasaMongoV3::TDataBasaMongoV3()
{
   m_mongo_inited  = 0;
   m_storage_type_name = "";
   m_storage_name  = "";
   m_otherdata   = "";
}

TDataBasaMongoV3::~TDataBasaMongoV3()
{


}

bool TDataBasaMongoV3::InitBeforeFork(const TString &server_hostname, const TString &server_code, const TString &server_start_time, const TString &server_version, TLogsGroup *LogsGroupA, TKConfig *configobjA)
{
   return InitBeforeForkNum(-1, server_hostname, server_code, server_start_time, server_version, LogsGroupA, configobjA);
}

bool TDataBasaMongoV3::InitBeforeForkNum(int index, const TString &server_hostname, const TString &server_code, const TString &server_start_time, const TString &server_version, TLogsGroup *LogsGroupA, TKConfig *configobjA)
{
   bool res = InitBeforeFork_base(index, server_hostname, server_code, server_start_time, server_version, LogsGroupA, configobjA);

   m_storage_type_name = "MONGOv3";
   LogsGroupB = LogsGroupA;
   if (configobjA != NULL)
   {
    if( !AtomicSwap( &m_mongo_inited, 1 ) )
      {
     const TString & seed = index > 0 ? "storage_" + IntToStroka(index) : "mongo";
     m_storage_name       = configobjA->ReadStroka(  seed, "name",             "" );

     stor_bt::loghandler.Init(LogsGroupB);

     m_mongo_uri.Reset(new mongo_v3::URI(mongo_v3::CreateConnectionString(*configobjA, m_database_name, seed)));
           m_mongo_pool.Reset(new mongo_v3::ClientPool(*m_mongo_uri));

         m_storage_connect = true;
         m_storage_status  = "";
         if (!server_code.empty())
         {
            nosql::HashMap   sets;
            ui64             id = 0;
            int              pv = 0;

            if (sscanf(server_code.c_str(), "%llx", &id) != 1)
               id = ShingleFromStroka(server_code);
            if (id != 0)
            {
    /*
    TConsoleStatData c_stat;

    c_stat.CreateStorageRequest(sets);
    if (WriteConsoleDataToStorage(id, sets))
    {
       m_storage_connect = true;
       m_storage_status  = "";
       if ( (LogsGroupB != NULL) && (LogsGroupB->GetServerLog() != NULL) )
       {
        LogsGroupB->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "MONGOCHECKCONN: OK");
        LogsGroupB->GetServerLog()->FFlush();
       }

    } else
    {
       m_storage_status  = "unknown error";
       if ( (LogsGroupB != NULL) && (LogsGroupB->GetServerLog() != NULL) )
       {
        LogsGroupB->GetServerLog()->WriteMessageAndDataStatus(KERROR, "MONGOCHECKCONN: FAILED(%s)", m_storage_status.c_str());
        LogsGroupB->GetServerLog()->FFlush();
       }

    }*/
            }
         }
      }
   }

   return res;
}

void TDataBasaMongoV3::InitAfterFork()
{
   InitAfterFork_base();
}

bool TDataBasaMongoV3::Midnight()
{
 bool res = Midnight_base();

 return res;
}

void TDataBasaMongoV3::EventTick()
{
 EventTick_base();
}

bool TDataBasaMongoV3::StorageUpdate(ui64 shingle, int type, stor_bt::TShingleStorageType sstype, const nosql::HashMap &incrs, const nosql::HashMap &sets, bool &err)
{
   bool     res             = true;

   if ( (incrs.empty()) && (sets.empty()) )
    return true;

   TString   collection_name = GetCollectionName(sstype, type);

   ui32 tick = CShingleTime::GetMs();
   try
   {
    mongo_v3::Update(*m_mongo_pool, m_database_name.c_str(), collection_name.c_str(), ShingleToStroka24(shingle).c_str(), incrs, sets, mongo_v3::KT_STRING);
       tick = CShingleTime::GetMs() - tick;

   } catch(const std::exception & e)
   {
       tick = CShingleTime::GetMs() - tick;
    res = false;
    err = true;
    LogsGroupB->GetServerLog()->WriteMessageAndData( "MONGOv3: StorageUpdate error: %s", e.what() );
   }

   AddStorageStat(sstype, stor_bt::SAT_UPDATE, 1, NStorageStats::ToTSRSErrTypeB(res), tick);

   IncrementStat(sstype, res);

   return res;
}

bool TDataBasaMongoV3::StorageUpdateUSERREP(ui64 shingle, int type, stor_bt::TShingleStorageType sstype, const nosql::HashMap &incrs, const nosql::HashMap &sets, bool &err)
{
   return StorageUpdate(shingle, type, sstype, incrs, sets, err);
}

bool TDataBasaMongoV3::StorageFindOne(ui64 shingle, int type, stor_bt::TShingleStorageType sstype, nosql::HashMap &hash, bool &err)
{
   const TString  & collection_name = GetCollectionName(sstype, type);

   bool good = true;
   ui32 tick = CShingleTime::GetMs();
   try
   {
    mongo_v3::FindOne(*m_mongo_pool, m_database_name.c_str(), collection_name.c_str(), ShingleToStroka24(shingle).c_str(), hash, mongo_v3::KT_STRING);
      tick = CShingleTime::GetMs() - tick;

   } catch(const std::exception & e)
   {
      tick = CShingleTime::GetMs() - tick;
    good = false;
    LogsGroupB->GetServerLog()->WriteMessageAndData( "MONGOv3: StorageFindOne error: %s", e.what() );
   }

   err &= good;

   AddStorageStat(sstype, stor_bt::SAT_FINDONE, 1, NStorageStats::ToTSRSErrTypeB(good), tick);

   IncrementStat(sstype, good);

   return good;
}

bool TDataBasaMongoV3::StorageFind(stor_bt::TShingleStorageType sstype, TVector<nosql::HashMap> &hashes, bool &err)
{
   bool     res             = true;
   const TString & collection_name = GetCollectionName(sstype, 0);

   bool good = true;
   ui32 tick = CShingleTime::GetMs();
   try
   {
    mongo_v3::FindAll(*m_mongo_pool, m_database_name.c_str(), collection_name.c_str(), hashes);
      tick = CShingleTime::GetMs() - tick;

   } catch(const std::exception & e)
   {
      tick = CShingleTime::GetMs() - tick;
    err = true;
    good = false;
    LogsGroupB->GetServerLog()->WriteMessageAndData( "MONGOv3: StorageFind error: %s", e.what() );
   }

   AddStorageStat(sstype, stor_bt::SAT_FIND, hashes.size(), NStorageStats::ToTSRSErrTypeB(res), tick);

   IncrementStat(sstype, res);

   return res;
}

bool TDataBasaMongoV3::StorageErase(ui64 shingle, int type, stor_bt::TShingleStorageType sstype, bool &err)
{
   bool     res             = true;
   const TString & collection_name = GetCollectionName(sstype, type);

   ui32 tick = CShingleTime::GetMs();
   //todo
   try
   {
    RemoveFromCollection(*m_mongo_pool, m_database_name.c_str(), collection_name.c_str(), shingle);
      tick = CShingleTime::GetMs() - tick;

   } catch(std::exception & e)
   {
      tick = CShingleTime::GetMs() - tick;
    res = false;
    LogsGroupB->GetServerLog()->WriteMessageAndData( "MONGOv3: StorageErase error: %s", e.what() );
   }

   AddStorageStat(sstype, stor_bt::SAT_ERASE, 1, NStorageStats::ToTSRSErrTypeB(res), tick);
   err &= res;

   IncrementStat(sstype, res);

   return res;
}

i64 TDataBasaMongoV3::StorageSize(int type, stor_bt::TShingleStorageType sstype, bool &err)
{
   i64     res = 0;
   TString  collection_name = "";

   collection_name = GetCollectionName(sstype, type);

   ui32 tick = CShingleTime::GetMs();

   bool good = true;
   try
   {
    res = mongo_v3::GetCollectionSize(*m_mongo_pool, m_database_name.c_str(), collection_name.c_str());
       tick = CShingleTime::GetMs() - tick;

   }catch (const std::exception & e)
   {
       tick = CShingleTime::GetMs() - tick;
    good = false;
    LogsGroupB->GetServerLog()->WriteMessageAndData( "MONGOv3: StorageSize error: %s", e.what() );
   }
   AddStorageStat(sstype, stor_bt::SAT_SIZE, 1, NStorageStats::ToTSRSErrTypeB(good), tick);
   err &= good;

   IncrementStat(sstype, res);

   return res;
}

void TDataBasaMongoV3::StorageMultiAction(stor_bt::TStorageActionList &actlist, bool &err)
{
   stor_bt::TStorageActionListIt it;
   ui32                 tick = 0;

   it = actlist.begin();
   while (it != actlist.end())
   {
      if ((*it).m_nosqldata != NULL)
      {
         tick = CShingleTime::GetMs();
         switch ((*it).m_action)
         {
         case stor_bt::SAT_UPDATE:
                           StorageUpdate((*it).m_nosqldata->shingle, (*it).m_nosqldata->type, (*it).m_storage_type, (*it).m_nosqldata->incrs, (*it).m_nosqldata->sets, *(*it).m_err);
                           break;
         case stor_bt::SAT_FINDONE:
                           StorageFindOne((*it).m_nosqldata->shingle, (*it).m_nosqldata->type, (*it).m_storage_type, (*it).m_nosqldata->hash, *(*it).m_err);
                           break;
         case stor_bt::SAT_ERASE:
                           StorageErase((*it).m_nosqldata->shingle, (*it).m_nosqldata->type, (*it).m_storage_type, *(*it).m_err);
                           break;
         };
         tick = CShingleTime::GetMs() - tick;
         *(*it).m_tick = tick;

         if (*(*it).m_err)
            err = true;

      }

      ++it;
   }
}

bool TDataBasaMongoV3::FindOne(TString db, TString collection, TString id, nosql::HashMap& hash, bool& err)
{
 bool good = true;

 stor_bt::TShingleStorageType sstype = GetCollectionNameFromType(collection);

 ui32 tick = CShingleTime::GetMs();
 try
 {
  mongo_v3::FindOne(*m_mongo_pool, db.c_str(), collection.c_str(), id.c_str(), hash, mongo_v3::KT_STRING);
  tick = CShingleTime::GetMs() - tick;

 }
 catch (const std::exception & e)
 {
  tick = CShingleTime::GetMs() - tick;
  good = false;
  LogsGroupB->GetServerLog()->WriteMessageAndData("MONGOv3: StorageFindOne error: %s", e.what());
 }

 err = !good;

 AddStorageStat(sstype, stor_bt::SAT_FINDONE, 1, NStorageStats::ToTSRSErrTypeB(good), tick);

 IncrementStat(sstype, good);

 return good;
}

bool TDataBasaMongoV3::Update(TString db, TString collection, TString id, const nosql::HashMap& incrs, const nosql::HashMap& sets, bool& err)
{
 bool     good = true;

 if ((incrs.empty()) && (sets.empty()))
  return true;

 stor_bt::TShingleStorageType sstype = GetCollectionNameFromType(collection);

 ui32 tick = CShingleTime::GetMs();
 try
 {
  mongo_v3::Update(*m_mongo_pool, db.c_str(), collection.c_str(), id.c_str(), incrs, sets, mongo_v3::KT_STRING);
  tick = CShingleTime::GetMs() - tick;

 }
 catch (const std::exception & e)
 {
  tick = CShingleTime::GetMs() - tick;
  good = false;
  LogsGroupB->GetServerLog()->WriteMessageAndData("MONGOv3: StorageUpdate error: %s", e.what());
 }

 err = !good;

 AddStorageStat(sstype, stor_bt::SAT_UPDATE, 1, NStorageStats::ToTSRSErrTypeB(good), tick);

 IncrementStat(sstype, good);

 return good;
}

bool TDataBasaMongoV3::FindAndModify(TString db, TString collection, TString id, const nosql::HashMap& incrs, const nosql::HashMap& sets, nosql::HashMap& hash, bool getnew, bool& err)
{
 bool     good = true;

 stor_bt::TShingleStorageType sstype = GetCollectionNameFromType(collection);

 ui32 tick = CShingleTime::GetMs();
 try
 {
  mongo_v3::FindAndModify(*m_mongo_pool, db.c_str(), collection.c_str(), id.c_str(), incrs, sets, hash, true, getnew, mongo_v3::KT_STRING);
  tick = CShingleTime::GetMs() - tick;

 }
 catch (const std::exception & e)
 {
  tick = CShingleTime::GetMs() - tick;
  good = false;
  LogsGroupB->GetServerLog()->WriteMessageAndData("MONGOv3: StorageFind error: %s", e.what());
 }
 err = !good;

 AddStorageStat(sstype, stor_bt::SAT_FIND, 1, NStorageStats::ToTSRSErrTypeB(good), tick);

 IncrementStat(sstype, good);

 return good;
}

i64 TDataBasaMongoV3::Size(TString db, TString collection, bool& err)
{
 i64  res  = 0;
 bool good = true;

 ui32 tick = CShingleTime::GetMs();

 stor_bt::TShingleStorageType sstype = GetCollectionNameFromType(collection);

 try
 {
  res = mongo_v3::GetCollectionSize(*m_mongo_pool, db.c_str(), collection.c_str());
  tick = CShingleTime::GetMs() - tick;

 }
 catch (const std::exception & e)
 {
  tick = CShingleTime::GetMs() - tick;
  good = false;
  LogsGroupB->GetServerLog()->WriteMessageAndData("MONGOv3: StorageSize error: %s", e.what());
 }
 AddStorageStat(sstype, stor_bt::SAT_SIZE, 1, NStorageStats::ToTSRSErrTypeB(good), tick);
 err = !good;

 IncrementStat(sstype, good);

 return res;
}

bool TDataBasaMongoV3::Find(TString db, TString collection, TVector< nosql::HashMap >& hashes, bool& err)
{
 bool     good = true;

 stor_bt::TShingleStorageType sstype = GetCollectionNameFromType(collection);

 ui32 tick = CShingleTime::GetMs();
 try
 {
  mongo_v3::FindAll(*m_mongo_pool, db.c_str(), collection.c_str(), hashes);
  tick = CShingleTime::GetMs() - tick;

 }
 catch (const std::exception & e)
 {
  tick = CShingleTime::GetMs() - tick;
  good = false;
  LogsGroupB->GetServerLog()->WriteMessageAndData("MONGOv3: StorageFind error: %s", e.what());
 }

 err = !good;

 AddStorageStat(sstype, stor_bt::SAT_FIND, hashes.size(), NStorageStats::ToTSRSErrTypeB(good), tick);

 IncrementStat(sstype, good);

 return good;
}

bool TDataBasaMongoV3::Erase(TString db, TString collection, TString id, bool& err)
{
 bool     good = true;

 stor_bt::TShingleStorageType sstype = GetCollectionNameFromType(collection);

 ui32 tick = CShingleTime::GetMs();
 try
 {
  RemoveFromCollection(*m_mongo_pool, db.c_str(), collection.c_str(), id.c_str(), mongo_v3::KT_STRING);
  tick = CShingleTime::GetMs() - tick;

 }
 catch (std::exception & e)
 {
  tick = CShingleTime::GetMs() - tick;
  good = false;
  LogsGroupB->GetServerLog()->WriteMessageAndData("MONGOv3: StorageErase error: %s", e.what());
 }

 AddStorageStat(sstype, stor_bt::SAT_ERASE, 1, NStorageStats::ToTSRSErrTypeB(good), tick);
 err = !good;

 IncrementStat(sstype, good);

 return good;
}

//*********************************************************************************************************************************



