#pragma once

#include "util/generic/string.h"
#include "util/system/mutex.h"
#include "util/string/util.h"
#include "util/system/rwlock.h"
#include "library/cpp/deprecated/atomic/atomic.h"
#include "tstoragenosql.h"
//#include "loggerhandler.h"
#include <mail/so/spamstop/tools/so-common/kqueuestat.h>
#include <mail/so/spamstop/tools/so-common/anyvalue.h>
#include <mail/so/spamstop/tools/mongoclient_v3/mongoclient.h>
#include <mail/so/spamstop/tools/so-common/tbasestoragetypes.h>
#include <mail/so/spamstop/tools/so-common/tlogsgroupbase.h>

//*********************************************************************************************************************************
//                                                       TDataBasaMongoV3
//*********************************************************************************************************************************

class TDataBasaMongoV3: public TStorageNoSql
{
public:
         TAtomic      m_mongo_inited;
         THolder<mongo_v3::URI>   m_mongo_uri;
         THolder<mongo_v3::ClientPool> m_mongo_pool;

private:
         bool       StorageUpdate(ui64 shingle, int type, stor_bt::TShingleStorageType sstype, const nosql::HashMap &incrs, const nosql::HashMap &sets, bool &err);
         bool       StorageUpdateUSERREP(ui64 shingle, int type, stor_bt::TShingleStorageType sstype, const nosql::HashMap &incrs, const nosql::HashMap &sets, bool &err);
         bool       StorageFindOne(ui64 shingle, int type, stor_bt::TShingleStorageType sstype, nosql::HashMap &hash, bool &err);
         bool       StorageFind(stor_bt::TShingleStorageType sstype, TVector<nosql::HashMap> &hashes, bool &err);
         bool       StorageErase(ui64 shingle, int type, stor_bt::TShingleStorageType sstype, bool &err);
         i64       StorageSize(int type, stor_bt::TShingleStorageType sstype, bool &err);
         void       StorageMultiAction(stor_bt::TStorageActionList &actlist, bool &err);

   TString      ReturnDriverProp(){ return ""; }
   qustatb::TDriverRqstPoolStat ReturnLiveRqstStatMaster(){ return qustatb::TDriverRqstPoolStat(); }
   qustatb::TDriverRqstPoolStat ReturnLiveRqstStatReplica(){ return qustatb::TDriverRqstPoolStat(); }
public:
         TDataBasaMongoV3();
         virtual ~TDataBasaMongoV3();

   bool       Midnight();
   void       EventTick();

         bool       InitBeforeFork(const TString &server_hostname, const TString &server_code, const TString &server_start_time, const TString &server_version, TLogsGroup *LogsGroupA, TKConfig *configobjA);
         bool       InitBeforeForkNum(int index, const TString &server_hostname, const TString &server_code, const TString &server_start_time, const TString &server_version, TLogsGroup *LogsGroupA, TKConfig *configobjA);
         void       InitAfterFork();

   bool       FindOne(TString db, TString collection, TString id, nosql::HashMap& hash, bool& err);
   bool       Update(TString db, TString collection, TString id, const nosql::HashMap& incrs, const nosql::HashMap& sets, bool& err);
   bool       FindAndModify(TString db, TString collection, TString id, const nosql::HashMap& incrs, const nosql::HashMap& sets, nosql::HashMap& hash, bool getnew, bool& err);
   i64       Size(TString db, TString collection, bool& err);
   bool       Find(TString db, TString collection, TVector< nosql::HashMap >& hashes, bool& err);
   bool       Erase(TString db, TString collection, TString id, bool& err);

   bool       SPSTSaveDump(const TString &filename, TString db, TString collection, bool& err, TFindToFileReport &report, i64 top_treshold) { return true; }
   bool       SPSTSaveTop(const TString &filename, TString db, TString collection, bool& err, TFindToFileReport &report, i64 top_treshold) { return true; }
   bool       SPSTSaveDumpWithSortByID(const TString &filename, TString db, TString collection, bool& err, TFindToFileReport &report) { return true; }
   bool       SPSTSaveDumpStep1(const TString &filename, TString db, TString collection, bool& err, TFindToFileReport &report) { return true; }
   bool       SPSTSaveDumpOnlyBanList(const TString &filename, TString db, TString collection, bool& err, TFindToFileReport &report) { return true; }
};

//*********************************************************************************************************************************


