#include "tdelaystrap.h"

TDelaysTrap::TDelaysTrap()
{
   time_t currenttime = time(NULL);

   m_lasttime = *localtime(&currenttime);
}

TDelaysTrap::~TDelaysTrap()
{


}

void TDelaysTrap::AddDelay(ui32 value)
{
   time_t currenttime = time(NULL);
   tm     t;
   i32    ivalue = value;

   m_Mutex.Acquire();

   t = *localtime(&currenttime);

   if (t.tm_yday != m_lasttime.tm_yday) // 
   {
      m_data.CopyTodayToYesterday();
      m_data.ClearToday();
   }

   if ( (t.tm_hour < 0) || (t.tm_hour > 23) )
      t.tm_hour = 0;

   if (ivalue > m_data.today_delays[t.tm_hour])
      m_data.today_delays[t.tm_hour] = ivalue;

   m_lasttime = t;

   m_Mutex.Release();
}

TString TDelaysTrap::GetStat()
{
   TString res           = "";
   TString today_s       = "";
   TString yesterday_s   = "";

   for (int i = 0; i < 24; i++)
   {
      if (m_data.today_delays[i] >= 0)
      {
         if (i != 23)
            today_s = today_s + IntToStroka(m_data.today_delays[i]) + ", ";
         else
            today_s = today_s + IntToStroka(m_data.today_delays[i]);
      } else
      {
         if (i != 23)
            today_s = today_s + "-, ";
         else
            today_s = today_s + "-";
      }

      if (m_data.yesterday_delays[i] >= 0)
      {
         if (i != 23)
            yesterday_s = yesterday_s + IntToStroka(m_data.yesterday_delays[i]) + ", ";
         else
            yesterday_s = yesterday_s + IntToStroka(m_data.yesterday_delays[i]);
      } else
      {
         if (i != 23)
            yesterday_s = yesterday_s + "-, ";
         else
            yesterday_s = yesterday_s + "-";
      }

      if ( (i == 5) || (i == 11) || (i == 17) )
      {
         today_s     = today_s + " &nbsp; ";
         yesterday_s = yesterday_s + " &nbsp; ";
      }
   }

   res = "T: " + today_s + " (Y: " + yesterday_s + ")";

   return res;
}

TString TDelaysTrap::GetStatToday()
{
   TString res           = "";
   TString today_s       = "";

   for (int i = 0; i < 24; i++)
   {
      if (m_data.today_delays[i] >= 0)
      {
         if (i != 23)
            today_s = today_s + IntToStroka(m_data.today_delays[i]) + ", ";
         else
            today_s = today_s + IntToStroka(m_data.today_delays[i]);
      } else
      {
         if (i != 23)
            today_s = today_s + "-, ";
         else
            today_s = today_s + "-";
      }
      if ( (i == 5) || (i == 11) || (i == 17) )
         today_s = today_s + " &nbsp; ";
   }

   res = today_s;

   return res;
}

TString TDelaysTrap::GetStatYesterday()
{
   TString res           = "";
   TString yesterday_s   = "";

   for (int i = 0; i < 24; i++)
   {
      if (m_data.yesterday_delays[i] >= 0)
      {
         if (i != 23)
            yesterday_s = yesterday_s + IntToStroka(m_data.yesterday_delays[i]) + ", ";
         else
            yesterday_s = yesterday_s + IntToStroka(m_data.yesterday_delays[i]);
      } else
      {
         if (i != 23)
            yesterday_s = yesterday_s + "-, ";
         else
            yesterday_s = yesterday_s + "-";
      }
      if ( (i == 5) || (i == 11) || (i == 17) )
         yesterday_s = yesterday_s + " &nbsp; ";
   }

   res = yesterday_s;

   return res;
}


