#pragma once

#include <util/generic/string.h>
#include "util/system/mutex.h"
#include <mail/so/spamstop/tools/so-common/kfunc.h>
#include <time.h>

struct TDelaysTrapData
{
   i32 today_delays[24];
   i32 yesterday_delays[24];

   TDelaysTrapData()
   {
      for (int i = 0; i < 24; i++)
         today_delays[i] = -1;

      for (int i = 0; i < 24; i++)
         yesterday_delays[i] = -1;
   }

   void ClearToday()
   {
      for (int i = 0; i < 24; i++)
         today_delays[i] = -1;
   }

   void CopyTodayToYesterday()
   {
      for (int i = 0; i < 24; i++)
         yesterday_delays[i] = today_delays[i];
   }

};

class TDelaysTrap
{
private:
         TDelaysTrapData m_data;
         TMutex          m_Mutex;
         tm              m_lasttime;
public:
         TDelaysTrap();
         ~TDelaysTrap();

         void   AddDelay(ui32 value);
         TString GetStat();
         TString GetStatToday();
         TString GetStatYesterday();
};

