#pragma once

#include <sys/stat.h>
#include "util/generic/hash.h"
#include <util/generic/string.h>
#include "util/system/mutex.h"
#include <library/cpp/deprecated/atomic/atomic.h>
#include "util/system/thread.h"
#include "util/thread/factory.h"
#include <library/cpp/cgiparam/cgiparam.h>
#include "util/system/file.h"
#include <list>
#include <mail/so/spamstop/tools/so-common/tlogclass.h>
#include <mail/so/spamstop/tools/so-common/kfunc.h>
#include <mail/so/spamstop/tools/so-common/anyvalue.h>
#include "tbasesstore_types.h"
#include <mail/so/spamstop/tools/so-common/tkconfig.h>
#include "baniplist.h"

//**************************************************************************************************************************
//                                           TDumpReadClass
//**************************************************************************************************************************

struct TQueueItem
{
   i64      str_number;
   bool     is_end;
   TString   data;

   TQueueItem()
   {
      Clear();
   }

   TQueueItem(i64 strnumb, const TString &data_r)
   {
      str_number = strnumb;
      is_end     = false;
      data       = data_r;
   }

   TQueueItem(bool enddata)
   {
      str_number = -1;
      is_end     = enddata;
      data       = "";
   }

   void Clear()
   {
      str_number = -1;
      is_end     = false;
      data       = "";
   }
};

struct TNegativValueStruct
{
   TString m_id;
   TString m_ip;
   TString m_errs;

   TNegativValueStruct()
   {
      Clear();
   }

   void Clear()
   {
      m_id   = "";
      m_ip   = "";
      m_errs = "";
   }
};

typedef std::list<TQueueItem>    TDumpReadQueue;
typedef TDumpReadQueue::iterator TDumpReadQueueIt;

class TDumpReadClass
{
private:
         static const ui32 DEFAULT_QUEUE_SIZE     = 100000;
         static const ui32 PRINT_PERIOD_COUNT     = 300000;
         static const int  SEND_TRY_COUNT_DEFAULT = 5;
         //static const ui32 PRINT_PERIOD_COUNT    = 3;
private:
         void           *statipobj;
         TString         m_ident;
         TString         m_dumpfilename;
         TStorageType   m_stortype;
         //TString         m_db;
         //TString         m_collection;
         ui32           m_buffersize;
         TDumpReadQueue queue;
         TMutex         m_Mutex;
         FILE           *m_handle;
         TLogClass      *m_log;
         i64            current_numb_str;
         bool           m_full_read_file;
         bool           m_start;
         ui32           fulltick;

         ui64           m_read_from_file;
         ui64           m_parser_error;
         ui64           m_send_ok;
         ui64           m_negativ_value;
         ui64           m_big_value;
         ui64           m_send_error;
         ui64           m_id_notfound;
         ui64           m_id_empty;
         ui64           m_last_read_from_file;
         ui64           m_last_parser_error;
         ui64           m_last_send_ok;
         ui64           m_last_negativ_value;
         ui64           m_last_big_value;
         ui64           m_last_send_error;
         ui64           m_last_id_notfound;
         ui64           m_last_id_empty;
         ui32           m_writelog_time;

         ui32           Crc32(unsigned char *buf, ui32 len);
         void           ReadToQueue();
         bool           NeedLoadData(ui32 &needdiff);
         bool           ParseDumpRecord(TQueueItem &rec, nosql::HashMap &hash);
         void           SendToStorage(TQueueItem &qi, nosql::HashMap &sets);
         bool           FileExists(const TString &filename);
         void           UserLock();
         void           UserUnLock();
         bool           FindNegativValue(nosql::HashMap &hash, TNegativValueStruct &stat);
         bool           FindBigValue(nosql::HashMap &hash, TNegativValueStruct &stat);
         void           CorrectBigNegValue(nosql::HashMap &hash);
public:
         TDumpReadClass();
         ~TDumpReadClass();

         bool  Init(void *statipobjA, const TString ident, ui32 thread_count, ui32 buffersize, const TString &dumpfilenameA, TLogClass *log, TStorageType stortype);
         void  ActionFunction(int threadnumber, bool &needstop);

};

//***************************************************************************************************************************
//                                                 TDumpReadClassMain
//***************************************************************************************************************************

class TDumpReadClassMain
{
public:
         static const ui32    MAX_THREAD_WORK          = 64;

private:
         TDumpReadClass       *dr_obj;

         TThread              *m_QueueThread[MAX_THREAD_WORK];
         TMutex               m_QueueMutex;
         bool                 m_StopQueueThread;
         bool                 run_scan_thread;
         ui32                 m_thread_count;

         int                  use_threadcount;
         void                 StartQueueThread();
         bool                 QueueThreadStopped();

public:
         ui32                 GetThreadCount(){ return m_thread_count; }
         void                 StopQueueThread();
         int                  IncrementNumberThread();
         void                 DecrementNumberThread();
         bool                 QueueThreadShouldStop(){ return m_StopQueueThread; }
         void                 ActionFunction(int threadnumber);
         bool                 InitBase(ui32 thread_count);

public:
         TDumpReadClassMain();
         ~TDumpReadClassMain();

         bool Init(void *statipobjA, const TString &ident, ui32 thread_count, ui32 buffersize, const TString &dumpfilenameA, TLogClass *log, TStorageType stortype);
         void Wait();

};

//***************************************************************************************************************************
//                                                 TDiskDumpConverter
//***************************************************************************************************************************

typedef struct _TFileBaseInfo
{
   char     Ident[4];    //index file - "KIFI", data file "KDFI"
   char     Version[4];  //version
   time_t   TimeCreate;  //create datetime
   char     Reserv[8];   //reserv
} TFileBaseInfo;

struct TBanIpBasicOld
{
    ui32       ip;             //ip
    time_t     tAction;        // 
    ui16       chours;         //- ,    
    ui32       cMessage;       //- ,   ,     (     )
  ui8        cIntBanIp;      // :
                               //    0x01 -   ip   banip.txt (   ,   )
                               //    0x02 -  
                               //    0x04 -   
                               //    0x08 -   
    char       cUser[25];      //,  
    char       cReserv[64];    //
    ui32       cs;             //crc

    TBanIpBasicOld()
    {
       Clear();
    }

    ui32 GetCRC32(ui32 cs)
    {
      ui8  buff[128];
      int  n = 0;
      ui32 i = 0, j = 0;

      memset(buff, 0, sizeof(buff));
      memcpy(buff + n, &ip, sizeof(ip));
      n += sizeof(ip);
      memcpy(buff + n, &tAction, sizeof(tAction));
      n += sizeof(tAction);
      memcpy(buff + n, &chours, sizeof(chours));
      n += sizeof(chours);
      memcpy(buff + n, &cMessage, sizeof(cMessage));
      n += sizeof(cMessage);
      memcpy(buff + n, &cIntBanIp, sizeof(cIntBanIp));
      n += sizeof(cIntBanIp);
      memcpy(buff + n, &cUser, sizeof(cUser));
      n += sizeof(cUser);
      memcpy(buff + n, &cReserv, sizeof(cReserv));
      n += sizeof(cReserv);

      for (i = 0, j = 0; i < n; i++, j++)
      {
        if (j == 4)
            j = 0;

        if (!j)
            cs += (buff[i] & 0xFF);
        else
            cs += (((buff[i] << (8 * j))) & 0xFF);
      }

      return cs;
    }

    void Clear()
    {
       ip        = 0;
       tAction   = 0;
       chours    = 0;
       cMessage  = 0;
     cIntBanIp = 0;
       cs        = 0;
       memset(cUser, 0, sizeof(cUser));
       memset(cReserv, 0, sizeof(cReserv));
    }

    bool operator<(const TBanIpBasicOld &value) const
    {
      return (ip < value.ip);
    }

};

class TDiskDumpConverter
{
private:
         static const ui64 PRINT_STAT_STEP = 4000000;
private:
         TString            m_IPDiskIndexFilename;
         TString            m_IPDiskBasaFilename;
         TString            m_IPDiskTargetFilename;

         TString            m_BanTargetFilename;
         TString            m_BanIndexFilename;

         TString            m_Ban7TargetFilename;
         TString            m_Ban7IndexFilename;

         bool              m_open_indexfile;
         bool              m_open_basafile;
         TLogClass         *m_log;
         TFile             *idxhandle;
         TFile             *bashandle;
         TMutex            m_Mutex;
         TKConfig          m_config;

         void              Lock();
         void              UnLock();
         bool              FileExists(const TString &filename);
         bool              ReadBlock(ui32 ip, TIpDisk &value, int &err, bool &exists);
         bool              ConvertDataIPDisk(const TString &ident);
         bool              ConvertBanData(const TString &ident, const TString &index_filename, const TString &target_filename);

public:
         TDiskDumpConverter();
         ~TDiskDumpConverter();

         bool              Init(const TString &config_filename);
         bool              ConvertData();



};

//**************************************************************************************************************************

