#include "tforwards.h"

//********************************************************************************
//                               kui16
//********************************************************************************

kui16::kui16()
{
   fvalue = 0;
}

kui16::kui16(long value)
{
   if (value > MAX_VALUE_COUNT)
      fvalue = MAX_VALUE_COUNT;
   else
      fvalue = value;
}

kui16::kui16(const kui16 &value)
{
   fvalue = value.fvalue;
}

kui16::~kui16()
{

}

ui16 kui16::IncMax16(const ui16 value, const ui16 step)
{
   ui16 res   = 0;
   ui16 count = 0;
   ui16 stepn = 0;

   switch (step)
   {
   case 0:
               res = value;
               break;
   case 1:
               res = (value < MAX_VALUE_COUNT) ? (value + 1) : MAX_VALUE_COUNT;
               break;
   default:
               count = MAX_VALUE_COUNT - value;
               if (count > 0)
               {
                  stepn = (step > count) ? count : step;
                  res = value + stepn;
               } else
                  res = value;
  };

  return res;
}

ui16 kui16::DecMax16(const ui16 value, const ui16 step)
{
   ui16 res   = 0;
   ui16 count = 0;
   ui16 stepn = 0;

   switch (step)
   {
   case 0:
               res = value;
               break;
   case 1:
               res = (value > 0) ? (value - 1) : 0;
               break;
   default:
               if (step > value)
                  res = 0;
               else
                  res = value - step;
  };

  return res;
}

/*kui16 kui16::operator+(const kui16 &value)
{
   kui16 res = *this;

   res.fvalue = IncMax16(res.fvalue, value.fvalue);

   return res;
}*/

kui16 kui16::operator+=(const kui16 &value)
{
   fvalue = IncMax16(fvalue, value.fvalue);

   return *this;
}

kui16 &kui16::operator++()
{
   this->fvalue = IncMax16(this->fvalue, 1);

   return *this;
}

kui16 kui16::operator-(const kui16 &value)
{
   kui16 res = *this;

   res.fvalue = DecMax16(res.fvalue, value.fvalue);

   return res;
}

kui16 kui16::operator-=(const kui16 &value){

   fvalue = DecMax16(fvalue, value.fvalue);

   return *this;
}

kui16 &kui16::operator--(){
   kui16 res = *this;

   this->fvalue = DecMax16(this->fvalue, 1);

   return res;
}

kui16::operator ui16() const
{
   return fvalue;
}

//********************************************************************************
//                              TUIDValue
//********************************************************************************

TUIDValue::TUIDValue()
{
   m_mailcount = 0;
}

TUIDValue::TUIDValue(ui16 mail_count)
{
   m_mailcount = mail_count;
}

TUIDValue::~TUIDValue()
{

}

TUIDValue &TUIDValue::operator+=(const TUIDValue &value)
{
   m_mailcount += value.m_mailcount;

   return *this;
}

//********************************************************************************
//                             TStoreBoxO
//********************************************************************************

TIpForwards::TIpForwards()
{
   sbox = new TStoreBox();
   memset(box_count_mail, 0, sizeof(box_count_mail));
   mail_count = 0;
   summ_500   = 0;
}

TIpForwards::TIpForwards(const TIpForwards &r)
{
   TStoreBoxIt it;

   sbox = new TStoreBox();
   memset(box_count_mail, 0, sizeof(box_count_mail));

   it = (r.sbox)->begin();
   while (it != (r.sbox)->end())
   {
      (*sbox)[(*it).first] = (*it).second;
      ++it;
   }

   for (int i = 0; i < 16; i++)
      box_count_mail[i] = r.box_count_mail[i];

   mail_count = r.mail_count;
   summ_500   = r.summ_500;
}

TIpForwards &TIpForwards::operator=(const TIpForwards &r)
{
   TStoreBoxIt it;

   if (this->sbox != NULL)
   {
      delete this->sbox;
      this->sbox = NULL;
   }
   this->sbox = new TStoreBox();

   it = (r.sbox)->begin();
   while (it != (r.sbox)->end())
   {
      (*(this->sbox))[(*it).first] = (*it).second;
      ++it;
   }

   memset(this->box_count_mail, 0, sizeof(this->box_count_mail));
   for (int i = 0; i < 16; i++)
      this->box_count_mail[i] = r.box_count_mail[i];

   this->mail_count = r.mail_count;
   this->summ_500   = r.summ_500;

   return *this;
}

TIpForwards::~TIpForwards()
{
   if (sbox != NULL)
   {
      delete sbox;
      sbox = NULL;
   }
}

bool TIpForwards::Add(ui64 uid, ui16 count, bool &first_mail)
{
   bool  res = false;

   first_mail = false;
   if (sbox != NULL)
   {
      TStoreBoxIt it;
      TUIDValue   value, *pvalue = NULL;
      ui16        n  = 0;
      ui16        tv = 0;

      it = sbox->find(uid);
      if (it == sbox->end())
      {
         if (sbox->size() < MAX_BOX_FROM_ONEIP)
         {
            (*sbox)[uid] = TUIDValue(count);
            mail_count = IncMax32(mail_count, count);

            if (count > 500)
               summ_500 = IncMax32(summ_500, 500);
            else
               summ_500 = IncMax32(summ_500, count);

            n = count;
            if (n > 0)
            {
               if (n > 15)
                  n = 16;
               ++box_count_mail[n-1];
            }

            res = true;
            first_mail = true;
         }
      } else
      {
         pvalue = &((*it).second);

         n = pvalue->mailcount();
         if (n > 0)
         {
            if (n > 15)
               n = 16;
            --box_count_mail[n-1];
         }
         n = pvalue->mailcount();
         if (n > 500)
            summ_500 = summ_500 - 500;
         else
            summ_500 = summ_500 - n;

         *pvalue += TUIDValue(count);
         mail_count += count;

         tv = IncMax16(n, count);
         if (tv > 500)
            summ_500 = IncMax32(summ_500, 500);
         else
            summ_500 = IncMax32(summ_500, tv);

         n = pvalue->mailcount();
         if (n > 0)
         {
            if (n > 15)
               n = 16;
            ++box_count_mail[n-1];
         }

         res = true;
      }

   }
   return res;
}

kui16 TIpForwards::Get(ui64 uid)
{
   kui16 res = 0;

   if (sbox != NULL)
   {
      TStoreBoxIt it;

      it = sbox->find(uid);
      if (it != sbox->end())
      {
         res = (*it).second.mailcount();
      }
   }

   return res;
}

ui16 TIpForwards::GetBoxCount()
{
   ui16  res = 0;

   if (sbox != NULL)
      res = sbox->size();
   return res;
}

ui16 TIpForwards::GetBoxCountMail(ui16 mailcount)
{
   ui16   res = 0;
   ui16   n = 0;

   if (mailcount > 0)
   {
      if (mailcount > 15)
         n = 16;
      else
         n = mailcount;
      res = box_count_mail[n - 1];
   }

   return res;
}

TFrwdData TIpForwards::GetForwardsData() const
{
   TFrwdData res;
   ui32      summa = 0;
   ui16      aa = 0;
   int       j = 0;
   ui32      v = 0;
   ui32      a_all = 0;

   memset(&res, 0, sizeof(res));
   res.box_count = sbox->size();
   res.mail_count = mail_count;
   res.summ_500 = summ_500;
   for (int i = 1; i < 16; i++)
   {
      res.box_count_mail[i] = box_count_mail[i];
      res.a_count_mail[i] = box_count_mail[i - 1] * i;
      summa = summa + res.a_count_mail[i];
   }
   res.box_count_mail[0] = box_count_mail[0];
   res.a_count_mail[0] = mail_count - summa; //   65535
   res.a_all = mail_count - summa;           // 
   aa = box_count_mail[15];

   //
   for (int k = 0; k < 16; k++)
   {
      if (res.a_count_mail[k] > 0)
      {
         v = res.a_count_mail[k];
         if (k > 0)
         {
            j += snprintf(res.forward_comments + j, sizeof(res.forward_comments) - j - 1, "%d=%d ", k, res.a_count_mail[k]/k);
         } else
         {
            v = res.a_all;
            j += snprintf(res.forward_comments + j, sizeof(res.forward_comments) - j - 1, "0=%d(%d) ", aa, v);
         }
      }
   }
   snprintf(res.forward_comments + j, sizeof(res.forward_comments) - j - 1, " (%d mails in %d boxes)", res.mail_count, res.box_count);

   return res;
}

/*int TIpForwards::CheckForwards(TReport &report)
{
   int  res = 0;
   ui16 boxcount = 0;
   char rep[256];
   ui32 a[16];
   ui32 summa = 0;
   bool fFrwd = false;
   char forward_comments[256];
   int  j = 0;
   ui16 aa = 0;
   ui32 v = 0;

   memset(a, 0, sizeof(a));
   memset(rep, 0, sizeof(rep));
   memset(forward_comments, 0, sizeof(forward_comments));

   for (int i = 1; i < 16; i++)
   {
      a[i] = box_count_mail[i - 1] * i;
      summa = summa + a[i];
   }
   a[0] = mail_count - summa;
   aa = box_count_mail[15];

   boxcount = sbox->size();

   for (int k = 0; k < 16; k++)
   {
      if (a[k] > 0)
      {
         v = res.a_count_mail[k];
         if (k > 0)
         {
            j += snprintf(forward_comments + j, sizeof(forward_comments) - j - 1, "%d=%d ", k, a[k]/k);
         } else
         {
            j += snprintf(forward_comments + j, sizeof(forward_comments) - j - 1, "0=%d(%d) ", aa, a[k]);
         }
      }
   }
   snprintf(forward_comments + j, sizeof(forward_comments) - j - 1, " (%d mails in %d boxes)", mail_count, boxcount);


   if (boxcount >= 100)
      snprintf(rep, sizeof(rep) - 1, "%s", "NEW");
   if (boxcount >= 100)
   {
      if (boxcount < 200)
      {
         if (mail_count > 2 * boxcount)
         {
            res = 1;
            fFrwd = true;
         } else
            res = 0;
      } else if (boxcount < 400)
      {
          if (mail_count > 4 * boxcount)
          {
            res = 1;
            fFrwd = true;
          } else
            res = 0;
      } else
      {
          if (mail_count > 5 * boxcount)
          {
            res = 1;
            fFrwd = true;
          } else
            res = 0;
      }
   } else if ((boxcount > 0) && box_count_mail[9] && (mail_count < 500) && ((summ_500 / boxcount) >= 2)) //more than  10 mails in one mailbox
   {
      res = 10;
      snprintf(rep, sizeof(rep) - 1, "%s", "YES-10");
      fFrwd = true;
   } else if ((a[1] + a[2]) < (mail_count - a[1] - a[2]))         //one or two mails in mailboxes SPAM else FORWARDS
   {
      if (mail_count >= 10)
      {
         fFrwd = true;
         snprintf(rep, sizeof(rep) - 1, "%s", "YES-2");
         res = 2;
      } else
      {
         snprintf(rep, sizeof(rep) - 1, "%s", "NO-2");
         res = 0;
      }
   } else if (a[1]  < (mail_count - a[1]))                        //one mail in mailboxes - SPAM  else FORWARDS
   {
      if (mail_count >= 10)
      {
         fFrwd = true;
         snprintf(rep, sizeof(rep) - 1, "%s", "YES-1");
         res = 1;
      } else
      {
         snprintf(rep, sizeof(rep) - 1, "%s", "NO-1");
         res = 0;
      }
   } else
   {
      snprintf(rep, sizeof(rep) - 1, "%s", "NO");
      res = 0;
   }
   report.SetFrwd(fFrwd);
   report.Setforward(TString(rep));
   report.Setforward_comments(TString(forward_comments));
   return res;
}*/

TString TIpForwards::GetStat()
{
   TString res = "";

   res = "mail_count=" + IntToStroka(mail_count) + " summ500=" + IntToStroka(summ_500) + " ";
   for (int i = 0; i < 16; i++)
      res = res + IntToStroka(i) + "=" + IntToStroka(box_count_mail[i]) + " ";

   return res;
}

void TIpForwards::clear()
{
   if (sbox != NULL)
      sbox->clear();

   memset(box_count_mail, 0, sizeof(box_count_mail));
   mail_count = 0;
   summ_500   = 0;
}

//********************************************************************************
//                               TForwards
//********************************************************************************
/*
TForwards::TForwards()
{
   sip = new TStoreIP();
}

TForwards::~TForwards()
{
   if (sip != NULL)
   {
      sip->clear();
      delete sip;
      sip = NULL;
   }
}

bool TForwards::Add(ui32 ip, ui64 uid, ui16 count)
{
   bool  res = false;

   if (sip != NULL)
   {
      TStoreIPIt it;

      it = sip->find(ip);
      if (it == sip->end())
      {
         (*sip)[ip] = TStoreBoxO();
         it = sip->find(ip);
      }
      if (it != sip->end())
      {
         res = (*it).second.Add(uid, count);
      }
   }
   return res;
}

ui16 TForwards::GetBoxCountMail(ui32 ip, ui16 mailcount)
{
   ui16 res = 0;

   if (sip != NULL)
   {
      TStoreIPIt it;

      it = sip->find(ip);
      if (it != sip->end())
      {
         res = (*it).second.GetBoxCountMail(mailcount);
      }
   }
   return res;
}
*/

TVector< char > StoreBoxToVector( const TStoreBox& sbox )
{
    TVector< std::pair< ui64, kui16 > > v;
    for( TStoreBox::const_iterator p = sbox.begin(); p != sbox.end(); p++ )
        v.push_back( std::make_pair( p->first, p->second.mailcount() ) );

    if( v.empty() )
        return TVector< char >();

    const char* pData = reinterpret_cast< const char* >( &v[ 0 ] );
    return TVector< char >( pData, pData + v.size() * sizeof( v[ 0 ] ) );
}

void VectorToStoreBox( const TVector< char >& data, TStoreBox& sbox )
{
    if( data.empty() )
        return;

    sbox.clear();
    TVector< std::pair< ui64, kui16 > > v;
    v.resize( ( data.size() + sizeof( v[ 0 ] ) - 1 ) / sizeof( v[ 0 ] ) );
    memcpy( reinterpret_cast< char* >( &v[ 0 ] ), &data[ 0 ], data.size() );

    for( size_t i = 0; i < v.size(); i++ )
        sbox[ v[ i ].first ] = TUIDValue( v[ i ].second );
}
