#pragma once

#include <mail/so/spamstop/sp/sptypes.h>
#include "util/generic/hash.h"
#include "treport.h"
#include <mail/so/spamstop/tools/so-common/kfunc.h>
#include <mail/so/spamstop/tools/so-common/serializehelper.h>

#define MAX_BOX_FROM_ONEIP 1000 //. 4369 -  TFrwdData::a_count_mail[15] - 

class kui16 //  ui16,    .     MAX_VALUE_COUNT
{
private:
         static const ui16 MAX_VALUE_COUNT = 65535;
         ui16   fvalue;

         ui16   IncMax16(const ui16 value, const ui16 step);
         ui16   DecMax16(const ui16 value, const ui16 step);
public:
         kui16();
         kui16(long value);
         kui16(const kui16 &value);
         ~kui16();

         //kui16 operator+(const kui16 &value);
         kui16 operator+=(const kui16 &value);
         kui16 &operator++();                      // 

         kui16 operator-(const kui16 &value);
         kui16 operator-=(const kui16 &value);
         kui16 &operator--();                      // 

         operator ui16() const;
};

struct TFrwdData
{
   ui16     box_count;          // 
   ui32     mail_count;         //  (  )
   ui32     summ_500;           //    ,   -    > 500 ,  ,    500 .
   kui16    box_count_mail[16]; //- ,   1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,>15  (box_count_mail[0] - - ,  1 , box_count_mail[1] - - ,  2   ..)
   kui16    a_count_mail[16];   //a_count_mail[0] -    ,   15   , a_count_mail[1] -    ,  1 , a_count_mail[2] -    ,  2 
   ui32     a_all;              // ,   a_count_mail[0] -    -   65535 ( kui16   a_count_mail[0]  65535   )
   char     forward_comments[256];//      
};

class TUIDValue
{
public:
//private:
   kui16 m_mailcount; //count mail

public:
   TUIDValue();
   TUIDValue(ui16 mail_count);
   virtual ~TUIDValue();

   TUIDValue &operator+=(const TUIDValue &value);

   kui16     mailcount() const { return m_mailcount; }
};

class TUIDValueSerialization
{
public:
    static void Deserialize( nosql::HashMap& hash, TUIDValue& data )
    {
        AssignValue( data.m_mailcount, hash[ "m_mailcount" ].Long() );
    }

    static void Serialize( const TUIDValue& data, const TUIDValue& data_prev, nosql::HashMap& incrs, nosql::HashMap& sets )
    {
        SetElement( sets, "m_mailcount", data.m_mailcount, data_prev.m_mailcount );
    }

    static TString ConvertToId( ui64 value )
    {
        char buf[ 64 ];
        sprintf( buf, "%llx", value );
        return buf;
    }
};

typedef THashMap< ui64, TUIDValue > TStoreBox;   //records: box (uid) = TUIDValue
typedef TStoreBox::iterator      TStoreBoxIt;

class TIpForwards
{
public:
//private:
   TStoreBox *sbox;
   kui16     box_count_mail[16]; //- ,   1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,>15  (box_count_mail[0] - - ,  1 , box_count_mail[1] - - ,  2   ..)
   ui32      mail_count;         //-     (  )
   ui32      summ_500;           //    ,   -    > 500 ,  ,    500 )
public:
   TIpForwards();
   TIpForwards(const TIpForwards &r);
   virtual ~TIpForwards();

   TIpForwards &operator=(const TIpForwards &r);

   bool  Add(ui64 uid, ui16 count, bool &first_mail);
   kui16 Get(ui64 uid);
   ui16  GetBoxCount();

   ui16  GetBoxCountMail(ui16 mailcount); //1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,>15

   TFrwdData GetForwardsData() const;

   TString GetStat();

   void   clear();

   friend class TMemRecordSerialization;
};

TVector< char > StoreBoxToVector( const TStoreBox& sbox );
void VectorToStoreBox( const TVector< char >& data, TStoreBox& sbox );


