#include "tgeneralobject.h"

//******************************************************************************************************************************************
//                                                       TGeneralObject
//******************************************************************************************************************************************

TGeneralObject::TGeneralObject()
{
   LogsGroup      = NULL;
   config         = NULL;
   StatIPObject   = NULL;
}

TGeneralObject::~TGeneralObject()
{
   if (StatIPObject != NULL)
   {
      delete StatIPObject;
      StatIPObject = NULL;
   }
}

TLogsGroup *TGeneralObject::GetLogsGroup()
{
   return (TLogsGroup *)LogsGroup;
}

bool TGeneralObject::InitBeforeFork(const TString &server_id, TLogsGroupBase *LogsGroupA, TKConfig *configA)
{
   bool res = false;

   LogsGroup = LogsGroupA;
   config    = configA;

   StatIPObject = new TStatIPObject();
   if (StatIPObject != NULL)
      res = StatIPObject->InitBeforeFork(server_id, GetLogsGroup(), config);

   return res;
}

bool TGeneralObject::InitAfterFork()
{
   bool res = false;

   if (StatIPObject != NULL)
      res = StatIPObject->InitAfterFork();

   if (GetLogsGroup() != NULL)
      GetLogsGroup()->WriteFlushStatus();

   return true;
}

bool TGeneralObject::Midnight()
{
   bool res = false;

   if (GetLogsGroup() != NULL)
      GetLogsGroup()->Midnight();
   if (StatIPObject != NULL)
      res = StatIPObject->Midnight();

   return res;
}

bool TGeneralObject::MidnightHeavy()
{
   bool res = false;

   if (StatIPObject != NULL)
      res = StatIPObject->MidnightHeavy();
   SaveTopStorage(true);

   return res;
}

bool TGeneralObject::Shutdown()
{
   bool res = false;

   if (StatIPObject != NULL)
   {
      StatIPObject->Shutdown();
      res = true;
   }

   return res;
}

void TGeneralObject::EventTick()
{
   StatIPObject->EventTick();
}

void TGeneralObject::EventTickHeavy()
{
   if (StatIPObject != NULL)
      StatIPObject->EventTickHeavy();
}

bool TGeneralObject::Close()
{

   return true;
}

TString TGeneralObject::GetTimeOnlyFilenameArx(time_t ttek)
{
   ui16   year = 0, mon = 0, day = 0;
   char   tbuff[1025];
   TString sdate = "";
   tm     ttm;

   ttm  = *localtime(&ttek);
   year = 1900 + ttm.tm_year;
   mon  = ttm.tm_mon + 1;
   day  = ttm.tm_mday;
   memset(tbuff, 0, sizeof(tbuff));
   snprintf(tbuff, sizeof(tbuff) - 1, "%04d-%02d-%02d", year, mon, day);
   sdate.assign(tbuff);

   return sdate;
}

TString TGeneralObject::SaveTopStor2(const TString &filepath, TStorageType stortype, i64 top_treshold)
{
   TString res = "";

   if ( (StatIPObject != NULL) && (StatIPObject->GetStorage() != NULL) )
   {
      TString filename         = "";
      bool   err              = false;
      ui32   tick             = 0;
      TString filepath_t       = filepath;
      i64    collection_size  = 0;
      ui64   readcount        = 0;
      bool   fullresok        = true;
      TFindToFileReport report;
      TString top_dop          = "";
      TString need_dop         = "";

   #ifdef _win_
               if (!filepath_t.empty())
               {
                  if (filepath_t.back() != '\\')
                     filepath_t = filepath_t + "\\";
               }
   #else
               if (!filepath_t.empty())
               {
                  if (filepath_t.back() != '/')
                     filepath_t = filepath_t + "/";
               }
   #endif
      filename = filepath_t + StatIPObject->GetStorage()->GetDBCollectionText(stortype, "_") + "_" + GetTimeOnlyFilenameArx(time(NULL)) + ".top_txt";
      res += "Write toplist " + StatIPObject->GetStorage()->GetDBCollectionText(stortype, "::") + ":";

      //get collection size
      tick = CShingleTime::GetMs();
      err  = false;
      collection_size = StatIPObject->GetStorage()->mongo_basa_size(stortype);
      tick = CShingleTime::GetMs() - tick;
      if (err)
      {
         res += " Size=???(FAILED, " + IntToStroka(tick) + " msec)";
         fullresok = false;

      } else
      {
         res += " Size=" + IntToStroka(collection_size) + "(OK, " + IntToStroka(tick) + " msec)";
      }

      //read collection
      tick = CShingleTime::GetMs();
      err  = false;
      StatIPObject->GetStorage()->spamstat_savetop(filename, stortype, err, report, top_treshold);

      readcount = report.fulldump_record_count;
      if (report.use_top)
         top_dop = ", topcount=" + UI64ToStroka(report.top_record_count) + " [trsh=" + UI64ToStrokaNum(report.top_treshold) + "]";

      tick = CShingleTime::GetMs() - tick;
      if (err)
      {
         res += ", Find " + UI64ToStroka(readcount) + " record (empty=" + UI64ToStroka(report.empty_data) + ", type_count=" + report.GetCountersByType() + ")" + top_dop + " (FAILED, " + IntToStroka(tick) + " msec)";
         fullresok = false;

      } else
      {
         res += ", Find " + UI64ToStroka(readcount) + " record (empty=" + UI64ToStroka(report.empty_data) + ", type_count=" + report.GetCountersByType() + ")" + top_dop + " (OK, " + IntToStroka(tick) + " msec)";
      }

      if ( (GetLogsGroup() != NULL) && (GetLogsGroup()->GetServerLog() != NULL) )
      {
         if (fullresok)
            GetLogsGroup()->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "%s", res.c_str());
         else
            GetLogsGroup()->GetServerLog()->WriteMessageAndDataStatus(KERROR, "%s", res.c_str());
      }
      if ( (GetLogsGroup() != NULL) && (GetLogsGroup()->StorageDumpLog() != NULL) )
      {
         if (fullresok)
            GetLogsGroup()->StorageDumpLog()->WriteMessageAndDataStatus(KMESSAGE, "%s", res.c_str());
         else
            GetLogsGroup()->StorageDumpLog()->WriteMessageAndDataStatus(KERROR, "%s", res.c_str());
      }
   }

   return res;
}

TString TGeneralObject::SaveTopStorage(bool is_midnight)
{
   TString filepath         = "";
   TString text             = "";
   i64    top_treshold     = SPST_TOP_TRESHOLD;
   bool   enable_calctop   = false;
   bool   needcalc         = true;

   if (GetConfigObject() != NULL)
   {
      filepath       = GetConfigObject()->ReadStroka("nosql", "dumppath", "");
      top_treshold   = GetConfigObject()->ReadInteger("nosql", "top_treshold", SPST_TOP_TRESHOLD);
      enable_calctop = GetConfigObject()->ReadBool("nosql", "enable_calc_topstor", false);
   }

   if (is_midnight)
      needcalc = enable_calctop;

   if (needcalc)
   {
      //text += SaveTopStor2(filepath, MST_BANSETUP, top_treshold) + "<br>";
      //text += SaveTopStor2(filepath, MST_BANIP, top_treshold) + "<br>";
      //text += SaveTopStor2(filepath, MST_BAN7IP, top_treshold) + "<br>";
      //text += SaveTopStor2(filepath, MST_MEMSTAT, top_treshold) + "<br>";
      text += SaveTopStor2(filepath, MST_MEMBASE, top_treshold) + "<br>";

   }

   return text;
}

TString TGeneralObject::SaveIPDataFromStorage(TKIPv6 ip)
{
   TString res          = "";
   ui32   tick         = 0;
   bool   find_membase = false;
   bool   find_memstat = false;
   bool   find_banobj  = false;
   bool   find_ban7obj = false;

   if ( (StatIPObject != NULL) && (StatIPObject->GetStorage() != NULL) && (!ip.Undefined()) )
   {
      tick = CShingleTime::GetMs();

      TString   text       = "";
      FILE     *handle    = NULL;
      TString   filename   = "";
      TString   filepath_t = "";

      if (GetConfigObject() != NULL)
         filepath_t = GetConfigObject()->ReadStroka("nosql", "dumppath", "");

      if (ip.IsIPv4())
      {
         filename = ip.toStroka2();

      } else if (ip.IsIPv6())
      {
         filename = ip.toStroka2();
         if (!filename.empty())
         {
            TString tstr = "";

            for (int i = 0; i < filename.length(); i++)
            {
               if (filename[i] == ':')
                  tstr += '.';
               else
                  tstr += filename[i];
            }
            filename = tstr;

         }
      }
   #ifdef _win_
               if (!filepath_t.empty())
               {
                  if (filepath_t.back() != '\\')
                     filepath_t = filepath_t + "\\";
               }
   #else
               if (!filepath_t.empty())
               {
                  if (filepath_t.back() != '/')
                     filepath_t = filepath_t + "/";
               }
   #endif

      if (!filename.empty())
      {

         filename = filepath_t + "ipaddr_dump_" + filename + ".dmp";

         handle = fopen(filename.c_str(), "wb");
         if (handle != NULL)
         {
            bool              mongo_err       = false;
            TMemRecord        data;
            TIpStat           data_stat;
            TBanIpBasic       bandata;
            TBanIpBasic       ban7data;
            bool              empty           = true;
            time_t            currenttime     = 0;
            ui32              currenttime_m   = 0;
            tm                cttm;
            char              tbuff[512];
            nosql::HashMap    sets;
            TFindToFileReport counters;
            TString            id_s            = "";
            TString            ip_s            = "";

            //shap
            currenttime = time(NULL);
            currenttime_m = currenttime;
            cttm = *localtime(&currenttime);
            memset(tbuff, 0, sizeof(tbuff));
            snprintf(tbuff, sizeof(tbuff) - 1, "#document create to %02d.%02d.%04d %02d:%02d:%02d (%u)\n", cttm.tm_mday, cttm.tm_mon + 1, cttm.tm_year + 1900, cttm.tm_hour, cttm.tm_min, cttm.tm_sec, currenttime_m);
            text += TString(tbuff);

            //membase
            mongo_err = true;
            empty     = true;
            if (StatIPObject->GetStorage()->mongo_read_ip_data(MST_MEMBASE, ip, mongo_err, data, empty))
            {
               text += "\nMEMBASE (" + ip.toStroka() + "):\n";
               if (!mongo_err)
               {
                  if (empty)
                  {
                     text += "empty\n";

                  } else
                  {
                     sets.clear();
                     TMemRecordSerialization::SerializeWOCheck(data, sets);
                     sets["_id"] = nosql::AnyValue(TMemRecordSerialization::ConvertToId(ip));
                     text += TStorageNoSql::GetDataToLog(sets, counters, id_s, ip_s) + "\n";
                     find_membase = true;

                  }

               } else
               {
                  text += "mongo error\n";

               }

            }

            //memstat
            mongo_err = true;
            empty     = true;
            if (StatIPObject->GetStorage()->mongo_read_ip_data_stat(MST_MEMSTAT, ip, mongo_err, data_stat, empty))
            {
               text += "\nMEMSTAT (" + ip.toStroka() + "):\n";
               if (!mongo_err)
               {
                  if (empty)
                  {
                     text += "empty\n";

                  } else
                  {
                     sets.clear();
                     TIpStatSerialization::SerializeWOCheck(data_stat, sets);
                     sets["_id"] = nosql::AnyValue(TIpStatSerialization::ConvertToId(ip));
                     text += TStorageNoSql::GetDataToLog(sets, counters, id_s, ip_s) + "\n";
                     find_memstat = true;

                  }

               } else
               {
                  text += "mongo error\n";

               }

            }

            //banobj
            mongo_err = true;
            empty     = true;
            if (StatIPObject->GetStorage()->mongo_read_banip(MST_BANIP, ip, mongo_err, bandata, empty))
            {
               text += "\nBANOBJ (" + ip.toStroka() + "):\n";
               if (!mongo_err)
               {
                  if (empty)
                  {
                     text += "empty\n";

                  } else
                  {
                     sets.clear();
                     TBanIpBasicSerialization::SerializeWOCheck(bandata, sets);
                     sets["_id"] = nosql::AnyValue(TBanIpBasicSerialization::ConvertToId(ip));
                     text += TStorageNoSql::GetDataToLog(sets, counters, id_s, ip_s) + "\n";
                     find_banobj = true;

                  }

               } else
               {
                  text += "mongo error\n";

               }

            }

            //ban7obj
            mongo_err = true;
            empty     = true;
            if (StatIPObject->GetStorage()->mongo_read_banip(MST_BAN7IP, ip, mongo_err, ban7data, empty))
            {
               text += "\nBAN7OBJ (" + ip.toStroka() + "):\n";
               if (!mongo_err)
               {
                  if (empty)
                  {
                     text += "empty\n";

                  } else
                  {
                     sets.clear();
                     TBanIpBasicSerialization::SerializeWOCheck(ban7data, sets);
                     sets["_id"] = nosql::AnyValue(TBanIpBasicSerialization::ConvertToId(ip));
                     text += TStorageNoSql::GetDataToLog(sets, counters, id_s, ip_s) + "\n";
                     find_ban7obj = true;

                  }

               } else
               {
                  text += "mongo error\n";

               }
            }

            fprintf(handle, "%s", text.c_str());

            fclose(handle);
            handle = NULL;
         }
      }

      tick = CShingleTime::GetMs() - tick;
      res += "Save IP=" + ip.toStroka() + " dump complete to " + IntToStroka(tick) + " msec, ";
      if (find_membase)
         res += "MEMBASE: OK, ";
      else
         res += "MEMBASE: -, ";

      if (find_memstat)
         res += "MEMSTAT: OK, ";
      else
         res += "MEMSTAT: -, ";

      if (find_banobj)
         res += "BANOBJ: OK, ";
      else
         res += "BANOBJ: -, ";

      if (find_ban7obj)
         res += "BAN7OBJ: OK.";
      else
         res += "BAN7OBJ: -.";

   } else
   {
      res += "ip undefined!";

   }

   return res;
}

TString TGeneralObject::SaveDumpStor2(const TString &filepath, TStorageType stortype, i64 top_treshold)
{
   TString res              = "";
   TString filename         = "";
   bool   err              = false;
   ui32   tick             = 0;
   TString filepath_t       = filepath;
   i64    collection_size  = 0;
   ui64   readcount        = 0;
   bool   fullresok        = true;
   TFindToFileReport report;
   TString top_dop          = "";
   TString need_dop         = "";

   if ( (StatIPObject != NULL) && (StatIPObject->GetStorage() != NULL) )
   {
   #ifdef _win_
               if (!filepath_t.empty())
               {
                  if (filepath_t.back() != '\\')
                     filepath_t = filepath_t + "\\";
               }
   #else
               if (!filepath_t.empty())
               {
                  if (filepath_t.back() != '/')
                     filepath_t = filepath_t + "/";
               }
   #endif
      filename = filepath_t + StatIPObject->GetStorage()->GetDBCollectionText(stortype, "_") + "_" + GetTimeOnlyFilenameArx(time(NULL)) + ".bdd";
      res += "Write dump " + StatIPObject->GetStorage()->GetDBCollectionText(stortype, "::") + ":";

      //get collection size
      tick = CShingleTime::GetMs();
      err  = false;
      collection_size = StatIPObject->GetStorage()->mongo_basa_size(stortype);
      tick = CShingleTime::GetMs() - tick;
      if (err)
      {
         res += " Size=???(FAILED, " + IntToStroka(tick) + " msec)";
         fullresok = false;

      } else
      {
         res += " Size=" + IntToStroka(collection_size) + "(OK, " + IntToStroka(tick) + " msec)";
      }

      //read collection
      tick = CShingleTime::GetMs();
      err  = false;
      StatIPObject->GetStorage()->spamstat_savedump(filename, stortype, err, report, top_treshold);

      readcount = report.fulldump_record_count;
      if (report.use_need)
         need_dop = ", needcount=" + UI64ToStroka(report.need_record_count);
      if (report.use_top)
         top_dop = ", topcount=" + UI64ToStroka(report.top_record_count) + " [trsh=" + UI64ToStrokaNum(report.top_treshold) + "]";

      tick = CShingleTime::GetMs() - tick;
      if (err)
      {
         res += ", Save " + UI64ToStroka(readcount) + " record (empty=" + UI64ToStroka(report.empty_data) + ", type_count=" + report.GetCountersByType() + ")" + need_dop + top_dop + " (FAILED, " + IntToStroka(tick) + " msec)";
         fullresok = false;

      } else
      {
         res += ", Save " + UI64ToStroka(readcount) + " record (empty=" + UI64ToStroka(report.empty_data) + ", type_count=" + report.GetCountersByType() + ")" + need_dop + top_dop + " (OK, " + IntToStroka(tick) + " msec)";
      }

      if ( (GetLogsGroup() != NULL) && (GetLogsGroup()->GetServerLog() != NULL) )
      {
         if (fullresok)
            GetLogsGroup()->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "%s", res.c_str());
         else
            GetLogsGroup()->GetServerLog()->WriteMessageAndDataStatus(KERROR, "%s", res.c_str());
      }
      if ( (GetLogsGroup() != NULL) && (GetLogsGroup()->StorageDumpLog() != NULL) )
      {
         if (fullresok)
            GetLogsGroup()->StorageDumpLog()->WriteMessageAndDataStatus(KMESSAGE, "%s", res.c_str());
         else
            GetLogsGroup()->StorageDumpLog()->WriteMessageAndDataStatus(KERROR, "%s", res.c_str());
      }
   }

   return res;
}

TString TGeneralObject::SaveMembasaDumpStorStep1(const TString &filepath, TStorageType stortype)
{
   TString res              = "";
   TString filename         = "";
   bool   err              = false;
   ui32   tick             = 0;
   TString filepath_t       = filepath;
   i64    collection_size  = 0;
   ui64   readcount        = 0;
   bool   fullresok        = true;
   TFindToFileReport report;
   TString top_dop          = "";
   TString need_dop         = "";

   if ( (StatIPObject != NULL) && (StatIPObject->GetStorage() != NULL) )
   {
   #ifdef _win_
               if (!filepath_t.empty())
               {
                  if (filepath_t.back() != '\\')
                     filepath_t = filepath_t + "\\";
               }
   #else
               if (!filepath_t.empty())
               {
                  if (filepath_t.back() != '/')
                     filepath_t = filepath_t + "/";
               }
   #endif
      filename = filepath_t + StatIPObject->GetStorage()->GetDBCollectionText(stortype, "_") + "_step1" + "_" + GetTimeOnlyFilenameArx(time(NULL)) + ".bdd";
      res += "Write dump " + StatIPObject->GetStorage()->GetDBCollectionText(stortype, "::") + "_step1" + ":";

      //get collection size
      tick = CShingleTime::GetMs();
      err  = false;
      collection_size = StatIPObject->GetStorage()->mongo_basa_size(stortype);
      tick = CShingleTime::GetMs() - tick;
      if (err)
      {
         res += " Size=???(FAILED, " + IntToStroka(tick) + " msec)";
         fullresok = false;

      } else
      {
         res += " Size=" + IntToStroka(collection_size) + "(OK, " + IntToStroka(tick) + " msec)";
      }

      //read collection
      tick = CShingleTime::GetMs();
      err  = false;
      StatIPObject->GetStorage()->spamstat_savedump_step1(filename, stortype, err, report);

      readcount = report.fulldump_record_count;
      if (report.use_need)
         need_dop = ", needcount=" + UI64ToStroka(report.need_record_count);

      tick = CShingleTime::GetMs() - tick;
      if (err)
      {
         res += ", Save " + UI64ToStroka(readcount) + " record (FAILED, " + IntToStroka(tick) + " msec)";
         fullresok = false;

      } else
      {
         res += ", Save " + UI64ToStroka(readcount) + " record (OK, " + IntToStroka(tick) + " msec)";
      }

      if ( (GetLogsGroup() != NULL) && (GetLogsGroup()->GetServerLog() != NULL) )
      {
         if (fullresok)
            GetLogsGroup()->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "%s", res.c_str());
         else
            GetLogsGroup()->GetServerLog()->WriteMessageAndDataStatus(KERROR, "%s", res.c_str());
      }
      if ( (GetLogsGroup() != NULL) && (GetLogsGroup()->StorageDumpLog() != NULL) )
      {
         if (fullresok)
            GetLogsGroup()->StorageDumpLog()->WriteMessageAndDataStatus(KMESSAGE, "%s", res.c_str());
         else
            GetLogsGroup()->StorageDumpLog()->WriteMessageAndDataStatus(KERROR, "%s", res.c_str());
      }
   }

   return res;
}

TString TGeneralObject::SaveMembasaDumpStorOnlyBanList(const TString &filepath, TStorageType stortype)
{
   TString res              = "";
   TString filename         = "";
   bool   err              = false;
   ui32   tick             = 0;
   TString filepath_t       = filepath;
   i64    collection_size  = 0;
   ui64   readcount        = 0;
   bool   fullresok        = true;
   TFindToFileReport report;
   TString top_dop          = "";
   TString need_dop         = "";

   if ( (StatIPObject != NULL) && (StatIPObject->GetStorage() != NULL) )
   {
   #ifdef _win_
               if (!filepath_t.empty())
               {
                  if (filepath_t.back() != '\\')
                     filepath_t = filepath_t + "\\";
               }
   #else
               if (!filepath_t.empty())
               {
                  if (filepath_t.back() != '/')
                     filepath_t = filepath_t + "/";
               }
   #endif
      filename = filepath_t + StatIPObject->GetStorage()->GetDBCollectionText(stortype, "_") + "_onlybanlist" + "_" + GetTimeOnlyFilenameArx(time(NULL)) + ".bdd";
      res += "Write dump " + StatIPObject->GetStorage()->GetDBCollectionText(stortype, "::") + "_onlybanlist" + ":";

      //get collection size
      tick = CShingleTime::GetMs();
      err  = false;
      collection_size = StatIPObject->GetStorage()->mongo_basa_size(stortype);
      tick = CShingleTime::GetMs() - tick;
      if (err)
      {
         res += " Size=???(FAILED, " + IntToStroka(tick) + " msec)";
         fullresok = false;

      } else
      {
         res += " Size=" + IntToStroka(collection_size) + "(OK, " + IntToStroka(tick) + " msec)";
      }

      //read collection
      tick = CShingleTime::GetMs();
      err  = false;
      StatIPObject->GetStorage()->spamstat_savedump_onlybanlist(filename, stortype, err, report);

      readcount = report.fulldump_record_count;
      if (report.use_need)
         need_dop = ", needcount=" + UI64ToStroka(report.need_record_count);

      tick = CShingleTime::GetMs() - tick;
      if (err)
      {
         res += ", Save " + UI64ToStroka(readcount) + " record (FAILED, " + IntToStroka(tick) + " msec)";
         fullresok = false;

      } else
      {
         res += ", Save " + UI64ToStroka(readcount) + " record (OK, " + IntToStroka(tick) + " msec)";
      }

      if ( (GetLogsGroup() != NULL) && (GetLogsGroup()->GetServerLog() != NULL) )
      {
         if (fullresok)
            GetLogsGroup()->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "%s", res.c_str());
         else
            GetLogsGroup()->GetServerLog()->WriteMessageAndDataStatus(KERROR, "%s", res.c_str());
      }
      if ( (GetLogsGroup() != NULL) && (GetLogsGroup()->StorageDumpLog() != NULL) )
      {
         if (fullresok)
            GetLogsGroup()->StorageDumpLog()->WriteMessageAndDataStatus(KMESSAGE, "%s", res.c_str());
         else
            GetLogsGroup()->StorageDumpLog()->WriteMessageAndDataStatus(KERROR, "%s", res.c_str());
      }
   }

   return res;
}


TString TGeneralObject::SaveDumpStorage()
{
   TString filepath      = "";
   TString text          = "";
   i64    top_treshold  = SPST_TOP_TRESHOLD;

   if (GetConfigObject() != NULL)
   {
      filepath       = GetConfigObject()->ReadStroka("nosql", "dumppath", "");
      top_treshold   = GetConfigObject()->ReadInteger("nosql", "top_treshold", SPST_TOP_TRESHOLD);
   }

   text += SaveDumpStor2(filepath, MST_BANSETUP, top_treshold) + "<br>";
   text += SaveDumpStor2(filepath, MST_BANIP, top_treshold) + "<br>";
   text += SaveDumpStor2(filepath, MST_BAN7IP, top_treshold) + "<br>";
   text += SaveDumpStor2(filepath, MST_MEMSTAT, top_treshold) + "<br>";
   text += SaveDumpStor2(filepath, MST_MEMBASE, top_treshold) + "<br>";

   return text;
}

TString TGeneralObject::SaveDumpStorageStep1()
{
   TString filepath      = "";
   TString text          = "";

   if (GetConfigObject() != NULL)
      filepath       = GetConfigObject()->ReadStroka("nosql", "dumppath", "");

   text += SaveMembasaDumpStorStep1(filepath, MST_BANIP) + "<br>";
   text += SaveMembasaDumpStorStep1(filepath, MST_BAN7IP) + "<br>";
   text += SaveMembasaDumpStorStep1(filepath, MST_MEMBASE) + "<br>";

   return text;
}

TString TGeneralObject::SaveDumpStorageOnlyBanList()
{
   TString filepath      = "";
   TString text          = "";

   if (GetConfigObject() != NULL)
      filepath       = GetConfigObject()->ReadStroka("nosql", "dumppath", "");

   text += SaveMembasaDumpStorOnlyBanList(filepath, MST_BANIP) + "<br>";
   text += SaveMembasaDumpStorOnlyBanList(filepath, MST_BAN7IP) + "<br>";

   return text;
}

TString TGeneralObject::ReadDumpStor2(ui32 threadcount, ui32 buffer_size, const TString &filepath, TStorageType stortype)
{
   TString         res         = "";
   TString         filename    = "";
   bool           err         = false;
   ui32           tick        = 0;
   TString         filepath_t  = filepath;
   TDumpReadClassMain *poolobj    = NULL;
   TLogClass      *log        = NULL;
   TString         ident       = "";
   bool           fok         = false;

#ifdef _win_
            if (!filepath_t.empty())
            {
               if (filepath_t.back() != '\\')
                  filepath_t = filepath_t + "\\";
            }
#else
            if (!filepath_t.empty())
            {
               if (filepath_t.back() != '/')
                  filepath_t = filepath_t + "/";
            }
#endif

   ident = StatIPObject->GetStorage()->GetDBCollectionText(stortype, "-");
   filename = filepath_t + StatIPObject->GetStorage()->GetDBCollectionText(stortype, "_") + ".bdd";

   if (GetLogsGroup() != NULL)
      log = GetLogsGroup()->StorageDumpLog();

   tick = CShingleTime::GetMs();

   poolobj = new TDumpReadClassMain();
   if (poolobj != NULL)
   {
      fok = poolobj->Init(StatIPObject, ident, threadcount, buffer_size, filename, log, stortype);
      if (fok)
         poolobj->Wait();

      delete poolobj;
      poolobj = NULL;
   }

   tick = CShingleTime::GetMs() - tick;
   if (fok)
      res += "Read dump " + StatIPObject->GetStorage()->GetDBCollectionText(stortype, "::") + " complete to " + IntToStroka(tick) + "ms";
   else
      res += "Read dump " + StatIPObject->GetStorage()->GetDBCollectionText(stortype, "::") + " FAILED to " + IntToStroka(tick) + "ms";

   return res;
}

TString TGeneralObject::DoReaddump()
{
   TString filepath      = "";
   TString text          = "";
   ui32   threadcount   = 0;
   ui32   buffer_size   = 0;

   if (GetConfigObject() != NULL)
   {
      filepath    = GetConfigObject()->ReadStroka("nosql", "dumppath", "");
      threadcount = GetConfigObject()->ReadInteger("nosql", "load_thread_count", 16);
      buffer_size = GetConfigObject()->ReadInteger("nosql", "load_buffer_size", 0);
   }

   text += ReadDumpStor2(threadcount, buffer_size, filepath, MST_BANSETUP) + "<br>";
   text += ReadDumpStor2(threadcount, buffer_size, filepath, MST_BANIP) + "<br>";
   text += ReadDumpStor2(threadcount, buffer_size, filepath, MST_BAN7IP) + "<br>";
   text += ReadDumpStor2(threadcount, buffer_size, filepath, MST_MEMSTAT) + "<br>";
   text += ReadDumpStor2(threadcount, buffer_size, filepath, MST_MEMBASE) + "<br>";

   return text;
}

//******************************************************************************************************************************************
