#pragma once

#include <mail/so/spamstop/tools/fcgiserver_base/tgeneralserviceobject.h>
#include <mail/so/spamstop/tools/so-common/tlogsgroupbase.h>
#include <mail/so/spamstop/tools/so-common/kfunc.h>
#include "tlogsgroup.h"
#include "tstatipobject.h"
#include "tdumpreadclass.h"

#define SPST_TOP_TRESHOLD 100000000

//******************************************************************************************************************************************
//                                                       TGeneralObject
//******************************************************************************************************************************************

class TGeneralObject: public TGeneralServiceObject
{
private:
         TLogsGroupBase *LogsGroup;
         TKConfig       *config;

         TLogsGroup     *GetLogsGroup();
         TKConfig       *GetConfigObject(){ return config; }

         TString         GetTimeOnlyFilenameArx(time_t ttek);
         TString         SaveTopStor2(const TString &filepath, TStorageType stortype, i64 top_treshold);
         TString         SaveDumpStor2(const TString &filepath, TStorageType stortype, i64 top_treshold);
         TString         ReadDumpStor2(ui32 threadcount, ui32 buffer_size, const TString &filepath, TStorageType stortype);
         TString         SaveMembasaDumpStorStep1(const TString &filepath, TStorageType stortype);
         TString         SaveMembasaDumpStorOnlyBanList(const TString &filepath, TStorageType stortype);

public:
         TGeneralObject();
         ~TGeneralObject();

         TStatIPObject *StatIPObject;

         bool           InitBeforeFork(const TString &server_id, TLogsGroupBase *LogsGroupA, TKConfig *configA);
         bool           InitAfterFork();

         bool           Midnight();
         bool           MidnightHeavy();
         bool           Shutdown();
         void           EventTick();
         void           EventTickHeavy();
         bool           Close();

         TString         SaveTopStorage(bool is_midnight);
         TString         SaveDumpStorage();
         TString         SaveDumpStorageStep1();
         TString         SaveDumpStorageOnlyBanList();
         TString         DoReaddump();
         TString         SaveIPDataFromStorage(TKIPv6 ip);
};

//******************************************************************************************************************************************
