#include "tkstrlist.h"

TKStrList::TKStrList()
{
   LogsGroup  = NULL;
   m_filename = "";
}

TKStrList::~TKStrList()
{

}

bool TKStrList::Init(const TString &filename, TLogsGroup *LogsGroupA)
{
   bool res = false;

   LogsGroup  = LogsGroupA;
   m_filename = filename;

   res = ReloadList();

   return res;
}

bool TKStrList::ReloadList()
{
   m_Mutex.Acquire();

   TString err_s = "";

   const auto newState = FileStateWasChanged(m_filename, m_filestat, err_s);

   if (!newState)
   {
       if ( (LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL) )
          LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "SHORTURLSERVICES: no changed.");

       m_Mutex.Release();
       return true;
   } else {
      m_filestat = *newState;
   }

   bool                 res = false;
   FILE                 *fhandle;
   char                 m_buff[SP_BUFF_SIZE];
   const char           *pbf;
   int                  len = 0;
   TKStrListHashIt      it;
   TString               rulename = "";
   ui32                 record = 0, recorddublicat = 0;

   data.clear();
   fhandle = fopen(m_filename.c_str(), "rb");
   if (fhandle != NULL)
   {
      memset(m_buff, 0, SP_BUFF_SIZE - 1);
      while (fgets(m_buff, SP_BUFF_SIZE - 1, fhandle))
      {
         SpTrim(m_buff, &pbf, &len);
         if (len < 1 || pbf[0] == '#')
            continue;

         record++;
         rulename = TString(pbf, len);
         it = data.find(rulename);
         if (it == data.end())
            data[rulename] = 0;
         else
            recorddublicat++;

         memset(m_buff, 0, SP_BUFF_SIZE - 1);
      }

      fclose(fhandle);

      if ( (LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL) )
         LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "SHORTURLSERVICES: Read file, records: %u, dublicat: %u", record, recorddublicat);
      res = true;
   }

   m_Mutex.Release();

   return res;
}

bool TKStrList::FindStroka(TString &s)
{
   bool             res   = false;
   TKStrListHashIt  it;
   //TString           stemp = "";
   //TString           st    = "";
   //bool             ok    = false;

   m_Mutex.Acquire();

/*   it = data.begin();
   while (it != data.end())
   {
      st = (*it).first;
      stemp = stemp + st + "\n";

      if (st == s)
         ok = true;
      else
         ok = false;

      ++it;
   }
*/

   it = data.find(s);
   if (it != data.end())
      res = true;

   m_Mutex.Release();

   return res;
}
