#include "tlogsgroup.h"

//****************************************************************************************************************************************
//                                              TLogsGroup
//****************************************************************************************************************************************

TLogsGroup::TLogsGroup()
{
   configobj               = NULL;
   m_ServerLog             = NULL;
   m_InputStreamLog        = NULL;
   m_DebugInfoLog          = NULL;
   /*m_ShinglesLog           = NULL;
   m_TraceLog              = NULL;
   m_ErrorLog              = NULL;
   */
   m_inputstreamlog_enable = false;
   m_ProtokolLog           = NULL;
   m_PBProtokolLog         = NULL;
   m_RejectLog             = NULL;
   m_StatLog               = NULL;
   m_Ban3mailLog           = NULL;
   m_ZonesLog              = NULL;
   m_DayLoghLog            = NULL;
   m_WhiteIpLog            = NULL;
   m_TmpBan30Log           = NULL;
   m_TraceIpLog            = NULL;
   m_MissingMessLog        = NULL;
   m_ActionLog             = NULL;
   m_FilterLog             = NULL;
   m_StatIPLog             = NULL;
   m_StatMPSLog            = NULL;
   m_SrvcErrorLog          = NULL;
   m_MonLog                = NULL;
   m_FollowLog             = NULL;
   m_StorageDumpLog        = NULL;
   m_MongoEventLog         = NULL;
   m_BanStepLog            = NULL;
}

TLogsGroup::~TLogsGroup()
{
   /*if (m_ErrorLog != NULL)
   {
      delete m_ErrorLog;
      m_ErrorLog = NULL;
   }
   if (m_TraceLog != NULL)
   {
      delete m_TraceLog;
      m_TraceLog = NULL;
   }
   if (m_ShinglesLog != NULL)
   {
      delete m_ShinglesLog;
      m_ShinglesLog = NULL;
   }*/

   if (m_BanStepLog != NULL)
   {
      delete m_BanStepLog;
      m_BanStepLog = NULL;
   }

   if (m_MongoEventLog != NULL)
   {
      delete m_MongoEventLog;
      m_MongoEventLog = NULL;
   }

   if (m_StorageDumpLog != NULL)
   {
      delete m_StorageDumpLog;
      m_StorageDumpLog = NULL;
   }

   if (m_FollowLog != NULL)
   {
      delete m_FollowLog;
      m_FollowLog = NULL;
   }

   if (m_MonLog != NULL)
   {
      delete m_MonLog;
      m_MonLog = NULL;
   }

   if (m_SrvcErrorLog != NULL)
   {
      delete m_SrvcErrorLog;
      m_SrvcErrorLog = NULL;
   }

   if (m_StatMPSLog != NULL)
   {
      delete m_StatMPSLog;
      m_StatMPSLog = NULL;
   }

   if (m_StatIPLog != NULL)
   {
      delete m_StatIPLog;
      m_StatIPLog = NULL;
   }

   if (m_FilterLog != NULL)
   {
      delete m_FilterLog;
      m_FilterLog = NULL;
   }

   if (m_ActionLog != NULL)
   {
      delete m_ActionLog;
      m_ActionLog = NULL;
   }

   if (m_MissingMessLog != NULL)
   {
      delete m_MissingMessLog;
      m_MissingMessLog = NULL;
   }

   if (m_TraceIpLog != NULL)
   {
      delete m_TraceIpLog;
      m_TraceIpLog = NULL;
   }
   if (m_TmpBan30Log != NULL)
   {
      delete m_TmpBan30Log;
      m_TmpBan30Log = NULL;
   }
   if (m_WhiteIpLog != NULL)
   {
      delete m_WhiteIpLog;
      m_WhiteIpLog = NULL;
   }
   if (m_DayLoghLog != NULL)
   {
      delete m_DayLoghLog;
      m_DayLoghLog = NULL;
   }
   if (m_ZonesLog != NULL)
   {
      delete m_ZonesLog;
      m_ZonesLog = NULL;
   }
   if (m_Ban3mailLog != NULL)
   {
      delete m_Ban3mailLog;
      m_Ban3mailLog = NULL;
   }
   if (m_StatLog != NULL)
   {
      delete m_StatLog;
      m_StatLog = NULL;
   }
   if (m_RejectLog != NULL)
   {
      delete m_RejectLog;
      m_RejectLog = NULL;
   }
   if (m_PBProtokolLog != NULL)
   {
      delete m_PBProtokolLog;
      m_PBProtokolLog = NULL;
   }
   if (m_ProtokolLog != NULL)
   {
      delete m_ProtokolLog;
      m_ProtokolLog = NULL;
   }

   if (m_ServerLog != NULL)
   {
      delete m_ServerLog;
      m_ServerLog = NULL;
   }

   if (m_DebugInfoLog != NULL)
   {
      delete m_DebugInfoLog;
      m_DebugInfoLog = NULL;
   }

   if (m_InputStreamLog != NULL)
   {
      delete m_InputStreamLog;
      m_InputStreamLog = NULL;
   }
}

bool TLogsGroup::Init(TKConfig *configobjA)
{
   bool   res                    = true;
   TString serverlog_name         = "";
   TString inputstreamlog_name    = "";
   bool   debugmode              = false;
   TString protokollog            = "";
   TString pbprotokollog          = "";
   TString rejectlog              = "";
   TString statlog                = "";
   TString ban3maillog            = "";
   TString zoneslog               = "";
   TString dayloghlog             = "";
   TString whiteiplog             = "";
   TString tmpban30log            = "";
   TString traceiplog             = "";
   TString missingmesslog         = "";
   TString actionlog              = "";
   TString deliverylog            = "";
   TString filterlog              = "";
   TString statiplog              = "";
   TString statmpslog             = "";
   TString srvcerrorlog           = "";
   TString debuginfolog_name      = "";
   TString monlog                 = "";
   TString followlog              = "";
   TString storagedumplog         = "";
   TString mongoeventlog          = "";
   TString bansteplog             = "";
   bool   protokollog_enable     = false;
   bool   pbprotokollog_enable   = false;
   bool   rejectlog_enable       = false;
   bool   statlog_enable         = false;
   bool   ban3maillog_enable     = false;
   bool   zoneslog_enable        = false;
   bool   dayloghlog_enable      = false;
   bool   whiteiplog_enable      = false;
   bool   tmpban30log_enable     = false;
   bool   traceiplog_enable      = false;
   bool   missingmesslog_enable  = false;
   bool   actionlog_enable       = false;
   bool   deliverylog_enable     = false;
   bool   filterlog_enable       = false;
   bool   statiplog_enable       = false;
   bool   statmpslog_enable      = false;
   bool   srvcerrorlog_enable    = false;
   bool   logs_flush             = false;

   configobj = configobjA;
   if (configobj != NULL)
   {
      logs_flush              = configobj->ReadBool("logs", "flush", false);
      serverlog_name          = configobj->ReadStroka("server", "server_log_file", "");
      inputstreamlog_name     = configobj->ReadStroka("server", "inputstreamlog", "");
      debuginfolog_name       = configobj->ReadStroka("logs", "debuginfolog", "");
      m_inputstreamlog_enable = configobj->ReadBool("server", "inputstreamlog_enable", false);
      debugmode               = configobj->ReadBool("server", "debug_mode", false);
      protokollog             = configobj->ReadStroka("logs", "protokol", "");
      protokollog_enable      = configobj->ReadBool("logs", "enable_protokol", "");
      pbprotokollog           = configobj->ReadStroka("logs", "pb_protokol", "");
      pbprotokollog_enable    = configobj->ReadBool("logs", "enable_pbprotokol", true);
      rejectlog               = configobj->ReadStroka("logs", "reject", "");
      rejectlog_enable        = configobj->ReadBool("logs", "enable_reject", true);
      statlog                 = configobj->ReadStroka("logs", "stat", "");
      statlog_enable          = configobj->ReadBool("logs", "enable_stat", true);
      ban3maillog             = configobj->ReadStroka("logs", "ban3mail", "");
      ban3maillog_enable      = configobj->ReadBool("logs", "enable_ban3log", true);
      zoneslog                = configobj->ReadStroka("logs", "zones", "");
      zoneslog_enable         = configobj->ReadBool("logs", "enable_zones", true);
      dayloghlog              = configobj->ReadStroka("logs", "daylogh", "");
      dayloghlog_enable       = configobj->ReadBool("logs", "enable_daylogh", true);
      whiteiplog              = configobj->ReadStroka("logs", "whiteip", "");
      whiteiplog_enable       = configobj->ReadBool("logs", "enable_whitelog", true);
      tmpban30log             = configobj->ReadStroka("logs", "tmpban30", "");
      tmpban30log_enable      = configobj->ReadBool("logs", "enable_tmpban30", true);
      traceiplog              = configobj->ReadStroka("logs", "traceip", "");
      traceiplog_enable       = configobj->ReadBool("logs", "enable_traceip", true);
      missingmesslog          = configobj->ReadStroka("logs", "missingmess", "");
      missingmesslog_enable   = configobj->ReadBool("logs", "enable_misslog", true);
      actionlog               = configobj->ReadStroka("logs", "actionlog", "");
      actionlog_enable        = configobj->ReadBool("logs", "enable_actionlog", true);
      deliverylog             = configobj->ReadStroka("filter", "kDeliveryLog", "");
      deliverylog_enable      = configobj->ReadBool("filter", "enable_dlvlog", true);
      filterlog               = configobj->ReadStroka("filter", "kFilterLog", "");
      filterlog_enable        = configobj->ReadBool("filter", "enable_filterlog", true);
      statiplog               = configobj->ReadStroka("logs", "statiplog", "");
      statiplog_enable        = configobj->ReadBool("logs", "enable_statip", true);
      statmpslog              = configobj->ReadStroka("logs", "statmpslog", "");
      statmpslog_enable       = configobj->ReadBool("logs", "enable_statmps", true);
      srvcerrorlog            = configobj->ReadStroka("logs", "srvcerrorlog", "");
      srvcerrorlog_enable     = configobj->ReadBool("logs", "enable_srvcerrorlog", true);
      monlog                  = configobj->ReadStroka("logs", "monlog", "");
      followlog               = configobj->ReadStroka("logs", "followlog", "");
      storagedumplog          = configobj->ReadStroka("nosql", "dumplog", "");
      mongoeventlog           = configobj->ReadStroka("logs", "mongoeventlog", "");
      bansteplog              = configobj->ReadStroka("logs", "bansteplog", "");

      SetDebugMode(debugmode);

      if (!serverlog_name.empty())
      {
         m_ServerLog = new TLogClass(serverlog_name, true);
         if ( (m_ServerLog != NULL) && (logs_flush) )
            m_ServerLog->SetDisableFFlush(false);
      }

      if (!inputstreamlog_name.empty())
      {
         m_InputStreamLog = new TLogClass(inputstreamlog_name, true);
         if (m_InputStreamLog != NULL)
         {
            if (m_inputstreamlog_enable/* && debugmode*/)
               m_InputStreamLog->EnableWrite();
            else
               m_InputStreamLog->DisableWrite();

            if ( (m_InputStreamLog != NULL) && (logs_flush) )
               m_InputStreamLog->SetDisableFFlush(false);

         }
      }

      if (!debuginfolog_name.empty())
      {
         m_DebugInfoLog = new TLogClass(debuginfolog_name, false);
         if (m_DebugInfoLog != NULL)
         {
            m_DebugInfoLog->EnableWrite();
            if ( (m_DebugInfoLog != NULL) && (logs_flush) )
               m_DebugInfoLog->SetDisableFFlush(false);

         }
      }

      if (!protokollog.empty())
      {
         m_ProtokolLog = new TLogClass(protokollog, true);
         if (m_ProtokolLog != NULL)
         {
            if (protokollog_enable)
               m_ProtokolLog->EnableWrite();
            else
               m_ProtokolLog->DisableWrite();

            if (m_ProtokolLog != NULL)
               m_ProtokolLog->SetDisableFFlush(false);

         }
      }

      if (!pbprotokollog.empty())
      {
         m_PBProtokolLog = new TLogClass(pbprotokollog, true);
         if (m_PBProtokolLog != NULL)
         {
            if (pbprotokollog_enable)
               m_PBProtokolLog->EnableWrite();
            else
               m_PBProtokolLog->DisableWrite();

            if (m_PBProtokolLog != NULL)
               m_PBProtokolLog->SetDisableFFlush(false);

         }
      }

      if (!rejectlog.empty())
      {
         m_RejectLog = new TLogClass(rejectlog, true);
         if (m_RejectLog != NULL)
         {
            if (rejectlog_enable)
               m_RejectLog->EnableWrite();
            else
               m_RejectLog->DisableWrite();

            if ( (m_RejectLog != NULL) && (logs_flush) )
               m_RejectLog->SetDisableFFlush(false);

         }
      }

      if (!statlog.empty())
      {
         m_StatLog = new TLogClass(statlog, true);
         if (m_StatLog != NULL)
         {
            if (statlog_enable)
               m_StatLog->EnableWrite();
            else
               m_StatLog->DisableWrite();

            if ( (m_StatLog != NULL) && (logs_flush) )
               m_StatLog->SetDisableFFlush(false);

         }
      }

      if (!ban3maillog.empty())
      {
         m_Ban3mailLog = new TLogClass(ban3maillog, true);
         if (m_Ban3mailLog != NULL)
         {
            if (ban3maillog_enable)
               m_Ban3mailLog->EnableWrite();
            else
               m_Ban3mailLog->DisableWrite();

            if ( (m_Ban3mailLog != NULL) && (logs_flush) )
               m_Ban3mailLog->SetDisableFFlush(false);

         }
      }

      if (!zoneslog.empty())
      {
         m_ZonesLog = new TLogClass(zoneslog, true);
         if (m_ZonesLog != NULL)
         {
            if (zoneslog_enable)
               m_ZonesLog->EnableWrite();
            else
               m_ZonesLog->DisableWrite();

            if ( (m_ZonesLog != NULL) && (logs_flush) )
               m_ZonesLog->SetDisableFFlush(false);

         }
      }

      if (!dayloghlog.empty())
      {
         m_DayLoghLog = new TLogClass(dayloghlog, true);
         if (m_DayLoghLog != NULL)
         {
            if (dayloghlog_enable)
               m_DayLoghLog->EnableWrite();
            else
               m_DayLoghLog->DisableWrite();

            if ( (m_DayLoghLog != NULL) && (logs_flush) )
               m_DayLoghLog->SetDisableFFlush(false);

         }
      }

      if (!whiteiplog.empty())
      {
         m_WhiteIpLog = new TLogClass(whiteiplog, true);
         if (m_WhiteIpLog != NULL)
         {
            if (whiteiplog_enable)
               m_WhiteIpLog->EnableWrite();
            else
               m_WhiteIpLog->DisableWrite();

            if ( (m_WhiteIpLog != NULL) && (logs_flush) )
               m_WhiteIpLog->SetDisableFFlush(false);

         }
      }

      if (!tmpban30log.empty())
      {
         m_TmpBan30Log = new TLogClass(tmpban30log, true);
         if (m_TmpBan30Log != NULL)
         {
            if (tmpban30log_enable)
               m_TmpBan30Log->EnableWrite();
            else
               m_TmpBan30Log->DisableWrite();

            if ( (m_TmpBan30Log != NULL) && (logs_flush) )
               m_TmpBan30Log->SetDisableFFlush(false);

         }
      }

      if (!traceiplog.empty())
      {
         m_TraceIpLog = new TLogClass(traceiplog, true);
         if (m_TraceIpLog != NULL)
         {
            if (traceiplog_enable)
               m_TraceIpLog->EnableWrite();
            else
               m_TraceIpLog->DisableWrite();

            if ( (m_TraceIpLog != NULL) && (logs_flush) )
               m_TraceIpLog->SetDisableFFlush(false);

         }
      }

      if (!missingmesslog.empty())
      {
         m_MissingMessLog = new TLogClass(missingmesslog, true);
         if (m_MissingMessLog != NULL)
         {
            if (missingmesslog_enable)
               m_MissingMessLog->EnableWrite();
            else
               m_MissingMessLog->DisableWrite();

            if ( (m_MissingMessLog != NULL) && (logs_flush) )
               m_MissingMessLog->SetDisableFFlush(false);

         }
      }

      if (!actionlog.empty())
      {
         m_ActionLog = new TLogClass(actionlog, true);
         if (m_ActionLog != NULL)
         {
            if (actionlog_enable)
               m_ActionLog->EnableWrite();
            else
               m_ActionLog->DisableWrite();

            if ( (m_ActionLog != NULL) && (logs_flush) )
               m_ActionLog->SetDisableFFlush(false);

         }
      }


      if (deliverylog) {
          DelivryLog.ResetBackend(CreateOwningThreadedLogBackend(deliverylog, TLOG_RESOURCES));
      }

      if (!filterlog.empty())
      {
         m_FilterLog = new TLogClass(filterlog, true);
         if (m_FilterLog != NULL)
         {
            if (filterlog_enable)
               m_FilterLog->EnableWrite();
            else
               m_FilterLog->DisableWrite();

            if ( (m_FilterLog != NULL) && (logs_flush) )
               m_FilterLog->SetDisableFFlush(false);

         }
      }

      if (!statiplog.empty())
      {
         m_StatIPLog = new TLogClass(statiplog, true);
         if (m_StatIPLog != NULL)
         {
            if (statiplog_enable)
               m_StatIPLog->EnableWrite();
            else
               m_StatIPLog->DisableWrite();

            if ( (m_StatIPLog != NULL) && (logs_flush) )
               m_StatIPLog->SetDisableFFlush(false);

         }
      }

      if (!statmpslog.empty())
      {
         m_StatMPSLog = new TLogClass(statmpslog, true);
         if (m_StatMPSLog != NULL)
         {
            if (statmpslog_enable)
               m_StatMPSLog->EnableWrite();
            else
               m_StatMPSLog->DisableWrite();

            if ( (m_StatMPSLog != NULL) && (logs_flush) )
               m_StatMPSLog->SetDisableFFlush(false);

         }
      }

      if (!srvcerrorlog.empty())
      {
         m_SrvcErrorLog = new TLogClass(srvcerrorlog, true);
         if (m_SrvcErrorLog != NULL)
         {
            if (srvcerrorlog_enable)
               m_SrvcErrorLog->EnableWrite();
            else
               m_SrvcErrorLog->DisableWrite();

            if ( (m_SrvcErrorLog != NULL) && (logs_flush) )
               m_SrvcErrorLog->SetDisableFFlush(false);

         }
      }

      if (!monlog.empty())
      {
         m_MonLog = new TLogClass(monlog, true, "#<SeRVeRid:xxxx-xxx><CLUSTer(all/lost):XX/XX><GetIpStat(all/lost):XX/XX><GetForFrodo(all/lost):XX/XX><RULeS(uniqpartcount/allcall):XX/XX><WHiTeipcount:XX><ISBANipcount:XX><ReJecTcount:XX><ACTionBANip:XX><IPV6count:XX><ChangeDayCount:XX/XX>\n");
         if (m_MonLog != NULL)
            m_MonLog->EnableWrite();

         if ( (m_MonLog != NULL) && (logs_flush) )
            m_MonLog->SetDisableFFlush(false);

      }

      if (!followlog.empty())
      {
         m_FollowLog = new TLogClass(followlog, true);
         if (m_FollowLog != NULL)
            m_FollowLog->EnableWrite();

         if ( (m_FollowLog != NULL) && (logs_flush) )
            m_FollowLog->SetDisableFFlush(false);

      }

      if (!storagedumplog.empty())
      {
         m_StorageDumpLog = new TLogClass(storagedumplog, true);
         if (m_StorageDumpLog != NULL)
            m_StorageDumpLog->EnableWrite();

         if ( (m_StorageDumpLog != NULL) && (logs_flush) )
            m_StorageDumpLog->SetDisableFFlush(false);

      }

      if (!mongoeventlog.empty())
      {
         m_MongoEventLog = new TLogClass(mongoeventlog, true);
         if (m_MongoEventLog != NULL)
            m_MongoEventLog->EnableWrite();

         if ( (m_MongoEventLog != NULL) && (logs_flush) )
            m_MongoEventLog->SetDisableFFlush(false);

      }

      if (!bansteplog.empty())
      {
         m_BanStepLog = new TLogClass(bansteplog, true);
         if (m_BanStepLog != NULL)
            m_BanStepLog->EnableWrite();

         if ( (m_BanStepLog != NULL) && (logs_flush) )
            m_BanStepLog->SetDisableFFlush(false);

      }


   }

   return res;
}

void TLogsGroup::WriteFlushStatus()
{
   if ( (m_ServerLog != NULL) && (m_InputStreamLog != NULL) && (m_InputStreamLog->GetWriteStatus()) )
      m_ServerLog->WriteMessageAndDataStatus(KMESSAGE, "LOGSGROUP: InputStreamLog %s", m_InputStreamLog->FFlushStatus().c_str());

   if ( (m_ServerLog != NULL) && (m_DebugInfoLog != NULL) && (m_DebugInfoLog->GetWriteStatus()) )
      m_ServerLog->WriteMessageAndDataStatus(KMESSAGE, "LOGSGROUP: DebugInfoLog %s", m_DebugInfoLog->FFlushStatus().c_str());

   if ( (m_ServerLog != NULL) && (m_ProtokolLog != NULL) && (m_ProtokolLog->GetWriteStatus()) )
      m_ServerLog->WriteMessageAndDataStatus(KMESSAGE, "LOGSGROUP: ProtokolLog %s", m_ProtokolLog->FFlushStatus().c_str());

   if ( (m_ServerLog != NULL) && (m_PBProtokolLog != NULL) && (m_PBProtokolLog->GetWriteStatus()) )
      m_ServerLog->WriteMessageAndDataStatus(KMESSAGE, "LOGSGROUP: PBProtokolLog %s", m_PBProtokolLog->FFlushStatus().c_str());

   if ( (m_ServerLog != NULL) && (m_RejectLog != NULL) && (m_RejectLog->GetWriteStatus()) )
      m_ServerLog->WriteMessageAndDataStatus(KMESSAGE, "LOGSGROUP: RejectLog %s", m_RejectLog->FFlushStatus().c_str());

   if ( (m_ServerLog != NULL) && (m_StatLog != NULL) && (m_StatLog->GetWriteStatus()) )
      m_ServerLog->WriteMessageAndDataStatus(KMESSAGE, "LOGSGROUP: StatLog %s", m_StatLog->FFlushStatus().c_str());

   if ( (m_ServerLog != NULL) && (m_Ban3mailLog != NULL) && (m_Ban3mailLog->GetWriteStatus()) )
      m_ServerLog->WriteMessageAndDataStatus(KMESSAGE, "LOGSGROUP: Ban3mailLog %s", m_Ban3mailLog->FFlushStatus().c_str());

   if ( (m_ServerLog != NULL) && (m_ZonesLog != NULL) && (m_ZonesLog->GetWriteStatus()) )
      m_ServerLog->WriteMessageAndDataStatus(KMESSAGE, "LOGSGROUP: ZonesLog %s", m_ZonesLog->FFlushStatus().c_str());

   if ( (m_ServerLog != NULL) && (m_DayLoghLog != NULL) && (m_DayLoghLog->GetWriteStatus()) )
      m_ServerLog->WriteMessageAndDataStatus(KMESSAGE, "LOGSGROUP: DayLoghLog %s", m_DayLoghLog->FFlushStatus().c_str());

   if ( (m_ServerLog != NULL) && (m_WhiteIpLog != NULL) && (m_WhiteIpLog->GetWriteStatus()) )
      m_ServerLog->WriteMessageAndDataStatus(KMESSAGE, "LOGSGROUP: WhiteIpLog %s", m_WhiteIpLog->FFlushStatus().c_str());

   if ( (m_ServerLog != NULL) && (m_TmpBan30Log != NULL) && (m_TmpBan30Log->GetWriteStatus()) )
      m_ServerLog->WriteMessageAndDataStatus(KMESSAGE, "LOGSGROUP: TmpBan30Log %s", m_TmpBan30Log->FFlushStatus().c_str());

   if ( (m_ServerLog != NULL) && (m_TraceIpLog != NULL) && (m_TraceIpLog->GetWriteStatus()) )
      m_ServerLog->WriteMessageAndDataStatus(KMESSAGE, "LOGSGROUP: TraceIpLog %s", m_TraceIpLog->FFlushStatus().c_str());

   if ( (m_ServerLog != NULL) && (m_MissingMessLog != NULL) && (m_MissingMessLog->GetWriteStatus()) )
      m_ServerLog->WriteMessageAndDataStatus(KMESSAGE, "LOGSGROUP: MissingMessLog %s", m_MissingMessLog->FFlushStatus().c_str());

   if ( (m_ServerLog != NULL) && (m_ActionLog != NULL) && (m_ActionLog->GetWriteStatus()) )
      m_ServerLog->WriteMessageAndDataStatus(KMESSAGE, "LOGSGROUP: ActionLog %s", m_ActionLog->FFlushStatus().c_str());

   if ( (m_ServerLog != NULL) && (m_FilterLog != NULL) && (m_FilterLog->GetWriteStatus()) )
      m_ServerLog->WriteMessageAndDataStatus(KMESSAGE, "LOGSGROUP: FilterLog %s", m_FilterLog->FFlushStatus().c_str());

   if ( (m_ServerLog != NULL) && (m_StatIPLog != NULL) && (m_StatIPLog->GetWriteStatus()) )
      m_ServerLog->WriteMessageAndDataStatus(KMESSAGE, "LOGSGROUP: StatIPLog %s", m_StatIPLog->FFlushStatus().c_str());

   if ( (m_ServerLog != NULL) && (m_StatMPSLog != NULL) && (m_StatMPSLog->GetWriteStatus()) )
      m_ServerLog->WriteMessageAndDataStatus(KMESSAGE, "LOGSGROUP: StatMPSLog %s", m_StatMPSLog->FFlushStatus().c_str());

   if ( (m_ServerLog != NULL) && (m_SrvcErrorLog != NULL) && (m_SrvcErrorLog->GetWriteStatus()) )
      m_ServerLog->WriteMessageAndDataStatus(KMESSAGE, "LOGSGROUP: SrvcErrorLog %s", m_SrvcErrorLog->FFlushStatus().c_str());

   if ( (m_ServerLog != NULL) && (m_MonLog != NULL) && (m_MonLog->GetWriteStatus()) )
      m_ServerLog->WriteMessageAndDataStatus(KMESSAGE, "LOGSGROUP: MonLog %s", m_MonLog->FFlushStatus().c_str());

   if ( (m_ServerLog != NULL) && (m_FollowLog != NULL) && (m_FollowLog->GetWriteStatus()) )
      m_ServerLog->WriteMessageAndDataStatus(KMESSAGE, "LOGSGROUP: FollowLog %s", m_FollowLog->FFlushStatus().c_str());

   if ( (m_ServerLog != NULL) && (m_StorageDumpLog != NULL) && (m_StorageDumpLog->GetWriteStatus()) )
      m_ServerLog->WriteMessageAndDataStatus(KMESSAGE, "LOGSGROUP: StorageDumpLog %s", m_StorageDumpLog->FFlushStatus().c_str());

   if ( (m_ServerLog != NULL) && (m_MongoEventLog != NULL) && (m_MongoEventLog->GetWriteStatus()) )
      m_ServerLog->WriteMessageAndDataStatus(KMESSAGE, "LOGSGROUP: MongoEventLog %s", m_MongoEventLog->FFlushStatus().c_str());

   if ( (m_ServerLog != NULL) && (m_BanStepLog != NULL) && (m_BanStepLog->GetWriteStatus()) )
      m_ServerLog->WriteMessageAndDataStatus(KMESSAGE, "LOGSGROUP: BanStepLog %s", m_BanStepLog->FFlushStatus().c_str());


}

void TLogsGroup::Midnight()
{
   TruncLog();
}

bool TLogsGroup::TruncLog()
{
   bool res = true;

   if (m_InputStreamLog != NULL)
      if (!m_InputStreamLog->TruncLog())
         res = false;

   if (m_DebugInfoLog != NULL)
      if (!m_DebugInfoLog->TruncLog())
         res = false;

   if (m_ServerLog != NULL)
      if (!m_ServerLog->TruncLog())
         res = false;

   if (m_ProtokolLog != NULL)
      if (!m_ProtokolLog->TruncLog())
         res = false;

   if (m_PBProtokolLog != NULL)
      if (!m_PBProtokolLog->TruncLog())
         res = false;

   if (m_RejectLog != NULL)
      if (!m_RejectLog->TruncLog())
         res = false;

   if (m_StatLog != NULL)
      if (!m_StatLog->TruncLog())
         res = false;

   if (m_Ban3mailLog != NULL)
      if (!m_Ban3mailLog->TruncLog())
         res = false;

   if (m_ZonesLog != NULL)
      if (!m_ZonesLog->TruncLog())
         res = false;

   if (m_DayLoghLog != NULL)
      if (!m_DayLoghLog->TruncLog())
         res = false;

   if (m_WhiteIpLog != NULL)
      if (!m_WhiteIpLog->TruncLog())
         res = false;

   if (m_TmpBan30Log != NULL)
      if (!m_TmpBan30Log->TruncLog())
         res = false;

   if (m_TraceIpLog != NULL)
      if (!m_TraceIpLog->TruncLog())
         res = false;

   if (m_MissingMessLog != NULL)
      if (!m_MissingMessLog->TruncLog())
         res = false;

   if (m_ActionLog != NULL)
      if (!m_ActionLog->TruncLog())
         res = false;

   DelivryLog.ReopenLog();

   if (m_FilterLog != NULL)
      if (!m_FilterLog->TruncLog())
         res = false;

   if (m_StatIPLog != NULL)
      if (!m_StatIPLog->TruncLog())
         res = false;

   if (m_StatMPSLog != NULL)
      if (!m_StatMPSLog->TruncLog())
         res = false;

   if (m_SrvcErrorLog != NULL)
      if (!m_SrvcErrorLog->TruncLog())
         res = false;

   if (m_MonLog != NULL)
      if (!m_MonLog->TruncLog())
         res = false;

   if (m_FollowLog != NULL)
      if (!m_FollowLog->TruncLog())
         res = false;

   if (m_StorageDumpLog != NULL)
      if (!m_StorageDumpLog->TruncLog())
         res = false;

   if (m_MongoEventLog != NULL)
      if (!m_MongoEventLog->TruncLog())
         res = false;

   if (m_BanStepLog != NULL)
      if (!m_BanStepLog->TruncLog())
         res = false;

   return res;
}

void TLogsGroup::DisableFFlush(bool dsb)
{
   if (m_InputStreamLog != NULL)
      m_InputStreamLog->SetDisableFFlush(dsb);

   if (m_DebugInfoLog != NULL)
      m_DebugInfoLog->SetDisableFFlush(dsb);

   if (m_ServerLog != NULL)
      m_ServerLog->SetDisableFFlush(dsb);

   if (m_ProtokolLog != NULL)
      m_ProtokolLog->SetDisableFFlush(dsb);

   if (m_PBProtokolLog != NULL)
      m_PBProtokolLog->SetDisableFFlush(dsb);

   if (m_RejectLog != NULL)
      m_RejectLog->SetDisableFFlush(dsb);

   if (m_StatLog != NULL)
      m_StatLog->SetDisableFFlush(dsb);

   if (m_Ban3mailLog != NULL)
      m_Ban3mailLog->SetDisableFFlush(dsb);

   if (m_ZonesLog != NULL)
      m_ZonesLog->SetDisableFFlush(dsb);

   if (m_DayLoghLog != NULL)
      m_DayLoghLog->SetDisableFFlush(dsb);

   if (m_WhiteIpLog != NULL)
      m_WhiteIpLog->SetDisableFFlush(dsb);

   if (m_TmpBan30Log != NULL)
      m_TmpBan30Log->SetDisableFFlush(dsb);

   if (m_TraceIpLog != NULL)
      m_TraceIpLog->SetDisableFFlush(dsb);

   if (m_MissingMessLog != NULL)
      m_MissingMessLog->SetDisableFFlush(dsb);

   if (m_ActionLog != NULL)
      m_ActionLog->SetDisableFFlush(dsb);

   if (m_FilterLog != NULL)
      m_FilterLog->SetDisableFFlush(dsb);

   if (m_StatIPLog != NULL)
      m_StatIPLog->SetDisableFFlush(dsb);

   if (m_StatMPSLog != NULL)
      m_StatMPSLog->SetDisableFFlush(dsb);

   if (m_SrvcErrorLog != NULL)
      m_SrvcErrorLog->SetDisableFFlush(dsb);

   if (m_MonLog != NULL)
      m_MonLog->SetDisableFFlush(dsb);

   if (m_FollowLog != NULL)
      m_FollowLog->SetDisableFFlush(dsb);

   if (m_StorageDumpLog != NULL)
      m_StorageDumpLog->SetDisableFFlush(dsb);

   if (m_MongoEventLog != NULL)
      m_MongoEventLog->SetDisableFFlush(dsb);

   if (m_BanStepLog != NULL)
      m_BanStepLog->SetDisableFFlush(dsb);

}

/*
void TLogsGroup::SetDebugMode(bool debug)
{
   m_DebugMutex.Acquire();

   m_debug_mode = debug;

   if (m_InputStreamLog != NULL)
   {
      if (m_inputstreamlog_enable && debug)
         m_InputStreamLog->EnableWrite();
      else
         m_InputStreamLog->DisableWrite();
   }

   m_DebugMutex.Release();
}*/

//****************************************************************************************************************************************
//                                              ��������� TLogsGroup
//****************************************************************************************************************************************

TLogsGroupFake::TLogsGroupFake()
{
   m_ServerLog   = NULL;
   m_DeliveryLog = NULL;
   m_FilterLog   = NULL;
}

TLogsGroupFake::~TLogsGroupFake()
{


}

bool TLogsGroupFake::Init(TBaseLogClass *ServerLogA, TBaseLogClass *DeliveryLogA, TBaseLogClass *FilterLogA)
{
   m_ServerLog   = ServerLogA;
   m_DeliveryLog = DeliveryLogA;
   m_FilterLog   = FilterLogA;

   return true;
}

//******************************************************************************************************************************************
