#pragma once

#include <util/generic/string.h>
#include "util/system/mutex.h"
#include <mail/so/spamstop/tools/so-common/tkinifile.h>
#include <mail/so/spamstop/tools/so-common/tkconfig.h>
#include <mail/so/spamstop/tools/so-common/tlogclass.h>
#include <mail/so/spamstop/tools/so-common/tlogsgroupbase.h>

#define deliverykey "delivery_log"
#define statsokey   "statso_log"
#define controlkey  "control_log"

//****************************************************************************************************************************************
//                                              TLogsGroup
//****************************************************************************************************************************************

class TLogsGroup: public TLogsGroupBase
{
private:
         TKConfig     *configobj;

         TLogClass      *m_InputStreamLog;
         TLogClass      *m_DebugInfoLog;
         TLogClass      *m_ServerLog;
         TLogClass      *m_ProtokolLog;
         TLogClass      *m_PBProtokolLog;
         TLogClass      *m_RejectLog;
         TLogClass      *m_StatLog;
         TLogClass      *m_Ban3mailLog;
         TLogClass      *m_ZonesLog;
         TLogClass      *m_DayLoghLog;
         TLogClass      *m_WhiteIpLog;
         TLogClass      *m_TmpBan30Log;
         TLogClass      *m_TraceIpLog;
         TLogClass      *m_MissingMessLog;
         TLogClass      *m_ActionLog;
         TLogClass      *m_FilterLog;
         TLogClass      *m_StatIPLog;
         TLogClass      *m_StatMPSLog;
         TLogClass      *m_SrvcErrorLog;
         TLogClass      *m_MonLog;
         TLogClass      *m_FollowLog;
         TLogClass      *m_StorageDumpLog;
         /*TLogClass      *m_ServerLog;
         TLogClass      *m_InputStreamLog;
         TLogClass      *m_ShinglesLog;
         TLogClass      *m_TraceLog;
         TLogClass      *m_ErrorLog;*/
         TLogClass      *m_MongoEventLog;
         TLogClass      *m_BanStepLog;

         //bool           m_debug_mode;
         TMutex         m_DebugMutex;
         bool           m_inputstreamlog_enable;
public:
         TLogsGroup();
         ~TLogsGroup();

         TLog        DelivryLog;

         bool Init(TKConfig *configobjA);

         TLogClass   *GetInputStreamLog() { return m_InputStreamLog; }
         TLogClass   *GetLongRequestLog() { return NULL;             }
         TLogClass   *GetDebugInfoLog()   { return m_DebugInfoLog;   }
         TLogClass   *GetInputLog()       { return m_InputStreamLog; }
         TLogClass   *GetServerLog()      { return m_ServerLog;      }
         TLogClass   *GetStorageLog()     { return NULL;             }
         TLogClass   *ProtokolLog()       { return m_ProtokolLog;    }
         TLogClass   *PBProtokolLog()     { return m_PBProtokolLog;  }
         TLogClass   *RejectLog()         { return m_RejectLog;      }
         TLogClass   *StatLog()           { return m_StatLog;        }
         TLogClass   *Ban3mailLog()       { return m_Ban3mailLog;    }
         TLogClass   *ZonesLog()          { return m_ZonesLog;       }
         TLogClass   *DayLoghLog()        { return m_DayLoghLog;     }
         TLogClass   *WhiteIpLog()        { return m_WhiteIpLog;     }
         TLogClass   *TmpBan30Log()       { return m_TmpBan30Log;    }
         TLogClass   *TraceIpLog()        { return m_TraceIpLog;     }
         TLogClass   *MissingMessLog()    { return m_MissingMessLog; }
         TLogClass   *ActionLog()         { return m_ActionLog;      }
         TLogClass   *FilterLog()         { return m_FilterLog;      }
         TLogClass   *StatIPLog()         { return m_StatIPLog;      }
         TLogClass   *StatMPSLog()        { return m_StatMPSLog;     }
         TLogClass   *StatSrvcErrorLog()  { return m_SrvcErrorLog;   }
         TLogClass   *MonLog()            { return m_MonLog;         }
         TLogClass   *FollowLog()         { return m_FollowLog;      }
         TLogClass   *StorageDumpLog()    { return m_StorageDumpLog; }
         TLogClass   *MongoEventLog()     { return m_MongoEventLog;  }
         TLogClass   *BanStepLog()        { return m_BanStepLog;     }

         /*TLogClass      *GetServerLog()      { return m_ServerLog;          }
         TLogClass      *GetInputStreamLog() { return m_InputStreamLog;     }
         TLogClass      *ShinglesLog()       { return m_ShinglesLog;        }
         TLogClass      *TraceLog()          { return m_TraceLog;           }
         TLogClass      *ErrorLog()          { return m_ErrorLog;           }
         */

         bool           TruncLog();
         void           DisableFFlush(bool dsb);
         void           Midnight();
         void           WriteFlushStatus();

         //void           SetDebugMode(bool debug);
         //bool           GetDebugMode(){ return m_debug_mode; }
};

//****************************************************************************************************************************************
//                                              ��������� TLogsGroup
//****************************************************************************************************************************************

class TLogsGroupFake
{
private:
         TKIniFile     *iniobj;

         TBaseLogClass      *m_ServerLog;
         TBaseLogClass      *m_DeliveryLog;
         TBaseLogClass      *m_FilterLog;
public:
         TLogsGroupFake();
         ~TLogsGroupFake();

         bool Init(TBaseLogClass *ServerLogA, TBaseLogClass *DeliveryLogA, TBaseLogClass *FilterLogA);

         TBaseLogClass  *GetServerLog()    { return m_ServerLog;    }
         TBaseLogClass  *GetDeliveryLog()  { return m_DeliveryLog;  }
         TBaseLogClass  *GetFilterLog()    { return m_FilterLog;    }
};

//******************************************************************************************************************************************

