#include "tmakerequest.h"

TMakeRequest::TMakeRequest(TServiceObjectBase& srvcobjA, void* serverA)
    : TMakeRequestBase(srvcobjA, serverA) {
    //������� ������� ������� �� ������� '?', ���� � ��� � ��������� ���� ������, �� ������� ������� �� ���� action �������, ���� �� ���� action ���, �� �������� ������� ��������� console
    AllowList.push_back("info");
    AllowList.push_back("check");
    AllowList.push_back("checs");
    AllowList.push_back("getforfrodo");
    AllowList.push_back("getforfrod2");
    AllowList.push_back("putsender");

    wnet = new TNetKIPv6("");
    if (wnet != NULL)
        wnet->Init("", NULL);
}

TMakeRequest::~TMakeRequest() {
    if (wnet != NULL) {
        delete wnet;
        wnet = NULL;
    }
}

bool TMakeRequest::ActionParse(const TString& Ident, TRequestDopData& data, TReqParams* m_ReqParams, const TString& NumbRequest, const TString& requrl, int thread_index) {
    bool res = false;
    if (Ident == "check") {
        Check(m_ReqParams, NumbRequest);
        res = true;

    } else if (Ident == "checs") {
        CheckS(m_ReqParams, NumbRequest);
        res = true;

    } else if (Ident == "getipstatus") {
        GetIPStatus(NumbRequest, m_ReqParams);
        res = true;

    } else if (Ident == "getforfrodo") {
        GetForFrodo(NumbRequest, m_ReqParams);
        res = true;

    } else if (Ident == "getforfrod2") {
        GetForFrodo2(NumbRequest, m_ReqParams);
        res = true;

    } else if (Ident == "doreset") {
        Reset("-");
        res = true;

    } else if (Ident == "dorellist") {
        ReloadLists("-");
        res = true;

    } else if (Ident == "allrulesreset") {
        AllRulesReset("-");
        res = true;

    } else if (Ident == "putsender") {
        PutSender(NumbRequest, m_ReqParams); //������ ������ ����� (��� ������� ��������)
        res = true;

    } else if (Ident == "truncdaylist") {
        TruncDayList("-");
        res = true;
    }

    if ((!res)) //� ���������� �������
    {
        if (Ident == "log_debug_on") {
            LogDebugOn();
            res = true;

        } else if (Ident == "log_debug_off") {
            LogDebugOff();
            res = true;

        } else if (Ident == "writedump") {
            WriteDump();
            res = true;

        } else if (Ident == "enbfflush") {
            DisableFFlush(false, "-");
            res = true;

        } else if (Ident == "dsbfflush") {
            DisableFFlush(true, "-");
            res = true;

        } else if (Ident == "debuginfo") {
            Debuginfo("-", m_ReqParams);
            res = true;

        } else if (Ident == "asksavedumpbd") {
            AskSaveDumpStorage("-", m_ReqParams);
            res = true;

        } else if (Ident == "dosavedumpbd") {
            SaveDumpStorage("-", m_ReqParams);
            res = true;

        } else if (Ident == "asksavedumpb1s") {
            AskSaveDumpStorageStep1("-", m_ReqParams);
            res = true;

        } else if (Ident == "dosavedumpb1s") {
            SaveDumpStorageStep1("-", m_ReqParams);
            res = true;

        } else if (Ident == "asksavedumpobl") {
            AskSaveDumpStorageOnlyBanList("-", m_ReqParams);
            res = true;

        } else if (Ident == "dosavedumpobl") {
            SaveDumpStorageOnlyBanList("-", m_ReqParams);
            res = true;

        } else if (Ident == "asksavetopbd") {
            AskTopStorage("-", m_ReqParams);
            res = true;

        } else if (Ident == "dosavetopbd") {
            SaveTopStorage("-", m_ReqParams);
            res = true;

        } else if (Ident == "askreadmdump") {
            AskReaddump("-");
            res = true;

        } else if (Ident == "doreadmdump") {
            DoReaddump("-");
            res = true;

        } else if (Ident == "trunclogs") {
            TruncLogs("-");
            res = true;
        }
    }

    if ((!res)) //� ������� ������������ ������������
    {
        if (Ident == "askreset") {
            AskReset("-");
            res = true;

        } else if (Ident == "askrellist") {
            AskReloadLists("-");
            res = true;

        } else if (Ident == "setaddbantime") {
            SetAddBanTime("-", m_ReqParams);
            res = true;

        } else if (Ident == "setrptbase") {
            SetRepeaterBase("-", m_ReqParams);
            res = true;

        } else if (Ident == "addblackip") {
            AddBlackIp("-", m_ReqParams);
            res = true;

        } else if (Ident == "askaddblackip") {
            AskAddBlackIp("-", m_ReqParams);
            res = true;

        } else if (Ident == "askaddblackil") {
            AskAddBlackIp("-", m_ReqParams);
            res = true;

        } else if (Ident == "askaddblackig") {
            AskAddBlackIpNew("-", m_ReqParams);
            res = true;

        } else if (Ident == "addban7ip") {
            AddBan7Ip("-", m_ReqParams);
            res = true;

        } else if (Ident == "askaddban7ip") {
            AskAddBan7Ip("-", m_ReqParams);
            res = true;

        } else if (Ident == "delbanip") {
            DelBanIp("-", m_ReqParams);
            res = true;

        } else if (Ident == "askdelbanip") {
            AskDelBanIp("-", m_ReqParams);
            res = true;

        } else if (Ident == "viewrulestat") {
            ViewRuleTrap("-");
            res = true;

        } else if (Ident == "addstatrule") {
            AddStatRule("-", m_ReqParams);
            res = true;

        } else if (Ident == "delstatrule") {
            DelStatRule("-", m_ReqParams);
            res = true;

        } else if (Ident == "bancontrol") {
            BanControl("-");
            res = true;

        } else if (Ident == "clearipstat") {
            ClearIPStat("-", m_ReqParams);
            res = true;

        } else if (Ident == "baninfo") {
            BanInfo("-", m_ReqParams);
            res = true;

        } else if (Ident == "addfollowip") {
            AddFollowIp("-", m_ReqParams);
            res = true;

        } else if (Ident == "delfollowip") {
            DelFollowIp("-", m_ReqParams);
            res = true;

        } else if (Ident == "viewfollowiplist") {
            ViewFollowIpList("-", m_ReqParams);
            res = true;

        } else if (Ident == "lastbantimenew") {
            LastBanTimeNew("-");
            res = true;
        }
    }

    if ((!res)) //� ������� �������� ������������
    {
        if (Ident == "viewipstat") {
            ViewIPStat("-", m_ReqParams);
            res = true;

        } else if (Ident == "catchip") {
            CatchIP("-", m_ReqParams);
            res = true;

        } else if (Ident == "catchperip") {
            CatchIPPeriod("-", m_ReqParams);
            res = true;

        } else if (Ident == "periplist") {
            IPPeriodList("-");
            res = true;

        } else if (Ident == "viewcatchper") {
            ViewCatchPeriod("-", m_ReqParams);
            res = true;

        } else if (Ident == "askdelcatchper") {
            AskDelCatchPeriod("-", m_ReqParams);
            res = true;

        } else if (Ident == "delcatchper") {
            DelCatchPeriod("-", m_ReqParams);
            res = true;

        } else if (Ident == "viewmailpertrap") {
            ViewMailPeriodTrap("-", m_ReqParams);
            res = true;

        } else if (Ident == "findb3log") {
            FindB3Log("-", m_ReqParams);
            res = true;

        } else if (Ident == "afindb3log") {
            AFindB3Log("-", m_ReqParams);
            res = true;

        } else if (Ident == "printmemstat") {
            PrintMemStat("-", m_ReqParams);
            res = true;

        } else if (Ident == "setbansetup") {
            SetBanSetup("-", m_ReqParams);
            res = true;

        } else if (Ident == "getbansetup") {
            GetBanSetup("-", m_ReqParams);
            res = true;

        } else if (Ident == "bandefwin") {
            SetBanDefaultsWindow("-", m_ReqParams);
            res = true;

        } else if (Ident == "viewstorstat") {
            ViewStorageStatistik("-", m_ReqParams);
            res = true;

        } else if (Ident == "viewinrqststat") {
            InputRequestStatistik("-", m_ReqParams);
            res = true;

        } else if (Ident == "dumpstorip") {
            SaveIPDataFromStorage("-", m_ReqParams);
            res = true;
        }
    }

    return res;
}

void TMakeRequest::Midnight(const TString& id, TReqParams* m_ReqParams) {
    TString text = "";

    if ((srvcobj.GetGeneralObject() != NULL)) {
        srvcobj.GetGeneralObject()->Midnight();
        srvcobj.GetGeneralObject()->MidnightHeavy();

        text = text + "Midnight command accepted<br>";
        text = text + "<A href='" + GetHost() + GetModuleName("console") + GetActionOneParam("console") + "'>Console</A>";
        SendToClient(SO_LOG_MESSAGE, 200, text, id);
    }
}

void TMakeRequest::Shutdown(const TString& id, TReqParams* m_ReqParams) {
    TString text = "";

    srvcobj.GetGeneralObject()->Shutdown();

    text = text + "<html><head>";
    text = text + "<meta http-equiv='refresh' content='3; url=" + GetHost() + GetModuleName("console") + GetActionOneParam("console") + "'>";
    text = text + "</head><body bgcolor=palegoldenrod>\n";
    text = text + "<table border='0' width='100%' height='100%' cellspacing='0' cellpadding='4'>";
    text = text + "<tr><td valign='top'>Shutdown command accepted.</td></tr>";
    text = text + "</table></body></html>";

    SendToClient(SO_LOG_MESSAGE, 200, text, id);
}

TString TMakeRequest::GetTrapForm(const TString& action_ident, int typeip, int onlybanip, int sorttype, int whtip, int delay, bool markbanip, ui32 minstatcountperiod, ui32 minstatcountperiod_today, ui32 id, const TString& substr, bool is_pcre, ui32 maxhamcount_today, const TString& geozone) {
    /*int    typeip            = 0;
    int    onlybanip         = 1;
    int    sorttype          = 0;
    int    whtip             = 0;
    int    delay             = 60;
    bool   markbanip         = true;
    bool   flat              = false;*/

    //catchperip
    //viewcatchper

    char* table_color = "'#ffffcc'";
    TString perform = "";
    TString typeip_s[3] = {"", "", ""};
    TString typeip_restext = "";
    TString onlybanip_s[4] = {"", "", "", ""};
    TString onlybanip_restext = "";
    TString sorttype_s[7] = {"", "", "", "", "", "", ""};
    TString sorttype_restext = "";
    TString whtip_s[3] = {"", "", ""};
    TString whtip_restext = "";
    TString min_count_mails = "";
    TString min_count_mails_today = "";
    TString max_ham_count_today_s = "";
    TString geozone_s = "";
    TString delay_restext = "";
    TString reqtm_restext = "";
    TString markbanip_restext = "";
    TString id_restext = "";
    TString substr_restext = "";
    TString is_pcre_restext = "";

    //typeip
    switch (typeip) {
        case 0:
            typeip_s[0] = " selected";
            break;
        case 1:
            typeip_s[1] = " selected";
            break;
        case 2:
            typeip_s[2] = " selected";
            break;
        default:
            typeip_s[0] = " selected";
    };
    typeip_restext = typeip_restext + "<select name='typeip'>";
    typeip_restext = typeip_restext + "<option value='0'" + typeip_s[0] + "> ipv4 + ipv6 </option>";
    typeip_restext = typeip_restext + "<option value='1'" + typeip_s[1] + "> ipv4 </option>";
    typeip_restext = typeip_restext + "<option value='2'" + typeip_s[2] + "> ipv6 </option>";
    typeip_restext = typeip_restext + "</select>&nbsp;";

    //onlybanip
    switch (onlybanip) {
        case 1:
            onlybanip_s[1] = " selected";
            break;
        case 2:
            onlybanip_s[2] = " selected";
            break;
        case 3:
            onlybanip_s[3] = " selected";
            break;
        default:
            onlybanip_s[1] = " selected";
    };
    onlybanip_restext = onlybanip_restext + "<select name='onlybanip'>";
    onlybanip_restext = onlybanip_restext + "<option value='1'" + onlybanip_s[1] + "> ban ip + good ip </option>";
    onlybanip_restext = onlybanip_restext + "<option value='2'" + onlybanip_s[2] + "> only ban ip </option>";
    onlybanip_restext = onlybanip_restext + "<option value='3'" + onlybanip_s[3] + "> only good ip </option>";
    onlybanip_restext = onlybanip_restext + "</select>&nbsp;";

    //sorttype
    switch (sorttype) {
        case 0:
            sorttype_s[0] = " selected";
            break;
        case 1:
            sorttype_s[1] = " selected";
            break;
        case 2:
            sorttype_s[2] = " selected";
            break;
        case 3:
            sorttype_s[3] = " selected";
            break;
        case 5:
            sorttype_s[5] = " selected";
            break;
        case 6:
            sorttype_s[6] = " selected";
            break;
        default:
            sorttype_s[6] = " selected";
    };
    sorttype_restext = sorttype_restext + "<select name='sorttype'>";
    sorttype_restext = sorttype_restext + "<option value='0'" + sorttype_s[0] + "> ip </option>";
    sorttype_restext = sorttype_restext + "<option value='6'" + sorttype_s[6] + "> all </option>";
    sorttype_restext = sorttype_restext + "<option value='1'" + sorttype_s[1] + "> ham </option>";
    sorttype_restext = sorttype_restext + "<option value='2'" + sorttype_s[2] + "> spam </option>";
    sorttype_restext = sorttype_restext + "<option value='3'" + sorttype_s[3] + "> malic </option>";
    sorttype_restext = sorttype_restext + "<option value='5'" + sorttype_s[5] + "> host </option>";
    sorttype_restext = sorttype_restext + "</select>&nbsp;";

    //whtip
    switch (whtip) {
        case 0:
            whtip_s[0] = " selected";
            break;
        case 1:
            whtip_s[1] = " selected";
            break;
        case 2:
            whtip_s[2] = " selected";
            break;
        default:
            whtip_s[0] = " selected";
    };
    whtip_restext = whtip_restext + "<select name='whtip'>";
    whtip_restext = whtip_restext + "<option value='0'" + whtip_s[0] + "> all </option>";
    whtip_restext = whtip_restext + "<option value='1'" + whtip_s[1] + "> yes </option>";
    whtip_restext = whtip_restext + "<option value='2'" + whtip_s[2] + "> no </option>";
    whtip_restext = whtip_restext + "</select>&nbsp;";

    //min count mails
    min_count_mails = "min count mails <input type='text' size='3' name='mincount' value='" + IntToStroka(minstatcountperiod) + "'>, &nbsp; ";

    //min count mails today
    min_count_mails_today = "min count mails (today) <input type='text' size='3' name='mincounttd' value='" + IntToStroka(minstatcountperiod_today) + "'>, &nbsp;";

    //max ham count today
    max_ham_count_today_s = "max ham count (today) <input type='text' size='3' name='maxhamcount_today' value='" + IntToStroka(maxhamcount_today) + "'>, &nbsp;";

    //geozone
    geozone_s = "geozone <input type='text' size='4' name='geozone' value='" + geozone + "'>, &nbsp;";

    //delay
    delay_restext = "<input type='text' size='3' name='delay' value='60'>, &nbsp;";

    //reqtm
    reqtm_restext = "<input type='hidden' size='10' name='reqtm' value='" + IntToStroka(time(NULL)) + "'>";

    //markbanip
    if (markbanip)
        markbanip_restext = "<input type='checkbox' size='10' name='markbanip' value='' CHECKED>mark ban ip; &nbsp;";
    else
        markbanip_restext = "<input type='checkbox' size='10' name='markbanip' value=''>mark ban ip; &nbsp;";

    //substr
    substr_restext = "substr: <input type='text' size='20' name='substr' value='" + substr + "'> &nbsp;";

    //is_pcre
    /*if (is_pcre)
       is_pcre_restext = "<input type='checkbox' size='10' name='is_pcre' value='' CHECKED>use_pcre; &nbsp;";
    else
       is_pcre_restext = "<input type='checkbox' size='10' name='is_pcre' value=''>use_pcre; &nbsp;";*/

    //id
    id_restext = "<input type='hidden' size='10' name='id' value='" + IntToStroka(id) + "'>";

    if (action_ident == "catchperip") {
        perform = perform + "<form action='" + GetHost() + GetModuleName(action_ident) + "' method='GET' enctype='text/plain' target='_blank'>";
        perform = perform + "<table border='0' width='100%' cellspacing='0' cellpadding='4' bgcolor=lemonchiffon>";

        perform = perform + "<tr align='center'>";
        perform = perform + "<td width='5%'></td>";
        perform = perform + "<td width='85%'>";
        perform = perform + reqtm_restext;
        perform = perform + "&nbsp;<b>View ip:</b>";
        perform = perform + typeip_restext;
        perform = perform + onlybanip_restext;
        perform = perform + "&nbsp;<b>Sort by:</b>" + sorttype_restext;
        perform = perform + "&nbsp;<b>White ip:</b>" + whtip_restext;
        perform = perform + "</td>";
        perform = perform + "<td width='10%'></td>";
        perform = perform + "</tr>";

        perform = perform + "<tr align='center'>";
        perform = perform + "<td width='5%'></td>";
        perform = perform + "<td width='85%'>";
        perform = perform + min_count_mails;
        perform = perform + min_count_mails_today;
        perform = perform + max_ham_count_today_s;
        perform = perform + "</td>";
        perform = perform + "<td width='10%'>" + GetActionFormParam(action_ident) + "<input type='submit' size='10' value='to collect'></td>";
        perform = perform + "</tr>";

        perform = perform + "<tr align='center'>";
        perform = perform + "<td width='5%'></td>";
        perform = perform + "<td width='85%'>";
        perform = perform + geozone_s;
        perform = perform + "period (sec) " + delay_restext;
        perform = perform + markbanip_restext;
        perform = perform + substr_restext;
        perform = perform + is_pcre_restext;
        perform = perform + "</td><td width='10%'>&nbsp;</td>";
        perform = perform + "</tr>";

        perform = perform + "</table>";
        perform = perform + "</form>";

    } else if (action_ident == "viewcatchper") {
        perform = perform + "<form action='" + GetHost() + GetModuleName(action_ident) + "' method='GET' enctype='text/plain'>";
        perform = perform + "<table border='0' width='100%' cellspacing='0' cellpadding='4' bgcolor=" + TString(table_color) + ">";
        perform = perform + "<tr><td>";
        perform = perform + reqtm_restext;
        perform = perform + "&nbsp;<b>View ip:</b>";
        perform = perform + typeip_restext;
        perform = perform + onlybanip_restext;
        perform = perform + "&nbsp;<b>Sort by:</b>" + sorttype_restext;
        perform = perform + "&nbsp;<b>White ip:</b>" + whtip_restext + " &nbsp;  &nbsp; ";
        perform = perform + markbanip_restext;
        perform = perform + "substr='" + substr + "', &nbsp;";
        if (is_pcre)
            perform = perform + "use_pcre=yes, &nbsp;";
        else
            perform = perform + "use_pcre=no, &nbsp;";
        perform = perform + "<br><br>";
        perform = perform + min_count_mails;
        perform = perform + min_count_mails_today;
        perform = perform + max_ham_count_today_s;
        perform = perform + geozone_s;
        perform = perform + id_restext;
        perform = perform + "</td><td>";
        perform = perform + GetActionFormParam(action_ident) + "<input type='submit' size='10' value='to collect'>";
        perform = perform + "</td></tr>";
        perform = perform + "</table>";
        perform = perform + "</form>";
    }

    return perform;
}

TString TMakeRequest::GetTrapFormFA(const TString& action_ident, int typeip, int onlybanip, int sorttype, int whtip, int delay, bool markbanip, ui32 minstatcountperiod, ui32 minstatcountperiod_today, ui32 id, const TString& substr, bool is_pcre, ui32 maxhamcount_today, const TString& geozone, TNetKIPv6& find_ip, const TString& find_ip_source) {
    //viewcatchper
    char* table_color = "'#ffffcc'";
    TString perform = "";
    TString typeip_s[3] = {"", "", ""};
    TString typeip_restext = "";
    TString onlybanip_s[4] = {"", "", "", ""};
    TString onlybanip_restext = "";
    TString sorttype_s[7] = {"", "", "", "", "", "", ""};
    TString sorttype_restext = "";
    TString whtip_s[3] = {"", "", ""};
    TString whtip_restext = "";
    TString min_count_mails = "";
    TString min_count_mails_today = "";
    TString max_ham_count_today_s = "";
    TString geozone_s = "";
    TString delay_restext = "";
    TString reqtm_restext = "";
    TString markbanip_restext = "";
    TString id_restext = "";
    TString substr_restext = "";
    TString is_pcre_restext = "";
    TString find_addresses = "";
    TString find_addresses_list = "";
    THashMap<TString, TKIPv6>::iterator fait;

    //typeip
    switch (typeip) {
        case 0:
            typeip_s[0] = " selected";
            break;
        case 1:
            typeip_s[1] = " selected";
            break;
        case 2:
            typeip_s[2] = " selected";
            break;
        default:
            typeip_s[0] = " selected";
    };
    typeip_restext = typeip_restext + "<select name='typeip' style='visibility: hidden'>";
    typeip_restext = typeip_restext + "<option value='0'" + typeip_s[0] + "> ipv4 + ipv6 </option>";
    typeip_restext = typeip_restext + "<option value='1'" + typeip_s[1] + "> ipv4 </option>";
    typeip_restext = typeip_restext + "<option value='2'" + typeip_s[2] + "> ipv6 </option>";
    typeip_restext = typeip_restext + "</select>&nbsp;";

    //onlybanip
    switch (onlybanip) {
        case 1:
            onlybanip_s[1] = " selected";
            break;
        case 2:
            onlybanip_s[2] = " selected";
            break;
        case 3:
            onlybanip_s[3] = " selected";
            break;
        default:
            onlybanip_s[1] = " selected";
    };
    onlybanip_restext = onlybanip_restext + "<select name='onlybanip' style='visibility: hidden'>";
    onlybanip_restext = onlybanip_restext + "<option value='1'" + onlybanip_s[1] + "> ban ip + good ip </option>";
    onlybanip_restext = onlybanip_restext + "<option value='2'" + onlybanip_s[2] + "> only ban ip </option>";
    onlybanip_restext = onlybanip_restext + "<option value='3'" + onlybanip_s[3] + "> only good ip </option>";
    onlybanip_restext = onlybanip_restext + "</select>&nbsp;";

    //sorttype
    switch (sorttype) {
        case 0:
            sorttype_s[0] = " selected";
            break;
        case 1:
            sorttype_s[1] = " selected";
            break;
        case 2:
            sorttype_s[2] = " selected";
            break;
        case 3:
            sorttype_s[3] = " selected";
            break;
        case 5:
            sorttype_s[5] = " selected";
            break;
        case 6:
            sorttype_s[6] = " selected";
            break;
        default:
            sorttype_s[6] = " selected";
    };
    sorttype_restext = sorttype_restext + "<select name='sorttype' style='visibility: hidden'>";
    sorttype_restext = sorttype_restext + "<option value='0'" + sorttype_s[0] + "> ip </option>";
    sorttype_restext = sorttype_restext + "<option value='6'" + sorttype_s[6] + "> all </option>";
    sorttype_restext = sorttype_restext + "<option value='1'" + sorttype_s[1] + "> ham </option>";
    sorttype_restext = sorttype_restext + "<option value='2'" + sorttype_s[2] + "> spam </option>";
    sorttype_restext = sorttype_restext + "<option value='3'" + sorttype_s[3] + "> malic </option>";
    sorttype_restext = sorttype_restext + "<option value='5'" + sorttype_s[5] + "> host </option>";
    sorttype_restext = sorttype_restext + "</select>&nbsp;";

    //whtip
    switch (whtip) {
        case 0:
            whtip_s[0] = " selected";
            break;
        case 1:
            whtip_s[1] = " selected";
            break;
        case 2:
            whtip_s[2] = " selected";
            break;
        default:
            whtip_s[0] = " selected";
    };
    whtip_restext = whtip_restext + "<select name='whtip' style='visibility: hidden'>";
    whtip_restext = whtip_restext + "<option value='0'" + whtip_s[0] + "> all </option>";
    whtip_restext = whtip_restext + "<option value='1'" + whtip_s[1] + "> yes </option>";
    whtip_restext = whtip_restext + "<option value='2'" + whtip_s[2] + "> no </option>";
    whtip_restext = whtip_restext + "</select>&nbsp;";

    //min count mails
    min_count_mails = /*"min count mails */ "<input type='hidden' size='5' name='mincount' value='" + IntToStroka(minstatcountperiod) + "'> &nbsp; ";

    //min count mails today
    min_count_mails_today = /*"min count mails (today) */ "<input type='hidden' size='5' name='mincounttd' value='" + IntToStroka(minstatcountperiod_today) + "'> &nbsp;";

    //max ham count today
    max_ham_count_today_s = /*"max ham count (today) */ "<input type='hidden' size='5' name='maxhamcount_today' value='" + IntToStroka(maxhamcount_today) + "'> &nbsp;";

    //geozone
    geozone_s = /*"geozone */ "<input type='hidden' size='5' name='geozone' value='" + geozone + "'> &nbsp;";

    //delay
    delay_restext = "<input type='hidden' size='5' name='delay' value='60'>, &nbsp;";

    //reqtm
    reqtm_restext = "<input type='hidden' size='10' name='reqtm' value='" + IntToStroka(time(NULL)) + "'>";

    //markbanip
    if (markbanip)
        markbanip_restext = "<input type='hidden' size='10' name='markbanip' value='' CHECKED>" /*mark ban ip; &nbsp;"*/;
    else
        markbanip_restext = "<input type='hidden' size='10' name='markbanip' value=''>" /*mark ban ip; &nbsp;"*/;

    //substr
    substr_restext = /*"substr: */ "<input type='hidden' size='20' name='substr' value='" + substr + "'> &nbsp;";

    //is_pcre
    if (is_pcre)
        is_pcre_restext = "<input type='checkbox' size='10' name='is_pcre' value='' CHECKED>" /*use_pcre; &nbsp;"*/;
    else
        is_pcre_restext = "<input type='checkbox' size='10' name='is_pcre' value=''>" /*use_pcre; &nbsp;"*/;

    //id
    id_restext = "<input type='hidden' size='10' name='id' value='" + IntToStroka(id) + "'>";

    //find_addresses
    /*fait = find_ip.begin();
    while (fait != find_ip.end())
    {
       if ((*fait).second.Undefined())
       {
          if (find_addresses_list.empty())
             find_addresses_list = find_addresses_list + (*fait).first + "(undef)";
          else
             find_addresses_list = find_addresses_list + ", " + (*fait).first + "(undef)";

       } else
       {
          if (find_addresses_list.empty())
             find_addresses_list = find_addresses_list + (*fait).first;
          else
             find_addresses_list = find_addresses_list + ", " + (*fait).first;

       }

       ++fait;
    }*/
    if (find_addresses_list.empty())
        find_addresses = "<textarea rows='2' cols='50' name='find_address' wrap='off'>" + find_ip_source + "</textarea>";
    else
        find_addresses = find_addresses_list + "<textarea rows='2' cols='50' name='find_address' wrap='off'>" + find_ip_source + "</textarea>";

    if (action_ident == "viewcatchper") {
        perform = perform + "<form action='" + GetHost() + GetModuleName(action_ident) + "' method='GET' enctype='text/plain'>";
        perform = perform + "<table border='0' width='100%' cellspacing='0' cellpadding='4' bgcolor=" + TString(table_color) + ">";
        perform = perform + "<tr><td>";
        perform = perform + reqtm_restext;
        //perform = perform + "&nbsp;<b>View ip:</b>";
        perform = perform + typeip_restext;
        perform = perform + onlybanip_restext;
        perform = perform + /*"&nbsp;<b>Sort by:</b>" + */ sorttype_restext;
        perform = perform + /*"&nbsp;<b>White ip:</b>" + */ whtip_restext;
        perform = perform + min_count_mails;
        perform = perform + min_count_mails_today;
        perform = perform + max_ham_count_today_s;
        perform = perform + geozone_s;
        perform = perform + markbanip_restext;
        perform = perform + /*"substr='" + */ substr /*+ "', &nbsp;"*/;
        /*if (is_pcre)
         perform = perform + "use_pcre=yes, &nbsp;";
      else
         perform = perform + "use_pcre=no, &nbsp;";*/
        perform = perform + id_restext;
        perform = perform + find_addresses;
        perform = perform + "</td><td>";
        perform = perform + GetActionFormParam(action_ident) + "<input type='submit' size='10' value='find address'>";
        perform = perform + "</td></tr>";
        perform = perform + "</table>";
        perform = perform + "</form>";
    }

    return perform;
}

void TMakeRequest::Console(const TString& id, TReqParams* m_ReqParams) {
    char CurTime[CShingleTime::MAX_TIME_SIZE];
    ui32 BeginProcessTime = CShingleTime::GetMs();
    CShingleTime::GetTimeStr(CurTime);
    char* table_color = "'#ffffcc'";
    char* cell_color_today = "PaleGoldenrod";
    char* cell_color_history = "PaleGoldenrod";
    char* cell_color = "PaleGoldenrod";
    TString text = "";
    TSummaryStatistik stat;
    TString debugtxt = "";

    if (GetStatIPObject() != NULL)
        stat = GetStatIPObject()->GetStatistic();

    TString sstatipmem = "<br>&nbsp;&nbsp;&nbsp;<form action='" + GetHost() + GetModuleName("viewipstat") + "' method='GET' enctype='text/plain' target=_blank> &nbsp; ip-address <input type='text' size='20' name='ip' value=''> &nbsp;" + GetActionFormParam("viewipstat") + "<input type='submit' size='10' value='view statistik'></form>&nbsp;&nbsp;&nbsp;";
    TString consoleform = "<br>&nbsp;&nbsp;&nbsp;<form action='" + GetHost() + GetModuleName("console") + "' method='GET' enctype='text/plain'>" + GetActionFormParam("console") + "<input type='submit' size='10' value='clear'></form>&nbsp;&nbsp;&nbsp;";
    TString viewstorstatlink = "<A href='" + GetHost() + GetModuleName("viewstorstat") + GetActionOneParam("viewstorstat") + "' target='_blank' >storage statistik</A>";
    TString viewinrqststatstatlink = "<A href='" + GetHost() + GetModuleName("viewinrqststat") + GetActionOneParam("viewinrqststat") + "' target='_blank' >input request statistik</A>";

    text = text + "<i><b>Server control:</b></i>&nbsp;&nbsp;";
    text = text + "<A href='" + GetHost() + GetModuleName("askshutdown") + GetActionOneParam("askshutdown") + "'>Shutdown</A> &nbsp; ";
    text = text + "<A href='" + GetHost() + GetModuleName("trunclogs") + GetActionOneParam("trunclogs") + "'>Trunc_logs</A> &nbsp;";
    text = text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=" + TString(table_color) + ">";

    text = text + "<tr valign='top'><td valign='left' width='30%'>Version</td><td>" + m_servername + "</td></tr>";
    if ((GetServiceObject().GetNumberRequest() != NULL))
        text = text + "<tr valign='top'><td valign='left' width='30%'>Host name (code)</td><td>" + GetServiceObject().GetNumberRequest()->GetHostName() + " (" + GetServiceObject().GetNumberRequest()->GetHostCode() + ")</td></tr>";
    text = text + "<tr valign='top'><td valign='left' width='30%'>Port</td><td>" + srvcobj.Port() + "</td></tr>";
    text = text + "<tr valign='top'><td valign='left' width='30%'>Start time</td><td>" + m_StartTime + "</td></tr>";
    text = text + "<tr valign='top'><td valign='left' width='30%'>Current time</td><td>" + TString(CurTime) + "</td></tr>";
    if ((GetLogsGroup() != NULL) && (GetLogsGroup()->GetDebugMode())) {
        if (GetLogsGroup()->GetDebugMode())
            debugtxt = "yes (<A href='" + GetHost() + GetModuleName("log_debug_off") + GetActionOneParam("log_debug_off") + "'>disable</A>)";
        else
            debugtxt = "no (<A href='" + GetHost() + GetModuleName("log_debug_on") + GetActionOneParam("log_debug_on") + "'>enable</A>)";

        text = text + "<tr valign='top'><td align='left' width='30%'>Debug mode</td><td>" + debugtxt + " &nbsp </td></tr>";
    }
    text = text + "</table>";

    if ((stat.renginepool.good_filter_count == 0) || (stat.renginepool.bad_filter_count > 0)) {
        text = text + "<br><i><b>Filter statistik:</b></i>&nbsp;&nbsp;";
        text = text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=" + TString(table_color) + ">";
        text = text + "<tr valign='top' bgcolor='red'><td valign='left' width='30%'>Filter count</td><td valign='left'> good count: " + IntToStroka(stat.renginepool.good_filter_count) + ", bad count: " + IntToStroka(stat.renginepool.bad_filter_count) + " &nbsp; </td></tr>";
        text = text + "</table>";
    }

    text = text + "<br><i><b>Input statistik:</b></i>&nbsp;&nbsp;";
    text = text + viewinrqststatstatlink + "&nbsp; &nbsp;";
    text = text + viewstorstatlink + "&nbsp; &nbsp;";
    text = text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=" + TString(table_color) + ">";
    text = text + "<tr valign='top'><td valign='left' width='30%'>CLUSTER:          RequestPerSec</td><td valign='left'>" + stat.trafficctrl_stat.cps_stat + " &nbsp; </td></tr>";
    text = text + "<tr valign='top'><td valign='left' width='30%'>CLUSTER:          Request count (today / yesterday)</td><td valign='left'>" + UI64ToStroka(stat.trafficctrl_stat.today_request) + " / " + UI64ToStroka(stat.trafficctrl_stat.yesterday_request) + " </td></tr>";
    text = text + "<tr valign='top'><td valign='left' width='30%'>CLUSTER:          Skeep request (today / yesterday)</td><td valign='left'>" + UI64ToStroka(stat.trafficctrl_stat.today_lost) + " / " + UI64ToStroka(stat.trafficctrl_stat.yesterday_lost) + " </td></tr>";
    text = text + "<tr valign='top'><td valign='left' width='30%'>OTHER (IPSTAT,FRODO): RequestPerSec</td><td valign='left'>" + stat.tcstat_frodo.cps_stat + " &nbsp; </td></tr>";
    text = text + "<tr valign='top'><td valign='left' width='30%'>OTHER (IPSTAT,FRODO): Request count (today / yesterday)</td><td valign='left'>" + UI64ToStroka(stat.tcstat_frodo.today_request) + " / " + UI64ToStroka(stat.tcstat_frodo.yesterday_request) + " </td></tr>";
    text = text + "<tr valign='top'><td valign='left' width='30%'>OTHER (IPSTAT,FRODO): Skeep request (today / yesterday)</td><td valign='left'>" + UI64ToStroka(stat.tcstat_frodo.today_lost) + " / " + UI64ToStroka(stat.tcstat_frodo.yesterday_lost) + " </td></tr>";
    text = text + "</table>";

    TString add_heavy_local_button = "";
    if ((GetStatIPObject() != NULL) && (GetStatIPObject()->GetBasesStore() != NULL) && (GetStatIPObject()->GetBasesStore()->GetMemBasa() != NULL)) {
        TLocalCacheStat heavylocalstat = GetStatIPObject()->GetBasesStore()->GetMemBasa()->GetHeavyLocalCacheStat();

        ui32 timediff = time(NULL) - heavylocalstat.m_create_time;
        if (timediff < TMemBaseSection::LOCAL_CACHE_PERIOD_SEC)
            add_heavy_local_button = "<input type='submit' name='localsubmit' size='10' value='print local (" + GetTimePeriod(TMemBaseSection::LOCAL_CACHE_PERIOD_SEC - timediff) + ")'>";
    }
    TString sstatform = "";
    sstatform = sstatform + "<form action='" + GetHost() + GetModuleName("printmemstat") + "' method='GET' enctype='text/plain' target=_blank>";
    sstatform = sstatform + GetActionFormParam("printmemstat");
    sstatform = sstatform + "<table border='0' width='100%' cellspacing='0' cellpadding='4' bgcolor=lemonchiffon>";
    sstatform = sstatform + "<tr align='center'><td width='5%'></td><td width='85%'><b>Sort by:</b> <input type='radio' size='10' name='sorttype' value='6'> ip, &nbsp; <input type='radio' size='10' name='sorttype' value='0'> spam, &nbsp; <input type='radio' size='10' name='sorttype' value='1'>ham, &nbsp; <input type='radio' size='10' name='sorttype' value='2'>malic, &nbsp; <input type='radio' size='10' name='sorttype' value='3'>all mail, &nbsp; <input type='radio' size='10' name='sorttype' value='4'>host, &nbsp; <input type='radio' size='10' name='sorttype' value='5' CHECKED>mps <br> <b>View ip:</b> <input type='radio' size='10' name='typeip' value='0' CHECKED> all, &nbsp; <input type='radio' size='10' name='typeip' value='1'> ipv4, &nbsp; <input type='radio' size='10' name='typeip' value='2'> ipv6; &nbsp; <b>White ip:</b> <input type='radio' size='10' name='whtip' value='0' CHECKED> all, &nbsp; <input type='radio' size='10' name='whtip' value='1'> yes, &nbsp; <input type='radio' size='10' name='whtip' value='2'> no, &nbsp;</td><td width='10%'><input type='submit' name='storsubmit' size='10' value='print statistik'></td></tr>";
    sstatform = sstatform + "<tr align='center'><td width='5%' align='left'>" + IntToStroka(GetStatIPObject()->GetHeavyMemCount()) + "</td><td width='85%'><input type='checkbox' size='10' name='enableexlude' value='1'>exclude hosts &nbsp; <input type='checkbox' size='10' name='exludeforward' value='1'>exclude forwards (>1000 mail) &nbsp; <input type='checkbox' size='10' name='markbanip' value='1' CHECKED>mark ban ip &nbsp; &amp; &nbsp; <input type='checkbox' size='10' name='excludebanip' value='1'>exclude ban ip</td><td width='10%'></td></tr>";
    sstatform = sstatform + "<tr align='center'><td width='5%'></td><td width='85%'>min count mails <input type='text' size='5' name='mincount' value='" + IntToStroka(GetStatIPObject()->GetMinStatCount()) + "'>, &nbsp; was mail for last sec <input type='text' size='5' name='maxlastsec' value='0'>, &nbsp; max count ham <input type='text' size='5' name='maxcntham' value='1000'>, &nbsp; max count records <input type='text' size='5' name='maxrecords' value='3000'></td><td width='10%'>" + add_heavy_local_button + "</td></tr>";
    sstatform = sstatform + "</table>";
    sstatform = sstatform + "</form>";

    text = text + "<br><i><b>Heavy host statistik:</b></i>&nbsp;&nbsp;\n";
    text = text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=lemonchiffon>\n";
    text = text + "<tr valign='top'><td align='left' width='30%'>Heavy host count</td><td>" + sstatform + "</td></tr>\n";
    text = text + "</table>\n";

    TString viewfollowiplist_link = "<A href='" + GetHost() + GetModuleName("viewfollowiplist") + GetActionOneParam("viewfollowiplist") + "' target='_blank'>view follow ip list</A>&nbsp;&nbsp;";
    text = text + "<br><i><b>IP statistik:</b></i>&nbsp;&nbsp;\n";
    text = text + viewfollowiplist_link;
    text = text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=lemonchiffon>\n";
    text = text + "<tr valign='top'><td align='left' width='30%'>IP statistik</td><td align='center'>\n<table><tr><td>" + sstatipmem + "</td><td>&nbsp;&nbsp;&nbsp;</td><td>" + consoleform + "</td></tr></table></td></tr>\n";
    text = text + "</table>\n";

    if ((GetStatIPObject() != NULL) && (GetStatIPObject()->EnableObrabMess())) {
        ui32 minstatcountperiod = GetStatIPObject()->GetMinStatCountPeriod();

        TString perform = GetTrapForm("catchperip", 0, 1, 6, 0, 60, true, minstatcountperiod, minstatcountperiod, 0, "", false, 0, "");

        TString performlist = "";
        performlist = performlist + "<form action='" + GetHost() + GetModuleName("periplist") + "' method='GET' enctype='text/plain' target='_blank'>";
        performlist = performlist + "<table border='0' width='100%' cellspacing='0' cellpadding='4' bgcolor=lemonchiffon>";
        performlist = performlist + "<tr align='center'><td width='10%'></td><td width='60%'></td><td width='10%'><input type='hidden' size='10' value=''></td></tr>";
        performlist = performlist + "<tr align='center'><td width='10%'></td><td width='60%'></td><td width='10%'>" + GetActionFormParam("periplist") + "<input type='submit' size='10' value='view list'></td></tr>";
        performlist = performlist + "</table>";
        performlist = performlist + "</form>";

        TString periodstat = "";
        periodstat = periodstat + "<br><table border='0' width='100%' cellspacing='0' cellpadding='4' bgcolor=lemonchiffon>";
        periodstat = periodstat + "<tr><td width='85%' align='center'>" + perform + "</td>";
        periodstat = periodstat + "<td width='15%' align='center'>" + performlist + "</td></tr>";
        periodstat = periodstat + "</table>";

        text = text + "<br><i><b>Period statistik:</b></i>&nbsp;&nbsp;\n";
        text = text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=lemonchiffon>\n";
        text = text + "<tr valign='top'><td align='left' width='30%'>Period statistik</td><td>\n" + periodstat + "</td></tr>\n";
        text = text + "</table>\n";
    }

    if ((GetStatIPObject() != NULL) && (GetStatIPObject()->EnableObrabMess())) {
        TString baninfo_key1 = "";
        TString baninfo_key2 = "";
        TString baninfo_key3 = "";
        TString baninfo_key4 = "";
        TString baninfo_key5 = "";
        if (false)
            baninfo_key1 = "<form action='" + GetHost() + GetModuleName("baninfo") + "' method='GET' enctype='text/plain' target='_blank'><input type='hidden' size='10' name='sorttype' value='0'>" + GetActionFormParam("baninfo") + "<input type='submit' size='20' value='All ban ip'></form> &nbsp; ";
        baninfo_key2 = "<form action='" + GetHost() + GetModuleName("baninfo") + "' method='GET' enctype='text/plain' target='_blank'><input type='hidden' size='10' name='sorttype' value='1'>" + GetActionFormParam("baninfo") + "<input type='submit' size='20' value='Internal ban ip'></form> &nbsp; ";
        baninfo_key3 = "<form action='" + GetHost() + GetModuleName("baninfo") + "' method='GET' enctype='text/plain' target='_blank'><input type='hidden' size='10' name='sorttype' value='2'>" + GetActionFormParam("baninfo") + "<input type='submit' size='20' value='Manual ban ip'></form> &nbsp; ";
        baninfo_key4 = "<form action='" + GetHost() + GetModuleName("baninfo") + "' method='GET' enctype='text/plain' target='_blank'><input type='hidden' size='10' name='sorttype' value='3'>" + GetActionFormParam("baninfo") + "<input type='submit' size='20' value='Blacklist ban ip'></form> &nbsp; ";
        if (false)
            baninfo_key5 = "<form action='" + GetHost() + GetModuleName("baninfo") + "' method='GET' enctype='text/plain' target='_blank'><input type='hidden' size='10' name='sorttype' value='4'>" + GetActionFormParam("baninfo") + "<input type='submit' size='20' value='Rule ban ip'></form> &nbsp; ";
        TString baninfo_key = "<br><table width='100%' cellspacing='0' cellpadding='0'><tr><td width='16%' valign='top'>" + stat.bstat.GetBanCount() + " / " + stat.bstat7.GetBanCount() + " &nbsp; " + "</td><td width='16%'>" + baninfo_key1 + "</td><td width='16%'>" + baninfo_key2 + "</td><td width='16%'>" + baninfo_key3 + "</td><td width='16%'>" + baninfo_key4 + "</td><td width='16%'>" + baninfo_key5 + "</td></tr></table>";

        text = text + "<br><i><b>Ban statistik:</b></i>&nbsp;&nbsp;\n";
        text = text + "<A href='" + GetHost() + GetModuleName("bancontrol") + GetActionOneParam("bancontrol") + "' target='_blank'>Ban control</A>\n";
        text = text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=lemonchiffon>\n";
        if ((GetStatIPObject() != NULL) && (GetStatIPObject()->GetBasesStore() != NULL)) {
            ui32 bantime_v = 0;
            ui32 long_bantime_v = 0;
            TString ban_setup_v = "";

            GetStatIPObject()->GetBasesStore()->GetSetupBanTime(bantime_v, long_bantime_v);
            ban_setup_v = "<form action='" + GetHost() + GetModuleName("setbansetup") + "' method='GET' enctype='text/plain' target='_blank'>bantime=<input type='text' size='20' name='bantime' value='" + IntToStroka(bantime_v) + "'>, &nbsp;long_bantime=<input type='text' size='20' name='long_bantime' value='" + IntToStroka(long_bantime_v) + "'>" + GetActionFormParam("setbansetup") + "&nbsp;<input type='submit' size='20' value='Set ban parameters'></form> &nbsp; ";
            text = text + "<tr valign='top'><td align='left' width='30%'>Ban parameters</td><td>\n<br>bantime=" + IntToStroka(bantime_v) + ", &nbsp;long_bantime=" + IntToStroka(long_bantime_v) + "<br><br>" + ban_setup_v + "</td></tr>\n";
        }
        if (GetStatIPObject() != NULL) {
            ui32 sendtorbl = 0;
            bool sendtorbl_exists = false;

            sendtorbl = GetStatIPObject()->GetSendToRBL(sendtorbl_exists);
            if (sendtorbl_exists)
                text = text + "<tr valign='top'><td align='left' width='30%'>Auto sendtorbl</td><td>\n" + IntToStroka(sendtorbl) + "</td></tr>\n";
            else
                text = text + "<tr valign='top'><td align='left' width='30%'>Auto sendtorbl</td><td>\n local no defined (use external value or 0)</td></tr>\n";
        }
        text = text + "<tr valign='top'><td align='left' width='30%'>Last ban / ban7 time</td><td>\n<A href='" + GetHost() + GetModuleName("lastbantimenew") + GetActionOneParam("lastbantimenew") + "'>" + stat.bstat.GetLastBanTime() + " / " + stat.bstat7.GetLastBanTime() + "</A></td></tr>\n";
        text = text + "<tr valign='top'><td align='left' width='30%'>Last banlist / banlist7 check</td><td>\n" + stat.bstat.GetLastIpListCheck() + " / " + stat.bstat7.GetLastIpListCheck() + "</td></tr>\n";
        text = text + "<tr valign='top'><td align='left' width='30%'>Banlist / Banlist7 size</td><td>\n" + stat.bstat.GetSizeBanList() + " / " + stat.bstat7.GetSizeBanList() + "</td></tr>\n";
        text = text + "<tr valign='top'><td align='left' width='30%'>Ban / Ban7 count</td><td>" + baninfo_key + "</td></tr>\n";
        text = text + "<tr valign='top'><td align='left' width='30%'>CPS ban uniq IP (Ban / Ban7)</td><td>" + stat.bstat.GetBanCPSUniqIP() + " / " + stat.bstat7.GetBanCPSUniqIP() + "</td></tr>\n";
        if ((GetStatIPObject() != NULL) && (GetStatIPObject()->GetBasesStore() != NULL) && (GetStatIPObject()->GetBasesStore()->GetMemBasa() != NULL))
            text = text + "<tr valign='top'><td align='left' width='30%'>FirstDSL rps</td><td>" + GetStatIPObject()->GetBasesStore()->GetMemBasa()->GetFirstDslRPS() + "</td></tr>\n";

        //text = text + "<tr valign='top'><td align='left' width='30%'>Ban queue stat, CPS, Count, in/lost (today / yesterday)</td><td><b>" + FloatToStr(bqs.m_cps) + ", " + IntToStroka(bqs.m_today_count) + "</b>, " + UI64ToStroka(bqs.m_today_in_count) + "/" + UI64ToStroka(bqs.m_today_lost_count) + " (" + UI64ToStroka(bqs.m_yesterday_in_count) + "/" + UI64ToStroka(bqs.m_yesterday_lost_count) + ")</td></tr>\n";
        //text = text + "<tr valign='top'><td align='left' width='30%'>Diskbasa queue stat, CPS, Count, in/lost (today / yesterday)</td><td><b>" + FloatToStr(wqs.m_cps) + ", " + IntToStroka(wqs.m_today_count) + "</b>, " + UI64ToStroka(wqs.m_today_in_count) + "/" + UI64ToStroka(wqs.m_today_lost_count) + " (" + UI64ToStroka(wqs.m_yesterday_in_count) + "/" + UI64ToStroka(wqs.m_yesterday_lost_count) + ")</td></tr>\n";
        text = text + "</table>\n";
    }

    SendToClientWithShap(SO_LOG_MESSAGE, 200, text, id);
}

void TMakeRequest::ExtConsole(const TString& id, TReqParams* m_ReqParams) {
    char CurTime[CShingleTime::MAX_TIME_SIZE];
    ui32 BeginProcessTime = CShingleTime::GetMs();
    CShingleTime::GetTimeStr(CurTime);
    char* table_color = "'#ffffcc'";
    char* cell_color_today = "PaleGoldenrod";
    char* cell_color_history = "PaleGoldenrod";
    char* cell_color = "PaleGoldenrod";
    TString text = "";
    TSummaryStatistik stat;
    TString debugtxt = "";
    TString writemess = "";
    TString fcolor = "";

    if (GetStatIPObject() != NULL)
        stat = GetStatIPObject()->GetStatistic();

    TString shutdown_link = "<A href='" + GetHost() + GetModuleName("askshutdown") + GetActionOneParam("askshutdown") + "'>Shutdown</A> &nbsp; ";
    TString savetop_link = " &nbsp; <A href='" + GetHost() + GetModuleName("asksavetopbd") + GetActionOneParam("asksavetopbd") + "' target='_blank'>SaveTopBD</A>";
    TString savedump_link = " &nbsp; <A href='" + GetHost() + GetModuleName("asksavedumpbd") + GetActionOneParam("asksavedumpbd") + "' target='_blank'>SaveDumpBD</A>";
    TString savedump_link_step1 = " &nbsp; <A href='" + GetHost() + GetModuleName("asksavedumpb1s") + GetActionOneParam("asksavedumpb1s") + "' target='_blank'>SaveDumpBD(step1)</A>";
    TString savedump_link_onlybanlist = " &nbsp; <A href='" + GetHost() + GetModuleName("asksavedumpobl") + GetActionOneParam("asksavedumpobl") + "' target='_blank'>SaveDumpBD(only_ban_lists)</A>";
    TString readdump_link = " &nbsp; <A href='" + GetHost() + GetModuleName("askreadmdump") + GetActionOneParam("askreadmdump") + "' target='_blank'>ReadDumpBD</A>";

    text += "<table border='0' width='100%' cellspacing='0' cellpadding='4'>";
    text += "<tr><td align='left' width='50%'><i><b>Server control:</b></i>&nbsp;&nbsp;" + shutdown_link + "</td><td align='right' width='50%'>" + savedump_link_onlybanlist + " &nbsp; " + savetop_link + " &nbsp; " + savedump_link + " &nbsp; " + savedump_link_step1 + " &nbsp; " + readdump_link + "</td></tr>";
    text += "</table>";
    text = text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=" + TString(table_color) + ">";
    text = text + "<tr valign='top'><td valign='left' width='30%'>Version</td><td>" + m_servername + "</td></tr>";
    if ((GetServiceObject().GetNumberRequest() != NULL))
        text = text + "<tr valign='top'><td valign='left' width='30%'>Host name (code)</td><td>" + GetServiceObject().GetNumberRequest()->GetHostName() + " (" + GetServiceObject().GetNumberRequest()->GetHostCode() + ")</td></tr>";
    text = text + "<tr valign='top'><td valign='left' width='30%'>Port</td><td>" + srvcobj.Port() + "</td></tr>";
    text = text + "<tr valign='top'><td valign='left' width='30%'>Start time</td><td>" + m_StartTime + "</td></tr>";
    text = text + "<tr valign='top'><td valign='left' width='30%'>Current time</td><td>" + TString(CurTime) + "</td></tr>";
    if ((GetLogsGroup() != NULL) && (GetLogsGroup()->GetDebugMode())) {
        if (GetLogsGroup()->GetDebugMode())
            debugtxt = "yes (<A href='" + GetHost() + GetModuleName("log_debug_off") + GetActionOneParam("log_debug_off") + "'>disable</A>)";
        else
            debugtxt = "no (<A href='" + GetHost() + GetModuleName("log_debug_on") + GetActionOneParam("log_debug_on") + "'>enable</A>)";

        text = text + "<tr valign='top'><td align='left' width='30%'>Debug mode</td><td>" + debugtxt + " &nbsp </td></tr>";
    }
    text = text + "</table>";

    if ((stat.renginepool.good_filter_count == 0) || (stat.renginepool.bad_filter_count > 0))
        fcolor = " bgcolor='red'";
    text = text + "<br><i><b>Filter statistik:</b></i>&nbsp;&nbsp;";
    text = text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=" + TString(table_color) + ">";
    text = text + "<tr valign='top'><td valign='left' width='30%'>All filter count</td><td valign='left'>" + IntToStroka(stat.renginepool.filter_count) + " &nbsp; </td></tr>";
    text = text + "<tr valign='top'" + fcolor + "><td valign='left' width='30%'>Filter stat</td><td valign='left'> good count: " + IntToStroka(stat.renginepool.good_filter_count) + ", bad count: " + IntToStroka(stat.renginepool.bad_filter_count) + " &nbsp; </td></tr>";
    text = text + "<tr valign='top'><td valign='left' width='30%'>Rules</td><td valign='left'>" + stat.renginepool.rules + " &nbsp; </td></tr>";
    text = text + "<tr valign='top'><td valign='left' width='30%'>Score</td><td valign='left'>" + FloatToStr(stat.renginepool.score) + " &nbsp; </td></tr>";
    text = text + "<tr valign='top'><td valign='left' width='30%'>Filter RPS</td><td valign='left'>" + stat.renginepool.rps_str + " &nbsp; </td></tr>";
    text = text + "<tr valign='top'><td valign='left' width='30%'>Filter CRC</td><td valign='left'>" + stat.renginepool.rulescs_str + " &nbsp; </td></tr>";
    text = text + "<tr valign='top'><td valign='left' width='30%'>Get filter statistik (refrash every 60 sec)</td><td valign='left'>" + stat.renginepool.get_filter_res + " &nbsp; </td></tr>";
    text = text + "<tr valign='top'><td valign='left' width='30%'>IPv4 action rule weights (BanRule / RPTRule / FRWDRule / PROBBAN / BAN2Rule / BAN7Rule / BAN8Rule)</td><td valign='left'>" + TRengineRuleActionWeights::PrintIPv4Rules() + " &nbsp; </td></tr>";
    text = text + "<tr valign='top'><td valign='left' width='30%'>IPv6 action rule weights (BanRule / RPTRule / FRWDRule / PROBBAN / BAN2Rule / BAN7Rule / BAN8Rule)</td><td valign='left'>" + TRengineRuleActionWeights::PrintIPv6Rules() + " &nbsp; </td></tr>";
    text = text + "<tr valign='top'><td valign='left' width='30%'>last ?allrulesreset</td><td valign='left'>" + GetStatIPObject()->GetAllrulesresetState() + " &nbsp; </td></tr>";
    text = text + "<tr valign='top'><td valign='left' width='30%'>last ?doreset</td><td valign='left'>" + GetStatIPObject()->GetDoresetState() + " &nbsp; </td></tr>";
    text = text + "<tr valign='top'><td valign='left' width='30%'>last ?dorellist</td><td valign='left'>" + GetStatIPObject()->GetDorellistState() + " &nbsp; </td></tr>";
    text = text + "<tr valign='top'><td valign='left' width='30%'>hide_could_not_find_rule</td><td valign='left'>" + BoolToStroka2(GetStatIPObject()->HideCouldNotFindRule()) + " &nbsp; </td></tr>";
    text = text + "</table>";

    TString sstatipmem = "<br>&nbsp;&nbsp;&nbsp;<form action='" + GetHost() + GetModuleName("viewipstat") + "' method='GET' enctype='text/plain' target=_blank> &nbsp; ip-address <input type='text' size='20' name='ip' value=''> &nbsp;" + GetActionFormParam("viewipstat") + "<input type='submit' size='10' value='view ip statistik'></form>&nbsp;&nbsp;&nbsp;";
    TString savedumpip = "<br>&nbsp;&nbsp;&nbsp;<form action='" + GetHost() + GetModuleName("dumpstorip") + "' method='GET' enctype='text/plain' target=_blank> &nbsp; ip-address <input type='text' size='20' name='ip' value=''> &nbsp;" + GetActionFormParam("dumpstorip") + "<input type='submit' size='10' value='save ip dump'></form>&nbsp;&nbsp;&nbsp;";
    text = text + "<br><i><b>IP statistik:</b></i>&nbsp;&nbsp;\n";
    text = text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=lemonchiffon>\n";
    //text = text + "<tr valign='top'><td align='left' width='30%'>View IP statistik</td><td align='center'>\n<table><tr><td>" + sstatipmem + "&nbsp;</td><td>&nbsp;&nbsp;&nbsp;</td><td>&nbsp;</td></tr></table></td></tr>\n";
    text = text + "<tr valign='top'><td align='left' width='30%'>IP action</td><td align='center'>\n<table><tr><td>" + sstatipmem + "&nbsp;</td><td>&nbsp;&nbsp;&nbsp;</td><td>" + savedumpip + "&nbsp;</td></tr></table></td></tr>\n";
    text = text + "</table>\n";

    text = text + "<br><i><b>WhiteIP local cache statistik:</b></i>&nbsp;&nbsp;\n";
    text = text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=lemonchiffon>\n";
    if ((GetStatIPObject() != NULL) && (GetStatIPObject()->GetWhiteIPCache() != NULL)) {
        TWhiteIPLocalCacheStat whitecachestat = GetStatIPObject()->GetWhiteIPCache()->GetStatBase();
        text = text + "<tr valign='top'><td align='left' width='30%'>Propertis::white_local_cache_diff</td><td colspan='2'>" + IntToStroka(whitecachestat.m_diffcount) + "</td></tr>\n";
        text = text + "<tr valign='top'><td align='left' width='30%'>Propertis::white_local_cache_diff_time</td><td colspan='2'>" + IntToStroka(whitecachestat.m_difftime) + "</td></tr>\n";
        text = text + "<tr valign='top'><td align='left' width='30%'>Size</td><td colspan='2'>" + IntToStroka(whitecachestat.m_size) + "</td></tr>\n";
        text = text + "<tr valign='top' align='center'><td align='left' width='30%'>&nbsp;</td><td  width='35%'>TODAY</td><td width='35%'>YESTERDAY</td></tr>\n";
        text = text + "<tr valign='top'><td align='left' width='30%'>All request to cache</td><td>" + UI64ToStroka(whitecachestat.m_today_request) + "</td><td>" + UI64ToStroka(whitecachestat.m_yesterday_request) + "</td></tr>\n";
        text = text + "<tr valign='top'><td align='left' width='30%'>Request to storage (% from all)</td><td>" + UI64ToStroka(whitecachestat.m_today_findincache) + " (" + FloatToStr(whitecachestat.TodayFindInCachePercent()) + "%)</td><td>" + UI64ToStroka(whitecachestat.m_yesterday_findincache) + " (" + FloatToStr(whitecachestat.YesterdayFindInCachePercent()) + "%)</td></tr>\n";
    }
    text = text + "</table>\n";

    if ((GetStatIPObject() != NULL) && (GetStatIPObject()->GetBanIPCache() != NULL)) {
        TBanLocalCacheStat baniplocalcachestat = GetStatIPObject()->GetBanIPCache()->GetStat();
        text = text + "<br><i><b>BanIP local cache statistik:</b></i>&nbsp;&nbsp;\n";
        text = text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=lemonchiffon>\n";
        if ((GetStatIPObject() != NULL) && (GetStatIPObject()->GetBanIPCache() != NULL))
            text = text + "<tr valign='top'><td align='left' width='30%'>Propertis::period_time</td><td colspan='2'>" + IntToStroka(GetStatIPObject()->GetBanIPCache()->GetPeriodTime()) + "</td></tr>\n";
        text = text + "<tr valign='top'><td align='left' width='30%'>Data size</td><td colspan='2'>" + IntToStroka(baniplocalcachestat.m_data_size) + "</td></tr>\n";
        text = text + "<tr valign='top'><td align='left' width='30%'>Data_prev size</td><td colspan='2'>" + IntToStroka(baniplocalcachestat.m_data_prev_size) + "</td></tr>\n";
        text = text + "<tr valign='top'><td align='left' width='30%'>Last change data (remain time)</td><td colspan='2'>" + TimeToStr(baniplocalcachestat.m_last_change_data) + " (" + IntToHourMinSec(time(NULL) - baniplocalcachestat.m_last_change_data) + ")</td></tr>\n";
        text = text + "<tr valign='top' align='center'><td align='left' width='30%'>&nbsp;</td><td  width='35%'>TODAY</td><td width='35%'>YESTERDAY</td></tr>\n";
        text = text + "<tr valign='top'><td align='left' width='30%'>All request to cache</td><td>" + UI64ToStroka(baniplocalcachestat.m_today_request) + "</td><td>" + UI64ToStroka(baniplocalcachestat.m_yesterday_request) + "</td></tr>\n";
        text = text + "<tr valign='top'><td align='left' width='30%'>Find in cache (% from all)</td><td>" + UI64ToStroka(baniplocalcachestat.m_today_findincache) + " (" + FloatToStr(baniplocalcachestat.TodayFindInCachePercent()) + "%)</td><td>" + UI64ToStroka(baniplocalcachestat.m_yesterday_findincache) + " (" + FloatToStr(baniplocalcachestat.YesterdayFindInCachePercent()) + "%)</td></tr>\n";
        text = text + "</table>\n";
    }

    SendToClientWithShap(SO_LOG_MESSAGE, 200, text, id);
}

bool TMakeRequest::ActionWOParse(const TString& Ident, TRequestDopData& data, const TString& InRequest, const TString& NumbRequest, const TString& request_source, int thread_index) {
    bool res = false;

    /*
   if (Ident == "checkwo")
   {
      //����� ������ ������ � ���
      if (InputLog != NULL)
         InputLog->WriteMessageAndData("<begin %s>%s<end>\n", NumbRequest.c_str(), request_source.c_str());

      //������������ ������ InRequest
      //...

      //���������� �����, ����� �� ������������ ������
      res = true;
   }
   */

    return res;
}

void TMakeRequest::Check(TReqParams* m_ReqParams, const TString& NumbRequest) {
    bool full_good = false;
    ui32 full_op_tick = CShingleTime::GetMs();

    if ((GetStatIPObject() != NULL) && (m_ReqParams != NULL)) {
        TString sdob = "";
        bool f_ok = false;
        TString text = "";
        TString mail = "";
        int lzo = 0;
        TString lzos = "";
        ui32 proc_time = 0;
        TReqParams::iterator par_it;
        TObrabResult res;
        bool skeep = false;
        ui32 trap_remain = 0;
        TString dlv_ip = "";
        bool fast_ban = false;
        bool fast_reject = false;
        bool fast_skeep = false;
        TKIPv6 fast_ip = TKIPv6();
        ui32 sendtorbl = 0;
        bool sendtorbl_exists = false;

        sendtorbl = GetStatIPObject()->GetSendToRBL(sendtorbl_exists);
        if (!sendtorbl_exists) {
            par_it = m_ReqParams->find("sendtorbl");
            if (par_it != m_ReqParams->end())
                sendtorbl = atol(Trim(par_it->second[0]).data());
        }

        par_it = m_ReqParams->find("ip");
        if (par_it != m_ReqParams->end()) {
            dlv_ip = Trim(par_it->second[0]);
            if (!dlv_ip.empty()) {
                if ((GetLogsGroup() != NULL) && (GetLogsGroup()->FollowLog() != NULL)) {
                    TNetKIPv6* netobj = GetStatIPObject()->GetFollowList();
                    TKIPv6 dlvip = TKIPv6();

                    CGIUnescape(dlv_ip);
                    dlvip = TKIPv6(dlv_ip.c_str());
                    if (!dlvip.Undefined()) {
                        if (GetStatIPObject() != NULL)
                            GetStatIPObject()->PrintFollowExt(dlvip, NumbRequest.c_str(), FIE_00, "");

                        if ((netobj != NULL) && (netobj->IsInNet(dlvip)))
                            GetLogsGroup()->FollowLog()->WriteMessageAndData("%s [from %s]", dlv_ip.c_str(), m_remote_ip.c_str());

                        if (GetStatIPObject() != NULL) {
                            fast_ban = GetStatIPObject()->IsFastBanIP(dlvip);
                            fast_reject = GetStatIPObject()->IsFastRejectIP(dlvip);
                            fast_skeep = GetStatIPObject()->IsFastSkeepIP(dlvip);
                            fast_ip = dlvip;
                        }
                    }
                }
            }
        }

        if (!fast_ban && !fast_reject && !fast_skeep) {
            par_it = m_ReqParams->find("lzo");
            if (par_it != m_ReqParams->end()) {
                lzos = Trim(par_it->second[0]);
                lzo = atoi(lzos.c_str());
            }

            par_it = m_ReqParams->find("mail");
            if (par_it != m_ReqParams->end()) {
                if ((GetStatIPObject()->GetTrafficControl() != NULL) && (GetStatIPObject()->GetTrafficControl()->Skeep())) //�����������, ���������� ������
                {
                    skeep = true;

                } else {
                    mail = Trim(par_it->second[0]);

                    res = GetStatIPObject()->ObrabRequest(fast_ip, mail, lzo, f_ok, NumbRequest, m_remote_ip, trap_remain, sendtorbl, TStatDBCollInfo("IN", "CHECK"));
                }
            } else {
                if ((GetLogsGroup() != NULL) && (GetLogsGroup()->ActionLog() != NULL))
                    GetLogsGroup()->ActionLog()->WriteMessageAndDataStatus(KERROR, "FILTER:     Bad request - no 'mail' parameter");
            }
        }

        if (fast_skeep) {
            skeep = true;

        } else if (fast_ban) {
            res.Clear();
            res.ban = true;
            res.remainban = 24 * 3600;
            f_ok = true;

        } else if (fast_reject) {
            res.Clear();
            res.ban2 = true;
            res.remainban = 24 * 3600;
            f_ok = true;
        }

        if (!skeep) {
            if (f_ok) {
                int bantype = 0;

                proc_time = CShingleTime::GetMs() - m_BeginProcTime;

                if (res.ban)
                    bantype = 1;
                else if (res.ban2)
                    bantype = 2;
                else if (res.ban7)
                    bantype = 7;
                else if (res.ban8)
                    bantype = 8;

                text = text + "begin ban " + IntToStroka(bantype) + " save " + BoolToStroka(res.save) + " end\n";
                text = text + "<ext>" + res.dobdata.GetDobData() + "</ext>\n";
                text = text + "<ruls>" + res.dobdata.GetRulsStat() + "</ruls>\n";
                text = text + "<trapremain>" + IntToStroka(trap_remain) + "</trapremain>\n";
                SendToClientRAW(HTTP_200_OK(NumbRequest) + text);
                full_good = true;

                //WriteLogMin(SO_LOG_MESSAGE, 200, sdob.c_str(), NumbRequest);
                if ((GetLogsGroup() != NULL) && (GetLogsGroup()->GetDebugMode()) && (GetLogsGroup()->GetServerLog() != NULL))
                    GetLogsGroup()->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "%s 200 %u %s %s", NumbRequest.c_str(), proc_time, m_remote_ip.c_str(), "");

            } else {
                proc_time = CShingleTime::GetMs() - m_BeginProcTime;

                SendToClientRAW(HTTP_400_BAD_REQUEST(NumbRequest));
                full_good = false;

                //WriteLogMin(SO_LOG_ERROR, 400, sdob.c_str(), NumbRequest);
                if ((GetLogsGroup() != NULL) && (GetLogsGroup()->GetDebugMode()) && (GetLogsGroup()->GetServerLog() != NULL))
                    GetLogsGroup()->GetServerLog()->WriteMessageAndDataStatus(KERROR, "%s 400 %u %s %s", NumbRequest.c_str(), proc_time, m_remote_ip.c_str(), "");
            }

        } else {
            SendToClientRAW(HTTP_200_OK(NumbRequest));
            full_good = true;
        }
    } else {
        SendToClientRAW(HTTP_500_INTERNAL_SERVER_ERROR());
        full_good = false;
    }

    full_op_tick = CShingleTime::GetMs() - full_op_tick;
    if (GetStatIPObject() != NULL)
        GetStatIPObject()->AddInStatCount("IN", "CHECK", STATTICK_FULL, 1, full_good, full_op_tick);
}

void TMakeRequest::CheckS(TReqParams* m_ReqParams, const TString& id) {
    bool full_good = false;
    ui32 full_op_tick = CShingleTime::GetMs();

    if ((GetStatIPObject() != NULL) && (m_ReqParams != NULL)) {
        TString sdob = "";
        bool f_ok = false;
        TString text = "";
        TString mail = "";
        ui32 proc_time = 0;
        TReqParams::iterator par_it;
        TObrabResult res;
        bool skeep = false;
        int a = 0;
        ui32 trap_remain = 0;
        TString dlv_ip = "";
        bool fast_ban = false;
        bool fast_reject = false;
        bool fast_skeep = false;
        TKIPv6 fast_ip = TKIPv6();
        ui32 sendtorbl = 0;
        bool sendtorbl_exists = false;

        sendtorbl = GetStatIPObject()->GetSendToRBL(sendtorbl_exists);
        if (!sendtorbl_exists) {
            par_it = m_ReqParams->find("sendtorbl");
            if (par_it != m_ReqParams->end())
                sendtorbl = atol(Trim(par_it->second[0]).data());
        }

        par_it = m_ReqParams->find("ip");
        if (par_it != m_ReqParams->end()) {
            dlv_ip = Trim(par_it->second[0]);
            if (!dlv_ip.empty()) {
                if ((GetLogsGroup() != NULL) && (GetLogsGroup()->FollowLog() != NULL)) {
                    TNetKIPv6* netobj = GetStatIPObject()->GetFollowList();
                    TKIPv6 dlvip = TKIPv6();

                    CGIUnescape(dlv_ip);
                    dlvip = TKIPv6(dlv_ip.c_str());
                    if (!dlvip.Undefined()) {
                        if (GetStatIPObject() != NULL)
                            GetStatIPObject()->PrintFollowExt(dlvip, id.c_str(), FIE_00, "");

                        if ((netobj != NULL) && (netobj->IsInNet(dlvip)))
                            GetLogsGroup()->FollowLog()->WriteMessageAndData("%s [from %s]", dlv_ip.c_str(), m_remote_ip.c_str());

                        if (GetStatIPObject() != NULL) {
                            fast_ban = GetStatIPObject()->IsFastBanIP(dlvip);
                            fast_reject = GetStatIPObject()->IsFastRejectIP(dlvip);
                            fast_skeep = GetStatIPObject()->IsFastSkeepIP(dlvip);
                            fast_ip = dlvip;
                        }
                    }
                }
            }
        }

        if (!fast_ban && !fast_reject && !fast_skeep) {
            par_it = m_ReqParams->find("mail");
            if (par_it != m_ReqParams->end()) {
                if ((GetStatIPObject()->GetTrafficControl() != NULL) && (GetStatIPObject()->GetTrafficControl()->Skeep())) //�����������, ���������� ������
                {
                    skeep = true;

                } else {
                    mail = Trim(par_it->second[0]);

                    res = GetStatIPObject()->ObrabRequestSerializeData(fast_ip, mail, f_ok, id, m_remote_ip, trap_remain, sendtorbl, TStatDBCollInfo("IN", "CHECS"));
                }

            } else {
                if ((GetLogsGroup() != NULL) && (GetLogsGroup()->ActionLog() != NULL))
                    GetLogsGroup()->ActionLog()->WriteMessageAndDataStatus(KERROR, "FILTER:     Bad request - no 'mail' parameter");
            }
        }

        if (fast_skeep) {
            skeep = true;

        } else if (fast_ban) {
            res.Clear();
            res.ban = true;
            res.remainban = 24 * 3600;
            f_ok = true;

        } else if (fast_reject) {
            res.Clear();
            res.ban2 = true;
            res.remainban = 24 * 3600;
            f_ok = true;
        }

        if (!skeep) {
            if (f_ok) {
                int bantype = 0;

                proc_time = CShingleTime::GetMs() - m_BeginProcTime;

                if (res.ban)
                    bantype = 1;
                else if (res.ban2)
                    bantype = 2;
                else if (res.ban7)
                    bantype = 7;
                else if (res.ban8)
                    bantype = 8;

                text = text + "begin ban " + IntToStroka(bantype) + " save " + BoolToStroka(res.save) + " end\n";
                text = text + "<ext>" + res.dobdata.GetDobData() + "</ext>\n";
                text = text + "<ruls>" + res.dobdata.GetRulsStat() + "</ruls>\n";
                text = text + "<trapremain>" + IntToStroka(trap_remain) + "</trapremain>\n";
                full_good = true;
                SendToClientRAW(HTTP_200_OK(id) + text);

                if ((GetLogsGroup() != NULL) && (GetLogsGroup()->GetDebugMode()) && (GetLogsGroup()->GetServerLog() != NULL))
                    GetLogsGroup()->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "%s 200 %u %s %s", id.c_str(), proc_time, m_remote_ip.c_str(), "");

            } else {
                proc_time = CShingleTime::GetMs() - m_BeginProcTime;

                full_good = false;
                SendToClientRAW(HTTP_400_BAD_REQUEST(id));

                if ((GetLogsGroup() != NULL) && (GetLogsGroup()->GetDebugMode()) && (GetLogsGroup()->GetServerLog() != NULL))
                    GetLogsGroup()->GetServerLog()->WriteMessageAndDataStatus(KERROR, "%s 400 %u %s %s", id.c_str(), proc_time, m_remote_ip.c_str(), "");
            }

        } else {
            full_good = true;
            SendToClientRAW(HTTP_200_OK(id));
        }
    } else {
        full_good = false;
        SendToClientRAW(HTTP_500_INTERNAL_SERVER_ERROR());
    }

    full_op_tick = CShingleTime::GetMs() - full_op_tick;
    if (GetStatIPObject() != NULL)
        GetStatIPObject()->AddInStatCount("IN", "CHECS", STATTICK_FULL, 1, full_good, full_op_tick);
}

void TMakeRequest::GetIPStatus(const TString& id, TReqParams* m_ReqParams) {
    bool full_good = false;
    ui32 full_op_tick = CShingleTime::GetMs();

    if ((GetStatIPObject() != NULL) && (GetStatIPObject()->GetControlTraffOther() != NULL) && (m_ReqParams != NULL)) {
        bool f_ok = false;
        TString text = "";
        TReqParams::iterator par_it;
        TString ip_s = "";
        TKIPv6 ip = TKIPv6();
        bool ban = false;
        ui16 ban_hours = 0;
        ui8 ban_pr = 0;
        bool ban7 = false;
        ui16 ban7_hours = 0;
        ui8 ban7_pr = 0;

        if (GetStatIPObject()->GetControlTraffOther()->Skeep()) {
            SendToClientRAW(HTTP_503_SERVICE_UNAVAILABLE());
            full_good = false;

        } else {
            par_it = m_ReqParams->find("ip");
            if (par_it != m_ReqParams->end()) {
                ip_s = par_it->second[0];
                CGIUnescape(ip_s);
                ip_s = Trim(ip_s);
                ip = TKIPv6(ip_s.c_str());

                if (!ip.Undefined()) {
                    GetStatIPObject()->IsBanIpExt(ip, ban, ban_hours, ban_pr, ban7, ban7_hours, ban7_pr);
                    if (ban) {
                        GetStatIPObject()->GetControlTraffOther()->IncBanCount();
                        text = text + "1";
                        SendToClientRAW(HTTP_200_OK(id) + text);
                        full_good = true;

                    } else {
                        text = text + "0";
                        SendToClientRAW(HTTP_404_NOT_FOUND(id) + text);

                        full_good = false;
                    }
                } else {
                    SendToClient(SO_LOG_ERROR, 400, "Bad request (bad ip parameters).", id);
                    GetStatIPObject()->GetControlTraffOther()->IncMalicCount(); //bad request counter

                    full_good = false;
                }
            } else {
                SendToClient(SO_LOG_ERROR, 400, "Bad request (no ip parameters).", id);
                GetStatIPObject()->GetControlTraffOther()->IncMalicCount(); ////bad request counter

                full_good = false;
            }
        }

    } else {
        SendToClientRAW(HTTP_500_INTERNAL_SERVER_ERROR());
    }

    full_op_tick = CShingleTime::GetMs() - full_op_tick;
    if (GetStatIPObject() != NULL)
        GetStatIPObject()->AddInStatCount("IN", "GETIPSTATUS", STATTICK_FULL, 1, full_good, full_op_tick);
}

void TMakeRequest::GetForFrodo(const TString& id, TReqParams* m_ReqParams) {
    bool full_good = false;
    ui32 full_op_tick = CShingleTime::GetMs();

    if ((GetStatIPObject() != NULL) && (GetStatIPObject()->GetControlTraffOther() != NULL) && (m_ReqParams != NULL)) {
        bool f_ok = false;
        TString text = "";
        TReqParams::iterator par_it;
        TString ip_s = "";
        TKIPv6 ip = TKIPv6();

        if (GetStatIPObject()->GetControlTraffOther()->Skeep()) {
            SendToClientRAW(HTTP_503_SERVICE_UNAVAILABLE());
            full_good = false;

        } else {
            par_it = m_ReqParams->find("ip");
            if (par_it != m_ReqParams->end()) {
                ip_s = par_it->second[0];
                CGIUnescape(ip_s);
                ip_s = Trim(ip_s);
                ip = TKIPv6(ip_s.c_str());

                if (!ip.Undefined()) {
                    TIpStatOne ms;
                    ui32 today_ham = 0;
                    ui32 today_spam = 0;
                    ui32 today_malic = 0;
                    ui32 today_flags = 0;
                    ui32 yesterday_ham = 0;
                    ui32 yesterday_spam = 0;
                    ui32 yesterday_malic = 0;
                    ui32 yesterday_flags = 0;
                    ui32 history_reject = 0;
                    ui32 history_noreject = 0;
                    ui32 history_ham = 0;
                    ui32 history_spam = 0;
                    char buff[2048];
                    TString hostgeo = "";
                    bool ban = false;

                    GetStatIPObject()->CheckMemBasa(ip, id + "(getforfrodo)");

                    ms = GetStatIPObject()->GetIpStat(ip);
                    if (!ms.notfound) {
                        today_ham = ms.Ham;
                        today_spam = ms.Spam;
                        today_malic = ms.MalicSpam;
                        if (IS_SF_BAN(ms.bMask)) {
                            SET_EXPORT_BAN(today_flags);
                            ban = true;
                        }
                        if (IS_SF_BAN_WOW(ms.bMask)) {
                            SET_EXPORT_BAN_WOW(today_flags);
                            ban = true;
                        }
                        if (IS_SF_WHITE(ms.bMask))
                            SET_EXPORT_WHITE(today_flags);
                        if (IS_SF_RBL4(ms.bMask))
                            SET_EXPORT_RBL4(today_flags);

                        yesterday_ham = ms.yctHam;
                        yesterday_spam = ms.yctSpam;
                        yesterday_malic = ms.yctMalicSpam;
                        if (IS_SF_BAN(ms.ybMask)) {
                            SET_EXPORT_BAN(yesterday_flags);
                            ban = true;
                        }
                        if (IS_SF_BAN_WOW(ms.ybMask)) {
                            SET_EXPORT_BAN_WOW(yesterday_flags);
                            ban = true;
                        }
                        if (IS_SF_WHITE(ms.ybMask))
                            SET_EXPORT_WHITE(yesterday_flags);
                        if (IS_SF_RBL4(ms.ybMask))
                            SET_EXPORT_RBL4(yesterday_flags);

                        history_reject = ms.hDaysRej;
                        history_noreject = ms.hDaysNoRej;
                        history_ham = ms.hctHam;
                        history_spam = ms.hctSpam;

                        snprintf(buff, sizeof(buff) - 1, "ip=%s&empty=0&data=%u-%u-%u-%u-%u-%u-%u-%u-%u-%u-%u-%u&host=%s&geo=%s", ip.toStroka().c_str(), today_ham, today_spam, today_malic, today_flags, yesterday_ham, yesterday_spam, yesterday_malic, yesterday_flags, history_reject, history_noreject, history_ham, history_spam, ms.rdns.c_str(), ms.geo.c_str());
                        text = TString(buff);

                        if (ban)
                            GetStatIPObject()->GetControlTraffOther()->IncBanCount();

                    } else
                        text = "ip=" + ip.toStroka() + "&empty=1";

                    SendToClientRAW(HTTP_200_OK(id) + text);
                    full_good = true;

                } else {
                    SendToClient(SO_LOG_ERROR, 400, "Bad request (bad ip parameters).", id);
                    GetStatIPObject()->GetControlTraffOther()->IncMalicCount(); ////bad request counter
                    full_good = false;
                }
            } else {
                SendToClient(SO_LOG_ERROR, 400, "Bad request (no ip parameters).", id);
                GetStatIPObject()->GetControlTraffOther()->IncMalicCount(); ////bad request counter
                full_good = false;
            }
        }

    } else {
        SendToClientRAW(HTTP_500_INTERNAL_SERVER_ERROR());
        full_good = false;
    }

    full_op_tick = CShingleTime::GetMs() - full_op_tick;
    if (GetStatIPObject() != NULL)
        GetStatIPObject()->AddInStatCount("IN", "GETFORFRODO", STATTICK_FULL, 1, full_good, full_op_tick);
}

void TMakeRequest::GetForFrodo2(const TString& id, TReqParams* m_ReqParams) {
    bool full_good = false;
    ui32 full_op_tick = CShingleTime::GetMs();

    if ((GetStatIPObject() != NULL) && (GetStatIPObject()->GetControlTraffOther() != NULL) && (m_ReqParams != NULL)) {
        bool f_ok = false;
        TString text = "";
        TReqParams::iterator par_it;
        TString ip_s = "";
        TKIPv6 ip = TKIPv6();

        if (GetStatIPObject()->GetControlTraffOther()->Skeep()) {
            SendToClientRAW(HTTP_503_SERVICE_UNAVAILABLE());
            full_good = false;

        } else {
            par_it = m_ReqParams->find("ip");
            if (par_it != m_ReqParams->end()) {
                ip_s = par_it->second[0];
                CGIUnescape(ip_s);
                ip_s = Trim(ip_s);
                ip = TKIPv6(ip_s.c_str());

                if (!ip.Undefined()) {
                    TIpStatOne ms;
                    ui32 today_ham = 0;
                    ui32 today_spam = 0;
                    ui32 today_malic = 0;
                    ui32 today_flags = 0;
                    ui32 yesterday_ham = 0;
                    ui32 yesterday_spam = 0;
                    ui32 yesterday_malic = 0;
                    ui32 yesterday_flags = 0;
                    ui32 history_reject = 0;
                    ui32 history_noreject = 0;
                    ui32 history_ham = 0;
                    ui32 history_spam = 0;
                    char buff[2048];
                    TString hostgeo = "";
                    bool ban = false;
                    ui16 ban_hours = 0;
                    ui8 ban_pr = 0;
                    bool ban7 = false;
                    ui16 ban7_hours = 0;
                    ui8 ban7_pr = 0;
                    TString ban_stat = "";
                    TString ban7_stat = "";

                    //���������� ����
                    GetStatIPObject()->IsBanIpExt(ip, ban, ban_hours, ban_pr, ban7, ban7_hours, ban7_pr);
                    ban_stat = BoolToStroka(ban) + "-" + IntToStroka(ban_hours) + "-" + IntToStroka(ban_pr);
                    ban7_stat = BoolToStroka(ban7) + "-" + IntToStroka(ban7_hours) + "-" + IntToStroka(ban7_pr);

                    //���������� �� ������
                    GetStatIPObject()->CheckMemBasa(ip, id + "(getforfrodo2)");

                    ms = GetStatIPObject()->GetIpStat(ip);
                    if (!ms.notfound) {
                        today_ham = ms.Ham;
                        today_spam = ms.Spam;
                        today_malic = ms.MalicSpam;
                        if (IS_SF_BAN(ms.bMask)) {
                            SET_EXPORT_BAN(today_flags);
                            ban = true;
                        }
                        if (IS_SF_BAN_WOW(ms.bMask)) {
                            SET_EXPORT_BAN_WOW(today_flags);
                            ban = true;
                        }
                        if (IS_SF_WHITE(ms.bMask))
                            SET_EXPORT_WHITE(today_flags);
                        if (IS_SF_RBL4(ms.bMask))
                            SET_EXPORT_RBL4(today_flags);

                        yesterday_ham = ms.yctHam;
                        yesterday_spam = ms.yctSpam;
                        yesterday_malic = ms.yctMalicSpam;
                        if (IS_SF_BAN(ms.ybMask)) {
                            SET_EXPORT_BAN(yesterday_flags);
                            ban = true;
                        }
                        if (IS_SF_BAN_WOW(ms.ybMask)) {
                            SET_EXPORT_BAN_WOW(yesterday_flags);
                            ban = true;
                        }
                        if (IS_SF_WHITE(ms.ybMask))
                            SET_EXPORT_WHITE(yesterday_flags);
                        if (IS_SF_RBL4(ms.ybMask))
                            SET_EXPORT_RBL4(yesterday_flags);

                        history_reject = ms.hDaysRej;
                        history_noreject = ms.hDaysNoRej;
                        history_ham = ms.hctHam;
                        history_spam = ms.hctSpam;

                        snprintf(buff, sizeof(buff) - 1, "ip=%s&empty=0&data=%u-%u-%u-%u-%u-%u-%u-%u-%u-%u-%u-%u&host=%s&geo=%s&ban=%s&ban7=%s", ip.toStroka().c_str(), today_ham, today_spam, today_malic, today_flags, yesterday_ham, yesterday_spam, yesterday_malic, yesterday_flags, history_reject, history_noreject, history_ham, history_spam, ms.rdns.c_str(), ms.geo.c_str(), ban_stat.c_str(), ban7_stat.c_str());
                        text = TString(buff);

                        if (ban)
                            GetStatIPObject()->GetControlTraffOther()->IncBanCount();

                    } else
                        text = "ip=" + ip.toStroka() + "&empty=1&ban=" + ban_stat + "&ban7=" + ban7_stat;

                    SendToClientRAW(HTTP_200_OK(id) + text);
                    full_good = true;

                } else {
                    SendToClient(SO_LOG_ERROR, 400, "Bad request (bad ip parameters).", id);
                    GetStatIPObject()->GetControlTraffOther()->IncMalicCount(); ////bad request counter
                    full_good = false;
                }
            } else {
                SendToClient(SO_LOG_ERROR, 400, "Bad request (no ip parameters).", id);
                GetStatIPObject()->GetControlTraffOther()->IncMalicCount(); ////bad request counter
                full_good = false;
            }
        }

    } else {
        SendToClientRAW(HTTP_500_INTERNAL_SERVER_ERROR());
        full_good = false;
    }

    full_op_tick = CShingleTime::GetMs() - full_op_tick;
    if (GetStatIPObject() != NULL)
        GetStatIPObject()->AddInStatCount("IN", "GETFORFROD2", STATTICK_FULL, 1, full_good, full_op_tick);
}

void TMakeRequest::LogDebugOn() {
    ui32 BeginProcessTime = CShingleTime::GetMs();
    TString text = "";

    if (GetLogsGroup() != NULL) {
        GetLogsGroup()->SetDebugMode(true);

        text = text + "Log debug on - OK<br>";
    }

    SendToClientWithShap(SO_LOG_MESSAGE, 200, text, "");
}

void TMakeRequest::LogDebugOff() {
    ui32 BeginProcessTime = CShingleTime::GetMs();
    TString text = "";

    if (GetLogsGroup() != NULL) {
        GetLogsGroup()->SetDebugMode(false);

        text = text + "Log debug off - OK<br>";
    }

    SendToClientWithShap(SO_LOG_MESSAGE, 200, text, "");
}

bool TMakeRequest::WriteDump() {
    bool res = false;
    TString text = "";

    if (GetStatIPObject() != NULL) {
        res = GetStatIPObject()->WriteDump();
        if (res) {
            text = "Write dump succesfully.";
            SendToClientWithShap(SO_LOG_MESSAGE, 200, text, "-");
        } else {
            text = "Write dump failed.";
            SendToClientWithShap(SO_LOG_ERROR, 501, text, "-");
        }
    }

    return res;
}

void TMakeRequest::DisableFFlush(bool disable, const TString& id) {
    TString text = "";

    if (GetLogsGroup() != NULL) {
        if (disable) {
            GetLogsGroup()->DisableFFlush(true);
            text = "Disable fflush - OK.";
        } else {
            GetLogsGroup()->DisableFFlush(false);
            text = "Enable fflush - OK.";
        }
    } else {
        if (disable)
            text = "Disable fflush - FAILED.";
        else
            text = "Enable fflush - FAILED.";
    }
    text = text + "<br><A href='" + GetHost() + GetModuleName("console") + GetActionOneParam("console") + "'>Console</A>";

    SendToClient(SO_LOG_MESSAGE, 200, text, id);
}

void TMakeRequest::Debuginfo(const TString& id, TReqParams* m_ReqParams) {
    TReqParams::iterator par_it;
    TString text = "";
    TString skey = "";
    TString svalue = "";

    if (m_ReqParams != NULL) {
        par_it = m_ReqParams->begin();
        while (par_it != m_ReqParams->end()) {
            skey = par_it->first;
            svalue = par_it->second[0];

            text = text + "key='" + skey + "', value='" + svalue + "'<br>";

            ++par_it;
        }
    }
    text = text + "<br><A href='" + GetHost() + GetModuleName("console") + GetActionOneParam("console") + "'>Console</A>";
    SendToClient(SO_LOG_MESSAGE, 200, text, id);
}

void TMakeRequest::AskReset(const TString& id) {
    TString text = "";

    text = text + HTTP_200_OK(id);
    text = text + "<SCRIPT LANGUAGE='Javascript'>\n";
    text = text + "if(true == confirm('Reload rules ?')) {\n";
    text = text + "document.location = '";
    text = text + GetHost() + GetModuleName("doreset") + GetActionOneParam("doreset") + "'\n";
    text = text + "} else {\n";
    text = text + "document.location = '";
    text = text + GetHost() + GetModuleName("console") + GetActionOneParam("console") + "'}\n";
    text = text + "</SCRIPT>\n";

    SendToClientRAW(text);
}

void TMakeRequest::Reset(const TString& id) {
    TString text = "";
    bool ok = false;
    TString state = "";
    ui32 tick = 0;

    tick = CShingleTime::GetMs();
    if ((GetStatIPObject() != NULL) && (GetStatIPObject()->GetRenginePool() != NULL))
        text = GetStatIPObject()->GetRenginePool()->Reset(ok);

    tick = CShingleTime::GetMs() - tick;
    if (GetStatIPObject() != NULL) {
        if (ok)
            state = TimeToStr(time(NULL)) + "; OK; " + IntToStroka(tick) + " ms";
        else
            state = TimeToStr(time(NULL)) + "; FAILED; " + IntToStroka(tick) + " ms";

        GetStatIPObject()->SetDoresetState(state);
    }

    if (ok) {
        text = "<b>Reset filter - OK.<br>Filter message:</b><br>" + text;
        SendToClient(SO_LOG_MESSAGE, 200, text, id);
    } else {
        SendToClient(SO_LOG_ERROR, 501, "Cant's reset filter.", id);
    }
}

void TMakeRequest::AskReloadLists(const TString& id) {
    TString text = "";

    text = text + HTTP_200_OK(id);
    text = text + "<SCRIPT LANGUAGE='Javascript'>\n";
    text = text + "if(true == confirm('Reload lists (whitenet, shadyhosts, whiteip, blackip, ruleprintlist)?')) {\n";
    text = text + "document.location = '";
    text = text + GetHost() + GetModuleName("dorellist") + GetActionOneParam("dorellist") + "'\n";
    text = text + "} else {\n";
    text = text + "document.location = '";
    text = text + GetHost() + GetModuleName("console") + GetActionOneParam("console") + "'}\n";
    text = text + "</SCRIPT>\n";

    SendToClientRAW(text);
}

void TMakeRequest::ReloadLists(const TString& id) {
    TString state = "";
    ui32 tick = 0;

    tick = CShingleTime::GetMs();

    if (GetStatIPObject() != NULL) {
        if (GetStatIPObject()->GetBasesStore() != NULL)
            GetStatIPObject()->GetBasesStore()->ReloadLists();

        GetStatIPObject()->ReloadFastList();
    }

    tick = CShingleTime::GetMs() - tick;
    if (GetStatIPObject() != NULL) {
        state = TimeToStr(time(NULL)) + "; " + IntToStroka(tick) + " ms";

        GetStatIPObject()->SetDorellistState(state);
    }

    SendToClient(SO_LOG_MESSAGE, 200, "Reload lists command accepted", id);
}

void TMakeRequest::AllRulesReset(const TString& id) {
    TString status = "";
    TString text = "";
    bool ok = true;
    ui32 tick = 0;
    TString state = "";

    tick = CShingleTime::GetMs();

    if ((GetStatIPObject() != NULL) && (GetStatIPObject()->GetRenginePool() != NULL))
        text = GetStatIPObject()->GetRenginePool()->Reset(ok);
    else
        ok = false;

    if (ok)
        status += "Reset filter - OK. Filter message:\n" + text + ".\n";
    else
        status += "Can not reset filter.\n";

    if ((GetStatIPObject() != NULL) && (GetStatIPObject()->GetBasesStore() != NULL)) {
        GetStatIPObject()->GetBasesStore()->ReloadLists();
        status += "Reload lists command accepted\n";
    } else {
        ok = false;
        status += "Reload lists failed. NULL objects.\n";
    }

    tick = CShingleTime::GetMs() - tick;

    if (GetStatIPObject() != NULL) {
        if (ok)
            state = TimeToStr(time(NULL)) + "; OK; " + IntToStroka(tick) + " ms";
        else
            state = TimeToStr(time(NULL)) + "; FAILED; " + IntToStroka(tick) + " ms";

        GetStatIPObject()->SetAllrulesresetState(state);
    }

    SendToClient(ok ? SO_LOG_MESSAGE : SO_LOG_ERROR, ok ? 200 : 501, status, id);
}

void TMakeRequest::TruncDayList(const TString& id) {
    TString text = "";
    bool pr_ok = false;

    if ((GetStatIPObject() != NULL) && (GetStatIPObject()->GetBasesStore() != NULL)) {
        GetStatIPObject()->GetBasesStore()->TruncDayList();
        pr_ok = true;
        text = "Truncate daylist command - accepted!";
    }

    SendToClient(pr_ok ? SO_LOG_MESSAGE : SO_LOG_ERROR, pr_ok ? 200 : 501, text, id);
}

/*void TMakeRequest::PutSender(const TString& id)
{
  TString text = "";

  text = text + HTTP_200_OK(id);
  //text = text + "<SENDER shingle='79ce5c574595421f' null='0' body='4944-5071-1845-6764-4-17-53-3-11-0-85' stat='1:1,4:4' profile='v01.0.0'>\n";
  //text = text + "<DOMAIN shingle='ad5da02e153701a8' null='0' body='5016-5071-223-1676-0-0-5-3-3-0-34' stat='' profile='v01.0.0'>\n";
  text = text + "<SENDER shingle='fe3eae75499225b4' null='0' body='5139-5142-33-35419-8-19-7-0-33-0-4' stat='' profile='v01.0.0'>\n";
  text = text + "<DOMAIN shingle='414f2e24d6cf0d1a' null='0' body='5046-5142-33-35551-8-19-10-0-33-0-11' stat='' profile='v01.0.0'>\n";

  SendToClientRAW(text);
}*/

void TMakeRequest::SetAddBanTime(const TString& id, TReqParams* m_ReqParams) {
    TReqParams::iterator par_it;
    ui16 addbantime = 0;
    bool pr_ok = false;
    TString text = "";
    TString bts = "";
    bool fg = false;

    par_it = m_ReqParams->find("addbantime");
    if (par_it != m_ReqParams->end()) {
        bts = Trim(par_it->second[0]);
        if (!bts.empty()) {
            fg = true;
            addbantime = atoi(bts.c_str());

            if ((GetStatIPObject() != NULL) && (GetStatIPObject()->GetBasesStore() != NULL))
                pr_ok = GetStatIPObject()->GetBasesStore()->GetCPO()->SetAddBanTime(addbantime);
            if (pr_ok)
                text = "Set AddBanTime command accepted";
            else
                text = "Set AddBanTime command failed";

            SendToClient(SO_LOG_MESSAGE, 200, text, id);
        }
    }
    if (!fg) {
        if ((GetLogsGroup() != NULL) && (GetLogsGroup()->GetServerLog() != NULL))
            GetLogsGroup()->GetServerLog()->WriteMessageAndDataStatus(KERROR, "F\tBad request - no 'addbantime' parameter");
        SendToClient(SO_LOG_ERROR, 400, "Bad request", id);
    }
}

void TMakeRequest::SetRepeaterBase(const TString& id, TReqParams* m_ReqParams) {
    TReqParams::iterator par_it;
    ui16 repeaterbase = 0;
    bool pr_ok = false;
    TString text = "";
    TString bts = "";
    bool fg = false;

    par_it = m_ReqParams->find("rptbase");
    if (par_it != m_ReqParams->end()) {
        bts = Trim(par_it->second[0]);
        if (!bts.empty()) {
            fg = true;
            repeaterbase = atoi(bts.c_str());

            if ((GetStatIPObject() != NULL) && (GetStatIPObject()->GetBasesStore() != NULL))
                pr_ok = GetStatIPObject()->GetBasesStore()->GetCPO()->SetRepeaterBase(repeaterbase);
            if (pr_ok)
                text = "Set RepeaterBase command accepted";
            else
                text = "Set RepeaterBase command failed";

            SendToClient(SO_LOG_MESSAGE, 200, text, id);
        }
    }
    if (!fg) {
        if ((GetLogsGroup() != NULL) && (GetLogsGroup()->GetServerLog() != NULL))
            GetLogsGroup()->GetServerLog()->WriteMessageAndDataStatus(KERROR, "F\tBad request - no 'rptbase' parameter");
        SendToClient(SO_LOG_ERROR, 400, "Bad request", id);
    }
}

void TMakeRequest::AddBlackIp(const TString& id, TReqParams* m_ReqParams) {
    TReqParams::iterator par_it;
    TString ident_ip = "ip";
    TString rec_s = "";
    TString ip_s = "";
    TIPSumDataList iplist;
    TKIPv6 ip = TKIPv6();
    bool fl1 = false, fl2 = false;
    TString long_s = "0";
    bool longb = false;
    TString bantime_s = "";
    ui32 bantime = 0;
    ui8 IntBanIp = 0;
    TString iplink = "";
    bool pr_ok = false;
    TString text = "";
    TString index_str = "";
    int index = -1;

    par_it = m_ReqParams->begin();
    while (par_it != m_ReqParams->end()) {
        index = -1;
        index_str = "";

        rec_s = (*par_it).first;
        if ((rec_s.length() >= ident_ip.length()) && (!memcmp(rec_s.c_str(), ident_ip.c_str(), ident_ip.length()))) {
            index_str = TString(rec_s.c_str() + ident_ip.length());
            if (!index_str.empty())
                index = atoi(index_str.c_str());
            else
                index = 0;

            ip_s = Trim(par_it->second[0]);
            if (!ip_s.empty()) {
                CGIUnescape(ip_s);
                ip = TKIPv6(ip_s.c_str());
                if (!ip.Undefined()) {
                    fl1 = true;
                    iplink = "<A href='" + GetHost() + GetModuleName("viewipstat") + "?" + GetActionMultiParam("viewipstat") + "ip=" + ip_s + "&nrfr=1'>" + ip.toStroka() + "</A>";
                    iplist.push_back(TIPSumData(ip, index, ip_s, iplink));

                    if (iplist.size() > 10 * MAX_BAN_IP_COUNT)
                        break;
                }
            }
        }
        ++par_it;
    }

    if (iplist.size() == 0) {
        if ((GetLogsGroup() != NULL) && (GetLogsGroup()->GetServerLog() != NULL))
            GetLogsGroup()->GetServerLog()->WriteMessageAndDataStatus(KERROR, "F\tBad request - no 'ip' parameter");
        SendToClient(SO_LOG_ERROR, 400, "Bad request - no 'ip' parameter", id);
    }

    par_it = m_ReqParams->find("long");
    if (par_it != m_ReqParams->end()) {
        long_s = Trim(par_it->second[0]);
        longb = (bool)atoi(long_s.c_str());
    }

    //bantime
    if (fl1) {
        par_it = m_ReqParams->find("bantime");
        if (par_it != m_ReqParams->end()) {
            bantime_s = Trim(TString(par_it->second[0]));
            bantime = atoi(bantime_s.c_str());
            if (!bantime_s.empty()) {
                fl2 = true;
            } else {
                if ((GetLogsGroup() != NULL) && (GetLogsGroup()->GetServerLog() != NULL))
                    GetLogsGroup()->GetServerLog()->WriteMessageAndDataStatus(KERROR, "F\tBad request - 'bantime' parameter empty");
                SendToClient(SO_LOG_ERROR, 400, "Bad request - 'bantime' parameter empty", id);
            }
        } else {
            if ((GetLogsGroup() != NULL) && (GetLogsGroup()->GetServerLog() != NULL))
                GetLogsGroup()->GetServerLog()->WriteMessageAndDataStatus(KERROR, "F\tBad request - no 'bantime' parameter");
            SendToClient(SO_LOG_ERROR, 400, "Bad request - no 'bantime' parameter", id);
        }
    }

    //internal or no
    par_it = m_ReqParams->find("intbi");
    if (par_it != m_ReqParams->end()) {
        TString svalue = "";

        svalue = par_it->second[0];
        svalue.to_lower(0, svalue.size());
        if (!svalue.empty()) {
            if (svalue == "on")
                IntBanIp = 1;
            else
                IntBanIp = atoi(par_it->second[0].c_str());
        } else
            IntBanIp = 0;
    } else {
        IntBanIp = 0;
    }

    if ((GetStatIPObject() != NULL) && (GetStatIPObject()->GetBasesStore() != NULL)) {
        if (fl1 && fl2) {
            bool exists_ip = false;
            TIPSumDataListIt it;
            int ip_index = -1;
            ui32 all_ip_count = 0;
            TString all_ip_count_s = "";
            ui32 index_diff = 0;
            int last_index = 0;
            TString index_s = "";
            int ip_counter = 0;

            iplist.sort();

            all_ip_count = iplist.size() > MAX_BAN_IP_COUNT ? MAX_BAN_IP_COUNT : iplist.size();
            all_ip_count_s = iplist.size() > MAX_BAN_IP_COUNT ? " (YOU ADDED MORE ADDRESSES)" : "";
            text = "Ban ip count: " + IntToStroka(all_ip_count) + all_ip_count_s + ":<br>";
            text = text + "<table border='0' width='100%' cellspacing='0' cellpadding='4'>";
            ip_counter = 0;
            it = iplist.begin();
            while (it != iplist.end()) {
                if (ip_counter < MAX_BAN_IP_COUNT) {
                    ip = (*it).ip;
                    iplink = (*it).ip_link;
                    ip_index = (*it).index;

                    index_diff = ip_index - last_index;
                    last_index = ip_index;
                    index_s = "(i" + IntToStroka(ip_index) + ":" + IntToStroka(index_diff) + ")";

                    //<tr><td width='40%'>message</td><td width='30%'>ip</td><td width='15%'>bantime</td><td width='15%'>id</td></tr>

                    pr_ok = GetStatIPObject()->GetBasesStore()->AddBlackIP(ip, bantime, IntBanIp, exists_ip, true, false, false, "userlogin", longb);
                    if (pr_ok) {
                        if (exists_ip)
                            //text = text + "IP already exists. Replace ban ip address succesfull: ip=" + iplink + ", bantime=" + IntToStroka(bantime) + ".<br>";
                            text += "<tr><td width='40%'>IP already exists. Replace ban ip address succesfull:</td><td width='30%'>ip=" + iplink + "</td><td width='15%'>bantime=" + IntToStroka(bantime) + "</td><td width='15%'>" + index_s + "</td></tr>";
                        else
                            //text = text + "Add ban ip address succesfull: ip=" + iplink + ", bantime=" + IntToStroka(bantime) + ".<br>";
                            text += "<tr><td width='40%'>Add ban ip address succesfull: </td><td width='30%'>ip=" + iplink + "</td><td width='15%'>bantime=" + IntToStroka(bantime) + "</td><td width='15%'>" + index_s + "</td></tr>";
                    } else {
                        //text = text + "Add ban ip address failed: ip=" + iplink + ", bantime=" + IntToStroka(bantime) + ".<br>";
                        text += "<tr><td width='40%'>Add ban ip address failed:</td><td width='30%'>ip=" + iplink + "</td><td width='15%'>bantime=" + IntToStroka(bantime) + "</td><td width='15%'>" + index_s + "</td></tr>";
                    }
                    ip_counter++;
                }

                ++it;
            }
            text += "</table>";
            //if ((!referer.empty()) && (!back_s.empty()))
            //   text = text + "<br><A href='" + referer + "&back=" + back_s + "'>back</A>";
            SendToClientFull(SO_LOG_MESSAGE, 200, text, id);
        }
    }
}

void TMakeRequest::AskAddBlackIp(const TString& id, TReqParams* m_ReqParams) {
    TReqParams::iterator par_it;
    TString ip_s = "";
    TString ip_s_form = "";
    TKIPv6 ip = TKIPv6();
    TString bantime_s = "";
    TString intbanip_s = "0";
    TString long_s = "0";
    bool isforward = false;
    bool ispop3 = false;
    TString questtext = "";
    TIpStatOne ms;
    TString text = "";

    //ip
    par_it = m_ReqParams->find("ip");
    if (par_it != m_ReqParams->end()) {
        ip_s = Trim(par_it->second[0]);
        ip_s_form = ip_s;
        CGIUnescape(ip_s);
        ip = TKIPv6(ip_s.c_str());
    }

    //bantime
    par_it = m_ReqParams->find("bantime");
    if (par_it != m_ReqParams->end())
        bantime_s = Trim(TString(par_it->second[0]));

    //internal or no
    par_it = m_ReqParams->find("intbi");
    if (par_it != m_ReqParams->end())
        intbanip_s = Trim(TString(par_it->second[0]));

    //long
    par_it = m_ReqParams->find("long");
    if (par_it != m_ReqParams->end())
        long_s = Trim(par_it->second[0]);

    if ((!ip.Undefined()) && (!bantime_s.empty())) {
        if ((GetStatIPObject() != NULL) && (GetStatIPObject()->GetBasesStore() != NULL)) {
            ms = GetStatIPObject()->GetBasesStore()->GetMemBasa()->GetIpStat(ip);
            if (!ms.notfound) {
                if (IS_SF_FORWARD(ms.bMask))
                    isforward = true;
                if (ms.Pop3 > 0)
                    ispop3 = true;
            }

            if (isforward)
                questtext = questtext + "Current ip is FORWARD! ";
            if (ispop3)
                questtext = questtext + "Current ip has downloaded mail on POP3! ";
            questtext = questtext + "Are you assured, what want ban this address: " + ip_s + "?";

            if (isforward || ispop3) {
                text = text + HTTP_200_OK(id);
                text = text + "<SCRIPT LANGUAGE='Javascript'>\n";
                text = text + "if(true == confirm('" + questtext + "')) {\n";
                text = text + "document.location = '" + GetHost() + GetModuleName("addblackip") + "?" + GetActionMultiParam("addblackip") + "ip=" + ip_s_form + "&bantime=" + bantime_s + "&intbi=" + intbanip_s + "&long=" + long_s + "'\n";
                text = text + "}\n";
                //text = text + "} else {\n";
                //text = text + "document.location = '" + referer + "'}\n";
                text = text + "</SCRIPT>\n";
            } else {
                text = text + HTTP_200_OK(id);
                text = text + "<html><head>";
                text = text + "<meta http-equiv=\"Expires\" content=\"Mon, 26 Jul 1997 05:00:00 GMT\" />";
                text = text + "<meta http-equiv=\"Cache-Control\" content=\"no-store, no-cache, must-revalidate\" />";
                text = text + "<meta http-equiv=\"Pragma\" content=\"no-cache\" />";
                text = text + "<meta http-equiv='refresh' content='1; url=" + GetHost() + GetModuleName("addblackip") + "?" + GetActionMultiParam("addblackip") + "ip=" + ip_s_form + "&bantime=" + bantime_s + "&intbi=" + intbanip_s + "&long=" + long_s + "'>";
                text = text + "</head><body bgcolor=palegoldenrod>\n";
                text = text + "<table border='0' width='100%' height='100%' cellspacing='0' cellpadding='4'>";
                text = text + "<tr><td valign='top'>Link for ban ip: <A href='" + GetHost() + GetModuleName("addblackip") + "?" + GetActionMultiParam("addblackip") + "ip=" + ip_s_form + "&bantime=" + bantime_s + "&intbi=" + intbanip_s + "&long=" + long_s + "'>ban ip</A></td></tr>";
                text = text + "</table></body></html>";
            }
        }
        SendToClientRAW(text);
    } else {
        SendToClientRAW(HTTP_400_BAD_REQUEST(id) + "Bad request");
    }
}

void TMakeRequest::AskAddBlackIpNew(const TString& id, TReqParams* m_ReqParams) {
    TReqParams::iterator par_it;
    TString ip_s = "";
    TString ip_s_form = "";
    TKIPv6 ip = TKIPv6();
    TString bantime_s = "";
    TString intbanip_s = "0";
    TString long_s = "0";
    bool isforward = false;
    bool ispop3 = false;
    TString questtext = "";
    TIpStatOne ms;
    TString text = "";
    TString rec_s = "";
    TString ident_ip = "ip";
    TString iplink = "";
    TIPSumDataList iplist;
    TString index_str = "";
    int index = -1;

    //ip
    par_it = m_ReqParams->begin();
    while (par_it != m_ReqParams->end()) {
        index = -1;
        index_str = "";

        rec_s = (*par_it).first;
        if ((rec_s.length() >= ident_ip.length()) && (!memcmp(rec_s.c_str(), ident_ip.c_str(), ident_ip.length()))) {
            index_str = TString(rec_s.c_str() + ident_ip.length());
            if (!index_str.empty())
                index = atoi(index_str.c_str());
            else
                index = 0;

            ip_s = Trim(par_it->second[0]);
            if (!ip_s.empty()) {
                ip_s_form = ip_s;
                CGIUnescape(ip_s);

                ip = TKIPv6(ip_s.c_str());
                if (!ip.Undefined()) {
                    if (iplist.size() > (10 * MAX_BAN_IP_COUNT))
                        break;

                    iplink = "<A href='" + GetHost() + GetModuleName("viewipstat") + "?" + GetActionMultiParam("viewipstat") + "ip=" + ip_s_form + "&nrfr=1' target='_blank'>" + ip.toStroka() + "</A>";
                    iplist.push_back(TIPSumData(ip, index, ip_s_form, iplink));
                }
            }
        }
        ++par_it;
    }

    if (iplist.size() == 0) {
        if ((GetLogsGroup() != NULL) && (GetLogsGroup()->GetServerLog() != NULL))
            GetLogsGroup()->GetServerLog()->WriteMessageAndDataStatus(KERROR, "F\tBad request - no 'ip' parameter");
        SendToClient(SO_LOG_ERROR, 400, "Bad request - no 'ip' parameter", id);
    } else {
        //bantime
        par_it = m_ReqParams->find("bantime");
        if (par_it != m_ReqParams->end())
            bantime_s = Trim(TString(par_it->second[0]));

        //internal or no
        par_it = m_ReqParams->find("intbi");
        if (par_it != m_ReqParams->end())
            intbanip_s = Trim(TString(par_it->second[0]));

        //long
        par_it = m_ReqParams->find("long");
        if (par_it != m_ReqParams->end())
            long_s = Trim(par_it->second[0]);

        if (!bantime_s.empty()) {
            TIPSumDataListIt it;
            int ip_counter = 0;
            bool first = true;
            TString w1 = "";
            TString w2 = "";
            TString w3 = "";
            int ip_index = -1;
            ui32 all_ip_count = 0;
            TString all_ip_count_s = "";
            ui32 index_diff = 0;
            int last_index = 0;
            TString index_s = "";

            iplist.sort();

            all_ip_count = iplist.size() > MAX_BAN_IP_COUNT ? MAX_BAN_IP_COUNT : iplist.size();
            all_ip_count_s = iplist.size() > MAX_BAN_IP_COUNT ? " (YOU ADDED MORE ADDRESSES)" : "";
            text = "<b>Are you sure, what you want ban next addresses (" + IntToStroka(all_ip_count) + " ip" + all_ip_count_s + ")?<b><br>";
            //text = text + "<form action='" + GetHost() + GetModuleName("addblackip") + "' method='GET' enctype='text/plain'>" + GetActionFormParam("addblackip");
            text = text + "<form action='" + GetHost() + GetModuleName("addblackip") + "' method='POST' enctype='application/x-www-form-urlencoded'>" + GetActionFormParam("addblackip");
            text = text + "<table border='0' width='100%' cellspacing='0' cellpadding='4'>";
            ip_counter = 0;
            it = iplist.begin();
            while (it != iplist.end()) {
                if (ip_counter < MAX_BAN_IP_COUNT) {
                    ip = (*it).ip;
                    ip_s_form = (*it).ip_s;
                    iplink = (*it).ip_link;
                    ip_index = (*it).index;

                    index_diff = ip_index - last_index;
                    last_index = ip_index;
                    index_s = "(i" + IntToStroka(ip_index) + ":" + IntToStroka(index_diff) + ")";

                    if ((GetStatIPObject() != NULL) && (GetStatIPObject()->GetBasesStore() != NULL)) {
                        ms = GetStatIPObject()->GetBasesStore()->GetMemBasa()->GetIpStat(ip);
                        if (!ms.notfound) {
                            if (IS_SF_FORWARD(ms.bMask))
                                isforward = true;
                            if (ms.Pop3 > 0)
                                ispop3 = true;
                        }
                        questtext = "";
                        if (isforward)
                            questtext = questtext + "Current ip is FORWARD! ";
                        if (ispop3)
                            questtext = questtext + "Current ip has downloaded mail on POP3! ";

                        if (first) {
                            w1 = " width='35%'";
                            w2 = " width='55%'";
                            w3 = " width='10%'";
                            first = false;
                        }

                        //text = text + "<tr><td" + w1 + "><input type='checkbox' size='2' name='ip" + IntToStroka3(ip_counter) + "' value='" + ip_s_form + "' CHECKED> &nbsp; " + iplink + "</td><td" + w2 + ">" + questtext + "</td><td" + w3 + ">" + index_s + "</td></tr>";
                        text = text + "<tr><td" + w1 + "><input type='checkbox' size='2' name='ip" + IntToStroka3(ip_index) + "' value='" + ip_s_form + "' CHECKED> &nbsp; " + iplink + "</td><td" + w2 + ">" + questtext + "</td><td" + w3 + ">" + index_s + "</td></tr>";
                        ip_counter++;
                    }
                } else
                    break;

                ++it;
            }
            text = text + "<tr><td colspan='2'>";
            text = text + "<input type='hidden' name='bantime' size='10' value='" + bantime_s + "'>";
            text = text + "<input type='hidden' name='intbi' size='10' value='" + intbanip_s + "'>";
            text = text + "<input type='submit' size='30' value='Next ban ip addresses'>";
            text = text + "</td></tr>";
            text = text + "</table>";
            text = text + "</form>";
            SendToClientFull(SO_LOG_MESSAGE, 200, text, id);

        } else {
            SendToClientRAW(HTTP_400_BAD_REQUEST(id) + "Bad request");
        }
    }
}

void TMakeRequest::AddBan7Ip(const TString& id, TReqParams* m_ReqParams) {
    TReqParams::iterator par_it;
    TString ident_ip = "ip";
    TString rec_s = "";
    TString ip_s = "";
    TIPSumDataList iplist;
    TKIPv6 ip = TKIPv6();
    bool fl1 = false, fl2 = false;
    TString long_s = "0";
    bool longb = false;
    TString bantime_s = "";
    ui32 bantime = 0;
    ui8 IntBanIp = 0;
    TString iplink = "";
    bool pr_ok = false;
    TString text = "";
    TString index_str = "";
    int index = -1;

    par_it = m_ReqParams->begin();
    while (par_it != m_ReqParams->end()) {
        index = -1;
        index_str = "";

        rec_s = (*par_it).first;
        if ((rec_s.length() >= ident_ip.length()) && (!memcmp(rec_s.c_str(), ident_ip.c_str(), ident_ip.length()))) {
            index_str = TString(rec_s.c_str() + ident_ip.length());
            if (!index_str.empty())
                index = atoi(index_str.c_str());
            else
                index = 0;

            ip_s = Trim(par_it->second[0]);
            if (!ip_s.empty()) {
                CGIUnescape(ip_s);
                ip = TKIPv6(ip_s.c_str());
                if (!ip.Undefined()) {
                    fl1 = true;
                    iplink = "<A href='" + GetHost() + GetModuleName("viewipstat") + "?" + GetActionMultiParam("viewipstat") + "ip=" + ip_s + "&nrfr=1'>" + ip.toStroka() + "</A>";
                    iplist.push_back(TIPSumData(ip, index, ip_s, iplink));

                    if (iplist.size() > 10 * MAX_BAN_IP_COUNT)
                        break;
                }
            }
        }
        ++par_it;
    }

    if (iplist.size() == 0) {
        if ((GetLogsGroup() != NULL) && (GetLogsGroup()->GetServerLog() != NULL))
            GetLogsGroup()->GetServerLog()->WriteMessageAndDataStatus(KERROR, "F\tBad request - no 'ip' parameter");
        SendToClient(SO_LOG_ERROR, 400, "Bad request - no 'ip' parameter", id);
    }

    par_it = m_ReqParams->find("long");
    if (par_it != m_ReqParams->end()) {
        long_s = Trim(par_it->second[0]);
        longb = (bool)atoi(long_s.c_str());
    }

    //bantime
    if (fl1) {
        par_it = m_ReqParams->find("bantime");
        if (par_it != m_ReqParams->end()) {
            bantime_s = Trim(TString(par_it->second[0]));
            bantime = atoi(bantime_s.c_str());
            if (!bantime_s.empty()) {
                fl2 = true;
            } else {
                if ((GetLogsGroup() != NULL) && (GetLogsGroup()->GetServerLog() != NULL))
                    GetLogsGroup()->GetServerLog()->WriteMessageAndDataStatus(KERROR, "F\tBad request - 'bantime' parameter empty");
                SendToClient(SO_LOG_ERROR, 400, "Bad request - 'bantime' parameter empty", id);
            }
        } else {
            if ((GetLogsGroup() != NULL) && (GetLogsGroup()->GetServerLog() != NULL))
                GetLogsGroup()->GetServerLog()->WriteMessageAndDataStatus(KERROR, "F\tBad request - no 'bantime' parameter");
            SendToClient(SO_LOG_ERROR, 400, "Bad request - no 'bantime' parameter", id);
        }
    }

    //internal or no
    par_it = m_ReqParams->find("intbi");
    if (par_it != m_ReqParams->end()) {
        TString svalue = "";

        svalue = par_it->second[0];
        svalue.to_lower(0, svalue.size());
        if (!svalue.empty()) {
            if (svalue == "on")
                IntBanIp = 1;
            else
                IntBanIp = atoi(par_it->second[0].c_str());
        } else
            IntBanIp = 0;
    } else {
        IntBanIp = 0;
    }

    if ((GetStatIPObject() != NULL) && (GetStatIPObject()->GetBasesStore() != NULL)) {
        if (fl1 && fl2) {
            bool exists_ip = false;
            TIPSumDataListIt it;

            text = "";
            it = iplist.begin();
            while (it != iplist.end()) {
                ip = (*it).ip;
                iplink = (*it).ip_link;

                pr_ok = GetStatIPObject()->GetBasesStore()->AddBan7IP(ip, bantime, exists_ip, IntBanIp, true, false, false, "userlogin");
                if (pr_ok) {
                    if (exists_ip)
                        text = text + "IP already exists. Replace ban (ban7) ip address succesfull: ip=" + iplink + ", bantime=" + IntToStroka(bantime) + ".<br>";
                    else
                        text = text + "Add ban (ban7) ip address succesfull: ip=" + iplink + ", bantime=" + IntToStroka(bantime) + ".<br>";
                } else {
                    text = text + "Add ban (ban7) ip address failed: ip=" + iplink + ", bantime=" + IntToStroka(bantime) + ".<br>";
                }

                ++it;
            }
            //if ((!referer.empty()) && (!back_s.empty()))
            //   text = text + "<br><A href='" + referer + "&back=" + back_s + "'>back</A>";
            SendToClient(SO_LOG_MESSAGE, 200, text, id);
        }
    }
}

void TMakeRequest::AskAddBan7Ip(const TString& id, TReqParams* m_ReqParams) {
    TReqParams::iterator par_it;
    TString ip_s = "";
    TString ip_s_form = "";
    TKIPv6 ip = TKIPv6();
    TString bantime_s = "";
    bool isforward = false;
    bool ispop3 = false;
    TString questtext = "";
    TIpStatOne ms;
    TString text = "";

    //ip
    par_it = m_ReqParams->find("ip");
    if (par_it != m_ReqParams->end()) {
        ip_s = Trim(par_it->second[0]);
        ip_s_form = ip_s;
        CGIUnescape(ip_s);
        ip = TKIPv6(ip_s.c_str());
    }

    //bantime
    par_it = m_ReqParams->find("bantime");
    if (par_it != m_ReqParams->end())
        bantime_s = Trim(TString(par_it->second[0]));

    if ((!ip.Undefined()) && (!bantime_s.empty())) {
        if ((GetStatIPObject() != NULL) && (GetStatIPObject()->GetBasesStore() != NULL)) {
            ms = GetStatIPObject()->GetBasesStore()->GetMemBasa()->GetIpStat(ip);
            if (!ms.notfound) {
                if (IS_SF_FORWARD(ms.bMask))
                    isforward = true;
                if (ms.Pop3 > 0)
                    ispop3 = true;
            }

            if (isforward)
                questtext = questtext + "Current ip is FORWARD! ";
            if (ispop3)
                questtext = questtext + "Current ip has downloaded mail on POP3! ";
            questtext = questtext + "Are you assured, what want ban7 this address: " + ip_s + "?";

            if (isforward || ispop3) {
                text = text + HTTP_200_OK(id);
                text = text + "<SCRIPT LANGUAGE='Javascript'>\n";
                text = text + "if(true == confirm('" + questtext + "')) {\n";
                text = text + "document.location = '" + GetHost() + GetModuleName("addban7ip") + "?" + GetActionMultiParam("addban7ip") + "ip=" + ip_s_form + "&bantime=" + bantime_s + "'\n";
                text = text + "}\n";
                //text = text + "} else {\n";
                //text = text + "document.location = '" + referer + "'}\n";
                text = text + "</SCRIPT>\n";
            } else {
                text = text + HTTP_200_OK(id);
                text = text + "<html><head>";
                text = text + "<meta http-equiv=\"Expires\" content=\"Mon, 26 Jul 1997 05:00:00 GMT\" />";
                text = text + "<meta http-equiv=\"Cache-Control\" content=\"no-store, no-cache, must-revalidate\" />";
                text = text + "<meta http-equiv=\"Pragma\" content=\"no-cache\" />";
                text = text + "<meta http-equiv='refresh' content='1; url=" + GetHost() + GetModuleName("addban7ip") + "?" + GetActionMultiParam("addban7ip") + "ip=" + ip_s_form + "&bantime=" + bantime_s + "'>";
                text = text + "</head><body bgcolor=palegoldenrod>\n";
                text = text + "<table border='0' width='100%' height='100%' cellspacing='0' cellpadding='4'>";
                text = text + "<tr><td valign='top'>Link for ban ip: <A href='" + GetHost() + GetModuleName("addban7ip") + "?" + GetActionMultiParam("addban7ip") + "ip=" + ip_s_form + "&bantime=" + bantime_s + "'>ban ip</A></td></tr>";
                text = text + "</table></body></html>";
            }
        }
        SendToClientRAW(text);
    } else {
        SendToClientRAW(HTTP_400_BAD_REQUEST(id) + "Bad request");
    }
}

void TMakeRequest::DelBanIp(const TString& id, TReqParams* m_ReqParams) {
    TReqParams::iterator par_it;
    TString ip_s = "";
    TKIPv6 ip = TKIPv6();
    TString iplink = "";
    TString ip_s_form = "";
    bool pr_ok = false;
    TString text = "";

    //ip
    par_it = m_ReqParams->find("ip");
    if (par_it != m_ReqParams->end()) {
        ip_s = Trim(par_it->second[0].c_str());
        if (!ip_s.empty()) {
            ip_s_form = ip_s;
            CGIUnescape(ip_s);
            ip = TKIPv6(ip_s.c_str());
            iplink = "<A href='" + GetHost() + GetModuleName("viewipstat") + "?" + GetActionMultiParam("viewipstat") + "ip=" + ip_s_form + "&nrfr=1'>" + ip.toStroka() + "</A>";

            if (!ip.Undefined()) {
                if ((GetStatIPObject() != NULL) && (GetStatIPObject()->GetBasesStore() != NULL)) {
                    pr_ok = GetStatIPObject()->GetBasesStore()->DelBanIP(ip);
                    if (pr_ok) {
                        text = "Remove ban ip address succesfull: ip=" + iplink + ".";

                        SendToClient(SO_LOG_MESSAGE, 200, text, id);
                    } else {
                        text = "Remove ban ip address failed: ip=" + iplink + ".";

                        SendToClient(SO_LOG_MESSAGE, 501, text, id);
                    }
                } else
                    SendToClientRAW(HTTP_501_NOT_IMPLEMENTED());
            }
        } else {
            SendToClient(SO_LOG_ERROR, 400, "Bad request - bad 'ip' parameter.", id);
        }
    } else {
        if ((GetLogsGroup() != NULL) && (GetLogsGroup()->GetServerLog() != NULL))
            GetLogsGroup()->GetServerLog()->WriteMessageAndDataStatus(KERROR, "F\tBad request - no 'ip' parameter");
        SendToClient(SO_LOG_ERROR, 400, "Bad request - no 'ip' parameter.", id);
    }
}

void TMakeRequest::AskDelBanIp(const TString& id, TReqParams* m_ReqParams) {
    TReqParams::iterator par_it;
    TString ip_s = "";
    TKIPv6 ip = TKIPv6();
    TString iplink = "";
    TString ip_s_form = "";
    bool pr_ok = false;
    TString text = "";

    //ip
    par_it = m_ReqParams->find("ip");
    if (par_it != m_ReqParams->end()) {
        ip_s = Trim(par_it->second[0].c_str());
        if (!ip_s.empty()) {
            ip_s_form = ip_s;
            CGIUnescape(ip_s);
            ip = TKIPv6(ip_s.c_str());
            //iplink = "<A href='" + GetHost() + GetModuleName("viewipstat") + "?" + GetActionMultiParam("viewipstat") + "ip=" + ip_s_form + "&nrfr=1'>" + ip.toStroka() + "</A>";

            if (!ip.Undefined()) {
                text = text + HTTP_200_OK(id);
                text = text + "<SCRIPT LANGUAGE='Javascript'>\n";
                text = text + "if(true == confirm('Remove ban ip: " + ip.toStroka() + " ?')) {\n";
                text = text + "document.location = '" + GetHost() + GetModuleName("delbanip") + GetActionOneParam("delbanip") + "&ip=" + ip_s_form + "'\n";
                text = text + "}\n";
                //text = text + "} else {\n";
                //text = text + "document.location = '" + GetHost() + "console'}\n";
                //text = text + "document.location = '" + referer + "'}\n";
                text = text + "</SCRIPT>\n";
                SendToClientRAW(text);
            }
        } else {
            SendToClient(SO_LOG_ERROR, 400, "Bad request - bad 'ip' parameter.", id);
        }
    } else {
        if ((GetLogsGroup() != NULL) && (GetLogsGroup()->GetServerLog() != NULL))
            GetLogsGroup()->GetServerLog()->WriteMessageAndDataStatus(KERROR, "F\tBad request - no 'ip' parameter");
        SendToClient(SO_LOG_ERROR, 400, "Bad request - no 'ip' parameter.", id);
    }
}

void TMakeRequest::ViewRuleTrap(const TString& id) {
    if ((GetStatIPObject() != NULL) && (GetStatIPObject()->GetRuleTrap() != NULL)) {
        TListRuleStat listrulestat;
        TString text = "";
        TListRuleStatIt it;
        TString dellink = "";
        TString rulenamelink = "";

        GetStatIPObject()->GetRuleTrap()->GetRuleStat(listrulestat);

        TString saddstatrule = "<form action='" + GetHost() + GetModuleName("addstatrule") + "' method='GET' enctype='text/plain'><b>Add rule:</b>&nbsp;&nbsp;<input type='text' size='10' name='rulename' value=''>&nbsp;<input type='text' size='10' name='livetime' value='600'>&nbsp;" + GetActionFormParam("addstatrule") + "<input type='submit' size='10' value='add'></form>";

        text = text + "<center><b>VIEW RULE STATISTIK</b></center><hr><br>";
        text = text + saddstatrule;
        text = text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=lemonchiffon>\n";
        text = text + "<tr valign='top' bgcolor='" + TString(BGSHAPCOLOR) + "'>";
        text = text + "<td align='left' width='30%'><b>RULENAME</b></td>";
        text = text + "<td width='15%'><b>IP COUNT</b></td>";
        text = text + "<td width='25%'><b>SEC ESTIMATED</b></td>";
        text = text + "<td width='30%'> &nbsp </td>";
        text = text + "</tr>\n";

        it = listrulestat.begin();
        while (it != listrulestat.end()) {
            rulenamelink = (*it).rulename;
            if (!rulenamelink.empty())
                CGIEscape(rulenamelink);
            dellink = "<A href='" + GetHost() + GetModuleName("delstatrule") + GetActionOneParam("delstatrule") + "&rulename=" + rulenamelink + "'>delete rule</A>\n";

            text = text + "<tr valign='top'>";
            text = text + "<td align='left' width='30%'>" + (*it).rulename + " &nbsp</td>";
            text = text + "<td width='15%'>" + IntToStroka((*it).count) + " &nbsp</td>";
            text = text + "<td width='25%'>" + IntToStroka((*it).estimated) + " &nbsp</td>";
            text = text + "<td width='30%'>" + dellink + " &nbsp</td>";
            text = text + "</tr>\n";

            ++it;
        }
        text = text + "</table>\n";

        SendToClientWithShap(SO_LOG_MESSAGE, 200, text, id);
    } else
        SendToClientRAW(HTTP_501_NOT_IMPLEMENTED());
}

void TMakeRequest::AddStatRule(const TString& id, TReqParams* m_ReqParams) {
    TString text = "";
    TReqParams::iterator par_it;
    TString rulename = "";
    ui32 livetime = 0;

    if ((GetStatIPObject() != NULL) && (GetStatIPObject()->GetRuleTrap() != NULL)) {
        par_it = m_ReqParams->find("rulename");
        if (par_it != m_ReqParams->end()) {
            rulename = Trim(par_it->second[0].c_str());
            if (!rulename.empty())
                CGIUnescape(rulename);
        }

        par_it = m_ReqParams->find("livetime");
        if (par_it != m_ReqParams->end())
            livetime = atoi(par_it->second[0].c_str());

        if ((!rulename.empty()) && (livetime > 0)) {
            GetStatIPObject()->GetRuleTrap()->AddRule(rulename, livetime);
            text = text + "Add rule '" + rulename + "' - OK.<br>";
            text = text + "<A href='" + GetHost() + GetModuleName("viewrulestat") + "'>Back</A>\n";
            SendToClient(SO_LOG_MESSAGE, 200, text, id);
        } else {
            text = text + "Add rule '" + rulename + "' - Failed. No 'rulename' or 'livetime' parameters.<br>";
            text = text + "<A href='" + GetHost() + GetModuleName("viewrulestat") + "'>Back</A>\n";
            SendToClient(SO_LOG_ERROR, 400, text, id);
        }
    } else
        SendToClientRAW(HTTP_501_NOT_IMPLEMENTED());
}

void TMakeRequest::DelStatRule(const TString& id, TReqParams* m_ReqParams) {
    TString text = "";
    TReqParams::iterator par_it;
    TString rulename = "";

    if ((GetStatIPObject() != NULL) && (GetStatIPObject()->GetRuleTrap() != NULL)) {
        par_it = m_ReqParams->find("rulename");
        if (par_it != m_ReqParams->end()) {
            rulename = Trim(par_it->second[0].c_str());
            if (!rulename.empty())
                CGIUnescape(rulename);
        }

        if (!rulename.empty()) {
            GetStatIPObject()->GetRuleTrap()->DeleteRule(rulename);
            text = text + "Delete rule '" + rulename + "' - OK.<br>";
            text = text + "<A href='" + GetHost() + GetModuleName("viewrulestat") + "'>Back</A>\n";
            SendToClientWithShap(SO_LOG_MESSAGE, 200, text, id);
        } else {
            text = text + "Delete rule '" + rulename + "' - Failed. No 'rulename' parameter.<br>";
            text = text + "<A href='" + GetHost() + GetModuleName("viewrulestat") + "'>Back</A>\n";
            SendToClientWithShap(SO_LOG_ERROR, 400, text, id);
        }
    } else
        SendToClientRAW(HTTP_501_NOT_IMPLEMENTED());
}

void TMakeRequest::BanControl(const TString& id) {
    TString text = "";
    ui32 bantime_default = TBanIPListItem::MAX_BAN_HOURS;
    ui32 long_bantime_default = TBanIPListItem::MAX_BAN_HOURS_LONG;

    if ((GetStatIPObject() != NULL) && (GetStatIPObject()->GetCPO() != NULL)) {
        if (GetStatIPObject()->EnableObrabMess()) {
            TString sAddBanTime = "???";
            TString sRepeaterBase = "???";

            TSummaryInfo propsummaryinfo = GetStatIPObject()->GetChangePropSummaryInfo();
            if (propsummaryinfo.yes_data) {
                sAddBanTime = IntToStroka(propsummaryinfo.chpropsi.AddBanTime);
                sRepeaterBase = IntToStroka(propsummaryinfo.chpropsi.RepeaterBase);
            }

            if (GetStatIPObject()->GetBasesStore() != NULL)
                GetStatIPObject()->GetBasesStore()->GetSetupBanTime(bantime_default, long_bantime_default);

            TString saddbantime = "<form action='" + GetHost() + GetModuleName("setaddbantime") + "' method='GET' enctype='text/plain'><input type='text' size='10' name='addbantime' value='" + IntToStroka(GetStatIPObject()->GetCPO()->GetAddBanTime()) + "'> &nbsp; " + GetActionFormParam("setaddbantime") + "<input type='submit' size='10' value='set'></form>";
            TString srepeaterbase = "<form action='" + GetHost() + GetModuleName("setrptbase") + "' method='GET' enctype='text/plain'><input type='text' size='10' name='rptbase' value='" + IntToStroka(GetStatIPObject()->GetCPO()->GetRepeaterBase()) + "'> &nbsp; " + GetActionFormParam("setrptbase") + "<input type='submit' size='10' value='set'></form>";
            TString saddblackip = "<form action='" + GetHost() + GetModuleName("askaddblackip") + "' method='GET' enctype='text/plain'>ip-address: &nbsp <input type='text' size='20' name='ip' value=''>&nbsp ban time (< " + IntToStroka(TBanIPListItem::MAX_BAN_HOURS) + " hour): &nbsp <input type='text' size='10' name='bantime' value='" + IntToStroka(bantime_default) + "'> &nbsp <input type='checkbox' size='10' name='intbi' value='1'>internal &nbsp " + GetActionFormParam("askaddblackip") + "<input type='submit' size='10' value='add'></form>";
            TString sdelbanip = "<form action='" + GetHost() + GetModuleName("askdelbanip") + "' method='GET' enctype='text/plain'>ip-address: &nbsp <input type='text' size='20' name='ip' value=''> &nbsp; " + GetActionFormParam("askdelbanip") + "<input type='submit' size='10' value='del'></form>";

            text = text + "<br><i><b>Ban control:</b></i>&nbsp;&nbsp;\n";
            text = text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=lemonchiffon>\n";
            text = text + "<tr valign='top'><td align='left' width='30%'>AddBanTime</td><td width='45%' align='left'>\n" + sAddBanTime + " &nbsp</td><td width='25%' align='center'><br>" + saddbantime + "</td></tr>\n";
            text = text + "<tr valign='top'><td align='left' width='30%'>Repeater base</td><td width='45%' align='left'>\n" + sRepeaterBase + " &nbsp</td><td width='25%' align='center'><br>" + srepeaterbase + "</td></tr>\n";
            text = text + "<tr valign='top'><td align='left' width='30%'>Add black ip</td><td width='70%' colspan='2' align='center'><br>" + saddblackip + " &nbsp</td></tr>\n";
            text = text + "<tr valign='top'><td align='left' width='30%'>Remove ban ip</td><td width='70%' colspan='2' align='center'><br>" + sdelbanip + " &nbsp</td></tr>\n";
            text = text + "</table>\n";
        } else {
            text = text + "Functionality disabled.";
        }
    }
    SendToClientWithLittleShap(SO_LOG_MESSAGE, 200, text, id);
}

void TMakeRequest::ClearIPStat(const TString& id, TReqParams* m_ReqParams) {
    TReqParams::iterator par_it;
    TString ip_s = "";
    TKIPv6 ip = TKIPv6();
    TString iplink = "";
    TString ip_s_form = "";
    bool pr_ok = false;
    TString text = "";

    //ip
    par_it = m_ReqParams->find("ip");
    if (par_it != m_ReqParams->end()) {
        ip_s = Trim(par_it->second[0].c_str());
        if (!ip_s.empty()) {
            ip_s_form = ip_s;
            CGIUnescape(ip_s);
            ip = TKIPv6(ip_s.c_str());
            iplink = "<A href='" + GetHost() + GetModuleName("viewipstat") + "?" + GetActionMultiParam("viewipstat") + "ip=" + ip_s_form + "&nrfr=1'>" + ip.toStroka() + "</A>";

            if (!ip.Undefined()) {
                if ((GetStatIPObject() != NULL) && (GetStatIPObject()->GetBasesStore() != NULL) && (GetStatIPObject()->GetBasesStore()->GetMemBasa() != NULL)) {
                    pr_ok = GetStatIPObject()->GetBasesStore()->GetMemBasa()->mClearStat(ip);
                    if (pr_ok)
                        text = text + "Statistik IP (" + iplink + ") cleaned - succesfully.";
                    else
                        text = text + "Statistik IP (" + iplink + ") cleaned - failed.";

                    SendToClient(SO_LOG_MESSAGE, 200, text, id);

                } else
                    SendToClientRAW(HTTP_501_NOT_IMPLEMENTED());
            }
        } else {
            SendToClient(SO_LOG_ERROR, 400, "Bad request - bad 'ip' parameter.", id);
        }
    } else {
        if ((GetLogsGroup() != NULL) && (GetLogsGroup()->GetServerLog() != NULL))
            GetLogsGroup()->GetServerLog()->WriteMessageAndDataStatus(KERROR, "F\tBad request - no 'ip' parameter");
        SendToClient(SO_LOG_ERROR, 400, "Bad request - no 'ip' parameter.", id);
    }
}

void TMakeRequest::BanInfo(const TString& id, TReqParams* m_ReqParams) {
    TReqParams::iterator par_it;
    TString text = "";
    ui8 sorttype = 0;
    ui8 sorttype2 = 0;
    TDoubleBanIpBasicList banstatlist;
    TString sm1 = "", sm2 = "", sm3 = "", sm4 = "", sm5 = "";
    TString field1 = "";
    TString field2 = "";
    TString field3 = "";
    TString field4 = "";
    TString field5 = "";
    TString field6 = "";
    TString field7 = "";
    TString field8 = "";
    TString field9 = "";
    TString remurl = "";
    TString ipurl = "";
    TString title = "";
    TString baninfo_key1 = "";
    TString baninfo_key2 = "";
    TString baninfo_key3 = "";
    TString baninfo_key4 = "";
    TString baninfo_key5 = "";
    TString baninfo_key = "";
    TDoubleBanIpBasicListIt bit;
    TString s_field1 = "";
    TString s_field2 = "";
    TString s_field3 = "";
    TString s_field4 = "";
    TString s_field5 = "";
    TString s_field6 = "";
    TString s_field7 = "";
    TString s_field8 = "";
    TString s_field9 = "";
    TString s_field10 = "";
    TKIPv6 ip = TKIPv6();
    ui32 fulltick = 0;
    ui32 reqtick = 0;
    ui32 answertick = 0;
    ui32 remain_time = 0;
    ui32 remain7_time = 0;
    ui32 lastbantime = 0;
    ui32 lastbantime7 = 0;

    par_it = m_ReqParams->find("sorttype");
    if (par_it != m_ReqParams->end())
        sorttype = atoi(par_it->second[0].c_str());

    par_it = m_ReqParams->find("sortparam");
    if (par_it != m_ReqParams->end())
        sorttype2 = atoi(par_it->second[0].c_str());

    if ((GetStatIPObject() != NULL) && (GetStatIPObject()->GetBasesStore() != NULL) && (GetStatIPObject()->GetBasesStore()->GetBanIP() != NULL)) {
        //text = maino->StatIPObject->GetBasesStore()->GetBanIP()->WriteFullListInfo(GetHost(), sorttype, sorttype2);

        switch (sorttype2) {
            case 1:
                sm2 = "*";
                break;
            case 2:
                sm3 = "*";
                break;
            case 3:
                sm4 = "*";
                break;
            case 4:
                sm5 = "*";
                break;
            default:
                sm1 = "*";
        };

        //GetModuleName("deluser") + "?" + GetActionMultiParam("deluser")

        field1 = "<A href='" + GetHost() + GetModuleName("baninfo") + "?" + GetActionMultiParam("baninfo") + "sorttype=" + IntToStroka(sorttype) + "&sortparam=0'>" + sm1 + "BAN IP</A>";
        field2 = "<A href='" + GetHost() + GetModuleName("baninfo") + "?" + GetActionMultiParam("baninfo") + "sorttype=" + IntToStroka(sorttype) + "&sortparam=2'>" + sm3 + "BAN TIME</A>&nbsp;<A href='" + GetHost() + GetModuleName("baninfo") + "?" + GetActionMultiParam("baninfo") + "sorttype=" + IntToStroka(sorttype) + "&sortparam=1'>(" + sm2 + "HOURS)</A>";
        field3 = "REMAIN";
        field8 = "MESCNT";
        field4 = "BAN KIND";
        field5 = "<A href='" + GetHost() + GetModuleName("baninfo") + "?" + GetActionMultiParam("baninfo") + "sorttype=" + IntToStroka(sorttype) + "&sortparam=4'>" + sm5 + "BAN TIME</A>&nbsp;<A href='" + GetHost() + GetModuleName("baninfo") + "?" + GetActionMultiParam("baninfo") + "sorttype=" + IntToStroka(sorttype) + "&sortparam=3'>(" + sm4 + "HOURS)</A>";
        field6 = "REMAIN";
        field9 = "MESCNT";
        field7 = "BAN KIND";

        if (false) {
            if ((sorttype == 0) || (sorttype > 4))
                baninfo_key1 = "<I><B>ALL BAN IP</B></I>";
            else
                baninfo_key1 = "<form action='" + GetHost() + GetModuleName("baninfo") + "' method='GET' enctype='text/plain'><input type='hidden' size='10' name='sorttype' value='0'>" + GetActionFormParam("baninfo") + "<input type='submit' size='20' value='All ban ip'></form> &nbsp; ";
        }

        if (false) {
            if (sorttype == 1)
                baninfo_key2 = "<I><B>INTERNAL BAN IP</B></I>";
            else
                baninfo_key2 = "<form action='" + GetHost() + GetModuleName("baninfo") + "' method='GET' enctype='text/plain'><input type='hidden' size='10' name='sorttype' value='1'>" + GetActionFormParam("baninfo") + "<input type='submit' size='20' value='Internal ban ip'></form> &nbsp; ";
        }

        if (sorttype == 2)
            baninfo_key3 = "<I><B>MANUAL BAN IP</B></I>";
        else
            baninfo_key3 = "<form action='" + GetHost() + GetModuleName("baninfo") + "' method='GET' enctype='text/plain'><input type='hidden' size='10' name='sorttype' value='2'>" + GetActionFormParam("baninfo") + "<input type='submit' size='20' value='Manual ban ip'></form> &nbsp; ";

        if (sorttype == 3)
            baninfo_key4 = "<I><B>BLACKLIST BAN IP</B></I>";
        else
            baninfo_key4 = "<form action='" + GetHost() + GetModuleName("baninfo") + "' method='GET' enctype='text/plain'><input type='hidden' size='10' name='sorttype' value='3'>" + GetActionFormParam("baninfo") + "<input type='submit' size='20' value='Blacklist ban ip'></form> &nbsp; ";

        if (false) {
            if (sorttype == 4)
                baninfo_key5 = "<I><B>RULE BAN IP</B></I>";
            else
                baninfo_key5 = "<form action='" + GetHost() + GetModuleName("baninfo") + "' method='GET' enctype='text/plain'><input type='hidden' size='10' name='sorttype' value='4'>" + GetActionFormParam("baninfo") + "<input type='submit' size='20' value='Rule ban ip'></form> &nbsp; ";
        }

        baninfo_key = "<br><table width='100%' cellspacing='0' cellpadding='0'><tr><td width='20%' align='center'>" + baninfo_key1 + "</td><td width='20%' align='center'>" + baninfo_key2 + "</td><td width='20%' align='center'>" + baninfo_key3 + "</td><td width='20%' align='center'>" + baninfo_key4 + "</td><td width='20%' align='center'>" + baninfo_key5 + "</td></tr></table>";

        if ((sorttype != 1) && (sorttype != 2) && (sorttype != 3)) {
            text = text + "Function is disconnected.";
        } else {
            fulltick = CShingleTime::GetMs();

            reqtick = CShingleTime::GetMs();
            GetStatIPObject()->GetBasesStore()->GetBanIP()->WriteFullListInfo2(banstatlist, sorttype, sorttype2);
            reqtick = CShingleTime::GetMs() - reqtick;

            lastbantime = GetStatIPObject()->GetBasesStore()->GetBanIP()->GetStat().m_LastBanTime;
            lastbantime7 = GetStatIPObject()->GetBasesStore()->GetBanIP()->GetStat7().m_LastBanTime;

            answertick = CShingleTime::GetMs();
            text = text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=lemonchiffon>\n";
            text = text + "<tr><td width='100%' colspan=10 align='center'>" + baninfo_key + "</td></tr>";
            text = text + "<tr bgcolor='Moccasin'>";
            text = text + "<td width='20%' colspan='2'>&nbsp;</td>";
            text = text + "<td colspan='4' width='40%' align='center'><b>BAN</b> (last ban:&nbsp; " + TimeToStr(lastbantime) + ")</td>";
            text = text + "<td colspan='4' width='40%' align='center'><b>BAN7</b> (last ban:&nbsp; " + TimeToStr(lastbantime7) + ")</td>";
            text = text + "</tr>";
            text = text + "<tr bgcolor='Moccasin' align='center'>";
            text = text + "<td width='20%' colspan='2'><b>" + field1 + "</b></td>";
            text = text + "<td width='15%'><b>" + field2 + "</b></td>";
            text = text + "<td width='5%'><b>" + field3 + "</b></td>";
            text = text + "<td width='5%'><b>" + field8 + "</b></td>";
            text = text + "<td width='15%'><b>" + field4 + "</b></td>";
            text = text + "<td width='15%'><b>" + field5 + "</b></td>";
            text = text + "<td width='5%'><b>" + field6 + "</b></td>";
            text = text + "<td width='5%'><b>" + field9 + "</b></td>";
            text = text + "<td width='15%'><b>" + field7 + "</b></td>";
            text = text + "</tr>";

            bit = banstatlist.begin();
            while (bit != banstatlist.end()) {
                ip = (*bit).ip;

                remurl = "<A href='" + GetHost() + GetModuleName("askdelbanip") + GetActionOneParam("askdelbanip") + "&ip=" + ip.toStroka() + "'>remove ban</A>";
                ipurl = "<A href='" + GetHost() + GetModuleName("viewipstat") + GetActionOneParam("viewipstat") + "&ip=" + ip.toStroka() + "'>" + ip.toStroka() + "</A>";
                s_field1 = ipurl;
                s_field2 = remurl;

                if ((*bit).ban[0].tAction > 0) {
                    remain_time = GetStatIPObject()->GetBasesStore()->GetBanIP()->RemainBan((*bit).ban[0]);

                    s_field3 = ConvertTime3((*bit).ban[0].tAction) + " &nbsp;<b>(" + IntToStroka((*bit).ban[0].chours) + ")</b>";
                    s_field9 = IntToHourMinSec(remain_time);
                    s_field4 = IntToStroka((*bit).ban[0].cMessage);
                    s_field5 = "";
                    if (((*bit).ban[0].cIntBanIp & 0x01) > 0)
                        s_field5 = s_field5 + "INTBAN &nbsp; ";
                    if (((*bit).ban[0].cIntBanIp & 0x02) > 0) {
                        s_field5 = s_field5 + "MANUAL (\"" + TString((*bit).ban[0].cUser) + "\") &nbsp; ";
                    }
                    if (((*bit).ban[0].cIntBanIp & 0x04) > 0)
                        s_field5 = s_field5 + "BLACKLIST &nbsp; ";
                    if (((*bit).ban[0].cIntBanIp & 0x08) > 0)
                        s_field5 = s_field5 + "RULE &nbsp; ";
                    s_field5 = s_field5 + " &nbsp; ";
                } else {
                    s_field3 = " - ";
                    s_field9 = " - ";
                    s_field4 = " &nbsp; ";
                    s_field5 = " &nbsp; ";
                }

                if ((*bit).ban[1].tAction > 0) {
                    remain7_time = GetStatIPObject()->GetBasesStore()->GetBanIP()->RemainBan7((*bit).ban[1]);

                    s_field6 = ConvertTime3((*bit).ban[1].tAction) + " &nbsp;<b>(" + IntToStroka((*bit).ban[1].chours) + ")</b>";
                    s_field10 = IntToHourMinSec(remain7_time);
                    s_field7 = IntToStroka((*bit).ban[1].cMessage);
                    s_field8 = "";
                    if (((*bit).ban[1].cIntBanIp & 0x01) > 0)
                        s_field8 = s_field8 + "INTBAN &nbsp; ";
                    if (((*bit).ban[1].cIntBanIp & 0x02) > 0)
                        s_field8 = s_field8 + "MANUAL (\"" + TString((*bit).ban[1].cUser) + "\") &nbsp; ";
                    if (((*bit).ban[1].cIntBanIp & 0x04) > 0)
                        s_field8 = s_field8 + "BLACKLIST &nbsp; ";
                    if (((*bit).ban[1].cIntBanIp & 0x08) > 0)
                        s_field8 = s_field8 + "RULE &nbsp; ";
                    s_field8 = s_field8 + "&nbsp;";
                } else {
                    s_field6 = " - ";
                    s_field10 = " - ";
                    s_field7 = " &nbsp; ";
                    s_field8 = " &nbsp; ";
                }

                text = text + "<tr>";
                text = text + "<td>" + s_field1 + " &nbsp; </td>";
                text = text + "<td align='center'>" + s_field2 + " &nbsp; </td>";
                text = text + "<td>" + s_field3 + " &nbsp; </td>";
                text = text + "<td>" + s_field9 + " &nbsp; </td>";
                text = text + "<td>" + s_field4 + " &nbsp; </td>";
                text = text + "<td>" + s_field5 + " &nbsp; </td>";
                text = text + "<td>" + s_field6 + " &nbsp; </td>";
                text = text + "<td>" + s_field10 + " &nbsp; </td>";
                text = text + "<td>" + s_field7 + " &nbsp; </td>";
                text = text + "<td>" + s_field8 + " &nbsp; </td>";
                text = text + "</tr>";

                ++bit;
            }

            text = text + "</table>";

            answertick = CShingleTime::GetMs() - answertick;
            fulltick = CShingleTime::GetMs() - fulltick;
            text = text + "Found " + IntToStroka(banstatlist.size()) + " record to " + IntToStroka(fulltick) + " (" + IntToStroka(reqtick) + "," + IntToStroka(answertick) + ") msec.";

            banstatlist.clear();
        }

        SendToClientWithLittleShap(SO_LOG_MESSAGE, 200, text, id);
    } else {
        SendToClientRAW(HTTP_501_NOT_IMPLEMENTED());
    }
}

void TMakeRequest::ViewIPStat(const TString& id, TReqParams* m_ReqParams) {
    TReqParams::iterator par_it;
    TString ips = "";
    TWKIPv6 value;
    TNetKIPv6::TRecordType type;

    par_it = m_ReqParams->find("ip");
    if (par_it != m_ReqParams->end()) {
        ips = Trim(par_it->second[0]);
        CGIUnescape(ips);

        if (wnet != NULL) {
            type = wnet->GetAddresses(ips, value);
            switch (type) {
                case TNetKIPv6::TIPADDRESS:
                    ViewIPStatAddress(id, ips, value);
                    break;
                case TNetKIPv6::TIPNET:
                case TNetKIPv6::TIPRANGE:
                    ViewIPStatNet(id, ips, value);
                    break;
            };
        }
    } else {
        SendToClientWithShap(SO_LOG_ERROR, 400, "bad request", "-");
    }
}

void TMakeRequest::ViewIPStatAddress(const TString& id, const TString& ips, const TWKIPv6& value) {
    TString text = "";
    TString back_ss = "";

    if (GetStatIPObject() != NULL) {
        if ((GetStatIPObject()->GetBasesStore() != NULL) && (GetStatIPObject()->GetBasesStore()->GetBanIP() != NULL) && (GetStatIPObject()->GetBasesStore()->GetMemBasa() != NULL)) {
            TIpStatOne ms;
            TBanIpBasic tban;
            TBanIpBasic tban7;
            ui16 AddBanTime = 0;
            TBanRes banres;
            TString sban = "";
            TString sbanuser = "";
            TString sbansost = "";
            TString innerban = "";
            TString saction = "";
            TString shours = "";
            TString sban7 = "";
            TString sban7user = "";
            TString sban7sost = "";
            TString saction7 = "";
            TString shours7 = "";
            bool forwards = false, banprob = false;
            TString mask = "";
            TString ymask = "";
            TString sbansummary = "";
            TString sban7summary = "";
            TString sbancolor = "";
            TString sban7color = "";
            TString ip_s = "";
            TString ip_s_form = "";
            ui32 catchdelay = 60;
            TKIPv6 ip = TKIPv6();
            bool result = false;
            TString getbyidlink = "";
            TString getbyidlink2 = "";
            ui32 bantime_default = 0;
            ui32 long_bantime_default = 0;
            TWeightIPLocalCacheItem ip_cachestat;

            ip = value.ip1;
            ip_s = ip.toStroka();
            ip_s_form = ip.toStroka();
            CGIEscape(ip_s_form);

            TString sbanip = "&nbsp;";
            TString sbaniplong = "&nbsp;";
            TString sdelbanip = "&nbsp;";
            TString sbanip7 = "&nbsp;";
            TString catchrequest = "<form action='" + GetHost() + GetModuleName("catchip") + "' method='GET' enctype='text/plain' target='_blank'><input type='hidden' size='20' name='ip' value='" + ip_s_form + "'>&nbsp delay time: &nbsp <input type='text' size='10' name='delay' value='" + IntToStroka(catchdelay) + "'> &nbsp; " + GetActionFormParam("catchip") + "<input type='submit' size='10' value='catch mails'></form>";
            TString ban3log1 = "<form action='" + GetHost() + GetModuleName("findb3log") + "' method='GET' enctype='text/plain'><input type='hidden' size='10' name='day' value='1'><input type='hidden' size='10' name='ip' value='" + ip_s_form + "'><input type='hidden' size='10' name='diskindex' value='0'>" + GetActionFormParam("findb3log") + "<input type='submit' size='10' value='for 1 day'></form>";
            TString ban3log2 = "<form action='" + GetHost() + GetModuleName("findb3log") + "' method='GET' enctype='text/plain'><input type='hidden' size='10' name='day' value='2'><input type='hidden' size='10' name='ip' value='" + ip_s_form + "'><input type='hidden' size='10' name='diskindex' value='0'>" + GetActionFormParam("findb3log") + "<input type='submit' size='10' value='for 2 days'></form>";
            TString ban3log3 = "<form action='" + GetHost() + GetModuleName("findb3log") + "' method='GET' enctype='text/plain'><input type='hidden' size='10' name='day' value='3'><input type='hidden' size='10' name='ip' value='" + ip_s_form + "'><input type='hidden' size='10' name='diskindex' value='0'>" + GetActionFormParam("findb3log") + "<input type='submit' size='10' value='for 3 days'></form>";
            TString ban3logv = "<form action='" + GetHost() + GetModuleName("findb3log") + "' method='GET' enctype='text/plain'> days: <input type='text' size='10' name='day' value='5'><input type='hidden' size='10' name='ip' value='" + ip_s_form + "'>, &nbsp; no write disk index: <input type='checkbox' size='10' name='diskindex' value='1'> &nbsp; " + GetActionFormParam("findb3log") + "<input type='submit' size='10' value='get'></form>";
            TString ban3log = "";
            ban3log = ban3log + "<br><table border='0' width='100%' cellspacing='0' cellpadding='4' bgcolor=lemonchiffon>\n";
            ban3log = ban3log + "<tr><td width='15%' align='center'>" + ban3log1 + "</td><td width='15%' align='center'>" + ban3log2 + "</td><td width='15%' align='center'>" + ban3log3 + "</td><td width='55%' align='center'>" + ban3logv + "</td></tr>";
            ban3log = ban3log + "</table>";

            sdelbanip = "<br><form action='" + GetHost() + GetModuleName("askdelbanip") + "' method='GET' enctype='text/plain'>" + back_ss + "<input type='hidden' size='20' name='ip' value='" + ip_s_form + "'> &nbsp; " + GetActionFormParam("askdelbanip") + "<input type='submit' size='10' value='remove ban'></form>";

            GetStatIPObject()->GetBasesStore()->GetSetupBanTime(bantime_default, long_bantime_default);

            banres = GetStatIPObject()->GetBasesStore()->GetBanIP()->GetBanStatus(value.ip1, AddBanTime, tban, tban7);
            if (banres.ban) {
                if ((tban.cIntBanIp & 0x01) > 0)
                    innerban = "yes";
                else
                    innerban = "no";
                saction = ConvertTime(tban.tAction);
                shours = IntToStroka(tban.chours);
                sbanuser = Trim(TString(tban.cUser));

                sbansost = "";
                if ((tban.cIntBanIp & 0x01) > 0)
                    sbansost = sbansost + "INTBAN &nbsp; ";
                if ((tban.cIntBanIp & 0x02) > 0)
                    sbansost = sbansost + "MANUAL (\"" + TString(tban.cUser) + "\") &nbsp; ";
                if ((tban.cIntBanIp & 0x04) > 0)
                    sbansost = sbansost + "BLACKLIST &nbsp; ";
                if ((tban.cIntBanIp & 0x08) > 0)
                    sbansost = sbansost + "RULE &nbsp; ";

                TString checkedflag = "";

                if ((tban.cIntBanIp & 0x01) > 0)
                    checkedflag = "CHECKED";

                sbanip = "<br><form action='" + GetHost() + GetModuleName("askaddblackip") + "' method='GET' enctype='text/plain'>" + back_ss + "<input type='hidden' size='20' name='ip' value='" + ip_s_form + "'>&nbsp ban time (<=" + IntToStroka(TBanIPListItem::MAX_BAN_HOURS) + " hour): &nbsp <input type='text' size='10' name='bantime' value='" + IntToStroka(bantime_default) + "'> &nbsp <input type='checkbox' size='10' name='intbi' " + checkedflag + ">internal &nbsp " + GetActionFormParam("askaddblackip") + "<input type='submit' size='10' value='ban ip'></form>";
                sbaniplong = "<br><form action='" + GetHost() + GetModuleName("askaddblackil") + "' method='GET' enctype='text/plain'>" + back_ss + "<input type='hidden' size='20' name='long' value='1'><input type='hidden' size='20' name='ip' value='" + ip_s_form + "'>&nbsp ban time (<=" + IntToStroka(TBanIPListItem::MAX_BAN_HOURS_LONG) + " hour): &nbsp <input type='text' size='10' name='bantime' value='" + IntToStroka(long_bantime_default) + "'> &nbsp <input type='checkbox' size='10' name='intbi' " + checkedflag + ">internal &nbsp " + GetActionFormParam("askaddblackil") + "<input type='submit' size='10' value='long ban ip'></form>";

                sban = sban + "<table border='0' width='100%' cellspacing='0' cellpadding='4'>\n";
                sban = sban + "<tr><td width = '40%'> yes &nbsp; (remain " + IntToHourMinSec(banres.remainban) + ")</td><td width = '40%'>" + sbansost + " &nbsp;</td><td width = '20%'>" + sdelbanip + "</td></tr>";
                sban = sban + "</table>";

                sbancolor = "bgcolor='LightPink'";
            } else {
                sbanuser = "";
                sban = "no";
                innerban = "-";
                saction = "-";
                shours = "-";
                sbancolor = "";

                sbanip = "<br><form action='" + GetHost() + GetModuleName("askaddblackip") + "' method='GET' enctype='text/plain'>" + back_ss + "<input type='hidden' size='20' name='ip' value='" + ip_s_form + "'>&nbsp ban time (<=" + IntToStroka(TBanIPListItem::MAX_BAN_HOURS) + " hour): &nbsp <input type='text' size='10' name='bantime' value='" + IntToStroka(bantime_default) + "'> &nbsp <input type='checkbox' size='10' name='intbi'>internal &nbsp " + GetActionFormParam("askaddblackip") + "<input type='submit' size='10' value='ban ip'></form>";
                sbaniplong = "<br><form action='" + GetHost() + GetModuleName("askaddblackil") + "' method='GET' enctype='text/plain'>" + back_ss + "<input type='hidden' size='20' name='long' value='1'><input type='hidden' size='20' name='ip' value='" + ip_s_form + "'>&nbsp ban time (<=" + IntToStroka(TBanIPListItem::MAX_BAN_HOURS_LONG) + " hour): &nbsp <input type='text' size='10' name='bantime' value='" + IntToStroka(long_bantime_default) + "'> &nbsp <input type='checkbox' size='10' name='intbi'>internal &nbsp " + GetActionFormParam("askaddblackil") + "<input type='submit' size='10' value='long ban ip'></form>";
            }
            if (banres.ban7) {
                saction7 = ConvertTime(tban7.tAction);
                shours7 = IntToStroka(tban7.chours);
                sban7user = Trim(TString(tban7.cUser));

                sban7sost = "";
                if ((tban7.cIntBanIp & 0x01) > 0)
                    sban7sost = sban7sost + "INTBAN &nbsp; ";
                if ((tban7.cIntBanIp & 0x02) > 0)
                    sban7sost = sban7sost + "MANUAL (\"" + TString(tban7.cUser) + "\") &nbsp; ";
                if ((tban7.cIntBanIp & 0x04) > 0)
                    sban7sost = sban7sost + "BLACKLIST &nbsp; ";
                if ((tban7.cIntBanIp & 0x08) > 0)
                    sban7sost = sban7sost + "RULE &nbsp; ";

                TString checkedflag = "";

                if ((tban7.cIntBanIp & 0x01) > 0)
                    checkedflag = "CHECKED";
                sbanip7 = "<br><form action='" + GetHost() + GetModuleName("askaddban7ip") + "' method='GET' enctype='text/plain'>" + back_ss + "<input type='hidden' size='20' name='ip' value='" + ip_s_form + "'>&nbsp ban time (<=" + IntToStroka(TBanIPListItem::MAX_BAN_HOURS) + " hour): &nbsp <input type='text' size='10' name='bantime' value='" + IntToStroka(bantime_default) + "'> &nbsp; " + GetActionFormParam("askaddban7ip") + "<input type='submit' size='10' value='ban 7'></form>";

                sban7 = sban7 + "<table border='0' width='100%' cellspacing='0' cellpadding='4'>\n";
                sban7 = sban7 + "<tr><td width = '40%'> yes &nbsp; (remain " + IntToHourMinSec(banres.remainban7) + ")</td><td width = '40%'>" + sban7sost + " &nbsp;</td><td width = '20%'>" + sdelbanip + "</td></tr>";
                sban7 = sban7 + "</table>";

                sban7color = "bgcolor='LightPink'";
            } else {
                sban7user = "";
                sban7 = "no";
                saction7 = "-";
                shours7 = "-";
                sban7color = "";

                sbanip7 = "<br><form action='" + GetHost() + GetModuleName("askaddban7ip") + "' method='GET' enctype='text/plain'>" + back_ss + "<input type='hidden' size='20' name='ip' value='" + ip_s_form + "'>&nbsp ban time (<=" + IntToStroka(TBanIPListItem::MAX_BAN_HOURS) + " hour): &nbsp <input type='text' size='10' name='bantime' value='" + IntToStroka(bantime_default) + "'> &nbsp; " + GetActionFormParam("askaddban7ip") + "<input type='submit' size='10' value='ban 7'></form>";
            }

            sbansummary = "<table border='0' width='100%' cellspacing='0' cellpadding='4'><tr><td>" + sbanip + "</td></tr><tr><td>" + sbaniplong + "</td></tr></table>";
            sban7summary = sbanip7;

            text = "<html>\n<body bgcolor=palegoldenrod>\n";

            getbyidlink = "<A href='" + GetStatIPObject()->GetLinktogetbyid() + ip_s + "' target='_blank'>" + ip_s + "</A>";
            getbyidlink2 = "<A href='" + GetStatIPObject()->GetLinktogetbyid() + ip_s + "' target='_blank'>Get delivery log</A>";

            TString bandefwin = "<A href='" + GetHost() + GetModuleName("bandefwin") + GetActionOneParam("bandefwin") + "' target='_blank'>ban_defaults</A>";

            text = text + "<table border='0' width='100%' cellspacing='0' cellpadding='4'>";
            text = text + "<tr><td width='50%' align='left'><b>Ban statistik from IP: " + getbyidlink + "</b> &nbsp;</td><td width='50%' align='right'>" + bandefwin + " &nbsp; </td></tr>";
            text = text + "</table>";

            text = text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=lemonchiffon>\n";
            text = text + "<tr><td width = '20%'>Add ban time:</td><td width = '80%' colspan='2'>" + IntToStroka(AddBanTime) + "</td></tr>";
            text = text + "<tr><td width = '20%'>Ban:</td><td width = '50%' " + sbancolor + ">" + sban + "</td><td width = '30%'>" + sbansummary + "</td></tr>";
            text = text + "<tr><td width = '20%'>Ban time:</td><td width = '80%' colspan='2'>" + saction + "</td></tr>";
            text = text + "<tr><td width = '20%'>Ban hours:</td><td width = '80%' colspan='2'>" + shours + " &nbsp; (+ban.addbantime: " + IntToStroka(GetStatIPObject()->GetCPO()->GetAddBanTime()) + ")</td></tr>";
            text = text + "<tr><td width = '20%'>Inner ban:</td><td width = '80%' colspan='2'>" + innerban + "</td></tr>";
            text = text + "<tr><td width = '20%'>Ban7:</td><td width = '50%' " + sban7color + ">" + sban7 + "</td><td width = '30%'>" + sban7summary + "</td></tr>";
            text = text + "<tr><td width = '20%'>Ban7 time:</td><td width = '80%' colspan='2'>" + saction7 + "</td></tr>";
            text = text + "<tr><td width = '20%'>Ban7 hours:</td><td width = '80%' colspan='2'>" + shours7 + " &nbsp; (+ban.addbantime: " + IntToStroka(GetStatIPObject()->GetCPO()->GetAddBanTime()) + ")</td></tr>";
            text = text + "<tr><td width = '20%'>Action:</td><td width = '50%'> &nbsp; " + catchrequest + "</td><td width = '30%' align='center'>&nbsp;" + getbyidlink2 + "</td></tr>";
            text = text + "<tr><td width = '20%'>Ban3log:</td><td width = '80%' colspan='2'>" + ban3log + "</td></tr>";
            text = text + "</table>";

            TString clearipstatform = "<form action='" + GetHost() + GetModuleName("clearipstat") + "' method='GET' enctype='text/plain'>HISTORY:&nbsp;&nbsp;&nbsp;<input type='hidden' size='20' name='ip' value='" + ip_s_form + "'>" + GetActionFormParam("clearipstat") + "<input type='submit' size='10' value='Clear statistik'></form>";

            if ((GetStatIPObject() != NULL) && (GetStatIPObject()->GetBasesStore() != NULL)) {
                TGrayListStatus gr_list;
                bool m_whiteip = false;
                bool m_whitehost = false;
                bool m_blackip = false;
                bool m_whitenet = false;
                GetStatIPObject()->GetBasesStore()->GetListsStatus(ip, ms.rdns, m_whiteip, m_whitehost, m_whitenet, m_blackip);
                GetStatIPObject()->GetBasesStore()->GetGreyListsStatus(ip, ms.rdns, gr_list);

                TString ip_s_escape = ip_s;
                CGIEscape(ip_s_escape);
                TString add_follow_ip = " &nbsp; <A href='" + GetHost() + GetModuleName("addfollowip") + GetActionOneParam("addfollowip") + "&ip=" + ip_s_escape + "' target='_blank'>add_follow_list</A> &nbsp; ";
                TString delete_follow_ip = " &nbsp; <A href='" + GetHost() + GetModuleName("delfollowip") + GetActionOneParam("delfollowip") + "&ip=" + ip_s_escape + "' target='_blank'>delete_from_follow_list</A> &nbsp; ";
                TString follow_status = "";

                if (GetStatIPObject()->IsFollowIP(ip))
                    follow_status = delete_follow_ip;
                else
                    follow_status = add_follow_ip;

                text = text + "<br><b>IP: " + ip_s + " from lists:</b>\n";
                text = text + follow_status;
                text = text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=lemonchiffon>\n";
                //text = text + "<tr><td width = '20%'>BlackIP:</td><td width = '80%'></td></tr>";
                text = text + "<tr><td width = '20%'>WhiteIP:</td><td width = '80%'>" + BoolToStroka2(m_whiteip) + "</td></tr>";
                text = text + "<tr><td width = '20%'>WhiteNet (ip / host):</td><td width = '80%'>" + BoolToStroka2(m_whitenet) + " / " + BoolToStroka2(m_whitehost) + "</td></tr>";

                for (ui32 i = 0; i < TGrayListStatus::GREYLIST_COUNT; i++)
                    text = text + "<tr><td width = '20%'>GrayList_" + IntToStroka(i + 1) + "(addr/net/host):</td><td width = '80%'>" + BoolToStroka2(gr_list.addr[i]) + " / " + BoolToStroka2(gr_list.net[i]) + " / " + BoolToStroka2(gr_list.host[i]) + "</td></tr>";

                text = text + "</table>";
            }

            ms = GetStatIPObject()->GetBasesStore()->GetMemBasa()->GetIpStat(ip);
            if (!ms.notfound) {
                if (IS_SF_BAN(ms.bMask))
                    mask = mask + "<b>BAN</b> &nbsp;";
                else
                    mask = mask + "NO_BAN &nbsp;";

                if (IS_SF_BAN_WOW(ms.bMask))
                    mask = mask + "<b>MANUALBAN</b> &nbsp;";
                else
                    mask = mask + "NO_MANUALBAN &nbsp;";

                if (IS_SF_BAN_PROB(ms.bMask))
                    mask = mask + "<b>BANPROB</b> &nbsp;";
                else
                    mask = mask + "NO_BANPROB &nbsp;";

                if (IS_SF_FORWARD(ms.bMask))
                    mask = mask + "<b>FORWARD</b> &nbsp;";
                else
                    mask = mask + "NO_FORWARD &nbsp;";

                if (IS_SF_WHITE(ms.bMask))
                    mask = mask + "<b>WHITE</b> &nbsp;";
                else
                    mask = mask + "NO_WHITE &nbsp;";

                if (IS_SF_DSL(ms.bMask))
                    mask = mask + "<b>DSL</b> &nbsp;";
                else
                    mask = mask + "NO_DSL &nbsp;";

                if (IS_SF_SHM(ms.bMask))
                    mask = mask + "<b>SHM</b> &nbsp;";
                else
                    mask = mask + "NO_SHM &nbsp;";

                if (IS_SF_VISIBLE_FRWD1(ms.bMask))
                    mask = mask + "<b>VISFRWD1</b> &nbsp;";
                else
                    mask = mask + "NO_VISFRWD1 &nbsp;";

                if (IS_SF_VISIBLE_FRWD2(ms.bMask))
                    mask = mask + "<b>VISFRWD2</b> &nbsp;";
                else
                    mask = mask + "NO_VISFRWD2 &nbsp;";

                if (IS_SF_RBL4(ms.bMask))
                    mask = mask + "<b>RBL4</b> &nbsp;";
                else
                    mask = mask + "NO_RBL4 &nbsp;";

                if (IS_SF_WAS_BAN_WOW(ms.bMask))
                    mask = mask + "<b>WASMANUALBAN</b> &nbsp;";

                if (mask.empty())
                    mask = "&nbsp;";

                if (IS_SF_BAN(ms.ybMask))
                    ymask = ymask + "<b>BAN</b> &nbsp;";
                else
                    ymask = ymask + "NO_BAN &nbsp;";

                if (IS_SF_BAN_WOW(ms.ybMask))
                    ymask = ymask + "<b>MANUALBAN</b> &nbsp;";
                else
                    ymask = ymask + "NO_MANUALBAN &nbsp;";

                if (IS_SF_BAN_PROB(ms.ybMask))
                    ymask = ymask + "<b>BANPROB</b> &nbsp;";
                else
                    ymask = ymask + "NO_BANPROB &nbsp;";

                if (IS_SF_FORWARD(ms.ybMask))
                    ymask = ymask + "<b>FORWARD</b> &nbsp;";
                else
                    ymask = ymask + "NO_FORWARD &nbsp;";

                if (IS_SF_WHITE(ms.ybMask))
                    ymask = ymask + "<b>WHITE</b> &nbsp;";
                else
                    ymask = ymask + "NO_WHITE &nbsp;";

                if (IS_SF_DSL(ms.ybMask))
                    ymask = ymask + "<b>DSL</b> &nbsp;";
                else
                    ymask = ymask + "NO_DSL &nbsp;";

                if (IS_SF_SHM(ms.ybMask))
                    ymask = ymask + "<b>SHM</b> &nbsp;";
                else
                    ymask = ymask + "NO_SHM &nbsp;";

                if (IS_SF_VISIBLE_FRWD1(ms.ybMask))
                    ymask = ymask + "<b>VISFRWD1</b> &nbsp;";
                else
                    ymask = ymask + "NO_VISFRWD1 &nbsp;";

                if (IS_SF_VISIBLE_FRWD2(ms.ybMask))
                    ymask = ymask + "<b>VISFRWD2</b> &nbsp;";
                else
                    ymask = ymask + "NO_VISFRWD2 &nbsp;";

                if (IS_SF_RBL4(ms.ybMask))
                    ymask = ymask + "<b>RBL4</b> &nbsp;";
                else
                    ymask = ymask + "NO_RBL4 &nbsp;";

                if (IS_SF_WAS_BAN_WOW(ms.ybMask))
                    ymask = ymask + "<b>WASMANUALBAN</b> &nbsp;";

                if (ymask.empty())
                    ymask = "&nbsp;";

                text = text + "<br><b>Statistik from IP: " + ip_s + "</b>\n";
                text = text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=lemonchiffon>\n";
                text = text + "<tr><td width = '20%' colspan=2 align='center' bgcolor='" + TString(BGSHAPCOLOR) + "'><i><b>TODAY:</b></i></td></tr>";
                text = text + "<tr><td width = '20%'>Ham (ham mail):</td><td width = '80%'>" + IntToStroka(ms.Ham) + " (" + IntToStroka(ms.HamMail) + ")</td></tr>";
                text = text + "<tr><td width = '20%'>Spam (spam mail):</td><td width = '80%'>" + IntToStroka(ms.Spam) + " (" + IntToStroka(ms.SpamMail) + ")</td></tr>";
                text = text + "<tr><td width = '20%'>MalicSpam (malic mail):</td><td width = '80%'>" + IntToStroka(ms.MalicSpam) + " (" + IntToStroka(ms.MalicSpamMail) + ")</td></tr>";
                text = text + "<tr><td width = '20%'>Pop3 (+SMTP_AUTH):</td><td width = '80%'>" + IntToStroka(ms.Pop3) + "</td></tr>";
                text = text + "<tr><td width = '20%'>Dsn:</td><td width = '80%'>" + IntToStroka(ms.Dsn) + "</td></tr>";
                text = text + "<tr><td width = '20%'>Mail count after ban:</td><td width = '80%'>" + IntToStroka(ms.Rejected) + "</td></tr>";
                text = text + "<tr><td width = '20%'>Mcount:</td><td width = '80%'>" + IntToStroka(ms.Mcount) + "</td></tr>";
                text = text + "<tr><td width = '20%'>Mask:</td><td width = '80%'>" + mask + "</td></tr>";
                text = text + "<tr><td width = '20%'>Last mail:</td><td width = '80%'>" + ConvertTime(ms.tLastMes) + "</td></tr>";
                text = text + "<tr><td width = '20%'>Mail/box:</td><td width = '80%'>" + ms.frwds + "</td></tr>";
                text = text + "<tr><td width = '20%'>Tfix day:</td><td width = '80%'>" + ConvertTime(ms.tFixDay) + "</td></tr>";
                text = text + "<tr><td width = '20%'>Host:</td><td width = '80%'>" + ms.rdns + " &nbsp; </td></tr>";
                text = text + "<tr><td width = '20%'>MALICIOUS_SPAMER:</td><td width = '80%'>" + IntToStroka(ms.malicspamer_count) + " </td></tr>";
                text = text + "<tr><td width = '20%'>MailPerSec:</td><td width = '80%'>" + FloatToStr(ms.cps) + " </td></tr>";
                text = text + "<tr><td width = '20%'>Ban7count:</td><td width = '80%'>" + IntToStroka(ms.ban7count) + " </td></tr>";
                text = text + "<tr><td width = '20%'>Spam mail box count percent:</td><td width = '80%'>" + FloatToStr(ms.prSpamMailBox) + " </td></tr>";
                text = text + "<tr><td width = '20%'>GEO data:</td><td width = '80%'>" + ms.geo + " </td></tr>";

                text = text + "<tr><td width = '20%'>Manual ban count:</td><td width = '80%'>" + IntToStroka(ms.manual_ban_count) + " </td></tr>";
                text = text + "<tr><td width = '20%'>Rule ban count:</td><td width = '80%'>" + IntToStroka(ms.ban_count) + " </td></tr>";

                text = text + "<tr><td width = '20%' colspan=2 align='center' bgcolor='" + TString(BGSHAPCOLOR) + "'><i><b>YESTERDAY:</b></i></td></tr>";
                text = text + "<tr><td width = '20%'>Ham (ham mail):</td><td width = '80%'>" + IntToStroka(ms.yctHam) + " (" + IntToStroka(ms.yctHamMail) + ")</td></tr>";
                text = text + "<tr><td width = '20%'>Spam (spam mail):</td><td width = '80%'>" + IntToStroka(ms.yctSpam) + " (" + IntToStroka(ms.yctSpamMail) + ")</td></tr>";
                text = text + "<tr><td width = '20%'>MalicSpam (malic mail):</td><td width = '80%'>" + IntToStroka(ms.yctMalicSpam) + " (" + IntToStroka(ms.yctMalicSpamMail) + ")</td></tr>";
                text = text + "<tr><td width = '20%'>Pop3:</td><td width = '80%'>" + IntToStroka(ms.ycPop3) + " </td></tr>";
                text = text + "<tr><td width = '20%'>Dsn:</td><td width = '80%'>" + IntToStroka(ms.ycDsn) + " </td></tr>";
                text = text + "<tr><td width = '20%'>Mail count after ban:</td><td width = '80%'>" + IntToStroka(ms.ycRejected) + " </td></tr>";
                text = text + "<tr><td width = '20%'>Mcount:</td><td width = '80%'>" + IntToStroka(ms.ycMcount) + " </td></tr>";
                text = text + "<tr><td width = '20%'>Mask:</td><td width = '80%'>" + ymask + " </td></tr>";
                //text = text + "<tr><td width = '20%'>WeightSum:</td><td width = '80%'>" + IntToStroka(ms.ycWeightSum) + " </td></tr>";
                //text = text + "<tr><td width = '20%'>WMess:</td><td width = '80%'>" + IntToStroka(ms.ycWMess) + " </td></tr>";
                //text = text + "<tr><td width = '20%'>Manual ban count:</td><td width = '80%'>" + IntToStroka(ms.yManualBanCount) + " </td></tr>";

                text = text + "<tr><td width = '20%' colspan=2 align='center' bgcolor='" + TString(BGSHAPCOLOR) + "'><br><i><b>" + clearipstatform + "</b></i></td></tr>";
                text = text + "<tr><td width = '20%'>Create record:</td><td width = '80%'>" + ConvertTime(ms.htFirstDeal) + " </td></tr>";
                text = text + "<tr><td width = '20%'>Last message:</td><td width = '80%'>" + ConvertTime(ms.htLastMes) + " </td></tr>";
                text = text + "<tr><td width = '20%'>Ham:</td><td width = '80%'>" + IntToStroka(ms.hctHam) + " </td></tr>";
                text = text + "<tr><td width = '20%'>Spam:</td><td width = '80%'>" + IntToStroka(ms.hctSpam) + " </td></tr>";
                text = text + "<tr><td width = '20%'>MalicSpam:</td><td width = '80%'>" + IntToStroka(ms.hctMalicSpam) + " </td></tr>";
                text = text + "<tr><td width = '20%'>Dsn:</td><td width = '80%'>" + IntToStroka(ms.hcDsn) + " </td></tr>";
                text = text + "<tr><td width = '20%'>Pop3Auth days (+SMTP_AUTH):</td><td width = '80%'>" + IntToStroka(ms.hPop3_Auth) + " </td></tr>";
                text = text + "<tr><td width = '20%'>Reject days:</td><td width = '80%'>" + IntToStroka(ms.hDaysRej) + " </td></tr>";
                text = text + "<tr><td width = '20%'>NoReject days:</td><td width = '80%'>" + IntToStroka(ms.hDaysNoRej) + " </td></tr>";
                text = text + "<tr><td width = '20%'>Forward days:</td><td width = '80%'>" + IntToStroka(ms.hFwdDays) + " </td></tr>";
                text = text + "<tr><td width = '20%'>Manual ban count:</td><td width = '80%'>" + IntToStroka(ms.hManualBanCount) + " </td></tr>";
                text = text + "</table>";
            }

            if ((GetStatIPObject() != NULL) && (GetStatIPObject()->GetBanIPCache() != NULL)) {
                TBanCacheInfo datav;

                if (GetStatIPObject()->GetBanIPCache()->GetData(ip, datav)) {
                    text = text + "<br><b>Ban local cache statistik from IP: &nbsp; " + ip_s + "</b> &nbsp; <br>\n";
                    text = text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=lemonchiffon>\n";
                    text = text + "<tr><td width = '20%'>Propertis::period_time</td><td width = '80%'><i>" + IntToStroka(GetStatIPObject()->GetBanIPCache()->GetPeriodTime()) + "</i></td></tr>";
                    text = text + "<tr><td width = '20%'>Remain time (change data)</td><td width = '80%'><i>" + IntToStroka(GetStatIPObject()->GetBanIPCache()->GetRemainTime()) + "</i></td></tr>";
                    text = text + "<tr><td width = '20%'>Ban:</td><td width = '80%'>" + BoolToStroka2(datav.m_ban) + "</td></tr>";
                    text = text + "<tr><td width = '20%'>Ban7:</td><td width = '80%'>" + BoolToStroka2(datav.m_ban7) + "</td></tr>";
                    text = text + "</table>";

                } else {
                    text = text + "<br><b>Ban local cache statistik from IP: &nbsp; " + ip_s + "</b> &nbsp; <br>\n";
                    text = text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=lemonchiffon>\n";
                    text = text + "<tr><td width = '20%'>Propertis::period_time</td><td width = '80%'><i>" + IntToStroka(GetStatIPObject()->GetBanIPCache()->GetPeriodTime()) + "</i></td></tr>";
                    text = text + "<tr><td width = '100%' colspan='2'>not found</td></tr>";
                    text = text + "</table>";
                }
            }

            if ((GetStatIPObject() != NULL) && (GetStatIPObject()->GetWhiteIPCache() != NULL)) {
                if (GetStatIPObject()->GetWhiteIPCache()->GetStat(ip, ip_cachestat)) {
                    text = text + "<br><b>White local cache statistik from IP: &nbsp; " + ip_s + "</b> &nbsp; <br>\n";
                    text = text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=lemonchiffon>\n";
                    text = text + "<tr><td width = '20%'>Propertis::white_local_cache_diff</td><td width = '80%'><i>" + IntToStroka(ip_cachestat.diff.white_local_cache_diff) + "</i></td></tr>";
                    text = text + "<tr><td width = '20%'>Propertis::white_local_cache_diff_time</td><td width = '80%'><i>" + IntToStroka(ip_cachestat.diff.white_local_cache_diff_time) + "</i></td></tr>";
                    switch (ip_cachestat.last_action) {
                        case WIP_UNKNOWN:
                            text = text + "<tr><td width = '100%' colspan='2'>UNKNOWN ACTION</td></tr>";
                            break;
                        case WIP_UPDATE_STORAGE:
                            text = text + "<tr><td width = '100%' colspan='2'>UPDATE STORAGE</td></tr>";
                            text = text + "<tr><td width = '20%'>Elapsed time:</td><td width = '80%'>" + GetTimePeriod(time(NULL) - ip_cachestat.lasttime) + "</td></tr>";
                            break;
                        case WIP_UPDATE_DIFF:
                            text = text + "<tr><td width = '100%' colspan='2'>INCREMENT DIFF</td></tr>";
                            text = text + "<tr><td width = '20%'>Count:</td><td width = '80%'>" + IntToStroka(ip_cachestat.diff.m_count) + "</td></tr>";
                            text = text + "<tr><td width = '20%'>Elapsed time:</td><td width = '80%'>" + GetTimePeriod(time(NULL) - ip_cachestat.lasttime) + "</td></tr>";
                            text = text + "<tr><td width = '20%'>Ham count:</td><td width = '80%'>" + IntToStroka(ip_cachestat.diff.m_ham_count) + "</td></tr>";
                            text = text + "<tr><td width = '20%'>Ham mailbox count:</td><td width = '80%'>" + IntToStroka(ip_cachestat.diff.m_ham_mailbox_count) + "</td></tr>";
                            text = text + "<tr><td width = '20%'>Spam count:</td><td width = '80%'>" + IntToStroka(ip_cachestat.diff.m_spam_count) + "</td></tr>";
                            text = text + "<tr><td width = '20%'>Spam mailbox count:</td><td width = '80%'>" + IntToStroka(ip_cachestat.diff.m_spam_mailbox_count) + "</td></tr>";
                            text = text + "<tr><td width = '20%'>Malic count:</td><td width = '80%'>" + IntToStroka(ip_cachestat.diff.m_malic_count) + "</td></tr>";
                            text = text + "<tr><td width = '20%'>Malic mailbox count:</td><td width = '80%'>" + IntToStroka(ip_cachestat.diff.m_malic_mailbox_count) + "</td></tr>";
                            text = text + "<tr><td width = '20%'>WeightSum:</td><td width = '80%'>" + IntToStroka(ip_cachestat.diff.m_cWeightSum) + "</td></tr>";
                            text = text + "<tr><td width = '20%'>WMess:</td><td width = '80%'>" + IntToStroka(ip_cachestat.diff.m_cWMess) + "</td></tr>";
                            text = text + "<tr><td width = '20%'>Mcount:</td><td width = '80%'>" + IntToStroka(ip_cachestat.diff.m_cMcount) + "</td></tr>";
                            text = text + "<tr><td width = '20%'>Pop3:</td><td width = '80%'>" + IntToStroka(ip_cachestat.diff.m_cPop3) + "</td></tr>";
                            text = text + "<tr><td width = '20%'>Dsn:</td><td width = '80%'>" + IntToStroka(ip_cachestat.diff.m_cDsn) + "</td></tr>";
                            break;
                    };
                    text = text + "</table>";

                } else {
                    text = text + "<br><b>White local cache statistik from IP: &nbsp; " + ip_s + "</b> &nbsp; <br>\n";
                    text = text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=lemonchiffon>\n";
                    text = text + "<tr><td width = '20%'>Propertis::white_local_cache_diff</td><td width = '80%'><i>" + IntToStroka(GetStatIPObject()->GetWhiteIPCache()->GetDiffCount()) + "</i></td></tr>";
                    text = text + "<tr><td width = '20%'>Propertis::white_local_cache_diff_time</td><td width = '80%'><i>" + IntToStroka(GetStatIPObject()->GetWhiteIPCache()->GetDiffTime()) + "</i></td></tr>";
                    text = text + "<tr><td width = '100%' colspan='2'>not found</td></tr>";
                    text = text + "</table>";
                }
            }

            result = true;
            text = text + "</body>\n</html>\n";

            SendToClientWithShap(SO_LOG_MESSAGE, 200, text, "-");
        } else {
            SendToClientRAW(HTTP_501_NOT_IMPLEMENTED());
        }

    } else {
        SendToClientRAW(HTTP_501_NOT_IMPLEMENTED());
    }
}

void TMakeRequest::ViewIPStatNet(const TString& id, const TString& ips, const TWKIPv6& value) {
    TBanResList banlist;
    ui32 counter = 0;
    TKIPv6 ip = TKIPv6();
    const ui32 MAX_COUNT_RECORD = 256;
    ui16 AddBanTime = 0;
    TBanIpBasic tban;
    TBanIpBasic tban7;
    TIpStatOne ms;
    TBanRes banres;
    TString text = "";
    TKIPv6 ipfirst = value.ip1;
    TKIPv6 iplast = value.ip2;
    bool last_record = false;

    if ((GetStatIPObject() != NULL) && (GetStatIPObject()->GetBasesStore() != NULL) && (GetStatIPObject()->GetBasesStore()->GetBanIP() != NULL) && (GetStatIPObject()->GetBasesStore()->GetMemBasa() != NULL)) {
        last_record = false;
        banlist.clear();
        ip = ipfirst;
        do {
            if (ip == iplast)
                last_record = true;
            ms = GetStatIPObject()->GetBasesStore()->GetMemBasa()->GetIpStat(ip);
            if (!ms.notfound) {
                banres = GetStatIPObject()->GetBasesStore()->GetBanIP()->GetBanStatus(ip, AddBanTime, tban, tban7);
                banlist.push_back(TBanResExt(banres, ms.Ham, ms.Spam, ms.MalicSpam));
                counter++;
            }
            if (!last_record)
                ip = ip.GetNextIP();
        } while ((counter < MAX_COUNT_RECORD) && (!last_record));

        if (banlist.size() > 0) {
            int teil = 0;
            int posb1 = 0;
            int pose1 = 0;
            int posb2 = 0;
            int pose2 = 0;
            int posb3 = 0;
            int pose3 = 0;
            TString snetip = "";

            teil = banlist.size() / 2;
            if ((banlist.size() % 2) > 0)
                teil++;
            posb1 = 0;
            pose1 = teil - 1;
            posb2 = teil;
            if (posb2 >= banlist.size())
                posb2 = -1;
            pose2 = banlist.size() - 1;

            text = text + "<table border='0' width='100%' cellspacing='0' cellpadding='4'>\n";
            text = text + "<tr>\n";
            text = text + "<b>STATISTIK FOR NET: <i>'" + ipfirst.toStroka() + " - " + iplast.toStroka() + "'</i> - found " + IntToStroka(banlist.size()) + " records (MAX_RECORD: " + IntToStroka(MAX_COUNT_RECORD) + ")<br></b>\n";
            //1 column
            text = text + "<td width='50%' valign='top'>\n";
            text = text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=lemonchiffon>\n";
            text = text + "<tr bgcolor='" + TString(BGSHAPCOLOR) + "'>\n";
            text = text + "<td width='10%' align='center'><b><i>IP</i></b></td>\n";
            text = text + "<td width='30%' align='center'><b><i>BAN</i></b></td>\n";
            text = text + "<td width='30%' align='center'><b><i>BAN7</i></b></td>\n";
            text = text + "<td width='30%' align='center'><b><i>HAM / SPAM / MALIC</i></b></td>\n";
            text = text + "</tr>\n";
            if (posb1 >= 0) {
                for (int j = posb1; j <= pose1; j++) {
                    snetip = banlist[j].banres.ip.toStroka();

                    text = text + "<tr>\n";
                    text = text + "<td align='left'><A href='" + GetHost() + GetModuleName("viewipstat") + GetActionOneParam("viewipstat") + "&ip=" + snetip + "'>" + snetip + "</A></td>\n";
                    if (banlist[j].banres.ban)
                        text = text + "<td bgcolor='LightPink' align='center'> yes (" + IntToHourMinSec(banlist[j].banres.remainban) + ")</td>\n";
                    else
                        text = text + "<td align='center'> no </td>\n";
                    if (banlist[j].banres.ban7)
                        text = text + "<td bgcolor='LightPink' align='center'> yes (" + IntToHourMinSec(banlist[j].banres.remainban7) + ")</td>\n";
                    else
                        text = text + "<td align='center'> no </td>\n";
                    text = text + "<td align='center'>" + IntToStroka(banlist[j].ham) + " / " + IntToStroka(banlist[j].spam) + " / " + IntToStroka(banlist[j].malic) + "</td>\n";
                    text = text + "</tr>\n";
                }
            }
            text = text + "</table>";
            text = text + "</td>\n";
            //2 column
            text = text + "<td width='50%' valign='top'>\n";
            text = text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=lemonchiffon>\n";
            text = text + "<tr bgcolor='" + TString(BGSHAPCOLOR) + "'>\n";
            text = text + "<td width='10%' align='center'><b><i>IP</i></b></td>\n";
            text = text + "<td width='30%' align='center'><b><i>BAN</i></b></td>\n";
            text = text + "<td width='30%' align='center'><b><i>BAN7</i></b></td>\n";
            text = text + "<td width='30%' align='center'><b><i>HAM / SPAM / MALIC</i></b></td>\n";
            text = text + "</tr>\n";
            if (posb2 >= 0) {
                for (int j = posb2; j <= pose2; j++) {
                    snetip = banlist[j].banres.ip.toStroka();

                    text = text + "<tr>\n";
                    text = text + "<td align='left'><A href='" + GetHost() + GetModuleName("viewipstat") + GetActionOneParam("viewipstat") + "&ip=" + snetip + "'>" + snetip + "</A></td>\n";
                    if (banlist[j].banres.ban)
                        text = text + "<td bgcolor='LightPink' align='center'> yes (" + IntToHourMinSec(banlist[j].banres.remainban) + ")</td>\n";
                    else
                        text = text + "<td align='center'> no </td>\n";
                    if (banlist[j].banres.ban7)
                        text = text + "<td bgcolor='LightPink' align='center'> yes (" + IntToHourMinSec(banlist[j].banres.remainban7) + ")</td>\n";
                    else
                        text = text + "<td align='center'> no </td>\n";
                    text = text + "<td align='center'>" + IntToStroka(banlist[j].ham) + " / " + IntToStroka(banlist[j].spam) + " / " + IntToStroka(banlist[j].malic) + "</td>\n";
                    text = text + "</tr>\n";
                }
            }
            text = text + "</table>";
            text = text + "</td>\n";

            text = text + "<tr>";
            text = text + "</table>";
        } else {
            text = "not found";
        }
        SendToClientWithShap(SO_LOG_MESSAGE, 200, text, id);

    } else
        SendToClientRAW(HTTP_501_NOT_IMPLEMENTED());
}

void TMakeRequest::CatchIP(const TString& id, TReqParams* m_ReqParams) {
    TReqParams::iterator par_it;
    TString delay_s = "";
    ui32 delay = 0;
    TString ip_s = "";
    TString ip_s_form = "";
    TKIPv6 ip = TKIPv6();
    TString text = "";
    const char* pbegin = NULL;
    const char* pend = NULL;
    ui32 messsize = 0;
    TString st = "";
    TString btext = "";
    TString sbanip = "";
    TString sbanip7 = "";
    ui32 bantime_default = TBanIPListItem::MAX_BAN_HOURS;
    ui32 long_bantime_default = TBanIPListItem::MAX_BAN_HOURS_LONG;

    if ((GetStatIPObject() != NULL) && (GetStatIPObject()->GetBasesStore() != NULL))
        GetStatIPObject()->GetBasesStore()->GetSetupBanTime(bantime_default, long_bantime_default);

    //ip
    par_it = m_ReqParams->find("ip");
    if (par_it != m_ReqParams->end()) {
        ip_s = Trim(par_it->second[0]);
        ip_s_form = ip_s;
        CGIUnescape(ip_s);
        ip = TKIPv6(ip_s.c_str());
    }

    par_it = m_ReqParams->find("delay");
    if (par_it != m_ReqParams->end()) {
        delay_s = par_it->second[0].c_str();
        delay = atoi(delay_s.c_str());
    } else
        delay = 10;

    sbanip = "<form action='" + GetHost() + GetModuleName("askaddblackip") + "' method='GET' enctype='text/plain'><input type='hidden' size='20' name='ip' value='" + ip_s + "'>&nbsp ban time (<" + IntToStroka(TBanIPListItem::MAX_BAN_HOURS) + "): &nbsp <input type='text' size='10' name='bantime' value='" + IntToStroka(bantime_default) + "'> &nbsp <input type='checkbox' size='10' name='intbi' value='1'>internal &nbsp " + GetActionFormParam("askaddblackip") + "<input type='submit' size='10' value='ban ip'></form>";
    sbanip7 = "<form action='" + GetHost() + GetModuleName("askaddban7ip") + "' method='GET' enctype='text/plain'><input type='hidden' size='20' name='ip' value='" + ip_s + "'>&nbsp ban time (<" + IntToStroka(TBanIPListItem::MAX_BAN_HOURS) + "): &nbsp <input type='text' size='10' name='bantime' value='" + IntToStroka(bantime_default) + "'> &nbsp; " + GetActionFormParam("askaddban7ip") + "<input type='submit' size='10' value='ban 7'></form>";

    if (!ip.Undefined()) {
        if ((GetStatIPObject() != NULL) && (GetStatIPObject()->GetTrap() != NULL))
            btext = GetStatIPObject()->GetTrap()->GetMail(ip, delay, false);

        text = text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=lemonchiffon>\n";
        text = text + "<tr valign='top' bgcolor='palegoldenrod'><td align='center' colspan='2'><br><B>CATCH MAIL FROM IP: <A href='" + GetHost() + GetModuleName("viewipstat") + GetActionOneParam("viewipstat") + "&ip=" + ip_s_form + "'>" + ip.toStroka() + "</A></B>&nbsp;<br></td></tr>\n";
        text = text + "<tr valign='top' bgcolor='palegoldenrod'><td align='center' width='50%'><br>" + sbanip + "</td><td align='center' width='50%'><br>" + sbanip7 + "</td></tr>\n";

        pbegin = strstr(btext.c_str(), "mess: ");
        if (pbegin != NULL) {
            pend = strstr(pbegin + 1, "mess: ");
            if (pend != NULL) {
                messsize = pend - pbegin;
                while (messsize > 0) {
                    st = Trim(TString(pbegin, messsize));
                    if (!st.empty()) {
                        text = text + "<tr valign='top'><td align='left' colspan='2'>" + st + "</td></tr>";
                        text = text + "<tr valign='top' bgcolor='palegoldenrod'><td align='left' colspan='2'>&nbsp;</td></tr>";
                    }
                    pbegin = pend;
                    pend = strstr(pbegin + 1, "mess: ");
                    if (pend == NULL)
                        break;
                    messsize = pend - pbegin;
                }
            }
            st = Trim(TString(pbegin));
            if (!st.empty())
                text = text + "<tr valign='top'><td align='left' colspan='2'>" + st + "</td></tr>";
        }

        text = text + "</table>\n";

        SendToClientWithLittleShap(SO_LOG_MESSAGE, 200, text, id);
    } else {
        text = "Bad request - no 'ip' parameter\n";
        SendToClient(SO_LOG_ERROR, 400, text, id);
    }
}

void TMakeRequest::CatchIPPeriod(const TString& id, TReqParams* m_ReqParams) {
    TReqParams::iterator par_it;
    TString delay_s = "";
    ui32 delay = 0;
    TString sorttype_s = "";
    ui8 sorttype = 0;
    TString mincount_s = "0";
    ui32 mincount = 0;
    TString mincounttd_s = "0";
    ui32 mincounttd = 0;
    TString maxhamcount_today_s = "0";
    ui32 maxhamcount_today = 0;
    TString geozone = "";
    bool markbanip = false;
    int res = 0;
    ui32 ide = 0;
    TString text = "";
    TIDTrapInfo resdata;
    TString viewlink = "";
    TWhtIp whtip = WHTALL;
    int onlybanip = 0;
    TString rfrsh_link = "";
    TIpType iptype = IPAll;
    TString substr = "";
    bool is_pcre = false;

    if ((GetStatIPObject() != NULL)) {
        mincount_s = IntToStroka(GetStatIPObject()->GetMinStatCountPeriod());
        mincount = GetStatIPObject()->GetMinStatCountPeriod();
    }

    par_it = m_ReqParams->find("delay");
    if (par_it != m_ReqParams->end()) {
        delay_s = par_it->second[0];
        delay = atoi(delay_s.c_str());
    } else
        delay = 10;

    par_it = m_ReqParams->find("sorttype");
    if (par_it != m_ReqParams->end()) {
        sorttype_s = par_it->second[0];
        sorttype = atoi(sorttype_s.c_str());
    }

    par_it = m_ReqParams->find("mincount");
    if (par_it != m_ReqParams->end()) {
        mincount_s = par_it->second[0];
        mincount = atoi(mincount_s.c_str());
    }

    par_it = m_ReqParams->find("mincounttd");
    if (par_it != m_ReqParams->end()) {
        mincounttd_s = par_it->second[0];
        mincounttd = atoi(mincounttd_s.c_str());
    }

    par_it = m_ReqParams->find("maxhamcount_today");
    if (par_it != m_ReqParams->end()) {
        maxhamcount_today_s = par_it->second[0];
        maxhamcount_today = atoi(maxhamcount_today_s.c_str());
    }

    par_it = m_ReqParams->find("geozone");
    if (par_it != m_ReqParams->end()) {
        geozone = par_it->second[0];
    }

    par_it = m_ReqParams->find("markbanip");
    if (par_it != m_ReqParams->end())
        markbanip = true;

    par_it = m_ReqParams->find("onlybanip");
    if (par_it != m_ReqParams->end())
        onlybanip = atoi(par_it->second[0].c_str());

    par_it = m_ReqParams->find("typeip");
    if (par_it != m_ReqParams->end())
        iptype = (TIpType)atoi(par_it->second[0].c_str());

    par_it = m_ReqParams->find("whtip");
    if (par_it != m_ReqParams->end())
        whtip = (TWhtIp)atoi(par_it->second[0].c_str());

    par_it = m_ReqParams->find("substr");
    if (par_it != m_ReqParams->end()) {
        substr = Trim(par_it->second[0]);
        CGIUnescape(substr);
    }

    par_it = m_ReqParams->find("is_pcre");
    if (par_it != m_ReqParams->end())
        is_pcre = true;

    rfrsh_link = rfrsh_link + "sorttype=" + IntToStroka(sorttype);
    rfrsh_link = rfrsh_link + "&mincount=" + IntToStroka(mincount);
    rfrsh_link = rfrsh_link + "&mincounttd=" + IntToStroka(mincounttd);
    rfrsh_link = rfrsh_link + "&maxhamcount_today=" + IntToStroka(maxhamcount_today);
    rfrsh_link = rfrsh_link + "&geozone=" + geozone;
    if (markbanip)
        rfrsh_link = rfrsh_link + "&markbanip=" + IntToStroka(markbanip);
    rfrsh_link = rfrsh_link + "&onlybanip=" + IntToStroka(onlybanip);
    rfrsh_link = rfrsh_link + "&typeip=" + IntToStroka(iptype);
    rfrsh_link = rfrsh_link + "&whtip=" + IntToStroka(whtip);
    rfrsh_link = rfrsh_link + "&substr=" + substr;
    if (is_pcre)
        rfrsh_link = rfrsh_link + "&is_pcre=" + BoolToStroka(is_pcre);

    if ((GetStatIPObject() != NULL) && (GetStatIPObject()->GetPeriodTrap() != NULL))
        res = GetStatIPObject()->GetPeriodTrap()->AddPeriodTrap(delay, ide, sorttype, resdata, mincount, mincounttd, markbanip, whtip, onlybanip, substr, is_pcre, maxhamcount_today, geozone);
    if (res > 0) {
        rfrsh_link = rfrsh_link + "&id=" + IntToStroka(ide);

        viewlink = "<A href='" + GetHost() + GetModuleName("viewcatchper") + "?" + GetActionMultiParam("viewcatchper") + rfrsh_link + "'>view</A>";

        text = text + HTTP_200_OK(id);
        text = text + "<html><head>";
        text = text + "<meta http-equiv='refresh' content='5; url=" + GetHost() + GetModuleName("viewcatchper") + "?" + GetActionMultiParam("viewcatchper") + rfrsh_link + "'>";
        text = text + "</head><body bgcolor=palegoldenrod>\n";
        text = text + "<table border='0' width='100%' height='100%' cellspacing='0' cellpadding='4'>";
        text = text + "<tr><td valign='top'>The statistik already gathers. Try later (statistik " + viewlink + " automatically in " + IntToStroka(res) + " second).</td></tr>";
        text = text + "</table></body></html>";

        SendToClientRAW(text);
        WriteLog(SO_LOG_MESSAGE, 200, id);

    } else if (res < 0) {
        SendToClient(SO_LOG_ERROR, 500, "Internal error: " + IntToStroka(-1 * res) + ".", id);

    } else {
        rfrsh_link = rfrsh_link + "&id=" + IntToStroka(ide);

        text = text + HTTP_200_OK(id);
        text = text + "<html><head>";
        text = text + "<meta http-equiv='refresh' content='1; url=" + GetHost() + GetModuleName("viewcatchper") + "?" + GetActionMultiParam("viewcatchper") + rfrsh_link + "'>";
        text = text + "</head><body bgcolor=palegoldenrod>\n";
        text = text + "<table border='0' width='100%' height='100%' cellspacing='0' cellpadding='4'>";
        text = text + "<tr><td valign='top'>The statistik was collect successfully, <A href='" + GetHost() + GetModuleName("viewcatchper") + "?" + GetActionMultiParam("viewcatchper") + rfrsh_link + "'>view</A></td></tr>";
        text = text + "</table></body></html>";

        SendToClientRAW(text);
        WriteLog(SO_LOG_MESSAGE, 200, id);
    }
}

void TMakeRequest::IPPeriodList(const TString& id) {
    TKItemInfoList slist;
    TKItemInfoListIt it;
    TString text = "";
    TString viewlink = "";
    TString dellink = "";
    TString startlink = "";
    TString duration = "";
    TString periodstat = "";
    TString livetime_s = "";
    i32 livetime = 0;
    time_t tt = time(NULL);
    i32 remain = 0;
    TString remain_s = "";

    if ((GetStatIPObject() != NULL) && (GetStatIPObject()->GetPeriodTrap() != NULL)) {
        GetStatIPObject()->GetPeriodTrap()->GetTrapList(slist);

        periodstat = periodstat + "<br><table border='0' width='100%' cellspacing='0' cellpadding='4' bgcolor=lemonchiffon>";
        periodstat = periodstat + "<tr><td width='100%' align='center'><form action='" + GetHost() + GetModuleName("catchperip") + "' method='GET' enctype='text/plain' target=_blank><input type='hidden' size='5' name='reqtm' value='" + IntToStroka(tt) + "'>&nbsp;min count mails <input type='text' size='5' name='mincount' value='" + IntToStroka(GetStatIPObject()->GetMinStatCountPeriod()) + "'> &nbsp; period (sec): &nbsp; <input type='text' size='5' name='delay' value='60'>, &nbsp; sort: <input type='radio' size='10' name='sorttype' value='0'> ip, <input type='radio' size='10' name='sorttype' value='6' CHECKED> all, <input type='radio' size='10' name='sorttype' value='1'> ham, <input type='radio' size='10' name='sorttype' value='2'> spam, <input type='radio' size='10' name='sorttype' value='3'> malic, <input type='radio' size='10' name='sorttype' value='5'> host; &nbsp; substr: <input type='text' size='20' name='substr' value=''> &nbsp; <input type='checkbox' size='10' name='is_pcre' value=''>use_pcre &nbsp;" + GetActionFormParam("catchperip") + "<input type='submit' size='10' value='to collect'></form></td>";
        periodstat = periodstat + "<td width='0%' align='center'>&nbsp;</td></tr>";
        periodstat = periodstat + "</table>";

        text = text + "<center><b><i>PERIOD STATISTIK</i></b></center><br>";
        text = text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=lemonchiffon>\n";

        text = text + "<tr><td width='100%' colspan='8' align='center'>" + periodstat + "</td></tr>";
        text = text + "<tr bgcolor='" + TString(BGSHAPCOLOR) + "'>";
        text = text + "<td width='10%'><b>START TIME</b></td>";
        text = text + "<td width='20%'><b>SUBSTR</b></td>";
        text = text + "<td width='5%'><b>TYPE</b></td>";
        text = text + "<td width='10%'><b>RCV LOG</b></td>";
        text = text + "<td width='10%'><b>SKEEP LOG</b></td>";
        text = text + "<td width='15%'><b>DURATION</b></td>";
        text = text + "<td width='15%'><b>LIVETIME</b></td>";
        text = text + "<td width='15%'><b>ACTION</b></td>";
        text = text + "</tr>";

        it = slist.begin();
        while (it != slist.end()) {
            viewlink = "<A href='" + GetHost() + GetModuleName("viewcatchper") + GetActionOneParam("viewcatchper") + "&id=" + (*it).ident + "'>view item</A>";
            dellink = "<A href='" + GetHost() + GetModuleName("askdelcatchper") + GetActionOneParam("askdelcatchper") + "&id=" + (*it).ident + "'>delete</A>";
            startlink = "<A href='" + GetHost() + GetModuleName("viewcatchper") + GetActionOneParam("viewcatchper") + "&id=" + (*it).ident + "'>" + TimeToStr((*it).starttime) + "</A>";
            duration = IntToStroka((*it).period);
            livetime = TPeriodTrap::LIVETIMEPERIOD - (tt - (*it).starttime - (*it).period);
            if (livetime < 0)
                livetime = 0;
            remain = (*it).starttime + (*it).period - tt;
            if (remain < 0)
                remain_s = "remain: done";
            else
                remain_s = "remain: " + IntToStroka(remain) + " sec";
            livetime_s = IntToStroka(livetime) + " sec";

            text = text + "<tr>";
            text = text + "<td>" + startlink + "</td>";
            text = text + "<td>'" + (*it).substr + "'&nbsp;</td>";
            if ((*it).is_pcre)
                text = text + "<td>pcre</td>";
            else
                text = text + "<td>&nbsp;</td>";
            text = text + "<td>" + IntToStroka((*it).dlvlog_rcv) + "</td>";
            text = text + "<td>" + IntToStroka((*it).dlvlog_skeep) + "</td>";
            text = text + "<td>" + duration + " &nbsp; (" + remain_s + ") </td>";
            text = text + "<td>" + livetime_s + "</td>";
            text = text + "<td>" + viewlink + " &nbsp; " + dellink + "</td>";
            text = text + "</tr>";

            ++it;
        }
        text = text + "</table>\n";

        SendToClientWithLittleShap(SO_LOG_MESSAGE, 200, text, id);
    } else {
        SendToClientRAW(HTTP_501_NOT_IMPLEMENTED());
    }
}

TString FormListIP(const TString& iplist) {
    TString res = "";
    bool pred_probel = false;
    TString taddr = "";
    TKIPv6 ip = TKIPv6();
    const char* p = NULL;
    TString dopmaska = "";

    if (iplist.size() > 0) {
        for (int i = 0; i < iplist.size(); i++) {
            if (iplist[i] <= ' ') {
                if (!pred_probel) {
                    ip = TKIPv6(taddr.c_str());
                    if (!ip.Undefined()) {
                        dopmaska = "";
                        if (ip.IsIPv4()) {
                            p = strchr(taddr.c_str(), '/');
                            if (p == NULL)
                                p = strchr(taddr.c_str(), '\\');
                            if (p == NULL)
                                dopmaska = "/32";

                        } else if (ip.IsIPv6()) {
                            p = strchr(taddr.c_str(), '/');
                            if (p == NULL)
                                p = strchr(taddr.c_str(), '\\');
                            if (p == NULL)
                                dopmaska = "/128";
                        }
                        res = res + dopmaska + "\n";
                        pred_probel = true;
                        taddr = "";
                    }
                }

            } else {
                res = res + TString(iplist[i]);
                taddr = taddr + TString(iplist[i]);
                pred_probel = false;
            }
        }

        ip = TKIPv6(taddr.c_str());
        if (!ip.Undefined()) {
            dopmaska = "";
            if (ip.IsIPv4()) {
                p = strchr(taddr.c_str(), '/');
                if (p == NULL)
                    p = strchr(taddr.c_str(), '\\');
                if (p == NULL)
                    dopmaska = "/32";

            } else if (ip.IsIPv6()) {
                p = strchr(taddr.c_str(), '/');
                if (p == NULL)
                    p = strchr(taddr.c_str(), '\\');
                if (p == NULL)
                    dopmaska = "/128";
            }
            res = res + dopmaska + "\n";
        }
    }

    return res;
}

void TMakeRequest::ViewCatchPeriod(const TString& id, TReqParams* m_ReqParams) {
    TReqParams::iterator par_it;
    TString id_s = "";
    ui32 ide = 0;
    TString text = "";
    TString btext = "";
    int res = 0;
    TString viewlink = "";
    TString sorttype_s = "0";
    ui8 sorttype = 6;
    TIDTrapInfo resdata;
    TString mincount_s = "0";
    ui32 mincount = 0;
    TString mincounttd_s = "0";
    TString maxhamcount_today_s = "0";
    ui32 maxhamcount_today = 0;
    TString geozone = "";
    ui32 mincounttd = 0;
    bool markbanip = false;
    int onlybanip = 0; //0 - ��� ����������, 1 - ������ ���������� ������, 2 - ���, ����� ����������
    TIpType iptype = IPAll;
    TWhtIp ipwht = WHTALL;
    TString substr = "";
    bool is_pcre = false;
    TString rfrsh_link = "";
    ui32 tick = CShingleTime::GetMs();
    ui32 dlvlog_rcv = 0;
    ui32 dlvlog_skeep = 0;
    TString find_address = "";
    TNetKIPv6 addr_list = TNetKIPv6("FINDIP");
    ui32 get_resdata_tick = 0;

    if ((GetStatIPObject() != NULL)) {
        mincount_s = IntToStroka(GetStatIPObject()->GetMinStatCountPeriod());
        mincount = GetStatIPObject()->GetMinStatCountPeriod();
    }

    if (m_ReqParams != NULL) {
        par_it = m_ReqParams->find("id");
        if (par_it != m_ReqParams->end()) {
            id_s = par_it->second[0];
            ide = atoi(id_s.c_str());
        }

        par_it = m_ReqParams->find("sorttype");
        if (par_it != m_ReqParams->end()) {
            sorttype_s = par_it->second[0];
            sorttype = atoi(sorttype_s.c_str());
        }

        par_it = m_ReqParams->find("mincount");
        if (par_it != m_ReqParams->end()) {
            mincount_s = par_it->second[0];
            mincount = atoi(mincount_s.c_str());
        }

        par_it = m_ReqParams->find("mincounttd");
        if (par_it != m_ReqParams->end()) {
            mincounttd_s = par_it->second[0];
            mincounttd = atoi(mincounttd_s.c_str());
        }

        par_it = m_ReqParams->find("maxhamcount_today");
        if (par_it != m_ReqParams->end()) {
            maxhamcount_today_s = par_it->second[0];
            maxhamcount_today = atoi(maxhamcount_today_s.c_str());
        }

        par_it = m_ReqParams->find("geozone");
        if (par_it != m_ReqParams->end()) {
            geozone = par_it->second[0];
        }

        par_it = m_ReqParams->find("markbanip");
        if (par_it != m_ReqParams->end())
            markbanip = true;

        par_it = m_ReqParams->find("onlybanip");
        if (par_it != m_ReqParams->end())
            onlybanip = atoi(par_it->second[0].c_str());

        par_it = m_ReqParams->find("typeip");
        if (par_it != m_ReqParams->end())
            iptype = (TIpType)atoi(par_it->second[0].c_str());

        par_it = m_ReqParams->find("whtip");
        if (par_it != m_ReqParams->end())
            ipwht = (TWhtIp)atoi(par_it->second[0].c_str());

        par_it = m_ReqParams->find("substr");
        if (par_it != m_ReqParams->end())
            substr = Trim(par_it->second[0]);

        par_it = m_ReqParams->find("is_pcre");
        if (par_it != m_ReqParams->end())
            is_pcre = true;

        par_it = m_ReqParams->find("find_address");
        if (par_it != m_ReqParams->end()) {
            find_address = Trim(par_it->second[0]);
            find_address = FormListIP(find_address);

            addr_list.Init("", NULL);
            addr_list.ReloadMemList(find_address);
        }

        if (ide > 0) {
            if ((GetStatIPObject() != NULL) && (GetStatIPObject()->GetPeriodTrap() != NULL)) {
                if (find_address.empty()) {
                    get_resdata_tick = CShingleTime::GetMs();
                    res = GetStatIPObject()->GetPeriodTrap()->View(ide, sorttype, resdata, mincount, mincounttd, markbanip, ipwht, onlybanip, substr, is_pcre, dlvlog_rcv, dlvlog_skeep, maxhamcount_today, geozone);
                    get_resdata_tick = CShingleTime::GetMs() - get_resdata_tick;

                } else {
                    get_resdata_tick = CShingleTime::GetMs();
                    res = GetStatIPObject()->GetPeriodTrap()->ViewFA(ide, sorttype, resdata, mincount, mincounttd, markbanip, ipwht, onlybanip, substr, is_pcre, dlvlog_rcv, dlvlog_skeep, maxhamcount_today, geozone, addr_list);
                    get_resdata_tick = CShingleTime::GetMs() - get_resdata_tick;
                }
            }
            if (res > 0) {
                rfrsh_link = rfrsh_link + "&id=" + IntToStroka(ide);
                rfrsh_link = rfrsh_link + "&sorttype=" + IntToStroka(sorttype);
                rfrsh_link = rfrsh_link + "&mincount=" + IntToStroka(mincount);
                rfrsh_link = rfrsh_link + "&mincounttd=" + IntToStroka(mincounttd);
                rfrsh_link = rfrsh_link + "&maxhamcount_today=" + IntToStroka(maxhamcount_today);
                rfrsh_link = rfrsh_link + "&geozone=" + geozone;
                if (markbanip)
                    rfrsh_link = rfrsh_link + "&markbanip=" + IntToStroka(markbanip);
                rfrsh_link = rfrsh_link + "&onlybanip=" + IntToStroka(onlybanip);
                rfrsh_link = rfrsh_link + "&typeip=" + IntToStroka(iptype);
                rfrsh_link = rfrsh_link + "&whtip=" + IntToStroka(ipwht);
                rfrsh_link = rfrsh_link + "&substr=" + substr;
                if (is_pcre)
                    rfrsh_link = rfrsh_link + "&is_pcre=" + BoolToStroka(is_pcre);

                viewlink = "<A href='" + GetHost() + GetModuleName("viewcatchper") + GetActionOneParam("viewcatchper") + rfrsh_link + "'>view</A>";

                text = text + HTTP_200_OK(id);
                text = text + "<html><head>";
                text = text + "<meta http-equiv='refresh' content='5; url=" + GetHost() + GetModuleName("viewcatchper") + GetActionOneParam("viewcatchper") + rfrsh_link /*"&id=" + IntToStroka(ide)*/ + "'>";
                text = text + "</head><body bgcolor=palegoldenrod>\n";
                text = text + "<table border='0' width='100%' height='100%' cellspacing='0' cellpadding='4'>";
                text = text + "<tr><td valign='top'>The statistik already gathers. Try later (statistik " + viewlink + " automatically in " + IntToStroka(res) + " second).</td></tr>";
                text = text + "</table></body></html>";

                SendToClientRAW(text);
                WriteLog(SO_LOG_MESSAGE, 200, id);

            } else if (res < 0) {
                SendToClient(SO_LOG_ERROR, 500, "Internal error: " + IntToStroka(-1 * res) + ".", id);

            } else {
                if (find_address.empty()) {
                    text = PrintTrapPeriodData(sorttype, resdata, mincount, mincounttd, markbanip, iptype, ipwht, onlybanip, substr, is_pcre, dlvlog_rcv, dlvlog_skeep, maxhamcount_today, geozone, addr_list, find_address, get_resdata_tick);

                    tick = CShingleTime::GetMs() - tick;
                    SendToClientWithLittleShap(SO_LOG_MESSAGE, 200, text, id, tick);

                } else {
                    text = PrintTrapPeriodData(sorttype, resdata, mincount, mincounttd, markbanip, iptype, ipwht, onlybanip, substr, is_pcre, dlvlog_rcv, dlvlog_skeep, maxhamcount_today, geozone, addr_list, find_address, get_resdata_tick);

                    tick = CShingleTime::GetMs() - tick;
                    SendToClientWithLittleShap(SO_LOG_MESSAGE, 200, text, id, tick);
                }
            }

        } else {
            SendToClient(SO_LOG_ERROR, 400, "Bad request.", id);
        }
    }
}

void TMakeRequest::AskDelCatchPeriod(const TString& id, TReqParams* m_ReqParams) {
    TReqParams::iterator par_it;
    TString id_s = "";
    TString text = "";

    if (m_ReqParams != NULL) {
        //id
        par_it = m_ReqParams->find("id");
        if (par_it != m_ReqParams->end())
            id_s = GetIP(par_it->second[0].c_str());

        if (!id_s.empty()) {
            text = text + HTTP_200_OK(id);
            text = text + "<SCRIPT LANGUAGE='Javascript'>\n";
            text = text + "if(true == confirm('Delete period trap?')) {\n";
            text = text + "document.location = '" + GetHost() + GetModuleName("delcatchper") + GetActionOneParam("delcatchper") + "&id=" + id_s + "'\n";
            text = text + "} else {\n";
            text = text + "document.location = '" + GetHost() + GetModuleName("periplist") + GetActionOneParam("periplist") + "'}\n";
            text = text + "</SCRIPT>\n";
            SendToClientRAW(text);
        } else {
            SendToClientRAW(HTTP_400_BAD_REQUEST(id) + "Bad request");
        }
    } else {
        SendToClientRAW(HTTP_500_INTERNAL_SERVER_ERROR());
    }
}

void TMakeRequest::DelCatchPeriod(const TString& id, TReqParams* m_ReqParams) {
    TReqParams::iterator par_it;
    TString id_s = "";
    TString text = "";
    bool res = false;
    ui32 ide = 0;

    if (m_ReqParams != NULL) {
        par_it = m_ReqParams->find("id");
        if (par_it != m_ReqParams->end()) {
            id_s = par_it->second[0].c_str();
            ide = atoi(id_s.c_str());
        }

        if (ide > 0) {
            if ((GetStatIPObject() != NULL) && (GetStatIPObject()->GetPeriodTrap() != NULL))
                res = GetStatIPObject()->GetPeriodTrap()->EraseItem(ide);
            if (res) {
                text = text + "Delete period trap - OK.";
                SendToClient(SO_LOG_MESSAGE, 200, text, id);
            } else {
                text = text + "Delete period trap - FAILED.";
                SendToClient(SO_LOG_ERROR, 501, text, id);
            }

        } else {
            SendToClient(SO_LOG_ERROR, 400, "Bad request.", id);
        }
    } else {
        SendToClientRAW(HTTP_500_INTERNAL_SERVER_ERROR());
    }
}

TString TMakeRequest::PrintTrapPeriodData(ui8 sorttype, TIDTrapInfo& resdata, ui32 mincount, ui32 mincounttd, bool markbanip, TIpType iptype, TWhtIp ipwht, int onlybanip, const TString& substr, bool is_pcre, ui32 dlvlog_rcv, ui32 dlvlog_skeep, ui32 maxhamcount_today, const TString& geozone, TNetKIPv6& find_ip, const TString& find_ip_source, ui32 get_resdata_tick) {
    TViewItemClassListIt viit;
    TString ip_s = "";
    TString ham_s = "";
    TString spam_s = "";
    TString malic_s = "";
    TString ham_today_s = "";
    TString spam_today_s = "";
    TString malic_today_s = "";
    TString duration_s = "";
    TString host_s = "";
    TString geo_s = "";
    bool noban = false;
    const int sortbufsize = 10;
    char sortbuff[sortbufsize];
    TString checkedflag[sortbufsize];
    ui32 hamall = 0, spamall = 0, malicall = 0;
    TString text = "";
    TString t_text = "";
    TString viewmaillink = "";
    TString markbanips = "";
    TString bancolor = "";
    ui32 ip_counter = 0;
    bool banip2 = false;
    ui32 cMess = 0;
    ui32 csec = 0;
    bool ban7 = false;
    TString ip_s_form = "";
    TString typeip[3];
    TString whtip[3];
    bool printrecord = false;
    TString alliptext = "";
    TRemoteIPListIt iit;
    TString ip_checked = "";
    ui32 bantime_default = TBanIPListItem::MAX_BAN_HOURS;
    ui32 long_bantime_default = TBanIPListItem::MAX_BAN_HOURS_LONG;
    char* tbuffb = NULL;
    int in_tbuff = 0;
    int fullsize_tbuff = 0;
    ui32 traccert[10];

    memset(&traccert, 0, sizeof(traccert));
    traccert[0] = CShingleTime::GetMs();
    if (!substr.empty())
        ip_checked = " CHECKED";

    for (int i = 0; i < sortbufsize; i++)
        checkedflag[i] = "";
    memset(sortbuff, ' ', sizeof(sortbuff));
    if ((sorttype >= 0) && (sorttype < sortbufsize)) {
        sortbuff[sorttype] = '*';
        checkedflag[sorttype] = "CHECKED";
    }
    if (sorttype == 6) //all
    {
        sortbuff[1] = '*';
        sortbuff[2] = '*';
    }

    for (int i = 0; i < 3; i++) {
        if (i == iptype)
            typeip[i] = "CHECKED";
        else
            typeip[i] = "";
    }

    for (int i = 0; i < 3; i++) {
        if (i == ipwht)
            whtip[i] = "CHECKED";
        else
            whtip[i] = "";
    }

    if (markbanip)
        markbanips = "CHECKED";

    traccert[1] = CShingleTime::GetMs();
    if ((GetStatIPObject() != NULL) && (GetStatIPObject()->GetBasesStore() != NULL))
        GetStatIPObject()->GetBasesStore()->GetSetupBanTime(bantime_default, long_bantime_default);
    traccert[1] = CShingleTime::GetMs() - traccert[1];

    traccert[2] = get_resdata_tick;

    TString perform = GetTrapForm("viewcatchper", iptype, onlybanip, sorttype, ipwht, 60, markbanip, mincount, mincounttd, resdata.start, substr, is_pcre, maxhamcount_today, geozone);
    TString performFA = GetTrapFormFA("viewcatchper", iptype, onlybanip, sorttype, ipwht, 60, markbanip, mincount, mincounttd, resdata.start, substr, is_pcre, maxhamcount_today, geozone, find_ip, find_ip_source);

    ip_s = "<A href='" + GetHost() + GetModuleName("viewcatchper") + "?" + GetActionMultiParam("viewcatchper") + "id=" + IntToStroka(resdata.start) + "&sorttype=0&mincount=" + IntToStroka(mincount) + "&mincounttd=" + IntToStroka(mincounttd) + "&markbanip=" + IntToStroka(markbanip) + "&typeip=" + IntToStroka(iptype) + "&onlybanip=" + IntToStroka(onlybanip) + "&whtip=" + IntToStroka(ipwht) + "'><b>" + TString(sortbuff[0]) + "IP</b></A>";
    ham_s = "<A href='" + GetHost() + GetModuleName("viewcatchper") + "?" + GetActionMultiParam("viewcatchper") + "id=" + IntToStroka(resdata.start) + "&sorttype=1&mincount=" + IntToStroka(mincount) + "&mincounttd=" + IntToStroka(mincounttd) + "&markbanip=" + IntToStroka(markbanip) + "&typeip=" + IntToStroka(iptype) + "&onlybanip=" + IntToStroka(onlybanip) + "&whtip=" + IntToStroka(ipwht) + "'><b>" + TString(sortbuff[1]) + "HAM (today)</b></A>";
    spam_s = "<A href='" + GetHost() + GetModuleName("viewcatchper") + "?" + GetActionMultiParam("viewcatchper") + "id=" + IntToStroka(resdata.start) + "&sorttype=2&mincount=" + IntToStroka(mincount) + "&mincounttd=" + IntToStroka(mincounttd) + "&markbanip=" + IntToStroka(markbanip) + "&typeip=" + IntToStroka(iptype) + "&onlybanip=" + IntToStroka(onlybanip) + "&whtip=" + IntToStroka(ipwht) + "'><b>" + TString(sortbuff[2]) + "SPAM (today)</b></A>";
    malic_s = "<A href='" + GetHost() + GetModuleName("viewcatchper") + "?" + GetActionMultiParam("viewcatchper") + "id=" + IntToStroka(resdata.start) + "&sorttype=3&mincount=" + IntToStroka(mincount) + "&mincounttd=" + IntToStroka(mincounttd) + "&markbanip=" + IntToStroka(markbanip) + "&typeip=" + IntToStroka(iptype) + "&onlybanip=" + IntToStroka(onlybanip) + "&whtip=" + IntToStroka(ipwht) + "'><b>" + TString(sortbuff[3]) + "MALIC (today)</b></A>";
    duration_s = "<b>DURATION</b>";
    host_s = "<A href='" + GetHost() + GetModuleName("viewcatchper") + "?" + GetActionMultiParam("viewcatchper") + "id=" + IntToStroka(resdata.start) + "&sorttype=5&mincount=" + IntToStroka(mincount) + "&mincounttd=" + IntToStroka(mincounttd) + "&markbanip=" + IntToStroka(markbanip) + "&typeip=" + IntToStroka(iptype) + "&onlybanip=" + IntToStroka(onlybanip) + "&whtip=" + IntToStroka(ipwht) + "'><b>" + TString(sortbuff[5]) + "HOST</b></A>";
    geo_s = "<A href='" + GetHost() + GetModuleName("viewcatchper") + "?" + GetActionMultiParam("viewcatchper") + "id=" + IntToStroka(resdata.start) + "&sorttype=7&mincount=" + IntToStroka(mincount) + "&mincounttd=" + IntToStroka(mincounttd) + "&markbanip=" + IntToStroka(markbanip) + "&typeip=" + IntToStroka(iptype) + "&onlybanip=" + IntToStroka(onlybanip) + "&whtip=" + IntToStroka(ipwht) + "'><b>" + TString(sortbuff[7]) + "GEO</b></A>";

    text = text + "<b>Period statistik for " + TimeToStr(resdata.start) + " (period=" + IntToStroka(resdata.period) + ", stoptime=" + TimeToStr(resdata.stoptime) + ")</b> <b>SUBSTR=</b>'" + substr + "'(IS_PCRE:" + BoolToStroka2(is_pcre) + ")  &nbsp; <A href='" + GetHost() + GetModuleName("askdelcatchper") + GetActionOneParam("askdelcatchper") + "&id=" + IntToStroka(resdata.start) + "'>delete item</A> &nbsp; <A href='" + GetHost() + GetModuleName("periplist") + GetActionOneParam("periplist") + "'>view period trap list</A>";

    TString bandefwin = "<A href='" + GetHost() + GetModuleName("bandefwin") + GetActionOneParam("bandefwin") + "' target='_blank'>ban_defaults</A>";
    TString bangroupshap = "<table border='0' width='100%' cellspacing='0' cellpadding='4'>";
    bangroupshap = bangroupshap + "<tr><td width='50%' align='left'>Ban group addresses (< " + IntToStroka(TBanIPListItem::MAX_BAN_HOURS) + " hours): &nbsp;<input type='text' size='10' name='bantime' value='" + IntToStroka(bantime_default) + "'>&nbsp;<input type='checkbox' size='10' name='intbi'>internal &nbsp;" + GetActionFormParam("askaddblackig") + "<input type='submit' size='30' value='Ban group'></td><td width='50%' align='right'>" + bandefwin + " &nbsp; </td></tr>";
    bangroupshap = bangroupshap + "</table>";

    text = text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=lemonchiffon>";
    text = text + "<tr><td colspan='7' align='center'>" + perform + "</td><td colspan='2' align='center'>" + performFA + "</td></tr>";
    //text = text + "<tr><td colspan='9' align='center'>" + performFA + "</td></tr>";
    text = text + "<form action='" + GetHost() + GetModuleName("askaddblackig") + "' method='GET' enctype='text/plain' target='_black'>";
    //text += "<tr><td colspan='4'>All " + IntToStroka(resdata.allmails) + " mails from " + IntToStroka(resdata.allip) + " ip, receive_log=" + IntToStroka(resdata.rcv_dlvlog) + ", skeep_log=" + IntToStroka(resdata.skeep_dlvlog) + "</td><td colspan='5'>Ban group addresses (< " + IntToStroka(TBanIPListItem::MAX_BAN_HOURS) + " hours): &nbsp;<input type='text' size='10' name='bantime' value='" + IntToStroka(bantime_default) + "'>&nbsp;<input type='checkbox' size='10' name='intbi'>internal &nbsp;" + GetActionFormParam("askaddblackig") + "<input type='submit' size='30' value='Ban group'></td></tr>\n";
    text += "<tr><td colspan='4'>All " + IntToStroka(resdata.allmails) + " mails from " + IntToStroka(resdata.allip) + " ip, receive_log=" + IntToStroka(resdata.rcv_dlvlog) + ", skeep_log=" + IntToStroka(resdata.skeep_dlvlog) + "</td><td colspan='5'>" + bangroupshap + "</td></tr>\n";
    text = text + "<tr bgcolor='" + TString(BGSHAPCOLOR) + "'>";
    text = text + "<td colspan='2' width='10%'>" + ip_s + "</td>";
    text = text + "<td width='5%'>&nbsp;</td>";
    text = text + "<td width='15%'>" + ham_s + "</td>";
    text = text + "<td width='15%'>" + spam_s + "</td>";
    text = text + "<td width='15%'>" + malic_s + "</td>";
    text = text + "<td width='5%'>" + duration_s + "</td>";
    text = text + "<td width='30%'>" + host_s + "</td>";
    text = text + "<td width='5%'>" + geo_s + "</td>";
    text = text + "</tr>\n";

    fullsize_tbuff = text.length() + (1024 * resdata.data.size()) + 4096 + (resdata.remote_iplist.size() * 64) + 1;
    if (fullsize_tbuff <= 0)
        fullsize_tbuff = 4096;
    tbuffb = new char[fullsize_tbuff];
    if (tbuffb != NULL) {
        try {
            tbuffb[0] = 0x00;
            tbuffb[fullsize_tbuff - 1] = 0x00;
            if (text.length() > 0) {
                if (text.length() < (fullsize_tbuff - in_tbuff)) {
                    memcpy(tbuffb + in_tbuff, text.c_str(), text.length());
                    in_tbuff += text.length();
                }
            }

            traccert[3] = CShingleTime::GetMs();
            viit = resdata.data.begin();
            ip_counter = 0;
            while (viit != resdata.data.end()) {
                if ((iptype == IPv4) && ((*viit).ip().IsIPv6())) {
                    ++viit;
                    continue;
                }
                if ((iptype == IPv6) && ((*viit).ip().IsIPv4())) {
                    ++viit;
                    continue;
                }

                ip_counter++;
                ip_s_form = (*viit).ip().toStroka();
                CGIEscape(ip_s_form);
                viewmaillink = "<A href='" + GetHost() + GetModuleName("viewmailpertrap") + "?" + GetActionMultiParam("viewmailpertrap") + "id=" + IntToStroka(resdata.start) + "&ip=" + ip_s_form + "&sorttype=" + IntToStroka(sorttype) + "&mincount=" + IntToStroka(mincount) + "&mincounttd=" + IntToStroka(mincounttd) + "&markbanip=" + BoolToStroka(markbanip) + "'>view mail</A>";
                ip_s = "<A href='" + GetHost() + GetModuleName("viewipstat") + GetActionOneParam("viewipstat") + "&ip=" + ip_s_form + "'>" + (*viit).ip().toStroka() + "</A>";
                ham_s = IntToStroka((*viit).ham());
                spam_s = IntToStroka((*viit).spam());
                malic_s = IntToStroka((*viit).malic());
                duration_s = IntToStroka((*viit).duration());
                host_s = (*viit).rdns_isx();
                geo_s = (*viit).geo();
                noban = (*viit).noban();
                if (noban) {
                    ham_today_s = IntToStroka((*viit).ham_today());
                    spam_today_s = IntToStroka((*viit).spam_today());
                    malic_today_s = IntToStroka((*viit).malic_today());

                } else {
                    ham_today_s = "unavailable";
                    spam_today_s = "unavailable";
                    malic_today_s = "unavailable";
                }

                hamall += (*viit).ham();
                spamall += (*viit).spam();
                malicall += (*viit).malic();

                if ((GetStatIPObject() != NULL) && (GetStatIPObject()->GetBasesStore() != NULL) && (GetStatIPObject()->GetBasesStore()->GetBanIP() != NULL)) {
                    if (GetStatIPObject()->GetBasesStore()->GetBanIP()->IsBanIp((*viit).ip(), &cMess, &csec, ban7) > 0)
                        banip2 = true;
                    else
                        banip2 = false;
                } else
                    banip2 = false;

                if (markbanip && banip2)
                    bancolor = "bgcolor='LightPink'";
                else if ((*viit).visfrwd())
                    bancolor = "bgcolor='GreenYellow'";
                else
                    bancolor = "";

                printrecord = false;
                if (onlybanip == 2) //�������� ������ ���������� ������
                {
                    if (banip2) {
                        printrecord = true;
                        //bancolor = "";
                    }

                } else if (onlybanip == 3) //�������� ������ ������������ ������
                {
                    if (!banip2)
                        printrecord = true;

                } else {
                    printrecord = true; //�������� ���
                }

                if (printrecord) {
                    t_text = "";
                    /*t_text += "<tr " + bancolor + ">";
               t_text += "<td width = '2%' align='left'><input type='checkbox' size='2' name='ip" + IntToStroka3(ip_counter) + "' value='" + ip_s_form + "'" + ip_checked + "></td>";
               t_text += "<td width='8%'>" + ip_s + "</td>";
               t_text += "<td width='5%' align='center'>" + viewmaillink + "</td>";
               t_text += "<td width='15%'>" + ham_s + " (" + ham_today_s + ")</td>";
               t_text += "<td width='15%'>" + spam_s + " (" + spam_today_s + ")</td>";
               t_text += "<td width='15%'>" + malic_s + " (" + malic_today_s + ")</td>";
               t_text += "<td width='5%'>" + duration_s + "</td>";
               t_text += "<td width='30%'>" + host_s + "</td>";
               t_text += "<td width='5%'>" + geo_s + " &nbsp;</td>";
               t_text += "</tr>\n";*/
                    t_text += "<tr " + bancolor + ">";
                    t_text += "<td><input type='checkbox' size='2' name='ip" + IntToStroka3(ip_counter) + "' value='" + ip_s_form + "'" + ip_checked + "></td>";
                    t_text += "<td>" + ip_s + "</td>";
                    t_text += "<td>" + viewmaillink + "</td>";
                    t_text += "<td>" + ham_s + " (" + ham_today_s + ")</td>";
                    t_text += "<td>" + spam_s + " (" + spam_today_s + ")</td>";
                    t_text += "<td>" + malic_s + " (" + malic_today_s + ")</td>";
                    t_text += "<td>" + duration_s + "</td>";
                    t_text += "<td>" + WrapRdnsStroka(host_s) + "</td>";
                    if (!geo_s.empty())
                        t_text += "<td>" + WrapRdnsStroka(geo_s) + "</td>";
                    else
                        t_text += "<td>" + geo_s + " &nbsp;</td>";
                    t_text += "</tr>\n";

                    if (t_text.length() > 0) {
                        if (t_text.length() < (fullsize_tbuff - in_tbuff)) {
                            memcpy(tbuffb + in_tbuff, t_text.c_str(), t_text.length());
                            in_tbuff += t_text.length();
                        }
                    }
                }

                ++viit;
            }
            traccert[3] = CShingleTime::GetMs() - traccert[3];

            ip_s = "<b>All: " + IntToStroka(ip_counter) + " (" + IntToStroka(resdata.data.size()) + ")</b>";
            ham_s = "<b>All: " + IntToStroka(hamall) + "</b>";
            spam_s = "<b>All: " + IntToStroka(spamall) + "</b>";
            malic_s = "<b>All: " + IntToStroka(malicall) + "</b>";
            duration_s = " &nbsp; ";
            host_s = " &nbsp; ";
            geo_s = " &nbsp; ";
            text = "";
            text = text + "<tr><td colspan='2' width='15%'>" + ip_s + "</td><td width='10%'>&nbsp;</td><td width='10%'>" + ham_s + "</td><td width='10%'>" + spam_s + "<td width='10%'>" + malic_s + "</td><td width='10%'>" + duration_s + "</td><td width='30%'>" + host_s + "</td><td width='5%'>" + host_s + "</td></tr>\n";
            text = text + "</form>";

            text = text + "<table>\n";

            text = text + "<br><b><i>IP senders dlvlogs (spdemon's from cluster):</i></b><br>";
            text = text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=lemonchiffon>";
            text = text + "<tr><td>";

            traccert[4] = CShingleTime::GetMs();
            iit = resdata.remote_iplist.begin();
            while (iit != resdata.remote_iplist.end()) {
                if (alliptext.empty())
                    alliptext = alliptext + (*iit).first + "(" + IntToStroka((*iit).second) + ")";
                else
                    alliptext = alliptext + ", " + (*iit).first + "(" + IntToStroka((*iit).second) + ")";

                ++iit;
            }
            traccert[4] = CShingleTime::GetMs() - traccert[4];
            text = text + alliptext;
            text = text + "</td></tr>";
            text = text + "<table><br>\n";
            traccert[0] = CShingleTime::GetMs() - traccert[0];
            text = text + "docsize=" + IntToStroka(in_tbuff + 100) + ", trace=" + IntToStroka(traccert[0]) + "," + IntToStroka(traccert[1]) + "-" + IntToStroka(traccert[2]) + "-" + IntToStroka(traccert[3]) + "-" + IntToStroka(traccert[4]) + ".";

            if (text.length() > 0) {
                if (text.length() < (fullsize_tbuff - in_tbuff)) {
                    memcpy(tbuffb + in_tbuff, text.c_str(), text.length());
                    in_tbuff += text.length();
                }
            }

            text = TString(tbuffb, in_tbuff);

            delete[] tbuffb;
            tbuffb = NULL;

        } catch (...) {
            delete[] tbuffb;
            tbuffb = NULL;
        }
    }

    return text;
}

void TMakeRequest::ViewMailPeriodTrap(const TString& id, TReqParams* m_ReqParams) {
    TReqParams::iterator par_it;
    TString ip_s = "";
    TString ip_s_form = "";
    TString id_s = "";
    ui32 ide = 0;
    TKIPv6 ip = TKIPv6();
    TString sorttype_s = "0";
    TString mincount_s = "0";
    TString mincounttd_s = "";
    TString markbanip_s = "";
    TString sbanip = "";
    TString sbanip7 = "";
    TTrapMails slist;
    TKStrokaListIt it;
    TString text = "";
    ui32 bantime_default = TBanIPListItem::MAX_BAN_HOURS;
    ui32 long_bantime_default = TBanIPListItem::MAX_BAN_HOURS_LONG;

    if (GetStatIPObject() != NULL)
        mincount_s = IntToStroka(GetStatIPObject()->GetMinStatCountPeriod());

    if ((GetStatIPObject() != NULL) && (GetStatIPObject()->GetBasesStore() != NULL))
        GetStatIPObject()->GetBasesStore()->GetSetupBanTime(bantime_default, long_bantime_default);

    if (m_ReqParams != NULL) {
        par_it = m_ReqParams->find("id");
        if (par_it != m_ReqParams->end()) {
            id_s = Trim(par_it->second[0]);
            ide = atoi(id_s.c_str());
        }

        par_it = m_ReqParams->find("ip");
        if (par_it != m_ReqParams->end()) {
            ip_s = Trim(par_it->second[0]);
            ip_s_form = ip_s;
            CGIUnescape(ip_s);
            ip = TKIPv6(ip_s.c_str());
        }

        par_it = m_ReqParams->find("sorttype");
        if (par_it != m_ReqParams->end())
            sorttype_s = par_it->second[0];

        par_it = m_ReqParams->find("mincount");
        if (par_it != m_ReqParams->end())
            mincount_s = par_it->second[0];

        par_it = m_ReqParams->find("mincounttd");
        if (par_it != m_ReqParams->end())
            mincounttd_s = par_it->second[0];

        par_it = m_ReqParams->find("markbanip");
        if (par_it != m_ReqParams->end())
            markbanip_s = par_it->second[0];

        if ((ide > 0) && (!ip.Undefined())) {
            sbanip = "<form action='" + GetHost() + GetModuleName("askaddblackip") + "' method='GET' enctype='text/plain'><input type='hidden' size='20' name='ip' value='" + ip_s + "'>&nbsp ban time (<" + IntToStroka(TBanIPListItem::MAX_BAN_HOURS) + " hour): &nbsp <input type='text' size='10' name='bantime' value='" + IntToStroka(bantime_default) + "'> &nbsp <input type='checkbox' size='10' name='intbi' value='1'>internal &nbsp " + GetActionFormParam("askaddblackip") + "<input type='submit' size='10' value='ban ip'></form>";
            sbanip7 = "<form action='" + GetHost() + GetModuleName("askaddban7ip") + "' method='GET' enctype='text/plain'><input type='hidden' size='20' name='ip' value='" + ip_s + "'>&nbsp ban time (<" + IntToStroka(TBanIPListItem::MAX_BAN_HOURS) + " hour): &nbsp <input type='text' size='10' name='bantime' value='" + IntToStroka(bantime_default) + "'> &nbsp; " + GetActionFormParam("askaddban7ip") + "<input type='submit' size='10' value='ban 7'></form>";

            if ((GetStatIPObject() != NULL) && (GetStatIPObject()->GetPeriodTrap() != NULL))
                GetStatIPObject()->GetPeriodTrap()->ViewMails(ide, slist, ip);

            text = text + "<b>Mails from IP=<A href='" + GetHost() + GetModuleName("viewipstat") + GetActionOneParam("viewipstat") + "&ip=" + ip_s_form + "'>" + ip.toStroka() + "</A> for <A href='" + GetHost() + GetModuleName("viewcatchper") + "?" + GetActionMultiParam("viewcatchper") + "id=" + id_s + "&sorttype=" + sorttype_s + "&mincount=" + mincount_s + "&mincounttd=" + mincounttd_s + "&markbanip=" + markbanip_s + "'>" + TimeToStr(slist.start) + "(" + IntToStroka(slist.period) + ")</A></b> &nbsp; <A href='" + GetHost() + GetModuleName("periplist") + GetActionOneParam("periplist") + "'>view period trap list</A>";
            text = text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=lemonchiffon>";
            text = text + "<tr valign='top' bgcolor='palegoldenrod'><td align='center' width='50%'><br>" + sbanip + "</td><td align='center' width='50%'><br>" + sbanip7 + "</td></tr>\n";
            it = slist.data.begin();
            while (it != slist.data.end()) {
                text = text + "<tr><td colspan='2'>" + (*it) + "</td></tr>";
                text = text + "<tr bgcolor=palegoldenrod><td colspan='2'>&nbsp;</td></tr>";
                ++it;
            }
            text = text + "</table>";

            SendToClientWithLittleShap(SO_LOG_MESSAGE, 200, text, id);
        } else {
            SendToClient(SO_LOG_ERROR, 400, "Bad request.", id);
        }
    }
}

void TMakeRequest::FindB3Log(const TString& id, TReqParams* m_ReqParams) {
    if ((GetStatIPObject() != NULL) && (GetStatIPObject()->EnableViewStatLogs())) {
        SendToClient(SO_LOG_MESSAGE, 200, "Function disabled.", id);

        /*TReqParams::iterator par_it;
      TString               ip_s           = "";
      TString               ip_s_form      = "";
      TKIPv6               ip             = TKIPv6();
      ui32                 year = 0, mon = 0, day = 0;
      TString               year_s = "", mon_s = "", day_s = "", nodiskindex_s = "";
      TString               btext = "", errtext = "";
      bool                 nodiskindex = false;
      int                  err            = 0;
      TString               text           = "";
      TString               ip_link        = "";

      par_it = m_ReqParams->find("ip");
      if( par_it != m_ReqParams->end() )
      {
         ip_s = Trim(par_it->second[0]);
         ip_s_form = ip_s;
         CGIUnescape(ip_s);
         ip = TKIPv6(ip_s.c_str());
      }

      par_it = m_ReqParams->find("year");
      if( par_it != m_ReqParams->end() )
      {
         year_s = GetIP(par_it->second[0]);
         year = atoi(year_s.c_str());
      }

      par_it = m_ReqParams->find("mon");
      if( par_it != m_ReqParams->end() )
      {
         mon_s = GetIP(par_it->second[0]);
         mon = atoi(mon_s.c_str());
      }

      par_it = m_ReqParams->find("day");
      if( par_it != m_ReqParams->end() )
      {
         day_s = GetIP(par_it->second[0]);
         day = atoi(day_s.c_str());
      }

      par_it = m_ReqParams->find("diskindex");
      if( par_it != m_ReqParams->end() )
      {
         nodiskindex_s = GetIP(par_it->second[0].c_str());
         nodiskindex = atoi(nodiskindex_s.c_str());
      }

      if (!ip.Undefined())
      {
         if (m_pServer != NULL)
         {
            if ( (year == 0) && (mon == 0) )
            {
               btext = m_pServer->TVB3.GetMailFromIPLastDays(day, ip, !nodiskindex);

               ip_link = "<A href='" + GetHost() + "viewipstat?ip=" + IntToIp(ip) + "'>" + IntToIp(ip) + "</A>";
               // Header
               text = text + "<table border='0' width='100%' cellspacing='0' cellpadding='4' bgcolor=lemonchiffon>\n";
               text = text + "<tr valign='top' bgcolor='palegoldenrod'><td align='left'><br><b>Query IP: " + ip_link +"</b><br></td></tr>\n";
               text = text + btext;
               text = text + "</table>\n";
               SendToClientWithLittleShap(SO_LOG_MESSAGE, 200, text);

            } else
            {
               char tbuff[16];

               memset(tbuff, 0, sizeof(tbuff));
               snprintf(tbuff, sizeof(tbuff) - 1, "%4u.%02u.%02u", year, mon, day);
               btext = m_pServer->TVB3.GetMailFromIP(year, mon, day, ip, err, !nodiskindex);

               ip_link = "<A href='" + GetHost() + "viewipstat?ip=" + IntToIp(ip) + "'>" + IntToIp(ip) + "</A>";
               text = text + "<table border='0' width='100%' cellspacing='0' cellpadding='4' bgcolor=lemonchiffon>\n";
               text = text + "<tr valign='top' bgcolor='palegoldenrod'><td align='left'><br><b>Query IP: " + ip_link + " in " + TString(tbuff) + "</b><br></td></tr>\n";
               text = text + "<tr valign='top' bgcolor='palegoldenrod'>";
               text = text + "<td align='left'>";

               switch (err)
               {
                  case 0:
                           text = text + "<br>" + btext;
                           break;
                  case 4:
                           text = text + "<br>Bad structure log file.";
                           break;
                  case 7:
                           text = text + "<br>" + btext;
                           break;
                  default:
                           text = text + "<br>Error: " + IntToStroka(err);

               };

               text = text + "</td></tr>\n</table>\n";

               SendToClientWithLittleShap(SO_LOG_MESSAGE, 200, text);

            }

         }
      } else
      {
         SendToClient(SO_LOG_ERROR, 400, "Bad request");
      }*/
    } else {
        SendToClient(SO_LOG_MESSAGE, 200, "Function disabled.", id);
    }
}

void TMakeRequest::AFindB3Log(const TString& id, TReqParams* m_ReqParams) {
    if ((GetStatIPObject() != NULL) && (GetStatIPObject()->EnableViewStatLogs())) {
        SendToClient(SO_LOG_MESSAGE, 200, "Function disabled.", id);
    } else {
        SendToClient(SO_LOG_MESSAGE, 200, "Function disabled.", id);
    }
}

void TMakeRequest::GetBanSetup(const TString& id, TReqParams* m_ReqParams) {
    TReqParams::iterator par_it;

    bool pr_ok = false;
    TString text = "";
    ui32 bantime = 0;
    ui32 long_bantime = 0;

    if ((GetStatIPObject() != NULL) && (GetStatIPObject()->GetBasesStore() != NULL)) {
        GetStatIPObject()->GetBasesStore()->GetSetupBanTime(bantime, long_bantime);

        text = text + "<bantime>" + IntToStroka(bantime) + "</bantime>\n";
        text = text + "<long_bantime>" + IntToStroka(long_bantime) + "</long_bantime>\n";

        SendToClientWithLittleShap(SO_LOG_MESSAGE, 200, text, id);

    } else {
        SendToClientRAW(TString(HTTP_500_INTERNAL_SERVER_ERROR()));
    }
}

void TMakeRequest::SetBanSetup(const TString& id, TReqParams* m_ReqParams) {
    TReqParams::iterator par_it;

    if (m_ReqParams != NULL) {
        bool pr_ok = false;
        TString text = "";
        ui32 bantime = 0;
        ui32 long_bantime = 0;
        TReqParams::iterator par_it;

        par_it = m_ReqParams->find("bantime");
        if (par_it != m_ReqParams->end())
            bantime = atoi(par_it->second[0].c_str());

        par_it = m_ReqParams->find("long_bantime");
        if (par_it != m_ReqParams->end())
            long_bantime = atoi(par_it->second[0].c_str());

        if ((GetStatIPObject() != NULL) && (GetStatIPObject()->GetBasesStore() != NULL)) {
            GetStatIPObject()->GetBasesStore()->SetSetupBanTime(bantime, long_bantime);

            text = text + "Set bantime OK:\n";
            text = text + "bantime=" + IntToStroka(bantime) + "\n";
            text = text + "long_bantime=" + IntToStroka(long_bantime) + "\n";

            SendToClientWithLittleShap(SO_LOG_MESSAGE, 200, text, id);

        } else {
            SendToClientRAW(TString(HTTP_500_INTERNAL_SERVER_ERROR()));
        }

    } else {
        SendToClientRAW(TString(HTTP_500_INTERNAL_SERVER_ERROR()));
    }
}

void TMakeRequest::SetBanDefaultsWindow(const TString& id, TReqParams* m_ReqParams) {
    TString text = "";

    text = text + "<br><i><b>Set ban defaults:</b></i>&nbsp;&nbsp;\n";
    //if (IsAUser)
    //   text = text + "<A href='" + GetHost() + GetModuleName("bancontrol") + GetActionOneParam("bancontrol") + "'>Ban control</A>\n";
    text = text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=lemonchiffon>\n";
    if ((GetStatIPObject() != NULL) && (GetStatIPObject()->GetBasesStore() != NULL)) {
        ui32 bantime_v = 0;
        ui32 long_bantime_v = 0;
        TString ban_setup_v = "";

        GetStatIPObject()->GetBasesStore()->GetSetupBanTime(bantime_v, long_bantime_v);
        ban_setup_v = "<form action='" + GetHost() + GetModuleName("setbansetup") + "' method='GET' enctype='text/plain'>bantime=<input type='text' size='20' name='bantime' value='" + IntToStroka(bantime_v) + "'>, &nbsp;long_bantime=<input type='text' size='20' name='long_bantime' value='" + IntToStroka(long_bantime_v) + "'>" + GetActionFormParam("setbansetup") + "&nbsp;<input type='submit' size='20' value='Set ban parameters'></form> &nbsp; ";
        text = text + "<tr valign='top'><td align='left' width='30%'>Ban parameters</td><td>\n<br>bantime=" + IntToStroka(bantime_v) + ", &nbsp;long_bantime=" + IntToStroka(long_bantime_v) + "<br><br>" + ban_setup_v + "</td></tr>\n";
    }
    text = text + "</table>\n";

    SendToClientWithShap(SO_LOG_MESSAGE, 200, text, id);
}

void TMakeRequest::PrintMemStat(const TString& id, TReqParams* m_ReqParams) {
#ifdef MONGO_STORAGE

    TReqParams::iterator par_it;
    bool needstor = false;
    TLocalCacheStat localcache_stat;

    if (m_ReqParams != NULL) {
        par_it = m_ReqParams->find("storsubmit");
        if (par_it != m_ReqParams->end()) {
            needstor = true;
        } else {
            par_it = m_ReqParams->find("localsubmit");
            if (par_it != m_ReqParams->end()) {
                needstor = false;
            }
        }

        if ((GetStatIPObject() != NULL) && (GetStatIPObject()->GetBasesStore() != NULL) && (GetStatIPObject()->GetBasesStore()->GetMemBasa() != NULL) && (GetStatIPObject()->GetBasesStore()->GetMemBasa()->NeedUpdateLocalCache()))
            needstor = true;

        if (needstor) {
            if ((GetStatIPObject() != NULL) && (GetStatIPObject()->GetBasesStore() != NULL) && (GetStatIPObject()->GetBasesStore()->GetMemBasa() != NULL))
                GetStatIPObject()->GetBasesStore()->GetMemBasa()->SetNeedUpdateLocalCache();

            par_it = m_ReqParams->find("storsubmit");
            if (par_it != m_ReqParams->end())
                m_ReqParams->erase(par_it);

            par_it = m_ReqParams->find("needstor");
            if (par_it != m_ReqParams->end())
                m_ReqParams->erase(par_it);

            par_it = m_ReqParams->find("localsubmit");
            if (par_it == m_ReqParams->end()) {
                par_it = m_ReqParams->insert(TReqParams::value_type("localsubmit", TReqValues())).first;
                if (par_it != m_ReqParams->end())
                    par_it->second.push_back("1");
                //(*m_ReqParams)["localsubmit"] = TReqValues();
            }
        }

        if ((GetStatIPObject() != NULL) && (GetStatIPObject()->GetBasesStore() != NULL) && (GetStatIPObject()->GetBasesStore()->GetMemBasa() != NULL))
            localcache_stat = GetStatIPObject()->GetBasesStore()->GetMemBasa()->GetHeavyLocalCacheStat();

        if (localcache_stat.LocalCacheReady()) {
            PrintMemStatOld(id, m_ReqParams);

        } else {
            TString text = "";
            TString viewlink = "";
            TString rfrsh_link = "";
            TString sorttype = "";
            TString enableexlude = "";
            TString exludeforwards = "";
            TString mincount = "";
            TString maxlastsec = "";
            TString maxcountrecord = "";
            TString maxcountham = "";
            TString markbanip = "";
            TString excludebanip = "";
            TString iptype = "";
            TString ipwht = "";
            TString needstor = "";
            TString storsubmit = "";
            TString localsubmit = "";
            TString find_ip_source = "";

            par_it = m_ReqParams->find("sorttype");
            if (par_it != m_ReqParams->end())
                sorttype = Trim(par_it->second[0]);

            par_it = m_ReqParams->find("enableexlude");
            if (par_it != m_ReqParams->end())
                enableexlude = Trim(par_it->second[0]);

            par_it = m_ReqParams->find("exludeforward");
            if (par_it != m_ReqParams->end())
                exludeforwards = Trim(par_it->second[0]);

            par_it = m_ReqParams->find("mincount");
            if (par_it != m_ReqParams->end())
                mincount = Trim(par_it->second[0]);

            par_it = m_ReqParams->find("maxlastsec");
            if (par_it != m_ReqParams->end())
                maxlastsec = Trim(par_it->second[0]);

            par_it = m_ReqParams->find("maxcntham");
            if (par_it != m_ReqParams->end())
                maxcountham = Trim(par_it->second[0]);

            par_it = m_ReqParams->find("maxrecords");
            if (par_it != m_ReqParams->end())
                maxcountrecord = Trim(par_it->second[0]);

            par_it = m_ReqParams->find("markbanip");
            if (par_it != m_ReqParams->end())
                markbanip = Trim(par_it->second[0]);

            par_it = m_ReqParams->find("excludebanip");
            if (par_it != m_ReqParams->end())
                excludebanip = Trim(par_it->second[0]);

            par_it = m_ReqParams->find("typeip");
            if (par_it != m_ReqParams->end())
                iptype = Trim(par_it->second[0]);

            par_it = m_ReqParams->find("whtip");
            if (par_it != m_ReqParams->end())
                ipwht = Trim(par_it->second[0]);

            par_it = m_ReqParams->find("needstor");
            if (par_it != m_ReqParams->end())
                needstor = Trim(par_it->second[0]);

            par_it = m_ReqParams->find("storsubmit");
            if (par_it != m_ReqParams->end())
                storsubmit = Trim(par_it->second[0]);

            par_it = m_ReqParams->find("localsubmit");
            if (par_it != m_ReqParams->end())
                localsubmit = Trim(par_it->second[0]);

            par_it = m_ReqParams->find("find_address");
            if (par_it != m_ReqParams->end())
                find_ip_source = Trim(par_it->second[0]);

            if (!sorttype.empty())
                rfrsh_link = rfrsh_link + "&sorttype=" + sorttype;
            if (!enableexlude.empty())
                rfrsh_link = rfrsh_link + "&enableexlude=" + enableexlude;
            if (!exludeforwards.empty())
                rfrsh_link = rfrsh_link + "&exludeforward=" + exludeforwards;
            if (!mincount.empty())
                rfrsh_link = rfrsh_link + "&mincount=" + mincount;
            if (!maxlastsec.empty())
                rfrsh_link = rfrsh_link + "&maxlastsec=" + maxlastsec;
            if (!maxcountham.empty())
                rfrsh_link = rfrsh_link + "&maxcntham=" + maxcountham;
            if (!maxcountrecord.empty())
                rfrsh_link = rfrsh_link + "&maxrecords=" + maxcountrecord;
            if (!markbanip.empty())
                rfrsh_link = rfrsh_link + "&markbanip=" + markbanip;
            if (!excludebanip.empty())
                rfrsh_link = rfrsh_link + "&excludebanip=" + excludebanip;
            if (!iptype.empty())
                rfrsh_link = rfrsh_link + "&typeip=" + iptype;
            if (!ipwht.empty())
                rfrsh_link = rfrsh_link + "&whtip=" + ipwht;
            if (!needstor.empty())
                rfrsh_link = rfrsh_link + "&needstor=" + needstor;
            if (!storsubmit.empty())
                rfrsh_link = rfrsh_link + "&storsubmit=" + storsubmit;
            if (!localsubmit.empty())
                rfrsh_link = rfrsh_link + "&localsubmit=" + localsubmit;
            if (!find_ip_source.empty())
                rfrsh_link = rfrsh_link + "&find_address=" + find_ip_source;

            viewlink = "<A href='" + GetHost() + GetModuleName("printmemstat") + GetActionOneParam("printmemstat") + rfrsh_link + "'>update now</A>";

            text = text + HTTP_200_OK(id);
            text = text + "<html><head>";
            text = text + "<meta http-equiv='refresh' content='3; url=" + GetHost() + GetModuleName("printmemstat") + GetActionOneParam("printmemstat") + rfrsh_link + "'>";
            text = text + "</head><body bgcolor=palegoldenrod>\n";
            text = text + "<table border='0' width='100%' height='100%' cellspacing='0' cellpadding='4'>";
            text = text + "<tr><td valign='top'>" + m_servername + ": the heavy host statistik already gathers. Elapsed " + GetTimePeriod(time(NULL) - localcache_stat.m_start_update_time) + ". Wait (" + viewlink + ")...</td></tr>";
            text = text + "</table></body></html>";

            SendToClientRAW(text);
            WriteLog(SO_LOG_MESSAGE, 200, id);
        }

    } else {
        SendToClientRAW(TString(HTTP_500_INTERNAL_SERVER_ERROR()));
    }

#else
    PrintMemStatOld(id, m_ReqParams);
#endif
}

TString TMakeRequest::WrapRdnsStroka(const TString& str) {
    TString res = "";
    ui32 needsize = 50;
    int a1 = 0, a2 = 0;
    int count = 0;

    if (str.length() > needsize) {
        a1 = str.length() / needsize;
        a2 = str.length() % needsize;
        if (a2 > 0)
            a1++;

        for (int i = 0; i < a1; i++) {
            count = str.length() - (i * needsize);
            if (count > needsize)
                count = needsize;
            res += str.substr(i * needsize, count) + "<br>";
        }

    } else {
        res = str;
    }

    return res;
}

void TMakeRequest::PrintMemStatOld(const TString& id, TReqParams* m_ReqParams) {
    TReqParams::iterator par_it;

    if (m_ReqParams != NULL) {
        bool pr_ok = false;
        TString text = "";
        int sorttype = 0;
        TReqParams::iterator par_it;
        TMemList memlist;
        bool enableexlude = false;
        bool exludeforwards = false;
        bool excludebanip = false;
        time_t t = time(NULL);
        ui32 mincount = 0;
        ui32 maxlastsec = 0;
        TString mpss = "";
        bool less = 0;
        ui32 maxcountrecord = 0;
        ui32 maxcountham = 0;
        ui32 recordcount = 0;
        bool markbanip = false;
        bool markbanipitem = false;
        TString sortbyiplink = "";
        TString sortbyspamlink = "";
        TString sortbyhamlink = "";
        TString sortbymaliclink = "";
        TString sortbyallmaillink = "";
        TString sortbyhostlink = "";
        TString sortbympslink = "";
        TString herelink = "";
        TString srt2[7];
        TString typeip[3];
        TString whtip[3];
        TString excludehost_checked = "";
        TString excludeforward_checked = "";
        TString markbanip_checked = "";
        TString excludebanip_checked = "";
        bool frwd_pr1 = false;
        TIpType iptype = IPAll;
        TWhtIp ipwht = WHTALL;
        ui32 bantime_default = TBanIPListItem::MAX_BAN_HOURS;
        ui32 long_bantime_default = TBanIPListItem::MAX_BAN_HOURS_LONG;
        TLocalCacheStat storinfo;
        bool needstor = false;
        bool storsubmit = false;
        bool localsubmit = false;
        TString find_ip_source = "";
        TString find_address = "";
        TNetKIPv6 addr_list = TNetKIPv6("FINDIP");
        ui32 heavy_mem_count = 0;
        ui32 traccert[10];
        TString trace_s = "";

        memset(&traccert, 0, sizeof(traccert));

        traccert[0] = CShingleTime::GetMs();

        traccert[1] = CShingleTime::GetMs();
        if ((GetStatIPObject() != NULL) && (GetStatIPObject()->GetBasesStore() != NULL))
            GetStatIPObject()->GetBasesStore()->GetSetupBanTime(bantime_default, long_bantime_default);
        traccert[1] = CShingleTime::GetMs() - traccert[1];

        par_it = m_ReqParams->find("sorttype");
        if (par_it != m_ReqParams->end())
            sorttype = atoi(par_it->second[0].c_str());

        par_it = m_ReqParams->find("enableexlude");
        if (par_it != m_ReqParams->end())
            enableexlude = atoi(par_it->second[0].c_str());

        par_it = m_ReqParams->find("exludeforward");
        if (par_it != m_ReqParams->end())
            exludeforwards = atoi(par_it->second[0].c_str());

        par_it = m_ReqParams->find("mincount");
        if (par_it != m_ReqParams->end())
            mincount = atoi(par_it->second[0].c_str());

        par_it = m_ReqParams->find("maxlastsec");
        if (par_it != m_ReqParams->end())
            maxlastsec = atoi(par_it->second[0].c_str());

        par_it = m_ReqParams->find("maxrecords");
        if (par_it != m_ReqParams->end())
            maxcountrecord = atoi(par_it->second[0].c_str());

        par_it = m_ReqParams->find("maxcntham");
        if (par_it != m_ReqParams->end())
            maxcountham = atoi(par_it->second[0].c_str());

        par_it = m_ReqParams->find("markbanip");
        if (par_it != m_ReqParams->end())
            markbanip = atoi(par_it->second[0].c_str());

        par_it = m_ReqParams->find("excludebanip");
        if (par_it != m_ReqParams->end())
            excludebanip = atoi(par_it->second[0].c_str());

        par_it = m_ReqParams->find("typeip");
        if (par_it != m_ReqParams->end())
            iptype = (TIpType)atoi(par_it->second[0].c_str());

        par_it = m_ReqParams->find("whtip");
        if (par_it != m_ReqParams->end())
            ipwht = (TWhtIp)atoi(par_it->second[0].c_str());

        par_it = m_ReqParams->find("needstor");
        if (par_it != m_ReqParams->end())
            needstor = (bool)atoi(par_it->second[0].c_str());

        par_it = m_ReqParams->find("storsubmit");
        if (par_it != m_ReqParams->end()) {
            storsubmit = true;
            needstor = true;
        }

        par_it = m_ReqParams->find("localsubmit");
        if (par_it != m_ReqParams->end()) {
            localsubmit = true;
            needstor = false;
        }

        par_it = m_ReqParams->find("find_address");
        if (par_it != m_ReqParams->end()) {
            find_ip_source = Trim(par_it->second[0].c_str());
            find_address = FormListIP(find_ip_source);
            addr_list.Init("", NULL);
            addr_list.ReloadMemList(find_address);
        }

        for (int i = 0; i < 7; i++) {
            if (i == sorttype)
                srt2[i] = "CHECKED";
            else
                srt2[i] = "";
        }

        for (int i = 0; i < 3; i++) {
            if (i == iptype)
                typeip[i] = "CHECKED";
            else
                typeip[i] = "";
        }

        for (int i = 0; i < 3; i++) {
            if (i == ipwht)
                whtip[i] = "CHECKED";
            else
                whtip[i] = "";
        }

        if (enableexlude > 0)
            excludehost_checked = "CHECKED";

        if (exludeforwards > 0)
            excludeforward_checked = "CHECKED";

        if (markbanip > 0)
            markbanip_checked = "CHECKED";

        if (excludebanip > 0)
            excludebanip_checked = "CHECKED";

        traccert[2] = CShingleTime::GetMs();
        pr_ok = GetStatIPObject()->GetBasesStore()->GetMemBasa()->GetHeavyMemStat(sorttype, memlist, enableexlude, mincount, maxlastsec, false, exludeforwards, maxcountrecord, iptype, ipwht, storinfo, needstor, traccert[3]);
        traccert[2] = CShingleTime::GetMs() - traccert[2];

        herelink = "<A href='" + GetHost() + GetModuleName("printmemstat") + "?" + GetActionMultiParam("printmemstat") + "sorttype=" + IntToStroka(sorttype) + "&enableexlude=" + IntToStroka(enableexlude) + "&exludeforward=" + IntToStroka(exludeforwards) + "&mincount=" + IntToStroka(mincount) + "&maxlastsec=" + IntToStroka(maxlastsec) + "&less=" + BoolToStroka(less) + "&maxrecords=" + IntToStroka(maxcountrecord) + "&markbanip=" + IntToStroka(markbanip) + "&excludebanip=" + IntToStroka(excludebanip) + "'>here link</A>";

        //heavy_mem_count = GetStatIPObject()->GetHeavyMemCount();
        heavy_mem_count = storinfo.m_count;

        TString sstatform = "";
        sstatform = sstatform + "<form action='" + GetHost() + GetModuleName("printmemstat") + "' method='GET' enctype='text/plain'>";
        sstatform = sstatform + "<table border='0' width='100%' cellspacing='0' cellpadding='7' bgcolor=lemonchiffon>";
        sstatform = sstatform + "<tr align='center'><td width='10%' align='left'>Heavy host count: &nbsp;" + IntToStroka(heavy_mem_count) + "</td><td width='60%'><b>Sort by:</b> <input type='radio' size='10' name='sorttype' value='6' " + srt2[6] + "> ip, &nbsp; <input type='radio' size='10' name='sorttype' value='0'" + srt2[0] + "> spam, &nbsp; <input type='radio' size='10' name='sorttype' value='1'" + srt2[1] + ">ham, &nbsp; <input type='radio' size='10' name='sorttype' value='2'" + srt2[2] + ">malic, &nbsp; <input type='radio' size='10' name='sorttype' value='3'" + srt2[3] + ">all mail, &nbsp; <input type='radio' size='10' name='sorttype' value='4'" + srt2[4] + ">host, &nbsp; <input type='radio' size='10' name='sorttype' value='5'" + srt2[5] + ">mps &nbsp; <br> <b>View ip:</b> <input type='radio' size='10' name='typeip' value='0' " + typeip[0] + "> all, &nbsp; <input type='radio' size='10' name='typeip' value='1'" + typeip[1] + "> ipv4, &nbsp; <input type='radio' size='10' name='typeip' value='2'" + typeip[2] + "> ipv6; &nbsp;<b>White ip:</b> <input type='radio' size='10' name='whtip' value='0' " + whtip[0] + "> all, &nbsp; <input type='radio' size='10' name='whtip' value='1'" + whtip[1] + "> yes, &nbsp; <input type='radio' size='10' name='whtip' value='2'" + whtip[2] + "> no &nbsp;</td><td width='20%' rowspan='2'>IP filter:<br><textarea rows='5' cols='50' name='find_address' wrap='off'>" + find_address + "</textarea></td></tr>";
        sstatform = sstatform + "<tr align='center'><td width='10%' rowspan='2' align='left'>" + storinfo.GetData(TMemBaseSection::LOCAL_CACHE_PERIOD_SEC) + "</td><td width='60%'><input type='checkbox' size='10' name='enableexlude' value='1' " + excludehost_checked + ">exclude hosts &nbsp; <input type='checkbox' size='10' name='exludeforward' value='1' " + excludeforward_checked + ">exclude forwards (>1000 mail) &nbsp; <input type='checkbox' size='10' name='markbanip' value='1' " + markbanip_checked + ">mark ban ip &nbsp; &amp; &nbsp; <input type='checkbox' size='10' name='excludebanip' value='1' " + excludebanip_checked + ">exclude ban ip</td></tr>";
        sstatform = sstatform + "<tr align='center'><td width='60%'>min count mails <input type='text' size='5' name='mincount' value='" + IntToStroka(mincount) + "'>, &nbsp; was mail for last sec <input type='text' size='5' name='maxlastsec' value='" + IntToStroka(maxlastsec) + "'>, &nbsp; max count ham <input type='text' size='5' name='maxcntham' value='" + IntToStroka(maxcountham) + "'>, &nbsp; max count records <input type='text' size='5' name='maxrecords' value='" + IntToStroka(maxcountrecord) + "'></td><td width='20%'>" + GetActionFormParam("printmemstat") + "<input type='hidden' size='10' name='needstor' value='0'><input type='submit' name='localsubmit' color='green' size='10' value='print from local cache' class='focus_button'> &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; <input type='submit' name='storsubmit' size='10' value='print storage'></td></tr>";
        sstatform = sstatform + "</table>";
        sstatform = sstatform + "</form>";

        sortbyiplink = "<A href='" + GetHost() + GetModuleName("printmemstat") + "?" + GetActionMultiParam("printmemstat") + "sorttype=6&enableexlude=" + IntToStroka(enableexlude) + "&exludeforward=" + IntToStroka(exludeforwards) + "&mincount=" + IntToStroka(mincount) + "&maxlastsec=" + IntToStroka(maxlastsec) + "&less=" + BoolToStroka(less) + "&maxcntham=" + IntToStroka(maxcountham) + "&maxrecords=" + IntToStroka(maxcountrecord) + "&markbanip=" + IntToStroka(markbanip) + "&excludebanip=" + IntToStroka(excludebanip) + "'>IP</A>";
        sortbyspamlink = "<A href='" + GetHost() + GetModuleName("printmemstat") + "?" + GetActionMultiParam("printmemstat") + "sorttype=0&enableexlude=" + IntToStroka(enableexlude) + "&exludeforward=" + IntToStroka(exludeforwards) + "&mincount=" + IntToStroka(mincount) + "&maxlastsec=" + IntToStroka(maxlastsec) + "&less=" + BoolToStroka(less) + "&maxcntham=" + IntToStroka(maxcountham) + "&maxrecords=" + IntToStroka(maxcountrecord) + "&markbanip=" + IntToStroka(markbanip) + "&excludebanip=" + IntToStroka(excludebanip) + "'>SPAM (today)</A>";
        sortbyhamlink = "<A href='" + GetHost() + GetModuleName("printmemstat") + "?" + GetActionMultiParam("printmemstat") + "sorttype=1&enableexlude=" + IntToStroka(enableexlude) + "&exludeforward=" + IntToStroka(exludeforwards) + "&mincount=" + IntToStroka(mincount) + "&maxlastsec=" + IntToStroka(maxlastsec) + "&less=" + BoolToStroka(less) + "&maxcntham=" + IntToStroka(maxcountham) + "&maxrecords=" + IntToStroka(maxcountrecord) + "&markbanip=" + IntToStroka(markbanip) + "&excludebanip=" + IntToStroka(excludebanip) + "'>HAM (today)</A>";
        sortbymaliclink = "<A href='" + GetHost() + GetModuleName("printmemstat") + "?" + GetActionMultiParam("printmemstat") + "sorttype=2&enableexlude=" + IntToStroka(enableexlude) + "&exludeforward=" + IntToStroka(exludeforwards) + "&mincount=" + IntToStroka(mincount) + "&maxlastsec=" + IntToStroka(maxlastsec) + "&less=" + BoolToStroka(less) + "&maxcntham=" + IntToStroka(maxcountham) + "&maxrecords=" + IntToStroka(maxcountrecord) + "&markbanip=" + IntToStroka(markbanip) + "&excludebanip=" + IntToStroka(excludebanip) + "'>MALIC (today)</A>";
        sortbyallmaillink = "<A href='" + GetHost() + GetModuleName("printmemstat") + "?" + GetActionMultiParam("printmemstat") + "sorttype=3&enableexlude=" + IntToStroka(enableexlude) + "&exludeforward=" + IntToStroka(exludeforwards) + "&mincount=" + IntToStroka(mincount) + "&maxlastsec=" + IntToStroka(maxlastsec) + "&less=" + BoolToStroka(less) + "&maxcntham=" + IntToStroka(maxcountham) + "&maxrecords=" + IntToStroka(maxcountrecord) + "&markbanip=" + IntToStroka(markbanip) + "&excludebanip=" + IntToStroka(excludebanip) + "'></A>";
        sortbyhostlink = "<A href='" + GetHost() + GetModuleName("printmemstat") + "?" + GetActionMultiParam("printmemstat") + "sorttype=4&enableexlude=" + IntToStroka(enableexlude) + "&exludeforward=" + IntToStroka(exludeforwards) + "&mincount=" + IntToStroka(mincount) + "&maxlastsec=" + IntToStroka(maxlastsec) + "&less=" + BoolToStroka(less) + "&maxcntham=" + IntToStroka(maxcountham) + "&maxrecords=" + IntToStroka(maxcountrecord) + "&markbanip=" + IntToStroka(markbanip) + "&excludebanip=" + IntToStroka(excludebanip) + "'>HOST</A>";
        sortbympslink = "<A href='" + GetHost() + GetModuleName("printmemstat") + "?" + GetActionMultiParam("printmemstat") + "sorttype=5&enableexlude=" + IntToStroka(enableexlude) + "&exludeforward=" + IntToStroka(exludeforwards) + "&mincount=" + IntToStroka(mincount) + "&maxlastsec=" + IntToStroka(maxlastsec) + "&less=" + BoolToStroka(less) + "&maxcntham=" + IntToStroka(maxcountham) + "&maxrecords=" + IntToStroka(maxcountrecord) + "&markbanip=" + IntToStroka(markbanip) + "&excludebanip=" + IntToStroka(excludebanip) + "'>MPS</A>";

        if (pr_ok) {
            TString srt[7];

            for (int i = 0; i < 7; i++) {
                if (i == sorttype)
                    srt[i] = "*";
                else
                    srt[i] = "";
            }

            if (sorttype == 3) {
                srt[0] = "*";
                srt[1] = "*";
            }

            text = "";

            TString bandefwin = "<A href='" + GetHost() + GetModuleName("bandefwin") + GetActionOneParam("bandefwin") + "' target='_blank'>ban_defaults</A>";
            TString bangroupshap = "<table border='0' width='100%' cellspacing='0' cellpadding='4'>";
            bangroupshap = bangroupshap + "<tr><td width='50%' align='left'>Ban group addresses (<" + IntToStroka(TBanIPListItem::MAX_BAN_HOURS_LONG) + " hours): &nbsp;<input type='text' size='10' name='bantime' value='" + IntToStroka(long_bantime_default) + "'>&nbsp;<input type='checkbox' size='10' name='intbi'>internal &nbsp;" + GetActionFormParam("askaddblackig") + "<input type='submit' size='30' value='Ban group'></td><td width='50%' align='right'>" + bandefwin + " &nbsp; </td></tr>";
            bangroupshap = bangroupshap + "</table>";

            text += "<style>";
            text += ".focus_button {";
            text += "width:150px;height:25px;";
            text += "border:1px solid grey;";
            text += "background:linear-gradient(rgb(177,249,83) 30%,rgb(177,249,83) 50%,rgb(177,249,83) 70%);";
            text += "background:-ms-linear-gradient(rgb(177,249,83) 30%,rgb(177,249,83) 50%,rgb(177,249,83) 70%);";
            text += "background:-o-linear-gradient(rgb(177,249,83) 30%,rgb(177,249,83) 50%,rgb(177,249,83) 70%);";
            text += "background:-moz-linear-gradient(rgb(177,249,83) 30%,rgb(177,249,83) 50%,rgb(177,249,83) 70%);";
            text += "background:-webkit-linear-gradient(rgb(177,249,83) 30%,rgb(177,249,83) 50%,rgb(177,249,83) 70%);";
            text += "border-radius:5px;";
            text += "text-align:center;";
            text += "display:table-cell;";
            text += "vertical-align:middle;";
            text += "font:normal 0.9em arial;";
            text += "color:#333;";
            text += "}";
            text += "</style>";

            text += "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=lemonchiffon>\n";
            text += "<tr><td colspan='9'>" + sstatform + "</td></tr>";
            //text += "<form action='" + GetHost() + GetModuleName("askaddblackig") + "' method='GET' enctype='text/plain' target='_black'>";
            text += "<form action='" + GetHost() + GetModuleName("askaddblackig") + "' method='POST' enctype='application/x-www-form-urlencoded' target='_black'>";
            text += "<tr><td colspan='9'>" + bangroupshap + "</td></tr>"; //text += "<tr><td colspan='9'>Ban group addresses (<" + IntToStroka(TBanIPListItem::MAX_BAN_HOURS) + " hours): &nbsp;<input type='text' size='10' name='bantime' value='" + IntToStroka(bantime_default) + "'>&nbsp;<input type='checkbox' size='10' name='intbi'>internal &nbsp;" + GetActionFormParam("askaddblackig") + "<input type='submit' size='30' value='Ban group'></td></tr>\n";
            text += "<tr bgcolor='" + TString(BGSHAPCOLOR) + "'>";
            text += "<td width = '2%' align='center'>&nbsp;</td>";
            text += "<td width = '8%' align='center'><i><b>" + srt[6] + sortbyiplink + "</b></i></td>";
            text += "<td width = '17%' align='center'><i><b>" + srt[1] + sortbyhamlink + "</b></i></td>";
            text += "<td width = '17%' align='center'><i><b>" + srt[0] + sortbyspamlink + "</b></i></td>";
            text += "<td width = '17%' align='center'><i><b>" + srt[2] + sortbymaliclink + "</b></i></td>";
            text += "<td width = '9%' align='center'><i><b>LASTUPD</b><br>catch mail</i></td>";
            text += "<td width = '4%' align='center'><i><b>DURAT</b></i></td>";
            text += "<td width = '4%' align='center'><i><b>" + srt[5] + sortbympslink + "</b></i></td>";
            text += "<td width = '22%' align='center'><i><b>" + srt[4] + sortbyhostlink + "</b></i></td>";
            text += "</tr>\n";

            TMemListRIt rmit;
            TString sip;
            TString rdns = "";
            TString lastreg = "";
            TString lastfix = "";
            TString catchrequest = "";
            TString inforequest = "";
            TString summrequest = "";
            TString s = "";
            int ip_counter = 0;
            char* tbuffb = NULL;
            int in_tbuff = 0;
            int fullsize_tbuff = 0;
            TString pcmb_s = "";
            ui32 pcmb_count = 0;
            ui32 need_set_check = 0;
            TString debug_checked = "";

            fullsize_tbuff = text.length() + (1024 * memlist.size()) + 1;
            if (fullsize_tbuff <= 0)
                fullsize_tbuff = 1024;
            tbuffb = new char[fullsize_tbuff];
            if (tbuffb != NULL) {
                try {
                    tbuffb[0] = 0x00;
                    tbuffb[fullsize_tbuff - 1] = 0x00;
                    if (text.length() > 0) {
                        if (text.length() < (fullsize_tbuff - in_tbuff)) {
                            memcpy(tbuffb + in_tbuff, text.c_str(), text.length());
                            in_tbuff += text.length();
                        }
                    }

                    traccert[4] = CShingleTime::GetMs();
                    rmit = memlist.rbegin();
                    while (rmit != memlist.rend()) {
                        //if ((*rmit).white_pr

                        if ((*rmit).pcmb > 0) {
                            pcmb_count = IncMax32(pcmb_count, 1);
                            ++rmit;
                            continue;
                        }

                        markbanipitem = false;
                        if (markbanip || excludebanip) {
                            markbanipitem = GetStatIPObject()->IsBanIpForMark((*rmit).ip);
                        }

                        if (excludebanip && markbanipitem) {
                            ++rmit;
                            continue;
                        }

                        if (!find_address.empty()) {
                            if (!addr_list.IsInNet((*rmit).ip)) {
                                ++rmit;
                                continue;
                            }
                        }

                        if ((maxcountham > 0) && ((*rmit).ctHam >= maxcountham)) {
                            ++rmit;
                            continue;
                        }

                        sip = (*rmit).ip.toStroka();
                        lastreg = "<A href='" + GetHost() + GetModuleName("catchip") + GetActionOneParam("catchip") + "&ip=" + sip + "&delay=" + IntToStroka(GetStatIPObject()->GetBasesStore()->GetCatchDelay()) + "' target='_blank'>" + TimeToStr2((*rmit).last_update) + "(" + IntToHourMinSec2(t - (*rmit).last_update) + ")</A>";
                        lastfix = IntToHourMinSec2(t - (*rmit).last_fix);
                        mpss = FloatToStr((*rmit).cps);
                        catchrequest = "<A href='" + GetHost() + GetModuleName("catchip") + "?" + GetActionMultiParam("catchip") + "ip=" + sip + "&delay=" + IntToStroka(GetStatIPObject()->GetBasesStore()->GetCatchDelay()) + "' target='_blank'>catch mail</A>";
                        inforequest = "<A href='" + GetHost() + GetModuleName("viewipstat") + GetActionOneParam("viewipstat") + "&ip=" + sip + "' target='_blank'>" + TString(sip) + "</A>";
                        summrequest = ""; //"<br>" + catchrequest;

                        s = "<tr align='left'>";
                        if ((*rmit).pcmb > 0)
                            pcmb_s = "<b><font color='red'>PCMB#" + IntToStroka((*rmit).pcmb) + "</font></b> &nbsp; ";
                        else
                            pcmb_s = "";

                        //!!!DEBUG!!!
                        //                     need_set_check = IncMax32(need_set_check, 1);
                        //                     if ( ((need_set_check % 2) > 0) && (need_set_check < 650) )
                        //                        debug_checked = " CHECKED";
                        //                     else
                        debug_checked = "";

                        s = s + "<td><input type='checkbox' size='2' name='ip" + IntToStroka3(ip_counter) + "' value='" + TString(sip) + "' " + debug_checked + "></td>";
                        if (markbanipitem)
                            s = s + "<td bgcolor='LightPink'>" + inforequest + summrequest + "</td>";
                        else {
                            frwd_pr1 = (*rmit).frwd_pr1;
                            if (frwd_pr1)
                                s = s + "<td bgcolor='GreenYellow'>" + inforequest + summrequest + "</td>";
                            else
                                s = s + "<td>" + inforequest + summrequest + "</td>";
                        }
                        s = s + "<td>" + IntToStroka((*rmit).ctHam) + " (" + IntToStroka((*rmit).ctHam_today) + ")</td>";
                        s = s + "<td>" + IntToStroka((*rmit).ctSpam) + " (" + IntToStroka((*rmit).ctSpam_today) + ")</td>";
                        s = s + "<td>" + IntToStroka((*rmit).ctMalicSpam) + " (" + IntToStroka((*rmit).ctMalicSpam_today) + ")</td>";
                        s = s + "<td>" + lastreg + "</td>";
                        s = s + "<td>" + lastfix + "</td>";
                        s = s + "<td>" + mpss + "</td>";
                        s = s + "<td>" + pcmb_s + WrapRdnsStroka((*rmit).rdns_isx) + "</td>";
                        s = s + "</tr>\n";
                        if (s.length() > 0) {
                            if (s.length() < (fullsize_tbuff - in_tbuff)) {
                                memcpy(tbuffb + in_tbuff, s.c_str(), s.length());
                                in_tbuff += s.length();
                            }
                        }

                        recordcount++;
                        if ((maxcountrecord != 0) && (recordcount >= maxcountrecord))
                            break;

                        ip_counter++;
                        ++rmit;
                    }

                    traccert[4] = CShingleTime::GetMs() - traccert[4];

                    traccert[0] = CShingleTime::GetMs() - traccert[0];
                    trace_s = IntToStroka(traccert[0]) + "," + IntToStroka(traccert[1]) + "-" + IntToStroka(traccert[2]) + "-" + IntToStroka(traccert[3]) + "-" + IntToStroka(traccert[4]);
                    text = "";
                    text += "<tr align='left'><td colspan='2'>" + IntToStroka(recordcount) + " records is found.</td><td colspan='2'>trace: " + trace_s + "</td><td colspan='5'>docsize: " + IntToStrokaNum(in_tbuff + 200) + " byte, pcmb_cnt: " + IntToStroka(pcmb_count) + "</td></tr>\n";
                    text += "</table>\n";
                    text += "</form>";
                    if (text.length() > 0) {
                        if (text.length() < (fullsize_tbuff - in_tbuff)) {
                            memcpy(tbuffb + in_tbuff, text.c_str(), text.length());
                            in_tbuff += text.length();
                        }
                    }
                    text = TString(tbuffb, in_tbuff);

                    delete[] tbuffb;
                    tbuffb = NULL;

                } catch (...) {
                    delete[] tbuffb;
                    tbuffb = NULL;
                }
            }

        } else {
            text = "Print memory statistik failed!";
        }

        memlist.clear();

        SendToClientWithLittleShap(SO_LOG_MESSAGE, 200, text, id);
    } else {
        SendToClientRAW(TString(HTTP_500_INTERNAL_SERVER_ERROR()));
    }
}

void TMakeRequest::PutSender(const TString& id, TReqParams* m_ReqParams) {
    TString text = "";
    TReqParams::iterator par_it;
    TString data_s = "";
    TString abook_sender = "-21-22-23-24-25-26-27-777";
    TString abook_domen = "-31-32-33-34-35-36-37-888";
    TString abook_psndr = "-41-42-43-44-45-46-47-999";
    //TString               abook_sender = "";
    //TString               abook_domen  = "";
    //TString               abook_psndr  = "";

    par_it = m_ReqParams->find("data");
    if (par_it != m_ReqParams->end())
        data_s = Trim(par_it->second[0]);

    text = text + "<SENDER shingle='fe3eae75499225b4' null='0' body='4852-5324-1799249-8929386-0-2681-17421-15-12904-86725-300" + abook_sender + "' stat='' profile='v01.0.0'>\n";
    text = text + "<DOMAIN shingle='414f2e24d6cf0d1a' null='0' body='4852-5324-1799249-8929386-0-2681-17421-15-12904-86725-300" + abook_domen + "' stat='1:44711,10:397941,11:359,14:3,15:2,2:22314,23:17,28:104408,29:58,3:90122,31:2,4:4909813,5:3859,6:159281,7:1449' profile='v01.0.0'>\n";
    text = text + "<PSNDR shingle='c0f6c785fd11a7d1' null='0' body='4851-5322-1-2-3-4-5-6-7-8-98-99" + abook_psndr + "'>\n";

    //text = text + "<SENDER shingle='fe3eae75499225b4' null='0' body='0-0-1000000000001-1000000000002-1000000000003-1000000000004-1000000000005-12321-1000000000006-1000000000007-1-1000000000008-0-0-0-0-0-0' stat='' profile='v01.0.0'>\n";
    //text = text + "<DOMAIN shingle='414f2e24d6cf0d1a' null='0' body='0-0-2000000000001-2000000000002-2000000000003-2000000000004-2000000000005-12321-2000000000006-2000000000007-1-2000000000008-0-0-0-0-0-0' stat='' profile='v01.0.0'>\n";
    //text = text + "<PSNDR shingle='c0f6c785fd11a7d1' null='0' body='5400-5400-3000000000001-3000000000002-3000000000004-3000000000005-9-3000000000006-3000000000007-1-3000000000009-3000000000010-3000000000008-15-0-0-0-11-1' stat='2:4,7:1' profile='v01.0.0'>\n";

    //text = text + "<SENDER shingle='fe3eae75499225b4' null='0' body='4846-5407-23624514-457700-2038-2205-104198-15-1380-398002-534-7771-7772-7773-7774-7775-7776-7777' stat='1:455047,10:1552258,11:26,14:6,2:119826,20:2931137,3:34464,33:8787936,4:194,6:4' profile='v01.0.0'>\n";
    //text = text + "<DOMAIN shingle='414f2e24d6cf0d1a' null='0' body='4846-5407-24679179-486333-9859-2358-116376-15-1446-424125-545-8881-8882-8883-8884-8885-8886-8887' stat='1:465897,10:2245489,11:126,14:6,2:124006,20:2914873,23:1,3:42043,33:9789098,34:55,35:60,4:23282,5:5,6:122' profile='v01.0.0'>\n";

    SendToClientRAW(TString(HTTP_200_OK(id)) + text);
}

void TMakeRequest::AskSaveDumpStorage(const TString& id, TReqParams* m_ReqParams) {
    TString text = "";

    text = text + HTTP_200_OK(id);
    text = text + "<SCRIPT LANGUAGE='Javascript'>\n";
    text = text + "if(true == confirm('Save dump to files?')) {\n";
    text = text + "document.location = '";
    text = text + GetHost() + GetModuleName("dosavedumpbd") + GetActionOneParam("dosavedumpbd") + "'\n";
    text = text + "} else {\n";
    text = text + "document.location = '";
    text = text + GetHost() + GetModuleName("console") + GetActionOneParam("console") + "'}\n";
    text = text + "</SCRIPT>\n";

    SendToClientRAW(text);
}

void TMakeRequest::SaveDumpStorage(const TString& id, TReqParams* m_ReqParams) {
    TString text = "";

    if (GetGeneralObject() != NULL) {
        text = GetGeneralObject()->SaveDumpStorage();

        SendToClientWithShap(SO_LOG_MESSAGE, 200, text, id);

    } else {
        SendToClientWithShap(SO_LOG_ERROR, 501, text, "-");
    }
}

void TMakeRequest::AskSaveDumpStorageStep1(const TString& id, TReqParams* m_ReqParams) {
    TString text = "";

    text = text + HTTP_200_OK(id);
    text = text + "<SCRIPT LANGUAGE='Javascript'>\n";
    text = text + "if(true == confirm('Save dump to files (step1)?')) {\n";
    text = text + "document.location = '";
    text = text + GetHost() + GetModuleName("dosavedumpb1s") + GetActionOneParam("dosavedumpb1s") + "'\n";
    text = text + "} else {\n";
    text = text + "document.location = '";
    text = text + GetHost() + GetModuleName("console") + GetActionOneParam("console") + "'}\n";
    text = text + "</SCRIPT>\n";

    SendToClientRAW(text);
}

void TMakeRequest::SaveDumpStorageStep1(const TString& id, TReqParams* m_ReqParams) {
    TString text = "";

    if (GetGeneralObject() != NULL) {
        text = GetGeneralObject()->SaveDumpStorageStep1();

        SendToClientWithShap(SO_LOG_MESSAGE, 200, text, id);

    } else {
        SendToClientWithShap(SO_LOG_ERROR, 501, text, "-");
    }
}

void TMakeRequest::AskSaveDumpStorageOnlyBanList(const TString& id, TReqParams* m_ReqParams) {
    TString text = "";

    text = text + HTTP_200_OK(id);
    text = text + "<SCRIPT LANGUAGE='Javascript'>\n";
    text = text + "if(true == confirm('Save dump to files (only ban lists)?')) {\n";
    text = text + "document.location = '";
    text = text + GetHost() + GetModuleName("dosavedumpobl") + GetActionOneParam("dosavedumpobl") + "'\n";
    text = text + "} else {\n";
    text = text + "document.location = '";
    text = text + GetHost() + GetModuleName("console") + GetActionOneParam("console") + "'}\n";
    text = text + "</SCRIPT>\n";

    SendToClientRAW(text);
}

void TMakeRequest::SaveDumpStorageOnlyBanList(const TString& id, TReqParams* m_ReqParams) {
    TString text = "";

    if (GetGeneralObject() != NULL) {
        text = GetGeneralObject()->SaveDumpStorageOnlyBanList();

        SendToClientWithShap(SO_LOG_MESSAGE, 200, text, id);

    } else {
        SendToClientWithShap(SO_LOG_ERROR, 501, text, "-");
    }
}

void TMakeRequest::AskTopStorage(const TString& id, TReqParams* m_ReqParams) {
    TString text = "";

    text = text + HTTP_200_OK(id);
    text = text + "<SCRIPT LANGUAGE='Javascript'>\n";
    text = text + "if(true == confirm('Save top list to files?')) {\n";
    text = text + "document.location = '";
    text = text + GetHost() + GetModuleName("dosavetopbd") + GetActionOneParam("dosavetopbd") + "'\n";
    text = text + "} else {\n";
    text = text + "document.location = '";
    text = text + GetHost() + GetModuleName("console") + GetActionOneParam("console") + "'}\n";
    text = text + "</SCRIPT>\n";

    SendToClientRAW(text);
}

void TMakeRequest::SaveTopStorage(const TString& id, TReqParams* m_ReqParams) {
    TString text = "";

    if (GetGeneralObject() != NULL) {
        text = GetGeneralObject()->SaveTopStorage(false);

        SendToClientWithShap(SO_LOG_MESSAGE, 200, text, id);

    } else {
        SendToClientWithShap(SO_LOG_ERROR, 501, text, "-");
    }
}

void TMakeRequest::SaveIPDataFromStorage(const TString& id, TReqParams* m_ReqParams) {
    TReqParams::iterator par_it;

    if ((m_ReqParams != NULL) && (GetGeneralObject() != NULL)) {
        bool pr_ok = false;
        TString text = "";
        TKIPv6 ip = TKIPv6();
        TString ips = "";

        par_it = m_ReqParams->find("ip");
        if (par_it != m_ReqParams->end()) {
            ips = Trim(par_it->second[0]);
            ip = TKIPv6(ips.c_str());
            if (!ip.Undefined()) {
                text += GetGeneralObject()->SaveIPDataFromStorage(ip);

                SendToClientWithShap(SO_LOG_MESSAGE, 200, text, id);

            } else {
                SendToClientWithShap(SO_LOG_ERROR, 400, "ip undefined.", id);
            }

        } else {
            SendToClientWithShap(SO_LOG_ERROR, 400, "not 'ip' parametr.", id);
        }

    } else {
        SendToClientWithShap(SO_LOG_ERROR, 500, "", id);
    }
}

void TMakeRequest::ViewStorageStatistik(const TString& id, TReqParams* m_ReqParams) {
    TString text = "";
    TString db = "";

    if (GetConfigObject() != NULL)
        db = GetConfigObject()->ReadStroka("nosql", "db", "statip");

    if ((GetStatIPObject() != NULL) && (GetStatIPObject()->GetBasesStore() != NULL)) {
        TVector<TString> orderlist;

        orderlist.push_back(db + "::banobj");
        orderlist.push_back(db + "::membase");
        orderlist.push_back(db + "::memstat");
        if (GetStatIPObject()->GetStorage() != NULL)
            text += GetStatIPObject()->GetStorage()->GetWebStat().PrintDataWEBInOrder(orderlist, false, false, false);

        SendToClientWithShap(SO_LOG_MESSAGE, 200, text, id);

    } else {
        SendToClientWithShap(SO_LOG_ERROR, 500, text, id);
    }
}

void TMakeRequest::InputRequestStatistik(const TString& id, TReqParams* m_ReqParams) {
    TString text = "";

    if (GetStatIPObject() != NULL) {
        TVector<TString> orderlist;

        orderlist.push_back("IN::CHECS");
        orderlist.push_back("IN::GETFORFRODO");
        orderlist.push_back("IN::GETFORFROD2");
        orderlist.push_back("IN::CHECK");
        orderlist.push_back("IN::GETIPSTATUS");
        if (GetStatIPObject()->GetStorage() != NULL)
            text += GetStatIPObject()->GetInputRequestStat().PrintDataWEBInOrderShort(orderlist, false, true, true);

        if (text.empty())
            text = text + "statistics are not available (empty data).";

        SendToClientWithShap(SO_LOG_MESSAGE, 200, text, id);

    } else {
        SendToClientWithShap(SO_LOG_ERROR, 500, text, id);
    }
}

void TMakeRequest::AskReaddump(const TString& id) {
    TString text = "";

    text = text + HTTP_200_OK(id);
    text = text + "<SCRIPT LANGUAGE='Javascript'>\n";
    text = text + "if(true == confirm('Read dump from files?')) {\n";
    text = text + "document.location = '";
    text = text + GetHost() + GetModuleName("doreadmdump") + GetActionOneParam("doreadmdump") + "'\n";
    text = text + "} else {\n";
    text = text + "document.location = '";
    text = text + GetHost() + GetModuleName("console") + GetActionOneParam("console") + "'}\n";
    text = text + "</SCRIPT>\n";

    SendToClientRAW(text);
}

void TMakeRequest::DoReaddump(const TString& id) {
    TString text = "";

    if (GetGeneralObject() != NULL) {
        text = GetGeneralObject()->DoReaddump();

        SendToClientWithShap(SO_LOG_MESSAGE, 200, text, id);

    } else {
        SendToClientWithShap(SO_LOG_ERROR, 501, text, "-");
    }
}

void TMakeRequest::AddFollowIp(const TString& id, TReqParams* m_ReqParams) {
    TReqParams::iterator par_it;
    TString ips = "";
    TKIPv6 ip;
    TString text = "";

    if (GetStatIPObject() != NULL) {
        par_it = m_ReqParams->find("ip");
        if (par_it != m_ReqParams->end()) {
            ips = Trim(par_it->second[0]);
            CGIUnescape(ips);

            if (!ips.empty()) {
                ip = TKIPv6(ips.c_str());
                if (!ip.Undefined()) {
                    GetStatIPObject()->AddFollowIP(ip);

                    TString viewfollowiplist_link = " &nbsp; <A href='" + GetHost() + GetModuleName("viewfollowiplist") + GetActionOneParam("viewfollowiplist") + "'>view follow ip list</A>&nbsp;&nbsp;";

                    text = "Follow ip " + ip.toStroka() + " added succesfully! " + viewfollowiplist_link;

                    SendToClientWithShap(SO_LOG_MESSAGE, 200, text, id);

                } else {
                    SendToClientWithShap(SO_LOG_ERROR, 400, "bad request ('ip' params not defined)", "-");
                }

            } else {
                SendToClientWithShap(SO_LOG_ERROR, 400, "bad request ('ip' params empty)", "-");
            }

        } else {
            SendToClientWithShap(SO_LOG_ERROR, 400, "bad request (not find 'ip' params)", "-");
        }

    } else {
        SendToClientWithShap(SO_LOG_ERROR, 501, text, "-");
    }
}

void TMakeRequest::DelFollowIp(const TString& id, TReqParams* m_ReqParams) {
    TReqParams::iterator par_it;
    TString ips = "";
    TKIPv6 ip;
    TString text = "";

    if (GetStatIPObject() != NULL) {
        par_it = m_ReqParams->find("ip");
        if (par_it != m_ReqParams->end()) {
            ips = Trim(par_it->second[0]);
            CGIUnescape(ips);

            if (!ips.empty()) {
                ip = TKIPv6(ips.c_str());
                if (!ip.Undefined()) {
                    TString viewfollowiplist_link = " &nbsp; <A href='" + GetHost() + GetModuleName("viewfollowiplist") + GetActionOneParam("viewfollowiplist") + "'>view follow ip list</A>&nbsp;&nbsp;";

                    if (GetStatIPObject()->DeleteFollowIP(ip))
                        text = "Follow ip " + ip.toStroka() + " delete succesfully! " + viewfollowiplist_link;
                    else
                        text = "Follow ip " + ip.toStroka() + " delete FAILED! " + viewfollowiplist_link;

                    SendToClientWithShap(SO_LOG_MESSAGE, 200, text, id);

                } else {
                    SendToClientWithShap(SO_LOG_ERROR, 400, "bad request ('ip' params not defined)", "-");
                }

            } else {
                SendToClientWithShap(SO_LOG_ERROR, 400, "bad request ('ip' params empty)", "-");
            }

        } else {
            SendToClientWithShap(SO_LOG_ERROR, 400, "bad request (not find 'ip' params)", "-");
        }

    } else {
        SendToClientWithShap(SO_LOG_ERROR, 501, text, "-");
    }
}

void TMakeRequest::ViewFollowIpList(const TString& id, TReqParams* m_ReqParams) {
    if (GetStatIPObject() != NULL) {
        THashMap<TKIPv6, ui32> filist;
        THashMap<TKIPv6, ui32>::iterator it;
        char* table_color = "'#ffffcc'";
        char* table_color_shap = "'EBEBA6'";
        TString text = "";
        TString ips = "";

        GetStatIPObject()->ReturnFollowIpsList(filist);

        TString addfollowipform = "<form action='" + GetHost() + GetModuleName("addfollowip") + "' method='GET' enctype='text/plain'>" + GetActionFormParam("addfollowip") + "Add follow ip: &nbsp; <input type='text' name='ip' size='70' value=''> &nbsp; &nbsp; &nbsp;<input type='submit' size='10' value='add ip'></form>&nbsp;";

        text = text + addfollowipform + "<br>";
        text = text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=" + TString(table_color) + ">";
        text = text + "<tr valign='top' align='center' bgcolor=" + table_color_shap + "><td width='30%'><b>IP</b></td><td width='30%'><b>COUNT</b></td><td width='40%'>&nbsp;</td></tr>";
        //text = text + "<tr><td colspan='3' align='center'>" + addfollowipform + "</td></tr>";
        it = filist.begin();
        while (it != filist.end()) {
            ips = (*it).first.toStroka();
            CGIEscape(ips);
            text = text + "<tr align='left' ><td>" + (*it).first.toStroka() + "</td><td>" + UI32ToStroka((*it).second) + "</td><td><A href='" + GetHost() + GetModuleName("delfollowip") + GetActionOneParam("delfollowip") + "&ip=" + ips + "'>delete</A></td></tr>";

            ++it;
        }
        text = text + "</table>";

        SendToClientWithShap(SO_LOG_MESSAGE, 200, text, id);

    } else {
        SendToClientWithShap(SO_LOG_ERROR, 501, "", "-");
    }
}

void TMakeRequest::LastBanTimeNew(const TString& id) {
    if ((GetStatIPObject() != NULL) && (GetStatIPObject()->GetBasesStore() != NULL) && (GetStatIPObject()->GetBasesStore()->GetBanIP() != NULL)) {
        GetStatIPObject()->GetBasesStore()->GetBanIP()->SetLastBanTimeNew();

        SendToClientWithShap(SO_LOG_MESSAGE, 200, "Set lastban time new - OK.", id);

    } else {
        SendToClientWithShap(SO_LOG_ERROR, 501, "", "-");
    }
}

void TMakeRequest::TruncLogs(const TString& id) {
    if (GetLogsGroup() != NULL) {
        TString text = "";

        if (GetLogsGroup()->TruncLog())
            text += "Truncate logs succesfully!";
        else
            text += "Truncate logs FAILED.";

        SendToClientWithShap(SO_LOG_MESSAGE, 200, text, id);

    } else {
        SendToClientWithShap(SO_LOG_ERROR, 501, "", "-");
    }
}
