#pragma once

#include <mail/so/spamstop/tools/fcgiserver_base/tserviceobjectbase.h>
#include <mail/so/spamstop/tools/fcgiserver_base/tmakerequestbase.h>
#include <mail/so/spamstop/tools/so-common/tkconfig.h>
#include "tserviceobject.h"
#include "tlogsgroup.h"
#include "tgeneralobject.h"
#include "tstatipobject.h"
#include "tdumpreadclass.h"

#define LINK_TO_GETBYID "http://spamstat-in.yandex.ru/getbyid.pl?&do=%EF%D4%D0%D2%C1%D7%C9%D4%D8+%DA%C1%D0%D2%CF%D3&cmpf=&id="
#define LINK_TO_GETBYIP "http://spamstat-in.yandex.ru/getbyid.pl?do=%EF%D4%D0%D2%C1%D7%C9%D4%D8+%DA%C1%D0%D2%CF%D3&cmpf=&id=ip:"

#define RET_BUFFER_SIZE_N 16535
#define REQ_BUFFER_SIZE_N 65535

#define BGSHAPCOLOR "Moccasin"

typedef THashMap<TString, int>       TKStrokaHash;
typedef TKStrokaHash::iterator   TKStrokaHashIt;

typedef TVector<TString>          THeaders;
typedef THeaders::iterator       THeadersIt;

typedef THashMap<TString, TString>    TWStrokaHash;
typedef TWStrokaHash::iterator   TWStrokaHashIt;

struct TIPSumData
{
   int      index;
   TKIPv6   ip;
   TString   ip_s;
   TString   ip_link;

   TIPSumData()
   {
      index   = -1;
      ip      = TKIPv6();
      ip_s    = "";
      ip_link = "";
   }

   TIPSumData(TKIPv6 ipA, int indexA, const TString &ip_sA, const TString &ip_linkA)
   {
      index   = indexA;
      ip      = ipA;
      ip_s    = ip_sA;
      ip_link = ip_linkA;
   }

   bool operator<(const TIPSumData &value) const
   {
      return index < value.index;
   }
};

typedef std::list<TIPSumData>    TIPSumDataList;
typedef TIPSumDataList::iterator TIPSumDataListIt;

struct TBanResExt
{
   TBanRes banres;
   ui32    ham;
   ui32    spam;
   ui32    malic;

   TBanResExt()
   {
      ham = 0;
      spam = 0;
      malic = 0;
   }

   TBanResExt(TBanRes banresA, ui32 hamA, ui32 spamA, ui32 malicA)
   {
      banres   = banresA;
      ham      = hamA;
      spam     = spamA;
      malic    = malicA;
   }
};

typedef TVector<TBanResExt>  TBanResList;
typedef TBanResList::iterator    TBanResListIt;

class TMakeRequest: public TMakeRequestBase
{
public:
         static const int  MAX_BAN_IP_COUNT       = 1000;     //����� ��������
private:
         TServiceObject       &GetServiceObject()     { return dynamic_cast<TServiceObject &>(srvcobj);                                                 }
         TLogsGroup           *GetLogsGroup()         { return (TLogsGroup *)srvcobj.GetLogsGroup();          }
         TKConfig             *GetConfigObject()      { return srvcobj.GetConfigObject();                     }
         TGeneralObject       *GetGeneralObject()     { return (TGeneralObject *)srvcobj.GetGeneralObject();  }
         TStatIPObject        *GetStatIPObject()      { return (GetGeneralObject() != NULL) ? GetGeneralObject()->StatIPObject : NULL;    }

         TNetKIPv6            *wnet;

         void  Midnight(const TString &id, TReqParams *m_ReqParams);
         void  Shutdown(const TString &id, TReqParams *m_ReqParams);
         void  Console(const TString &id, TReqParams *m_ReqParams);
         void  ExtConsole(const TString &id, TReqParams *m_ReqParams);

         bool  ActionWOParse(const TString &Ident, TRequestDopData &data, const TString &InRequest, const TString &NumbRequest, const TString &request_source, int thread_index);
         bool  ActionParse(const TString &Ident, TRequestDopData &data, TReqParams *m_ReqParams, const TString &NumbRequest, const TString &requrl, int thread_index);

         void  Check(TReqParams *m_ReqParams, const TString &NumbRequest);
         void  CheckS(TReqParams *m_ReqParams, const TString &id);
         void  GetIPStatus(const TString &id, TReqParams *m_ReqParams);
         void  GetForFrodo2(const TString &id, TReqParams *m_ReqParams);
         void  GetForFrodo(const TString &id, TReqParams *m_ReqParams);
         void  LogDebugOn();
         void  LogDebugOff();
         bool  WriteDump();
         void  DisableFFlush(bool disable, const TString &id);
         void  Debuginfo(const TString &id, TReqParams *m_ReqParams);
         void  AskReset(const TString &id);
         void  Reset(const TString &id);
         void  AskReloadLists(const TString &id);
         void  ReloadLists(const TString &id);
         void  AllRulesReset(const TString& id);
         void  TruncDayList(const TString& id);
         //void  PutSender(const TString& id);
         void  SetAddBanTime(const TString &id, TReqParams *m_ReqParams);
         void  SetRepeaterBase(const TString &id, TReqParams *m_ReqParams);
         void  AddBlackIp(const TString &id, TReqParams *m_ReqParams);
         void  AskAddBlackIp(const TString &id, TReqParams *m_ReqParams);
         void  AskAddBlackIpNew(const TString &id, TReqParams *m_ReqParams);
         void  AddBan7Ip(const TString &id, TReqParams *m_ReqParams);
         void  AskAddBan7Ip(const TString &id, TReqParams *m_ReqParams);
         void  DelBanIp(const TString &id, TReqParams *m_ReqParams);
         void  AskDelBanIp(const TString &id, TReqParams *m_ReqParams);
         void  ViewRuleTrap(const TString &id);
         void  AddStatRule(const TString &id, TReqParams *m_ReqParams);
         void  DelStatRule(const TString &id, TReqParams *m_ReqParams);
         void  BanControl(const TString &id);
         void  ClearIPStat(const TString &id, TReqParams *m_ReqParams);
         void  BanInfo(const TString &id, TReqParams *m_ReqParams);

         void  ViewIPStat(const TString &id, TReqParams *m_ReqParams);
         void  ViewIPStatAddress(const TString &id, const TString &ips, const TWKIPv6 &value);
         void  ViewIPStatNet(const TString &id, const TString &ips, const TWKIPv6 &value);
         void  CatchIP(const TString &id, TReqParams *m_ReqParams);
         void  CatchIPPeriod(const TString &id, TReqParams *m_ReqParams);
         void  IPPeriodList(const TString &id);
         void  ViewCatchPeriod(const TString &id, TReqParams *m_ReqParams);
         void  AskDelCatchPeriod(const TString &id, TReqParams *m_ReqParams);
         void  DelCatchPeriod(const TString &id, TReqParams *m_ReqParams);
         TString PrintTrapPeriodData(ui8 sorttype, TIDTrapInfo &resdata, ui32 mincount, ui32 mincounttd, bool markbanip, TIpType iptype, TWhtIp ipwht, int onlybanip, const TString &substr, bool is_pcre, ui32 dlvlog_rcv, ui32 dlvlog_skeep, ui32 maxhamcount_today, const TString &geozone, TNetKIPv6 &find_ip, const TString &find_ip_source, ui32 get_resdata_tick);
         void  ViewMailPeriodTrap(const TString &id, TReqParams *m_ReqParams);
         void  FindB3Log(const TString &id, TReqParams *m_ReqParams);
         void  AFindB3Log(const TString &id, TReqParams *m_ReqParams);
         void  PrintMemStat(const TString &id, TReqParams *m_ReqParams);
         TString WrapRdnsStroka(const TString &str);
         void  PrintMemStatOld(const TString &id, TReqParams *m_ReqParams);
         void  SetBanSetup(const TString &id, TReqParams *m_ReqParams);
         void  GetBanSetup(const TString &id, TReqParams *m_ReqParams);
         void  SetBanDefaultsWindow(const TString &id, TReqParams *m_ReqParams);

         void  ViewStorageStatistik(const TString &id, TReqParams *m_ReqParams);
         void  InputRequestStatistik(const TString &id, TReqParams *m_ReqParams);

         void  AskSaveDumpStorage(const TString &id, TReqParams *m_ReqParams);
         void  SaveDumpStorage(const TString &id, TReqParams *m_ReqParams);

         void  AskSaveDumpStorageStep1(const TString &id, TReqParams *m_ReqParams);
         void  SaveDumpStorageStep1(const TString &id, TReqParams *m_ReqParams);

         void  AskSaveDumpStorageOnlyBanList(const TString &id, TReqParams *m_ReqParams);
         void  SaveDumpStorageOnlyBanList(const TString &id, TReqParams *m_ReqParams);

         void  AskTopStorage(const TString &id, TReqParams *m_ReqParams);
         void  SaveTopStorage(const TString &id, TReqParams *m_ReqParams);

         void  SaveIPDataFromStorage(const TString &id, TReqParams *m_ReqParams);

         void  AskReaddump(const TString &id);
         void  DoReaddump(const TString &id);

         void  PutSender(const TString &id, TReqParams *m_ReqParams); //��� ������� sender shingler

         TString GetTrapForm(const TString &action_ident, int typeip, int onlybanip, int sorttype, int whtip, int delay, bool markbanip, ui32 minstatcountperiod, ui32 minstatcountperiod_today, ui32 id, const TString &substr, bool is_pcre, ui32 maxhamcount_today, const TString &geozone);
         TString GetTrapFormFA(const TString &action_ident, int typeip, int onlybanip, int sorttype, int whtip, int delay, bool markbanip, ui32 minstatcountperiod, ui32 minstatcountperiod_today, ui32 id, const TString &substr, bool is_pcre, ui32 maxhamcount_today, const TString &geozone, TNetKIPv6 &find_ip, const TString &find_ip_source);

         void  AddFollowIp(const TString &id, TReqParams *m_ReqParams);
         void  DelFollowIp(const TString &id, TReqParams *m_ReqParams);
         void  ViewFollowIpList(const TString &id, TReqParams *m_ReqParams);
         void  LastBanTimeNew(const TString &id);

         void  TruncLogs(const TString &id);

public:
         TMakeRequest(TServiceObjectBase &srvcobjA, void *serverA);
         ~TMakeRequest();
};

