#include "tmembasaclass.h"
#include "tstatipobject.h"

#ifndef _win_
#include <unistd.h>
#include <sys/syscall.h>
#endif

//***************************************************************************************
//                            THistoryBasa
//***************************************************************************************

THistoryBasa::THistoryBasa() {
}

THistoryBasa::~THistoryBasa() {
}

bool THistoryBasa::dWriteBlock(TKIPv6 ip, TIpDisk& value) {
    return true;
}

bool THistoryBasa::dWriteBlockQueue(TKIPv6 ip, TIpDisk& value) {
    return true;
}

bool THistoryBasa::dReadBlock(TKIPv6 ip, TIpDisk& value) {
    return true;
}

//**************************************************************************************
//                                  TReadIPDiskQueue
//**************************************************************************************

TReadIPDiskQueue::TReadIPDiskQueue(TLogsGroup* LogsGroupA, const TString& ident) {
    m_today_in_count = 0;
    m_today_out_count = 0;
    m_today_lost_count = 0;
    m_yesterday_in_count = 0;
    m_yesterday_out_count = 0;
    m_yesterday_lost_count = 0;
    LogsGroup = LogsGroupA;
    m_ident = ident;
    m_cps = 0;
    m_request = 0;
    m_last_calc_cps = time(nullptr);
}

TReadIPDiskQueue::~TReadIPDiskQueue() {
    blist.clear();
}

void TReadIPDiskQueue::Lock() {
    m_Mutex.Acquire();
}

void TReadIPDiskQueue::UnLock() {
    m_Mutex.Release();
}

void TReadIPDiskQueue::CalcCPS() {
    time_t currenttime = time(nullptr);
    if ((currenttime - m_last_calc_cps) >= 10) {
        m_cps = (float)m_request / (float)(currenttime - m_last_calc_cps);
        m_last_calc_cps = currenttime;
        m_request = 0;
    } else {
        m_request = (m_request < 0xFFFFFFFF) ? (m_request + 1) : 0xFFFFFFFF;
    }
}

void TReadIPDiskQueue::ReCalcCPS() {
    time_t currenttime = time(nullptr);
    if ((currenttime - m_last_calc_cps) >= 10) {
        m_cps = (float)m_request / (float)(currenttime - m_last_calc_cps);
        m_last_calc_cps = currenttime;
        m_request = 0;
    }
}

void TReadIPDiskQueue::Add(TKIPv6 value) {
    if (!value.Undefined()) {
        bool lost = false;

        Lock();

        CalcCPS();

        m_today_in_count = (m_today_in_count < 0xFFFFFFFFFFFFFFFF) ? (m_today_in_count + 1) : 0xFFFFFFFFFFFFFFFF;

        if (blist.size() < MAX_ELEMENT_COUNT)
            blist.push_back(value);
        else {
            lost = true;
            m_today_lost_count = (m_today_lost_count < 0xFFFFFFFFFFFFFFFF) ? (m_today_lost_count + 1) : 0xFFFFFFFFFFFFFFFF;
        }

        UnLock();

        if ((lost) && (LogsGroup != nullptr) && (LogsGroup->ActionLog() != nullptr)) {
            LogsGroup->ActionLog()->WriteMessageAndDataStatus(KERROR, "DISKBASA(%s): Cant's read history ip info (%s) to queue, queue is full.", m_ident.c_str(), value.toStroka().c_str());
        }
    }
}

TKIPv6 TReadIPDiskQueue::Get() {
    TKIPv6 res = TKIPv6();
    TLockDataUI32ListIt it;

    Lock();

    it = blist.begin();
    if (it != blist.end()) {
        res = (*it);
        blist.erase(it);
        m_today_out_count = (m_today_out_count < 0xFFFFFFFFFFFFFFFF) ? (m_today_out_count + 1) : 0xFFFFFFFFFFFFFFFF;
    } else {
        ReCalcCPS();
    }

    UnLock();

    return res;
}

void TReadIPDiskQueue::Midnight() {
    Lock();

    m_yesterday_in_count = m_today_in_count;
    m_yesterday_out_count = m_today_out_count;
    m_yesterday_lost_count = m_today_lost_count;
    m_today_in_count = 0;
    m_today_out_count = 0;
    m_today_lost_count = 0;

    UnLock();
}

TReadIPDiskQueueStat TReadIPDiskQueue::GetStat() {
    TReadIPDiskQueueStat res;

    res.m_today_count = blist.size();
    res.m_today_in_count = m_today_in_count;
    res.m_today_out_count = m_today_out_count;
    res.m_today_lost_count = m_today_lost_count;
    res.m_yesterday_in_count = m_yesterday_in_count;
    res.m_yesterday_out_count = m_yesterday_out_count;
    res.m_yesterday_lost_count = m_yesterday_lost_count;
    res.m_cps = m_cps;

    return res;
}

//***************************************************************************************
//                               TBanIPLocalCache
//***************************************************************************************

/*TBanIPLocalCache::TBanIPLocalCache()
{
   m_period_time           = 15;
   data                    = new TIPv6HashOnlyP();
   prev_data               = nullptr;
   m_last_changedata       = time(nullptr);
   m_today_request         = 0;
   m_today_findincache     = 0;
   m_yesterday_request     = 0;
   m_yesterday_findincache = 0;
}

TBanIPLocalCache::~TBanIPLocalCache()
{
   if (prev_data != nullptr)
   {
      delete prev_data;
      prev_data = nullptr;
   }
   if (data != nullptr)
   {
      delete data;
      data = nullptr;
   }
}

void TBanIPLocalCache::Lock()
{
   m_Mutex.Acquire();
}

void TBanIPLocalCache::UnLock()
{
   m_Mutex.Release();
}

void TBanIPLocalCache::Init(ui32 period_time)
{
   m_period_time = period_time;
}

void TBanIPLocalCache::EventTick()
{
   TIPv6HashOnlyP *temp_data  = nullptr;
   ui32           currenttime = time(nullptr);
   ui32           difftime    = 0;

   if (currenttime >= m_last_changedata)
   {
      difftime = currenttime - m_last_changedata;
      if (difftime > m_period_time)
      {
         Lock();

         m_last_changedata = currenttime;

         temp_data = prev_data;
         prev_data = data;
         data = new TIPv6HashOnlyP();

         UnLock();

         if (temp_data != nullptr)
         {
            delete temp_data;
            temp_data = nullptr;
         }
      }

   } else
   {
      difftime = 0;

      Lock();

      m_last_changedata = currenttime;

      UnLock();
   }
}

void TBanIPLocalCache::Midnight()
{
   Lock();

   m_yesterday_request     = m_today_request;
   m_yesterday_findincache = m_today_findincache;
   m_today_request         = 0;
   m_today_findincache     = 0;

   UnLock();
}

ui32 TBanIPLocalCache::GetRemainTime()
{
   ui32 res          = 0;
   ui32 current_time = time(nullptr);

   if (current_time > m_last_changedata)
      res = current_time - m_last_changedata;

   return res;
}

TBanLocalCacheStat TBanIPLocalCache::GetStat()
{
   TBanLocalCacheStat res;

   Lock();

   if (data != nullptr)
      res.m_data_size = data->size();
   if (prev_data != nullptr)
      res.m_data_prev_size = prev_data->size();
   res.m_last_change_data = m_last_changedata;

   res.m_today_request         = m_today_request;
   res.m_today_findincache     = m_today_findincache;
   res.m_yesterday_request     = m_yesterday_request;
   res.m_yesterday_findincache = m_yesterday_findincache;

   UnLock();

   return res;
}

bool TBanIPLocalCache::GetData(TKIPv6 ip, TBanCacheInfo &datav)
{
   bool           res      = false;
   TBanCacheInfo  *datap   = nullptr;
   void           *vpoint  = nullptr;

   if (!ip.Undefined())
   {
      Lock();

      m_today_request = IncMax64(m_today_request, 1);

      if ( (!res) && (data != nullptr) )
      {
         vpoint = nullptr;
         if (auto vpoint = MapFindPtr(*data, ip))
         {
            if (vpoint != nullptr)
            {
               datap = (TBanCacheInfo *)vpoint;
               datav = *datap;
               res   = true;
            }
         }
      }

      if ( (!res) && (prev_data != nullptr) )
      {
         vpoint = nullptr;
         if (auto vpoint = MapFindPtr(*prev_data, ip))
         {
            if (vpoint != nullptr)
            {
               datap = (TBanCacheInfo *)vpoint;
               datav = *datap;
               res   = true;
            }
         }
      }

      if (res)
         m_today_findincache = IncMax64(m_today_findincache, 1);

      UnLock();
   }

   return res;
}

void TBanIPLocalCache::AddData(TKIPv6 ip, const TBanCacheInfo &datav)
{
   TBanCacheInfo  *datap   = nullptr;

   if (!ip.Undefined())
   {
      Lock();

      datap = new TBanCacheInfo(datav);
      if ( (datap != nullptr) && (data != nullptr) )
      {
         if (data->emplace(ip, datap)) //���� ���� ��� �������� � ����, �� ����� ��������� �������� �������, ����� �� ���� ������ ������
         {
            delete datap;
            datap = nullptr;
         }
      }

      UnLock();
   }
}

void TBanIPLocalCache::RemoveData(TKIPv6 ip)
{
   if (!ip.Undefined())
   {
      Lock();

      if (data != nullptr)
         data->erase(ip);

      UnLock();
   }
}*/

TBanIPLocalCache::TBanIPLocalCache() {
    m_period_time = 15;
    data = new THashMap<TKIPv6, TBanCacheInfo>();
    prev_data = nullptr;
    m_last_changedata = time(nullptr);
    m_today_request = 0;
    m_today_findincache = 0;
    m_yesterday_request = 0;
    m_yesterday_findincache = 0;
}

TBanIPLocalCache::~TBanIPLocalCache() {
    if (prev_data != nullptr) {
        delete prev_data;
        prev_data = nullptr;
    }
    if (data != nullptr) {
        delete data;
        data = nullptr;
    }
}

void TBanIPLocalCache::Lock() {
    m_Mutex.Acquire();
}

void TBanIPLocalCache::UnLock() {
    m_Mutex.Release();
}

void TBanIPLocalCache::Init(ui32 period_time) {
    m_period_time = period_time;
}

void TBanIPLocalCache::EventTick() {
    THashMap<TKIPv6, TBanCacheInfo>* temp_data = nullptr;
    ui32 currenttime = time(nullptr);
    ui32 difftime = 0;

    if (currenttime >= m_last_changedata) {
        difftime = currenttime - m_last_changedata;
        if (difftime > m_period_time) {
            Lock();

            m_last_changedata = currenttime;

            temp_data = prev_data;
            prev_data = data;
            data = new THashMap<TKIPv6, TBanCacheInfo>();

            UnLock();

            if (temp_data != nullptr) {
                delete temp_data;
                temp_data = nullptr;
            }
        }

    } else {
        difftime = 0;

        Lock();

        m_last_changedata = currenttime;

        UnLock();
    }
}

void TBanIPLocalCache::Midnight() {
    Lock();

    m_yesterday_request = m_today_request;
    m_yesterday_findincache = m_today_findincache;
    m_today_request = 0;
    m_today_findincache = 0;

    UnLock();
}

ui32 TBanIPLocalCache::GetRemainTime() {
    ui32 res = 0;
    ui32 current_time = time(nullptr);

    if (current_time > m_last_changedata)
        res = current_time - m_last_changedata;

    return res;
}

TBanLocalCacheStat TBanIPLocalCache::GetStat() {
    TBanLocalCacheStat res;

    Lock();

    if (data != nullptr)
        res.m_data_size = data->size();
    if (prev_data != nullptr)
        res.m_data_prev_size = prev_data->size();
    res.m_last_change_data = m_last_changedata;

    res.m_today_request = m_today_request;
    res.m_today_findincache = m_today_findincache;
    res.m_yesterday_request = m_yesterday_request;
    res.m_yesterday_findincache = m_yesterday_findincache;

    UnLock();

    return res;
}

bool TBanIPLocalCache::GetData(TKIPv6 ip, TBanCacheInfo& datav) {
    bool res = false;
    TBanCacheInfo data_rec = TBanCacheInfo();

    if (!ip.Undefined()) {
        Lock();

        m_today_request = IncMax64(m_today_request, 1);

        if ((!res) && (data != nullptr)) {
            if (auto data_rec = MapFindPtr(*data, ip)) {
                datav = *data_rec;
                res = true;
            }
        }

        if ((!res) && (prev_data != nullptr)) {
            if (auto data_rec = MapFindPtr(*prev_data, ip)) {
                datav = *data_rec;
                res = true;
            }
        }

        if (res)
            m_today_findincache = IncMax64(m_today_findincache, 1);

        UnLock();
    }

    return res;
}

void TBanIPLocalCache::AddData(TKIPv6 ip, const TBanCacheInfo& datav) {
    if (!ip.Undefined()) {
        Lock();

        if (data != nullptr)
            data->emplace(ip, datav);

        UnLock();
    }
}

void TBanIPLocalCache::RemoveData(TKIPv6 ip) {
    if (!ip.Undefined()) {
        Lock();

        if (data != nullptr)
            data->erase(ip);

        UnLock();
    }
}

TWhiteIPLocalCache::TWhiteIPLocalCache() {
    m_diffcount = 1;
    m_difftime = 3600;
    m_today_request = 0;
    m_today_findincache = 0;
    m_yesterday_request = 0;
    m_yesterday_findincache = 0;
    data = new THashMap<TKIPv6, TWeightIPLocalCacheItem>();
}

TWhiteIPLocalCache::~TWhiteIPLocalCache() {
    if (data != nullptr) {
        delete data;
        data = nullptr;
    }
}

void TWhiteIPLocalCache::Lock() {
    m_Mutex.Acquire();
}

void TWhiteIPLocalCache::UnLock() {
    m_Mutex.Release();
}

void TWhiteIPLocalCache::Init(ui32 diffcount, ui32 difftime) {
    m_diffcount = diffcount;
    m_difftime = difftime;
}

TWhiteIPLocalCacheStat TWhiteIPLocalCache::GetStatBase() {
    TWhiteIPLocalCacheStat res;

    Lock();

    res.m_diffcount = m_diffcount;
    res.m_difftime = m_difftime;
    if (data != nullptr)
        res.m_size = data->size();
    res.m_today_request = m_today_request;
    res.m_today_findincache = m_today_findincache;
    res.m_yesterday_request = m_yesterday_request;
    res.m_yesterday_findincache = m_yesterday_findincache;

    UnLock();

    return res;
}

ui32 TWhiteIPLocalCache::Size() {
    ui32 res = 0;

    Lock();

    if (data != nullptr)
        res = data->size();

    UnLock();

    return res;
}

void TWhiteIPLocalCache::Midnight() {
    Lock();

    m_yesterday_request = m_today_request;
    m_yesterday_findincache = m_today_findincache;
    m_today_request = 0;
    m_today_findincache = 0;

    UnLock();
}

void TWhiteIPLocalCache::Cleanup(ui32& worktime, ui32& all_record, TWeightIPLocalCacheItemExList& erase_list) {
    ui32 tick = 0;
    TKIPv6 ip = TKIPv6();
    ui32 current_time = time(nullptr);
    ui32 difftime = 0;
    THashMap<TKIPv6, TWeightIPLocalCacheItem>* data_new = nullptr;
    THashMap<TKIPv6, TWeightIPLocalCacheItem>* data_temp = nullptr;
    TWeightIPLocalCacheItem data_rec = TWeightIPLocalCacheItem();

    worktime = 0;
    all_record = 0;
    tick = CShingleTime::GetMs();
    Lock();

    if (data != nullptr) {
        data_new = new THashMap<TKIPv6, TWeightIPLocalCacheItem>();

        all_record = data->size();

        for (auto& [ip, data_rec] : *data) {
            if (current_time > data_rec.lasttime)
                difftime = current_time - data_rec.lasttime;
            else
                difftime = 0;

            if (difftime > MAX_ELAPSED_LASTTIME_TO_CLEANUP) //� ������ �� ��������
            {
                //erase_list.push_back(TWeightIPLocalCacheItemEx(ip, pvalue));

            } else //� ����� ���, ������� �������
            {
                if (data_new != nullptr)
                    data_new->emplace(ip, data_rec);
            }
        }

        data_temp = data;
        data = data_new;
    }

    UnLock();
    tick = CShingleTime::GetMs() - tick;

    worktime = tick;

    if (data_temp != nullptr) {
        delete data_temp;
        data_temp = nullptr;
    }
}

void TWhiteIPLocalCache::FillStat(TWeightIPLocalCacheItem* pvalue, TObrabData& odata) {
    bool malicspamA = false;

    if (pvalue != nullptr) {
        pvalue->diff.m_count = IncMax32(pvalue->diff.m_count, 1);

        malicspamA = odata.pdld.m_exportdata.m_malicspam && (odata.pdld.m_exportdata.m_messclass == TSpClass::SPAM);
        switch (odata.pdld.m_exportdata.m_messclass) {
            case TSpClass::HAM:
            case TSpClass::DLVR:
                pvalue->diff.m_ham_count = IncMax32(pvalue->diff.m_ham_count, 1);
                pvalue->diff.m_ham_mailbox_count = IncMax32(pvalue->diff.m_ham_mailbox_count, odata.pdld.m_exportdata.mbox.MailBoxCount);
                break;
            case TSpClass::SPAM:
                pvalue->diff.m_spam_count = IncMax32(pvalue->diff.m_spam_count, 1);
                pvalue->diff.m_spam_mailbox_count = IncMax32(pvalue->diff.m_spam_mailbox_count, odata.pdld.m_exportdata.mbox.MailBoxCount);
                break;

            default:
                break;
        }

        if (malicspamA) {
            if (!odata.m_inc_malicspam_count) {
                pvalue->diff.m_malicspam_count = IncMax32(pvalue->diff.m_malicspam_count, 1);
                odata.m_inc_malicspam_count = true;

                ui32 full_malicspam_count = IncMax32(pvalue->memcopy.today.malicspam_count, pvalue->diff.m_malicspam_count);
                if (full_malicspam_count <= 3)
                    odata.m_need_print_ban3log = true;
            }

            pvalue->diff.m_malic_count = IncMax32(pvalue->diff.m_malic_count, 1);
            pvalue->diff.m_malic_mailbox_count = IncMax32(pvalue->diff.m_malic_mailbox_count, odata.pdld.m_exportdata.mbox.MailBoxCount);
        }

        //bMask
        if ((!odata.pdld.m_exportdata.m_fDSN) && (!odata.pdld.m_exportdata.m_fPop3) && (!odata.pdld.m_exportdata.m_fSMTP)) {
            pvalue->diff.m_cWeightSum = IncMax16(pvalue->diff.m_cWeightSum, (int)odata.pdld.m_exportdata.m_sp_wght);
            pvalue->diff.m_cWMess = IncMax16(pvalue->diff.m_cWMess, 1);
        }

        pvalue->diff.m_cMcount = IncMax16(pvalue->diff.m_cMcount, odata.pdld.m_exportdata.m_Uwl);

        if (odata.pdld.m_exportdata.m_fPop3 || odata.pdld.m_exportdata.m_fSMTP)
            pvalue->diff.m_cPop3 = IncMax16(pvalue->diff.m_cPop3, 1);

        if (odata.pdld.m_exportdata.m_fDSN)
            pvalue->diff.m_cDsn = IncMax16(pvalue->diff.m_cDsn, 1);
    }
}

bool TWhiteIPLocalCache::GetStat(TKIPv6 ip, TWeightIPLocalCacheItem& value) {
    bool res = false;
    TWeightIPLocalCacheItem data_rec = TWeightIPLocalCacheItem();

    value.Clear();

    Lock();

    if (data != nullptr) {
        if (auto data_rec = MapFindPtr(*data, ip)) {
            value = *data_rec;
            value.diff.white_local_cache_diff = GetDiffCount();
            value.diff.white_local_cache_diff_time = GetDiffTime();
        }
    }

    UnLock();

    return res;
}

bool TWhiteIPLocalCache::NeedRequestToStorage(TKIPv6 ip) {
    bool res = true;
    ui32 calcdiff = 0;
    ui32 currenttime = 0;
    TWeightIPLocalCacheItem data_rec = TWeightIPLocalCacheItem();

    if (GetDiffCount() > 0) {
        Lock();

        m_today_request = IncMax64(m_today_request, 1);

        currenttime = time(nullptr);
        if (data != nullptr) {
            if (auto data_rec = MapFindPtr(*data, ip)) {
                if (currenttime > data_rec->lasttime)
                    calcdiff = time(nullptr) - data_rec->lasttime;
                else
                    data_rec->lasttime = currenttime;
                if ((data_rec->diff.m_count < GetDiffCount()) && (calcdiff < GetDiffTime()))
                    res = false;
            }
        }

        if (res)
            m_today_findincache = IncMax64(m_today_findincache, 1);

        UnLock();
    }

    return res;
}

void TWhiteIPLocalCache::AddStorageInfo(TKIPv6 ip, TMemRecordCopy& memcopy) {
    //return;
    TWeightIPLocalCacheItem data_rec = TWeightIPLocalCacheItem();

    if (GetDiffCount() > 0) {
        Lock();

        if (data != nullptr) {
            if (auto data_rec = MapFindPtr(*data, ip)) {
                data_rec->memcopy = memcopy;
                data_rec->last_action = WIP_UPDATE_STORAGE;
                data_rec->lasttime = time(nullptr);

            } else {
                auto d = TWeightIPLocalCacheItem(memcopy);
                d.last_action = WIP_UPDATE_STORAGE;
                d.lasttime = time(nullptr);
                data->emplace(ip, d);
            }
        }

        UnLock();
    }
}

void TWhiteIPLocalCache::AddDiffData(TKIPv6 ip, TObrabData& odata) {
    //return;

    TWeightIPLocalCacheItem data_rec = TWeightIPLocalCacheItem();

    if (GetDiffCount() > 0) {
        Lock();

        if (data != nullptr) {
            if (auto data_rec = MapFindPtr(*data, ip)) {
                FillStat(data_rec, odata);
                data_rec->last_action = WIP_UPDATE_DIFF;
            }
        }

        UnLock();
    }
}

bool TWhiteIPLocalCache::GetDiffData(TKIPv6 ip, TWeightIPLocalCacheDiff& value) {
    bool res = false;
    TWeightIPLocalCacheItem data_rec = TWeightIPLocalCacheItem();

    if (GetDiffCount() > 0) {
        Lock();

        if (data != nullptr) {
            if (auto data_rec = MapFindPtr(*data, ip)) {
                value = data_rec->diff;
                res = true;

                data->erase(ip);
            }
        }

        UnLock();
    }

    return res;
}

//***************************************************************************************
//                                 TMemBaseSection
//***************************************************************************************

TMemBaseSection::TMemBaseSection() {
    statipobj = nullptr;
    memstat_cache = nullptr;
    LogsGroup = nullptr;
    m_new_record_count_today = 0;
    m_new_record_count_yesterday = 0;
}

TMemBaseSection::~TMemBaseSection() {
    DELETE_OBJ(memstat_cache);
}

void TMemBaseSection::Init(void* statipobjA, TLogsGroup* LogsGroupA, TKConfig* configobjA) {
    statipobj = statipobjA;
    LogsGroup = LogsGroupA;

    if (configobjA != nullptr)
        minstatcount = configobjA->ReadInteger("mem", "minstatcount", 1000);
}

void TMemBaseSection::Midnight() {
    m_MemStatMutex.Acquire();

    m_new_record_count_yesterday = m_new_record_count_today;
    m_new_record_count_today = 0;

    m_MemStatMutex.Release();

    CleanupHeavyStorage();
}

void TMemBaseSection::EventTick() {
    if (cache_info.m_need_update_cache)
        ReadHeavyFromStorage();
}

void TMemBaseSection::GetNewRecordCount(ui64& today, ui64& yesterday) {
    today = m_new_record_count_today;
    yesterday = m_new_record_count_yesterday;
}

ui32 TMemBaseSection::AddData32(ui32& value, ui32 addv) {
    ui32 count = 0;
    ui32 dob = 0;

    if (value < MAX32BITVALUE) {
        count = MAX32BITVALUE - value;
        dob = (addv > count) ? count : addv;
        value += dob;
    }

    return value;
}

ui32 TMemBaseSection::AddData32Diff(ui32& value, ui32 addv) {
    ui32 count = 0;
    ui32 dob = 0;

    if (value < MAX32BITVALUE) {
        count = MAX32BITVALUE - value;
        dob = (addv > count) ? count : addv;
    }

    return dob;
}

ui32 TMemBaseSection::IncData32(ui32 value, ui32 addv) {
    ui32 res = value;
    ui32 count = 0;
    ui32 dob = 0;

    if (value < MAX32BITVALUE) {
        count = MAX32BITVALUE - value;
        dob = (addv > count) ? count : addv;
        res += dob;
    }

    return res;
}

ui16 TMemBaseSection::AddData16(ui16& value, ui16 addv) {
    ui16 count = 0;
    ui16 dob = 0;

    if (value < MAX16BITVALUE) {
        count = MAX16BITVALUE - value;
        dob = (addv > count) ? count : addv;
        value += dob;
    }

    return value;
}

ui16 TMemBaseSection::AddData16Diff(ui16& value, ui16 addv) {
    ui16 count = 0;
    ui16 dob = 0;

    if (value < MAX16BITVALUE) {
        count = MAX16BITVALUE - value;
        dob = (addv > count) ? count : addv;
    }

    return dob;
}

ui8 TMemBaseSection::AddData8(ui8& value, ui8 addv) {
    ui8 count = 0;
    ui8 dob = 0;

    if (value < MAX8BITVALUE) {
        count = MAX8BITVALUE - value;
        dob = (addv > count) ? count : addv;
        value += dob;
    }

    return value;
}

ui8 TMemBaseSection::AddData8Diff(ui8& value, ui8 addv) {
    ui8 count = 0;
    ui8 dob = 0;

    if (value < MAX8BITVALUE) {
        count = MAX8BITVALUE - value;
        dob = (addv > count) ? count : addv;
    }

    return dob;
}

void TMemBaseSection::AddToHash(nosql::HashMap& hash, const TString& fname, i64 value) {
    if (!fname.empty()) {
        nosql::HashMap::iterator it;
        i64 count = 0;
        i64 dob = 0;

        it = hash.find(fname);
        if (it != hash.end()) {
            if (value > 0) {
                if (value > MAX32BITVALUE)
                    value = MAX32BITVALUE;
                if (value <= MAX32BITVALUE) {
                    count = MAX32BITVALUE - value;
                    dob = (value > count) ? count : value;
                    dob += (*it).second.Long();
                    (*it).second = dob;
                }

            } else if (value < 0) {
                value += (*it).second.Long();
                (*it).second = value;
            }

        } else {
            if (value != 0) {
                if (value > MAX32BITVALUE)
                    hash[fname] = MAX32BITVALUE;
                else
                    hash[fname] = value;
            }
        }
    }
}

TString TMemBaseSection::PrintHashData(nosql::HashMap& value) {
    TString res = "";
    TFindToFileReport counters;
    TString id = "";
    TString ip = "";

    res = TStorageNoSql::GetDataToLog(value, counters, id, ip);

    return res;
}

void TMemBaseSection::WriteTodayStatistic(TKIPv6 ip, time_t m_curr_time, TMemRecord* mb) {
    TString res = "";
    time_t t1 = 0;
    time_t t2 = 0;
    ui32 Spam = 0;
    ui32 Ham = 0;
    ui32 MalicSpam = 0;
    TString rdns = "";
    ui32 ManualBanCount = 0;

    if (mb != nullptr) {
        t1 = m_curr_time - mb->today.tFixDay;
        t2 = m_curr_time - mb->today.tLastMes;
        Spam = mb->today.ctSpam;
        Ham = mb->today.ctHam;
        MalicSpam = mb->today.ctMalicSpam;
        rdns = mb->today.rdns;
        if (rdns.empty())
            rdns = "-";
        //ManualBanCount = mb->today.ManualBanCount;

        res = "IP:" + IntToIp(ip.IPv4Address()) + ", Tfix:" + ConvertTime(mb->today.tFixDay) + " (" + GetTimePeriod(t1) + "), Tlastmes:" + ConvertTime(mb->today.tLastMes) + " (" + GetTimePeriod(t2) + "), HAM:" + IntToStroka(Ham) + ", SPAM:" + IntToStroka(Spam) + ", MALIC:" + IntToStroka(MalicSpam) + ", rdns:" + rdns /*+ ", manual_ban_count:" + IntToStroka(ManualBanCount)*/;
        if ((LogsGroup != nullptr) && (LogsGroup->StatIPLog() != nullptr))
            LogsGroup->StatIPLog()->WriteMessageAndData("%s", res.c_str());
    }
}

bool TMemBaseSection::mongo_read_ip_data(TStorageType stortype, TKIPv6 ip, bool& mongo_err, TMemRecord& data, bool& empty) {
    bool res = false;

    if ((statipobj != nullptr) && (((TStatIPObject*)statipobj)->GetStorage() != nullptr))
        res = ((TStatIPObject*)statipobj)->GetStorage()->mongo_read_ip_data(stortype, ip, mongo_err, data, empty);

    return res;
}

bool TMemBaseSection::mongo_update_ip_data(TStorageType stortype, TKIPv6 ip, bool& mongo_err, nosql::HashMap& sets, nosql::HashMap& incrs) {
    bool res = false;

    if ((statipobj != nullptr) && (((TStatIPObject*)statipobj)->GetStorage() != nullptr))
        res = ((TStatIPObject*)statipobj)->GetStorage()->mongo_update_ip_data(stortype, ip, mongo_err, sets, incrs);

    return res;
}

bool TMemBaseSection::mongo_findandmodify(TStorageType stortype, TKIPv6 ip, bool& mongo_err, const nosql::HashMap& incrs, const nosql::HashMap& sets, nosql::HashMap& hash, bool getnew) {
    bool res = false;

    if ((statipobj != nullptr) && (((TStatIPObject*)statipobj)->GetStorage() != nullptr))
        res = ((TStatIPObject*)statipobj)->GetStorage()->mongo_findandmodify(stortype, ip, mongo_err, incrs, sets, hash, getnew);

    return res;
}

i64 TMemBaseSection::mongo_basa_size(TStorageType stortype) {
    i64 res = 0;

    if ((statipobj != nullptr) && (((TStatIPObject*)statipobj)->GetStorage() != nullptr))
        res = ((TStatIPObject*)statipobj)->GetStorage()->mongo_basa_size(stortype);

    return res;
}

bool TMemBaseSection::mongo_find(TStorageType stortype, TVector<nosql::HashMap>& hashes) {
    bool res = false;

    if ((statipobj != nullptr) && (((TStatIPObject*)statipobj)->GetStorage() != nullptr))
        res = ((TStatIPObject*)statipobj)->GetStorage()->mongo_find(stortype, hashes);

    return res;
}

bool TMemBaseSection::mongo_erase(TStorageType stortype, TKIPv6 ip, bool& mongo_err) {
    bool res = false;

    if ((statipobj != nullptr) && (((TStatIPObject*)statipobj)->GetStorage() != nullptr))
        res = ((TStatIPObject*)statipobj)->GetStorage()->mongo_erase(stortype, ip, mongo_err);

    return res;
}

void TMemBaseSection::AddToMemStatMongo(TKIPv6 ip, ui32 todayham, ui32 todayspam, ui32 todaymalic, ui32 summham, ui32 summspam, ui32 summmalic,
                                        const TString& m_rdns, const TString& m_rdns2, const TString& m_rdns3, time_t m_curr_time, time_t tFixDay, float m_cps, bool forwardA, ui32 frwd_pr1, bool white_pr, ui32 pcmb) {
    ui32 memall = 0;

    memall = IncMax32(summspam, summham);
    if (memall > minstatcount) {
        nosql::HashMap sets;
        nosql::HashMap incrs;
        TIpStat ips;
        bool mongo_err = false;

        sets.clear();
        incrs.clear();

        ips.ctHam_today = todayham;
        ips.ctSpam_today = todayspam;
        ips.ctMalicSpam_today = todaymalic;
        ips.ctHam = summham;
        ips.ctSpam = summspam;
        ips.ctMalicSpam = summmalic;
        ips.rdns = m_rdns;
        ips.rdns2 = m_rdns2;
        ips.rdns3 = m_rdns3;
        ips.last_update = m_curr_time;
        ips.last_fix = tFixDay;
        ips.cps = m_cps;
        ips.forwards = forwardA;
        ips.frwd_pr1 = frwd_pr1;
        ips.white_pr = white_pr ? WHTYES : WHTNO;
        ips.pcmb = pcmb;

        TIpStatSerialization::SerializeWOCheck(ips, sets);

        if (!mongo_update_ip_data(MST_MEMSTAT, ip, mongo_err, sets, incrs)) {
            if ((LogsGroup != nullptr) && (LogsGroup->MongoEventLog() != nullptr))
                LogsGroup->MongoEventLog()->WriteMessageAndDataStatus(KERROR, "update (AddToMemStatMongo), ip=%s", ip.toStroka().c_str());
        }
    }
}

bool TMemBaseSection::mongo_read_rps(TKIPv6 ip, bool& mongo_err, TDSLRps& data, bool& empty) {
    bool res = false;

    if ((statipobj != nullptr) && (((TStatIPObject*)statipobj)->GetStorage() != nullptr))
        res = ((TStatIPObject*)statipobj)->GetStorage()->mongo_read_rps(ip, mongo_err, data, empty);

    return res;
}

bool TMemBaseSection::mongo_update_rps(TKIPv6 ip, bool& mongo_err, nosql::HashMap& sets, nosql::HashMap& incrs) {
    bool res = false;

    if ((statipobj != nullptr) && (((TStatIPObject*)statipobj)->GetStorage() != nullptr))
        res = ((TStatIPObject*)statipobj)->GetStorage()->mongo_update_rps(ip, mongo_err, sets, incrs);

    return res;
}

bool TMemBaseSection::mongo_findandmodify_rps(TKIPv6 ip, bool& mongo_err, const nosql::HashMap& incrs, const nosql::HashMap& sets, nosql::HashMap& hash, bool getnew) {
    bool res = false;

    if ((statipobj != nullptr) && (((TStatIPObject*)statipobj)->GetStorage() != nullptr))
        res = ((TStatIPObject*)statipobj)->GetStorage()->mongo_findandmodify_rps(ip, mongo_err, incrs, sets, hash, getnew);

    return res;
}

bool TMemBaseSection::mongo_check_mem_basa(TKIPv6 ip, i64 currenttime, TMemRecord& data, const TString& idmess, TDiffCounter* changeday1_counter, TDiffCounter* changeday2_counter) {
    bool res = false;
    i64 t = 0;

    t = currenttime - data.today.tFixDay;
    if (t < (24 * 3600)) {
        res = true;

        if (statipobj != nullptr)
            ((TStatIPObject*)statipobj)->PrintFollowIp(ip, idmess.c_str(), FIE_31, "");

    } else {
        //TString         db_name         = "";
        //TString         collection_name = "";
        //TString         id              = "";
        bool update_check = true;
        nosql::HashMap incrs;
        nosql::HashMap sets;
        nosql::HashMap hash;
        bool err = false;
        bool mongo_err = false;
        bool empty = true;
        TString debug_info = "";
        bool need_debug_info = false;
        int a = 0;

        if (statipobj != nullptr)
            need_debug_info = ((TStatIPObject*)statipobj)->IsFollowIP(data.today.ip);

        sets[TODAY_FIXDAY] = currenttime;
        sets[TODAY_PR_CMB] = 1; //set priznak check_mem_basa

        if (need_debug_info) {
            //debug_info += "db='" + db_name + "::" + collection_name + "'^";
            debug_info += "curr='" + UI32ToStroka(currenttime) + "'^";
            debug_info += "tfix='" + UI32ToStroka(data.today.tFixDay) + "'^";
            debug_info += "sets='" + PrintHashData(sets) + "'^";
        }

        //��������:
        //ip ����� ������ ����� tFixDay
        //���� � ���� ���� ip � �������� ������ ��� tFixDay �� �����, � ���������� ������ �� ������ tFixDay (�������� getnew)
        //���� ������������ �������� tFixDay ����� ������� ������� tFixDay, ������ ���� ����� ������ �����, ������� ���������� ����� ���������
        //���� ������������ �������� tFixDay ����� ������ ������� tFixDay, �� �������� ������ �� ������, �.�. ������ ����� ��� ������� �������� ��� ����� �� ���, � �� ����� ������ ��������

        // It's an db AtomicSet to be sure that only one thread (of all processes) passes that if
        update_check = mongo_findandmodify(MST_MEMBASE, ip, err, incrs, sets, hash, false);

        if (need_debug_info)
            debug_info += "hash='" + PrintHashData(hash) + "'^";

        nosql::HashMap value = hash["value"].Hash();

        if (need_debug_info)
            debug_info += "value='" + PrintHashData(value) + "'^";

        if (update_check) {
            a = 1;
            update_check = value[TODAY_FIXDAY].Long() == static_cast<i64>(data.today.tFixDay);
            a = update_check ? 2 : 3;

        } else {
            a = 4;
        }

        if (need_debug_info) {
            debug_info += "update_check='" + IntToStroka(a) + "'^";
            if (statipobj != nullptr)
                ((TStatIPObject*)statipobj)->PrintFollowIp(ip, idmess.c_str(), FIE_32, debug_info);
        }

        // If value didn't changed since we read it
        if (update_check) {
            if ((t >= (24 * 3600)) && (t < (48 * 3600))) {
                if (changeday1_counter != nullptr)
                    changeday1_counter->Increment();

                TString dobdata = "";
                time_t t = 0;
                float koef2 = 0;
                TString rdns = "";
                bool is_white_ip = false;
                time_t ymlast = 0;

                t = currenttime - data.today.tLastMes;
                t = (t > 86400) ? 86400 : t;
                koef2 = (static_cast<float>(86400) - static_cast<float>(t)) / static_cast<float>(86400);

                rdns = data.today.rdns;
                is_white_ip = IS_SF_WHITE(data.today.bMask);

                WriteTodayStatistic(ip, currenttime, &data);
                ymlast = data.today.tLastMes;

                sets.clear();
                incrs.clear();

                //copy today to yesterday
                sets[YESTERDAY_SPAM] = static_cast<i64>(data.today.ctSpam);
                sets[YESTERDAY_HAM] = static_cast<i64>(data.today.ctHam);
                sets[YESTERDAY_MALICSPAM] = static_cast<i64>(data.today.ctMalicSpam);
                sets[YESTERDAY_SPAMMAIL] = static_cast<i64>(data.today.ctSpamMail);
                sets[YESTERDAY_HAMMAIL] = static_cast<i64>(data.today.ctHamMail);
                sets[YESTERDAY_MALICSPAMMAIL] = static_cast<i64>(data.today.ctMalicSpamMail);
                sets[YESTERDAY_POP3] = static_cast<i64>(data.today.cPop3);
                sets[YESTERDAY_DSN] = static_cast<i64>(data.today.cDsn);
                sets[YESTERDAY_REJECTED] = static_cast<i64>(data.today.cRejected);
                sets[YESTERDAY_MCOUNT] = static_cast<i64>(data.today.cMcount);
                sets[YESTERDAY_BMASK] = static_cast<i64>(data.today.bMask);
                sets[YESTERDAY_WEIGHTSUM] = static_cast<i64>(data.today.cWeightSum);
                sets[YESTERDAY_WMESS] = static_cast<i64>(data.today.cWMess);

                //add today to history
                sets[HISTORY_LASTMES] = currenttime;
                if (AddData32Diff(data.history.ctSpam, data.today.ctSpam) > 0)
                    incrs[HISTORY_SPAM] = AddData32Diff(data.history.ctSpam, data.today.ctSpam);
                if (AddData32Diff(data.history.ctHam, data.today.ctHam) > 0)
                    incrs[HISTORY_HAM] = AddData32Diff(data.history.ctHam, data.today.ctHam);
                if (AddData32Diff(data.history.ctMalicSpam, data.today.ctMalicSpam) > 0)
                    incrs[HISTORY_MALICSPAM] = AddData32Diff(data.history.ctMalicSpam, data.today.ctMalicSpam);
                if (AddData16Diff(data.history.cDsn, data.today.cDsn) > 0)
                    incrs[HISTORY_DSN] = AddData16Diff(data.history.cDsn, data.today.cDsn);
                if (data.today.cPop3 > 0) {
                    if (AddData16Diff(data.history.cPop3_Auth, data.today.cPop3) > 0)
                        incrs[HISTORY_POP3AUTH] = AddData16Diff(data.history.cPop3_Auth, data.today.cPop3);
                }
                if ((data.today.manual_ban_count > 0) || (data.today.ban_count > 0))
                //if ( IS_SF_BAN(data.today.bMask) || IS_SF_BAN_WOW(data.today.bMask) )
                {
                    if (AddData16Diff(data.history.cDaysRej, 1) > 0)
                        incrs[HISTORY_DAYSREJ] = AddData16Diff(data.history.cDaysRej, 1);

                } else {
                    if (AddData16Diff(data.history.cDaysNoRej, 1) > 0)
                        incrs[HISTORY_DAYSNOREJ] = AddData16Diff(data.history.cDaysNoRej, 1);
                }
                if (IS_SF_FORWARD(data.today.bMask)) {
                    if (AddData16Diff(data.history.cFwdDays, 1) > 0)
                        incrs[HISTORY_FWDDAYS] = AddData16Diff(data.history.cFwdDays, 1);
                }
                //if ( IS_SF_WAS_BAN_WOW(data.today.bMask) )
                //{
                //if (AddData32Diff(data.history.cManualBanCount, 1) > 0)
                //  incrs[ HISTORY_MANUALBANCOUNT ] = AddData32Diff(data.history.cManualBanCount, 1);

                //}
                sets[HISTORY_CRC32] = 0;

                //clear today
                TIpMemSerialization::Clear(sets, data.today);

                //correct today
                sets[TODAY_FIXDAY] = currenttime;
                sets[TODAY_LASTMES] = static_cast<i64>(ymlast); //������������ ����� ���������� ���������� ��������� � �����, �.�. �������� ������� �� ������ ���������� �� ������� ���������� ��������� � �����
                sets[TODAY_KOEF2] = koef2;
                if (!rdns.empty())
                    sets[TODAY_RDNS] = rdns; //��-�� ������ ���������� ������������ ������ � rdns � whiteip �� ���������� ������
                if (is_white_ip) {
                    ui32 t_mask = 0;

                    SET_SF_WHITE(t_mask);
                    sets[TODAY_BMASK] = t_mask;
                }
                sets[TODAY_PR_CMB] = 0; //reset priznak check_mem_basa

                //update ip data
                mongo_err = false;
                if (!mongo_update_ip_data(MST_MEMBASE, ip, mongo_err, sets, incrs)) {
                    dobdata += "up_false,";
                    if ((LogsGroup != nullptr) && (LogsGroup->MongoEventLog() != nullptr))
                        LogsGroup->MongoEventLog()->WriteMessageAndDataStatus(KERROR, "update (check_mem_basa,y), ip=%s", ip.toStroka().c_str());

                } else {
                    dobdata += "up_true,";
                }

                //read ip data from storage
                data.Clear();
                mongo_err = false;
                empty = true;
                if (!mongo_read_ip_data(MST_MEMBASE, ip, mongo_err, data, empty)) {
                    dobdata += "read_false";
                    if ((LogsGroup != nullptr) && (LogsGroup->MongoEventLog() != nullptr))
                        LogsGroup->MongoEventLog()->WriteMessageAndDataStatus(KERROR, "get (check_mem_basa), ip=%s", ip.toStroka().c_str());

                } else {
                    dobdata += "read_true";
                    res = true;
                }

                if (statipobj != nullptr)
                    ((TStatIPObject*)statipobj)->PrintFollowIp(ip, idmess.c_str(), FIE_33, dobdata);

            } else if (t >= (48 * 3600)) {
                if (changeday2_counter != nullptr)
                    changeday2_counter->Increment();

                TString dobdata = "";

                TString rdns = "";
                bool is_white_ip = false;
                time_t ymlast = 0;

                rdns = data.today.rdns;
                is_white_ip = IS_SF_WHITE(data.today.bMask);

                WriteTodayStatistic(ip, currenttime, &data);
                ymlast = data.today.tLastMes;

                sets.clear();
                incrs.clear();

                //clear yesterday
                TIpMemYSerialization::Clear(sets);

                //add today to history
                sets[HISTORY_LASTMES] = currenttime;
                if (AddData32Diff(data.history.ctSpam, data.today.ctSpam) > 0)
                    incrs[HISTORY_SPAM] = AddData32Diff(data.history.ctSpam, data.today.ctSpam);
                if (AddData32Diff(data.history.ctHam, data.today.ctHam) > 0)
                    incrs[HISTORY_HAM] = AddData32Diff(data.history.ctHam, data.today.ctHam);
                if (AddData32Diff(data.history.ctMalicSpam, data.today.ctMalicSpam) > 0)
                    incrs[HISTORY_MALICSPAM] = AddData32Diff(data.history.ctMalicSpam, data.today.ctMalicSpam);
                if (AddData16Diff(data.history.cDsn, data.today.cDsn) > 0)
                    incrs[HISTORY_DSN] = AddData16Diff(data.history.cDsn, data.today.cDsn);
                if (data.today.cPop3 > 0) {
                    if (AddData16Diff(data.history.cPop3_Auth, data.today.cPop3) > 0)
                        incrs[HISTORY_POP3AUTH] = AddData16Diff(data.history.cPop3_Auth, data.today.cPop3);
                }
                if ((data.today.manual_ban_count > 0) || (data.today.ban_count > 0))
                //if ( IS_SF_BAN(data.today.bMask) || IS_SF_BAN_WOW(data.today.bMask) )
                {
                    if (AddData16Diff(data.history.cDaysRej, 1) > 0)
                        incrs[HISTORY_DAYSREJ] = AddData16Diff(data.history.cDaysRej, 1);

                } else {
                    if (AddData16Diff(data.history.cDaysNoRej, 1) > 0)
                        incrs[HISTORY_DAYSNOREJ] = AddData16Diff(data.history.cDaysNoRej, 1);
                }
                if (IS_SF_FORWARD(data.today.bMask)) {
                    if (AddData16Diff(data.history.cFwdDays, 1) > 0)
                        incrs[HISTORY_FWDDAYS] = AddData16Diff(data.history.cFwdDays, 1);
                }
                //if ( IS_SF_WAS_BAN_WOW(data.today.bMask) )
                //{
                //if (AddData32Diff(data.history.cManualBanCount, 1) > 0)
                //  incrs[ HISTORY_MANUALBANCOUNT ] = AddData32Diff(data.history.cManualBanCount, 1);

                //}
                sets[HISTORY_CRC32] = 0;

                //clear today
                TIpMemSerialization::Clear(sets, data.today);

                //correct today
                sets[TODAY_FIXDAY] = currenttime;
                sets[TODAY_LASTMES] = static_cast<i64>(ymlast); //������������ ����� ���������� ���������� ��������� � �����, �.�. �������� ������� �� ������ ���������� �� ������� ���������� ��������� � �����

                if (!rdns.empty())
                    sets[TODAY_RDNS] = rdns; //��-�� ������ ���������� ������������ ������ � rdns � whiteip �� ���������� ������
                if (is_white_ip) {
                    ui32 t_mask = 0;

                    SET_SF_WHITE(t_mask);
                    sets[TODAY_BMASK] = t_mask;
                }
                sets[TODAY_PR_CMB] = 0; //reset priznak check_mem_basa

                //!!!DEBUG!!!
                //            sleep(30);

                //update ip data
                mongo_err = false;
                if (!mongo_update_ip_data(MST_MEMBASE, ip, mongo_err, sets, incrs)) {
                    dobdata += "up_false,";
                    if ((LogsGroup != nullptr) && (LogsGroup->MongoEventLog() != nullptr))
                        LogsGroup->MongoEventLog()->WriteMessageAndDataStatus(KERROR, "update (check_mem_basa,h), ip=%s", ip.toStroka().c_str());

                } else {
                    dobdata += "up_true,";
                }

                //read ip data from storage
                data.Clear();
                mongo_err = false;
                empty = true;
                if (!mongo_read_ip_data(MST_MEMBASE, ip, mongo_err, data, empty)) {
                    dobdata += "read_false";
                    if ((LogsGroup != nullptr) && (LogsGroup->MongoEventLog() != nullptr))
                        LogsGroup->MongoEventLog()->WriteMessageAndDataStatus(KERROR, "get (check_mem_basa), ip=%s", ip.toStroka().c_str());

                } else {
                    dobdata += "read_true";
                    res = true;
                }

                if (statipobj != nullptr)
                    ((TStatIPObject*)statipobj)->PrintFollowIp(ip, idmess.c_str(), FIE_34, dobdata);
            }
        } else {
            if (statipobj != nullptr)
                ((TStatIPObject*)statipobj)->PrintFollowIp(ip, idmess.c_str(), FIE_35, "");
        }
    }

    return res;
}

TMemRecordCopy TMemBaseSection::mAddStatMongo(TKIPv6 ip,
                                              T_enum_ip_level stattype,
                                              int* pIpSpam,
                                              bool& WhiteIp,
                                              TTimes& DelayT,
                                              TObrabData& odata,
                                              TWhiteIPLocalCache* whiteip_cache,
                                              TDiffCounter* changeday1_counter,
                                              TDiffCounter* changeday2_counter) {
    TMemRecordCopy res;
    bool mongo_err = false;
    bool mongo_empty = false;
    TMemRecord ipdata;
    bool resm = false;

    res.today.ip = ip;
    res.m_empty = true;

    if (statipobj != nullptr)
        ((TStatIPObject*)statipobj)->PrintFollowIp(ip, odata.m_rep.GetMailNumberShort().c_str(), FIE_25, "");

    resm = mongo_read_ip_data(MST_MEMBASE, ip, mongo_err, ipdata, mongo_empty);

    if (statipobj != nullptr)
        ((TStatIPObject*)statipobj)->PrintFollowIp(ip, odata.m_rep.GetMailNumberShort().c_str(), FIE_26, BoolToStroka(resm));

    if (resm) {
        if (!mongo_empty) {
            resm = mongo_check_mem_basa(ip, static_cast<i64>(odata.m_curr_time), ipdata, odata.m_rep.GetMailNumberShort(), changeday1_counter, changeday2_counter);

            if (statipobj != nullptr)
                ((TStatIPObject*)statipobj)->PrintFollowIp(ip, odata.m_rep.GetMailNumberShort().c_str(), FIE_27, BoolToStroka(resm));
        }

        if (resm) {
            nosql::HashMap incrs;
            nosql::HashMap sets;
            bool malicspamA = false;
            TWeightIPLocalCacheDiff white_cache_value;
            bool white_cache_value_nonempty = false;
            time_t cpsotc = 0;
            bool isforward = false;
            bool prfrwd_h = false;
            float koef = 0;
            ui32 summspam = 0;
            ui32 summham = 0;
            ui32 summmalic = 0;
            ui32 summall = 0;
            ui32 tall = 0;
            ui32 tallpred = 0;
            float tmpfvar = 0;

            incrs.clear();
            sets.clear();

            if (mongo_empty) //first record
            {
                sets[TODAY_IP] = ip.toStroka();
                ipdata.today.ip = ip;

                sets[TODAY_FIXDAY] = static_cast<i64>(odata.m_curr_time);
                ipdata.today.tFixDay = odata.m_curr_time;

                sets[HISTORY_FIRSTDEAL] = static_cast<i64>(odata.m_curr_time);
                ipdata.history.tFirstDeal = odata.m_curr_time;

                if (m_new_record_count_today < 0xFFFFFFFFFFFFFFFF)
                    AtomicIncrement(m_new_record_count_today);

                if (statipobj != nullptr)
                    ((TStatIPObject*)statipobj)->PrintFollowIp(ip, odata.m_rep.GetMailNumberShort().c_str(), FIE_28, "");
            }

            malicspamA = odata.pdld.m_exportdata.m_malicspam && (odata.pdld.m_exportdata.m_messclass == TSpClass::SPAM);
            *pIpSpam = 0;

            //����� ������� white �� ���� � rdns
            if ((!WhiteIp) && (IS_SF_WHITE(ipdata.today.bMask))) {
                WhiteIp = true;
                odata.m_rep.SetWhiteIp(WhiteIp);
            }

            //����� ������ �� ���� (���� ����)
            if ((WhiteIp) && (whiteip_cache != nullptr) && (whiteip_cache->GetDiffData(ip, white_cache_value))) {
                white_cache_value_nonempty = true;
            }

            if ((odata.m_rep.GetHost().empty()) && (!ipdata.today.rdns.empty()))
                odata.m_rep.SetHost(ipdata.today.rdns);

            switch (odata.pdld.m_exportdata.m_messclass) {
                case TSpClass::HAM:
                case TSpClass::DLVR:
                    AddData32(ipdata.today.ctHam, 1);
                    AddData32(ipdata.today.ctHamMail, odata.pdld.m_exportdata.mbox.MailBoxCount);

                    AddToHash(incrs, TODAY_HAM, static_cast<i64>(1));                                             //mongo
                    AddToHash(incrs, TODAY_HAMMAIL, static_cast<i64>(odata.pdld.m_exportdata.mbox.MailBoxCount)); //mongo

                    break;
                case TSpClass::SPAM:
                    AddData32(ipdata.today.ctSpam, 1);
                    AddData32(ipdata.today.ctSpamMail, odata.pdld.m_exportdata.mbox.MailBoxCount);

                    AddToHash(incrs, TODAY_SPAM, static_cast<i64>(1));                                             //mongo
                    AddToHash(incrs, TODAY_SPAMMAIL, static_cast<i64>(odata.pdld.m_exportdata.mbox.MailBoxCount)); //mongo

                    //----------------------------
                    {
                        int cdel = ipdata.today.ctSpam / 100;
                        if (cdel * 100 == ipdata.today.ctSpam) {
                            if (ipdata.today.ctSpam <= 1000 || ((cdel / 10) * 10 == cdel))
                                *pIpSpam = ipdata.today.ctSpam;
                        }
                    }
                    //----------------------------
                    break;

                default:
                    break;
            };

            if (malicspamA) {
                if (!odata.m_inc_malicspam_count) {
                    AddData32(ipdata.today.malicspam_count, 1);
                    AddToHash(incrs, TODAY_MALICSPAMCOUNT, static_cast<i64>(1)); //mongo
                    odata.m_inc_malicspam_count = true;

                    if (ipdata.today.malicspam_count <= 3)
                        odata.m_need_print_ban3log = true;
                }

                AddData32(ipdata.today.ctMalicSpam, 1);
                AddData32(ipdata.today.ctMalicSpamMail, odata.pdld.m_exportdata.mbox.MailBoxCount);
                AddToHash(incrs, TODAY_MALICSPAM, static_cast<i64>(1));                                             //mongo
                AddToHash(incrs, TODAY_MALICSPAMMAIL, static_cast<i64>(odata.pdld.m_exportdata.mbox.MailBoxCount)); //mongo
            }
            if (white_cache_value_nonempty) //INCREMENT WHITE_CACHE
            {
                AddData32(ipdata.today.ctHam, white_cache_value.m_ham_count);
                AddData32(ipdata.today.ctHamMail, white_cache_value.m_ham_mailbox_count);
                AddToHash(incrs, TODAY_HAM, static_cast<i64>(white_cache_value.m_ham_count));             //mongo
                AddToHash(incrs, TODAY_HAMMAIL, static_cast<i64>(white_cache_value.m_ham_mailbox_count)); //mongo

                AddData32(ipdata.today.ctSpam, white_cache_value.m_spam_count);
                AddData32(ipdata.today.ctSpamMail, white_cache_value.m_spam_mailbox_count);
                AddToHash(incrs, TODAY_SPAM, static_cast<i64>(white_cache_value.m_spam_count));             //mongo
                AddToHash(incrs, TODAY_SPAMMAIL, static_cast<i64>(white_cache_value.m_spam_mailbox_count)); //mongo

                AddData32(ipdata.today.ctMalicSpam, white_cache_value.m_malic_count);
                AddData32(ipdata.today.ctMalicSpamMail, white_cache_value.m_malic_mailbox_count);
                AddToHash(incrs, TODAY_MALICSPAM, static_cast<i64>(white_cache_value.m_malic_count));             //mongo
                AddToHash(incrs, TODAY_MALICSPAMMAIL, static_cast<i64>(white_cache_value.m_malic_mailbox_count)); //mongo

                AddData32(ipdata.today.malicspam_count, white_cache_value.m_malicspam_count);
                AddToHash(incrs, TODAY_MALICSPAMCOUNT, static_cast<i64>(white_cache_value.m_malicspam_count)); //mongo
            }

            if (odata.pdld.m_exportdata.m_geo.length() > 31)
                ipdata.today.geodata = odata.pdld.m_exportdata.m_geo.substr(0, 31);
            else
                ipdata.today.geodata = odata.pdld.m_exportdata.m_geo;
            sets[TODAY_GEODATA] = ipdata.today.geodata; //mongo

            //calc cps
            cpsotc = odata.m_curr_time - ipdata.today.cps_otc;
            if (cpsotc > 15) {
                tall = IncMax32(ipdata.today.ctHam, ipdata.today.ctSpam);
                tallpred = ipdata.today.cps_tall;
                if (tallpred > tall)
                    tallpred = 0;

                odata.m_cps = (float)((float)(tall - tallpred) / (float)cpsotc);
                ipdata.today.cps = odata.m_cps;

                ipdata.today.cps_otc = odata.m_curr_time;
                ipdata.today.cps_tall = tall;

                sets[TODAY_CPS] = ipdata.today.cps;          //mongo
                sets[TODAY_CPSOTC] = ipdata.today.cps_otc;   //mongo
                sets[TODAY_CPSTALL] = ipdata.today.cps_tall; //mongo

            } else
                odata.m_cps = ipdata.today.cps;

            if ((odata.m_cps > 1) && (odata.m_cps <= 5)) {
                AddData16(ipdata.today.cps5mcount, 1);
                AddToHash(incrs, TODAY_CPS5MCOUNT, static_cast<i64>(1)); //mongo

            } else if ((odata.m_cps > 5) && (odata.m_cps <= 20)) {
                AddData16(ipdata.today.cps20mcount, 1);
                AddToHash(incrs, TODAY_CPS20MCOUNT, static_cast<i64>(1)); //mongo

            } else if ((odata.m_cps > 20) && (odata.m_cps <= 50)) {
                AddData16(ipdata.today.cps50mcount, 1);
                AddToHash(incrs, TODAY_CPS50MCOUNT, static_cast<i64>(1)); //mongo

            } else if ((odata.m_cps > 50) && (odata.m_cps <= 100)) {
                AddData16(ipdata.today.cps100mcount, 1);
                AddToHash(incrs, TODAY_CPS100MCOUNT, static_cast<i64>(1)); //mongo

            } else if (odata.m_cps > 100) {
                AddData16(ipdata.today.cpsGreatmcount, 1);
                AddToHash(incrs, TODAY_CPSGREATMCOUNT, static_cast<i64>(1)); //mongo
            }

            //heavy ip - add stat
            koef = std::max(0.0f, (float)1 - (float)(((float)(odata.m_curr_time - ipdata.today.tFixDay)) / ((float)3600 * 24)));
            tmpfvar = static_cast<float>(koef) * static_cast<float>(ipdata.yesterday.ctSpam);
            summspam = IncData32(ipdata.today.ctSpam, static_cast<ui32>(tmpfvar));
            tmpfvar = static_cast<float>(koef) * static_cast<float>(ipdata.yesterday.ctHam);
            summham = IncData32(ipdata.today.ctHam, static_cast<ui32>(tmpfvar));
            tmpfvar = static_cast<float>(koef) * static_cast<float>(ipdata.yesterday.ctMalicSpam);
            summmalic = IncData32(ipdata.today.ctMalicSpam, static_cast<ui32>(tmpfvar));

            summall = IncData32(summspam, summham);
            if ((summall > 1000) && (IS_SF_FORWARD(ipdata.today.bMask)))
                isforward = true;

            if (ipdata.today.pcmb == 0)
                AddToMemStatMongo(ip, ipdata.today.ctHam, ipdata.today.ctSpam, ipdata.today.ctMalicSpam, summham, summspam, summmalic, odata.pdld.m_exportdata.ipaddresses.sourceip.m_rdns, odata.pdld.m_exportdata.ipaddresses.sourceip.m_rdns2, odata.pdld.m_exportdata.ipaddresses.sourceip.m_rdns3, odata.m_curr_time, ipdata.today.tFixDay, odata.m_cps, isforward, prfrwd_h, WhiteIp, ipdata.today.pcmb);

            //bMask
            if ((!odata.pdld.m_exportdata.m_fDSN) && (!odata.pdld.m_exportdata.m_fPop3) && (!odata.pdld.m_exportdata.m_fSMTP)) {
                i64 vt = static_cast<int>(ipdata.today.cWeightSum) + static_cast<int>(odata.pdld.m_exportdata.m_sp_wght);
                if (vt < 0)
                    ipdata.today.cWeightSum = 0;
                else if (vt > MAX16BITVALUE)
                    ipdata.today.cWeightSum = MAX16BITVALUE;
                else
                    ipdata.today.cWeightSum = vt & 0xFFFF;

                AddData16(ipdata.today.cWMess, 1);

                AddToHash(incrs, TODAY_WEIGHTSUM, static_cast<i64>(odata.pdld.m_exportdata.m_sp_wght)); //mongo
                AddToHash(incrs, TODAY_WMESS, static_cast<i64>(1));                                     //mongo
            }
            if (white_cache_value_nonempty) //INCREMENT WHITE_CACHE
            {
                AddData16(ipdata.today.cWeightSum, white_cache_value.m_cWeightSum);
                AddData16(ipdata.today.cWMess, white_cache_value.m_cWMess);

                AddToHash(incrs, TODAY_WEIGHTSUM, static_cast<i64>(white_cache_value.m_cWeightSum)); //mongo
                AddToHash(incrs, TODAY_WMESS, static_cast<i64>(white_cache_value.m_cWMess));         //mongo
            }

            //cRejected - ������������� � ������ ipmess_k.cpp � �-�� ObrabMessage(...)
            //FwdMeasure - ?
            //cBL - ?
            //cUid - ?
            AddData16(ipdata.today.cMcount, odata.pdld.m_exportdata.m_Uwl);
            AddToHash(incrs, TODAY_MCOUNT, static_cast<i64>(odata.pdld.m_exportdata.m_Uwl)); //mongo
            if (white_cache_value_nonempty)                                                  //INCREMENT WHITE_CACHE
            {
                AddData16(ipdata.today.cMcount, white_cache_value.m_cMcount);
                AddToHash(incrs, TODAY_MCOUNT, static_cast<i64>(white_cache_value.m_cMcount)); //mongo
            }

            if (odata.pdld.m_exportdata.m_fPop3 || odata.pdld.m_exportdata.m_fSMTP) {
                AddData16(ipdata.today.cPop3, 1);
                AddToHash(incrs, TODAY_POP3, static_cast<i64>(1)); //mongo
            }
            if (white_cache_value_nonempty) //INCREMENT WHITE_CACHE
            {
                AddData16(ipdata.today.cPop3, white_cache_value.m_cPop3);
                AddToHash(incrs, TODAY_POP3, static_cast<i64>(white_cache_value.m_cPop3)); //mongo
            }

            if (odata.pdld.m_exportdata.m_fDSN) {
                AddData16(ipdata.today.cDsn, 1);
                AddToHash(incrs, TODAY_DSN, static_cast<i64>(1)); //mongo
            }
            if (white_cache_value_nonempty) //INCREMENT WHITE_CACHE
            {
                AddData16(ipdata.today.cDsn, white_cache_value.m_cDsn);
                AddToHash(incrs, TODAY_DSN, static_cast<i64>(white_cache_value.m_cDsn)); //mongo
            }

            //forwards
            bool first_mail = false, first_mail2 = false;
            int mb_count = odata.pdld.m_exportdata.mbox.MailBoxCount;
            if (mb_count >= TMailBox::MBS_Max) {
                if ((LogsGroup != nullptr) && (LogsGroup->StatSrvcErrorLog() != nullptr))
                    LogsGroup->StatSrvcErrorLog()->WriteMessageAndDataStatus(KERROR, "MBOXOVERFLOW %s (cnt=%d)", ip.toStroka().c_str(), mb_count);
                mb_count = TMailBox::MBS_Max - 1;
            }
            for (int iz = 0; iz < mb_count; iz++) {
                ipdata.today.forwards.Add(odata.pdld.m_exportdata.mbox.MailBoxShingle[iz], 1, first_mail);
                if (first_mail) {
                    if (odata.pdld.m_exportdata.m_messclass == TSpClass::SPAM) {
                        AddData8(ipdata.today.SpamMailBoxCount, 1);
                        //forwards mongo ???
                    }

                    first_mail2 = true;
                }
            }

            if (!odata.pdld.m_exportdata.mSH_17_2) {
                char name[50];

                for (int ik = 0; ik < 15; ik++) {
                    if (odata.pdld.m_exportdata.parray[ik]) {
                        AddData16(ipdata.today.PANNERN_STAT[ik], 1);

                        sprintf(name, "PS%d", ik);
                        AddToHash(incrs, name, static_cast<i64>(1)); //mongo
                    }
                }
            }

            if ((!odata.pdld.m_exportdata.ipaddresses.sourceip.m_rdns.empty()) && (odata.pdld.m_exportdata.ipaddresses.sourceip.m_rdns != "-")) {
                ipdata.today.rdns = odata.pdld.m_exportdata.ipaddresses.sourceip.m_rdns;
                sets[TODAY_RDNS] = ipdata.today.rdns; //mongo
            }

            if (WhiteIp)
                SET_SF_WHITE(ipdata.today.bMask);

            if (odata.pdld.m_exportdata.m_fDsl_first) {
                SET_SF_DSL(ipdata.today.bMask);
            } else {
                ipdata.today.bMask &= (~SF_DSL);
            }

            if (odata.pdld.m_exportdata.m_fSHM)
                SET_SF_SHM(ipdata.today.bMask);

            if (odata.pdld.m_exportdata.m_frwd_pr1) //�� ���� 17
                SET_SF_VISIBLE_FRWD1(ipdata.today.bMask);
            if (odata.pdld.m_exportdata.m_frwd_pr2) //�� ���� 19
                SET_SF_VISIBLE_FRWD2(ipdata.today.bMask);

            if (odata.pdld.m_exportdata.m_fRBL && odata.pdld.m_exportdata.m_fRBL4)
                SET_SF_RBL4(ipdata.today.bMask);

            sets[TODAY_BMASK] = ipdata.today.bMask; //mongo

            ipdata.today.tLastMes = odata.m_curr_time;   //����� ��������� �������� ��������� � ������
            sets[TODAY_LASTMES] = ipdata.today.tLastMes; //mongo

            mongo_err = false;
            if (!mongo_update_ip_data(MST_MEMBASE, ip, mongo_err, sets, incrs)) {
                if (statipobj != nullptr)
                    ((TStatIPObject*)statipobj)->PrintFollowIp(ip, odata.m_rep.GetMailNumberShort().c_str(), FIE_29, "");

                if ((LogsGroup != nullptr) && (LogsGroup->MongoEventLog() != nullptr))
                    LogsGroup->MongoEventLog()->WriteMessageAndDataStatus(KERROR, "update (mAddStatMongo), ip=%s", ip.toStroka().c_str());

            } else {
                if (statipobj != nullptr)
                    ((TStatIPObject*)statipobj)->PrintFollowIp(ip, odata.m_rep.GetMailNumberShort().c_str(), FIE_30, "");
            }

            res.m_empty = false;
            res.today = TIpMemCopy(ipdata.today);
            res.yesterday = ipdata.yesterday;
            res.history = ipdata.history;
        }

    } else {
        if ((LogsGroup != nullptr) && (LogsGroup->MongoEventLog() != nullptr))
            LogsGroup->MongoEventLog()->WriteMessageAndDataStatus(KERROR, "get (mAddStatMongo), ip=%s", ip.toStroka().c_str());
    }

    return res;
}

int TMemBaseSection::mIncBan7Mongo(TKIPv6 ip, bool is_malic_spam, bool& inc_malicspam_count, bool& need_print_ban3log) {
    int res = 0;
    bool mongo_err = false;
    TMemRecord ipdata;
    bool empty = false;

    if (mongo_read_ip_data(MST_MEMBASE, ip, mongo_err, ipdata, empty)) {
        if (!empty) {
            nosql::HashMap incrs;
            nosql::HashMap sets;

            incrs.clear();
            sets.clear();

            AddData32(ipdata.today.ban7count, 1);
            AddToHash(incrs, TODAY_BAN7COUNT, static_cast<i64>(1)); //mongo

            if ((is_malic_spam) && (!inc_malicspam_count)) {
                AddData32(ipdata.today.malicspam_count, 1);
                AddToHash(incrs, TODAY_MALICSPAMCOUNT, static_cast<i64>(1)); //mongo

                if (ipdata.today.malicspam_count <= 3)
                    need_print_ban3log = true;

                inc_malicspam_count = true;
            }

            res = ipdata.today.ban7count;

            mongo_err = false;
            if (!mongo_update_ip_data(MST_MEMBASE, ip, mongo_err, sets, incrs)) {
                if ((LogsGroup != nullptr) && (LogsGroup->MongoEventLog() != nullptr))
                    LogsGroup->MongoEventLog()->WriteMessageAndDataStatus(KERROR, "update (mIncBan7Mongo), ip=%s", ip.toStroka().c_str());
            }
        }

    } else {
        if ((LogsGroup != nullptr) && (LogsGroup->MongoEventLog() != nullptr))
            LogsGroup->MongoEventLog()->WriteMessageAndDataStatus(KERROR, "get (mIncBan7Mongo), ip=%s", ip.toStroka().c_str());
    }

    return res;
}

bool TMemBaseSection::mIncMSCwFlagMongo(TKIPv6 ip, bool& inc_malicspam_count, ui16 forward, ui16 probbancriterion, ui16 bancriterion) {
    bool res = false;

    bool mongo_err = false;
    TMemRecord ipdata;
    bool empty = false;

    if (mongo_read_ip_data(MST_MEMBASE, ip, mongo_err, ipdata, empty)) {
        if (!empty) {
            nosql::HashMap incrs;
            nosql::HashMap sets;

            incrs.clear();
            sets.clear();

            if (forward > 0)
                SET_SF_FORWARD(ipdata.today.bMask);
            if (probbancriterion > 0)
                SET_SF_BAN_PROB(ipdata.today.bMask);
            if (bancriterion > 0)
                SET_SF_BAN(ipdata.today.bMask);
            sets[TODAY_BMASK] = ipdata.today.bMask; //mongo

            if (bancriterion > 0)
                incrs[TODAY_BANCOUNT] = 1; //mongo

            if (!inc_malicspam_count) {
                AddData32(ipdata.today.malicspam_count, 1);
                AddToHash(incrs, TODAY_MALICSPAMCOUNT, static_cast<i64>(1)); //mongo

                if (ipdata.today.malicspam_count <= 3)
                    res = true;

                inc_malicspam_count = true;
            }

            mongo_err = false;
            if (!mongo_update_ip_data(MST_MEMBASE, ip, mongo_err, sets, incrs)) {
                if ((LogsGroup != nullptr) && (LogsGroup->MongoEventLog() != nullptr))
                    LogsGroup->MongoEventLog()->WriteMessageAndDataStatus(KERROR, "update (mIncMSCwFlagMongo), ip=%s", ip.toStroka().c_str());
            }
        }

    } else {
        if ((LogsGroup != nullptr) && (LogsGroup->MongoEventLog() != nullptr))
            LogsGroup->MongoEventLog()->WriteMessageAndDataStatus(KERROR, "get (mIncMSCwFlagMongo), ip=%s", ip.toStroka().c_str());
    }

    return res;
}

void TMemBaseSection::mIncOnlyMalicwFlagMongo(TKIPv6 ip, ui32 mailcount, ui16 forward, ui16 probbancriterion, ui16 bancriterion) {
    bool mongo_err = false;
    TMemRecord ipdata;
    bool empty = false;

    if (mongo_read_ip_data(MST_MEMBASE, ip, mongo_err, ipdata, empty)) {
        if (!empty) {
            nosql::HashMap incrs;
            nosql::HashMap sets;

            incrs.clear();
            sets.clear();

            if (forward > 0)
                SET_SF_FORWARD(ipdata.today.bMask);
            if (probbancriterion > 0)
                SET_SF_BAN_PROB(ipdata.today.bMask);
            if (bancriterion > 0)
                SET_SF_BAN(ipdata.today.bMask);
            sets[TODAY_BMASK] = ipdata.today.bMask; //mongo

            if (bancriterion > 0)
                incrs[TODAY_BANCOUNT] = 1; //mongo

            AddData32(ipdata.today.ctMalicSpam, 1);
            AddData32(ipdata.today.ctMalicSpamMail, mailcount);
            AddToHash(incrs, TODAY_MALICSPAM, static_cast<i64>(1));             //mongo
            AddToHash(incrs, TODAY_MALICSPAMMAIL, static_cast<i64>(mailcount)); //mongo

            mongo_err = false;
            if (!mongo_update_ip_data(MST_MEMBASE, ip, mongo_err, sets, incrs)) {
                if ((LogsGroup != nullptr) && (LogsGroup->MongoEventLog() != nullptr))
                    LogsGroup->MongoEventLog()->WriteMessageAndDataStatus(KERROR, "update (mIncOnlyMalicwFlagMongo), ip=%s", ip.toStroka().c_str());
            }
        }

    } else {
        if ((LogsGroup != nullptr) && (LogsGroup->MongoEventLog() != nullptr))
            LogsGroup->MongoEventLog()->WriteMessageAndDataStatus(KERROR, "get (mIncOnlyMalicwFlagMongo), ip=%s", ip.toStroka().c_str());
    }
}

void TMemBaseSection::mGetStatBanMongo(TObrabData& odata, bool malicspamer, TTimes& DelayT, int mailcount) {
    int res = 0;
    bool mongo_err = false;
    TMemRecord ipdata;
    bool empty = false;
    TKIPv6 ip = odata.pdld.m_exportdata.ipaddresses.sourceip.m_ip;
    time_t m_curr_time = odata.m_curr_time;

    if (mongo_read_ip_data(MST_MEMBASE, ip, mongo_err, ipdata, empty)) {
        if (!empty) {
            nosql::HashMap incrs;
            nosql::HashMap sets;

            incrs.clear();
            sets.clear();

            if (empty) //first record
            {
                sets[TODAY_IP] = ip.toStroka();
                sets[TODAY_FIXDAY] = static_cast<i64>(odata.m_curr_time);
                sets[HISTORY_FIRSTDEAL] = static_cast<i64>(odata.m_curr_time);
            }

            odata.m_cmess_ban = IncMax64(odata.m_cmess_ban, 1);

            AddData16(ipdata.today.cRejected, 1);
            AddToHash(incrs, TODAY_REJECTED, static_cast<i64>(1)); //mongo

            if (malicspamer) {
                AddData32(ipdata.today.malicspam_count, 1);
                AddToHash(incrs, TODAY_MALICSPAMCOUNT, static_cast<i64>(1)); //mongo
            }

            //����������� �������� malic (�.�. ������ ������� � ��� ������ � ���� ������� �������)
            AddData32(ipdata.today.ctMalicSpam, 1);
            AddData32(ipdata.today.ctMalicSpamMail, mailcount);
            AddToHash(incrs, TODAY_MALICSPAM, static_cast<i64>(1));             //mongo
            AddToHash(incrs, TODAY_MALICSPAMMAIL, static_cast<i64>(mailcount)); //mongo

            if (odata.cMess >= 500)
                SET_SF_BAN_500(ipdata.today.bMask);

            sets[TODAY_BMASK] = ipdata.today.bMask; //mongo

            ipdata.today.tLastMes = odata.m_curr_time;                     //����� ��������� �������� ��������� � ������
            sets[TODAY_LASTMES] = static_cast<i64>(ipdata.today.tLastMes); //mongo

            mongo_err = false;
            if (!mongo_update_ip_data(MST_MEMBASE, ip, mongo_err, sets, incrs)) {
                if ((LogsGroup != nullptr) && (LogsGroup->MongoEventLog() != nullptr))
                    LogsGroup->MongoEventLog()->WriteMessageAndDataStatus(KERROR, "update (mGetStatBanMongo), ip=%s", ip.toStroka().c_str());
            }
        }

    } else {
        if ((LogsGroup != nullptr) && (LogsGroup->MongoEventLog() != nullptr))
            LogsGroup->MongoEventLog()->WriteMessageAndDataStatus(KERROR, "get (mGetStatBanMongo), ip=%s", ip.toStroka().c_str());
    }
}

bool TMemBaseSection::mClearStat(TKIPv6 ip) {
    bool res = false;
    bool mongo_err = false;
    TMemRecord ipdata;
    bool empty = false;

    if (mongo_read_ip_data(MST_MEMBASE, ip, mongo_err, ipdata, empty)) {
        if (!empty) {
            nosql::HashMap incrs;
            nosql::HashMap sets;

            incrs.clear();
            sets.clear();

            //���������� ���������� � white ip
            ipdata.today.rdns = "";
            sets[TODAY_RDNS] = ipdata.today.rdns; //mongo

            RESET_SF_WHITE(ipdata.today.bMask);
            sets[TODAY_BMASK] = ipdata.today.bMask; //mongo

            RESET_SF_WHITE(ipdata.yesterday.bMask);
            sets[YESTERDAY_BMASK] = ipdata.yesterday.bMask; //mongo

            //���������� ���������� �� �������
            ipdata.history.cDaysRej = 0;
            sets[HISTORY_DAYSREJ] = ipdata.history.cDaysRej; //mongo

            //ipdata.history.cDaysNoRej = 0;
            //sets[ HISTORY_DAYSNOREJ ] = ipdata.history.cDaysNoRej;          //mongo

            ipdata.history.cManualBanCount = 0;
            sets[HISTORY_MANUALBANCOUNT] = ipdata.history.cManualBanCount; //mongo

            mongo_err = false;
            if (!mongo_update_ip_data(MST_MEMBASE, ip, mongo_err, sets, incrs)) {
                if ((LogsGroup != nullptr) && (LogsGroup->MongoEventLog() != nullptr))
                    LogsGroup->MongoEventLog()->WriteMessageAndDataStatus(KERROR, "update (mClearStat), ip=%s", ip.toStroka().c_str());

            } else {
                res = true;
            }
        }

    } else {
        if ((LogsGroup != nullptr) && (LogsGroup->MongoEventLog() != nullptr))
            LogsGroup->MongoEventLog()->WriteMessageAndDataStatus(KERROR, "get (mClearStat), ip=%s", ip.toStroka().c_str());
    }

    return res;
}

ui32 TMemBaseSection::mCheckMemBasa(TKIPv6 ip, time_t m_curr_time, bool& diskwrite, const TString& id, TDiffCounter* changeday1_counter, TDiffCounter* changeday2_counter) {
    ui32 res = CShingleTime::GetMs();
    bool mongo_err = false;
    bool mongo_empty = false;
    TMemRecord ipdata;
    bool resm = false;

    resm = mongo_read_ip_data(MST_MEMBASE, ip, mongo_err, ipdata, mongo_empty);
    if (resm) {
        if (!mongo_empty)
            resm = mongo_check_mem_basa(ip, static_cast<i64>(m_curr_time), ipdata, id, changeday1_counter, changeday2_counter);

    } else {
        if ((LogsGroup != nullptr) && (LogsGroup->MongoEventLog() != nullptr))
            LogsGroup->MongoEventLog()->WriteMessageAndDataStatus(KERROR, "get (mCheckMemBasa), ip=%s", ip.toStroka().c_str());
    }

    res = CShingleTime::GetMs() - res;

    return res;
}

void TMemBaseSection::mSetBanNow(TKIPv6 ip, bool bannow) {
    if (bannow > 0) {
        bool mongo_err = false;
        TMemRecord ipdata;
        bool empty = false;

        if (mongo_read_ip_data(MST_MEMBASE, ip, mongo_err, ipdata, empty)) {
            if (!empty) {
                nosql::HashMap incrs;
                nosql::HashMap sets;

                incrs.clear();
                sets.clear();

                SET_SF_BAN_WOW(ipdata.today.bMask);
                SET_SF_WAS_BAN_WOW(ipdata.today.bMask);

                sets[TODAY_BMASK] = ipdata.today.bMask; //mongo

                incrs[TODAY_MANUALBANCOUNT] = 1;
                incrs[HISTORY_MANUALBANCOUNT] = 1;

                mongo_err = false;
                if (!mongo_update_ip_data(MST_MEMBASE, ip, mongo_err, sets, incrs)) {
                    if ((LogsGroup != nullptr) && (LogsGroup->MongoEventLog() != nullptr))
                        LogsGroup->MongoEventLog()->WriteMessageAndDataStatus(KERROR, "update (mSetBanNow), ip=%s", ip.toStroka().c_str());
                }
            }

        } else {
            if ((LogsGroup != nullptr) && (LogsGroup->MongoEventLog() != nullptr))
                LogsGroup->MongoEventLog()->WriteMessageAndDataStatus(KERROR, "get (mSetBanNow), ip=%s", ip.toStroka().c_str());
        }
    }
}

void TMemBaseSection::mClearBanToday(TKIPv6 ip) {
    bool mongo_err = false;
    TMemRecord ipdata;
    bool empty = false;

    if (mongo_read_ip_data(MST_MEMBASE, ip, mongo_err, ipdata, empty)) {
        if (!empty) {
            nosql::HashMap incrs;
            nosql::HashMap sets;

            incrs.clear();
            sets.clear();

            RESET_SF_BAN(ipdata.today.bMask);
            RESET_SF_BAN_WOW(ipdata.today.bMask);

            sets[TODAY_BMASK] = ipdata.today.bMask; //mongo

            mongo_err = false;
            if (!mongo_update_ip_data(MST_MEMBASE, ip, mongo_err, sets, incrs)) {
                if ((LogsGroup != nullptr) && (LogsGroup->MongoEventLog() != nullptr))
                    LogsGroup->MongoEventLog()->WriteMessageAndDataStatus(KERROR, "update (mClearBanToday), ip=%s", ip.toStroka().c_str());
            }
        }

    } else {
        if ((LogsGroup != nullptr) && (LogsGroup->MongoEventLog() != nullptr))
            LogsGroup->MongoEventLog()->WriteMessageAndDataStatus(KERROR, "get (mClearBanToday), ip=%s", ip.toStroka().c_str());
    }
}

TString TMemBaseSection::GetFirstDslRPS() {
    TString res = "";
    TKIPv6 ip = TKIPv6("1.1.1.1");
    bool mongo_err = false;
    TDSLRps data;
    bool empty = true;

    if (mongo_read_rps(ip, mongo_err, data, empty)) {
        if (empty) {
            res = "data empty";

        } else {
            ui32 currenttime = time(nullptr);
            ui32 diff = 0;

            if (currenttime >= data.m_calctime) {
                diff = currenttime - data.m_calctime;
                res = FloatToStr(data.m_rps) + " (calc to " + TimeToStr(data.m_calctime) + ", elapsed " + IntToHourMinSec(diff) + ", cnt=" + IntToStroka(data.m_count) + ")";

            } else {
                res = "error calc";
            }
        }

    } else {
        res = "storage error";
    }

    return res;
}

float TMemBaseSection::CalcFirstDslRPS() {
    float res = 0;
    TKIPv6 ip = TKIPv6("1.1.1.1");
    bool mongo_err = false;
    TDSLRps data;
    bool empty = true;
    ui32 currenttime = time(nullptr);
    ui32 tdiff = 0;
    nosql::HashMap incrs;
    nosql::HashMap sets;

    if (mongo_read_rps(ip, mongo_err, data, empty)) {
        incrs.clear();
        sets.clear();

        if (empty) {
            sets[DSLRPS_RPS] = 0;
            sets[DSLRPS_CALCTIME] = currenttime;
            sets[DSLRPS_COUNT] = 1;
            sets[DSLRPS_PR_CMB] = 0;

            mongo_err = false;
            if (!mongo_update_rps(ip, mongo_err, sets, incrs)) {
                if ((LogsGroup != nullptr) && (LogsGroup->MongoEventLog() != nullptr))
                    LogsGroup->MongoEventLog()->WriteMessageAndDataStatus(KERROR, "update empty (CalcFirstDslRPS)");
            }

            res = 0;

        } else {
            if (currenttime >= data.m_calctime) {
                res = data.m_rps;

                tdiff = currenttime - data.m_calctime;
                if (tdiff >= 60) {
                    nosql::HashMap hash;
                    bool update_check = false;

                    sets[DSLRPS_CALCTIME] = currenttime;
                    sets[DSLRPS_PR_CMB] = 1;

                    //��������:
                    //ip ����� ������ ����� calctime
                    //���� � �������� ������ calctime �� �����, � ���������� ������ �� ������ calctime (�������� getnew)
                    //���� ������������ �������� calctime ����� ������� ������� calctime, ������ ���� ����� ������ �����, ������� ���������� ����� ���������
                    //���� ������������ �������� calctime ����� ������ ������� calctime, �� rps ������ �� ������, �.�. ������ ����� ��� ������� �������� ��� ����� �� ���, � �� ����� ������ rps

                    // It's an db AtomicSet to be sure that only one thread (of all processes) passes that if
                    mongo_err = false;
                    update_check = mongo_findandmodify_rps(ip, mongo_err, incrs, sets, hash, false);

                    nosql::HashMap value = hash["value"].Hash();
                    if (update_check) {
                        update_check = value[DSLRPS_CALCTIME].Long() == static_cast<i64>(data.m_calctime);
                        if (update_check) //calc new rps and write to storage
                        {
                            double rps = static_cast<double>(data.m_count) / static_cast<double>(tdiff);

                            sets[DSLRPS_RPS] = rps;
                            sets[DSLRPS_CALCTIME] = currenttime;
                            sets[DSLRPS_COUNT] = 1;
                            sets[DSLRPS_PR_CMB] = 0;

                            mongo_err = false;
                            if (!mongo_update_rps(ip, mongo_err, sets, incrs)) {
                                if ((LogsGroup != nullptr) && (LogsGroup->MongoEventLog() != nullptr))
                                    LogsGroup->MongoEventLog()->WriteMessageAndDataStatus(KERROR, "update calc rps (CalcFirstDslRPS)");
                            }

                            res = rps;
                        }
                    }

                } else {
                    incrs[DSLRPS_COUNT] = 1;

                    mongo_err = false;
                    if (!mongo_update_rps(ip, mongo_err, sets, incrs)) {
                        if ((LogsGroup != nullptr) && (LogsGroup->MongoEventLog() != nullptr))
                            LogsGroup->MongoEventLog()->WriteMessageAndDataStatus(KERROR, "update incrs (CalcFirstDslRPS)");
                    }
                }

            } else {
                tdiff = data.m_calctime - currenttime;
                if (tdiff > 30) {
                    if ((LogsGroup != nullptr) && (LogsGroup->MongoEventLog() != nullptr))
                        LogsGroup->MongoEventLog()->WriteMessageAndDataStatus(KWARNING, "find bad time (CalcFirstDslRPS)");

                    sets[DSLRPS_RPS] = 0;
                    sets[DSLRPS_CALCTIME] = currenttime;
                    sets[DSLRPS_COUNT] = 1;

                    mongo_err = false;
                    if (!mongo_update_rps(ip, mongo_err, sets, incrs)) {
                        if ((LogsGroup != nullptr) && (LogsGroup->MongoEventLog() != nullptr))
                            LogsGroup->MongoEventLog()->WriteMessageAndDataStatus(KERROR, "update bad time (CalcFirstDslRPS)");
                    }
                }
                res = 0;
            }
        }

    } else {
        if ((LogsGroup != nullptr) && (LogsGroup->MongoEventLog() != nullptr))
            LogsGroup->MongoEventLog()->WriteMessageAndDataStatus(KERROR, "get (CalcFirstDslRPS)");
    }

    return res;
}

TIpStatOne TMemBaseSection::GetIpStat(TKIPv6 ip) {
    TIpStatOne res;
    bool mongo_err = false;
    TMemRecord ipdata;
    bool empty = false;

    if (mongo_read_ip_data(MST_MEMBASE, ip, mongo_err, ipdata, empty)) {
        if (!empty) {
            //today
            res.notfound = false;
            res.Spam = ipdata.today.ctSpam;
            res.Ham = ipdata.today.ctHam;
            res.MalicSpam = ipdata.today.ctMalicSpam;
            res.SpamMail = ipdata.today.ctSpamMail;
            res.HamMail = ipdata.today.ctHamMail;
            res.MalicSpamMail = ipdata.today.ctMalicSpamMail;
            res.Pop3 = ipdata.today.cPop3;
            res.Dsn = ipdata.today.cDsn;
            res.Rejected = ipdata.today.cRejected;
            res.Mcount = ipdata.today.cMcount;
            res.bMask = ipdata.today.bMask;
            res.tLastMes = ipdata.today.tLastMes;
            res.frwds = TString(ipdata.today.forwards.GetForwardsData().forward_comments);
            res.tFixDay = ipdata.today.tFixDay;
            res.rdns = ipdata.today.rdns;
            res.malicspamer_count = ipdata.today.malicspam_count;
            res.cps = ipdata.today.cps;
            res.ban7count = ipdata.today.ban7count;
            if (ipdata.today.forwards.GetBoxCount() > 0)
                res.prSpamMailBox = (float)ipdata.today.SpamMailBoxCount / (float)ipdata.today.forwards.GetBoxCount() * (float)100;
            res.geo = ipdata.today.geodata;
            res.manual_ban_count = ipdata.today.manual_ban_count;
            res.ban_count = ipdata.today.ban_count;
            //res.ManualBanCount    = ipdata.today.ManualBanCount;

            //yesterday
            res.yctSpam = ipdata.yesterday.ctSpam;
            res.yctHam = ipdata.yesterday.ctHam;
            res.yctMalicSpam = ipdata.yesterday.ctMalicSpam;
            res.yctSpamMail = ipdata.yesterday.ctSpamMail;
            res.yctHamMail = ipdata.yesterday.ctHamMail;
            res.yctMalicSpamMail = ipdata.yesterday.ctMalicSpamMail;
            res.ycPop3 = ipdata.yesterday.cPop3;
            res.ycDsn = ipdata.yesterday.cDsn;
            res.ycRejected = ipdata.yesterday.cRejected;
            res.ycMcount = ipdata.yesterday.cMcount;
            res.ybMask = ipdata.yesterday.bMask;
            res.ycWeightSum = ipdata.yesterday.cWeightSum;
            res.ycWMess = ipdata.yesterday.cWMess;
            //res.yManualBanCount    = ipdata.yesterday.cManualBanCount;

            //history
            res.htFirstDeal = ipdata.history.tFirstDeal;
            res.htLastMes = ipdata.history.tLastMes;
            res.hctSpam = ipdata.history.ctSpam;
            res.hctHam = ipdata.history.ctHam;
            res.hctMalicSpam = ipdata.history.ctMalicSpam;
            res.hcDsn = ipdata.history.cDsn;
            res.hPop3_Auth = ipdata.history.cPop3_Auth;
            res.hDaysRej = ipdata.history.cDaysRej;
            res.hDaysNoRej = ipdata.history.cDaysNoRej;
            res.hFwdDays = ipdata.history.cFwdDays;
            res.hManualBanCount = ipdata.history.cManualBanCount;
        }

    } else {
        if ((LogsGroup != nullptr) && (LogsGroup->MongoEventLog() != nullptr))
            LogsGroup->MongoEventLog()->WriteMessageAndDataStatus(KERROR, "get (GetIpStat), ip=%s", ip.toStroka().c_str());
    }

    return res;
}

ui32 TMemBaseSection::mGetMembasaSize() {
    ui32 res = 0;
    i64 size_v = 0;

    size_v = mongo_basa_size(MST_MEMBASE);
    if (size_v < 0)
        res = 0;
    else if (size_v > 0xFFFFFFFF)
        res = 0xFFFFFFFF;
    else
        res = static_cast<ui32>(size_v);

    return res;
}

bool TMemBaseSection::SendTailsByWhiteIP(TKIPv6 ip, TWeightIPLocalCacheItem* diffdata, TDiffCounter* changeday1_counter, TDiffCounter* changeday2_counter) {
    bool res = true;

    if ((diffdata != nullptr) && (diffdata->diff.m_count > 0)) {
        bool mongo_err = false;
        bool mongo_empty = false;
        TMemRecord ipdata;
        bool resm = false;
        time_t curr_time = time(nullptr);

        resm = mongo_read_ip_data(MST_MEMBASE, ip, mongo_err, ipdata, mongo_empty);
        if (resm) {
            if (!mongo_empty)
                resm = mongo_check_mem_basa(ip, static_cast<i64>(curr_time), ipdata, "SendTailsByWhiteIP", changeday1_counter, changeday2_counter);

            if (resm) {
                nosql::HashMap incrs;
                nosql::HashMap sets;
                TWeightIPLocalCacheDiff white_cache_value;
                bool white_cache_value_nonempty = false;

                incrs.clear();
                sets.clear();

                if (mongo_empty) //first record
                {
                    sets[TODAY_IP] = ip.toStroka();
                    sets[TODAY_FIXDAY] = static_cast<i64>(curr_time);
                    sets[HISTORY_FIRSTDEAL] = static_cast<i64>(curr_time);
                }

                if (diffdata != nullptr) {
                    white_cache_value = diffdata->diff;
                    white_cache_value_nonempty = true;
                }

                if (white_cache_value_nonempty) //INCREMENT WHITE_CACHE
                {
                    AddData32(ipdata.today.ctHam, white_cache_value.m_ham_count);
                    AddData32(ipdata.today.ctHamMail, white_cache_value.m_ham_mailbox_count);
                    AddToHash(incrs, TODAY_HAM, static_cast<i64>(white_cache_value.m_ham_count));             //mongo
                    AddToHash(incrs, TODAY_HAMMAIL, static_cast<i64>(white_cache_value.m_ham_mailbox_count)); //mongo

                    AddData32(ipdata.today.ctSpam, white_cache_value.m_spam_count);
                    AddData32(ipdata.today.ctSpamMail, white_cache_value.m_spam_mailbox_count);
                    AddToHash(incrs, TODAY_SPAM, static_cast<i64>(white_cache_value.m_spam_count));             //mongo
                    AddToHash(incrs, TODAY_SPAMMAIL, static_cast<i64>(white_cache_value.m_spam_mailbox_count)); //mongo

                    AddData32(ipdata.today.ctMalicSpam, white_cache_value.m_malic_count);
                    AddData32(ipdata.today.ctMalicSpamMail, white_cache_value.m_malic_mailbox_count);
                    AddToHash(incrs, TODAY_MALICSPAM, static_cast<i64>(white_cache_value.m_malic_count));             //mongo
                    AddToHash(incrs, TODAY_MALICSPAMMAIL, static_cast<i64>(white_cache_value.m_malic_mailbox_count)); //mongo

                    AddData32(ipdata.today.malicspam_count, white_cache_value.m_malicspam_count);
                    AddToHash(incrs, TODAY_MALICSPAMCOUNT, static_cast<i64>(white_cache_value.m_malicspam_count)); //mongo

                    AddData16(ipdata.today.cWeightSum, white_cache_value.m_cWeightSum);
                    AddData16(ipdata.today.cWMess, white_cache_value.m_cWMess);
                    AddToHash(incrs, TODAY_WEIGHTSUM, static_cast<i64>(white_cache_value.m_cWeightSum)); //mongo
                    AddToHash(incrs, TODAY_WMESS, static_cast<i64>(white_cache_value.m_cWMess));         //mongo

                    AddData16(ipdata.today.cMcount, white_cache_value.m_cMcount);
                    AddToHash(incrs, TODAY_MCOUNT, static_cast<i64>(white_cache_value.m_cMcount)); //mongo

                    AddData16(ipdata.today.cPop3, white_cache_value.m_cPop3);
                    AddToHash(incrs, TODAY_POP3, static_cast<i64>(white_cache_value.m_cPop3)); //mongo

                    AddData16(ipdata.today.cDsn, white_cache_value.m_cDsn);
                    AddToHash(incrs, TODAY_DSN, static_cast<i64>(white_cache_value.m_cDsn)); //mongo

                    ipdata.today.tLastMes = curr_time;                             //����� ��������� �������� ��������� � ������
                    sets[TODAY_LASTMES] = static_cast<i64>(ipdata.today.tLastMes); //mongo

                    mongo_err = false;
                    if (!mongo_update_ip_data(MST_MEMBASE, ip, mongo_err, sets, incrs)) {
                        if ((LogsGroup != nullptr) && (LogsGroup->MongoEventLog() != nullptr))
                            LogsGroup->MongoEventLog()->WriteMessageAndDataStatus(KERROR, "update (SendTailsByWhiteIP), ip=%s", ip.toStroka().c_str());
                    }
                }
            }

        } else {
            if ((LogsGroup != nullptr) && (LogsGroup->MongoEventLog() != nullptr))
                LogsGroup->MongoEventLog()->WriteMessageAndDataStatus(KERROR, "get (SendTailsByWhiteIP), ip=%s", ip.toStroka().c_str());
        }
    }

    return res;
}

TLocalCacheStat TMemBaseSection::GetHeavyLocalCacheStat() {
    return cache_info;
}

void TMemBaseSection::SetNeedUpdateLocalCache() {
    m_MemStatMutex.Acquire();

    if (!cache_info.m_need_update_cache) {
        cache_info.m_need_update_cache = true;
        cache_info.m_start_update_time = time(nullptr);
        if (memstat_cache != nullptr) {
            delete memstat_cache;
            memstat_cache = nullptr;
        }
    }

    m_MemStatMutex.Release();
}

void TMemBaseSection::ReadHeavyFromStorage() {
    ui32 tick = 0;
    ui32 waittime = 0;
    TVector<nosql::HashMap> hashes;
    TIpStat ipdata;
    TKIPv6 ip;
    ui32 record_count = 0;
    ui32 current_time = 0;

    tick = CShingleTime::GetMs();
    waittime = time(nullptr) - cache_info.m_start_update_time;

    if (mongo_find(MST_MEMSTAT, hashes)) {
        m_MemStatMutex.Acquire();

        if ((memstat_cache != nullptr) && (memstat_cache->size() > 0)) {
            delete memstat_cache;
            memstat_cache = nullptr;
        }
        if (memstat_cache == nullptr) {
            memstat_cache = new TCacheMemStat();
            cache_info.m_create_time = time(nullptr);
        }

        current_time = time(nullptr);
        for (size_t i = 0; i < hashes.size(); i++) {
            //Preload( Serialization::IdToKey( hashes[ i ][ "_id" ].String() ), hashes[ i ] );
            ipdata.Clear();
            ip = TIpStatSerialization::IdToKey(hashes[i]["_id"].String());
            TIpStatSerialization::Deserialize(hashes[i], ipdata);

            record_count = IncMax32(record_count, 1);

            if (memstat_cache != nullptr) //copy to local cache
            {
                if (current_time > ipdata.last_update) {
                    if ((current_time - ipdata.last_update) > 15)
                        ipdata.cps = 0;

                } else {
                    ipdata.cps = 0;
                }
                (*memstat_cache)[ip] = ipdata;
            }
        }

        cache_info.m_need_update_cache = false;

        m_MemStatMutex.Release();

    } else {
        if ((LogsGroup != nullptr) && (LogsGroup->MongoEventLog() != nullptr))
            LogsGroup->MongoEventLog()->WriteMessageAndDataStatus(KERROR, "find (ReadHeavyFromStorage)");
    }

    tick = CShingleTime::GetMs() - tick;

    if ((LogsGroup != nullptr) && (LogsGroup->GetServerLog() != nullptr))
        LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "PRINTMEMSTAT: Receive heavy host statistik from storage to %u msec (wait %s).", tick, GetTimePeriod(waittime).c_str());
}

void TMemBaseSection::CleanupHeavyStorage() {
    for (int i = 0; i < 5; i++) {
        ui32 tick = 0;
        TVector<nosql::HashMap> hashes;
        TIpStat ipdata;
        TKIPv6 ip;
        ui32 record_count = 0;
        time_t current_time = time(nullptr);
        ui32 time_diff = 0;
        ui32 erase_count = 0;
        ui32 erase_failed_count = 0;
        bool mongo_err = false;
        bool failed_all = false;

        tick = CShingleTime::GetMs();

        if (mongo_find(MST_MEMSTAT, hashes)) {
            for (size_t i = 0; i < hashes.size(); i++) {
                ipdata.Clear();
                ip = TIpStatSerialization::IdToKey(hashes[i]["_id"].String());
                TIpStatSerialization::Deserialize(hashes[i], ipdata);

                record_count = IncMax32(record_count, 1);

                if (current_time > ipdata.last_update) {
                    time_diff = current_time - ipdata.last_update;
                    if (time_diff >= MEMSTAT_CLEANUP_PERIOD) {
                        mongo_err = false;
                        if (mongo_erase(MST_MEMSTAT, ip, mongo_err)) {
                            erase_count = IncMax32(erase_count, 1);

                        } else {
                            erase_failed_count = IncMax32(erase_failed_count, 1);
                            if ((LogsGroup != nullptr) && (LogsGroup->MongoEventLog() != nullptr))
                                LogsGroup->MongoEventLog()->WriteMessageAndDataStatus(KERROR, "erase (CleanupHeavyStorage), ip=", ip.toStroka().c_str());
                        }
                    }
                }
            }

            failed_all = false;

        } else {
            failed_all = true;
            if ((LogsGroup != nullptr) && (LogsGroup->MongoEventLog() != nullptr))
                LogsGroup->MongoEventLog()->WriteMessageAndDataStatus(KERROR, "find (CleanupHeavyStorage)");
        }

        tick = CShingleTime::GetMs() - tick;

        if ((LogsGroup != nullptr) && (LogsGroup->GetServerLog() != nullptr)) {
            if (failed_all)
                LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "MEMSTAT: cleanup memstat storage FAILED(%d)!", i + 1);
            else
                LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "MEMSTAT: cleanup memstat storage to %u msec (all_count=%u, erase_count=%u, erase_failed=%u).", tick, record_count, erase_count, erase_failed_count);
            LogsGroup->GetServerLog()->FFlush();
        }

        if (failed_all) {
            sleep(3);

        } else {
            break;
        }
    }
}

bool TMemBaseSection::NeedUpdateLocalCache() {
    bool res = false;
    ui32 timediff = 0;

    timediff = time(nullptr) - cache_info.m_create_time;
    if ((memstat_cache == nullptr) || (timediff >= TMemBaseSection::LOCAL_CACHE_PERIOD_SEC))
        res = true;

    return res;
}

bool TMemBaseSection::GetHeavyMemStat(int sorttype, TMemList& memlist, bool enableexclude, ui32 mincount, ui32 maxlastsec, bool adddata_to_filename, bool excludeforward, ui32 maxrecord, TIpType typeip, TWhtIp whtip, TLocalCacheStat& storinfo, bool needstor, ui32& sorttime) {
    bool res = false;

    if ((needstor) || (NeedUpdateLocalCache()))
        ReadHeavyFromStorage();

    res = GetHeavyMemStatLocalCache(sorttype, memlist, enableexclude, mincount, maxlastsec, adddata_to_filename, excludeforward, maxrecord, typeip, whtip, storinfo.m_count, sorttime);
    storinfo.m_create_time = cache_info.m_create_time;
    storinfo.m_is_local_cache = true;

    return res;
}

bool TMemBaseSection::GetHeavyMemStatLocalCache(int sorttype, TMemList& memlist, bool enableexclude, ui32 mincount, ui32 maxlastsec, bool adddata_to_filename, bool excludeforward, ui32 maxrecord, TIpType typeip, TWhtIp whtip, ui32& record_count, ui32& sorttime) {
    bool res = false;
    int exclude = 0;
    TCacheMemStatIt it;
    char sip[32];
    TString rdns = "";
    TString lastreg = "";
    TString lastfix = "";
    TString scps = "";
    time_t t = time(nullptr);
    TString st1 = "";
    bool bt2 = false;

    record_count = 0;
    sorttime = 0;
    memlist.clear();
    if (memstat_cache != nullptr) {
        m_MemStatMutex.Acquire();

        if (memstat_cache != nullptr) {
            it = memstat_cache->begin();
            while (it != memstat_cache->end()) {
                record_count = IncMax32(record_count, 1);
                //����������� �� ���� ip (ipv6 ��� ipv4)
                if ((typeip == IPv4) && ((*it).first.IsIPv6())) {
                    ++it;
                    continue;
                }
                if ((typeip == IPv6) && ((*it).first.IsIPv4())) {
                    ++it;
                    continue;
                }

                //����������� white/�� white ip
                st1 = (*it).first.toStroka();
                bt2 = (*it).second.white_pr;
                if ((whtip == WHTNO) && ((*it).second.white_pr != WHTNO)) {
                    ++it;
                    continue;
                }
                if ((whtip == WHTYES) && ((*it).second.white_pr != WHTYES)) {
                    ++it;
                    continue;
                }

                TString ips = (*it).first.toStroka();
                TIpStat ipstat = (*it).second;

                // TODO: Hm, where is m_excludestat?
                /*           if ((enableexclude) && (m_excludestat != nullptr))
              {
                     exclude = m_excludestat->FindBad((*it).second.rdns2.c_str());
                     exclude |= m_excludestat->FindBad((*it).second.rdns3.c_str());
                     if (exclude > 0)
                     {
                        ++it;
                        continue;
                     }
              }*/

                ui32 summ_sh_count = 0;
                summ_sh_count = IncMax32(summ_sh_count, (*it).second.ctHam);
                summ_sh_count = IncMax32(summ_sh_count, (*it).second.ctSpam);
                summ_sh_count = IncMax32(summ_sh_count, (*it).second.ctMalicSpam);
                if ((mincount > 0) && (mincount > summ_sh_count)) {
                    ++it;
                    continue;
                }
                if ((maxlastsec > 0) && ((t - (*it).second.last_update) > maxlastsec)) {
                    ++it;
                    continue;
                }
                if (excludeforward && (*it).second.forwards) {
                    ++it;
                    continue;
                }
                //TODO: �������� cps, ���� �� ������� ���������� ���������� ������ ������ ������ 15 ���
                //if ((t - (*it).second.last_update) > 15)
                //   (*it).second.cps = 0;

                //���������
                memlist.push_back(TIpStatEx((*it).first, (*it).second, sorttype));
                ++it;
            }
        }
        m_MemStatMutex.Release();
    }
    sorttime = CShingleTime::GetMs();
    memlist.sort();
    sorttime = CShingleTime::GetMs() - sorttime;
    res = true;

    return res;
}

ui32 TMemBaseSection::GetHeavyMemCount() {
    ui32 res = 0;
    i64 size_v = 0;

    size_v = mongo_basa_size(MST_MEMSTAT);
    if (size_v < 0)
        res = 0;
    else if (size_v > 0xFFFFFFFF)
        res = 0xFFFFFFFF;
    else
        res = static_cast<ui32>(size_v);

    return res;
}

//***************************************************************************************
//                                 TMemBaseMain
//***************************************************************************************

TMemBaseMain::TMemBaseMain() {
    statipobj = nullptr;
    LogsGroup = nullptr;
}

TMemBaseMain::~TMemBaseMain() {
}

void TMemBaseMain::Init(void* statipobjA, TLogsGroup* LogsGroupA, TKConfig* configobjA) {
    statipobj = statipobjA;
    LogsGroup = LogsGroupA;
    MemSection.Init(statipobj, LogsGroupA, configobjA);
}

void TMemBaseMain::Midnight() {
    MemSection.Midnight();
}

void TMemBaseMain::EventTick() {
    MemSection.EventTick();
}

void TMemBaseMain::WriteThreadIDToLog() {
    int thread_id = -1;

#ifndef _win_
    thread_id = syscall(SYS_gettid);
#endif

    if ((LogsGroup != nullptr) && (LogsGroup->GetDebugInfoLog() != nullptr))
        LogsGroup->GetDebugInfoLog()->WriteMessageAndDataStatus(KMESSAGE, "THREADID % 9d: MEMBASAMAIN(READDISKBASA)", thread_id);
}

void TMemBaseMain::GetNewRecordCount(ui64& today, ui64& yesterday) {
    ui64 today_t = 0;
    ui64 yesterday_t = 0;

    today = 0;
    yesterday = 0;

    MemSection.GetNewRecordCount(today_t, yesterday_t);

    today = IncMax64(today, today_t);
    yesterday = IncMax64(yesterday, yesterday_t);
}

TMemRecordCopy TMemBaseMain::mAddStatMongo(int& index, TKIPv6 ip, T_enum_ip_level stattype, int* pIpSpam, bool& WhiteIp, TTimes& DelayT, TObrabData& odata, TWhiteIPLocalCache* whiteip_cache, TDiffCounter* changeday1_counter, TDiffCounter* changeday2_counter) {
    return MemSection.mAddStatMongo(ip, stattype, pIpSpam, WhiteIp, DelayT, odata, whiteip_cache, changeday1_counter, changeday2_counter);
}

int TMemBaseMain::mIncBan7Mongo(TKIPv6 ip, bool is_malic_spam, bool& inc_malicspam_count, bool& need_print_ban3log) {
    return MemSection.mIncBan7Mongo(ip, is_malic_spam, inc_malicspam_count, need_print_ban3log);
}

bool TMemBaseMain::mIncMSCwFlagMongo(TKIPv6 ip, bool& inc_malicspam_count, ui16 forward, ui16 probbancriterion, ui16 bancriterion) {
    return MemSection.mIncMSCwFlagMongo(ip, inc_malicspam_count, forward, probbancriterion, bancriterion);
}

void TMemBaseMain::mIncOnlyMalicwFlagMongo(TKIPv6 ip, ui32 mailcount, ui16 forward, ui16 probbancriterion, ui16 bancriterion) {
    return MemSection.mIncOnlyMalicwFlagMongo(ip, mailcount, forward, probbancriterion, bancriterion);
}

void TMemBaseMain::mGetStatBanMongo(TObrabData& odata, bool malicspamer, TTimes& DelayT, int mailcount) {
    MemSection.mGetStatBanMongo(odata, malicspamer, DelayT, mailcount);
}

bool TMemBaseMain::mClearStat(TKIPv6 ip) {
    return MemSection.mClearStat(ip);
}

ui32 TMemBaseMain::mCheckMemBasa(TKIPv6 ip, time_t m_curr_time, bool& diskwrite, const TString& id, TDiffCounter* changeday1_counter, TDiffCounter* changeday2_counter) {
    return MemSection.mCheckMemBasa(ip, m_curr_time, diskwrite, id, changeday1_counter, changeday2_counter);
}

void TMemBaseMain::mSetBanNow(TKIPv6 ip, bool bannow) {
    MemSection.mSetBanNow(ip, bannow);
}

void TMemBaseMain::mClearBanToday(TKIPv6 ip) {
    MemSection.mClearBanToday(ip);
}

TString TMemBaseMain::GetFirstDslRPS() {
    return MemSection.GetFirstDslRPS();
}

float TMemBaseMain::CalcFirstDslRPS() {
    return MemSection.CalcFirstDslRPS();
}

TIpStatOne TMemBaseMain::GetIpStat(TKIPv6 ip) {
    return MemSection.GetIpStat(ip);
}

ui32 TMemBaseMain::mGetMembasaSize() {
    return MemSection.mGetMembasaSize();
}

bool TMemBaseMain::SendTailsByWhiteIP(TKIPv6 ip, TWeightIPLocalCacheItem* diffdata, TDiffCounter* changeday1_counter, TDiffCounter* changeday2_counter) {
    return MemSection.SendTailsByWhiteIP(ip, diffdata, changeday1_counter, changeday2_counter);
}

TLocalCacheStat TMemBaseMain::GetHeavyLocalCacheStat() {
    return MemSection.GetHeavyLocalCacheStat();
}

bool TMemBaseMain::NeedUpdateLocalCache() {
    return MemSection.NeedUpdateLocalCache();
}

void TMemBaseMain::SetNeedUpdateLocalCache() {
    MemSection.SetNeedUpdateLocalCache();
}

bool TMemBaseMain::GetHeavyMemStat(int sorttype, TMemList& memlist, bool enableexclude, ui32 mincount, ui32 maxlastsec, bool adddata_to_filename, bool excludeforward, ui32 maxrecord, TIpType typeip, TWhtIp whtip, TLocalCacheStat& storinfo, bool needstor, ui32& sorttime) {
    return MemSection.GetHeavyMemStat(sorttype, memlist, enableexclude, mincount, maxlastsec, adddata_to_filename, excludeforward, maxrecord, typeip, whtip, storinfo, needstor, sorttime);
}

ui32 TMemBaseMain::GetHeavyMemCount() {
    return MemSection.GetHeavyMemCount();
}

//***************************************************************************************
