#pragma once

#include "util/system/mutex.h"
#include "util/generic/hash.h"
#include "util/system/thread.h"
#include <mail/so/spamstop/tools/so-common/kfunc.h>
#include "tstatiptypes.h"
#include "tbasesstore_types.h"
#include "tlogsgroup.h"
#include "tstoragenosql.h"
#include <mail/so/spamstop/tools/so-common/ttrafficcontrol.h>

//***************************************************************************************
//                            THistoryBasa
//***************************************************************************************

class THistoryBasa {
private:
public:
    THistoryBasa();
    ~THistoryBasa();

    bool dWriteBlock(TKIPv6 ip, TIpDisk& value);
    bool dWriteBlockQueue(TKIPv6 ip, TIpDisk& value);
    bool dReadBlock(TKIPv6 ip, TIpDisk& value);
};

//***************************************************************************************
//                                  TReadIPDiskQueue
//***************************************************************************************

struct TReadIPDiskQueueStat {
    ui32 m_today_count;
    ui64 m_today_in_count;
    ui64 m_today_out_count;
    ui64 m_today_lost_count;
    ui64 m_yesterday_in_count;
    ui64 m_yesterday_out_count;
    ui64 m_yesterday_lost_count;
    float m_cps;

    TReadIPDiskQueueStat() {
        m_today_count = 0;
        m_today_in_count = 0;
        m_today_out_count = 0;
        m_today_lost_count = 0;
        m_yesterday_in_count = 0;
        m_yesterday_out_count = 0;
        m_yesterday_lost_count = 0;
        m_cps = 0;
    }
};

typedef std::list<TKIPv6> TLockDataUI32List;
typedef TLockDataUI32List::iterator TLockDataUI32ListIt;

class TReadIPDiskQueue {
private:
    static const int MAX_ELEMENT_COUNT = 50000;

    TLockDataUI32List blist;
    TMutex m_Mutex;
    ui64 m_today_in_count;
    ui64 m_today_out_count;
    ui64 m_today_lost_count;
    ui64 m_yesterday_in_count;
    ui64 m_yesterday_out_count;
    ui64 m_yesterday_lost_count;
    float m_cps;
    TLogsGroup* LogsGroup;
    TString m_ident;

    ui32 m_request;
    time_t m_last_calc_cps;

    void Lock();
    void UnLock();
    void CalcCPS();
    void ReCalcCPS();

public:
    TReadIPDiskQueue(TLogsGroup* LogsGroupA, const TString& ident);
    ~TReadIPDiskQueue();

    void Add(TKIPv6 value);
    TKIPv6 Get();
    void Midnight();
    TReadIPDiskQueueStat GetStat();
};

//***************************************************************************************
//                               TBanIPLocalCache
//***************************************************************************************

struct TBanCacheInfo //: public TIPv6HashOnlyPRec
{
    bool m_ban;
    bool m_ban7;

    TBanCacheInfo() {
        Clear();
    }

    TBanCacheInfo(const TBanCacheInfo& value) {
        m_ban = value.m_ban;
        m_ban7 = value.m_ban7;
    }

    TBanCacheInfo(bool ban, bool ban7) {
        Clear();
        m_ban = ban;
        m_ban7 = ban7;
    }

    void Clear() {
        m_ban = false;
        m_ban7 = false;
    }
};

struct TBanLocalCacheStat {
    ui32 m_data_size;
    ui32 m_data_prev_size;
    ui32 m_last_change_data;
    ui64 m_today_request;
    ui64 m_today_findincache;
    ui64 m_yesterday_request;
    ui64 m_yesterday_findincache;

    TBanLocalCacheStat() {
        Clear();
    }

    void Clear() {
        m_data_size = 0;
        m_data_prev_size = 0;
        m_last_change_data = 0;
        m_today_request = 0;
        m_today_findincache = 0;
        m_yesterday_request = 0;
        m_yesterday_findincache = 0;
    }

    float TodayFindInCachePercent() {
        float res = 0;

        if (m_today_request > 0)
            res = (float)m_today_findincache * (float)100 / (float)m_today_request;

        return res;
    }

    float YesterdayFindInCachePercent() {
        float res = 0;

        if (m_yesterday_request > 0)
            res = (float)m_yesterday_findincache * (float)100 / (float)m_yesterday_request;

        return res;
    }
};

/*class TBanIPLocalCache
{
private:
         TIPv6HashOnlyP *data;
         TIPv6HashOnlyP *prev_data;
         TMutex         m_Mutex;
         ui32           m_period_time;
         ui32           m_last_changedata;

         ui64           m_today_request;
         ui64           m_today_findincache;
         ui64           m_yesterday_request;
         ui64           m_yesterday_findincache;

         void Lock();
         void UnLock();
public:
         TBanIPLocalCache();
         ~TBanIPLocalCache();

         void                 Init(ui32 period_time);
         void                 EventTick();
         void                 Midnight();
         TBanLocalCacheStat   GetStat();
         ui32                 GetPeriodTime(){ return m_period_time; }
         ui32                 GetRemainTime();

         bool                 GetData(TKIPv6 ip, TBanCacheInfo &datav);
         void                 AddData(TKIPv6 ip, const TBanCacheInfo &datav);
         void                 RemoveData(TKIPv6 ip);
};*/

class TBanIPLocalCache {
private:
    THashMap<TKIPv6, TBanCacheInfo>* data;
    THashMap<TKIPv6, TBanCacheInfo>* prev_data;
    TMutex m_Mutex;
    ui32 m_period_time;
    ui32 m_last_changedata;

    ui64 m_today_request;
    ui64 m_today_findincache;
    ui64 m_yesterday_request;
    ui64 m_yesterday_findincache;

    void Lock();
    void UnLock();

public:
    TBanIPLocalCache();
    ~TBanIPLocalCache();

    void Init(ui32 period_time);
    void EventTick();
    void Midnight();
    TBanLocalCacheStat GetStat();
    ui32 GetPeriodTime() {
        return m_period_time;
    }
    ui32 GetRemainTime();

    bool GetData(TKIPv6 ip, TBanCacheInfo& datav);
    void AddData(TKIPv6 ip, const TBanCacheInfo& datav);
    void RemoveData(TKIPv6 ip);
};

//***************************************************************************************
//                               TWhiteIPLocalCache
//***************************************************************************************

struct TWhiteIPLocalCacheStat {
    ui32 m_diffcount;
    ui32 m_difftime;
    ui32 m_size;
    ui64 m_today_request;
    ui64 m_today_findincache;
    ui64 m_yesterday_request;
    ui64 m_yesterday_findincache;

    TWhiteIPLocalCacheStat() {
        Clear();
    }

    void Clear() {
        m_diffcount = 0;
        m_difftime = 0;
        m_size = 0;
        m_today_request = 0;
        m_today_findincache = 0;
        m_yesterday_request = 0;
        m_yesterday_findincache = 0;
    }

    float TodayFindInCachePercent() {
        float res = 0;

        if (m_today_request > 0)
            res = (float)m_today_findincache * (float)100 / (float)m_today_request;

        return res;
    }

    float YesterdayFindInCachePercent() {
        float res = 0;

        if (m_yesterday_request > 0)
            res = (float)m_yesterday_findincache * (float)100 / (float)m_yesterday_request;

        return res;
    }
};

/*class TWhiteIPLocalCache
{
private:
         static const ui32 MAX_ELAPSED_LASTTIME_TO_CLEANUP = 3600;
private:
         TIPv6HashOnlyP *data;
         TMutex         m_Mutex;
         ui32           m_diffcount;
         ui32           m_difftime;

         ui64           m_today_request;
         ui64           m_today_findincache;
         ui64           m_yesterday_request;
         ui64           m_yesterday_findincache;

         void Lock();
         void UnLock();
         void FillStat(TWeightIPLocalCacheItem *pvalue, TObrabData &odata);
public:
         TWhiteIPLocalCache();
         ~TWhiteIPLocalCache();

         void                    Init(ui32 diffcount, ui32 difftime);
         TWhiteIPLocalCacheStat  GetStatBase();
         ui32                    GetDiffCount(){ return m_diffcount; }
         ui32                    GetDiffTime() { return m_difftime;  }
         ui32                    Size();

         void                    Midnight();
         void                    Cleanup(ui32 &worktime, ui32 &all_record, TWeightIPLocalCacheItemExList &erase_list);

         bool                    GetStat(TKIPv6 ip, TWeightIPLocalCacheItem &value);
         bool                    NeedRequestToStorage(TKIPv6 ip);
         void                    AddStorageInfo(TKIPv6 ip, TMemRecordCopy &memcopy);
         void                    AddDiffData(TKIPv6 ip, TObrabData &odata);
         bool                    GetDiffData(TKIPv6 ip, TWeightIPLocalCacheDiff &value); //���������� diff � ������� ������ �� ip �� ����

};*/

class TWhiteIPLocalCache {
private:
    static const ui32 MAX_ELAPSED_LASTTIME_TO_CLEANUP = 3600;

private:
    THashMap<TKIPv6, TWeightIPLocalCacheItem>* data;
    TMutex m_Mutex;
    ui32 m_diffcount;
    ui32 m_difftime;

    ui64 m_today_request;
    ui64 m_today_findincache;
    ui64 m_yesterday_request;
    ui64 m_yesterday_findincache;

    void Lock();
    void UnLock();
    void FillStat(TWeightIPLocalCacheItem* pvalue, TObrabData& odata);

public:
    TWhiteIPLocalCache();
    ~TWhiteIPLocalCache();

    void Init(ui32 diffcount, ui32 difftime);
    TWhiteIPLocalCacheStat GetStatBase();
    ui32 GetDiffCount() {
        return m_diffcount;
    }
    ui32 GetDiffTime() {
        return m_difftime;
    }
    ui32 Size();

    void Midnight();
    void Cleanup(ui32& worktime, ui32& all_record, TWeightIPLocalCacheItemExList& erase_list);

    bool GetStat(TKIPv6 ip, TWeightIPLocalCacheItem& value);
    bool NeedRequestToStorage(TKIPv6 ip);
    void AddStorageInfo(TKIPv6 ip, TMemRecordCopy& memcopy);
    void AddDiffData(TKIPv6 ip, TObrabData& odata);
    bool GetDiffData(TKIPv6 ip, TWeightIPLocalCacheDiff& value); //���������� diff � ������� ������ �� ip �� ����
};

//***************************************************************************************
//                                 TMemBaseSection
//***************************************************************************************

struct TLocalCacheStat {
    bool m_need_update_cache;
    ui32 m_start_update_time;
    bool m_is_local_cache;
    ui32 m_create_time;
    ui32 m_count;

    TLocalCacheStat() {
        m_need_update_cache = false;
        m_start_update_time = 0;
        m_is_local_cache = false;
        m_create_time = 0;
        m_count = 0;
    }

    TString GetData(ui32 period) {
        TString res = "";

        if (m_is_local_cache)
            res = "(<b>LOCAL_CACHE</b>)<br>(elapsed " + GetTimePeriod(time(NULL) - m_create_time) + ")<br>(remain " + GetTimePeriod(period - (time(NULL) - m_create_time)) + ")";
        else
            res = "(<b>STORAGE</b>)<br>(elapsed " + GetTimePeriod(time(NULL) - m_create_time) + ")<br>(remain " + GetTimePeriod(period - (time(NULL) - m_create_time)) + ")";

        return res;
    }

    bool LocalCacheReady() {
        bool res = true;

        if (m_need_update_cache)
            res = false;

        return res;
    }
};

class TMemBaseSection {
public:
    static const ui32 LOCAL_CACHE_PERIOD_SEC = 900;
    static const ui32 MEMSTAT_CLEANUP_PERIOD = 24 * 3600;

private:
    void* statipobj;
    TLogsGroup* LogsGroup;
    //TString            m_db;
    //TString            m_membase_collection;
    //TString            m_memstat_collection;

    TMutex m_MemStatMutex;
    TLocalCacheStat cache_info;
    TCacheMemStat* memstat_cache;

    TAtomic m_new_record_count_today;
    TAtomic m_new_record_count_yesterday;
    TAtomic minstatcount;

    ui32 AddData32(ui32& value, ui32 addv);
    ui32 AddData32Diff(ui32& value, ui32 addv);
    ui32 IncData32(ui32 value, ui32 addv);
    ui16 AddData16(ui16& value, ui16 addv);
    ui16 AddData16Diff(ui16& value, ui16 addv);
    ui8 AddData8(ui8& value, ui8 addv);
    ui8 AddData8Diff(ui8& value, ui8 addv);
    void AddToHash(nosql::HashMap& hash, const TString& fname, i64 value);
    TString PrintHashData(nosql::HashMap& value);
    void WriteTodayStatistic(TKIPv6 ip, time_t m_curr_time, TMemRecord* mb);

    bool mongo_read_ip_data(TStorageType stortype, TKIPv6 ip, bool& mongo_err, TMemRecord& data, bool& empty);
    bool mongo_update_ip_data(TStorageType stortype, TKIPv6 ip, bool& mongo_err, nosql::HashMap& sets, nosql::HashMap& incrs);
    bool mongo_findandmodify(TStorageType stortype, TKIPv6 ip, bool& mongo_err, const nosql::HashMap& incrs, const nosql::HashMap& sets, nosql::HashMap& hash, bool getnew);
    i64 mongo_basa_size(TStorageType stortype);
    bool mongo_find(TStorageType stortype, TVector<nosql::HashMap>& hashes);
    bool mongo_erase(TStorageType stortype, TKIPv6 ip, bool& mongo_err);

    bool mongo_check_mem_basa(TKIPv6 ip, i64 currenttime, TMemRecord& data, const TString& idmess, TDiffCounter* changeday1_counter, TDiffCounter* changeday2_counter);
    void AddToMemStatMongo(TKIPv6 ip, ui32 todayham, ui32 todayspam, ui32 todaymalic, ui32 summham, ui32 summspam, ui32 summmalic, const TString& m_rdns, const TString& m_rdns2, const TString& m_rdns3, time_t m_curr_time, time_t tFixDay, float m_cps, bool forwardA, ui32 frwd_pr1, bool white_pr, ui32 pcmb);

    //TKIPv6("1.1.1.1") - first_dsl rps
    bool mongo_read_rps(TKIPv6 ip, bool& mongo_err, TDSLRps& data, bool& empty);
    bool mongo_update_rps(TKIPv6 ip, bool& mongo_err, nosql::HashMap& sets, nosql::HashMap& incrs);
    bool mongo_findandmodify_rps(TKIPv6 ip, bool& mongo_err, const nosql::HashMap& incrs, const nosql::HashMap& sets, nosql::HashMap& hash, bool getnew);

public:
    TMemBaseSection();
    ~TMemBaseSection();

    void Init(void* statipobjA, TLogsGroup* LogsGroupA, TKConfig* configobjA);
    void Midnight();
    void EventTick();
    void GetNewRecordCount(ui64& today, ui64& yesterday);

    TMemRecordCopy mAddStatMongo(TKIPv6 ip, T_enum_ip_level stattype, int* pIpSpam, bool& WhiteIp, TTimes& DelayT, TObrabData& odata, TWhiteIPLocalCache* whiteip_cache, TDiffCounter* changeday1_counter, TDiffCounter* changeday2_counter);
    int mIncBan7Mongo(TKIPv6 ip, bool is_malic_spam, bool& inc_malicspam_count, bool& need_print_ban3log);
    bool mIncMSCwFlagMongo(TKIPv6 ip, bool& inc_malicspam_count, ui16 forward, ui16 probbancriterion, ui16 bancriterion);
    void mIncOnlyMalicwFlagMongo(TKIPv6 ip, ui32 mailcount, ui16 forward, ui16 probbancriterion, ui16 bancriterion);
    void mGetStatBanMongo(TObrabData& odata, bool malicspamer, TTimes& DelayT, int mailcount);
    bool mClearStat(TKIPv6 ip);
    ui32 mCheckMemBasa(TKIPv6 ip, time_t m_curr_time, bool& diskwrite, const TString& id, TDiffCounter* changeday1_counter, TDiffCounter* changeday2_counter);
    void mSetBanNow(TKIPv6 ip, bool bannow);
    void mClearBanToday(TKIPv6 ip);
    TString GetFirstDslRPS();
    float CalcFirstDslRPS();

    TIpStatOne GetIpStat(TKIPv6 ip);
    ui32 mGetMembasaSize();

    //cache white ip to write storage
    bool SendTailsByWhiteIP(TKIPv6 ip, TWeightIPLocalCacheItem* diffdata, TDiffCounter* changeday1_counter, TDiffCounter* changeday2_counter);

    //statistik by heavy ip
    TLocalCacheStat GetHeavyLocalCacheStat();
    void SetNeedUpdateLocalCache();
    void ReadHeavyFromStorage();
    void CleanupHeavyStorage();
    bool NeedUpdateLocalCache();
    bool GetHeavyMemStat(int sorttype, TMemList& memlist, bool enableexclude, ui32 mincount, ui32 maxlastsec, bool adddata_to_filename, bool excludeforward, ui32 maxrecord, TIpType typeip, TWhtIp whtip, TLocalCacheStat& storinfo, bool needstor, ui32& sorttime);
    bool GetHeavyMemStatLocalCache(int sorttype, TMemList& memlist, bool enableexclude, ui32 mincount, ui32 maxlastsec, bool adddata_to_filename, bool excludeforward, ui32 maxrecord, TIpType typeip, TWhtIp whtip, ui32& record_count, ui32& sorttime);
    ui32 GetHeavyMemCount();
};

//***************************************************************************************
//                                 TMemBaseMain
//***************************************************************************************

class TMemBaseMain {
private:
    void* statipobj;
    TLogsGroup* LogsGroup;
    TMemBaseSection MemSection;

public:
    TMemBaseMain();
    ~TMemBaseMain();

    void Init(void* statipobjA, TLogsGroup* LogsGroupA, TKConfig* configobjA);
    void Midnight();
    void EventTick();
    void WriteThreadIDToLog();
    void GetNewRecordCount(ui64& today, ui64& yesterday);

    TMemRecordCopy mAddStatMongo(int& index, TKIPv6 ip, T_enum_ip_level stattype, int* pIpSpam, bool& WhiteIp, TTimes& DelayT, TObrabData& odata, TWhiteIPLocalCache* whiteip_cache, TDiffCounter* changeday1_counter, TDiffCounter* changeday2_counter);
    int mIncBan7Mongo(TKIPv6 ip, bool is_malic_spam, bool& inc_malicspam_count, bool& need_print_ban3log);
    bool mIncMSCwFlagMongo(TKIPv6 ip, bool& inc_malicspam_count, ui16 forward, ui16 probbancriterion, ui16 bancriterion);
    void mIncOnlyMalicwFlagMongo(TKIPv6 ip, ui32 mailcount, ui16 forward, ui16 probbancriterion, ui16 bancriterion);
    void mGetStatBanMongo(TObrabData& odata, bool malicspamer, TTimes& DelayT, int mailcount);
    bool mClearStat(TKIPv6 ip);
    ui32 mCheckMemBasa(TKIPv6 ip, time_t m_curr_time, bool& diskwrite, const TString& id, TDiffCounter* changeday1_counter, TDiffCounter* changeday2_counter);
    void mSetBanNow(TKIPv6 ip, bool bannow);
    void mClearBanToday(TKIPv6 ip);
    TString GetFirstDslRPS();
    float CalcFirstDslRPS();

    TIpStatOne GetIpStat(TKIPv6 ip);
    ui32 mGetMembasaSize();

    //cache white ip to write storage
    bool SendTailsByWhiteIP(TKIPv6 ip, TWeightIPLocalCacheItem* diffdata, TDiffCounter* changeday1_counter, TDiffCounter* changeday2_counter);

    //statistik by heavy ip
    TLocalCacheStat GetHeavyLocalCacheStat();
    bool NeedUpdateLocalCache();
    void SetNeedUpdateLocalCache();
    bool GetHeavyMemStat(int sorttype, TMemList& memlist, bool enableexclude, ui32 mincount, ui32 maxlastsec, bool adddata_to_filename, bool excludeforward, ui32 maxrecord, TIpType typeip, TWhtIp whtip, TLocalCacheStat& storinfo, bool needstor, ui32& sorttime);
    ui32 GetHeavyMemCount();
};

//***************************************************************************************
