#pragma once

#ifndef tnetlist_ipv6_H
#define tnetlist_ipv6_H

#include <util/system/defaults.h>
#include <util/system/compat.h>
#include <util/system/mutex.h>
#include <util/generic/hash.h>
#include <mail/so/spamstop/tools/so-common/tkipv6.h>
#include <mail/so/spamstop/tools/so-common/tlogclass.h>
#include <mail/so/spamstop/tools/so-clients/shtime.h>
#include "mail/so/spamstop/spk2/sputil.h"
#include <list>
#include <sys/stat.h>

//*********************************************************************************************************************
//                                                 TListIPv6Base
//*********************************************************************************************************************

#define K_PRINT_ONLY_STAT

struct THashStatNL {
    ui32 trace_count;
    ui32 no_trace_count;
    ui32 bad_count;
    ui32 dublicat_count;

    THashStatNL() {
        Clear();
    }

    void Clear() {
        trace_count = 0;
        no_trace_count = 0;
        bad_count = 0;
        dublicat_count = 0;
    }
};

struct TFileState {
    time_t mtime;
    long size;

    TFileState() {
        mtime = 0;
        size = 0;
    }
};

class TListIPv6Base {
private:
    static const int MAX_FILE_SIZE = 33000000;

private:
    TString m_filename;
    TFileState m_statHashIp;
    bool m_clear_before_load;

    ui32 GetStr(const char* source, ui32 source_size, char* destination, ui32 destination_size);
    void ReloadMemListA(const char* buff, int buff_size, THashStatNL& stat);
    virtual void ParseItem(const char* str, THashStatNL& stat) = 0;
    virtual void ClearData() = 0;
    virtual TString GetResultPrint(THashStatNL& stat, ui32 timedelay) = 0;
    virtual void TriggerFunction() = 0;
    virtual void PrefixFunction() = 0;
    virtual void PostfixFunction() = 0;
    bool ExistsFile();
    bool FileStateWasChangedK(const char* fn, TFileState* poldbufstat);

public:
    TBaseLogClass* m_log;
    TString m_ident;
    TMutex m_Mutex;
    TMutex m_MutexLoad; //�� ����� �������� ����� ������

    void Lock();
    void UnLock();
    void LockLoad();
    void UnLockLoad();
    ui64 CalcShingle(const TString& str_data);
    TString IntToStroka(int value);
    TString KTrim(const TString& s);
    ui32 IncMax32(const ui32 value, const ui32 step);
    TString IntToIpV4(ui32 ip);
    char* STRNCPY(char* strDest, const char* strSource, size_t DestSize, size_t count);
    bool IpToIntV4(const char* pstr, int len, ui32* pnet, ui32* pip);

public:
    TListIPv6Base();
    TListIPv6Base(const TListIPv6Base& value);
    virtual ~TListIPv6Base();

    void InitBase(const TString& ident, const TString& filename, TBaseLogClass* logA, bool clear_before_load);
    void ReloadFileList();
    void ReloadMemList(const TString& data);
};

//*********************************************************************************************************************
//                                                 TWhiteNetv6
//*********************************************************************************************************************

#define SYMB_RANGE1 0x01
#define SYMB_RANGE2 0x02
#define IS_SYMB_RANGE1(flag) ((flag)&SYMB_RANGE1)
#define IS_SYMB_RANGE2(flag) ((flag)&SYMB_RANGE2)

struct TWIPv6 {
    TKIPv6 ip1;
    TKIPv6 ip2;

    TWIPv6() {
        ip1 = TKIPv6();
        ip2 = TKIPv6();
    }
};

typedef std::list<TWIPv6> TWIPv6List;
typedef TWIPv6List::iterator TWIPv6ListIt;

typedef THashMap<ui64, TString> TStrokaHash;
typedef TStrokaHash::iterator TStrokaHashIt;

class TNetListIPv6: public TListIPv6Base {
public:
    enum TRecordType { TUNDEF,
                       THOST,
                       TIPNET,
                       TIPRANGE,
                       TIPADDRESS };

private:
    TStrokaHash* host_data;
    TStrokaHash* host_data_temp;
    TWIPv6List* range_data;
    TWIPv6List* range_data_temp;
    ui8 SymbTable[256];
    TString idents;

    virtual void ParseItem(const char* str, THashStatNL& stat);
    virtual void ClearData();
    virtual TString GetResultPrint(THashStatNL& stat, ui32 timedelay);
    virtual void TriggerFunction();
    virtual void PrefixFunction();
    virtual void PostfixFunction();
    TString NormalizeStr(const char* str, int strlength);
    TRecordType GetRecordType(const char* str, int strlength);
    void InitTable();
    bool IsAllowSymbolRange1(char symb);
    bool IsAllowSymbolRange2(char symb);
    bool ParseRangeType1(const TString& text, TWIPv6& value);
    bool ParseRangeType2(const TString& text, TWIPv6& value);

public:
    TNetListIPv6();
    TNetListIPv6(const TString& ident);
    virtual ~TNetListIPv6();

    void Init(const TString& filename, TBaseLogClass* logA);
    bool IsNet(const char* phost);
    bool IsNet(TKIPv6 ip);
    bool IsNet(TKIPv6 ip, TKIPv6& min_ip_from_diapason);

    TRecordType GetAddresses(const TString& addr_text, TWIPv6& value);
};

//**********************************************************************************************************************

#endif
