#include "tparsedlvlog.h"
#include <mail/so/spamstop/tools/so-common/get_zone_time.h>

//*************************************************************************************************************************************
//                                       ParsedDlvLog - class for parse delivery logs
//*************************************************************************************************************************************

TParsedDlvLog::TParsedDlvLog() {
    dlvtypehash["rcvd"] = DST_RECEIVED;
    dlvtypehash["wght"] = DST_WEIGHT;
    dlvtypehash["spam"] = DST_SPAM;
    dlvtypehash["r_sp"] = DST_REPORT_SPAM;
    dlvtypehash["r_dl"] = DST_REPORT_DLV;
    dlvtypehash["r_nl"] = DST_REPORT_NULL;
    dlvtypehash["r_st"] = DST_RULE_STAT;
    dlvtypehash["srce"] = DST_SOURCE;
    dlvtypehash["fxrl"] = DST_FIXED_BY_RULE;
    dlvtypehash["mess"] = DST_MESSAGE;
    dlvtypehash["log "] = DST_LOG;
    dlvtypehash["subj"] = DST_SUBJ;
    dlvtypehash["http"] = DST_HTTP;
    dlvtypehash["phon"] = DST_PHONE;
    dlvtypehash["iy-geozone"] = DST_GEO;
    dlvtypehash["messageid"] = DST_MESSID;
    dlvtypehash["x-yandex-queueid"] = DST_QUEUEID;
    dlvtypehash["clnt"] = DST_EXTSRVERRORS;
}

TParsedDlvLog::~TParsedDlvLog() {
}

TSpClass TParsedDlvLog::GetSpamType(const char* BUFF, ui32 BuffSize) {
    TSpClass res = TSpClass::UNKNOWN;
    TTBuffStruct bdata;

    if (bdata.ValidBuffer()) {
        char* pbuf = nullptr;
        int buflen = 0;
        ui32 strlength = 0;
        ui32 m_buff_pos = 0;
        char* tbuff = nullptr;
        TString tstr = "";

        bdata.SetLastSymbToNull();
        tbuff = bdata.GetBuff();
        while (m_buff_pos < BuffSize) {
            strlength = GetStr(BUFF + m_buff_pos, BuffSize - m_buff_pos, &tbuff, bdata.size());
            if (strlength > 0) {
                m_buff_pos += strlength;
                buflen = strlen(tbuff);

                if ((buflen <= 6) || (*(tbuff + 4) != ':'))
                    continue;
                if (memcmp(bdata.GetBuff(), "spam: ", 6))
                    continue;

                pbuf = tbuff + 6;
                buflen -= 6;

                tstr = TString(pbuf);

                if (!STRNCMP(tstr.c_str(), "yes")) {
                    res = TSpClass::SPAM;
                    //data.m_exportdata.m_pmesstype = "yes";
                } else if (!STRNCMP(tstr.c_str(), "no")) {
                    res = TSpClass::HAM;
                    //data.m_exportdata.m_pmesstype = "no";
                } else if (!STRNCMP(tstr.c_str(), "dlv")) {
                    res = TSpClass::DLVR;
                    //data.m_exportdata.m_pmesstype = "dlv";
                } else {
                    res = TSpClass::UNKNOWN;
                    //data.m_exportdata.m_pmesstype = "unknown";
                }
            }
        }
    }

    return res;
}

TIPAddresses TParsedDlvLog::GetIPAddress(const char* BUFF, ui32 BuffSize) {
    TIPAddresses res;
    TTBuffStruct bdata;

    if (bdata.ValidBuffer()) {
        char* pbuf = nullptr;
        int buflen = 0;
        ui32 strlength = 0;
        ui32 m_buff_pos = 0;
        const char* paddr = nullptr;
        const char* prdns = nullptr;
        const char* phelo = nullptr;
        const char* pend = nullptr;
        TString ip_s = "";
        TString rdns_s = "";
        TString helo_s = "";
        TString ip_sn = "";
        TString rdns_sn = "";
        TString helo_sn = "";
        int count = 0;
        TString ipaddr_ident = "source ip =";
        TString ipaddr_ident_n = "next ip =";
        TString rdns_ident = "rdns =";
        TString helo_ident = "helo =";
        TKIPv6 ip = TKIPv6();
        char* tbuff = nullptr;

        bdata.SetLastSymbToNull();
        tbuff = bdata.GetBuff();
        while (m_buff_pos < BuffSize) {
            strlength = GetStr(BUFF + m_buff_pos, BuffSize - m_buff_pos, &tbuff, bdata.size());
            if (strlength > 0) {
                m_buff_pos += strlength;
                buflen = strlen(tbuff);

                if ((buflen <= 6) || (*(tbuff + 4) != ':'))
                    continue;
                if (memcmp(bdata.GetBuff(), "rcvd: ", 6))
                    continue;

                pbuf = tbuff + 6;
                buflen -= 6;

                //source ip
                paddr = strstr(pbuf, ipaddr_ident.c_str());
                if (paddr != nullptr) {
                    ip_s = "";
                    rdns_s = "";
                    helo_s = "";

                    prdns = strstr(paddr, rdns_ident.c_str());
                    if (prdns != nullptr) {
                        count = prdns - paddr - ipaddr_ident.length();
                        if (count > 0) {
                            ip_s = Trim(TString(paddr + ipaddr_ident.length(), count));
                            ip = TKIPv6(ip_s.c_str());
                        }

                        phelo = strstr(prdns, helo_ident.c_str());
                        if (phelo != nullptr) {
                            count = phelo - prdns - rdns_ident.length();
                            if (count > 0)
                                rdns_s = Trim(TString(prdns + rdns_ident.length(), count));

                            pend = pbuf + buflen;
                            if (pend != nullptr) {
                                count = pend - phelo - rdns_ident.length();
                                if (count > 0)
                                    helo_s = Trim(TString(phelo + helo_ident.length(), count));
                            }
                        }
                        if (!ip.Undefined())
                            res.sourceip = TSummaryIPInfo(ip, rdns_s, helo_s);
                    }
                }

                //next ip
                paddr = strstr(pbuf, ipaddr_ident_n.c_str());
                if (paddr != nullptr) {
                    prdns = strstr(paddr, rdns_ident.c_str());
                    if (prdns != nullptr) {
                        count = prdns - paddr - ipaddr_ident_n.length();
                        if (count > 0) {
                            ip_sn = Trim(TString(paddr + ipaddr_ident_n.length(), count));
                            ip = TKIPv6(ip_sn.c_str());
                        }

                        phelo = strstr(prdns, helo_ident.c_str());
                        if (phelo != nullptr) {
                            count = phelo - prdns - rdns_ident.length();
                            if (count > 0)
                                rdns_sn = Trim(TString(prdns + rdns_ident.length(), count));

                            pend = pbuf + buflen;
                            if (pend != nullptr) {
                                count = pend - phelo - rdns_ident.length();
                                if (count > 0)
                                    helo_sn = Trim(TString(phelo + helo_ident.length(), count));
                            }
                        }
                        if (!ip.Undefined())
                            res.nextip.push_back(TSummaryIPInfo(ip, rdns_sn, helo_sn));
                    }
                }
            }
        }
    }

    return res;
}

ui32 TParsedDlvLog::GetStr(const char* source, ui32 source_size, char** destination, ui32 destination_size) {
    long pos = -1;
    ui32 res = 0;
    ui8 dob = 0;

    (*destination)[0] = 0;
    for (ui32 i = 0; i < source_size; i++) {
        if ((source[i] == 0x0D) && ((i + 1) < source_size) && (source[i + 1] == 0x0A)) {
            pos = i;
            dob = 1;
            break;
        }
        if (source[i] == 0x0A) {
            pos = i;
            dob = 0;
            break;
        }
    }
    res = pos + 1 + dob;
    if (res == 0)
        res = source_size;
    if (res > 0) {
        if (res <= destination_size) {
            memcpy(*destination, source, res);
            (*destination)[res] = 0;
        } else {
            memcpy(*destination, source, destination_size);
            (*destination)[destination_size - 1] = 0;
        }
    }
    return res;
}

bool TParsedDlvLog::GetIPAddressFromRcvd(const char* tbuff, bool& is_nextip, TSummaryIPInfo& resip) {
    bool res = false;
    const char* pbuf = nullptr;
    int buflen = 0;
    const char* paddr = nullptr;
    const char* prdns = nullptr;
    const char* phelo = nullptr;
    const char* pend = nullptr;
    TString ip_s = "";
    TString rdns_s = "";
    TString helo_s = "";
    TString ip_sn = "";
    TString rdns_sn = "";
    TString helo_sn = "";
    int count = 0;
    TString ipaddr_ident = "source ip =";
    TString ipaddr_ident_n = "next ip =";
    TString rdns_ident = "rdns =";
    TString helo_ident = "helo =";
    TKIPv6 ip = TKIPv6();

    is_nextip = false;
    //pbuf = tbuff + 6;
    //buflen -= 6;
    pbuf = tbuff;
    buflen = strlen(pbuf);

    //source ip
    paddr = strstr(pbuf, ipaddr_ident.c_str());
    if (paddr != nullptr) {
        ip_s = "";
        rdns_s = "";
        helo_s = "";

        prdns = strstr(paddr, rdns_ident.c_str());
        if (prdns != nullptr) {
            count = prdns - paddr - ipaddr_ident.length();
            if (count > 0) {
                ip_s = Trim(TString(paddr + ipaddr_ident.length(), count));
                ip = TKIPv6(ip_s.c_str());
            }

            phelo = strstr(prdns, helo_ident.c_str());
            if (phelo != nullptr) {
                count = phelo - prdns - rdns_ident.length();
                if (count > 0)
                    rdns_s = Trim(TString(prdns + rdns_ident.length(), count));

                pend = pbuf + buflen;
                if (pend != nullptr) {
                    count = pend - phelo - rdns_ident.length();
                    if (count > 0)
                        helo_s = Trim(TString(phelo + helo_ident.length(), count));
                }
            }
            if (!ip.Undefined()) {
                resip = TSummaryIPInfo(ip, rdns_s, helo_s);
                is_nextip = false;
                res = true;
            }
        }
    }

    //next ip
    paddr = strstr(pbuf, ipaddr_ident_n.c_str());
    if (paddr != nullptr) {
        prdns = strstr(paddr, rdns_ident.c_str());
        if (prdns != nullptr) {
            count = prdns - paddr - ipaddr_ident_n.length();
            if (count > 0) {
                ip_sn = Trim(TString(paddr + ipaddr_ident_n.length(), count));
                ip = TKIPv6(ip_sn.c_str());
            }

            phelo = strstr(prdns, helo_ident.c_str());
            if (phelo != nullptr) {
                count = phelo - prdns - rdns_ident.length();
                if (count > 0)
                    rdns_sn = Trim(TString(prdns + rdns_ident.length(), count));

                pend = pbuf + buflen;
                if (pend != nullptr) {
                    count = pend - phelo - rdns_ident.length();
                    if (count > 0)
                        helo_sn = Trim(TString(phelo + helo_ident.length(), count));
                }
            }
            if (!ip.Undefined()) {
                resip = TSummaryIPInfo(ip, rdns_sn, helo_sn);
                is_nextip = true;
                res = true;
            }
        }
    }

    return res;
}

TSTRTYPEDLV TParsedDlvLog::GetDlvSType(const TString& value) {
    TSTRTYPEDLV res = DST_UNKNOWN;
    TString tvalue = value;
    TSTRTYPEDLVHashIt it;

    to_lower_k(tvalue);

    it = dlvtypehash.find(tvalue);
    if (it != dlvtypehash.end())
        res = (*it).second;

    return res;
}

void TParsedDlvLog::ParseWeights(const char* str, float& w1, float& w2) {
    w1 = 0;
    w2 = 0;

    if (str != nullptr) {
        float f1 = 0, f2 = 0;

        sscanf(str, "%f %f ", &f1, &f2);
        w1 = f1;
        w2 = f2;
    }
}

void TParsedDlvLog::SetSpamRule(const char* pbuf, TParsedDlvLogData& odata) {
    if (strstr(pbuf, "DSN_NO_SENT_BY_YAMAIL ") || strstr(pbuf, "NEG_WL "))
        odata.m_exportdata.m_fDSN = true;
    if (strstr(pbuf, "YANDEXWL_1 "))
        odata.m_exportdata.m_Uwl += 10;
    if (strstr(pbuf, "__RDSL_OR_NORESOLVED_FIRST"))
        odata.m_exportdata.m_fDsl_first = true;
    if (strstr(pbuf, " RELAY_NORESOLVED_IN_FIRST_RCVD "))
        odata.m_exportdata.m_fNoresolv_first = true;
    if (strstr(pbuf, "SOURCE_LEVEL_1 "))
        odata.m_exportdata.m_fSource_level_1 = true;
    if (strstr(pbuf, "SOURCE_LEVEL_2 "))
        odata.m_exportdata.m_fSource_level_2 = true;
    if (strstr(pbuf, "RCVD_FROM_DSL_FIRST_RCVD_8 "))
        odata.m_exportdata.m_fDsl_first8 = true;
    if (strstr(pbuf, "BAN_100_MAILS "))
        odata.m_exportdata.m_f100mails = true;
    if (strstr(pbuf, "MALICIOUS_SPAMER "))
        odata.m_exportdata.m_malicspam = true;

    char* str = nullptr;
    if (str = strstr((char*)pbuf, "BAN_MAILS_CRITERION_")) {
        if (3 == sscanf(str, "BAN_MAILS_CRITERION_%d_%d_%d ", &odata.m_exportdata.m_mcrit_spam, &odata.m_exportdata.m_mcrit_hour, &odata.m_exportdata.m_mcrit_crit))
            odata.m_exportdata.m_fmails_criterion = true;
    }

    if (strstr(pbuf, "RCVD_FROM_DSL_FIRST_RCVD_6 ") ||
        strstr(pbuf, "RCVD_FROM_DSL_FIRST_RCVD_7 ") ||
        strstr(pbuf, "RCVD_FROM_DSL_FIRST_RCVD_8 ") ||
        strstr(pbuf, "RCVD_FROM_DSL_FIRST_RCVD_9 ") ||
        strstr(pbuf, "RCVD_FROM_DSL_FIRST_RCVD_10 ") ||
        strstr(pbuf, "RCVD_FROM_DSL_FIRST_RCVD_19 ") ||
        strstr(pbuf, "RCVD_FROM_DSL_FIRST_RCVD_20 ") ||
        strstr(pbuf, "RCVD_FROM_DSL_FIRST_RCVD_14 "))
        odata.m_exportdata.m_fDsl_first67891014 = true;

    if (strstr(pbuf, "SHM_500_1111_DATE_IN_FUTURE_PAST") ||
        strstr(pbuf, "SHM_500_1111_REAL_NAME_TO_ABSENT") ||
        strstr(pbuf, "SHM_500_1111_COMBINEDBL") ||
        strstr(pbuf, "SHM_500_1111_CONTINUOUS_LETTERS_FROM_TO"))
        odata.m_exportdata.m_fSHM = true;

    //META_RFDONF_DATE_TZ_ABSURD

    if (strstr(pbuf, "BW_1_D_E") ||
        strstr(pbuf, "BW_2_D_E") ||
        strstr(pbuf, "BW_3_D_E") ||
        strstr(pbuf, "BW_4_D_E") ||
        strstr(pbuf, "BW_8_D_E") ||
        strstr(pbuf, "SHM_500_1111_RFDONF_BL") ||
        strstr(pbuf, "SHM_500_1111_DATE_TZ_ABSURD") ||
        strstr(pbuf, "SHM_100_500_RFDONF_SEMINAR") ||
        strstr(pbuf, "SHM_100_500_RNTA_DFP"))
        odata.m_exportdata.m_fBW = true;

    //SHM_100_500_RFDONF_SEMINAR
    if (strstr(pbuf, "ZONE_F_INFO") &&
        (strstr(pbuf, "HAVING_TROUBLE_SEEING") ||
         strstr(pbuf, "BAN_SUBJ_SEXUALLY") ||
         strstr(pbuf, "BAN_SUBJ_SEXUALLY_2") ||
         strstr(pbuf, "PORNO_SUBJ") ||
         strstr(pbuf, "HTML_FONT_UNVISIBLE_TEXT") ||
         strstr(pbuf, "EMPTY_BODYTEXT")))
        odata.m_exportdata.m_f20 = true;

    if (strstr(pbuf, "SHM_500_1111_DATE_TZ_ABSURD"))
        odata.m_exportdata.m_f21 = true;

    if (strstr(pbuf, "BW_1_D_E") ||
        strstr(pbuf, "BW_2_D_E") ||
        strstr(pbuf, "BW_3_D_E") ||
        strstr(pbuf, "BW_4_D_E") ||
        strstr(pbuf, "BW_8_D_E") ||
        strstr(pbuf, "SHM_500_1111_RFDONF_BL") ||
        strstr(pbuf, "SHM_500_1111_DATE_TZ_ABSURD") ||
        strstr(pbuf, "SHM_500_1111_RNTA_DFP") ||
        strstr(pbuf, "IDTA_RNTA_MLZ") ||
        strstr(pbuf, "IDTA_RNTA_MLZ_DFP"))
        odata.m_exportdata.m_f22 = true;

    if (strstr(pbuf, "__HELO_LOCALHOST"))
        odata.m_exportdata.m_f__HELO_LOCALHOST = true;

    if (strstr(pbuf, "DL_IP_STAT "))
        odata.m_exportdata.m_fDlvrRules = true;
    if (strstr(pbuf, "OUR_USER "))
        odata.m_exportdata.m_fOurUser = true;
    if (strstr(pbuf, "BOUNCE_ANTIVIRUS "))
        odata.m_exportdata.m_fBounce = true;
    if (strstr(pbuf, "SPF_PASS "))
        odata.m_exportdata.m_fSpf = true;
    if (strstr(pbuf, "COMBINEDBL_4 "))
        odata.m_exportdata.m_fRBL4 = true;

    const char* p = strstr(pbuf, "combinedbl_2 ");
    if (p != nullptr)
        odata.m_exportdata.m_fRBL = true;
    else {
        p = strstr(pbuf, "combinedbl_4 ");
        if (p != nullptr)
            odata.m_exportdata.m_fRBL = true;
        else {
            p = strstr(pbuf, "combinedbl_5 ");
            if (p != nullptr)
                odata.m_exportdata.m_fRBL = true;
            else {
                p = strstr(pbuf, "combinedbl_6 ");
                if (p != nullptr)
                    odata.m_exportdata.m_fRBL = true;
            }
        }
    }
}

void TParsedDlvLog::GetListRule(const char* rnl, VP_STR_DBL& list) {
    const char* p = nullptr;
    const char* pred = nullptr;
    const char* pend = nullptr;

    list.clear();
    pend = rnl + strlen(rnl);
    p = nullptr;
    pred = rnl;
    p = strstr(pred, ",");
    while (p != nullptr) {
        TTempArrayK tmpar{};
        memcpy(tmpar.first.data(), pred, p - pred);
        if (sscanf((const char*)tmpar.first.data(), " %127s ", (char*)tmpar.second.data()) > 0) {
            TString s = TString((const char*)tmpar.second.data());
            if (!s.empty())
                list.emplace_back(std::move(s), 0.);
        }

        pred = p + 1;
        if (pred != nullptr)
            p = strstr(pred, ",");
        else
            p = nullptr;
    }
    if ((p == nullptr) && (pred < pend)) {
        TTempArrayK tmpar{};
        memcpy(tmpar.first.data(), pred, pend - pred);
        if (sscanf((const char*)tmpar.first.data(), " %127s ", (char*)tmpar.second.data()) > 0) {
            TString s = TString((const char*)tmpar.second.data());
            if (!s.empty())
                list.emplace_back(std::move(s), 0.);
        }
    }
}

void TParsedDlvLog::SearchPANNERN_STAT(const char* buff, TParsedDlvLogData& odata) {
    char sbuff[17];
    const char* p = nullptr;

    for (int i = 0; i < 15; i++) {
        snprintf(sbuff, sizeof(sbuff) - 1, "PANNERN_STAT_%u", i + 1);
        p = strstr(buff, sbuff);
        if (p != nullptr)
            odata.m_exportdata.parray[i] = true;
    }
}

void TParsedDlvLog::SetMetaShingle(const char* pbuf, TParsedDlvLogData& odata) {
    if (strstr(pbuf, "META_SHINGLES_")) {
        if (strstr(pbuf, "META_SHINGLES_2_5 ")) {
            odata.m_exportdata.m_metash = enMETA_SHINGLES_2_5;
        } else if (strstr(pbuf, "META_SHINGLES_5_10 ")) {
            odata.m_exportdata.m_metash = enMETA_SHINGLES_5_10;
        } else if (strstr(pbuf, "META_SHINGLES_10_100 ")) {
            odata.m_exportdata.m_metash = enMETA_SHINGLES_10_100;
        } else if (strstr(pbuf, "META_SHINGLES_100_200 ")) {
            odata.m_exportdata.m_metash = enMETA_SHINGLES_100_200;
        } else if (strstr(pbuf, "META_SHINGLES_200_1000 ")) {
            odata.m_exportdata.m_metash = enMETA_SHINGLES_200_1000;
        } else if (strstr(pbuf, "META_SHINGLES_MAX")) {
            odata.m_exportdata.m_metash = enMETA_SHINGLES_MAX;
        }
    }
}

void TParsedDlvLog::SetSpamRuleNL(const char* pbuf, TParsedDlvLogData& odata) {
    if (strstr(pbuf, "__RDSL_OR_NORESOLVED_FIRST"))
        odata.m_exportdata.m_fDsl_first = true;
}

void TParsedDlvLog::SetNullRule(const char* pbuf, TParsedDlvLogData& odata) {
    if (strstr(pbuf, "__POP3_AUTH,"))
        odata.m_exportdata.m_fPop3 = true;
    if (strstr(pbuf, "__SMTP_AUTH,"))
        odata.m_exportdata.m_fSMTP = true;
    if (strstr(pbuf, "BOUNCE_ANTIVIRUS,"))
        odata.m_exportdata.m_fBounce = true;
    if (strstr(pbuf, "__COMBINEDBL,"))
        odata.m_exportdata.m_fCOMBL = true;
}

void TParsedDlvLog::SearchSH_17_2(const char* buff, TParsedDlvLogData& odata) {
    const char* p = nullptr;

    p = strstr(buff, "SH_17_2");
    if (p != nullptr)
        odata.m_exportdata.mSH_17_2 = true;
}

void TParsedDlvLog::GetListRule2(const char* rst, TWorkRuleListExt& list) {
    const char* p = nullptr;
    const char* pred = nullptr;
    TString s = "";
    const char* pend = nullptr;

    list.clear();
    pend = rst + strlen(rst);
    p = nullptr;
    pred = rst;
    p = strstr(pred, ",");
    while (p != nullptr) {
        TTempArrayK tmpar{};
        memcpy(tmpar.first.data(), pred, p - pred);
        if (sscanf((const char*)tmpar.first.data(), " %127s ", (char*)tmpar.second.data()) > 0) {
            s = TString((const char*)tmpar.second.data());
            if (!s.empty())
                list.emplace_back(std::move(s), 0, 0, 0);
        }

        pred = p + 1;
        if (pred != nullptr)
            p = strstr(pred, ",");
        else
            p = nullptr;
    }
    if ((p == nullptr) && (pred < pend)) {
        TTempArrayK tmpar{};
        memcpy(tmpar.first.data(), pred, p - pred);
        if (sscanf((const char*)tmpar.first.data(), " %127s ", (char*)tmpar.second.data()) > 0) {
            s = TString((const char*)tmpar.second.data());
            if (!s.empty())
                list.emplace_back(std::move(s), 0, 0, 0);
        }
    }
}

void TParsedDlvLog::ParseShingles(const char* tbuff, TParsedDlvLogData& odata) {
    const char* p[5];
    TString ident_record_shingle = "log :";

    p[0] = strstr(tbuff, "t =");
    p[1] = strstr(tbuff, "s =");
    p[2] = strstr(tbuff, "h =");
    p[3] = strstr(tbuff, "u =");
    p[4] = strstr(tbuff, "w =");
    if ((p[0] != nullptr) && (p[1] != nullptr) && (p[2] != nullptr) && (p[3] != nullptr) && (p[4] != nullptr)) {
        if ((p[0] < p[1]) && (p[1] < p[2]) && (p[2] < p[3]) && (p[3] < p[4])) {
            ui32 vt = 0, vs = 0, vh = 0, vu = 0;
            float vw = 0;
            ui64 vshingle = 0;
            int count = 0;
            ui64 shingle = 0;
            ui32 type = 0;
            ui32 ham = 0;
            ui32 spam = 0;
            ui32 unknown = 0;

            count = sscanf(tbuff, " %*c %*c %u%*c %*c %*c %u%*c %*c %*c %u%*c %*c %*c %u%*c %*c %*c %f%*c %*s %" PRIx64 " ", &vt, &vs, &vh, &vu, &vw, &vshingle);
            if (count == 6) {
                shingle = vshingle;
                type = vt & 0xFF;
                ham = vh & 0xFFFF;
                spam = vs & 0xFFFF;
                unknown = vu & 0xFFFF;

                if ((type == 17) && (unknown > 200))
                    odata.m_exportdata.m_frwd_pr1 = true;
                if ((type == 19) && (unknown >= 5))
                    odata.m_exportdata.m_frwd_pr2 = false;
            }
        }
    }
}

TSrvcErr TParsedDlvLog::ParseSrvcErrors(const TString& str) {
    TSrvcErr res;
    const char* pb = nullptr;
    const char* pe = nullptr;
    TString tstr = "";
    long count = 0;
    bool flag_end_str = false;
    char pbuff1[16], pbuff2[16], pbuff3[16];

    if (!str.empty()) {
        pb = str.c_str();
        if (pb != nullptr) {
            pe = strchr(pb, ',');
            if (pe == nullptr) {
                pe = str.c_str() + str.length();
                flag_end_str = true;
            }
        }
        do {
            if ((pb != nullptr) && (pe != nullptr)) {
                count = pe - pb;
                if (count > 0) {
                    tstr = TString(pb, count);
                    if (!tstr.empty()) {
                        memset(pbuff1, 0, sizeof(pbuff1));
                        memset(pbuff2, 0, sizeof(pbuff2));
                        memset(pbuff2, 0, sizeof(pbuff3));

                        if (sscanf(tstr.c_str(), " %2s %15s %15s ", pbuff1, pbuff2, pbuff3) == 3) {
                            TString srvctype = "";
                            bool clt_error = true;
                            bool conn_err = true;
                            int exterr = 0;
                            const char* pe1 = nullptr;
                            const char* pe2 = nullptr;
                            const char* pe3 = nullptr;
                            TString et1 = "";
                            TString et2 = "";
                            TString et3 = "";
                            int count2 = 0;

                            pe1 = strchr(pbuff3, '-');
                            if (pe1 != nullptr) {
                                count2 = pe1 - pbuff3;
                                if (count2 > 0) {
                                    et1 = TString(pbuff3, count2);
                                    if (et1 == "OK")
                                        clt_error = true;
                                    else if (et1 == "BPR")
                                        clt_error = false;
                                    else if (et1 == "HTP")
                                        clt_error = false;
                                    else if (et1 == "BRS")
                                        clt_error = false;
                                }

                                pe2 = strchr(pe1, '(');
                                if (pe2 == nullptr)
                                    pe2 = pbuff3 + strlen(pbuff3);
                                if (pe2 != nullptr) {
                                    count2 = pe2 - pe1 - 1;
                                    if (count2 > 0) {
                                        et2 = TString(pe1 + 1, count2);
                                        if (et1 == "HTP") {
                                            if (et2 == "CO")
                                                conn_err = true;
                                            else if (et2 == "CE")
                                                conn_err = false;
                                            else if (et2 == "CT")
                                                conn_err = false;
                                            else if (et2 == "CB")
                                                conn_err = false;
                                            else if (et2 == "RO")
                                                conn_err = false;
                                            else if (et2 == "RE")
                                                conn_err = false;
                                            else if (et2 == "RT")
                                                conn_err = false;
                                            else if (et2 == "RB")
                                                conn_err = false;
                                        }
                                    }

                                    pe3 = strchr(pe2, ')');
                                    if (pe3 != nullptr) {
                                        count2 = pe3 - pe2 - 1;
                                        if (count2 > 0) {
                                            et3 = TString(pe2 + 1, count2);
                                            exterr = atoi(et3.c_str());
                                        }
                                    }
                                }
                            }

                            srvctype = TString(pbuff1);
                            if (srvctype == "U") {
                                res.m_urlreputation = TSrvcErrExt(clt_error, conn_err, exterr);
                            } else if (srvctype == "T") {
                                res.m_textprocessor = TSrvcErrExt(clt_error, conn_err, exterr);
                            } else if (srvctype == "R") {
                                res.m_reputation_get = TSrvcErrExt(clt_error, conn_err, exterr);
                            } else if (srvctype == "RP") {
                                res.m_reputation_put = TSrvcErrExt(clt_error, conn_err, exterr);
                            } else if (srvctype == "H") {
                                res.m_shingler_get = TSrvcErrExt(clt_error, conn_err, exterr);
                            } else if (srvctype == "HP") {
                                res.m_shingler_put = TSrvcErrExt(clt_error, conn_err, exterr);
                            } else if (srvctype == "I") {
                                res.m_statipserver = TSrvcErrExt(clt_error, conn_err, exterr);
                            } else if (srvctype == "L") {
                                res.m_dlvlogserver = TSrvcErrExt(clt_error, conn_err, exterr);
                            } else if (srvctype == "F") {
                                res.m_freemail_get = TSrvcErrExt(clt_error, conn_err, exterr);
                            } else if (srvctype == "FP") {
                                res.m_freemail_put = TSrvcErrExt(clt_error, conn_err, exterr);
                            }
                        }
                    }
                }
                if (!flag_end_str) {
                    pb = pe + 1;
                    if (pb != nullptr) {
                        pe = strchr(pb, ',');
                        if (pe == nullptr) {
                            pe = str.c_str() + str.length();
                            flag_end_str = true;
                        }
                    }
                } else {
                    pb = nullptr;
                    pe = nullptr;
                }
            }
        } while (pe != nullptr);
    }

    return res;
}

bool TParsedDlvLog::ParseDlvLog(const char* BUFF, size_t sizebuff, TParsedDlvLogData& data, bool parse_ip,
                                bool add_dlvlog) {
    TTBuffStruct bdata;

    bool m_ok = false;
    if ((bdata.ValidBuffer()) && (BUFF != nullptr) && (sizebuff > 0)) {
        ui32 strlength = 0;
        ui32 m_buff_pos = 0;
        int buflen = 0;
        TString dlvprefix = "";
        TSTRTYPEDLV strtype = DST_UNKNOWN;
        char* tbuff = nullptr;
        TSummaryIPInfo ipinfo;
        bool is_nextip = false;
        const char* pbuf = nullptr;
        TString tstr = "";
        bool mess_pr = false;
        bool sourceip_pr = false;
        bool spam_pr = false;
        char sshingle[32];
        time_t currtime = time(nullptr);

        if (add_dlvlog)
            data.dlv_log = TString(BUFF, sizebuff);

        bdata.SetLastSymbToNull();
        tbuff = bdata.GetBuff();
        while (m_buff_pos < sizebuff) {
            strlength = GetStr(BUFF + m_buff_pos, sizebuff - m_buff_pos, &tbuff, bdata.size());
            if (strlength > 0) {
                m_buff_pos += strlength;
                buflen = strlen(tbuff);

                dlvprefix = bdata.GetDlvPrefix();
                strtype = GetDlvSType(dlvprefix);

                pbuf = tbuff + dlvprefix.length() + 1;
                tstr = Trim(pbuf);

                //to_lower_k(tstr);

                switch (strtype) {
                    default:
                        break;
                    case DST_RECEIVED:
                        if (parse_ip) {
                            if (GetIPAddressFromRcvd(pbuf, is_nextip, ipinfo)) {
                                if (!is_nextip) {
                                    data.m_exportdata.ipaddresses.sourceip = ipinfo;
                                    sourceip_pr = true;
                                } else
                                    data.m_exportdata.ipaddresses.nextip.push_back(ipinfo);
                            }
                        } else {
                            if (!data.m_exportdata.ipaddresses.sourceip.m_ip.Undefined())
                                sourceip_pr = true;
                        }
                        break;
                    case DST_WEIGHT:
                        ParseWeights(pbuf, data.m_exportdata.m_sp_wght, data.m_exportdata.m_dlv_wght);
                        break;
                    case DST_SPAM:
                        spam_pr = true;
                        if (!STRNCMP(tstr.c_str(), "yes")) {
                            data.m_exportdata.m_messclass = TSpClass::SPAM;
                            data.m_exportdata.m_pmesstype = "yes";
                        } else if (!STRNCMP(tstr.c_str(), "no")) {
                            data.m_exportdata.m_messclass = TSpClass::HAM;
                            data.m_exportdata.m_pmesstype = "no";
                        } else if (!STRNCMP(tstr.c_str(), "dlv")) {
                            data.m_exportdata.m_messclass = TSpClass::DLVR;
                            data.m_exportdata.m_pmesstype = "dlv";
                        } else {
                            data.m_exportdata.m_messclass = TSpClass::UNKNOWN;
                            data.m_exportdata.m_pmesstype = "unknown";
                        }
                        break;
                    case DST_REPORT_SPAM: //r_sp
                        SetSpamRule(tstr.c_str(), data);
                        GetListRule(tstr.c_str(), data.rsp_list);
                        SearchPANNERN_STAT(tstr.c_str(), data);
                        break;
                    case DST_REPORT_DLV: //r_dl
                        SetMetaShingle(tstr.c_str(), data);
                        GetListRule(tstr.c_str(), data.rdl_list);
                        SearchPANNERN_STAT(tstr.c_str(), data);
                        break;
                    case DST_REPORT_NULL: //r_nl
                        SetSpamRuleNL(tstr.c_str(), data);
                        SetNullRule(tstr.c_str(), data);
                        GetListRule(tstr.c_str(), data.rnl_list);
                        SearchPANNERN_STAT(tstr.c_str(), data);
                        SearchSH_17_2(tstr.c_str(), data);
                        break;
                    case DST_RULE_STAT: //r_st
                        GetListRule2(tstr.c_str(), data.rst_list);
                        break;
                    case DST_SOURCE:
                        if (strstr(tstr.c_str(), "source fixed by rule"))
                            data.m_exportdata.m_fFixedByRule = true;
                        if (strstr(tstr.c_str(), "source fixed for domen name"))
                            data.m_exportdata.m_fFixedSource = true;
                        break;
                    case DST_FIXED_BY_RULE:
                        data.m_exportdata.m_fFixedByRule = true;
                        break;
                    case DST_MESSAGE:
                        mess_pr = true;
                        if (tstr.length() > 255)
                            data.m_exportdata.messfull = tstr.substr(0, 255);
                        else
                            data.m_exportdata.messfull = tstr;

                        data.m_exportdata.mbox = TMailBox::Parse_mailboxByID(tstr.c_str(), tstr.length());
                        break;
                    case DST_LOG:
                        ParseShingles(tstr.c_str(), data);
                        break;
                    case DST_SUBJ:
                        data.m_exportdata.m_subj = tstr;
                        break;
                    case DST_HTTP:

                        break;
                    case DST_PHONE:

                        break;
                    case DST_GEO:
                        data.m_exportdata.m_geo = tstr;
                        GetZoneTimeN(data.m_exportdata.m_geo, currtime, &data.m_exportdata.m_geotime, "%H:%M:%S %a %d %m %Y");
                        break;
                    case DST_MESSID:
                        if (tstr.length() > 1) {
                            if ((tstr[0] == '<') && (tstr[tstr.length() - 1] == '>'))
                                data.m_exportdata.m_MessId = tstr.substr(1, tstr.length() - 2);
                            else
                                data.m_exportdata.m_MessId = tstr;
                        } else
                            data.m_exportdata.m_MessId = tstr;
                        if (!data.m_exportdata.m_MessId.empty()) {
                            memset(sshingle, 0, sizeof(sshingle));
                            calc_strcrc64(data.m_exportdata.m_MessId.c_str(), data.m_exportdata.m_MessId.size(), sshingle);
                            sscanf(sshingle, "%" PRIx64, &data.m_exportdata.m_uid);
                        }
                        break;
                    case DST_QUEUEID:
                        data.m_exportdata.m_queueid = tstr;
                        break;
                    case DST_EXTSRVERRORS:
                        data.m_exportdata.m_srvcerr = ParseSrvcErrors(tstr);
                        break;
                };
            }
        }
        m_ok = mess_pr && sourceip_pr && spam_pr;
    }

    return m_ok;
}

//*************************************************************************************************************************************
