#pragma once

#ifndef tparsedlvlog_H
#define tparsedlvlog_H

#include "util/generic/hash.h"
#include "tstatiptypes.h"
#include <list>
#include <mail/so/spamstop/tools/so-common/tparsedlvlog_data.h>

//*************************************************************************************************************************************
//                                       ParsedDlvLog - class for parse delivery logs
//*************************************************************************************************************************************

typedef THashMap<TString, TSTRTYPEDLV> TSTRTYPEDLVHash;
typedef TSTRTYPEDLVHash::iterator TSTRTYPEDLVHashIt;

class TParsedDlvLog {
private:
    TSTRTYPEDLVHash dlvtypehash;

    TSTRTYPEDLV GetDlvSType(const TString& value);
    void ParseWeights(const char* str, float& w1, float& w2);
    ui32 GetStr(const char* source, ui32 source_size, char** destination, ui32 destination_size);
    bool GetIPAddressFromRcvd(const char* tbuff, bool& is_nextip, TSummaryIPInfo& resip);
    void SetSpamRule(const char* pbuf, TParsedDlvLogData& odata);
    void GetListRule(const char* rnl, VP_STR_DBL& list);
    void SearchPANNERN_STAT(const char* buff, TParsedDlvLogData& odata);
    void SetMetaShingle(const char* pbuf, TParsedDlvLogData& odata);
    void SetSpamRuleNL(const char* pbuf, TParsedDlvLogData& odata);
    void SetNullRule(const char* pbuf, TParsedDlvLogData& odata);
    void SearchSH_17_2(const char* buff, TParsedDlvLogData& odata);
    void GetListRule2(const char* rst, TWorkRuleListExt& list);
    void ParseShingles(const char* tbuff, TParsedDlvLogData& odata);
    TSrvcErr ParseSrvcErrors(const TString& str);

public:
    TParsedDlvLog();
    ~TParsedDlvLog();

    bool ParseDlvLog(const char* BUFF, size_t sizebuff, TParsedDlvLogData& data, bool parse_ip, bool add_dlvlog);
    TIPAddresses GetIPAddress(const char* BUFF, ui32 BuffSize);
    TSpClass GetSpamType(const char* BUFF, ui32 BuffSize);
};

//*************************************************************************************************************************************

#endif
