#include "tperiodiptrap.h"
#include <util/string/reverse.h>

//***********************************************************************************
//                               TViewItemClass
//***********************************************************************************

TViewItemClass::TViewItemClass()
{
   Clear();
}

TViewItemClass::TViewItemClass(TKIPv6 ip, time_t t, TPTIIPInfo ifi, ui8 sorttype)
{
   Clear();

   m_ip          = ip;
   m_ham         = ifi.ham;
   m_spam        = ifi.spam;
   m_malic       = ifi.malic;
   m_ham_today   = ifi.ham_today;
   m_spam_today  = ifi.spam_today;
   m_malic_today = ifi.malic_today;
   m_visfrwd     = ifi.visfrwd;
   m_geo         = ifi.geo;
   m_noban       = ifi.noban;

   if ( (!ifi.rdns3.empty()) && (ifi.rdns3 != "-") )
      m_reverse_rdns = ifi.rdns3;
   else
      m_reverse_rdns = ifi.rdns2;
   m_rdns_isx    = ifi.rdns;
   m_rdns        = m_reverse_rdns;
   ReverseInPlace(m_reverse_rdns);

   m_duration  = (ifi.lasttime - t) > 0 ? (ifi.lasttime - t) : 0;
   m_sorttype  = sorttype;

}

TViewItemClass::~TViewItemClass()
{

}

bool TViewItemClass::operator<(const TViewItemClass &value) const
{
  bool res = false;

  switch (m_sorttype)
  {
   case 0:
             res = m_ip.toStroka() < value.m_ip.toStroka();
             break;
   case 1:
             res = m_ham > value.m_ham;
             break;
   case 2:
             res = m_spam > value.m_spam;
             break;
   case 3:
             res = m_malic > value.m_malic;
             break;
   case 4:
             res = m_duration > value.m_duration;
             break;
   case 5:
             res = m_reverse_rdns > value.m_reverse_rdns;
             break;
   case 6:
             res = (m_ham + m_spam) > (value.m_ham + value.m_spam);
             break;
   case 7:
             res = m_geo < value.m_geo;
             break;
   default:
             res = m_spam > value.m_spam;
  };

  return res;
}

void TViewItemClass::Clear()
{
   m_ip           = TKIPv6();
   m_ham          = 0;
   m_spam         = 0;
   m_malic        = 0;
   m_ham_today    = 0;
   m_spam_today   = 0;
   m_malic_today  = 0;
   m_reverse_rdns = "";
   m_rdns_isx     = "";
   m_rdns.clear();
   m_duration     = 0;
   m_sorttype     = 0;
   m_visfrwd      = false;
   m_geo          = "";
   m_noban        = false;
}

//***********************************************************************************
//                               TIPTrapItem
//***********************************************************************************

/*TPeriodTrapItem::TPeriodTrapItem(time_t startA, ui32 periodA, const TString &filenameA)
{
   m_filedata = NULL;
   m_start = startA;

   if (periodA < MINPERIOD)
      m_period = MINPERIOD;
   else if (periodA > MAXPERIOD)
      m_period = MAXPERIOD;
   else
      m_period = periodA;

   m_trapfilename = filenameA;
   m_stoptime     = 0;
   m_allmails     = 0;
   StartRecord();
}*/

TPeriodTrapItem::TPeriodTrapItem(time_t startA, ui32 periodA, const TString &filenameA, const TString &substrA, bool is_pcreA)
{
   m_filedata = NULL;
   m_start = startA;

   if (periodA < MINPERIOD)
      m_period = MINPERIOD;
   else if (periodA > MAXPERIOD)
      m_period = MAXPERIOD;
   else
      m_period = periodA;

   m_trapfilename = filenameA;
   m_stoptime     = 0;
   m_allmails     = 0;

   m_substr       = substrA;
   m_is_pcre      = is_pcreA;
   m_dlvlog_rcv   = 0;
   m_dlvlog_skeep = 0;

   StartRecord();
}

TPeriodTrapItem::~TPeriodTrapItem()
{
   if (m_filedata != NULL)
   {
      delete m_filedata;
      m_filedata = NULL;
   }
}

void TPeriodTrapItem::Lock()
{
   m_Mutex.Acquire();
}

void TPeriodTrapItem::UnLock()
{
   m_Mutex.Release();
}

void TPeriodTrapItem::AddMailIn(TPTIIPInfo &ipi, TSpClass type, time_t t, TString host, TString host2, TString host3, const char *mess, ui32 messsize, bool malic, TMemRecordCopy mrc, bool visfrwd, bool whiteip, const TString &geo, bool ban)
{
   bool        malicspam   = false;
   TString      pstr        = PR_FLAGEND;
   const char  *p          = NULL;
   ui32        messsizenew = 0;
   i64         pos         = 0;

   malicspam  = malic && (type == TSpClass::SPAM);

   switch(type)
   {
    case TSpClass::HAM:
    case TSpClass::DLVR:
                                    if (ipi.ham < MAX32BITVALUE)
                                       ++ipi.ham;
                                    break;
    case TSpClass::SPAM:
                                    if (ipi.spam < MAX32BITVALUE)
                                       ++ipi.spam;
                                    break;

    default:
                                    break;
   };

   if (malicspam)
   {
      if (ipi.malic < MAX32BITVALUE)
         ++ipi.malic;
   }

   ipi.rdns = Trim(host);
   ipi.rdns2 = Trim(host2);
   ipi.rdns3 = Trim(host3);

   if (!geo.empty())
      ipi.geo = geo;

   ipi.lasttime = t;

   ipi.ham_today   = mrc.today.ctHam;
   ipi.spam_today  = mrc.today.ctSpam;
   ipi.malic_today = mrc.today.ctMalicSpam;

   ipi.visfrwd = visfrwd;
   ipi.whiteip = whiteip;

   if (!ban)
      ipi.noban = true;

   if ((mess != NULL) && (messsize > 0))
   {
      try
      {
         if (ipi.size1mail == 0)
         {
            if ( (m_filedata != NULL) && (m_filedata->IsOpen()) )
            {
               pos = m_filedata->Seek(0, sEnd);
               if (pos != -1L)
               {
                  ipi.pos1mail = m_filedata->GetPosition();
                  p = strstr(mess, pstr.c_str());
                  if (p != NULL)
                  {
                     messsizenew = p - mess;
                     if ((messsizenew > 0) && (messsizenew < messsize))
                     {
                        m_filedata->Write(mess, messsizenew);
                        ipi.size1mail = messsizenew;
                     }
                  } else
                  {
                     m_filedata->Write(mess, messsize);
                     ipi.size1mail = messsize;
                  }
               }
            }

         } else if (ipi.size2mail == 0)
         {
            if ( (m_filedata != NULL) && (m_filedata->IsOpen()) )
            {
               pos = m_filedata->Seek(0, sEnd);
               if (pos != -1L)
               {
                  ipi.pos2mail = m_filedata->GetPosition();
                  p = strstr(mess, pstr.c_str());
                  if (p != NULL)
                  {
                     messsizenew = p - mess;
                     if ((messsizenew > 0) && (messsizenew < messsize))
                     {
                        m_filedata->Write(mess, messsizenew);
                        ipi.size2mail = messsizenew;
                     }
                  } else
                  {
                     m_filedata->Write(mess, messsize);
                     ipi.size2mail = messsize;
                  }
               }
            }

         } else if (ipi.size3mail == 0)
         {
            if ( (m_filedata != NULL) && (m_filedata->IsOpen()) )
            {
               pos = m_filedata->Seek(0, sEnd);
               if (pos != -1L)
               {
                  ipi.pos3mail = m_filedata->GetPosition();
                  p = strstr(mess, pstr.c_str());
                  if (p != NULL)
                  {
                     messsizenew = p - mess;
                     if ((messsizenew > 0) && (messsizenew < messsize))
                     {
                        m_filedata->Write(mess, messsizenew);
                        ipi.size3mail = messsizenew;
                     }
                  } else
                  {
                     m_filedata->Write(mess, messsize);
                     ipi.size3mail = messsize;
                  }
               }
            }

         }

      } catch(...)
      {

      }
   }
}

void TPeriodTrapItem::StartRecord()
{
   m_busy     = true;
   m_stoptime = 0;

   //if ( (!m_filedata.IsOpen()) && (!m_trapfilename.empty()) )
   //   m_filedata.Open(m_trapfilename.c_str(), O_CREAT | O_TRUNC | O_RDWR | O_BINARY, Os::File::PermRdWr);
   if (m_filedata != NULL)
   {
      delete m_filedata;
      m_filedata = NULL;
   }
   if (!m_trapfilename.empty())
      m_filedata = new TFile(m_trapfilename, OpenAlways | RdWr);
}

void TPeriodTrapItem::StopRecord()
{
   Lock();

   if (m_busy)
   {
      m_busy     = false;
      m_stoptime = time(NULL);
   }

   UnLock();
}

void TPeriodTrapItem::AddMailA(TKIPv6 ip, TSpClass type, time_t t, const TString &host, const TString &host2, const TString &host3, const char *mess, ui32 messsize, bool malic, TMemRecordCopy mrc, bool visfrwd, bool whiteip, const TString &remote_ip, const TString &geo, bool ban)
{
   TPTIIPInfoHashIt it;
   time_t           current_time = time(NULL);
   TRemoteIPListIt  ipit;
   bool             skeep        = false;
   const char       *p           = NULL;

   if (!m_substr.empty())
   {
      if ( (mess != NULL) && (messsize > 0) )
      {
         if (m_is_pcre)
         {
            skeep = false;

         } else
         {
            p = strstr(mess, m_substr.c_str());
            if (p == NULL)
               skeep = true;
            else
               skeep = false;

         }
      }
   }

   Lock();

   if (!skeep)
   {
      m_dlvlog_rcv = IncMax32(m_dlvlog_rcv, 1);

      it = data.find(ip);
      if (it != data.end())
      {
         AddMailIn((*it).second, type, t, host, host2, host3, mess, messsize, malic, mrc, visfrwd, whiteip, geo, ban);

      } else
      {
         TPTIIPInfo ipi;

         AddMailIn(ipi, type, t, host, host2, host3, mess, messsize, malic, mrc, visfrwd, whiteip, geo, ban);
         data[ip] = ipi;
      }

      if (!remote_ip.empty())
      {
         ipit = remiplist.find(remote_ip);
         if (ipit != remiplist.end())
         {
            (*ipit).second = IncMax32((*ipit).second, 1);

         } else
         {
            remiplist[remote_ip] = 1;

         }

      }

   } else
   {
      m_dlvlog_skeep = IncMax32(m_dlvlog_skeep, 1);

   }

   m_allmails = IncMax32(m_allmails, 1);

   if (current_time > m_start)
   {
      if ((current_time - m_start) >= m_period)
      {
         m_busy     = false;
         m_stoptime = time(NULL);
      }

   } else
   {
      m_busy     = false;
      m_stoptime = time(NULL);
   }

   UnLock();
}

void TPeriodTrapItem::AddMail(TKIPv6 ip, TSpClass type, time_t t, const TString &host, const TString &host2, const TString &host3, const char *mess, ui32 messsize, bool malic, TMemRecordCopy mrc, bool visfrwd, bool whiteip, const TString &remote_ip, const TString &geo)
{
   AddMailA(ip, type, t, host, host2, host3, mess, messsize, malic, mrc, visfrwd, whiteip, remote_ip, geo, false);
}

void TPeriodTrapItem::AddMailBan(TKIPv6 ip, TSpClass type, time_t t, const TString &host, const TString &host2, const TString &host3, const char *mess, ui32 messsize, bool malic, TMemRecordCopy mrc, bool visfrwd, bool whiteip, const TString &remote_ip, const TString &geo)
{
   AddMailA(ip, type, t, host, host2, host3, mess, messsize, malic, mrc, visfrwd, whiteip, remote_ip, geo, true);
}

TString TPeriodTrapItem::GetModGeo(const TString &geo)
{
   TString     res    = "";
   const char *p     = NULL;
   int        count  = 0;

   if (!geo.empty())
   {
      res = Trim(geo);
      to_lower_k(res);
      if (!res.empty())
      {
         p = strchr(res.c_str(), ' ');
         if (p != NULL)
         {
            count = p - res.c_str();
            if (count > 0)
               res = TString(res.c_str(), count);
         }
      }
   }

   return res;
}

void TPeriodTrapItem::GetData(ui8 sorttype, TViewItemClassList &reslist, ui32 mincount, ui32 mincounttd, bool markbanip, TWhtIp whtip, int onlybanip, TRemoteIPList &remote_iplist, ui32 &allip, ui32 &allmails, TString &substr, bool &is_pcre, ui32 &dlvlog_rcv, ui32 &dlvlog_skeep, ui32 max_count_today, const TString &geo)
{
   TPTIIPInfoHashIt it;
   time_t           t            = time(NULL);
   bool             flag1        = false;
   bool             flag2        = false;
   bool             flag3        = false;
   bool             flag4        = false;
   bool             flag5        = false;
   TString           geomod       = "";
   TString           geomod_item  = "";

   reslist.clear();

   geomod = GetModGeo(geo);

   Lock();

   substr       = m_substr;
   is_pcre      = m_is_pcre;
   dlvlog_rcv   = m_dlvlog_rcv;
   dlvlog_skeep = m_dlvlog_skeep;

   allmails = m_allmails;
   allip = data.size();
   it = data.begin();
   while (it != data.end())
   {
      flag1 = false;
      flag2 = false;
      flag3 = false;
      flag4 = false;
      flag5 = false;

      if (((*it).second.ham + (*it).second.spam) >= mincount)
         flag1 = true;
      else
         flag1 = false;
      if (((*it).second.ham_today + (*it).second.spam_today) >= mincounttd)
         flag2 = true;
      else
         flag2 = false;

      if (whtip == WHTALL)
         flag3 = true;
      if ( ((*it).second.whiteip) && (whtip == WHTYES) )
         flag3 = true;
      if ( (!(*it).second.whiteip) && (whtip == WHTNO) )
         flag3 = true;

      if (max_count_today == 0)
      {
         flag4 = true;

      } else
      {
         if ((*it).second.ham_today <= max_count_today)
            flag4 = true;
      }

      if (geomod.empty())
      {
         flag5 = true;

      } else
      {
         geomod_item = GetModGeo((*it).second.geo);
         if (geomod == geomod_item)
            flag5 = true;
      }

      if (flag1 && flag2 && flag3 && flag4 && flag5)
         reslist.push_back(TViewItemClass((*it).first, m_start, (*it).second, sorttype));

      ++it;
   }

   remote_iplist = remiplist;

   UnLock();

   reslist.sort();

}

void TPeriodTrapItem::GetDataFA(ui8 sorttype, TViewItemClassList &reslist, ui32 mincount, ui32 mincounttd, bool markbanip, TWhtIp whtip, int onlybanip, TRemoteIPList &remote_iplist, ui32 &allip, ui32 &allmails, TString &substr, bool &is_pcre, ui32 &dlvlog_rcv, ui32 &dlvlog_skeep, ui32 max_count_today, const TString &geo, TNetKIPv6 &addr_list)
{
   TPTIIPInfoHashIt it;
   time_t           t            = time(NULL);

   reslist.clear();

   Lock();

   substr       = m_substr;
   is_pcre      = m_is_pcre;
   dlvlog_rcv   = m_dlvlog_rcv;
   dlvlog_skeep = m_dlvlog_skeep;

   allmails = m_allmails;
   allip = data.size();
   it = data.begin();
   while (it != data.end())
   {
      if (addr_list.IsInNet((*it).first))
         reslist.push_back(TViewItemClass((*it).first, m_start, (*it).second, sorttype));

      ++it;
   }

   remote_iplist = remiplist;

   UnLock();

   reslist.sort();
}

void TPeriodTrapItem::ViewMails(TTrapMails &slist, TKIPv6 ip)
{
   TPTIIPInfoHashIt it;
   char             *buff = NULL;
   ui32             maxbuffsize = 0;
   i32              count = 0;
   TString           s = "";

   Lock();

   it = data.find(ip);
   if (it != data.end())
   {
      if ((*it).second.size1mail > maxbuffsize)
         maxbuffsize = (*it).second.size1mail;
      if ((*it).second.size2mail > maxbuffsize)
         maxbuffsize = (*it).second.size2mail;
      if ((*it).second.size3mail > maxbuffsize)
         maxbuffsize = (*it).second.size3mail;

      if ( (m_filedata != NULL) && (maxbuffsize > 0) )
      {
         buff = new char[maxbuffsize + 1];
         if ((*it).second.size1mail > 0)
         {
             memset(buff, 0, maxbuffsize + 1);
             m_filedata->Seek((*it).second.pos1mail, sSet);
             count = m_filedata->Read(buff, (*it).second.size1mail);
             if (count == (*it).second.size1mail)
             {
                s = FormatHTMLPrint(buff, count);
                slist.data.push_back(s);
             }
         }
         if ((*it).second.size2mail > 0)
         {
            memset(buff, 0, maxbuffsize + 1);
            m_filedata->Seek((*it).second.pos2mail, sSet);
             count = m_filedata->Read(buff, (*it).second.size2mail);
             if (count == (*it).second.size2mail)
             {
                s = FormatHTMLPrint(buff, count);
                slist.data.push_back(s);
             }
         }
         if ((*it).second.size3mail > 0)
         {
             memset(buff, 0, maxbuffsize + 1);
             m_filedata->Seek((*it).second.pos3mail, sSet);
             count = m_filedata->Read(buff, (*it).second.size3mail);
             if (count == (*it).second.size3mail)
             {
                s = FormatHTMLPrint(buff, count);
                slist.data.push_back(s);
             }
         }

         delete[] buff;
         buff = NULL;
      }


   } else
   {
      slist.data.push_back("No mails found.");
   }


   UnLock();

}

void TPeriodTrapItem::Del()
{
   if (m_filedata != NULL)
   {
      delete m_filedata;
      m_filedata = NULL;
   }
   if (!m_trapfilename.empty())
      remove(m_trapfilename.c_str());

}

//***********************************************************************************
//                              TPeriodIPTrap
//***********************************************************************************

TPeriodTrap::TPeriodTrap()
{
   lastcheckerase = 0;
   cashtrap       = NULL;
   m_trapfilename = "";
   m_lastchangetrap = 0;
}

TPeriodTrap::~TPeriodTrap()
{
   TPeriodTrapListIt it;

   it = data.begin();
   while (it != data.end())
   {
      if ((*it) != NULL)
      {
         (*it)->Del();
         delete (*it);
         (*it) = NULL;
      }

      ++it;
   }
   data.clear();

}

void TPeriodTrap::Lock()
{
   m_Mutex.Acquire();
}

void TPeriodTrap::UnLock()
{
   m_Mutex.Release();
}

void TPeriodTrap::Init(const TString &trapfilenameA)
{
   m_trapfilename = trapfilenameA;
}

TPeriodTrapItem *TPeriodTrap::GetTrapitem(time_t t)
{
   TPeriodTrapItem   *res = NULL;
   TPeriodTrapListIt it;
   time_t            tbegin = 0, tend = 0;

   Lock();

   if (t != m_lastchangetrap)
   {
      cashtrap = NULL;

      it = data.begin();
      while (it != data.end())
      {
         if ((*it) != NULL)
         {
            tbegin = (*it)->start();
            tend = (*it)->start() + (*it)->period();

            if ((t >= tbegin) && (t <= tend))
            {
               res = (*it);
               cashtrap = res;
               break;
            }
         }

         ++it;
      }
      m_lastchangetrap = t;
   } else
   {
      res = cashtrap;
   }

   UnLock();

   return res;
}

int TPeriodTrap::AddPeriodTrap(ui32 period, ui32 &id, ui8 sorttype, TIDTrapInfo &resdata, ui32 mincount, ui32 mincounttd, bool markbanip, TWhtIp whtip, int onlybanip, TString &substr, bool &is_pcre, ui32 max_count_today, const TString &geo)
{
   int               res            = 0;
   time_t            t              = time(NULL);
   TPeriodTrapListIt it;
   time_t            tbegin         = 0, tend = 0;
   bool              exists         = false;
   TPeriodTrapItem   *pti           = NULL;
   ui32              tdiff          = 0;
   ui32              dlvlog_rcv     = 0;
   ui32              dlvlog_skeep   = 0;

   Lock();

   it = data.begin();
   while (it != data.end())
   {
      if ((*it) != NULL)
      {
         tbegin = (*it)->start();
         tend = (*it)->start() + (*it)->period();

         if ((t >= tbegin) && (t <= tend))
         {
            res = tend - t;
            id = tbegin;
            exists = true;
            break;
         }
      }

      ++it;
   }
   if (!exists)
   {
      TString filename = m_trapfilename + "_" + IntToStroka(t);
      pti = new TPeriodTrapItem(t, period, filename, substr, is_pcre);
      data.push_back(pti);
      //res = 0;
      res = period;
      id = t;
   }

   UnLock();

   if (res == 0)
   {
      if (pti != NULL)
      {
         resdata.start = pti->start();
         resdata.period = pti->period();

         tdiff = t - pti->start();
         while (tdiff <= pti->period())
         {
            ::sleep(1);
            tdiff = time(NULL) - pti->start();
         }

         pti->StopRecord();
         pti->GetData(sorttype, resdata.data, mincount, mincounttd, markbanip, whtip, onlybanip, resdata.remote_iplist, resdata.allip, resdata.allmails, substr, is_pcre, dlvlog_rcv, dlvlog_skeep, max_count_today, geo);
      } else
      {
         res = -2;
      }
   }

   return res;
}

int TPeriodTrap::GetTrapList(TKItemInfoList &slist)
{
   int               res = 0;
   TPeriodTrapListIt it;
   TKItemInfo        kii;

   Lock();

   slist.clear();
   it = data.begin();
   while (it != data.end())
   {
      if ((*it) != NULL)
      {
         kii.starttime     = (*it)->start();
         kii.period        = (*it)->period();
         kii.ident         = IntToStroka((*it)->start());
         kii.substr        = (*it)->substr();
         kii.is_pcre       = (*it)->is_pcre();
         kii.dlvlog_rcv    = (*it)->dlvlog_rcv();
         kii.dlvlog_skeep  = (*it)->dlvlog_skeep();

         slist.push_back(kii);
      }
      ++it;
   }
   res = slist.size();

   UnLock();

   return res;
}

void TPeriodTrap::EraseOld()
{
   TPeriodTrapListIt it;
   TPeriodTrapListIt it_rem;
   time_t            t = time(NULL);

   Lock();

   if ((t - lastcheckerase) > 10)
   {
      it = data.begin();
      while (it != data.end())
      {
         if ( ((*it) != NULL) && ( (t - (*it)->start() - (*it)->period()) >= LIVETIMEPERIOD) )
         {
            if (cashtrap == (*it))
            {
               cashtrap = NULL;
               m_lastchangetrap = 0;
            }
            (*it)->Del();
            delete (*it);
            (*it) = NULL;

            data.erase(it++);
         } else
            ++it;
      }
      lastcheckerase = t;
   }

   UnLock();
}

bool TPeriodTrap::EraseItem(ui32 id)
{
   bool              res = false;
   TPeriodTrapListIt it;

   Lock();

   it = data.begin();
   while (it != data.end())
   {
      if ( ((*it) != NULL) && ((*it)->start() == id) )
      {
         if (cashtrap == (*it))
         {
            cashtrap = NULL;
            m_lastchangetrap = 0;
         }
         (*it)->Del();
         delete (*it);
         (*it) = NULL;

         data.erase(it);
         res = true;
         break;
      }

      ++it;
   }

   UnLock();

   return res;
}

int TPeriodTrap::View(ui32 id, ui8 sorttype, TIDTrapInfo &resdata, ui32 mincount, ui32 mincounttd, bool markbanip, TWhtIp whtip, int onlybanip, TString &substr, bool &is_pcre, ui32 &dlvlog_rcv, ui32 &dlvlog_skeep, ui32 max_count_today, const TString &geo)
{
   int               res      = 0;
   TPeriodTrapListIt it;
   bool              exists   = false;
   time_t            t        = time(NULL);
   i32               tdiff    = 0;
   time_t            start_t  = 0;
   ui32              period_t = 0;

   Lock();

   dlvlog_rcv   = 0;
   dlvlog_skeep = 0;

   it = data.begin();
   while (it != data.end())
   {
      if ( ((*it) != NULL) && ((*it)->start() == id) )
      {
         start_t  = (*it)->start();
         period_t = (*it)->period();

         if (t > (*it)->start())
         {
            if ((t - (*it)->start()) >= (*it)->period())
               (*it)->StopRecord();

         } else
         {
            (*it)->StopRecord();
         }

         if ((*it)->busy())
         {
            tdiff = (*it)->start() + (*it)->period() - t;
            res = (tdiff > 0) ? tdiff: 1;

         } else
         {
            resdata.start        = (*it)->start();
            resdata.period       = (*it)->period();
            resdata.stoptime     = (*it)->stoptime();
            resdata.rcv_dlvlog   = (*it)->dlvlog_rcv();
            resdata.skeep_dlvlog = (*it)->dlvlog_skeep();
            (*it)->GetData(sorttype, resdata.data, mincount, mincounttd, markbanip, whtip, onlybanip, resdata.remote_iplist, resdata.allip, resdata.allmails, substr, is_pcre, dlvlog_rcv, dlvlog_skeep, max_count_today, geo);
         }

         exists = true;
         break;
      }

      ++it;
   }

   UnLock();

   if (!exists)
      res = -1;

   return res;
}

int TPeriodTrap::ViewFA(ui32 id, ui8 sorttype, TIDTrapInfo &resdata, ui32 mincount, ui32 mincounttd, bool markbanip, TWhtIp whtip, int onlybanip, TString &substr, bool &is_pcre, ui32 &dlvlog_rcv, ui32 &dlvlog_skeep, ui32 max_count_today, const TString &geo, TNetKIPv6 &addr_list)
{
   int               res      = 0;
   TPeriodTrapListIt it;
   bool              exists   = false;
   time_t            t        = time(NULL);
   i32               tdiff    = 0;
   time_t            start_t  = 0;
   ui32              period_t = 0;

   Lock();

   dlvlog_rcv   = 0;
   dlvlog_skeep = 0;

   it = data.begin();
   while (it != data.end())
   {
      if ( ((*it) != NULL) && ((*it)->start() == id) )
      {
         start_t  = (*it)->start();
         period_t = (*it)->period();

         if (t > (*it)->start())
         {
            if ((t - (*it)->start()) >= (*it)->period())
               (*it)->StopRecord();

         } else
         {
            (*it)->StopRecord();
         }

         if ((*it)->busy())
         {
            tdiff = (*it)->start() + (*it)->period() - t;
            res = (tdiff > 0) ? tdiff: 1;

         } else
         {
            resdata.start        = (*it)->start();
            resdata.period       = (*it)->period();
            resdata.stoptime     = (*it)->stoptime();
            resdata.rcv_dlvlog   = (*it)->dlvlog_rcv();
            resdata.skeep_dlvlog = (*it)->dlvlog_skeep();
            (*it)->GetDataFA(sorttype, resdata.data, mincount, mincounttd, markbanip, whtip, onlybanip, resdata.remote_iplist, resdata.allip, resdata.allmails, substr, is_pcre, dlvlog_rcv, dlvlog_skeep, max_count_today, geo, addr_list);
         }

         exists = true;
         break;
      }

      ++it;
   }

   UnLock();

   if (!exists)
      res = -1;

   return res;
}

void TPeriodTrap::AddMail(TKIPv6 ip, TSpClass type, time_t t, TString host, TString host2, TString host3, const char *mess, ui32 messsize, bool malic, TMemRecordCopy mrc, bool visfrwd, bool whiteip, const TString &remote_ip, ui32 &remaintime, const TString &geo)
{
   TPeriodTrapItem *pti          = NULL;
   ui32            to            = 0;
   ui32            currenttime   = time(NULL);

   remaintime    = 0;
   pti = GetTrapitem(t);
   if (pti != NULL)
   {
      pti->AddMail(ip, type, t, host, host2, host3, mess, messsize, malic, mrc, visfrwd, whiteip, remote_ip, geo);

      to = pti->start() + pti->period();
      if (to > currenttime)
         remaintime = to - currenttime;
   }
}

void TPeriodTrap::ViewMails(ui32 id, TTrapMails &slist, TKIPv6 ip)
{
   TPeriodTrapListIt it;

   Lock();

   it = data.begin();
   while (it != data.end())
   {
      if ( ((*it) != NULL) && ((*it)->start() == id) )
      {
         slist.start = (*it)->start();
         slist.period = (*it)->period();
         (*it)->ViewMails(slist, ip);
         break;
      }

      ++it;
   }

   UnLock();

}

void TPeriodTrap::AddBanMail(TKIPv6 ip, TSpClass type, time_t t, const TString &host, const TString &host2, const TString &host3, const char *mess, ui32 messsize, bool malic, const TString &remote_ip, const TString &geo)
{
   TPeriodTrapItem   *pti     = NULL;
   TMemRecordCopy    mrc;
   bool              visfrwd  = false;
   bool              whiteip  = false;

   mrc.today.ctSpam      = -1;
   mrc.today.ctHam       = -1;
   mrc.today.ctMalicSpam = -1;

   pti = GetTrapitem(t);
   if (pti != NULL)
      pti->AddMail(ip, type, t, host, host2, host3, mess, messsize, malic, mrc, visfrwd, whiteip, remote_ip, geo);
}

void TPeriodTrap::AddBanMailBan(TKIPv6 ip, TSpClass type, time_t t, const TString &host, const TString &host2, const TString &host3, const char *mess, ui32 messsize, bool malic, const TString &remote_ip, const TString &geo)
{
   TPeriodTrapItem   *pti     = NULL;
   TMemRecordCopy    mrc;
   bool              visfrwd  = false;
   bool              whiteip  = false;

   mrc.today.ctSpam      = -1;
   mrc.today.ctHam       = -1;
   mrc.today.ctMalicSpam = -1;

   pti = GetTrapitem(t);
   if (pti != NULL)
      pti->AddMailBan(ip, type, t, host, host2, host3, mess, messsize, malic, mrc, visfrwd, whiteip, remote_ip, geo);
}

//**********************************************************************************
