#pragma once

#include <util/generic/string.h>
#include "util/system/mutex.h"
#include "util/generic/hash.h"
#include "util/system/file.h"
#include <mail/so/spamstop/tools/so-common/kfunc.h>
#include <mail/so/spamstop/tools/so-common/tkipv6.h>
#include <mail/so/spamstop/tools/so-common/tkipv6classes.h>
#include "tstatiptypes.h"
#include "tbasesstore_types.h"
#include <time.h>
#include <list>

//***********************************************************************************
//                               TPTIIPInfo
//***********************************************************************************

struct TPTIIPInfo
{
   ui32   ham;
   ui32   spam;
   ui32   malic;
   ui32   ham_today;
   ui32   spam_today;
   ui32   malic_today;
   TString rdns;
   TString rdns2;
   TString rdns3;
   time_t lasttime;
   i64    pos1mail;
   ui32   size1mail;
   i64    pos2mail;
   ui32   size2mail;
   i64    pos3mail;
   ui32   size3mail;
   bool   visfrwd;
   bool   whiteip;
   TString geo;
   bool   noban;

   TPTIIPInfo()
   {
      ham         = 0;
      spam        = 0;
      malic       = 0;
      ham_today   = 0;
      spam_today  = 0;
      malic_today = 0;
      rdns        = "";
      rdns2       = "";
      rdns3       = "";
      lasttime    = 0;
      pos1mail    = 0;
      size1mail   = 0;
      pos2mail    = 0;
      size2mail   = 0;
      pos3mail    = 0;
      size3mail   = 0;
      visfrwd     = false;
      whiteip     = false;
      geo         = "";
      noban       = false;
   }
};

//***********************************************************************************
//                               TViewItemClass
//***********************************************************************************

class TViewItemClass
{
private:
         TKIPv6 m_ip;
         ui32   m_ham;
         ui32   m_spam;
         ui32   m_malic;
         ui32   m_ham_today;
         ui32   m_spam_today;
         ui32   m_malic_today;
         TString m_reverse_rdns;
         TString m_rdns_isx;
         TString m_rdns;
         ui32   m_duration;
         ui8    m_sorttype;
         bool   m_visfrwd;
         TString m_geo;
         bool   m_noban;
public:
         TViewItemClass();
         TViewItemClass(TKIPv6 ip, time_t t, TPTIIPInfo ifi, ui8 sorttype);
         ~TViewItemClass();

         bool operator<(const TViewItemClass &value) const;

         void   Clear();
         TKIPv6 ip()           const { return m_ip;           }
         ui32   ham()          const { return m_ham;          }
         ui32   spam()         const { return m_spam;         }
         ui32   malic()        const { return m_malic;        }
         ui32   ham_today()    const { return m_ham_today;    }
         ui32   spam_today()   const { return m_spam_today;   }
         ui32   malic_today()  const { return m_malic_today;  }
         TString reverse_rdns() const { return m_reverse_rdns; }
         TString rdns_isx()     const { return m_rdns_isx;     }
         TString rdns()         const { return m_rdns;         }
         ui32   duration()     const { return m_duration;     }
         bool   visfrwd()      const { return m_visfrwd;      }
         TString geo()          const { return m_geo;          }
         bool   noban()        const { return m_noban;        }
};

typedef std::list<TViewItemClass>    TViewItemClassList;
typedef TViewItemClassList::iterator TViewItemClassListIt;

typedef THashMap<TString, ui32>        TRemoteIPList;
typedef TRemoteIPList::iterator    TRemoteIPListIt;

struct TIDTrapInfo
{
   time_t             start;
   ui32               period;
   time_t             stoptime;
   TViewItemClassList data;
   TRemoteIPList      remote_iplist;
   ui32               allip;
   ui32               allmails;
   ui32               rcv_dlvlog;
   ui32               skeep_dlvlog;

   TIDTrapInfo()
   {
      start          = 0;
      period         = 0;
      stoptime       = 0;
      data.clear();
      remote_iplist.clear();
      allip          = 0;
      allmails       = 0;
      rcv_dlvlog     = 0;
      skeep_dlvlog   = 0;
   }
};

typedef std::list<TString>        TKStrokaList;
typedef TKStrokaList::iterator   TKStrokaListIt;

struct TTrapMails
{
   time_t             start;
   ui32               period;
   TKStrokaList       data;

   TTrapMails()
   {
      start  = 0;
      period = 0;
      data.clear();
   }
};

//***********************************************************************************
//                               TIPTrapItem
//***********************************************************************************

typedef THashMap<TKIPv6, TPTIIPInfo>  TPTIIPInfoHash;
typedef TPTIIPInfoHash::iterator   TPTIIPInfoHashIt;

class TPeriodTrapItem
{
private:
         static const ui32 MINPERIOD = 5;
         static const ui32 MAXPERIOD = 600;

         TPTIIPInfoHash    data;
         TRemoteIPList     remiplist;
         TMutex            m_Mutex;
         time_t            m_start;
         ui32              m_period;
         bool              m_busy;
         time_t            m_stoptime;
         TFile             *m_filedata;
         TString            m_trapfilename;
         ui32              m_allmails;
         TString            m_substr;
         bool              m_is_pcre;
         ui32              m_dlvlog_rcv;
         ui32              m_dlvlog_skeep;

         void Lock();
         void UnLock();

         void   AddMailIn(TPTIIPInfo &ipi, TSpClass type, time_t t, TString host, TString host2, TString host3, const char *mess, ui32 messsize, bool malic, TMemRecordCopy mrc, bool visfrwd, bool whiteip, const TString &geo, bool ban);
         void   AddMailA(TKIPv6 ip, TSpClass type, time_t t, const TString &host, const TString &host2, const TString &host3, const char *mess, ui32 messsize, bool malic, TMemRecordCopy mrc, bool visfrwd, bool whiteip, const TString &remote_ip, const TString &geo, bool ban);
         void   StartRecord();
public:
         //TPeriodTrapItem(time_t startA, ui32 periodA, const TString &filenameA);
         TPeriodTrapItem(time_t startA, ui32 periodA, const TString &filenameA, const TString &substr, bool is_pcre);
         ~TPeriodTrapItem();

         time_t start()        const { return m_start;        }
         ui32   period()       const { return m_period;       }
         bool   busy()         const { return m_busy;         }
         time_t stoptime()     const { return m_stoptime;     }
         TString substr()       const { return m_substr;       }
         bool   is_pcre()      const { return m_is_pcre;      }
         ui32   dlvlog_rcv()   const { return m_dlvlog_rcv;   }
         ui32   dlvlog_skeep() const { return m_dlvlog_skeep; }

         void   StopRecord();
         void   AddMail(TKIPv6 ip, TSpClass type, time_t t, const TString &host, const TString &host2, const TString &host3, const char *mess, ui32 messsize, bool malic, TMemRecordCopy mrc, bool visfrwd, bool whiteip, const TString &remote_ip, const TString &geo);
         void   AddMailBan(TKIPv6 ip, TSpClass type, time_t t, const TString &host, const TString &host2, const TString &host3, const char *mess, ui32 messsize, bool malic, TMemRecordCopy mrc, bool visfrwd, bool whiteip, const TString &remote_ip, const TString &geo);
         void   GetData(ui8 sorttype, TViewItemClassList &reslist, ui32 mincount, ui32 mincounttd, bool markbanip, TWhtIp whtip, int onlybanip, TRemoteIPList &remote_iplist, ui32 &allip, ui32 &allmails, TString &substr, bool &is_pcre, ui32 &dlvlog_rcv, ui32 &dlvlog_skeep, ui32 max_count_today, const TString &geo);
         void   GetDataFA(ui8 sorttype, TViewItemClassList &reslist, ui32 mincount, ui32 mincounttd, bool markbanip, TWhtIp whtip, int onlybanip, TRemoteIPList &remote_iplist, ui32 &allip, ui32 &allmails, TString &substr, bool &is_pcre, ui32 &dlvlog_rcv, ui32 &dlvlog_skeep, ui32 max_count_today, const TString &geo, TNetKIPv6 &addr_list);
         void   ViewMails(TTrapMails &slist, TKIPv6 ip);
         void   Del();

         TString GetModGeo(const TString &geo);
};

//***********************************************************************************
//                              TPeriodIPTrap
//***********************************************************************************

struct TKItemInfo
{
   time_t starttime;
   ui32   period;
   TString ident;
   TString substr;
   bool   is_pcre;
   ui32   dlvlog_rcv;
   ui32   dlvlog_skeep;

   TKItemInfo()
   {
      starttime      = 0;
      period         = 0;
      is_pcre        = false;
      dlvlog_rcv     = 0;
      dlvlog_skeep   = 0;
   }
};

typedef std::list<TPeriodTrapItem*>  TPeriodTrapList;
typedef TPeriodTrapList::iterator    TPeriodTrapListIt;

typedef std::list<TKItemInfo>        TKItemInfoList;
typedef TKItemInfoList::iterator     TKItemInfoListIt;

class TPeriodTrap
{
public:
         static const ui32 LIVETIMEPERIOD = 3 * 3600;
private:
         TPeriodTrapList   data;
         TMutex            m_Mutex;
         ui32              lastcheckerase;
         time_t            m_lastchangetrap;
         TPeriodTrapItem   *cashtrap;
         TString            m_trapfilename;

         void Lock();
         void UnLock();

         TPeriodTrapItem *GetTrapitem(time_t t);
public:
         TPeriodTrap();
         ~TPeriodTrap();

         void   Init(const TString &trapfilenameA);
         int    AddPeriodTrap(ui32 period, ui32 &id, ui8 sorttype, TIDTrapInfo &resdata, ui32 mincount, ui32 mincounttd, bool markbanip, TWhtIp whtip, int onlybanip, TString &substr, bool &is_pcre, ui32 max_count_today, const TString &geo); //<0 - îøèáêà, 0 - äîáàâèëè, >0 - îñòàëîñü ñåêóíä äî îêîí÷àíèÿ ñáîðà äàííûõ
         int    GetTrapList(TKItemInfoList &slist);   //âîçâðàùàåò êîë-âî ëîâóøåê
         void   EraseOld();
         bool   EraseItem(ui32 id);
         int    View(ui32 id, ui8 sorttype, TIDTrapInfo &resdata, ui32 mincount, ui32 mincounttd, bool markbanip, TWhtIp whtip, int onlybanip, TString &substr, bool &is_pcre, ui32 &dlvlog_rcv, ui32 &dlvlog_skeep, ui32 max_count_today, const TString &geo);
         int    ViewFA(ui32 id, ui8 sorttype, TIDTrapInfo &resdata, ui32 mincount, ui32 mincounttd, bool markbanip, TWhtIp whtip, int onlybanip, TString &substr, bool &is_pcre, ui32 &dlvlog_rcv, ui32 &dlvlog_skeep, ui32 max_count_today, const TString &geo, TNetKIPv6 &addr_list);
         void   AddMail(TKIPv6 ip, TSpClass type, time_t t, TString host, TString host2, TString host3, const char *mess, ui32 messsize, bool malic, TMemRecordCopy mrc, bool visfrwd, bool whiteip, const TString &remote_ip, ui32 &remaintime, const TString &geo);
         void   ViewMails(ui32 id, TTrapMails &slist, TKIPv6 ip);

         void   AddBanMail(TKIPv6 ip, TSpClass type, time_t t, const TString &host, const TString &host2, const TString &host3, const char *mess, ui32 messsize, bool malic, const TString &remote_ip, const TString &geo);
         void   AddBanMailBan(TKIPv6 ip, TSpClass type, time_t t, const TString &host, const TString &host2, const TString &host3, const char *mess, ui32 messsize, bool malic, const TString &remote_ip, const TString &geo);
};

//***********************************************************************************
