#include "tperiodstat.h"

TPeriodStat::TPeriodStat()
{
   last_calc_time = time(NULL);
   cps_value.Clear();
}

TPeriodStat::~TPeriodStat()
{

}

void TPeriodStat::Lock()
{
   m_Mutex.Acquire();
}

void TPeriodStat::UnLock()
{
   m_Mutex.Release();
}

TPStatF TPeriodStat::GetLastCalcData()
{
   TPStatF res;

   Lock();

   res = cps_value;

   UnLock();

   return res;
}

void TPeriodStat::AddData(ui32 dslcountA, ui32 dslmailcountA, ui32 banipcountA)
{
   time_t current_time = time(NULL);

   Lock();

   if ((current_time - last_calc_time) >= PERIOD_TIME_SEC)
   {
      cps_value.Clear();
      cps_value.dsl_count      = (float)current_calc.dsl_count      / (float)(current_time - last_calc_time);
      cps_value.dsl_mail_count = (float)current_calc.dsl_mail_count / (float)(current_time - last_calc_time);
      cps_value.banip_count    = (float)current_calc.banip_count    / (float)(current_time - last_calc_time);

      current_calc.Clear();
      last_calc_time = current_time;
   } else
   {
      current_calc.IncDslCount(dslcountA);
      current_calc.IncDslMailCount(dslmailcountA);
      current_calc.IncBanIPCount(banipcountA);
   }

   UnLock();
}
