#pragma once

#include <util/generic/string.h>
#include "util/system/mutex.h"
#include <mail/so/spamstop/tools/so-common/kfunc.h>
#include <time.h>

struct TPStatF
{
   float dsl_count;
   float dsl_mail_count;
   float banip_count;

   TPStatF()
   {
      Clear();
   }

   void Clear()
   {
      dsl_count      = 0;
      dsl_mail_count = 0;
      banip_count    = 0;
   }
};

struct TPStat
{
   ui32 dsl_count;
   ui32 dsl_mail_count;
   ui32 banip_count;

   TPStat()
   {
      Clear();
   }

   void Clear()
   {
      dsl_count      = 0;
      dsl_mail_count = 0;
      banip_count    = 0;
   }

   void IncDslCount(ui32 countA)
   {
      dsl_count = IncMax32(dsl_count, countA);
   }

   void IncDslMailCount(ui32 countA)
   {
      dsl_mail_count = IncMax32(dsl_mail_count, countA);
   }

   void IncBanIPCount(ui32 countA)
   {
      banip_count = IncMax32(banip_count, countA);
   }
};

class TPeriodStat
{
private:
         static const int PERIOD_TIME_SEC = 30;

         time_t            last_calc_time;
         TPStatF           cps_value;
         TPStat            current_calc;
         TMutex            m_Mutex;

         void Lock();
         void UnLock();
public:
         TPeriodStat();
         ~TPeriodStat();

         TPStatF GetLastCalcData();
         void    AddData(ui32 dslcountA, ui32 dslmailcountA, ui32 banipcountA);
};

