#include "treport.h"
#include "tstatiptypes.h"
#include "tforwards.h"
#include "tbasesstore.h"

TReport::TReport()
{
   clear_report();
}

TReport::~TReport()
{

}

void TReport::Init(const TString &MailNumberA, bool writemailnumberA)
{
   mailnumber      = MailNumberA;
   writemailnumber = writemailnumberA;
}

void TReport::SetTimeStart(time_t startA)
{
   char tbuff[128];
   tm   ttime;

   fstart = startA;
   ttime = *localtime(&fstart);
   memset(tbuff, 0, sizeof(tbuff));
   strftime(tbuff, sizeof(tbuff) - 1, "%Y.%m.%d %H:%M:%S", &ttime);
   timestart.assign(tbuff);
}

time_t TReport::GetTimeStart()
{
   return fstart;
}

TString TReport::GetTimeStartStroka()
{
   return timestart;
}

void TReport::SetIp(TKIPv6 xIpA)
{
   xIp = xIpA;
   sIp = xIp.toStroka();
 }

TKIPv6 TReport::GetIp()
{
   return xIp;
}

TString TReport::GetIps()
{
   return sIp;
}

void TReport::SetHost(TString hostA)
{
   host = hostA;
}

void TReport::SetFrwd(ui16 FrwdA)
{
   fFrwd = FrwdA;
}

ui16 TReport::GetFrwd()
{
   return fFrwd;
}

void TReport::Setforward(TString forwardA)
{
   forward = forwardA;
}

TString TReport::Getforward()
{
   return forward;
}

void TReport::Setforward_comments(TString forward_commentsA)
{
   forward_comments = forward_commentsA;
}

TString TReport::Getforward_comments()
{
   return forward_comments;
}

void TReport::SetRulename(TString rulenameA)
{
   rulename = rulenameA;
}

TString TReport::GetRulename()
{
   return rulename;
}

void TReport::SetCriterion(ui16 criterionA)
{
   criterion = criterionA;
}

ui16 TReport::GetCriterion()
{
   return criterion;
}

void TReport::SetHour(ui16 hourA)
{
   hour = hourA;
}

void TReport::SetBanHour(ui16 banhourA)
{
   banhour = banhourA;
}

ui16 TReport::GetHour()
{
   return hour;
}

TString TReport::GetRepeater()
{
   return repeater;
}

void TReport::SetRepeaterType(ui16 d_repeaterA)
{
   char       sbuff[16];

   type_repeater = d_repeaterA;

   memset(sbuff, 0, sizeof(sbuff));
   snprintf(sbuff, sizeof(sbuff) - 1, "(R%03d)", type_repeater);
   repeater = TString(sbuff);
}

ui16 TReport::GetRepeaterType()
{
   return type_repeater;
}

void TReport::SetPROBBANCriterion(ui16 criterionA)
{
   probbancriterion = criterionA;
}

ui16 TReport::GetPROBBANCriterion()
{
   return probbancriterion;
}

void TReport::SetMessClass(TSpClass messclassA)
{
   messclass = messclassA;
}

void TReport::SetDsn(bool DsnA)
{
   Dsn = DsnA;
}

void TReport::SetUwl(ui16 UwlA)
{
   Uwl = UwlA;
}

void TReport::SetDsl_first(bool DslfirstA)
{
   Dslfirst = DslfirstA;
}

void TReport::SetNoresolv_first(bool Noresolv_firstA)
{
   Noresolv_first = Noresolv_firstA;
}

void TReport::SetFixedByRule(bool FixedByRuleA)
{
   FixedByRule = FixedByRuleA;
}

void TReport::SetFixedSource(bool FixedSourceA)
{
   FixedSource = FixedSourceA;
}

void TReport::SetRBL(bool RBLA)
{
   RBL = RBLA;
}

void TReport::SetBounce(bool BounceA)
{
   Bounce = BounceA;
}

TString TReport::GetMailNumber()
{
   TString res = "";

   if (writemailnumber)
      //res = GetNumber(mailnumber);
      res = mailnumber;
   return res;
}

TString TReport::GetMailNumberShort()
{
   TString res = "";

   if (writemailnumber)
      //res = GetNumberShort(mailnumber);
      res = mailnumber;
   return res;
}

void TReport::SetWhiteIp(bool whiteipA)
{
   whiteip = whiteipA;
}

TString TReport::GetStatMail(void *memrecA)
{
   TString         res     = "";
   char           sep     = ' ';
   TString         ssip    = "";
   TMemRecordCopy *memrec = (TMemRecordCopy *)memrecA;

   //if (writemailnumber)
   //   res = res + GetNumber(mailnumber);

   switch (messclass)
   {
    case TSpClass::UNKNOWN:
                        res = res + sep + "Unknw";
                        break;
    case TSpClass::HAM:
                        res = res + sep + "Ham  ";
                        break;
    case TSpClass::DLVR:
                        res = res + sep + "Dlv  ";
                        break;
    case TSpClass::SPAM:
                        res = res + sep + "Spam ";
                        break;
   };

   for (int i = sIp.size(); i < 15; i++)
      ssip = ssip + " ";
   ssip = ssip + sIp;
   res = res + sep + ssip;

   if (memrec != NULL)
   {
      //today
      res = res + sep + "[T: S=" + IntToStroka(memrec->today.ctSpam) + " ";
      res = res + "H=" + IntToStroka(memrec->today.ctHam) + " ";
      res = res + "M=" + IntToStroka(memrec->today.ctMalicSpam) + " ";
      res = res + "POP3=" + IntToStroka(memrec->today.cPop3) + " ";
      res = res + "DSN=" + IntToStroka(memrec->today.cDsn) + " ";
      res = res + "Rej=" + IntToStroka(memrec->today.cRejected) + " ";
      res = res + "MCnt=" + IntToStroka(memrec->today.cMcount) + "; ";

      //history
      res = res + "H: S=" + IntToStroka(memrec->history.ctSpam) + " ";
      res = res + "H=" + IntToStroka(memrec->history.ctHam) + " ";
      res = res + "M=" + IntToStroka(memrec->history.ctMalicSpam) + " ";
      res = res + "Pop3=" + IntToStroka(memrec->history.cPop3_Auth) + " ";
      res = res + "DRej=" + IntToStroka(memrec->history.cDaysRej) + " ";
      res = res + "DNoRej=" + IntToStroka(memrec->history.cDaysNoRej) + " ";
      res = res + "DFwd=" + IntToStroka(memrec->history.cFwdDays) + " ";

      //end
      res = res + "]";
   } else
   {
      res = res + sep + "[Spam=? Ham=? MSpam=?]";
   }

   if (criterion > 0)
      res = res + sep + "CR=" + IntToStroka3(criterion);
   else
      res = res + sep + "CR= - ";

   if (type_repeater > 0)
      res = res + sep + "RPT=" + IntToStroka3(type_repeater);
   else
      res = res + sep + "RPT= - ";

   res = res + sep + "ban=" + IntToStroka2(banhour);

   if (fFrwd > 0)
      res = res + sep + "FWD=" + IntToStroka3(fFrwd);
   else
      res = res + sep + "FWD= - ";
   res = res + "{" + forward_comments + "} ";

   if (Dsn)
      res = res + sep + "Dsn";
   if (Uwl)
      res = res + sep + "Uwl=" + IntToStroka(Uwl);
   if (Dslfirst)
      res = res + sep + "Dsl";
   if (Noresolv_first)
      res = res + sep + "Nrv";
   if (FixedByRule)
      res = res + sep + "FR";
   if (FixedSource)
      res = res + sep + "FS";
   if (RBL)
      res = res + sep + "BL";
   if (Bounce)
      res = res + sep + "Bnc";
   if (whiteip)
      res = res + sep + "WhtIP";

   if (host.size() > 0)
      res = res + sep + "host=" + host;

   return res;
}

void TReport::clear_report()
{
   fstart            = 0;
   timestart         = "";
   xIp               = TKIPv6();
   sIp               = "";
   host              = "";
   fFrwd             = 0;
   forward           = "";
   forward_comments  = "";
   rulename          = "";
   criterion         = 0;
   banhour           = 0;
   hour              = 0;
   repeater.clear();
   type_repeater     = 0;
   probbancriterion  = 0;
   messclass         = TSpClass::UNKNOWN;
   Dsn               = false;
   Uwl               = 0;
   Dslfirst          = false;
   Noresolv_first    = false;
   FixedByRule       = false;
   FixedSource       = false;
   RBL               = false;
   Bounce            = false;
   mailnumber        = "";
   whiteip           = false;
}
