#include "trulestorage.h"

TRuleStorage::TRuleStorage()
{
   m_dumpfilename = "";
   LogsGroup = NULL;
   m_LastMidnight = time(NULL);
   objectname = "rules_stat_storage";
   today_hash = new TRuleStorageHash();
   yesterday_hash = new TRuleStorageHash();
   m_load_at_start = false;
}

TRuleStorage::~TRuleStorage()
{
   WriteDump();
   if (today_hash != NULL)
   {
      delete today_hash;
      today_hash = NULL;
   }
   if (yesterday_hash != NULL)
   {
      delete yesterday_hash;
      yesterday_hash = NULL;
   }
}

void TRuleStorage::Lock()
{
   m_Mutex.Acquire();
}

void TRuleStorage::UnLock()
{
   m_Mutex.Release();
}

void TRuleStorage::Init(bool load_at_startA, TString &dump_filenameA, TLogsGroup *LogsGroupA)
{
   LogsGroup = LogsGroupA;
   m_dumpfilename = dump_filenameA;
   m_load_at_start = load_at_startA;
   if (m_load_at_start)
      ReadDump();
}

void TRuleStorage::Midnight()
{
   TRuleStorageHash  *tmp_hash = NULL;

   Lock();

   tmp_hash = yesterday_hash;
   yesterday_hash = today_hash;
   today_hash = new TRuleStorageHash();

   m_LastMidnight = time(NULL);

   UnLock();

   WriteDump();

   if (tmp_hash != NULL)
   {
      delete tmp_hash;
      tmp_hash = NULL;
   }
}

ui32 TRuleStorage::GetBuffElement(ui64 shingle, TRuleRecord *elm, char *buff, ui32 buffsize)
{
   ui32 res = 0;

   if ((elm != NULL) && (buff != NULL) && ((sizeof(ui64) + sizeof(TRuleRecord)) <= buffsize))
   {
      memcpy(buff, &shingle, sizeof(shingle));
      res += sizeof(shingle);
      memcpy(buff + res, elm, sizeof(TRuleRecord));
      res += sizeof(TRuleRecord);
   }

   return res;
}

TRuleRecord TRuleStorage::AddBuffElement(ui64 &shingle, char *buff, ui32 buffsize, ui32 &elsize)
{
   TRuleRecord     res;
   ui64            shingleA = 0;

   elsize = 0;
   if ((sizeof(shingleA) + sizeof(TRuleRecord)) <= buffsize)
   {
      memcpy(&shingleA, buff, sizeof(shingleA));
      shingle = shingleA;
      memcpy(&res, buff + sizeof(shingleA), sizeof(TRuleRecord));
      elsize = sizeof(shingleA) + sizeof(TRuleRecord);
   }

   return res;
}

bool TRuleStorage::WriteDumpDay(TString filename, TRuleStorageHash *datahash, bool today)
{
   bool                  res             = true;
   char                  *buff           = NULL;
   ui32                  buffsize        = 0;
   ui32                  inbuff          = 0;
   TString                newfilename     = "";
   TString                newfilename_tmp = "";
   FILE                  *handle         = NULL;
   TRuleStorageHashIt    it;
   ui32                  esize           = 0;
   char                  tbuff[128];
   ui32                  bsize           = 0;
   ui32                  crc32           = 0;
   TString                blockident      = "DBCS";
   ui32                  shapsize        = 0;
   unsigned char         uc              = 0;
   ui32                  writecount      = 0;
   TString                today_ident     = "";

   if (today)
      today_ident = "today";
   else
      today_ident = "yesterday";

   if (datahash != NULL)
   {
      newfilename_tmp = filename + "." + "dmp_tmp";
      newfilename = filename + ".dmp";
      handle = fopen(newfilename_tmp.c_str(), "w+b");
      if (handle != NULL)
      {
         buffsize = KREAD_WRITE_DUMP_BUFFSIZE;
         buff = new char[buffsize];
         try
         {
            shapsize = blockident.size() + sizeof(bsize) + sizeof(crc32);
            inbuff = shapsize;
            it = datahash->begin();
            while (it != datahash->end())
            {
               esize = GetBuffElement((*it).first, &((*it).second), tbuff, sizeof(tbuff));
               if (esize > 0)
               {
                  writecount++;
                  if ((esize + inbuff) >= buffsize)
                  {
                     crc32 = 0;
                     for (int i = shapsize; i < inbuff; i++)
                     {
                        memcpy(&uc, buff + i, sizeof(uc));
                        crc32 += uc;
                     }
                     memcpy(buff, blockident.c_str(), blockident.size());
                     memcpy(buff + blockident.size(), &inbuff, sizeof(inbuff));
                     memcpy(buff + blockident.size() + sizeof(inbuff), &crc32, sizeof(crc32));
                     fwrite(buff, 1, inbuff, handle);
                     inbuff = shapsize;
                  }
                  memcpy(buff + inbuff, tbuff, esize);
                  inbuff += esize;
               }

               ++it;
            }
            if (inbuff > 0)
            {
               crc32 = 0;
               for (int i = shapsize; i < inbuff; i++)
               {
                  memcpy(&uc, buff + i, sizeof(uc));
                  crc32 += uc;
               }
               memcpy(buff, blockident.c_str(), blockident.size());
               memcpy(buff + blockident.size(), &inbuff, sizeof(inbuff));
               memcpy(buff + blockident.size() + sizeof(inbuff), &crc32, sizeof(crc32));
               fwrite(buff, 1, inbuff, handle);
            }

            delete[] buff;
            buff = NULL;
         } catch(...)
         {
            delete[] buff;
            buff = NULL;
         }
         fclose(handle);
      } else
      {
         res = false;
      }

      if (res)
      {
         remove(newfilename.c_str());
         if ( rename(newfilename_tmp.c_str(), newfilename.c_str()) )
            res = false;
      }

      if ((LogsGroup != NULL) && (LogsGroup->ActionLog() != NULL))
      {
         if (res)
            LogsGroup->ActionLog()->WriteMessageAndDataStatus(KMESSAGE, "    RULESTORAGE:   Write dump (%s_%s) successfully, count = %u", objectname.c_str(), today_ident.c_str(), writecount);
         else
            LogsGroup->ActionLog()->WriteMessageAndDataStatus(KERROR, "    RULESTORAGE:   Write dump (%s_%s) failed, file: %s", objectname.c_str(), today_ident.c_str(), newfilename.c_str());
      }
   }

   return res;
}

bool TRuleStorage::ReadDumpDay(TString filename, TRuleStorageHash *datahash, bool today)
{
   bool           res         = true;
   TString         blockident  = "DBCS";
   FILE           *handle     = NULL;
   TString         newfilename = "";
   char           *buff       = NULL;
   ui32           buffsize    = 0;
   ui32           inbuff      = 0;
   char           *bufftemp   = NULL;
   ui32           inbufftemp  = 0;
   ui32           readbyte    = 0;
   ui32           needread    = 0;
   ui32           blocksize   = 0;
   ui32           crc32       = 0;
   ui32           tcrc32      = 0;
   unsigned char  uc          = 0;
   ui32           shapsize    = 0;
   ui32           readcount   = 0;
   TString         today_ident = "";

   if (today)
      today_ident = "today";
   else
      today_ident = "yesterday";

   if (datahash != NULL)
   {
      newfilename = filename + ".dmp";
      handle = fopen(newfilename.c_str(), "rb");
      if (handle != NULL)
      {
         buffsize = KREAD_WRITE_DUMP_BUFFSIZE;
         buff = new char[buffsize];
         bufftemp = new char[buffsize];
         try
         {
            inbuff = 0;
            int n = 0;
            while (true)
            {
               n++;

               needread = buffsize - inbuff;
               readbyte = fread(buff + inbuff, 1, needread, handle);
               if ((readbyte > 0) || (needread == 0))
               {
                  inbuff += readbyte;
                  if (memcmp(buff, blockident.c_str(), blockident.size()) == 0)
                  {
                     memcpy(&blocksize, buff + blockident.size(), sizeof(blocksize));
                     if (inbuff >= blocksize)
                     {
                        memcpy(&crc32, buff + blockident.size() + sizeof(blocksize), sizeof(crc32));
                        shapsize = blockident.size() + sizeof(blocksize) + sizeof(crc32);
                        tcrc32 = 0;
                        for (int i = shapsize; i < blocksize; i++)
                        {
                           memcpy(&uc, buff + i, sizeof(uc));
                           tcrc32 += uc;
                        }
                        if (crc32 == tcrc32)
                        {
                           ui64            shingle = 0;
                           TRuleRecord     mr;
                           ui32            posiz   = 0;
                           ui32            tsize   = 0;
                           ui32            elsize  = 0;

                           posiz = 0;
                           while (true)
                           {
                              tsize = blocksize - shapsize - posiz;
                              if (tsize < 10)
                                 tsize = tsize;
                              if (tsize == 0)
                                 break;
                              mr = AddBuffElement(shingle, buff + shapsize + posiz, tsize, elsize);
                              if (elsize > 0)
                              {
                                 (*datahash)[shingle] = mr;
                                 posiz += elsize;
                                 readcount++;
                              } else
                              {
                                 break;
                              }
                           }
                        } else
                        {
                           if ((LogsGroup != NULL) && (LogsGroup->ActionLog() != NULL))
                              LogsGroup->ActionLog()->WriteMessageAndDataStatus(KERROR, "    RULESTORAGE:      READDUMP (%s_%s): Bad crc32, file: %s", objectname.c_str(), today_ident.c_str(), newfilename.c_str());
                           res = false;
                           break;
                        }
                     } else
                     {
                        if ((LogsGroup != NULL) && (LogsGroup->ActionLog() != NULL))
                           LogsGroup->ActionLog()->WriteMessageAndDataStatus(KERROR, "    RULESTORAGE:      READDUMP (%s_%s): Bad identificator, file: %s", objectname.c_str(), today_ident.c_str(), newfilename.c_str());
                        res = false;
                        break;
                     }

                     if ((inbuff - blocksize) > 0)
                     {
                        memcpy(bufftemp, buff + blocksize, inbuff - blocksize);
                        memcpy(buff, bufftemp, inbuff - blocksize);
                        inbuff = inbuff - blocksize;
                     }

                  } else
                  {
                     if ((LogsGroup != NULL) && (LogsGroup->ActionLog() != NULL))
                        LogsGroup->ActionLog()->WriteMessageAndDataStatus(KERROR, "    RULESTORAGE:      READDUMP (%s_%s): Bad identificator, file: %s", objectname.c_str(), today_ident.c_str(), newfilename.c_str());
                     res = false;
                     break;
                  }

               } else
               {
                  if (feof(handle))
                  {
                     break;
                  } else
                  {
                     if ((LogsGroup != NULL) && (LogsGroup->ActionLog() != NULL))
                        LogsGroup->ActionLog()->WriteMessageAndDataStatus(KERROR, "    RULESTORAGE:      READDUMP (%s_%s): Error read file: %s", objectname.c_str(), today_ident.c_str(), newfilename.c_str());
                     res = false;
                     break;
                  }
               }
            }


            delete[] buff;
            buff = NULL;
            delete[] bufftemp;
            bufftemp = NULL;
         } catch(...)
         {
            delete[] buff;
            buff = NULL;
            delete[] bufftemp;
            bufftemp = NULL;
         }
         fclose(handle);
      }

      if ((res) && (LogsGroup != NULL) && (LogsGroup->ActionLog() != NULL))
         LogsGroup->ActionLog()->WriteMessageAndDataStatus(KMESSAGE, "    RULESTORAGE:      READDUMP (%s_%s): Read count = %u", objectname.c_str(), today_ident.c_str(), readcount);
   } else
      res = false;

   return res;
}

double TRuleStorage::GetAgeCoeff(time_t lastmidnight)
{
    return ((double)1 - ( ((double)time(NULL) - lastmidnight) / (double)86400) );
}

TTripleUi32 TRuleStorage::GetRuleAMount(TString &rule, TKMessType messtype)
{
   TTripleUi32          res;
   ui32                 res_today_ham        = 0;
   ui32                 res_today_spam       = 0;
   ui32                 res_today_malic      = 0;
   ui32                 res_yesterday_ham    = 0;
   ui32                 res_yesterday_spam   = 0;
   ui32                 res_yesterday_malic  = 0;
   ui64                 shingle              = 0;
   TRuleStorageHashIt   it;
   float                koef                 = 0;

   shingle = ShingleFromStroka(rule);
   if ( (shingle != 0) && ( (today_hash != NULL) || (yesterday_hash != NULL) ) )
   {
      Lock();

      if (today_hash != NULL)
      {
         it = today_hash->find(shingle);
         if (it != today_hash->end())
         {
            if ((*it).second.CompareRulename(rule))
            {
               res_today_ham = (*it).second.m_count_ham;
               res_today_spam = (*it).second.m_count_spam;
               res_today_malic = (*it).second.m_count_malic;
               switch (messtype)
               {
               case kHam:
                           res_today_ham = (*it).second.IncHam();
                           break;
               case kSpam:
                           res_today_spam = (*it).second.IncSpam();
                           break;
               case kMalic:
                           res_today_malic = (*it).second.IncMalic();
                           break;
               };
            }
         } else
         {
            res_today_ham   = 0;
            res_today_spam  = 0;
            res_today_malic = 0;
            switch (messtype)
            {
             case kHam:
                           (*today_hash)[shingle] = TRuleRecord(rule, 0, 1, 0);
                           res_today_ham = 1;
                           break;
             case kSpam:
                           (*today_hash)[shingle] = TRuleRecord(rule, 1, 0, 0);
                           res_today_spam = 1;
                           break;
             case kMalic:
                           (*today_hash)[shingle] = TRuleRecord(rule, 0, 0, 1);
                           res_today_malic = 1;
                           break;
            };
         }
      }

      if (yesterday_hash != NULL)
      {
         it = yesterday_hash->find(shingle);
         if (it != yesterday_hash->end())
         {
            if ((*it).second.CompareRulename(rule))
            {
               res_yesterday_ham   = (*it).second.GetCountHam();
               res_yesterday_spam  = (*it).second.GetCountSpam();
               res_yesterday_malic = (*it).second.GetCountMalic();
            }
         }
      }

      UnLock();

      koef = GetAgeCoeff(m_LastMidnight);
      res.ham   = (ui32)((float)res_today_ham + (float)koef * (float)res_yesterday_ham);
      res.spam  = (ui32)((float)res_today_spam + (float)koef * (float)res_yesterday_spam);
      res.malic = (ui32)((float)res_today_malic + (float)koef * (float)res_yesterday_malic);
   }

   return res;
}

bool TRuleStorage::WriteDump()
{
   bool res       = true;
   ui32 proc_time = 0;

   if ((LogsGroup != NULL) && (LogsGroup->ActionLog() != NULL))
      LogsGroup->ActionLog()->WriteMessageAndDataStatus(KMESSAGE, "    RULESTORAGE:   write dump...");

   proc_time = CShingleTime::GetMs();

   if (!m_dumpfilename.empty())
   {
      TString today_filename      = m_dumpfilename + "_today";
      TString yesterday_filename  = m_dumpfilename + "_yesterday";

      Lock();

      if (WriteDumpDay(today_filename, today_hash, true))
      {
         if (!WriteDumpDay(yesterday_filename, yesterday_hash, false))
            res = false;
      } else
      {
         res = false;
      }

      UnLock();

   } else
      res = false;

   proc_time = CShingleTime::GetMs() - proc_time;

   if ((LogsGroup != NULL) && (LogsGroup->ActionLog() != NULL))
      LogsGroup->ActionLog()->WriteMessageAndDataStatus(KMESSAGE, "    RULESTORAGE:   write dump to %u msec", proc_time);

   return res;
}

bool TRuleStorage::ReadDump()
{
   bool res = true;
   ui32 proc_time = 0;

   if ((LogsGroup != NULL) && (LogsGroup->ActionLog() != NULL))
      LogsGroup->ActionLog()->WriteMessageAndDataStatus(KMESSAGE, "    RULESTORAGE:   read dump...");

   proc_time = CShingleTime::GetMs();

   if (!m_dumpfilename.empty())
   {
      TString today_filename      = m_dumpfilename + "_today";
      TString yesterday_filename  = m_dumpfilename + "_yesterday";

      Lock();

      if (ReadDumpDay(today_filename, today_hash, true))
      {
         if (!ReadDumpDay(yesterday_filename, yesterday_hash, false))
            res = false;
      } else
      {
         res = false;
      }

      UnLock();

   } else
      res = false;

   proc_time = CShingleTime::GetMs() - proc_time;

   if ((LogsGroup != NULL) && (LogsGroup->ActionLog() != NULL))
      LogsGroup->ActionLog()->WriteMessageAndDataStatus(KMESSAGE, "    RULESTORAGE:   read dump to %u msec", proc_time);

   return res;
}

TString TRuleStorage::GetRulesStat(TWorkRuleListExt &rulelist, TKMessType messtype)
{
   TString             res = "";
   TTripleUi32        dat;

   auto it = rulelist.begin();
   while (it != rulelist.end())
   {
      dat = GetRuleAMount((*it).rulename, messtype);
      (*it).count_ham   = dat.ham;
      (*it).count_spam  = dat.spam;
      (*it).count_malic = dat.malic;
      res = res + (*it).rulename + " " + IntToStroka((*it).count_ham) + " " + IntToStroka((*it).count_spam) + " " + IntToStroka((*it).count_malic) + ", ";

      ++it;
   }

   return res;
}

ui32 TRuleStorage::GetCountToday()
{
   ui32 res = 0;

   Lock();

   if (today_hash != NULL)
      res = today_hash->size();

   UnLock();

   return res;
}

ui32 TRuleStorage::GetCountYesterday()
{
   ui32 res = 0;

   Lock();

   if (yesterday_hash != NULL)
      res = yesterday_hash->size();

   UnLock();

   return res;
}
