#pragma once

#include "util/generic/hash.h"
#include "util/system/mutex.h"
#include <mail/so/spamstop/tools/so-common/kfunc.h>
#include "tlogsgroup.h"
#include "tstatiptypes.h"

typedef enum {
        kUnknown = 0, kHam = 1, kSpam = 2, kMalic = 4
} TKMessType;

struct TTripleUi32
{
   ui32 ham;
   ui32 spam;
   ui32 malic;

   TTripleUi32()
   {
      ham   = 0;
      spam  = 0;
      malic = 0;
   }
};

struct TRuleRecord
{
   char     m_rulename[64];
   ui32     m_count_spam;
   ui32     m_count_ham;
   ui32     m_count_malic;

   TRuleRecord()
   {
      Clear();
   }

   TRuleRecord(TString &rulename)
   {
      SetRulename(rulename);
      m_count_spam  = 0;
      m_count_ham   = 0;
      m_count_malic = 0;
   }

   TRuleRecord(TString &rulename, ui32 count_spam, ui32 count_ham, ui32 count_malic)
   {
      SetRulename(rulename);
      m_count_spam = count_spam;
      m_count_ham = count_ham;
      m_count_malic = count_malic;
   }

   void Clear()
   {
      memset(m_rulename, 0, sizeof(m_rulename));
      m_count_spam  = 0;
      m_count_ham   = 0;
      m_count_malic = 0;
   }

   void SetRulename(TString &rulename)
   {
      memset(m_rulename, 0, sizeof(m_rulename));
      if (!rulename.empty())
      {
         int count = 0;

         count = (rulename.length() > (sizeof(m_rulename) - 1) ) ? (sizeof(m_rulename) - 1) : rulename.length();
         if (count > 0)
            memcpy(m_rulename, rulename.c_str(), count);
      }
   }

   bool CompareRulename(TString &rulename) //���������� rulename � ������ � ���������, ���� ��������� - true, ����� false
   {
      bool   res         = false;
      TString rulenametmp = "";

      rulenametmp = TString(m_rulename);
      if (rulenametmp == rulename)
         res = true;

      return res;
   }

   ui32 IncSpam()
   {
      m_count_spam = ((m_count_spam + 1) > 0xFFFFFFFF) ? 0xFFFFFFFF : (m_count_spam + 1);

      return m_count_spam;
   }

   ui32 IncHam()
   {
      m_count_ham = ((m_count_ham + 1) > 0xFFFFFFFF) ? 0xFFFFFFFF : (m_count_ham + 1);

      return m_count_ham;
   }

   ui32 IncMalic()
   {
      m_count_malic = ((m_count_malic + 1) > 0xFFFFFFFF) ? 0xFFFFFFFF : (m_count_malic + 1);

      return m_count_malic;
   }

   ui32 GetCountSpam()
   {
      return m_count_spam;
   }

   ui32 GetCountHam()
   {
      return m_count_ham;
   }

   ui32 GetCountMalic()
   {
      return m_count_malic;
   }
};

typedef THashMap<ui64, TRuleRecord>    TRuleStorageHash;
typedef TRuleStorageHash::iterator  TRuleStorageHashIt;

class TRuleStorage
{
private:
         static const ui32 KREAD_WRITE_DUMP_BUFFSIZE = 64001;

         TRuleStorageHash     *today_hash;
         TRuleStorageHash     *yesterday_hash;
         TMutex               m_Mutex;
         TString               m_dumpfilename;
         TLogsGroup           *LogsGroup;
         TString               objectname;
         time_t               m_LastMidnight;
         bool                 m_load_at_start;

         void                 Lock();
         void                 UnLock();

         ui32                 GetBuffElement(ui64 shingle, TRuleRecord *elm, char *buff, ui32 buffsize);
         TRuleRecord          AddBuffElement(ui64 &shingle, char *buff, ui32 buffsize, ui32 &elsize);
         bool                 WriteDumpDay(TString filename, TRuleStorageHash *datahash, bool today);
         bool                 ReadDumpDay(TString filename, TRuleStorageHash *datahash, bool today);
         double               GetAgeCoeff(time_t lastmidnight);

         TTripleUi32          GetRuleAMount(TString &rule, TKMessType messtype);
public:
         TRuleStorage();
         ~TRuleStorage();

         void   Init(bool load_at_startA, TString &dump_filenameA, TLogsGroup *LogsGroupA);
         void   Midnight();
         bool   WriteDump();
         bool   ReadDump();
         ui32   GetCountToday();
         ui32   GetCountYesterday();

         TString GetRulesStat(TWorkRuleListExt &rulelist, TKMessType messtype);
};
