#include "truletrap.h"

//**************************************************************************************
//                               TRuleTrapItem
//**************************************************************************************

TRuleTrapItem::TRuleTrapItem()
{
   createtime = time(NULL);
   rulename = "";
   livetime = 0;
}

TRuleTrapItem::TRuleTrapItem(TString rulenameA, ui32 livetimeA)
{
   createtime = time(NULL);
   rulename = rulenameA;
   livetime = livetimeA;

}

TRuleTrapItem::~TRuleTrapItem()
{
   ipdata.clear();

}

bool TRuleTrapItem::GetTrap(ui32 ip)
{
   bool      res = true;
   TIPHashIt it;

   it = ipdata.find(ip);
   if (it != ipdata.end())
   {
      if ((*it).second)
         res = false;
   }

   return res;
}

void TRuleTrapItem::SetPriznak(ui32 ip)
{
   TIPHashIt it;

   it = ipdata.find(ip);
   if (it != ipdata.end())
      (*it).second = true;
   else
      ipdata[ip] = true;
}

bool TRuleTrapItem::LeaveTime(time_t t)
{
   bool res = false;

   if ((t - createtime) > livetime)
      res = true;

   return res;
}

ui32 TRuleTrapItem::Ipcount()
{
   ui32 res = 0;

   res = ipdata.size();

   return res;
}

ui32 TRuleTrapItem::TimeEstimated(time_t t)
{
   ui32 tt = 0;
   ui32 res = 0;

   tt = t - createtime;
   if (livetime > tt)
      res = livetime - tt;
   else
      res = 0;

   return res;
}

//**************************************************************************************
//                                TRuleTrap
//**************************************************************************************

TRuleTrap::TRuleTrap()
{


}

TRuleTrap::~TRuleTrap()
{
   TRuleHashIt it;

   it = rulehash.begin();
   while (it != rulehash.end())
   {
      if ((*it).second != NULL)
      {
         delete (*it).second;
         (*it).second = NULL;
      }
      ++it;
   }
   rulehash.clear();
}

void TRuleTrap::Lock()
{
   m_Mutex.Acquire();
}

void TRuleTrap::UnLock()
{
   m_Mutex.Release();
}

void TRuleTrap::Init(TString resdirA)
{
   resdir = resdirA;
   if (resdir.length() > 0)
   {
#ifdef _win_
      if (resdir[resdir.size()] != '\\')
         resdir = resdir + "\\";
#else
      if (resdir[resdir.size()] != '/')
         resdir = resdir + "/";
#endif

   }
}

void TRuleTrap::AddRule(TString rulename, ui32 livetime)
{
   Lock();

   TRuleHashIt it;

   it = rulehash.find(rulename);
   if (it == rulehash.end())
   {
      rulehash[rulename] = new TRuleTrapItem(rulename, livetime);
   }

   UnLock();
}

void TRuleTrap::DeleteRule(TString rulename)
{
   Lock();

   TRuleHashIt it;

   it = rulehash.find(rulename);
   if (it != rulehash.end())
   {
      if ((*it).second != NULL)
      {
         delete (*it).second;
         (*it).second = NULL;
      }
      rulehash.erase(it);
   }

   UnLock();
}

bool TRuleTrap::IsFirst(TString rulename)
{
   bool        res = true;
   TRuleHashIt it;

   Lock();

   it = rulehash.find(rulename);
   if (it != rulehash.end())
   {
      if ((*it).second != NULL)
      {
         if ((*it).second->Ipcount() > 0)
            res = false;
      }
   }

   UnLock();

   return res;
}

TListRule *TRuleTrap::GetCheckRule(ui32 ip)
{
   TListRule   *res = NULL;
   TRuleHashIt it;

   Lock();

   it = rulehash.begin();
   while (it != rulehash.end())
   {
      if ((*it).second != NULL)
      {
         if ((*it).second->GetTrap(ip))
         {
            if (res == NULL)
               res = new TListRule();
            if (res != NULL)
               res->push_back((*it).first);
         }
      }
      ++it;
   }

   UnLock();

   return res;
}

void TRuleTrap::SetPriznak(ui32 ip, TListRule *listrule)
{
   if (listrule != NULL)
   {
      if (listrule->size() > 0)
      {
         TListRuleIt lit;
         TRuleHashIt it;

         Lock();

         lit = listrule->begin();
         while (lit != listrule->end())
         {
            if (!(*lit).empty())
            {
               it = rulehash.find((*lit));
               if (it != rulehash.end())
               {
                  if ((*it).second != NULL)
                     (*it).second->SetPriznak(ip);
               }
            }
            ++lit;
         }

         UnLock();
      }

      delete listrule;
      listrule = NULL;
   }
}

void TRuleTrap::CheckLiveTrap(ui32 t)
{
   Lock();

   TRuleHashIt  it;
   TRuleHashIt  rmit = rulehash.end();

   it = rulehash.begin();
   while (it != rulehash.end())
   {
      if (rmit != rulehash.end())
      {
         delete (*rmit).second;
         (*rmit).second = NULL;
         rulehash.erase(rmit);

         rmit = rulehash.end();
      }
      if ( ((*it).second != NULL) && ((*it).second->LeaveTime(t)) )
         rmit = it;

      ++it;
   }
   if (rmit != rulehash.end())
   {
      delete (*rmit).second;
      (*rmit).second = NULL;
      rulehash.erase(rmit);

      rmit = rulehash.end();
   }

   UnLock();
}

TString TRuleTrap::GetDir()
{
   return resdir;
}

void TRuleTrap::GetRuleStat(TListRuleStat &listrulestat)
{
   TRuleHashIt it;
   TRuleStat   rs;
   time_t      t = 0;

   Lock();

   t = time(NULL);
   listrulestat.clear();

   it = rulehash.begin();
   while (it != rulehash.end())
   {
      if ((*it).second != NULL)
      {
         rs.rulename = (*it).first;
         rs.count = (*it).second->Ipcount();
         rs.estimated = (*it).second->TimeEstimated(t);
         listrulestat.push_back(rs);
      }
      ++it;
   }

   UnLock();
}

//**************************************************************************************
