#pragma once

#include "util/system/mutex.h"
#include <mail/so/spamstop/tools/so-common/kfunc.h>
#include <time.h>
#include <list>

//**************************************************************************************
//                               TRuleTrapItem
//**************************************************************************************

typedef THashMap<ui32, bool> TIPHash;
typedef TIPHash::iterator TIPHashIt;

class TRuleTrapItem
{
private:
         TString  rulename;
         TIPHash ipdata;
         time_t  createtime;
         ui32    livetime;
public:
         TRuleTrapItem();
         TRuleTrapItem(TString rulenameA, ui32 livetimeA);
         ~TRuleTrapItem();

         bool GetTrap(ui32 ip);    //true - ��������� �������, false - �� �������
         void SetPriznak(ui32 ip); //������ �������, ��� ������� �� ������� ip ��� ���������
         bool LeaveTime(time_t t); //true - ����� "�����" �����
         ui32 Ipcount();
         ui32 TimeEstimated(time_t t); //�������� ��� ������������� �������
};

//**************************************************************************************
//                                TRuleTrap
//**************************************************************************************

struct TRuleStat
{
   TString rulename; //��� �������
   ui32   count;    //���-�� ip (�� �������� ip ���������)
   ui32   estimated;//�������� ���
};

typedef THashMap<TString, TRuleTrapItem*> TRuleHash;
typedef TRuleHash::iterator           TRuleHashIt;

typedef std::list<TString>             TListRule;
typedef TListRule::iterator           TListRuleIt;

typedef std::list<TRuleStat>          TListRuleStat;
typedef TListRuleStat::iterator       TListRuleStatIt;

class TRuleTrap
{
private:
         TRuleHash            rulehash;
         TMutex               m_Mutex;
         TString               resdir;

         void Lock();
         void UnLock();
public:
         TRuleTrap();
         ~TRuleTrap();

         void        Init(TString resdirA);
         void        AddRule(TString rulename, ui32 livetime);
         void        DeleteRule(TString rulename);
         bool        IsFirst(TString rulename);
         TListRule   *GetCheckRule(ui32 ip); //� ���� ������ ������ ����������� ������, ����� ��������, ���� ������� ������� - ��� ����������� � ������, ���� �� ������� - ���������. ���� ������ ������, ������������ ���, ���� ��� - ���������� � ������� SetPriznak
         void        SetPriznak(ui32 ip, TListRule *listrule);
         void        CheckLiveTrap(ui32 t);
         TString      GetDir();

         void        GetRuleStat(TListRuleStat &listrulestat);
};

//**************************************************************************************
