#pragma once

#include "util/generic/string.h"
#include <mail/so/spamstop/tools/so-common/kfunc.h>

//*******************************************************************************************************************************
//                                                    TStatTopOther
//*******************************************************************************************************************************

#define SF_BAN_MC                0x00000002 // ban today
#define SF_BAN_WOW_MC            0x00000004 // ban today manual
#define IS_SF_BAN_MC(flag)       ((flag) & SF_BAN_MC)
#define IS_SF_BAN_WOW_MC(flag)   ((flag) & SF_BAN_WOW_MC)

struct TStatTopOther
{
 ui64 m_badtime;
 ui64 m_ip_undefined;
 ui64 m_ipv4_count_all;
 ui64 m_ipv4_count_today;
 ui64 m_ipv4_count_autoban;         //from today
 ui64 m_ipv4_count_manban;          //from today
 ui64 m_ipv4_count_with_reject_day; //from history
 ui64 m_ipv4_count_with_manualban;  //from history
 ui64 m_ipv6_count_all;
 ui64 m_ipv6_count_today;
 ui64 m_ipv6_count_autoban;
 ui64 m_ipv6_count_manban;
 ui64 m_ipv6_count_with_reject_day;
 ui64 m_ipv6_count_with_manualban;

 TStatTopOther()
 {
  Clear();
 }

 void Clear()
 {
  m_badtime = 0;
  m_ip_undefined = 0;
  m_ipv4_count_all = 0;
  m_ipv4_count_today = 0;
  m_ipv4_count_autoban = 0;
  m_ipv4_count_manban = 0;
  m_ipv4_count_with_reject_day = 0;
  m_ipv4_count_with_manualban = 0;
  m_ipv6_count_all = 0;
  m_ipv6_count_today = 0;
  m_ipv6_count_autoban = 0;
  m_ipv6_count_manban = 0;
  m_ipv6_count_with_reject_day = 0;
  m_ipv6_count_with_manualban = 0;

 }

 TString toLog()
 {
  TString res = "";

  res += "Bad time count:                       " + UI64ToStroka(m_badtime) + "\n";
  res += "IP undefined count:                   " + UI64ToStroka(m_ip_undefined) + "\n";
  res += "IPv4 count (all):                     " + UI64ToStroka(m_ipv4_count_all) + "\n";
  res += "IPv4 count (today):                   " + UI64ToStroka(m_ipv4_count_today) + "\n";
  res += "IPv4 count ruleban (today):           " + UI64ToStroka(m_ipv4_count_autoban) + "\n";
  res += "IPv4 count manual ban (today):        " + UI64ToStroka(m_ipv4_count_manban) + "\n";
  res += "IPv4 count with reject day (history): " + UI64ToStroka(m_ipv4_count_with_reject_day) + "\n";
  res += "IPv4 count with manualban  (history): " + UI64ToStroka(m_ipv4_count_with_manualban) + "\n";
  res += "IPv6 count (all):                     " + UI64ToStroka(m_ipv6_count_all) + "\n";
  res += "IPv6 count (today):                   " + UI64ToStroka(m_ipv6_count_today) + "\n";
  res += "IPv6 count ruleban (today):           " + UI64ToStroka(m_ipv6_count_autoban) + "\n";
  res += "IPv6 count manual ban (today):        " + UI64ToStroka(m_ipv6_count_manban) + "\n";
  res += "IPv6 count with reject day (history): " + UI64ToStroka(m_ipv6_count_with_reject_day) + "\n";
  res += "IPv6 count with manualban  (history): " + UI64ToStroka(m_ipv6_count_with_manualban) + "\n";

  return res;
 }
};

//*******************************************************************************************************************************
//                                                    TFindToFileReport
//*******************************************************************************************************************************

struct TFindToFileReport
{
 ui64 fulldump_record_count;
 bool use_need;
 ui64 need_record_count;
 bool use_top;
 ui64 top_record_count;
 i64  top_treshold;
 ui64 count_by_type[8];
 ui64 empty_data;

 TFindToFileReport()
 {
  Clear();
 }

 void Clear()
 {
  fulldump_record_count = 0;
  use_need = false;
  need_record_count = 0;
  use_top = false;
  top_record_count = 0;
  top_treshold = 0;
  memset(count_by_type, 0, sizeof(count_by_type));
  empty_data = 0;
 }

 TString GetCountersByType()
 {
  char tbuff[512];

  memset(tbuff, 0, sizeof(tbuff));
  snprintf(tbuff, sizeof(tbuff) - 1, "%llu-%llu-%llu-%llu,%llu-%llu-%llu-%llu", count_by_type[nosql::AnyValue::INTEGER], count_by_type[nosql::AnyValue::INTEGER64], count_by_type[nosql::AnyValue::DOUBLE], count_by_type[nosql::AnyValue::STRING], count_by_type[nosql::AnyValue::NOTYPE], count_by_type[nosql::AnyValue::VECTOR], count_by_type[nosql::AnyValue::LIST], count_by_type[nosql::AnyValue::HASH]);

  return TString(tbuff);
 }

 TFindToFileReport operator-(const TFindToFileReport &value)
 {
  TFindToFileReport res;

  for (int i = 0; i < 8; i++)
   res.count_by_type[i] = count_by_type[i] - value.count_by_type[i];

  return res;
 }
};

//*******************************************************************************************************************************
//                                                    TFindToFileReportMC
//*******************************************************************************************************************************

struct TFindToFileReportMC
{
 ui64           fulldump_record_count;
 bool           use_need;
 ui64           need_record_count;
 bool           use_top;
 ui64           top_record_count;
 i64            top_treshold;
 ui64           count_by_type[8];
 ui64           empty_data;
 TStatTopOther  top_other;

 TFindToFileReportMC()
 {
  Clear();
 }

 void Clear()
 {
  fulldump_record_count = 0;
  use_need = false;
  need_record_count = 0;
  use_top = false;
  top_record_count = 0;
  top_treshold = 0;
  memset(count_by_type, 0, sizeof(count_by_type));
  empty_data = 0;
  top_other.Clear();
 }

 TString GetCountersByType()
 {
  char tbuff[512];

  memset(tbuff, 0, sizeof(tbuff));
  snprintf(tbuff, sizeof(tbuff) - 1, "%llu-%llu-%llu-%llu,%llu-%llu-%llu-%llu", count_by_type[nosql::AnyValue::INTEGER], count_by_type[nosql::AnyValue::INTEGER64], count_by_type[nosql::AnyValue::DOUBLE], count_by_type[nosql::AnyValue::STRING], count_by_type[nosql::AnyValue::NOTYPE], count_by_type[nosql::AnyValue::VECTOR], count_by_type[nosql::AnyValue::LIST], count_by_type[nosql::AnyValue::HASH]);

  return TString(tbuff);
 }

 TFindToFileReportMC operator-(const TFindToFileReportMC &value)
 {
  TFindToFileReportMC res;

  for (int i = 0; i < 8; i++)
   res.count_by_type[i] = count_by_type[i] - value.count_by_type[i];

  return res;
 }
};


