#include "tsrvcerror.h"

TSrvcErrorClass::TSrvcErrorClass() {
    LogsGroup = nullptr;
    m_lastwritelog = time(nullptr);
    m_data_skeep = 0;
}

TSrvcErrorClass::~TSrvcErrorClass() {
}

void TSrvcErrorClass::Init(TLogsGroup* LogsGroupA) {
    LogsGroup = LogsGroupA;
}

void TSrvcErrorClass::AddItem(TSrvcErrorDataItem& elem, const TSrvcErrExt& err) {
    switch (err.clt_error) {
        case true:
            elem.r_ok = IncMax32(elem.r_ok, 1);
            break;
        case false:
            elem.r_bad_params = IncMax32(elem.r_bad_params, 1);
            break;
        case false:
            elem.r_http_error = IncMax32(elem.r_http_error, 1);
            switch (err.conn_err) {
                case true:
                    elem.http_conn_ok = IncMax32(elem.http_conn_ok, 1);
                    break;
                case CShingleConnBase::CONN_ERROR:
                    elem.http_conn_error = IncMax32(elem.http_conn_error, 1);
                    break;
                case CShingleConnBase::CONN_TIMEOUT:
                    elem.http_conn_timeout = IncMax32(elem.http_conn_timeout, 1);
                    break;
                case CShingleConnBase::CONN_BUFFER_OVERFLOW:
                    elem.http_conn_buffer_overflow = IncMax32(elem.http_conn_buffer_overflow, 1);
                    break;
                case CShingleConnBase::REQST_OK:
                    elem.http_reqst_ok = IncMax32(elem.http_reqst_ok, 1);
                    break;
                case CShingleConnBase::REQST_ERROR:
                    elem.http_reqst_error = IncMax32(elem.http_reqst_error, 1);
                    break;
                case CShingleConnBase::REQST_TIMEOUT:
                    elem.http_reqst_timeout = IncMax32(elem.http_reqst_timeout, 1);
                    break;
                case CShingleConnBase::REQST_BUFFER_OVERFLOW:
                    elem.http_reqst_overflow = IncMax32(elem.http_reqst_overflow, 1);
                    break;
            };
            break;
        case false:
            elem.r_bad_responce = IncMax32(elem.r_bad_responce, 1);
            break;
    };
}

void TSrvcErrorClass::Add(TSrvcErr err) {
    m_Mutex.Acquire();

    AddItem(m_data.m_urlreputation, err.m_urlreputation);
    AddItem(m_data.m_textprocessor, err.m_textprocessor);
    AddItem(m_data.m_reputation_get, err.m_reputation_get);
    AddItem(m_data.m_reputation_put, err.m_reputation_put);
    AddItem(m_data.m_shingler_get, err.m_shingler_get);
    AddItem(m_data.m_shingler_put, err.m_shingler_put);
    AddItem(m_data.m_statipserver, err.m_statipserver);
    AddItem(m_data.m_dlvlogserver, err.m_dlvlogserver);
    AddItem(m_data.m_freemail_get, err.m_freemail_get);
    AddItem(m_data.m_freemail_put, err.m_freemail_put);
    AddItem(m_data.m_reserv0, err.m_reserv0);
    AddItem(m_data.m_reserv1, err.m_reserv1);
    AddItem(m_data.m_reserv2, err.m_reserv2);
    AddItem(m_data.m_reserv3, err.m_reserv3);
    AddItem(m_data.m_reserv4, err.m_reserv4);
    AddItem(m_data.m_reserv5, err.m_reserv5);
    AddItem(m_data.m_reserv6, err.m_reserv6);
    AddItem(m_data.m_reserv7, err.m_reserv7);
    AddItem(m_data.m_reserv8, err.m_reserv8);
    AddItem(m_data.m_reserv9, err.m_reserv9);

    m_Mutex.Release();
}

void TSrvcErrorClass::AddSkeep() {
    m_Mutex.Acquire();

    if (m_data_skeep < 0xFFFFFFFF)
        m_data_skeep++;

    m_Mutex.Release();
}

TString TSrvcErrorClass::GetTxtdata(const TString& srvc_ident, TSrvcErrorDataItem& elem) {
    TString res = "";
    char buff[256];

    memset(buff, 0, sizeof(buff));
    snprintf(buff, sizeof(buff) - 1, "%s:%u-%u-%u-%u-%u-%u-%u-%u-%u-%u-%u-%u", srvc_ident.c_str(), elem.r_ok, elem.r_bad_params, elem.r_http_error, elem.r_bad_responce, elem.http_conn_ok, elem.http_conn_error, elem.http_conn_timeout, elem.http_conn_buffer_overflow, elem.http_reqst_ok, elem.http_reqst_error, elem.http_reqst_timeout, elem.http_reqst_overflow);
    res = TString(buff);

    return res;
}

void TSrvcErrorClass::EventTick() {
    TString text = "";
    time_t currenttime = time(nullptr);
    tm t1;
    tm t2;

    if ((localtime_r(&currenttime, &t1) != nullptr) && (localtime_r(&m_lastwritelog, &t2) != nullptr)) {
        if (((t1.tm_min % 5) == 0) && (t1.tm_min != t2.tm_min)) {
            m_Mutex.Acquire();

            m_lastwritelog = currenttime;

            text = text + "SKEEP:" + UI32ToStroka(m_data_skeep) + ", ";
            text = text + GetTxtdata("URLREP", m_data.m_urlreputation) + ", ";
            text = text + GetTxtdata("TEXTPR", m_data.m_textprocessor) + ", ";
            text = text + GetTxtdata("REP_GET", m_data.m_reputation_get) + ", ";
            text = text + GetTxtdata("REP_PUT", m_data.m_reputation_put) + ", ";
            text = text + GetTxtdata("SH_GET", m_data.m_shingler_get) + ", ";
            text = text + GetTxtdata("SH_PUT", m_data.m_shingler_put) + ", ";
            text = text + GetTxtdata("STATIP", m_data.m_statipserver) + ", ";
            text = text + GetTxtdata("DLVLOG", m_data.m_dlvlogserver) + ", ";
            text = text + GetTxtdata("FREEM_GET", m_data.m_freemail_get) + ", ";
            text = text + GetTxtdata("FREEM_PUT", m_data.m_freemail_put);
            //text = text + GetTxtdata("RESERV0", m_data.m_reserv0) + ", ";
            //text = text + GetTxtdata("RESERV1", m_data.m_reserv1) + ", ";
            //text = text + GetTxtdata("RESERV2", m_data.m_reserv2) + ", ";
            //text = text + GetTxtdata("RESERV3", m_data.m_reserv3) + ", ";
            //text = text + GetTxtdata("RESERV4", m_data.m_reserv4) + ", ";
            //text = text + GetTxtdata("RESERV5", m_data.m_reserv5) + ", ";
            //text = text + GetTxtdata("RESERV6", m_data.m_reserv6) + ", ";
            //text = text + GetTxtdata("RESERV7", m_data.m_reserv7) + ", ";
            //text = text + GetTxtdata("RESERV8", m_data.m_reserv8) + ", ";
            //text = text + GetTxtdata("RESERV9", m_data.m_reserv9) + ", ";

            m_data.Clear();
            m_data_skeep = 0;

            m_Mutex.Release();

            if ((LogsGroup != nullptr) && (LogsGroup->StatSrvcErrorLog() != nullptr))
                LogsGroup->StatSrvcErrorLog()->WriteMessageAndData("%s", text.c_str());
        }
    }
}

