#pragma once

#include <util/generic/string.h>
#include "util/system/mutex.h"
#include "util/datetime/systime.h"
#include <mail/so/spamstop/tools/so-common/kfunc.h>
#include "tlogsgroup.h"

struct TSrvcErrorDataItem
{
   ui32 r_ok;
   ui32 r_bad_params;
   ui32 r_http_error;
   ui32 r_bad_responce;
   ui32 http_conn_ok;
   ui32 http_conn_error;
   ui32 http_conn_timeout;
   ui32 http_conn_buffer_overflow;
   ui32 http_reqst_ok;
   ui32 http_reqst_error;
   ui32 http_reqst_timeout;
   ui32 http_reqst_overflow;

   TSrvcErrorDataItem()
   {
      Clear();
   }

   void Clear()
   {
      r_ok                       = 0;
      r_bad_params               = 0;
      r_http_error               = 0;
      r_bad_responce             = 0;
      http_conn_ok               = 0;
      http_conn_error            = 0;
      http_conn_timeout          = 0;
      http_conn_buffer_overflow  = 0;
      http_reqst_ok              = 0;
      http_reqst_error           = 0;
      http_reqst_timeout         = 0;
      http_reqst_overflow        = 0;
   }
};

struct TSrvcErrorData
{
   TSrvcErrorDataItem m_urlreputation;
   TSrvcErrorDataItem m_textprocessor;
   TSrvcErrorDataItem m_reputation_get;
   TSrvcErrorDataItem m_reputation_put;
   TSrvcErrorDataItem m_shingler_get;
   TSrvcErrorDataItem m_shingler_put;
   TSrvcErrorDataItem m_statipserver;
   TSrvcErrorDataItem m_dlvlogserver;
   TSrvcErrorDataItem m_freemail_get;
   TSrvcErrorDataItem m_freemail_put;
   TSrvcErrorDataItem m_reserv0;
   TSrvcErrorDataItem m_reserv1;
   TSrvcErrorDataItem m_reserv2;
   TSrvcErrorDataItem m_reserv3;
   TSrvcErrorDataItem m_reserv4;
   TSrvcErrorDataItem m_reserv5;
   TSrvcErrorDataItem m_reserv6;
   TSrvcErrorDataItem m_reserv7;
   TSrvcErrorDataItem m_reserv8;
   TSrvcErrorDataItem m_reserv9;

   TSrvcErrorData()
   {
      Clear();
   }

   void Clear()
   {
      m_urlreputation.Clear();
      m_textprocessor.Clear();
      m_reputation_get.Clear();
      m_reputation_put.Clear();
      m_shingler_get.Clear();
      m_shingler_put.Clear();
      m_statipserver.Clear();
      m_dlvlogserver.Clear();
      m_freemail_get.Clear();
      m_freemail_put.Clear();
      m_reserv0.Clear();
      m_reserv1.Clear();
      m_reserv2.Clear();
      m_reserv3.Clear();
      m_reserv4.Clear();
      m_reserv5.Clear();
      m_reserv6.Clear();
      m_reserv7.Clear();
      m_reserv8.Clear();
      m_reserv9.Clear();
   }
};


class TSrvcErrorClass
{
private:
         TSrvcErrorData m_data;
         TMutex         m_Mutex;
         TLogsGroup     *LogsGroup;
         time_t         m_lastwritelog;
         ui32           m_data_skeep;

         void           AddItem(TSrvcErrorDataItem &elem, const TSrvcErrExt &err);
         TString         GetTxtdata(const TString &srvc_ident, TSrvcErrorDataItem &elem);
public:
         TSrvcErrorClass();
         ~TSrvcErrorClass();

         void Init(TLogsGroup *LogsGroupA);
         void EventTick();
         void Add(TSrvcErr err);
         void AddSkeep();


};
