#include <library/cpp/string_utils/base64/base64.h>
#include "tstatipobject.h"
#include "tserviceobject.h"

TStatIPObject::TStatIPObject()
{
   m_Storage               = NULL;
   server_id               = "";
   lastwritestatlog        = time(NULL);
   lastwritemonlog         = time(NULL);
   m_linktogetbyid         = "";
   LogsGroup               = NULL;
   configobj               = NULL;
   m_RulesStorage          = new TRuleStorage();
   m_RuleTrap              = new TRuleTrap();
   PeriodTrap              = new TPeriodTrap();
   trap                    = new TTrap();
   perstat                 = new TPeriodStat();
   RenginePool             = new TRenginePool();
   whiteip_cache           = new TWhiteIPLocalCache();
   banip_cache             = new TBanIPLocalCache();
   m_enable_obrabmess      = false;
   m_enable_viewstatlogs   = false;
   m_minstatcountperiod    = 0;
   m_minstatcount          = 0;
   m_fastban_list          = NULL;
   m_fastreject_list       = NULL;
   m_fastskeep_list        = NULL;
   m_allrulesreset_last    = " -";
   m_doreset               = " -";
   m_dorellist             = " -";
   m_hide_could_not_find_rule = false;
}

TStatIPObject::~TStatIPObject()
{
   if (m_fastban_list != NULL)
   {
      delete m_fastban_list;
      m_fastban_list = NULL;
   }

   if (m_fastreject_list != NULL)
   {
      delete m_fastreject_list;
      m_fastreject_list = NULL;
   }

   if (m_fastskeep_list != NULL)
   {
      delete m_fastskeep_list;
      m_fastskeep_list = NULL;
   }

   if (banip_cache != NULL)
   {
      delete banip_cache;
      banip_cache = NULL;
   }
   if (whiteip_cache != NULL)
   {
      delete whiteip_cache;
      whiteip_cache = NULL;
   }
   if (RenginePool != NULL)
   {
      delete RenginePool;
      RenginePool = NULL;
   }
   if (m_RulesStorage != NULL)
   {
      delete m_RulesStorage;
      m_RulesStorage = NULL;
   }
   if (m_RuleTrap != NULL)
   {
      delete m_RuleTrap;
      m_RuleTrap = NULL;
   }
   if (PeriodTrap != NULL)
   {
      delete PeriodTrap;
      PeriodTrap = NULL;
   }
   if (trap != NULL)
   {
      delete trap;
      trap = NULL;
   }
   if (perstat != NULL)
   {
      delete perstat;
      perstat = NULL;
   }
   if (m_Storage != NULL)
   {
      delete m_Storage;
      m_Storage = NULL;
   }
}

bool TStatIPObject::InitBeforeFork(const TString &server_idA, TLogsGroup *LogsGroupA, TKConfig *configobjA)
{
   bool     res                       = true;
   ui32     min_treshold              = 0;
   ui32     max_treshold              = 0;
   ui32     min_treshold_other        = 0;
   ui32     max_treshold_other        = 0;
   TString   instream_filename         = "";
   TString   instream_index_filename   = "";
   bool     savemess                  = false;
   TString   rulstat_dumpfilename      = "";
   bool     rulstat_load_at_start     = false;
   TString   ruletrappath              = "";
   TString   periodtrapfilename        = "";
   TString   dnRules                   = "";
   float    Score                     = 1;
   int      filtercount               = 1;
   int      whitelocalcache_diff      = 0;
   ui32     whitelocalcache_difftime  = 0;
   ui32     banlocalcache_period      = 0;
   TString   fastban_filename          = "";
   TString   fastreject_filename       = "";
   TString   fastskeep_filename        = "";

   server_id      = server_idA;
   LogsGroup      = LogsGroupA;
   configobj      = configobjA;

#ifdef MONGO_OLD
   m_Storage = new TStorageMongoOld();
#else  //MONGO_OLD
   m_Storage = new TDataBasaMongoV3();
#endif //MONGO_OLD
   if (m_Storage != NULL)
      m_Storage->InitBeforeFork("", "", "", "", LogsGroup, configobj);

   change_labels_list.push_back(NStorageStats::TStorageRequestStat::TChangeLabelStruct(NStorageStats::TStorageRequestStat::SAT_UPDATE, "full (FL)", "FL"));
   change_labels_list.push_back(NStorageStats::TStorageRequestStat::TChangeLabelStruct(NStorageStats::TStorageRequestStat::SAT_FINDONE, "getbanstate_cache (GBL)", "GBL"));
   change_labels_list.push_back(NStorageStats::TStorageRequestStat::TChangeLabelStruct(NStorageStats::TStorageRequestStat::SAT_ERASE, "getbanstate_stor1 (GBS1)", "GBS1"));
   //change_labels_list.push_back(NStorageStats::TStorageRequestStat::TChangeLabelStruct(NStorageStats::TStorageRequestStat::SAT_RESERV1, "getbanstate_stor2 (GBS2)", "GBS2"));
   change_labels_list.push_back(NStorageStats::TStorageRequestStat::TChangeLabelStruct(NStorageStats::TStorageRequestStat::SAT_SIZE, "check_lists (CL)", "CL"));
   change_labels_list.push_back(NStorageStats::TStorageRequestStat::TChangeLabelStruct(NStorageStats::TStorageRequestStat::SAT_MULTYACTION, "ipv4mem (IP4M)", "IP4M"));
   change_labels_list.push_back(NStorageStats::TStorageRequestStat::TChangeLabelStruct(NStorageStats::TStorageRequestStat::SAT_FIND, "ipv6mem (IP6M)", "IP6M"));
   change_labels_list.push_back(NStorageStats::TStorageRequestStat::TChangeLabelStruct(NStorageStats::TStorageRequestStat::SAT_CLEAR, "get_filter (GF)", "GF"));
   change_labels_list.push_back(NStorageStats::TStorageRequestStat::TChangeLabelStruct(NStorageStats::TStorageRequestStat::SAT_FINDANDMODIFY, "work_filter (WF)", "WF"));

   if (configobj != NULL)
   {
      m_minstatcountperiod    = configobj->ReadInteger("mem", "minstatcountperiod", 0);
      m_minstatcount          = configobj->ReadInteger("mem", "minstatcount", 0);

      m_linktogetbyid         = configobj->ReadStroka("server", "srvtogetbyid", "");
      m_enable_obrabmess      = configobj->ReadBool("func", "enable_obrabmess", false);;
      m_enable_viewstatlogs   = configobj->ReadBool("func", "enable_viewstatlogs", false);

      min_treshold            = configobj->ReadInteger("server", "cluster_min_treshold", 1000);
      max_treshold            = configobj->ReadInteger("server", "cluster_max_treshold", 1500);
      TrafficControl.Init(min_treshold, max_treshold, true);

      min_treshold_other      = configobj->ReadInteger("server", "other_min_treshold", 1000);
      max_treshold_other      = configobj->ReadInteger("server", "other_max_treshold", 1500);
      ControlTraffOther.Init(min_treshold_other, max_treshold_other, true);

      instream_filename       = configobj->ReadStroka("func", "save_filename", "");
      instream_index_filename = configobj->ReadStroka("func", "save_filename_index", "");
      savemess                = configobj->ReadBool("func", "enable_savemess", false);

      rulstat_dumpfilename    = configobj->ReadStroka("rulsstat", "dumpfilename", "");
      rulstat_load_at_start   = configobj->ReadBool("rulsstat", "load_at_start", false);
      if (m_RulesStorage != NULL)
         m_RulesStorage->Init(rulstat_load_at_start, rulstat_dumpfilename, LogsGroup);

      ruletrappath            = configobj->ReadStroka("logs", "ruletrappath", "");
      if (m_RuleTrap != NULL)
         m_RuleTrap->Init(ruletrappath);

      periodtrapfilename      = configobj->ReadStroka("func", "periodtrapfilename", "");
      if (PeriodTrap != NULL)
         PeriodTrap->Init(periodtrapfilename);

      whitelocalcache_diff     = configobj->ReadInteger("mem", "white_local_cache_diff", 10);
      whitelocalcache_difftime = configobj->ReadInteger("mem", "white_local_cache_diff_time", 60);
      if (whiteip_cache != NULL)
         whiteip_cache->Init(whitelocalcache_diff, whitelocalcache_difftime);

      banlocalcache_period     = configobj->ReadInteger("mem", "ban_local_cache_period", 60);
      if (banip_cache != NULL)
         banip_cache->Init(banlocalcache_period);

      ui16 addbantime   = configobj->ReadInteger("ban", "addbantime", 0);
      ui16 repeaterbase = configobj->ReadInteger("ban", "repeaterbase", 0);
      CPO.SetAddBanTime(addbantime);
      CPO.SetRepeaterBase(repeaterbase);

      res = ipbasa.InitBeforeFork(this, LogsGroup, configobj, &CPO);

      fastban_filename          = configobj->ReadStroka("fast_answer", "fastban_list", "");
      if (!fastban_filename.empty())
      {
         m_fastban_list = new TNetKIPv6("FASTBAN");
         if (m_fastban_list != NULL)
         {
            m_fastban_list->Init(fastban_filename, LogsGroup->ActionLog());
            m_fastban_list->ReloadFileList();
         }
      }

      fastreject_filename       = configobj->ReadStroka("fast_answer", "fastreject_list", "");
      if (!fastreject_filename.empty())
      {
         m_fastreject_list = new TNetKIPv6("FASTREJECT");
         if (m_fastreject_list != NULL)
         {
            m_fastreject_list->Init(fastreject_filename, LogsGroup->ActionLog());
            m_fastreject_list->ReloadFileList();
         }
      }

      fastskeep_filename        = configobj->ReadStroka("fast_answer", "fastskeep_list", "");
      if (!fastskeep_filename.empty())
      {
         m_fastskeep_list = new TNetKIPv6("FASTSKEEP");
         if (m_fastskeep_list != NULL)
         {
            m_fastskeep_list->Init(fastskeep_filename, LogsGroup->ActionLog());
            m_fastskeep_list->ReloadFileList();
         }
      }

      m_hide_could_not_find_rule = configobj->ReadBool("filter", "hide_could_not_find_rule", false);
      dnRules = configobj->ReadStroka("filter", "dnRules", "");
      Score = configobj->ReadFloat("filter", "score", 1);
      filtercount = configobj->ReadFloat("filter", "filtercount", 1);
      if (RenginePool != NULL)
         res = RenginePool->Init(LogsGroup, filtercount, dnRules, Score, ipbasa.GetRulePrintList());
      else
         res = false;

      ipmess.Init(this, LogsGroup, &ipbasa, &TrafficControl, m_RulesStorage, m_RuleTrap, PeriodTrap, trap, perstat, RenginePool, whiteip_cache, banip_cache);
   }

   return res;
}

bool TStatIPObject::InitAfterFork()
{
   bool res = true;

   if (m_Storage != NULL)
      m_Storage->InitAfterFork();
   if (res)
      res = ipbasa.InitAfterFork();

   return res;
}

bool TStatIPObject::WriteDump()
{
   return true;
}

bool TStatIPObject::Midnight()
{
   if (m_Storage != NULL)
      m_Storage->Midnight();

   TrafficControl.Midnight();
   ControlTraffOther.Midnight();

   //statistic rules
   if (m_RulesStorage != NULL)
      m_RulesStorage->Midnight();

   if (banip_cache != NULL)
      banip_cache->Midnight();
   if (whiteip_cache != NULL)
      whiteip_cache->Midnight();

   ipmess.Midnight();
   ipbasa.Midnight();

   in_statweb.Midnight();

   return true;
}

void TStatIPObject::EventTick()
{
   if (m_Storage != NULL)
      m_Storage->EventTick();

   TrafficControl.CalcCPS();
   ControlTraffOther.CalcCPS();
   ipmess.EventTick();
   ipbasa.EventTick();
   WriteStatToLog();
   WriteMonLog();
   if (PeriodTrap != NULL)
      PeriodTrap->EraseOld();

   if (banip_cache != NULL)
      banip_cache->EventTick();
}

void TStatIPObject::EventTickHeavy()
{


}

bool TStatIPObject::MidnightHeavy()
{
   bool res = true;


   return res;
}

bool TStatIPObject::OldUnpackData(const char* instr, size_t len, bool& warning_size, TString& result, TString& errs)
{
   bool                 res                 = false;
   ui32                 count_pack_base64   = 0;
   ui32                 count_unpack_base64 = 0;
   ui32                 count_unpack        = 0;
   ui32                 n4                  = 0;
   TString               flagend             = PR_FLAGEND;
   char                 *decode_data        = NULL;
   ui32                 decode_base64_data_size = 0;
   char                 *decode_base64_data = NULL;
   ui32                 decode_data_size    = 0;
   ui32                 decode_data_size2   = 0;
   bool                 compress            = true;
   char                 *unpackdata         = NULL;
   ui32                 unpackdatasize      = 0;
   TString               shingle             = "";
   TString               stat                = "";
   ui32                 tui                 = 0;
   int                  err                 = 0;

   err = 0;
   warning_size = false;
   count_pack_base64 = len;
   if ( (count_pack_base64 > 0) && (instr != NULL) )
   {
         decode_base64_data_size = count_pack_base64 + flagend.size() + 1;
         decode_base64_data = new char[decode_base64_data_size];
         try
         {
            //decode base64
            memset(decode_base64_data, 0, decode_base64_data_size);
            //count_unpack_base64 = base64_decode(decode_base64_data, instr);

            TVector< char > vDecode_data(Base64DecodeBufSize(len));
            count_unpack_base64 = Base64Decode(&vDecode_data[0], instr, instr + len);

            if (decode_base64_data_size > vDecode_data.size())
               memcpy(decode_base64_data, &vDecode_data[0], vDecode_data.size());

            //decode deflate
            if (compress)
            {
               decode_data_size = MAX_IN_BUFF_SIZE + flagend.size() + 1;
               decode_data = new char[decode_data_size];
               try
               {
                  memset(decode_data, 0, decode_data_size);
                  decode_data_size2 = decode_data_size - flagend.size() - 1;
                  tui = decode_data_size2;

                  uLongf destlen = decode_data_size2;
                  uLongf sourcelen = count_unpack_base64;

                  err = uncompress((Bytef *)decode_data, &destlen, (Bytef *)decode_base64_data, sourcelen);
                  if (err == Z_OK)
                  {
                     unpackdata = decode_data;
                     unpackdatasize = destlen;

                     result = TString(unpackdata, unpackdatasize);
                     res = true;
                  } else
                  {
                     errs = "error unpack mail (" + IntToStroka(err) + "), destlen=" + IntToStroka(destlen) + ", sourcelen=" + IntToStroka(sourcelen);
                     res = false;
                  }

                  if (decode_data != NULL){
                     delete[] decode_data;
                     decode_data = NULL;
                  }
               } catch(...)
               {
                  if (decode_data != NULL){
                     delete[] decode_data;
                     decode_data = NULL;
                  }
               }
            } else
            {
               unpackdata = decode_base64_data;
               unpackdatasize = count_unpack_base64;

               result = TString(unpackdata, unpackdatasize);
               res = true;
            }

            if (decode_base64_data != NULL){
               delete[] decode_base64_data;
               decode_base64_data = NULL;
            }

         } catch(...)
         {
            if (decode_base64_data != NULL){
               delete[] decode_base64_data;
               decode_base64_data = NULL;
            }
         }

   }

   return res;
}

TObrabResult TStatIPObject::ObrabRequest(TKIPv6 ip, TString &mail, int lzo, bool &f_ok, const TString &id, const TString &remote_ip, ui32 &trap_remain, ui32 sendtorbl, const TStatDBCollInfo stat_info)
{
   TObrabResult res;
   bool         warning_size = false;
   TString       result       = "";
   TString       err_s        = "";
   bool         good_unpack  = false;
   TTimes       delays;

   //�������������
   if (lzo > 0)            //lzo
   {
      if (Unbase64AndUncompress(mail.c_str(), mail.length(), warning_size, result, err_s))
         good_unpack = true;
   } else                  //�� lzo
   {
      if (OldUnpackData(mail.c_str(), mail.length(), warning_size, result, err_s))
         good_unpack = true;
   }

   if (!good_unpack)
   {
      PrintFollowIp(ip, id.c_str(), FIE_02, "");
      if ( (LogsGroup != NULL) && (LogsGroup->ActionLog() != NULL) )
         LogsGroup->ActionLog()->WriteMessageAndDataStatus(KERROR, "FILTER: %s", err_s.c_str());

   } else
   {
      f_ok = true;
      //������������
      PrintFollowIp(ip, id.c_str(), FIE_01, "");
      res = ipmess.ObrabMessage(pdl, result, delays, id, TrafficControl.GetInMPS(), TrafficControl.GetMinTreshold(), remote_ip, trap_remain, sendtorbl, stat_info);
   }

   return res;
}

TObrabResult TStatIPObject::ObrabRequestSerializeData(TKIPv6 ip, TString &mail, bool &f_ok, const TString &id, const TString &remote_ip, ui32 &trap_remain, ui32 sendtorbl, const TStatDBCollInfo stat_info)
{
   TObrabResult         res;
   TString               result = "";
   TTimes               delays;
   TParsedDlvLogDataEx  pdlde;

   if (pdlde.UnPackAll(mail.c_str(), mail.length()))
   {
      f_ok = true;
      //������������
      res = ipmess.ObrabMessageSerializeData(pdlde, delays, id, TrafficControl.GetInMPS(), TrafficControl.GetMinTreshold(), remote_ip, trap_remain, sendtorbl, stat_info);

   } else
   {
      PrintFollowIp(ip, id.c_str(), FIE_02, "");
      ipmess.PrintParseError(id);
   }

   return res;
}

TSummaryStatistik TStatIPObject::GetStatistic()
{
   TSummaryStatistik res;

   res.trafficctrl_stat = TrafficControl.GetConsoleStat();
   res.tcstat_frodo = ControlTraffOther.GetConsoleStat();
   if (RenginePool != NULL)
      res.renginepool    = RenginePool->GetStat();
   if (ipbasa.GetBanIP() != NULL)
   {
      res.bstat  = ipbasa.GetBanIP()->GetStat();
      res.bstat7 = ipbasa.GetBanIP()->GetStat7();
   }

   return res;
}

TString TStatIPObject::GetMonitoringData()
{
   return "";
}

void TStatIPObject::Shutdown()
{
   if (trap != NULL)
      trap->Quit();
}

TSummaryInfo TStatIPObject::GetChangePropSummaryInfo()
{
   TSummaryInfo res;

   if (true)
   {
      res.chpropsi = CPO.GetSummaryInfo();
      //res.EnableSaveMail = ipk->SaveMailKey.GetValue();
      if (LogsGroup != NULL)
      {
         if (LogsGroup->ProtokolLog() != NULL)
         {
            res.protokol = LogsGroup->ProtokolLog()->GetTekFilename();
            res.Enable_protokol_log = LogsGroup->ProtokolLog()->GetWriteStatus();
            res.Nofflush_protokol_log = LogsGroup->ProtokolLog()->FFlushStatus();
         }
         if (LogsGroup->PBProtokolLog() != NULL)
         {
            res.pbprotokol = LogsGroup->PBProtokolLog()->GetTekFilename();
            res.Enable_pbprotokol_log = LogsGroup->PBProtokolLog()->GetWriteStatus();
            res.Nofflush_pbprotokol_log = LogsGroup->PBProtokolLog()->FFlushStatus();
         }
         if (LogsGroup->RejectLog() != NULL)
         {
            res.reject = LogsGroup->RejectLog()->GetTekFilename();
            res.Enable_reject_log = LogsGroup->RejectLog()->GetWriteStatus();
            res.Nofflush_reject_log = LogsGroup->RejectLog()->FFlushStatus();
         }
         if (LogsGroup->StatLog() != NULL)
         {
            res.stat = LogsGroup->StatLog()->GetTekFilename();
            res.Enable_stat_log = LogsGroup->StatLog()->GetWriteStatus();
            res.Nofflush_stat_log = LogsGroup->StatLog()->FFlushStatus();
         }
         if (LogsGroup->Ban3mailLog() != NULL)
         {
            res.ban3mail = LogsGroup->Ban3mailLog()->GetTekFilename();
            res.Enable_ban3mail_log = LogsGroup->Ban3mailLog()->GetWriteStatus();
            res.Nofflush_ban3mail_log = LogsGroup->Ban3mailLog()->FFlushStatus();
         }
         if (LogsGroup->ZonesLog() != NULL)
         {
            res.zones = LogsGroup->ZonesLog()->GetTekFilename();
            res.Enable_zones_log = true;
            res.Nofflush_zones_log = LogsGroup->ZonesLog()->FFlushStatus();
         }
         if (LogsGroup->DayLoghLog() != NULL)
         {
            res.daylogh = LogsGroup->DayLoghLog()->GetTekFilename();
            res.Enable_daylogh_log = LogsGroup->DayLoghLog()->GetWriteStatus();
            res.Nofflush_daylogh_log = LogsGroup->DayLoghLog()->FFlushStatus();
         }
         if (LogsGroup->WhiteIpLog() != NULL)
         {
            res.whiteip = LogsGroup->WhiteIpLog()->GetTekFilename();
            res.Enable_whiteip_log = LogsGroup->WhiteIpLog()->GetWriteStatus();
            res.Nofflush_whiteip_log = LogsGroup->WhiteIpLog()->FFlushStatus();
         }
         if (LogsGroup->TmpBan30Log() != NULL)
         {
            res.tmpban30 = LogsGroup->TmpBan30Log()->GetTekFilename();
            res.Enable_tmp_ban30_log = LogsGroup->TmpBan30Log()->GetWriteStatus();
            res.Nofflush_tmp_ban30_log = LogsGroup->TmpBan30Log()->FFlushStatus();
         }
         if (LogsGroup->MissingMessLog() != NULL)
         {
            res.missingmess = LogsGroup->MissingMessLog()->GetTekFilename();
            res.Enable_missingmess_log = LogsGroup->MissingMessLog()->GetWriteStatus();
            res.Nofflush_missingmess_log = LogsGroup->MissingMessLog()->FFlushStatus();
         }
         if (LogsGroup->TraceIpLog() != NULL)
         {
            res.traceip = LogsGroup->TraceIpLog()->GetTekFilename();
            res.Enable_traceip_log = LogsGroup->TraceIpLog()->GetWriteStatus();
            res.Nofflush_traceip_log = LogsGroup->TraceIpLog()->FFlushStatus();
         }
         if (LogsGroup->StatIPLog() != NULL)
         {
            res.statip = LogsGroup->StatIPLog()->GetTekFilename();
            res.Enable_statip_log = LogsGroup->StatIPLog()->GetWriteStatus();
            res.Nofflush_statip_log = LogsGroup->StatIPLog()->FFlushStatus();
         }
         if (LogsGroup->ActionLog() != NULL)
         {
            res.saction = LogsGroup->ActionLog()->GetTekFilename();
            res.Enable_action_log = LogsGroup->ActionLog()->GetWriteStatus();
            res.Nofflush_action_log = LogsGroup->ActionLog()->FFlushStatus();
         }
      }
      res.yes_data = true;
   }

   return res;
}

void TStatIPObject::WriteStatToLog()
{
   time_t t = time(NULL);

   if ((t - lastwritestatlog) > 60)
   {
      TString text             = "";
      TString mailstat         = "";
      ui32   ham              = 0;
      ui32   spam             = 0;
      ui32   malic            = 0;
      ui32   ban              = 0;
      ui32   maxusedrengine   = 0;
      TString filters_rps      = "";

      lastwritestatlog = t;

      if ( (LogsGroup != NULL) && (LogsGroup->StatMPSLog() != NULL) )
      {
         TString claster_stat     = "";
         TString getforfrodo_stat = "";
         TString getfilter_stat   = "";

         claster_stat = TrafficControl.GetStatistikToLog();
         getforfrodo_stat = ControlTraffOther.GetStatistikToLog2();
         if (RenginePool != NULL)
            getfilter_stat = RenginePool->GetStatForLog();

         text = "IN_CLUSTER[" + claster_stat + "], IN_OTHER[" + getforfrodo_stat + "], RENGINEPOOL[" + getfilter_stat + "]";

         LogsGroup->StatMPSLog()->WriteMessageAndData("%s", text.c_str());
      }
   }
}

bool TStatIPObject::IsBanIpForMark( TKIPv6 ip )
{
   bool res          = false;
   bool ban          = false;
   ui16 ban_hours    = 0;
   ui8  ban_pr       = 0;
   bool ban7         = false;
   ui16 ban7_hours   = 0;
   ui8  ban7_pr      = 0;

   ipmess.IsBanIpExt(ip, ban, ban_hours, ban_pr, ban7, ban7_hours, ban7_pr);
   res = ban;

   return res;
}

void TStatIPObject::IsBanIpExt(TKIPv6 ip, bool &ban, ui16 &ban_hours, ui8 &ban_pr, bool &ban7, ui16 &ban7_hours, ui8 &ban7_pr)
{
   ipmess.IsBanIpExt(ip, ban, ban_hours, ban_pr, ban7, ban7_hours, ban7_pr);
}

void TStatIPObject::CheckMemBasa(TKIPv6 ip, const TString &id)
{
   bool   diskwrite = false;
   time_t currtime  = time(NULL);

   if (ipbasa.GetMemBasa() != NULL)
      ipbasa.GetMemBasa()->mCheckMemBasa(ip, currtime, diskwrite, id, ipmess.ChangeDay1Counter(), ipmess.ChangeDay2Counter());
}

TIpStatOne TStatIPObject::GetIpStat(TKIPv6 ip)
{
   TIpStatOne res;

   if (ipbasa.GetMemBasa() != NULL)
      res = ipbasa.GetMemBasa()->GetIpStat(ip);

   return res;
}

ui32 TStatIPObject::GetHeavyMemCount()
{
   ui32 res = 0;

   if (ipbasa.GetMemBasa() != NULL)
      res = ipbasa.GetMemBasa()->GetHeavyMemCount();

   return res;
}

void TStatIPObject::WriteMonLog()
{
   time_t t = time(NULL);

   if ((t - lastwritemonlog) > 60)
   {
      TString text             = "";

      lastwritemonlog = t;

      if ( (LogsGroup != NULL) && (LogsGroup->MonLog() != NULL) )
      {
         //server identifier
         text = text + "<SRVR:" + server_id + ">";

         //input statistik
   NStorageStats::TStorageStatVector datav = in_statmon.GetMonStat();
         datav.ChangeLabelLog(change_labels_list);
         text = text + datav.PrintDataLog();

         //request from cluster
         text = text + "<CLUST:" + IntToStroka(TrafficControl.GetDiffAllRequest()) + "/" + IntToStroka(TrafficControl.GetDiffLostRequest()) + ">";

         //request getforfrodo
         text = text + "<GOT:" + IntToStroka(ControlTraffOther.GetDiffAllRequest()) + "/" + IntToStroka(ControlTraffOther.GetDiffLostRequest()) + ">";

         //rules stat
         text = text + "<RULS:" + ipmess.GetUniqRulesCount() + ">";

         //whilte ip count
         text = text + "<WHT:" + IntToStroka(ipmess.GetWhiteIPCount()) + ">";

         //ban count
         text = text + "<ISBAN:" + IntToStroka(ipmess.GetIsBanIPCount()) + ">";

         //ban2 (reject) count
         text = text + "<RJT:" + IntToStroka(ipmess.GetBan2IPCount()) + ">";

         //action ban count
         text = text + "<ACTBAN:" + IntToStroka(ipmess.GetActionBanCount()) + ">";

         //ipv6 count
         text = text + "<IPV6:" + IntToStroka(ipmess.GetIPv6Count()) + ">";

         //chane day count
         text = text + "<CDC:" + IntToStroka(ipmess.GetChangeDay1Count()) + "/" + IntToStroka(ipmess.GetChangeDay2Count()) + ">";

         //storage statistik
         if (GetStorage() != NULL)
            text = text + GetStorage()->GetMonStat().PrintDataLog();

         LogsGroup->MonLog()->WriteMessageAndData("%s", text.c_str());
         LogsGroup->MonLog()->FFlush();
      }
   }
}

bool TStatIPObject::IsFastBanIP(TKIPv6 ip)
{
   bool res = false;

   if (m_fastban_list != NULL)
      res = m_fastban_list->IsInNet(ip);

   return res;
}

bool TStatIPObject::IsFastRejectIP(TKIPv6 ip)
{
   bool res = false;

   if (m_fastreject_list != NULL)
      res = m_fastreject_list->IsInNet(ip);

   return res;
}

bool TStatIPObject::IsFastSkeepIP(TKIPv6 ip)
{
   bool res = false;

   if (m_fastskeep_list != NULL)
      res = m_fastskeep_list->IsInNet(ip);

   return res;
}

void TStatIPObject::ReloadFastList()
{
   if (m_fastban_list != NULL)
      m_fastban_list->ReloadFileList();

   if (m_fastreject_list != NULL)
      m_fastreject_list->ReloadFileList();

   if (m_fastskeep_list != NULL)
      m_fastskeep_list->ReloadFileList();

}

TString TFollowIpEventToStroka(TFollowIpEvent value)
{
   TString res = "";

   switch (value)
   {
   case FIE_00:
                  res = "FIE_00";
                  break;
   case FIE_01:
                  res = "FIE_01";
                  break;
   case FIE_02:
                  res = "FIE_02";
                  break;
   case FIE_03:
                  res = "FIE_03";
                  break;
   case FIE_04:
                  res = "FIE_04";
                  break;
   case FIE_05:
                  res = "FIE_05";
                  break;
   case FIE_06:
                  res = "FIE_06";
                  break;
   case FIE_07:
                  res = "FIE_07";
                  break;
   case FIE_08:
                  res = "FIE_08";
                  break;
   case FIE_09:
                  res = "FIE_09";
                  break;
   case FIE_10:
                  res = "FIE_10";
                  break;
   case FIE_11:
                  res = "FIE_11";
                  break;
   case FIE_12:
                  res = "FIE_12";
                  break;
   case FIE_13:
                  res = "FIE_13";
                  break;
   case FIE_14:
                  res = "FIE_14";
                  break;
   case FIE_15:
                  res = "FIE_15";
                  break;
   case FIE_16:
                  res = "FIE_16";
                  break;
   case FIE_17:
                  res = "FIE_17";
                  break;
   case FIE_18:
                  res = "FIE_18";
                  break;
   case FIE_19:
                  res = "FIE_19";
                  break;
   case FIE_20:
                  res = "FIE_20";
                  break;
   case FIE_21:
                  res = "FIE_21";
                  break;
   case FIE_22:
                  res = "FIE_22";
                  break;
   case FIE_23:
                  res = "FIE_23";
                  break;
   case FIE_24:
                  res = "FIE_24";
                  break;
   case FIE_25:
                  res = "FIE_25";
                  break;
   case FIE_26:
                  res = "FIE_26";
                  break;
   case FIE_27:
                  res = "FIE_27";
                  break;
   case FIE_28:
                  res = "FIE_28";
                  break;
   case FIE_29:
                  res = "FIE_29";
                  break;
   case FIE_30:
                  res = "FIE_30";
                  break;
   case FIE_31:
                  res = "FIE_31";
                  break;
   case FIE_32:
                  res = "FIE_32";
                  break;
   case FIE_33:
                  res = "FIE_33";
                  break;
   case FIE_34:
                  res = "FIE_34";
                  break;
   case FIE_35:
                  res = "FIE_35";
                  break;
   default:
                  res = "FIE_UNKNOWN";
   };

   return res;
}

void TStatIPObject::AddFollowIP(TKIPv6 ip)
{
   if (!ip.Undefined())
   {
      m_FollowIpMutex.Acquire();

      THashMap<TKIPv6, ui32>::iterator it;

      it = m_FollowIpStor.find(ip);
      if (it == m_FollowIpStor.end())
         m_FollowIpStor[ip] = 0;

      m_FollowIpMutex.Release();
   }
}

bool TStatIPObject::IsFollowIP(TKIPv6 ip)
{
   bool res = false;

   if (!ip.Undefined())
   {
      m_FollowIpMutex.Acquire();

      THashMap<TKIPv6, ui32>::iterator it;

      it = m_FollowIpStor.find(ip);
      if (it != m_FollowIpStor.end())
         res = true;

      m_FollowIpMutex.Release();
   }

   return res;
}

bool TStatIPObject::IsFollowIPExt(TKIPv6 ip)
{
   bool res = false;

   if (!ip.Undefined())
   {
      m_FollowIpMutex.Acquire();

      THashMap<TKIPv6, ui32>::iterator it;

      it = m_FollowIpStor.find(ip);
      if (it != m_FollowIpStor.end())
      {
         (*it).second = IncMax32((*it).second, 1);
         res = true;

      }

      m_FollowIpMutex.Release();
   }

   return res;
}

bool TStatIPObject::DeleteFollowIP(TKIPv6 ip)
{
   bool res = false;

   if (!ip.Undefined())
   {
      m_FollowIpMutex.Acquire();

      THashMap<TKIPv6, ui32>::iterator it;

      it = m_FollowIpStor.find(ip);
      if (it != m_FollowIpStor.end())
      {
         m_FollowIpStor.erase(it);
         res = true;
      }

      m_FollowIpMutex.Release();
   }

   return res;
}

void TStatIPObject::PrintFollowIp(TKIPv6 ip, const TString &id, TFollowIpEvent fievent, const TString &dobdata)
{
   if (IsFollowIP(ip))
   {
      if ( (LogsGroup != NULL) && (LogsGroup->FollowLog() != NULL) )
      {
         if (dobdata.empty())
            LogsGroup->FollowLog()->WriteMessageAndData("%s %s %s", id.c_str(), ip.toStroka().c_str(), TFollowIpEventToStroka(fievent).c_str());
         else
            LogsGroup->FollowLog()->WriteMessageAndData("%s %s %s [%s]", id.c_str(), ip.toStroka().c_str(), TFollowIpEventToStroka(fievent).c_str(), dobdata.c_str());

      }

   }
}

void TStatIPObject::PrintFollowExt(TKIPv6 ip, const TString &id, TFollowIpEvent fievent, const TString &dobdata)
{
   if (IsFollowIPExt(ip))
   {
      if ( (LogsGroup != NULL) && (LogsGroup->FollowLog() != NULL) )
      {
         if (dobdata.empty())
            LogsGroup->FollowLog()->WriteMessageAndData("%s %s %s", id.c_str(), ip.toStroka().c_str(), TFollowIpEventToStroka(fievent).c_str());
         else
            LogsGroup->FollowLog()->WriteMessageAndData("%s %s %s [%s]", id.c_str(), ip.toStroka().c_str(), TFollowIpEventToStroka(fievent).c_str(), dobdata.c_str());

      }

   }
}

void TStatIPObject::ReturnFollowIpsList(THashMap<TKIPv6, ui32> &filist)
{
   filist.clear();

   m_FollowIpMutex.Acquire();

   THashMap<TKIPv6, ui32>::iterator it;

   it = m_FollowIpStor.begin();
   while (it != m_FollowIpStor.end())
   {
      filist[(*it).first] = (*it).second;

      ++it;
   }

   m_FollowIpMutex.Release();

}

void TStatIPObject::AddInStatCount(const TString &db, const TString &collection, NStorageStats::TStorageRequestStat::TStorageActionType acttype, int count, bool good, ui32 tick)
{
   in_statmon.AddCount(db, collection, acttype, count, NStorageStats::ToTSRSErrTypeB(good), tick);
   in_statweb.AddCount(db, collection, acttype, count, NStorageStats::ToTSRSErrTypeB(good), tick);
}

NStorageStats::TStorageStatVector TStatIPObject::GetInputRequestStat()
{
   in_statweb.ChangeLabelWeb(change_labels_list);

   return in_statweb.GetWebStat();
}

ui32 TStatIPObject::GetSendToRBL(bool &exists)
{
   ui32 res = 0;

   exists = false;
   if (configobj != NULL)
   {
      if (configobj->KeyExists("ban", "sendtorbl"))
      {
         exists = true;
         res = configobj->ReadInteger("ban", "sendtorbl", 0);
      }
   }

   return res;
}
