#pragma once

#include <util/generic/hash.h>
#include <util/generic/string.h>
#include <util/system/mutex.h>
#include <util/string/util.h>
#include "tlogsgroup.h"
#include <mail/so/spamstop/tools/so-common/tkconfig.h>
#include <mail/so/spamstop/tools/so-common/sobase64.h>
#include "tkstrlist.h"
#include <mail/so/spamstop/tools/so-common/ttrafficcontrol.h>
#include <mail/so/spamstop/tools/so-common/tstoragerequeststat.h>
#include "tdelaystrap.h"
#include <contrib/libs/zlib/zlib.h>
#include "tbasesstore.h"
#include "ipmess.h"
#include "tstatiptypes.h"
#include "trulestorage.h"
#include "truletrap.h"
#include "tperiodiptrap.h"
#include "ttrap.h"
#include "tperiodstat.h"
#include "trenginepool.h"

#ifdef MONGO_OLD
#include "tstorage_mongo_old.h"
#else  //MONGO_OLD
#include "tdatabasa_mongo_v3.h"
#endif //MONGO_OLD

#define STATTICK_FULL               NStorageStats::TStorageRequestStat::SAT_UPDATE
#define STATTICK_GETBANSTATE_CACHE  NStorageStats::TStorageRequestStat::SAT_FINDONE
#define STATTICK_GEGBANSTATE_STOR1  NStorageStats::TStorageRequestStat::SAT_ERASE
//#define STATTICK_GEGBANSTATE_STOR2  NStorageStats::TStorageRequestStat::SAT_RESERV1
#define STATTICK_CHECK_LISTS        NStorageStats::TStorageRequestStat::SAT_SIZE
#define STATTICK_IPV4MEM            NStorageStats::TStorageRequestStat::SAT_MULTYACTION
#define STATTICK_IPV6MEM            NStorageStats::TStorageRequestStat::SAT_FIND
#define STATTICK_GET_FILTER         NStorageStats::TStorageRequestStat::SAT_CLEAR
#define STATTICK_WORK_FILTER        NStorageStats::TStorageRequestStat::SAT_FINDANDMODIFY

struct TSummaryStatistik
{
   TTrafficCtrlStat     trafficctrl_stat;   //���������� ���������� ������� �� ����� (�������)
   TTrafficCtrlStat     tcstat_frodo;       //���������� ���������� ������� �� ����� (����� getforfrodo, getipstat, getforfrodo2)
   //TWriteDataDiskStat   wd_stat;            //���������� ������ ������� ������ (delivery �����) �� ����
   TRenginePoolStat     renginepool;        //���������� ���� ��������
   //TRengineRuleActionWeights  rengineweights;     //���� ������� � �.�. ������
   TBanStat             bstat;              //���������� ����
   TBanStat             bstat7;             //���������� ban7
};

struct TSummaryInfo
{
   TChPropSummaryInfo chpropsi;     //���������� ���������� �� ���������� ����������
   TString             protokol;     //��� ����� protokol.log
   TString             pbprotokol;   //��� ����� pbprotokol.log
   TString             reject;       //��� ����� reject.log
   TString             stat;         //��� ����� stat.log
   TString             ban3mail;     //��� ����� ban3mail.log
   TString             zones;        //��� ����� zones.log
   TString             daylogh;      //��� ����� daylogh.log
   TString             whiteip;      //��� ����� whiteip.log
   TString             tmpban30;     //��� ����� tmpban30.log
   TString             missingmess;  //��� ����� missingmess.log
   TString             traceip;      //��� ����� traceip.log
   TString             statip;       //��� ����� statip.log
   TString             saction;      //��� ����� action.log
   bool               Enable_protokol_log;   //true - ������ � protokol ���
   bool               Enable_pbprotokol_log; //true - ������ � protokol ���
   bool               Enable_reject_log;     //true - ������ � protokol ���
   bool               Enable_stat_log;       //true - ������ � stat ���
   bool               Enable_ban3mail_log;   //true - ������ � ban3mail ���
   bool               Enable_daylogh_log;    //true - ������ � daylogh ���
   bool               Enable_zones_log;      //true - ������ � zones ���
   bool               Enable_whiteip_log;    //true - ������ � whiteip ���
   bool               Enable_tmp_ban30_log;  //true - ������ � tmp_ban30 ���
   bool               Enable_missingmess_log;//true - ������ � missingmess ���
   bool               Enable_traceip_log;    //true - ������ � traceip ���
   bool               Enable_statip_log;     //true - ������ � statip ���
   bool               Enable_action_log;     //true - ������ � action ���

   TString             Nofflush_protokol_log;   //������ � protokol ��� ��� fflush
   TString             Nofflush_pbprotokol_log; //������ � protokol ��� ��� fflush
   TString             Nofflush_reject_log;     //������ � protokol ��� ��� fflush
   TString             Nofflush_stat_log;       //������ � stat ��� ��� fflush
   TString             Nofflush_ban3mail_log;   //������ � ban3mail ��� ��� fflush
   TString             Nofflush_daylogh_log;    //������ � daylogh ��� ��� fflush
   TString             Nofflush_zones_log;      //������ � zones ��� ��� fflush
   TString             Nofflush_whiteip_log;    //������ � whiteip ��� ��� fflush
   TString             Nofflush_tmp_ban30_log;  //������ � tmp_ban30 ��� ��� fflush
   TString             Nofflush_missingmess_log;//������ � missingmess ��� ��� fflush
   TString             Nofflush_traceip_log;    //������ � traceip ��� ��� fflush
   TString             Nofflush_statip_log;     //������ � statip ��� ��� fflush
   TString             Nofflush_action_log;     //������ � action ��� ��� fflush

   bool               EnableSaveMail;        //true - ������ ������ �� ����
   bool               yes_data;     //���� ������ ��������� - ������������� true

   TSummaryInfo()
   {
      memset(&chpropsi, 0, sizeof(chpropsi));
      protokol    = "";
      pbprotokol  = "";
      reject      = "";
      stat        = "";
      ban3mail    = "";
      zones       = "";
      daylogh     = "";
      whiteip     = "";
      tmpban30    = "";
      missingmess = "";
      traceip     = "";
      statip      = "";
      saction     = "";
      Enable_protokol_log    = false;
      Enable_pbprotokol_log  = false;
      Enable_reject_log      = false;
      Enable_stat_log        = false;
      Enable_ban3mail_log    = false;
      Enable_daylogh_log     = false;
      Enable_zones_log       = false;
      Enable_whiteip_log     = false;
      Enable_tmp_ban30_log   = false;
      Enable_missingmess_log = false;
      Enable_traceip_log     = false;
      Enable_statip_log      = false;
      Enable_action_log      = false;
      EnableSaveMail         = false;

      Nofflush_protokol_log    = "";
      Nofflush_pbprotokol_log  = "";
      Nofflush_reject_log      = "";
      Nofflush_stat_log        = "";
      Nofflush_ban3mail_log    = "";
      Nofflush_daylogh_log     = "";
      Nofflush_zones_log       = "";
      Nofflush_whiteip_log     = "";
      Nofflush_tmp_ban30_log   = "";
      Nofflush_missingmess_log = "";
      Nofflush_traceip_log     = "";
      Nofflush_statip_log      = "";
      Nofflush_action_log      = "";

      yes_data    = false;
   }
};

TString TFollowIpEventToStroka(TFollowIpEvent value);

class TStatIPObject
{
private:
         static const ui32 MAX_IN_BUFF_SIZE = 1000000;
private:
         TStorageNoSql     *m_Storage;
         TString            server_id;
         TLogsGroup        *LogsGroup;
         TKConfig          *configobj;
         TChangeProperties CPO;               //"�������" ������ ��������� ��������
         TTrafficControl   TrafficControl;    //������������ ������ � ��������
         TTrafficControl   ControlTraffOther; //������� ������ �� ������ �������� ������� IP (getipstatus, getforfrodo, getforfrod2)
         TBasesStore       ipbasa;            //������ � ������ ip (today, yesterday, history)
         TIPMess           ipmess;            //������� � ��������� �������� ����� delivery
         TRuleStorage      *m_RulesStorage;
         TRuleTrap         *m_RuleTrap;
         TPeriodTrap       *PeriodTrap;
         TTrap             *trap;
         TPeriodStat       *perstat;
         TRenginePool      *RenginePool;
         TWhiteIPLocalCache *whiteip_cache;
         TBanIPLocalCache   *banip_cache;
         TString            m_linktogetbyid;
         bool              m_enable_obrabmess;
         bool              m_enable_viewstatlogs;
         ui32              lastwritestatlog;
         ui32              lastwritemonlog;
         TParsedDlvLog     pdl;
   NStorageStats::TStorageRequestStatMain in_statmon;
   NStorageStats::TStorageRequestStatMain in_statweb;
         bool              m_hide_could_not_find_rule;

         TNetKIPv6         *m_fastban_list;
         TNetKIPv6         *m_fastreject_list;
         TNetKIPv6         *m_fastskeep_list;

         ui32              m_minstatcountperiod;
         ui32              m_minstatcount;

   NStorageStats::TStorageRequestStat::TChangeLabelStructList change_labels_list;

         bool              OldUnpackData(const char* instr, size_t len, bool& warning_size, TString& result, TString& errs);
         void              WriteStatToLog();
         void              WriteMonLog();

         TMutex              m_FollowIpMutex;
         THashMap<TKIPv6, ui32> m_FollowIpStor;

         TString             m_allrulesreset_last;
         TString             m_doreset;
         TString             m_dorellist;
public:
         TStatIPObject();
         ~TStatIPObject();

         bool              InitBeforeFork(const TString &server_idA, TLogsGroup *LogsGroupA, TKConfig *configobjA);
         bool              InitAfterFork();
         bool              WriteDump();
         bool              Midnight();
         void              Shutdown();
         void              EventTick();
         void              EventTickHeavy();
         bool              MidnightHeavy();
         TString            GetServerID(){ return server_id.c_str(); }


         TObrabResult      ObrabRequest(TKIPv6 ip, TString &mail, int lzo, bool &f_ok, const TString &id, const TString &remote_ip, ui32 &trap_remain, ui32 sendtorbl, const TStatDBCollInfo stat_info);
         TObrabResult      ObrabRequestSerializeData(TKIPv6 ip, TString &mail, bool &f_ok, const TString &id, const TString &remote_ip, ui32 &trap_remain, ui32 sendtorbl, const TStatDBCollInfo stat_info);
         TSummaryStatistik GetStatistic();
         TString            GetMonitoringData();
         TTrafficControl   *GetTrafficControl()    { return &TrafficControl;        }
         TTrafficControl   *GetControlTraffOther() { return &ControlTraffOther;     }
         TBasesStore       *GetBasesStore()        { return &ipbasa;                }
         TWhiteIPLocalCache *GetWhiteIPCache()     { return whiteip_cache;          }
         TBanIPLocalCache   *GetBanIPCache()       { return banip_cache;            }
         TRenginePool      *GetRenginePool()       { return RenginePool;            }
         TRuleTrap         *GetRuleTrap()          { return m_RuleTrap;             }
         TChangeProperties *GetCPO()               { return &CPO;                   }
         TTrap             *GetTrap()              { return trap;                   }
         TPeriodTrap       *GetPeriodTrap()        { return PeriodTrap;             }
         TString            GetLinktogetbyid()      { return m_linktogetbyid;        }
         bool              EnableObrabMess()       { return m_enable_obrabmess;     }
         bool              EnableViewStatLogs()    { return m_enable_viewstatlogs;  }
         TSummaryInfo      GetChangePropSummaryInfo();

         ui32              GetMinStatCountPeriod() { return m_minstatcountperiod;   }
         ui32              GetMinStatCount()       { return m_minstatcount;         }

         //mark ban ip in heavyip report
         bool              IsBanIpForMark( TKIPv6 ip );

         //GetIPStatus, GetForFrodo and GetForFrodo2
         void              IsBanIpExt(TKIPv6 ip, bool &ban, ui16 &ban_hours, ui8 &ban_pr, bool &ban7, ui16 &ban7_hours, ui8 &ban7_pr);
         void              CheckMemBasa(TKIPv6 ip, const TString &id);
         TIpStatOne        GetIpStat(TKIPv6 ip);

         //console
         ui32              GetHeavyMemCount();

         TNetKIPv6         *GetFollowList(){ return ipbasa.GetFollowList(); }

         bool              IsFastBanIP(TKIPv6 ip);
         bool              IsFastRejectIP(TKIPv6 ip);
         bool              IsFastSkeepIP(TKIPv6 ip);
         void              ReloadFastList();

         void              AddFollowIP(TKIPv6 ip);
         bool              IsFollowIP(TKIPv6 ip);
         bool              IsFollowIPExt(TKIPv6 ip);
         bool              DeleteFollowIP(TKIPv6 ip);
         void              PrintFollowIp(TKIPv6 ip, const TString &id, TFollowIpEvent fievent, const TString &dobdata);
         void              PrintFollowExt(TKIPv6 ip, const TString &id, TFollowIpEvent fievent, const TString &dobdata);
         void              ReturnFollowIpsList(THashMap<TKIPv6, ui32> &filist);

         TStorageNoSql     *GetStorage(){ return m_Storage; }

         void               AddInStatCount(const TString &db, const TString &collection, NStorageStats::TStorageRequestStat::TStorageActionType acttype, int count, bool good, ui32 tick);
   NStorageStats::TStorageStatVector GetInputRequestStat();

         void               SetAllrulesresetState(const TString &state){ m_allrulesreset_last = state; }
         TString             GetAllrulesresetState()                   { return m_allrulesreset_last;  }
         void               SetDoresetState(const TString &state)      { m_doreset = state;            }
         TString             GetDoresetState()                         { return m_doreset;             }
         void               SetDorellistState(const TString &state)    { m_dorellist = state;          }
         TString             GetDorellistState()                       { return m_dorellist;           }

         bool               HideCouldNotFindRule()                    { return m_hide_could_not_find_rule; }

         ui32               GetSendToRBL(bool &exists);
};



