#pragma once

#include "treport.h"
#include <mail/so/spamstop/tools/so-common/tkipv6.h>
#include <mail/so/spamstop/tools/so-common/kfunc.h>
#include <mail/so/spamstop/tools/so-common/tparsedlvlog_data.h>
#include <mail/so/spamstop/sp/sptypes.h>
#include <mail/so/spamstop/sp/spamrule.h>
#include <mail/so/spamstop/sp/spstat.h>
#include <contrib/libs/pcre/pcre.h>
#include <list>

#define PR_FLAGEND              "\nmess: _"
#define SP_BUFF_SIZE            36000

#define RELOAD_RBL_TIME         21600 //6 hour
#define RELOAD_RBL_DIFF_TIME    600   //10 min
#define RELOAD_OTHER_LISTS_TIME 600   //10 min (whitenet, shadyhosts, whiteip, blackip)
#define CHECK_BAN_LIST_TIME     600   //10 min

typedef enum  {enSpLevel1, enSpLevel2, enSpIp2} T_enum_ip_level;

enum TFollowIpEvent{FIE_00, FIE_01, FIE_02, FIE_03, FIE_04, FIE_05, FIE_06, FIE_07, FIE_08, FIE_09, FIE_10, FIE_11, FIE_12, FIE_13, FIE_14, FIE_15, FIE_16, FIE_17, FIE_18, FIE_19, FIE_20, FIE_21, FIE_22, FIE_23, FIE_24, FIE_25, FIE_26, FIE_27, FIE_28, FIE_29, FIE_30, FIE_31, FIE_32, FIE_33, FIE_34, FIE_35};

//******************************************************************************************************************************************
//                                                      TObrabResult
//******************************************************************************************************************************************

struct TDobBanResData
{
   ui32     cDaysRej;      //������� ���� ���������
   ui32     cDaysNoRej;    //������� ���� ��������� ��� ���������
   ui32     tSpam;         //today � ��� ����� � malicious
   ui32     tHam;          //today dlv or ham
   ui32     tMalicSpam;    //today malicious spam
   ui32     ySpam;         //yesterday � ��� ����� � malicious
   ui32     yHam;          //yesterday dlv or ham
   ui32     yMalicSpam;    //yesterday malicious spam
   ui32     hSpam;         //history � ��� ����� � malicious
   ui32     hHam;          //history dlv or ham
   ui32     hMalicSpam;    //history malicious spam
   bool     isforward;     //������� ������ ���������
   ui32     age;           //������� ������� � ����
   TString   rulesstat;     //���������� ������

   TDobBanResData()
   {
      Clear();
   }

   void Clear()
   {
      cDaysRej   = 0;
      cDaysNoRej = 0;
      tSpam      = 0;
      tHam       = 0;
      tMalicSpam = 0;
      ySpam      = 0;
      yHam       = 0;
      yMalicSpam = 0;
      hSpam      = 0;
      hHam       = 0;
      hMalicSpam = 0;
      isforward  = 0;
      age        = 0;
      rulesstat  = "";
   }

   TString GetDobData()
   {
      char buff[256];
      ui32 frwd = 0;

      if (isforward)
         frwd = 1;
      else
         frwd = 0;

      memset(buff, 0, sizeof(buff));
      snprintf(buff, sizeof(buff) - 1, "dr %u dnr %u ts %u th %u tm %u ys %u yh %u ym %u hs %u hh %u hm %u frwd %u age %u", cDaysRej, cDaysNoRej, tSpam, tHam, tMalicSpam, ySpam, yHam, yMalicSpam, hSpam, hHam, hMalicSpam, frwd, age);

      return TString(buff);
   }

   TString GetRulsStat()
   {
      return rulesstat;
   }
};

struct TObrabResult
{
   TKIPv6         ip;           //ip
   bool           ban;          //true - �������
   ui32           remainban;    //�������� ������ �� ����� ����
   bool           ban2;         //������� ������
   bool           ban7;
   ui32           remainban7;
   bool           ban8;
   ui32           remainban8;

   bool           save;
   TDobBanResData dobdata;

   TObrabResult()
   {
      Clear();
   }

   void Clear()
   {
      ip                   = TKIPv6();
      ban                  = false;
      remainban            = 0;
      ban2                 = false;
      ban7                 = false;
      remainban7           = 0;
      ban8                 = false;
      remainban8           = 0;
      save                 = false;
      dobdata.Clear();
   }
};

typedef TObrabResult TBanRes;

//****************************************************************************************************************************************************
//                                                             TTimes
//****************************************************************************************************************************************************

struct TTimes
{
   //�������� �������:
   //0 - ����� ������ �������
   //1 - ����� �������� �� ���� �������
   //2 - ����� ���������� �-�� TestBanCriterion
   //3 - ���������� ���������� � ������ m_ipbase->MemBasa.mAddStat(
   //4 - ����� ������ ������� �� ������ �������
   //5 - �������� �� ��������� � "�����" ������
   //6 - ��������� ����� ��������� ������
   //7 - ������ �����
   //8 - ����� ��������� ������

   static const ui32 ELEMENTCOUNT = 20;

   ui32 timesn[ELEMENTCOUNT];
   TTimes()
   {
      memset(timesn, 0, sizeof(timesn));
   };
};

//****************************************************************************************************************************************************
//                                                              TObrabData
//****************************************************************************************************************************************************

const TPcreUnit ipmessre [] = {
    { "uid",         "/^[^\\-]+-\\s+([^$]+)/",                         true },
    { "source_ip",   "/source ip = ([\\d\\.]+)/",                      true },
    { "next_ip",     "/next ip = ([\\d\\.]+)/",                        true },
    { "rdns",        "/rdns = (\\S*)\\s+helo =\\s*(\\S*)\\s*$/",       true },
    { "rdns2",       "/(?:^|.+\\.)([^.]+\\.[^.]+)$/",                  true },
    { "rdns3",       "/(?:^|.+\\.)([^.]+\\.[^.]+\\.[^.]+)$/",          true },
    { "rdns_ip",     "/^\\[[\\d\\.]+\\]$/",                            true },
    { "combinedbl",  "/COMBINEDBL_(?:2|4|5|6) /",                      true },
    { "whitenet1",   "/^([\\d.]+)[\\/\\\\]([\\d]+)$/",                 true },
    { "whitenet2",   "/^([\\d.]+)[-\\s]+([\\d.])$/",                   true },
    { "net_org",     "/\\.(?:net|org)$/",                              true },
    { "ip_dsl",      "/\\d+[.-]\\d+[.-]\\d+[.-]\\d+/",                 true },
    { "sh_phone",    "/^CS phone = (\\S+)\\s+count = \\d+\\s+(\\S+)/", true },
    { "sh_host",     "/^CS host = (\\S+)\\s+count = \\d+\\s+(\\S+)/",  true },
    { "sh_mail",     "/^CS mail = (\\S+)\\s+count = \\d+\\s+(\\S+)/",  true },
    { "sh_subj",     "/^shtype= 8,.*sh = (\\S+)/",                     true },
    { "sh_shn",      "/^shtype= 1,.*sh = (\\S+)/",                     true },
    { "sh_cshn",     "/^shtype= 2,.*sh = (\\S+)/",                     true },
    { "sh_fcrc",     "/^shtype= 11,.*sh = (\\S+)/",                    true },
    { "sh_html",     "/^shtype= 3,.*sh = (\\S+)/",                     true },
    { "sh_icq",      "/^icq - (\\S+)/",                                true },
    { "dsl1", "/\\d+\\.\\d+\\.\\d+\\.\\d+[-.]/",                                                                       true},
    { "dsl2", "/\\d+[^.0-9]{1,3}\\d+[^.0-9]{1,3}\\d+/",                                                                true},
    { "dsl3", "/(?:catv|docsis|cable|dynamic-?\\d|\\.dynamic\\.|dhcp|dial[^so]|dsl|isdn|ppp|pool-|catv-|kbl-|modem)/", true},
    { "dsl4", "/(?:a?dl|lns|du)-?\\d+[-.]/",                                                                           true},
    { "dsl5", "/h(?:ost)?\\d+-?\\d*\\.?p(?:ool)?\\d+\\./",                                                             true},
    { "dsl6", "/[^b]\\d{5}/",                                                                                          true},
    { "dsl7", "/[-_a-z0-9.]*[0-9]{2}[-_a-z0-9.]*[0-9]{2}[-_a-z0-9.]*\\.[-_a-z0-9.]*\\.[a-z]{2}/",                      true}
};

struct TGrayListStatus
{
   static const ui32 GREYLIST_COUNT = 5;

   bool addr[GREYLIST_COUNT];
   bool net[GREYLIST_COUNT];
   bool host[GREYLIST_COUNT];

   TGrayListStatus()
   {
      Clear();
   }

   void Clear()
   {
      for (ui32 i = 0; i < GREYLIST_COUNT; i++)
      {
         addr[i] = false;
         net[i]  = false;
         host[i] = false;
      }
   }
};

struct TStatDBCollInfo
{
   TString m_db;
   TString m_coll;

   TStatDBCollInfo()
   {
      Clear();
   }

   TStatDBCollInfo(const TString &db, const TString coll)
   {
      m_db   = db;
      m_coll = coll;
   }

   void Clear()
   {
      m_db   = "";
      m_coll = "";
   }
};

struct TObrabData
{
   TParsedDlvLogData pdld;
   TString            pdld_totext;

   bool              use_hide_could_not_find_rule;

   TStatDBCollInfo   stat_ident;

   //TKIPv6            ip;
   ui32              cMess;
   ui32              csec;
   //TIpInfoList       nextip;

   TString            m_mailnumber;
   //TSpClass          m_messclass;
   //double            m_sp_wght;
   //double            m_dlv_wght;
   //bool              m_fDSN;
   //ui16              m_Uwl;
   //bool              m_fDsl_first;
   //bool              m_fDsl_first67891014;
   //bool              m_fDsl_first8;
   //bool              m_fSHM;
   //bool              m_fBW;
   //bool              m_f100mails;
   //bool              m_fmails_criterion;
   //bool              m_fCOMBL;
   //bool              m_f20;
   //bool              m_f21;
   //bool              m_f22;
   //bool              m_f__HELO_LOCALHOST;
   //bool              m_fNoresolv_first;
   //bool              m_fFixedByRule;
   //bool              m_fFixedSource;
   //bool              m_fSource_level_1;
   //bool              m_fSource_level_2;
   //bool              m_fRBL;
   //bool              m_fPop3;
   //bool              m_fSMTP;
   bool              m_fNetOrg;
   bool              m_fIpDsl;
   //bool              m_fDlvrRules;
   //bool              m_fOurUser;
   //bool              m_fBounce;
   //bool              m_fSpf;
   //bool              m_fRBL4;
   bool              m_fRBL_hash;
   //bool              m_malicspam;
   int               m_bad_type;
   int               m_bad_type1;
   int               m_bad_type2;
   int               m_bad_type3;
   int               m_bad_type4;
   int               m_bad_type5;
   //ui64              m_uid;
   ui16              m_repeater;
   //TSpMetaShingles   m_metash;
   //TSpMCount         m_mcount;
   TString            m_smessage;
   //TString            m_rdns;
   //TString            m_helo;
   //TString            m_rdns2;
   //TString            m_rdns3;
   //const char        *m_pmesstype;
   char              m_zn[10];
   time_t            m_curr_time;
   //TString            m_MessId;
   int               m_Forwards;
   //int               m_mcrit_spam;
   //int               m_mcrit_crit;
   //int               m_mcrit_hour;
   ui16              m_criterion_n;
   ui64              m_cmess_ban;
   ui16              m_probbancriterion;
   //bool              m_frwd_pr1;
   //bool              m_frwd_pr2;
   //TString            m_geo;

   TReport           m_rep;
   char              m_buff[65500];

   ;            //pcre object

   //TMailBox          mbox;
   //TWorkRuleList     rsp_list;
   //TWorkRuleList     rdl_list;
   //TWorkRuleList     rnl_list;
   //TWorkRuleListExt  rst_list;
   //TBoolArrayK       parray;
   TString            messageid;
   //TString            messfull;
   bool              m_ban2;
   bool              m_ban7;
   bool              m_ban8;
   bool              m_baninternal;
   bool              m_undoban;
   bool              m_undobanmess;
   float             m_cps;
   bool              m_inc_malicspam_count; //true - ������� malicspam_count (���-�� ����� � ��������� malic_spam) ���������
   bool              m_need_print_ban3log;  //true - ����� ������� ��� � ����
   //bool              mSH_17_2;
   TGrayListStatus   m_graylists_status;
   bool              m_dslfirst;
   float             m_dslfirst_rps;

   TObrabData()
   {
      Init();
   };

   void Init()
   {
      pdld = {};
      pdld_totext = "";

      use_hide_could_not_find_rule = false;

      stat_ident.Clear();

      //ip                     = TKIPv6();
      cMess                  = 0;
      csec                   = 0;
      //nextip.clear();

      m_mailnumber           = "";
      //m_uid                  = 0;
      //m_MessId               = "";
      //m_messclass            = spUnknown;
      //m_sp_wght              = 0.0;
      //m_dlv_wght             = 0.0;
//      m_fDSN                 = false;
//      m_Uwl                  = 0;
//      m_fDsl_first           = false;
//      m_fDsl_first8          = false;
//      m_fDsl_first67891014   = false;
//      m_fSHM                 = false;
//      m_fBW                  = false;
//      m_f100mails            = false;
//      m_fmails_criterion     = false;
//      m_f20                  = false;
//      m_f21                  = false;
//      m_f22                  = false;
//      m_f__HELO_LOCALHOST    = false;
//      m_fCOMBL               = false;
//      m_fNoresolv_first      = false;
//      m_fFixedByRule         = false;
//      m_fFixedSource         = false;
//      m_fSource_level_1      = false;
//      m_fSource_level_2      = false;
//      m_fRBL                 = false;
//      m_fPop3                = false;
//      m_fSMTP                = false;
      m_fNetOrg              = false;
      m_fIpDsl               = false;
//      m_fDlvrRules           = false;
//      m_fOurUser             = false;
//      m_fBounce              = false;
//      m_fSpf                 = false;
//      m_fRBL4                = false;
      m_fRBL_hash            = false;
//      m_malicspam            = false;
      m_bad_type             = 0;
      m_bad_type1            = 0;
      m_bad_type2            = 0;
      m_bad_type3            = 0;
      m_bad_type4            = 0;
      m_bad_type5            = 0;
      //m_level                = 0;
//      m_metash               = enMETA_SHINGLES_1;
//      m_mcount               = enMCOUNT_0;
      m_smessage.assign("-");
      //m_rdns.assign("-");
      //m_rdns2.assign("-");
      //m_rdns3.assign("-");
      //m_helo.assign("-");
      //m_pmesstype            = "unknown";
      m_zn[0]                = 0;
      m_repeater             = 0;
      m_criterion_n          = 0;
      m_probbancriterion     = 0;
      //m_frwd_pr1             = false;
      //m_frwd_pr2             = true;
      //m_geo                  = "";

      //mbox.Clear();
      pdld = {};

      //memset(parray.PANNERN_STAT, 0, sizeof(parray.PANNERN_STAT));

      messageid      = "";
      //messfull       = "";
      m_ban2         = false;
      m_ban7         = false;
      m_ban8         = false;
      m_baninternal  = false;
      m_undoban      = false;
      m_undobanmess  = false;
      m_cps          = 0;
      m_inc_malicspam_count = false;
      m_need_print_ban3log  = false;
//      mSH_17_2       = false;
      m_graylists_status.Clear();
      m_dslfirst     = false;
      m_dslfirst_rps = 0;
   };
};

//******************************************************************************************************************************************
//                                                      TErrorWrite
//******************************************************************************************************************************************

enum TErrorWriteObject {KBANLIST, KBASA};
struct TErrorWrite
{
 ui32              error_write_txt;
 ui32              error_write_idx;
 time_t            last_calc_error_info;
 time_t            last_write_moment;
 bool              now;

 TErrorWrite()
 {
   Clear();
 }

 void Clear()
 {
   error_write_txt      = 0;
   error_write_idx      = 0;
   last_calc_error_info = 0;
   last_write_moment    = 0;
   now                  = false;
 }

 TString GetMessage(TErrorWriteObject type)
 {
   TString res = "";

   switch (type)
   {
    case KBANLIST:
                  res = "BANIPLIST: For last " + IntToStroka(last_calc_error_info) + " sec were " + IntToStroka(error_write_txt) + " error write to baniptxt file and " + IntToStroka(error_write_idx) + " error write to banipidx file.";
                  break;
    case KBASA:
                  res = "DDB: For last " + IntToStroka(last_calc_error_info) + " sec were " + IntToStroka(error_write_txt) + " error write databasa file and " + IntToStroka(error_write_idx) + " error write to indexbasa file.";
                  break;
   };

   return res;
 }
};

//******************************************************************************************************************************************
//                                                      TBanIp
//******************************************************************************************************************************************

typedef struct _TBanIp
{
    TKIPv6     ip;             //ip
    time_t     tAction;        //����� ����
    ui16       chours;         //���-�� �����, �� ������� ���������� ���
    ui32       cMessage;       //���-�� �����, ���������� ����� ����, ��� �� �������� ����� (������������� ��� �������� �� ��� ������)
  ui8        cIntBanIp;      //������� ����:
                               //���������� 0x01 - �� �������� ip � ���� banip.txt (����� ������ ������ ����, �������� �� ������)
                               //���������� 0x02 - ������� �������
                               //���������� 0x04 - ��������� � ���������
                               //���������� 0x08 - ������� ����� �������
    ui32       cs;             //crc

    ui32 GetCRC32(ui32 cs)
    {
      ui8  buff[128];
      int  n = 0;
      ui32 i = 0, j = 0;

      memset(buff, 0, sizeof(buff));
      memcpy(buff + n, &ip, sizeof(ip));
      n += sizeof(ip);
      memcpy(buff + n, &tAction, sizeof(tAction));
      n += sizeof(tAction);
      memcpy(buff + n, &chours, sizeof(chours));
      n += sizeof(chours);
      memcpy(buff + n, &cMessage, sizeof(cMessage));
      n += sizeof(cMessage);
      memcpy(buff + n, &cIntBanIp, sizeof(cIntBanIp));
      n += sizeof(cIntBanIp);
      for (i = 0, j = 0; i < static_cast<ui32>(n); i++, j++)
      {
        if (j == 4)
            j = 0;

        if (!j)
            cs += (buff[i] & 0xFF);
        else
            cs += (((buff[i] << (8 * j))) & 0xFF);
      }

      return cs;
    }

    void Clear()
    {
       ip        = TKIPv6();
       tAction   = 0;
       chours    = 0;
       cMessage  = 0;
     cIntBanIp = 0;
       cs        = 0;
    }

} TBanIp;

//****************************************************************************************************************************************************

#define EXPORT_BAN                     0x00000001           // was ban
#define EXPORT_BAN_WOW                 0x00000002           // was ban manual
#define EXPORT_WHITE                   0x00000004           // white list
#define EXPORT_RBL4                    0x00000008           // rbl4
#define IS_EXPORT_BAN(flag)            ((flag) & EXPORT_BAN)
#define IS_EXPORT_BAN_WOW(flag)        ((flag) & EXPORT_BAN_WOW)
#define IS_EXPORT_WHITE(flag)          ((flag) & EXPORT_WHITE)
#define IS_EXPORT_RBL4(flag)           ((flag) & EXPORT_RBL4)
#define SET_EXPORT_BAN(flag)           { (flag) |= EXPORT_BAN;     }
#define SET_EXPORT_BAN_WOW(flag)       { (flag) |= EXPORT_BAN_WOW; }
#define SET_EXPORT_WHITE(flag)         { (flag) |= EXPORT_WHITE;   }
#define SET_EXPORT_RBL4(flag)          { (flag) |= EXPORT_RBL4;    }

//****************************************************************************************************************************************************


