#include "tstorage_mongo_old.h"

//*******************************************************************************************************************************
//                                              TStorageMongoOld
//*******************************************************************************************************************************

TStorageMongoOld::TStorageMongoOld()
{


}

TStorageMongoOld::~TStorageMongoOld()
{


}

TStorageMongoOld::LoggerHandler::LoggerHandler()
   : LogsGroup( NULL )
{
}

void TStorageMongoOld::LoggerHandler::Init( TLogsGroup* LogsGroupA )
{
   LogsGroup = LogsGroupA;
}

void TStorageMongoOld::LoggerHandler::Error( const TString& msg )
{
   if( !LogsGroup || !LogsGroup->GetServerLog() )
      return;

   LogsGroup->GetServerLog()->WriteMessageAndDataStatus( KERROR, "Mongo error: %s", msg.c_str() );
}

void TStorageMongoOld::LoggerHandler::Info( const TString& msg )
{
   if( !LogsGroup || !LogsGroup->GetServerLog() )
      return;

   LogsGroup->GetServerLog()->WriteMessageAndDataStatus( KINFO, "Mongo info: %s", msg.c_str() );
}

bool TStorageMongoOld::InitBeforeFork(const TString &server_hostname, const TString &server_code, const TString &server_start_time, const TString &server_version, TLogsGroup *LogsGroupA, TKConfig *configobjA)
{
   bool res = InitBeforeFork_base(-1, server_hostname, server_code, server_start_time, server_version, LogsGroupA, configobjA);

   TString mongo_hosts = configobjA->ReadStroka( "mongo", "hosts", "127.0.0.1" );
   TString rs = configobjA->ReadStroka( "mongo", "rs", "" );
   int pool_size = configobjA->ReadInteger( "mongo", "client_poolsize", 64 );
   int reconnect_timeout_ms = configobjA->ReadInteger( "mongo", "connect_try_time", 1000 );
   int socket_timeout_ms = configobjA->ReadInteger( "mongo", "socket_timeout", 2000 );

   m_loghandler.Init( LogsGroupA );
   //nosql::MongoCachedClient::Instance().Init( pool_size, mongo_hosts, rs, socket_timeout_ms, reconnect_timeout_ms, &m_loghandler );

   return res;
}

void TStorageMongoOld::InitAfterFork()
{
   InitAfterFork_base();

}

bool TStorageMongoOld::Midnight()
{
   bool res = Midnight_base();

   //nosql::MongoCachedClient::Instance().GetRawClient().Midnight();

   return res;
}

void TStorageMongoOld::EventTick()
{
   EventTick_base();

}

TFindToFileReport TStorageMongoOld::FTFRMCtoFTFR(TFindToFileReportMC &value)
{
   TFindToFileReport res;

   res.fulldump_record_count = value.fulldump_record_count;
   res.use_need              = value.use_need;
   res.need_record_count     = value.need_record_count;
   res.use_top               = value.use_top;
   res.top_record_count      = value.top_record_count;
   res.top_treshold          = value.top_treshold;
   memcpy(res.count_by_type, value.count_by_type, sizeof(res.count_by_type));
   res.empty_data            = value.empty_data;

   return res;
}

bool TStorageMongoOld::FindOne( TString db, TString collection, TString id, nosql::HashMap& hash, bool& err )
{
   return true; //nosql::MongoCachedClient::Instance().GetRawClient().FindOne( db, collection, id, hash, err );
}

bool TStorageMongoOld::Update( TString db, TString collection, TString id, const nosql::HashMap& incrs, const nosql::HashMap& sets, bool& err)
{
   return true; //nosql::MongoCachedClient::Instance().GetRawClient().Update(db, collection, id, incrs, sets, err, MONGO_UPDATE_UPSERT);
}

bool TStorageMongoOld::FindAndModify( TString db, TString collection, TString id, const nosql::HashMap& incrs, const nosql::HashMap& sets, nosql::HashMap& hash, bool getnew, bool& err )
{
   return true; //nosql::MongoCachedClient::Instance().GetRawClient().FindAndModify(db, collection, id, incrs, sets, hash, getnew, err );
}

i64 TStorageMongoOld::Size( TString db, TString collection, bool& err)
{
   return 0; //static_cast<i64>(nosql::MongoCachedClient::Instance().GetRawClient().SizeM(db, collection, err));
}

bool TStorageMongoOld::Find( TString db, TString collection, TVector< nosql::HashMap >& hashes, bool& err )
{
   return true; //nosql::MongoCachedClient::Instance().GetRawClient().FindM(db, collection, hashes, err );
}

bool TStorageMongoOld::Erase( TString db, TString collection, TString id, bool& err )
{
   return true; //nosql::MongoCachedClient::Instance().GetRawClient().Erase( db, collection, id, err );
}

bool TStorageMongoOld::SPSTSaveDump( const TString &filename, TString db, TString collection, bool& err, TFindToFileReport &report, i64 top_treshold )
{
   bool                res       = false;
   TFindToFileReportMC report_mc;

   res = true; //nosql::MongoCachedClient::Instance().GetRawClient().SPSTSaveDumpM(filename, db, collection, err, report_mc, top_treshold );
   report = FTFRMCtoFTFR(report_mc);

   return res;
}

bool TStorageMongoOld::SPSTSaveTop( const TString &filename, TString db, TString collection, bool& err, TFindToFileReport &report, i64 top_treshold )
{
   bool                res       = false;
   TFindToFileReportMC report_mc;

   res = true; //nosql::MongoCachedClient::Instance().GetRawClient().SPSTSaveTopM(filename, db, collection, err, report_mc, top_treshold);
   report = FTFRMCtoFTFR(report_mc);

   return res;
}

bool TStorageMongoOld::SPSTSaveDumpWithSortByID( const TString &filename, TString db, TString collection, bool& err, TFindToFileReport &report )
{
   bool                res       = false;
   TFindToFileReportMC report_mc;

   res = true; //nosql::MongoCachedClient::Instance().GetRawClient().SPSTSaveDumpWithSortByIDM(filename, db, collection, err, report_mc );
   report = FTFRMCtoFTFR(report_mc);

   return res;
}

bool TStorageMongoOld::SPSTSaveDumpStep1( const TString &filename, TString db, TString collection, bool& err, TFindToFileReport &report )
{
   bool                res       = false;
   TFindToFileReportMC report_mc;

   res = true; //nosql::MongoCachedClient::Instance().GetRawClient().SPSTSaveDumpStep1(filename, db, collection, err, report_mc);
   report = FTFRMCtoFTFR(report_mc);

   return res;
}

bool TStorageMongoOld::SPSTSaveDumpOnlyBanList( const TString &filename, TString db, TString collection, bool& err, TFindToFileReport &report )
{
   bool                res       = false;
   TFindToFileReportMC report_mc;

   res = true; //nosql::MongoCachedClient::Instance().GetRawClient().SPSTSaveDumpOnlyBanList(filename, db, collection, err, report_mc);
   report = FTFRMCtoFTFR(report_mc);

   return res;
}

NStorageStats::TStorageStatVector TStorageMongoOld::GetWebStatA()
{
   return NStorageStats::TStorageStatVector(); //nosql::MongoCachedClient::Instance().GetRawClient().GetWebStat();
}

NStorageStats::TStorageStatVector TStorageMongoOld::GetMonStatA()
{
   return NStorageStats::TStorageStatVector(); //nosql::MongoCachedClient::Instance().GetRawClient().GetMonStat();
}

//*******************************************************************************************************************************
