#pragma once

#include <util/generic/string.h>
#include <mail/so/spamstop/tools/so-common/anyvalue.h>
#include "tstoragenosql.h"
#include <mail/so/spamstop/tools/so-common/tkipv6.h>
#include <mail/so/spamstop/tools/so-common/eventhandler.h>
#include <mail/so/spamstop/tools/so-common/tstoragerequeststat.h>
#include "tspamstat_stor_stat.h"

enum mongo_update_opts {
 MONGO_UPDATE_UPSERT = 0x1,
 MONGO_UPDATE_MULTI = 0x2,
 MONGO_UPDATE_BASIC = 0x4
};

//*******************************************************************************************************************************
//                                              TStorageMongoOld
//*******************************************************************************************************************************

class TStorageMongoOld: public TStorageNoSql
{
private:
         class LoggerHandler : public nosql::EventHandler
         {
             TLogsGroup* LogsGroup;

         public:
             LoggerHandler();
             void Init( TLogsGroup* LogsGroupA );
             void Error( const TString& msg );
             void Info( const TString& msg );
         };

         LoggerHandler        m_loghandler;

         TFindToFileReport FTFRMCtoFTFR(TFindToFileReportMC &value);

public:
         TStorageMongoOld();
         ~TStorageMongoOld();

         bool        InitBeforeFork(const TString &server_hostname, const TString &server_code, const TString &server_start_time, const TString &server_version, TLogsGroup *LogsGroupA, TKConfig *configobjA);
         void        InitAfterFork();
         bool        Midnight();
         void        EventTick();

         bool        FindOne( TString db, TString collection, TString id, nosql::HashMap& hash, bool& err );
         bool        Update( TString db, TString collection, TString id, const nosql::HashMap& incrs, const nosql::HashMap& sets, bool& err);
         bool        FindAndModify( TString db, TString collection, TString id, const nosql::HashMap& incrs, const nosql::HashMap& sets, nosql::HashMap& hash, bool getnew, bool& err );
         i64         Size( TString db, TString collection, bool& err);
         bool        Find( TString db, TString collection, TVector< nosql::HashMap >& hashes, bool& err );
         bool        Erase( TString db, TString collection, TString id, bool& err );

         bool        SPSTSaveDump( const TString &filename, TString db, TString collection, bool& err, TFindToFileReport &report, i64 top_treshold );
         bool        SPSTSaveTop( const TString &filename, TString db, TString collection, bool& err, TFindToFileReport &report, i64 top_treshold );
         bool        SPSTSaveDumpWithSortByID( const TString &filename, TString db, TString collection, bool& err, TFindToFileReport &report );
         bool        SPSTSaveDumpStep1( const TString &filename, TString db, TString collection, bool& err, TFindToFileReport &report );
         bool        SPSTSaveDumpOnlyBanList( const TString &filename, TString db, TString collection, bool& err, TFindToFileReport &report );

   NStorageStats::TStorageStatVector  GetWebStatA();
   NStorageStats::TStorageStatVector  GetMonStatA();
};

//*******************************************************************************************************************************

