#include "tstorageclientstat.h"

//***********************************************************************************************************************
//                                              TStorageClientStat
//***********************************************************************************************************************

TStorageClientStat::TStorageClientStat() {
}

TStorageClientStat::~TStorageClientStat() {
}

void TStorageClientStat::AddCount(TStorageActionType acttype, int count, bool good, ui32 tick) {
    data.AddCount(acttype, count, good, tick);
}

void TStorageClientStat::Midnight() {
    data.Midnight();
}

TString TStorageClientStat::PrintDataWEB(bool print_percent, bool disable_errors, bool disable_summary) {
    TString text = "";
    char* table_color = "'#ffffcc'";
    char* shap_cell_color = "'#ffffaa'";
    char* yesterday_color = "'#F8FCBF'";

    TOperCountStatItemPart today_summary = data.today.GetAll();
    TOperCountStatItemPart yesterday_summary = data.yesterday.GetAll();

    text = text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=" + TString(table_color) + ">\n";
    if (!disable_errors) {
        text = text + "<tr bgcolor=" + TString(shap_cell_color) + " align='center'><td width='30%' align='left' colspan='2'><b>ERRORS</b></td><td colspan='4' width='35%'><b>TODAY</b></td><td colspan='4' width='35%'><b>YESTERDAY</b></td><tr>";
        text = text + "<tr bgcolor=" + TString(shap_cell_color) + " align='center'><td width='30%' align='left' colspan='2'>&nbsp;</td><td colspan='2' width='17%'><b>GOOD</b></td><td colspan='2' width='18%'><b>BAD</b></td><td colspan='2' width='17%'><b>GOOD</b></td><td colspan='2' width='18%'><b>BAD</b></td><tr>";
        text = text + "<tr align='right'><td width='30%' align='left' colspan='2'>" + m_weblabels.GetParamNameWeb(SAT_UPDATE) + "</td><td colspan='2' width='17%'>" + UI64ToStroka(data.today.update_count.good) + "</td><td colspan='2' width='18%'>" + UI64ToStroka(data.today.update_count.bad) + "</td><td colspan='2' width='17%'>" + UI64ToStroka(data.yesterday.update_count.good) + "</td><td colspan='2' width='18%'>" + UI64ToStroka(data.yesterday.update_count.bad) + "</td><tr>";
        text = text + "<tr align='right'><td width='30%' align='left' colspan='2'>" + m_weblabels.GetParamNameWeb(SAT_FINDONE) + "</td><td colspan='2' width='17%'>" + UI64ToStroka(data.today.findone_count.good) + "</td><td colspan='2' width='18%'>" + UI64ToStroka(data.today.findone_count.bad) + "</td><td colspan='2' width='17%'>" + UI64ToStroka(data.yesterday.findone_count.good) + "</td><td colspan='2' width='18%'>" + UI64ToStroka(data.yesterday.findone_count.bad) + "</td><tr>";
        text = text + "<tr align='right'><td width='30%' align='left' colspan='2'>" + m_weblabels.GetParamNameWeb(SAT_FIND) + "</td><td colspan='2' width='17%'>" + UI64ToStroka(data.today.find_count.good) + "</td><td colspan='2' width='18%'>" + UI64ToStroka(data.today.find_count.bad) + "</td><td colspan='2' width='17%'>" + UI64ToStroka(data.yesterday.find_count.good) + "</td><td colspan='2' width='18%'>" + UI64ToStroka(data.yesterday.find_count.bad) + "</td><tr>";
        text = text + "<tr align='right'><td width='30%' align='left' colspan='2'>" + m_weblabels.GetParamNameWeb(SAT_ERASE) + "</td><td colspan='2' width='17%'>" + UI64ToStroka(data.today.erase_count.good) + "</td><td colspan='2' width='18%'>" + UI64ToStroka(data.today.erase_count.bad) + "</td><td colspan='2' width='17%'>" + UI64ToStroka(data.yesterday.erase_count.good) + "</td><td colspan='2' width='18%'>" + UI64ToStroka(data.yesterday.erase_count.bad) + "</td><tr>";
        text = text + "<tr align='right'><td width='30%' align='left' colspan='2'>" + m_weblabels.GetParamNameWeb(SAT_SIZE) + "</td><td colspan='2' width='17%'>" + UI64ToStroka(data.today.size_count.good) + "</td><td colspan='2' width='18%'>" + UI64ToStroka(data.today.size_count.bad) + "</td><td colspan='2' width='17%'>" + UI64ToStroka(data.yesterday.size_count.good) + "</td><td colspan='2' width='18%'>" + UI64ToStroka(data.yesterday.size_count.bad) + "</td><tr>";
        text = text + "<tr align='right'><td width='30%' align='left' colspan='2'>" + m_weblabels.GetParamNameWeb(SAT_MULTYACTION) + "</td><td colspan='2' width='17%'>" + UI64ToStroka(data.today.multiaction_count.good) + "</td><td colspan='2' width='18%'>" + UI64ToStroka(data.today.multiaction_count.bad) + "</td><td colspan='2' width='17%'>" + UI64ToStroka(data.yesterday.multiaction_count.good) + "</td><td colspan='2' width='18%'>" + UI64ToStroka(data.yesterday.multiaction_count.bad) + "</td><tr>";
        text = text + "<tr align='right'><td width='30%' align='left' colspan='2'>" + m_weblabels.GetParamNameWeb(SAT_CLEAR) + "</td><td colspan='2' width='17%'>" + UI64ToStroka(data.today.clear_count.good) + "</td><td colspan='2' width='18%'>" + UI64ToStroka(data.today.clear_count.bad) + "</td><td colspan='2' width='17%'>" + UI64ToStroka(data.yesterday.clear_count.good) + "</td><td colspan='2' width='18%'>" + UI64ToStroka(data.yesterday.clear_count.bad) + "</td><tr>";
        text = text + "<tr align='right'><td width='30%' align='left' colspan='2'>" + m_weblabels.GetParamNameWeb(SAT_FINDANDMODIFY) + "</td><td colspan='2' width='17%'>" + UI64ToStroka(data.today.findandmodify_count.good) + "</td><td colspan='2' width='18%'>" + UI64ToStroka(data.today.findandmodify_count.bad) + "</td><td colspan='2' width='17%'>" + UI64ToStroka(data.yesterday.findandmodify_count.good) + "</td><td colspan='2' width='18%'>" + UI64ToStroka(data.yesterday.findandmodify_count.bad) + "</td><tr>";
        text = text + "<tr align='right'><td width='30%' align='left' colspan='2'>" + m_weblabels.GetParamNameWeb(SAT_RESERV1) + "</td><td colspan='2' width='17%'>" + UI64ToStroka(data.today.reserv1_count.good) + "</td><td colspan='2' width='18%'>" + UI64ToStroka(data.today.reserv1_count.bad) + "</td><td colspan='2' width='17%'>" + UI64ToStroka(data.yesterday.reserv1_count.good) + "</td><td colspan='2' width='18%'>" + UI64ToStroka(data.yesterday.reserv1_count.bad) + "</td><tr>";

        if (!disable_summary)
            text = text + "<tr align='right'><td width='30%' align='left' colspan='2'>SUMMARY (all type request)</td><td colspan='2' width='17%'>" + UI64ToStroka(today_summary.good) + "</td><td colspan='2' width='18%'>" + UI64ToStroka(today_summary.bad) + "</td><td colspan='2' width='17%'>" + UI64ToStroka(yesterday_summary.good) + "</td><td colspan='2' width='18%'>" + UI64ToStroka(yesterday_summary.bad) + "</td><tr>";
    }
    //text = text + "<tr valign='top' bgcolor='" + TString(cell_color) + "'><td valign='left' width='100%' colspan='9'>&nbsp;</td></tr>\n";
    text = text + "<tr bgcolor=" + TString(shap_cell_color) + " align='center'><td width='30%' align='left' colspan='2'><b>DELAYS (ms)</b></td><td><b>0-10</b></td><td><b>10-20</b></td><td><b>20-50</b></td><td><b>50-100</b></td><td><b>100-150</b></td><td><b>150-190</b></td><td><b>190-500</b></td><td><b>more500</b></td></tr>";
    text = text + "<tr align='right'><td width='25%' align='left' rowspan='2'>" + m_weblabels.GetParamNameWeb(SAT_UPDATE) + "</td><td align='center' width='5%'>today</td><td>" + data.today.update_count.m_0_10_s(print_percent) + "</td><td>" + data.today.update_count.m_10_20_s(print_percent) + "</td><td>" + data.today.update_count.m_20_50_s(print_percent) + "</td><td>" + data.today.update_count.m_50_100_s(print_percent) + "</td><td>" + data.today.update_count.m_100_150_s(print_percent) + "</td><td>" + data.today.update_count.m_150_190_s(print_percent) + "</td><td>" + data.today.update_count.m_190_500_s(print_percent) + "</td><td>" + data.today.update_count.m_more500_s(print_percent) + "</td></tr>";
    text = text + "<tr align='right' bgcolor=" + TString(yesterday_color) + "><td align='center' width='5%'>yesterday</td><td>" + data.yesterday.update_count.m_0_10_s(print_percent) + "</td><td>" + data.yesterday.update_count.m_10_20_s(print_percent) + "</td><td>" + data.yesterday.update_count.m_20_50_s(print_percent) + "</td><td>" + data.yesterday.update_count.m_50_100_s(print_percent) + "</td><td>" + data.yesterday.update_count.m_100_150_s(print_percent) + "</td><td>" + data.yesterday.update_count.m_150_190_s(print_percent) + "</td><td>" + data.yesterday.update_count.m_190_500_s(print_percent) + "</td><td>" + data.yesterday.update_count.m_more500_s(print_percent) + "</td></tr>";
    text = text + "<tr align='right'><td width='25%' align='left' rowspan='2'>" + m_weblabels.GetParamNameWeb(SAT_FINDONE) + "</td><td align='center' width='5%'>today</td><td>" + data.today.findone_count.m_0_10_s(print_percent) + "</td><td>" + data.today.findone_count.m_10_20_s(print_percent) + "</td><td>" + data.today.findone_count.m_20_50_s(print_percent) + "</td><td>" + data.today.findone_count.m_50_100_s(print_percent) + "</td><td>" + data.today.findone_count.m_100_150_s(print_percent) + "</td><td>" + data.today.findone_count.m_150_190_s(print_percent) + "</td><td>" + data.today.findone_count.m_190_500_s(print_percent) + "</td><td>" + data.today.findone_count.m_more500_s(print_percent) + "</td></tr>";
    text = text + "<tr align='right' bgcolor=" + TString(yesterday_color) + "><td align='center' width='5%'>yesterday</td><td>" + data.yesterday.findone_count.m_0_10_s(print_percent) + "</td><td>" + data.yesterday.findone_count.m_10_20_s(print_percent) + "</td><td>" + data.yesterday.findone_count.m_20_50_s(print_percent) + "</td><td>" + data.yesterday.findone_count.m_50_100_s(print_percent) + "</td><td>" + data.yesterday.findone_count.m_100_150_s(print_percent) + "</td><td>" + data.yesterday.findone_count.m_150_190_s(print_percent) + "</td><td>" + data.yesterday.findone_count.m_190_500_s(print_percent) + "</td><td>" + data.yesterday.findone_count.m_more500_s(print_percent) + "</td></tr>";
    text = text + "<tr align='right'><td width='25%' align='left' rowspan='2'>" + m_weblabels.GetParamNameWeb(SAT_FIND) + "</td><td align='center' width='5%'>today</td><td>" + data.today.find_count.m_0_10_s(print_percent) + "</td><td>" + data.today.find_count.m_10_20_s(print_percent) + "</td><td>" + data.today.find_count.m_20_50_s(print_percent) + "</td><td>" + data.today.find_count.m_50_100_s(print_percent) + "</td><td>" + data.today.find_count.m_100_150_s(print_percent) + "</td><td>" + data.today.find_count.m_150_190_s(print_percent) + "</td><td>" + data.today.find_count.m_190_500_s(print_percent) + "</td><td>" + data.today.find_count.m_more500_s(print_percent) + "</td></tr>";
    text = text + "<tr align='right' bgcolor=" + TString(yesterday_color) + "><td align='center' width='5%'>yesterday</td><td>" + data.yesterday.find_count.m_0_10_s(print_percent) + "</td><td>" + data.yesterday.find_count.m_10_20_s(print_percent) + "</td><td>" + data.yesterday.find_count.m_20_50_s(print_percent) + "</td><td>" + data.yesterday.find_count.m_50_100_s(print_percent) + "</td><td>" + data.yesterday.find_count.m_100_150_s(print_percent) + "</td><td>" + data.yesterday.find_count.m_150_190_s(print_percent) + "</td><td>" + data.yesterday.find_count.m_190_500_s(print_percent) + "</td><td>" + data.yesterday.find_count.m_more500_s(print_percent) + "</td></tr>";
    text = text + "<tr align='right'><td width='25%' align='left' rowspan='2'>" + m_weblabels.GetParamNameWeb(SAT_ERASE) + "</td><td align='center' width='5%'>today</td><td>" + data.today.erase_count.m_0_10_s(print_percent) + "</td><td>" + data.today.erase_count.m_10_20_s(print_percent) + "</td><td>" + data.today.erase_count.m_20_50_s(print_percent) + "</td><td>" + data.today.erase_count.m_50_100_s(print_percent) + "</td><td>" + data.today.erase_count.m_100_150_s(print_percent) + "</td><td>" + data.today.erase_count.m_150_190_s(print_percent) + "</td><td>" + data.today.erase_count.m_190_500_s(print_percent) + "</td><td>" + data.today.erase_count.m_more500_s(print_percent) + "</td></tr>";
    text = text + "<tr align='right' bgcolor=" + TString(yesterday_color) + "><td align='center' width='5%'>yesterday</td><td>" + data.yesterday.erase_count.m_0_10_s(print_percent) + "</td><td>" + data.yesterday.erase_count.m_10_20_s(print_percent) + "</td><td>" + data.yesterday.erase_count.m_20_50_s(print_percent) + "</td><td>" + data.yesterday.erase_count.m_50_100_s(print_percent) + "</td><td>" + data.yesterday.erase_count.m_100_150_s(print_percent) + "</td><td>" + data.yesterday.erase_count.m_150_190_s(print_percent) + "</td><td>" + data.yesterday.erase_count.m_190_500_s(print_percent) + "</td><td>" + data.yesterday.erase_count.m_more500_s(print_percent) + "</td></tr>";
    text = text + "<tr align='right'><td width='25%' align='left' rowspan='2'>" + m_weblabels.GetParamNameWeb(SAT_SIZE) + "</td><td align='center' width='5%'>today</td><td>" + data.today.size_count.m_0_10_s(print_percent) + "</td><td>" + data.today.size_count.m_10_20_s(print_percent) + "</td><td>" + data.today.size_count.m_20_50_s(print_percent) + "</td><td>" + data.today.size_count.m_50_100_s(print_percent) + "</td><td>" + data.today.size_count.m_100_150_s(print_percent) + "</td><td>" + data.today.size_count.m_150_190_s(print_percent) + "</td><td>" + data.today.size_count.m_190_500_s(print_percent) + "</td><td>" + data.today.size_count.m_more500_s(print_percent) + "</td></tr>";
    text = text + "<tr align='right' bgcolor=" + TString(yesterday_color) + "><td align='center' width='5%'>yesterday</td><td>" + data.yesterday.size_count.m_0_10_s(print_percent) + "</td><td>" + data.yesterday.size_count.m_10_20_s(print_percent) + "</td><td>" + data.yesterday.size_count.m_20_50_s(print_percent) + "</td><td>" + data.yesterday.size_count.m_50_100_s(print_percent) + "</td><td>" + data.yesterday.size_count.m_100_150_s(print_percent) + "</td><td>" + data.yesterday.size_count.m_150_190_s(print_percent) + "</td><td>" + data.yesterday.size_count.m_190_500_s(print_percent) + "</td><td>" + data.yesterday.size_count.m_more500_s(print_percent) + "</td></tr>";
    text = text + "<tr align='right'><td width='25%' align='left' rowspan='2'>" + m_weblabels.GetParamNameWeb(SAT_MULTYACTION) + "</td><td align='center' width='5%'>today</td><td>" + data.today.multiaction_count.m_0_10_s(print_percent) + "</td><td>" + data.today.multiaction_count.m_10_20_s(print_percent) + "</td><td>" + data.today.multiaction_count.m_20_50_s(print_percent) + "</td><td>" + data.today.multiaction_count.m_50_100_s(print_percent) + "</td><td>" + data.today.multiaction_count.m_100_150_s(print_percent) + "</td><td>" + data.today.multiaction_count.m_150_190_s(print_percent) + "</td><td>" + data.today.multiaction_count.m_190_500_s(print_percent) + "</td><td>" + data.today.multiaction_count.m_more500_s(print_percent) + "</td></tr>";
    text = text + "<tr align='right' bgcolor=" + TString(yesterday_color) + "><td align='center' width='5%'>yesterday</td><td>" + data.yesterday.multiaction_count.m_0_10_s(print_percent) + "</td><td>" + data.yesterday.multiaction_count.m_10_20_s(print_percent) + "</td><td>" + data.yesterday.multiaction_count.m_20_50_s(print_percent) + "</td><td>" + data.yesterday.multiaction_count.m_50_100_s(print_percent) + "</td><td>" + data.yesterday.multiaction_count.m_100_150_s(print_percent) + "</td><td>" + data.yesterday.multiaction_count.m_150_190_s(print_percent) + "</td><td>" + data.yesterday.multiaction_count.m_190_500_s(print_percent) + "</td><td>" + data.yesterday.multiaction_count.m_more500_s(print_percent) + "</td></tr>";
    text = text + "<tr align='right'><td width='25%' align='left' rowspan='2'>" + m_weblabels.GetParamNameWeb(SAT_CLEAR) + "</td><td align='center' width='5%'>today</td><td>" + data.today.clear_count.m_0_10_s(print_percent) + "</td><td>" + data.today.clear_count.m_10_20_s(print_percent) + "</td><td>" + data.today.clear_count.m_20_50_s(print_percent) + "</td><td>" + data.today.clear_count.m_50_100_s(print_percent) + "</td><td>" + data.today.clear_count.m_100_150_s(print_percent) + "</td><td>" + data.today.clear_count.m_150_190_s(print_percent) + "</td><td>" + data.today.clear_count.m_190_500_s(print_percent) + "</td><td>" + data.today.clear_count.m_more500_s(print_percent) + "</td></tr>";
    text = text + "<tr align='right' bgcolor=" + TString(yesterday_color) + "><td align='center' width='5%'>yesterday</td><td>" + data.yesterday.clear_count.m_0_10_s(print_percent) + "</td><td>" + data.yesterday.clear_count.m_10_20_s(print_percent) + "</td><td>" + data.yesterday.clear_count.m_20_50_s(print_percent) + "</td><td>" + data.yesterday.clear_count.m_50_100_s(print_percent) + "</td><td>" + data.yesterday.clear_count.m_100_150_s(print_percent) + "</td><td>" + data.yesterday.clear_count.m_150_190_s(print_percent) + "</td><td>" + data.yesterday.clear_count.m_190_500_s(print_percent) + "</td><td>" + data.yesterday.clear_count.m_more500_s(print_percent) + "</td></tr>";
    text = text + "<tr align='right'><td width='25%' align='left' rowspan='2'>" + m_weblabels.GetParamNameWeb(SAT_FINDANDMODIFY) + "</td><td align='center' width='5%'>today</td><td>" + data.today.findandmodify_count.m_0_10_s(print_percent) + "</td><td>" + data.today.findandmodify_count.m_10_20_s(print_percent) + "</td><td>" + data.today.findandmodify_count.m_20_50_s(print_percent) + "</td><td>" + data.today.findandmodify_count.m_50_100_s(print_percent) + "</td><td>" + data.today.findandmodify_count.m_100_150_s(print_percent) + "</td><td>" + data.today.findandmodify_count.m_150_190_s(print_percent) + "</td><td>" + data.today.findandmodify_count.m_190_500_s(print_percent) + "</td><td>" + data.today.findandmodify_count.m_more500_s(print_percent) + "</td></tr>";
    text = text + "<tr align='right' bgcolor=" + TString(yesterday_color) + "><td align='center' width='5%'>yesterday</td><td>" + data.yesterday.findandmodify_count.m_0_10_s(print_percent) + "</td><td>" + data.yesterday.findandmodify_count.m_10_20_s(print_percent) + "</td><td>" + data.yesterday.findandmodify_count.m_20_50_s(print_percent) + "</td><td>" + data.yesterday.findandmodify_count.m_50_100_s(print_percent) + "</td><td>" + data.yesterday.findandmodify_count.m_100_150_s(print_percent) + "</td><td>" + data.yesterday.findandmodify_count.m_150_190_s(print_percent) + "</td><td>" + data.yesterday.findandmodify_count.m_190_500_s(print_percent) + "</td><td>" + data.yesterday.findandmodify_count.m_more500_s(print_percent) + "</td></tr>";
    text = text + "<tr align='right'><td width='25%' align='left' rowspan='2'>" + m_weblabels.GetParamNameWeb(SAT_RESERV1) + "</td><td align='center' width='5%'>today</td><td>" + data.today.reserv1_count.m_0_10_s(print_percent) + "</td><td>" + data.today.reserv1_count.m_10_20_s(print_percent) + "</td><td>" + data.today.reserv1_count.m_20_50_s(print_percent) + "</td><td>" + data.today.reserv1_count.m_50_100_s(print_percent) + "</td><td>" + data.today.reserv1_count.m_100_150_s(print_percent) + "</td><td>" + data.today.reserv1_count.m_150_190_s(print_percent) + "</td><td>" + data.today.reserv1_count.m_190_500_s(print_percent) + "</td><td>" + data.today.reserv1_count.m_more500_s(print_percent) + "</td></tr>";
    text = text + "<tr align='right' bgcolor=" + TString(yesterday_color) + "><td align='center' width='5%'>yesterday</td><td>" + data.yesterday.reserv1_count.m_0_10_s(print_percent) + "</td><td>" + data.yesterday.reserv1_count.m_10_20_s(print_percent) + "</td><td>" + data.yesterday.reserv1_count.m_20_50_s(print_percent) + "</td><td>" + data.yesterday.reserv1_count.m_50_100_s(print_percent) + "</td><td>" + data.yesterday.reserv1_count.m_100_150_s(print_percent) + "</td><td>" + data.yesterday.reserv1_count.m_150_190_s(print_percent) + "</td><td>" + data.yesterday.reserv1_count.m_190_500_s(print_percent) + "</td><td>" + data.yesterday.reserv1_count.m_more500_s(print_percent) + "</td></tr>";
    if (!disable_summary) {
        text = text + "<tr align='right'><td width='25%' align='left' rowspan='2'>SUMMARY (all type request)</td><td align='center' width='5%'>today</td><td>" + today_summary.m_0_10_s(print_percent) + "</td><td>" + today_summary.m_10_20_s(print_percent) + "</td><td>" + today_summary.m_20_50_s(print_percent) + "</td><td>" + today_summary.m_50_100_s(print_percent) + "</td><td>" + today_summary.m_100_150_s(print_percent) + "</td><td>" + today_summary.m_150_190_s(print_percent) + "</td><td>" + today_summary.m_190_500_s(print_percent) + "</td><td>" + today_summary.m_more500_s(print_percent) + "</td></tr>";
        text = text + "<tr align='right' bgcolor=" + TString(yesterday_color) + "><td align='center' width='5%'>yesterday</td><td>" + yesterday_summary.m_0_10_s(print_percent) + "</td><td>" + yesterday_summary.m_10_20_s(print_percent) + "</td><td>" + yesterday_summary.m_20_50_s(print_percent) + "</td><td>" + yesterday_summary.m_50_100_s(print_percent) + "</td><td>" + yesterday_summary.m_100_150_s(print_percent) + "</td><td>" + yesterday_summary.m_150_190_s(print_percent) + "</td><td>" + yesterday_summary.m_190_500_s(print_percent) + "</td><td>" + yesterday_summary.m_more500_s(print_percent) + "</td></tr>";
    }
    text = text + "</table>";

    return text;
}

TString TStorageClientStat::PrintDataWEBShort(bool print_percent, bool disable_errors, bool disable_summary) {
    TString text = "";
    char* table_color = "'#ffffcc'";
    char* shap_cell_color = "'#ffffaa'";
    char* yesterday_color = "'#F8FCBF'";
    int bcount = 0;

    TOperCountStatItemPart today_summary = data.today.GetAll();
    TOperCountStatItemPart yesterday_summary = data.yesterday.GetAll();

    text = text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=" + TString(table_color) + ">\n";
    if (!disable_errors) {
        text = text + "<tr bgcolor=" + TString(shap_cell_color) + " align='center'><td width='30%' align='left' colspan='2'><b>ERRORS</b></td><td colspan='4' width='35%'><b>TODAY</b></td><td colspan='4' width='35%'><b>YESTERDAY</b></td><tr>";
        text = text + "<tr bgcolor=" + TString(shap_cell_color) + " align='center'><td width='30%' align='left' colspan='2'>&nbsp;</td><td colspan='2' width='17%'><b>GOOD</b></td><td colspan='2' width='18%'><b>BAD</b></td><td colspan='2' width='17%'><b>GOOD</b></td><td colspan='2' width='18%'><b>BAD</b></td><tr>";

        bcount = 0;

        if ((data.today.update_count.SummGoodBadCount() > 0) || (data.yesterday.update_count.SummGoodBadCount() > 0)) {
            text = text + "<tr align='right'><td width='30%' align='left' colspan='2'>" + m_weblabels.GetParamNameWeb(SAT_UPDATE) + "</td><td colspan='2' width='17%'>" + UI64ToStroka(data.today.update_count.good) + "</td><td colspan='2' width='18%'>" + UI64ToStroka(data.today.update_count.bad) + "</td><td colspan='2' width='17%'>" + UI64ToStroka(data.yesterday.update_count.good) + "</td><td colspan='2' width='18%'>" + UI64ToStroka(data.yesterday.update_count.bad) + "</td><tr>";
            bcount++;
        }

        if ((data.today.findone_count.SummGoodBadCount() > 0) || (data.yesterday.findone_count.SummGoodBadCount() > 0)) {
            text = text + "<tr align='right'><td width='30%' align='left' colspan='2'>" + m_weblabels.GetParamNameWeb(SAT_FINDONE) + "</td><td colspan='2' width='17%'>" + UI64ToStroka(data.today.findone_count.good) + "</td><td colspan='2' width='18%'>" + UI64ToStroka(data.today.findone_count.bad) + "</td><td colspan='2' width='17%'>" + UI64ToStroka(data.yesterday.findone_count.good) + "</td><td colspan='2' width='18%'>" + UI64ToStroka(data.yesterday.findone_count.bad) + "</td><tr>";
            bcount++;
        }

        if ((data.today.find_count.SummGoodBadCount() > 0) || (data.yesterday.find_count.SummGoodBadCount() > 0)) {
            text = text + "<tr align='right'><td width='30%' align='left' colspan='2'>" + m_weblabels.GetParamNameWeb(SAT_FIND) + "</td><td colspan='2' width='17%'>" + UI64ToStroka(data.today.find_count.good) + "</td><td colspan='2' width='18%'>" + UI64ToStroka(data.today.find_count.bad) + "</td><td colspan='2' width='17%'>" + UI64ToStroka(data.yesterday.find_count.good) + "</td><td colspan='2' width='18%'>" + UI64ToStroka(data.yesterday.find_count.bad) + "</td><tr>";
            bcount++;
        }

        if ((data.today.erase_count.SummGoodBadCount() > 0) || (data.yesterday.erase_count.SummGoodBadCount() > 0)) {
            text = text + "<tr align='right'><td width='30%' align='left' colspan='2'>" + m_weblabels.GetParamNameWeb(SAT_ERASE) + "</td><td colspan='2' width='17%'>" + UI64ToStroka(data.today.erase_count.good) + "</td><td colspan='2' width='18%'>" + UI64ToStroka(data.today.erase_count.bad) + "</td><td colspan='2' width='17%'>" + UI64ToStroka(data.yesterday.erase_count.good) + "</td><td colspan='2' width='18%'>" + UI64ToStroka(data.yesterday.erase_count.bad) + "</td><tr>";
            bcount++;
        }

        if ((data.today.size_count.SummGoodBadCount() > 0) || (data.yesterday.size_count.SummGoodBadCount() > 0)) {
            text = text + "<tr align='right'><td width='30%' align='left' colspan='2'>" + m_weblabels.GetParamNameWeb(SAT_SIZE) + "</td><td colspan='2' width='17%'>" + UI64ToStroka(data.today.size_count.good) + "</td><td colspan='2' width='18%'>" + UI64ToStroka(data.today.size_count.bad) + "</td><td colspan='2' width='17%'>" + UI64ToStroka(data.yesterday.size_count.good) + "</td><td colspan='2' width='18%'>" + UI64ToStroka(data.yesterday.size_count.bad) + "</td><tr>";
            bcount++;
        }

        if ((data.today.multiaction_count.SummGoodBadCount() > 0) || (data.yesterday.multiaction_count.SummGoodBadCount() > 0)) {
            text = text + "<tr align='right'><td width='30%' align='left' colspan='2'>" + m_weblabels.GetParamNameWeb(SAT_MULTYACTION) + "</td><td colspan='2' width='17%'>" + UI64ToStroka(data.today.multiaction_count.good) + "</td><td colspan='2' width='18%'>" + UI64ToStroka(data.today.multiaction_count.bad) + "</td><td colspan='2' width='17%'>" + UI64ToStroka(data.yesterday.multiaction_count.good) + "</td><td colspan='2' width='18%'>" + UI64ToStroka(data.yesterday.multiaction_count.bad) + "</td><tr>";
            bcount++;
        }

        if ((data.today.clear_count.SummGoodBadCount() > 0) || (data.yesterday.clear_count.SummGoodBadCount() > 0)) {
            text = text + "<tr align='right'><td width='30%' align='left' colspan='2'>" + m_weblabels.GetParamNameWeb(SAT_CLEAR) + "</td><td colspan='2' width='17%'>" + UI64ToStroka(data.today.clear_count.good) + "</td><td colspan='2' width='18%'>" + UI64ToStroka(data.today.clear_count.bad) + "</td><td colspan='2' width='17%'>" + UI64ToStroka(data.yesterday.clear_count.good) + "</td><td colspan='2' width='18%'>" + UI64ToStroka(data.yesterday.clear_count.bad) + "</td><tr>";
            bcount++;
        }

        if ((data.today.findandmodify_count.SummGoodBadCount() > 0) || (data.yesterday.findandmodify_count.SummGoodBadCount() > 0)) {
            text = text + "<tr align='right'><td width='30%' align='left' colspan='2'>" + m_weblabels.GetParamNameWeb(SAT_FINDANDMODIFY) + "</td><td colspan='2' width='17%'>" + UI64ToStroka(data.today.findandmodify_count.good) + "</td><td colspan='2' width='18%'>" + UI64ToStroka(data.today.findandmodify_count.bad) + "</td><td colspan='2' width='17%'>" + UI64ToStroka(data.yesterday.findandmodify_count.good) + "</td><td colspan='2' width='18%'>" + UI64ToStroka(data.yesterday.findandmodify_count.bad) + "</td><tr>";
            bcount++;
        }

        if ((data.today.reserv1_count.SummGoodBadCount() > 0) || (data.yesterday.reserv1_count.SummGoodBadCount() > 0)) {
            text = text + "<tr align='right'><td width='30%' align='left' colspan='2'>" + m_weblabels.GetParamNameWeb(SAT_RESERV1) + "</td><td colspan='2' width='17%'>" + UI64ToStroka(data.today.reserv1_count.good) + "</td><td colspan='2' width='18%'>" + UI64ToStroka(data.today.reserv1_count.bad) + "</td><td colspan='2' width='17%'>" + UI64ToStroka(data.yesterday.reserv1_count.good) + "</td><td colspan='2' width='18%'>" + UI64ToStroka(data.yesterday.reserv1_count.bad) + "</td><tr>";
            bcount++;
        }

        if ((bcount > 1) && (!disable_summary))
            text = text + "<tr align='right'><td width='30%' align='left' colspan='2'>SUMMARY (all type request)</td><td colspan='2' width='17%'>" + UI64ToStroka(today_summary.good) + "</td><td colspan='2' width='18%'>" + UI64ToStroka(today_summary.bad) + "</td><td colspan='2' width='17%'>" + UI64ToStroka(yesterday_summary.good) + "</td><td colspan='2' width='18%'>" + UI64ToStroka(yesterday_summary.bad) + "</td><tr>";
    }

    //text = text + "<tr valign='top' bgcolor='" + TString(cell_color) + "'><td valign='left' width='100%' colspan='9'>&nbsp;</td></tr>\n";
    bcount = 0;
    text = text + "<tr bgcolor=" + TString(shap_cell_color) + " align='center'><td width='30%' align='left' colspan='2'><b>DELAYS (ms)</b></td><td><b>0-10</b></td><td><b>10-20</b></td><td><b>20-50</b></td><td><b>50-100</b></td><td><b>100-150</b></td><td><b>150-190</b></td><td><b>190-500</b></td><td><b>more500</b></td></tr>";

    if ((data.today.update_count.SummQuantileCount() > 0) || (data.yesterday.update_count.SummQuantileCount() > 0)) {
        text = text + "<tr align='right'><td width='25%' align='left' rowspan='2'>" + m_weblabels.GetParamNameWeb(SAT_UPDATE) + "</td><td align='center' width='5%'>today</td><td>" + data.today.update_count.m_0_10_s(print_percent) + "</td><td>" + data.today.update_count.m_10_20_s(print_percent) + "</td><td>" + data.today.update_count.m_20_50_s(print_percent) + "</td><td>" + data.today.update_count.m_50_100_s(print_percent) + "</td><td>" + data.today.update_count.m_100_150_s(print_percent) + "</td><td>" + data.today.update_count.m_150_190_s(print_percent) + "</td><td>" + data.today.update_count.m_190_500_s(print_percent) + "</td><td>" + data.today.update_count.m_more500_s(print_percent) + "</td></tr>";
        text = text + "<tr align='right' bgcolor=" + TString(yesterday_color) + "><td align='center' width='5%'>yesterday</td><td>" + data.yesterday.update_count.m_0_10_s(print_percent) + "</td><td>" + data.yesterday.update_count.m_10_20_s(print_percent) + "</td><td>" + data.yesterday.update_count.m_20_50_s(print_percent) + "</td><td>" + data.yesterday.update_count.m_50_100_s(print_percent) + "</td><td>" + data.yesterday.update_count.m_100_150_s(print_percent) + "</td><td>" + data.yesterday.update_count.m_150_190_s(print_percent) + "</td><td>" + data.yesterday.update_count.m_190_500_s(print_percent) + "</td><td>" + data.yesterday.update_count.m_more500_s(print_percent) + "</td></tr>";
        bcount++;
    }

    if ((data.today.findone_count.SummQuantileCount() > 0) || (data.yesterday.findone_count.SummQuantileCount() > 0)) {
        text = text + "<tr align='right'><td width='25%' align='left' rowspan='2'>" + m_weblabels.GetParamNameWeb(SAT_FINDONE) + "</td><td align='center' width='5%'>today</td><td>" + data.today.findone_count.m_0_10_s(print_percent) + "</td><td>" + data.today.findone_count.m_10_20_s(print_percent) + "</td><td>" + data.today.findone_count.m_20_50_s(print_percent) + "</td><td>" + data.today.findone_count.m_50_100_s(print_percent) + "</td><td>" + data.today.findone_count.m_100_150_s(print_percent) + "</td><td>" + data.today.findone_count.m_150_190_s(print_percent) + "</td><td>" + data.today.findone_count.m_190_500_s(print_percent) + "</td><td>" + data.today.findone_count.m_more500_s(print_percent) + "</td></tr>";
        text = text + "<tr align='right' bgcolor=" + TString(yesterday_color) + "><td align='center' width='5%'>yesterday</td><td>" + data.yesterday.findone_count.m_0_10_s(print_percent) + "</td><td>" + data.yesterday.findone_count.m_10_20_s(print_percent) + "</td><td>" + data.yesterday.findone_count.m_20_50_s(print_percent) + "</td><td>" + data.yesterday.findone_count.m_50_100_s(print_percent) + "</td><td>" + data.yesterday.findone_count.m_100_150_s(print_percent) + "</td><td>" + data.yesterday.findone_count.m_150_190_s(print_percent) + "</td><td>" + data.yesterday.findone_count.m_190_500_s(print_percent) + "</td><td>" + data.yesterday.findone_count.m_more500_s(print_percent) + "</td></tr>";
        bcount++;
    }

    if ((data.today.find_count.SummQuantileCount() > 0) || (data.yesterday.find_count.SummQuantileCount() > 0)) {
        text = text + "<tr align='right'><td width='25%' align='left' rowspan='2'>" + m_weblabels.GetParamNameWeb(SAT_FIND) + "</td><td align='center' width='5%'>today</td><td>" + data.today.find_count.m_0_10_s(print_percent) + "</td><td>" + data.today.find_count.m_10_20_s(print_percent) + "</td><td>" + data.today.find_count.m_20_50_s(print_percent) + "</td><td>" + data.today.find_count.m_50_100_s(print_percent) + "</td><td>" + data.today.find_count.m_100_150_s(print_percent) + "</td><td>" + data.today.find_count.m_150_190_s(print_percent) + "</td><td>" + data.today.find_count.m_190_500_s(print_percent) + "</td><td>" + data.today.find_count.m_more500_s(print_percent) + "</td></tr>";
        text = text + "<tr align='right' bgcolor=" + TString(yesterday_color) + "><td align='center' width='5%'>yesterday</td><td>" + data.yesterday.find_count.m_0_10_s(print_percent) + "</td><td>" + data.yesterday.find_count.m_10_20_s(print_percent) + "</td><td>" + data.yesterday.find_count.m_20_50_s(print_percent) + "</td><td>" + data.yesterday.find_count.m_50_100_s(print_percent) + "</td><td>" + data.yesterday.find_count.m_100_150_s(print_percent) + "</td><td>" + data.yesterday.find_count.m_150_190_s(print_percent) + "</td><td>" + data.yesterday.find_count.m_190_500_s(print_percent) + "</td><td>" + data.yesterday.find_count.m_more500_s(print_percent) + "</td></tr>";
        bcount++;
    }

    if ((data.today.erase_count.SummQuantileCount() > 0) || (data.yesterday.erase_count.SummQuantileCount() > 0)) {
        text = text + "<tr align='right'><td width='25%' align='left' rowspan='2'>" + m_weblabels.GetParamNameWeb(SAT_ERASE) + "</td><td align='center' width='5%'>today</td><td>" + data.today.erase_count.m_0_10_s(print_percent) + "</td><td>" + data.today.erase_count.m_10_20_s(print_percent) + "</td><td>" + data.today.erase_count.m_20_50_s(print_percent) + "</td><td>" + data.today.erase_count.m_50_100_s(print_percent) + "</td><td>" + data.today.erase_count.m_100_150_s(print_percent) + "</td><td>" + data.today.erase_count.m_150_190_s(print_percent) + "</td><td>" + data.today.erase_count.m_190_500_s(print_percent) + "</td><td>" + data.today.erase_count.m_more500_s(print_percent) + "</td></tr>";
        text = text + "<tr align='right' bgcolor=" + TString(yesterday_color) + "><td align='center' width='5%'>yesterday</td><td>" + data.yesterday.erase_count.m_0_10_s(print_percent) + "</td><td>" + data.yesterday.erase_count.m_10_20_s(print_percent) + "</td><td>" + data.yesterday.erase_count.m_20_50_s(print_percent) + "</td><td>" + data.yesterday.erase_count.m_50_100_s(print_percent) + "</td><td>" + data.yesterday.erase_count.m_100_150_s(print_percent) + "</td><td>" + data.yesterday.erase_count.m_150_190_s(print_percent) + "</td><td>" + data.yesterday.erase_count.m_190_500_s(print_percent) + "</td><td>" + data.yesterday.erase_count.m_more500_s(print_percent) + "</td></tr>";
        bcount++;
    }

    if ((data.today.size_count.SummQuantileCount() > 0) || (data.yesterday.size_count.SummQuantileCount() > 0)) {
        text = text + "<tr align='right'><td width='25%' align='left' rowspan='2'>" + m_weblabels.GetParamNameWeb(SAT_SIZE) + "</td><td align='center' width='5%'>today</td><td>" + data.today.size_count.m_0_10_s(print_percent) + "</td><td>" + data.today.size_count.m_10_20_s(print_percent) + "</td><td>" + data.today.size_count.m_20_50_s(print_percent) + "</td><td>" + data.today.size_count.m_50_100_s(print_percent) + "</td><td>" + data.today.size_count.m_100_150_s(print_percent) + "</td><td>" + data.today.size_count.m_150_190_s(print_percent) + "</td><td>" + data.today.size_count.m_190_500_s(print_percent) + "</td><td>" + data.today.size_count.m_more500_s(print_percent) + "</td></tr>";
        text = text + "<tr align='right' bgcolor=" + TString(yesterday_color) + "><td align='center' width='5%'>yesterday</td><td>" + data.yesterday.size_count.m_0_10_s(print_percent) + "</td><td>" + data.yesterday.size_count.m_10_20_s(print_percent) + "</td><td>" + data.yesterday.size_count.m_20_50_s(print_percent) + "</td><td>" + data.yesterday.size_count.m_50_100_s(print_percent) + "</td><td>" + data.yesterday.size_count.m_100_150_s(print_percent) + "</td><td>" + data.yesterday.size_count.m_150_190_s(print_percent) + "</td><td>" + data.yesterday.size_count.m_190_500_s(print_percent) + "</td><td>" + data.yesterday.size_count.m_more500_s(print_percent) + "</td></tr>";
        bcount++;
    }

    if ((data.today.multiaction_count.SummQuantileCount() > 0) || (data.yesterday.multiaction_count.SummQuantileCount() > 0)) {
        text = text + "<tr align='right'><td width='25%' align='left' rowspan='2'>" + m_weblabels.GetParamNameWeb(SAT_MULTYACTION) + "</td><td align='center' width='5%'>today</td><td>" + data.today.multiaction_count.m_0_10_s(print_percent) + "</td><td>" + data.today.multiaction_count.m_10_20_s(print_percent) + "</td><td>" + data.today.multiaction_count.m_20_50_s(print_percent) + "</td><td>" + data.today.multiaction_count.m_50_100_s(print_percent) + "</td><td>" + data.today.multiaction_count.m_100_150_s(print_percent) + "</td><td>" + data.today.multiaction_count.m_150_190_s(print_percent) + "</td><td>" + data.today.multiaction_count.m_190_500_s(print_percent) + "</td><td>" + data.today.multiaction_count.m_more500_s(print_percent) + "</td></tr>";
        text = text + "<tr align='right' bgcolor=" + TString(yesterday_color) + "><td align='center' width='5%'>yesterday</td><td>" + data.yesterday.multiaction_count.m_0_10_s(print_percent) + "</td><td>" + data.yesterday.multiaction_count.m_10_20_s(print_percent) + "</td><td>" + data.yesterday.multiaction_count.m_20_50_s(print_percent) + "</td><td>" + data.yesterday.multiaction_count.m_50_100_s(print_percent) + "</td><td>" + data.yesterday.multiaction_count.m_100_150_s(print_percent) + "</td><td>" + data.yesterday.multiaction_count.m_150_190_s(print_percent) + "</td><td>" + data.yesterday.multiaction_count.m_190_500_s(print_percent) + "</td><td>" + data.yesterday.multiaction_count.m_more500_s(print_percent) + "</td></tr>";
        bcount++;
    }

    if ((data.today.clear_count.SummQuantileCount() > 0) || (data.yesterday.clear_count.SummQuantileCount() > 0)) {
        text = text + "<tr align='right'><td width='25%' align='left' rowspan='2'>" + m_weblabels.GetParamNameWeb(SAT_CLEAR) + "</td><td align='center' width='5%'>today</td><td>" + data.today.clear_count.m_0_10_s(print_percent) + "</td><td>" + data.today.clear_count.m_10_20_s(print_percent) + "</td><td>" + data.today.clear_count.m_20_50_s(print_percent) + "</td><td>" + data.today.clear_count.m_50_100_s(print_percent) + "</td><td>" + data.today.clear_count.m_100_150_s(print_percent) + "</td><td>" + data.today.clear_count.m_150_190_s(print_percent) + "</td><td>" + data.today.clear_count.m_190_500_s(print_percent) + "</td><td>" + data.today.clear_count.m_more500_s(print_percent) + "</td></tr>";
        text = text + "<tr align='right' bgcolor=" + TString(yesterday_color) + "><td align='center' width='5%'>yesterday</td><td>" + data.yesterday.clear_count.m_0_10_s(print_percent) + "</td><td>" + data.yesterday.clear_count.m_10_20_s(print_percent) + "</td><td>" + data.yesterday.clear_count.m_20_50_s(print_percent) + "</td><td>" + data.yesterday.clear_count.m_50_100_s(print_percent) + "</td><td>" + data.yesterday.clear_count.m_100_150_s(print_percent) + "</td><td>" + data.yesterday.clear_count.m_150_190_s(print_percent) + "</td><td>" + data.yesterday.clear_count.m_190_500_s(print_percent) + "</td><td>" + data.yesterday.clear_count.m_more500_s(print_percent) + "</td></tr>";
        bcount++;
    }

    if ((data.today.findandmodify_count.SummQuantileCount() > 0) || (data.yesterday.findandmodify_count.SummQuantileCount() > 0)) {
        text = text + "<tr align='right'><td width='25%' align='left' rowspan='2'>" + m_weblabels.GetParamNameWeb(SAT_FINDANDMODIFY) + "</td><td align='center' width='5%'>today</td><td>" + data.today.findandmodify_count.m_0_10_s(print_percent) + "</td><td>" + data.today.findandmodify_count.m_10_20_s(print_percent) + "</td><td>" + data.today.findandmodify_count.m_20_50_s(print_percent) + "</td><td>" + data.today.findandmodify_count.m_50_100_s(print_percent) + "</td><td>" + data.today.findandmodify_count.m_100_150_s(print_percent) + "</td><td>" + data.today.findandmodify_count.m_150_190_s(print_percent) + "</td><td>" + data.today.findandmodify_count.m_190_500_s(print_percent) + "</td><td>" + data.today.findandmodify_count.m_more500_s(print_percent) + "</td></tr>";
        text = text + "<tr align='right' bgcolor=" + TString(yesterday_color) + "><td align='center' width='5%'>yesterday</td><td>" + data.yesterday.findandmodify_count.m_0_10_s(print_percent) + "</td><td>" + data.yesterday.findandmodify_count.m_10_20_s(print_percent) + "</td><td>" + data.yesterday.findandmodify_count.m_20_50_s(print_percent) + "</td><td>" + data.yesterday.findandmodify_count.m_50_100_s(print_percent) + "</td><td>" + data.yesterday.findandmodify_count.m_100_150_s(print_percent) + "</td><td>" + data.yesterday.findandmodify_count.m_150_190_s(print_percent) + "</td><td>" + data.yesterday.findandmodify_count.m_190_500_s(print_percent) + "</td><td>" + data.yesterday.findandmodify_count.m_more500_s(print_percent) + "</td></tr>";
        bcount++;
    }

    if ((data.today.reserv1_count.SummQuantileCount() > 0) || (data.yesterday.reserv1_count.SummQuantileCount() > 0)) {
        text = text + "<tr align='right'><td width='25%' align='left' rowspan='2'>" + m_weblabels.GetParamNameWeb(SAT_RESERV1) + "</td><td align='center' width='5%'>today</td><td>" + data.today.reserv1_count.m_0_10_s(print_percent) + "</td><td>" + data.today.reserv1_count.m_10_20_s(print_percent) + "</td><td>" + data.today.reserv1_count.m_20_50_s(print_percent) + "</td><td>" + data.today.reserv1_count.m_50_100_s(print_percent) + "</td><td>" + data.today.reserv1_count.m_100_150_s(print_percent) + "</td><td>" + data.today.reserv1_count.m_150_190_s(print_percent) + "</td><td>" + data.today.reserv1_count.m_190_500_s(print_percent) + "</td><td>" + data.today.reserv1_count.m_more500_s(print_percent) + "</td></tr>";
        text = text + "<tr align='right' bgcolor=" + TString(yesterday_color) + "><td align='center' width='5%'>yesterday</td><td>" + data.yesterday.reserv1_count.m_0_10_s(print_percent) + "</td><td>" + data.yesterday.reserv1_count.m_10_20_s(print_percent) + "</td><td>" + data.yesterday.reserv1_count.m_20_50_s(print_percent) + "</td><td>" + data.yesterday.reserv1_count.m_50_100_s(print_percent) + "</td><td>" + data.yesterday.reserv1_count.m_100_150_s(print_percent) + "</td><td>" + data.yesterday.reserv1_count.m_150_190_s(print_percent) + "</td><td>" + data.yesterday.reserv1_count.m_190_500_s(print_percent) + "</td><td>" + data.yesterday.reserv1_count.m_more500_s(print_percent) + "</td></tr>";
        bcount++;
    }

    if ((bcount > 1) && (!disable_summary)) {
        text = text + "<tr align='right'><td width='25%' align='left' rowspan='2'>SUMMARY (all type request)</td><td align='center' width='5%'>today</td><td>" + today_summary.m_0_10_s(print_percent) + "</td><td>" + today_summary.m_10_20_s(print_percent) + "</td><td>" + today_summary.m_20_50_s(print_percent) + "</td><td>" + today_summary.m_50_100_s(print_percent) + "</td><td>" + today_summary.m_100_150_s(print_percent) + "</td><td>" + today_summary.m_150_190_s(print_percent) + "</td><td>" + today_summary.m_190_500_s(print_percent) + "</td><td>" + today_summary.m_more500_s(print_percent) + "</td></tr>";
        text = text + "<tr align='right' bgcolor=" + TString(yesterday_color) + "><td align='center' width='5%'>yesterday</td><td>" + yesterday_summary.m_0_10_s(print_percent) + "</td><td>" + yesterday_summary.m_10_20_s(print_percent) + "</td><td>" + yesterday_summary.m_20_50_s(print_percent) + "</td><td>" + yesterday_summary.m_50_100_s(print_percent) + "</td><td>" + yesterday_summary.m_100_150_s(print_percent) + "</td><td>" + yesterday_summary.m_150_190_s(print_percent) + "</td><td>" + yesterday_summary.m_190_500_s(print_percent) + "</td><td>" + yesterday_summary.m_more500_s(print_percent) + "</td></tr>";
    }

    text = text + "</table>";

    return text;
}

void TStorageClientStat::ChangeLabelLog(TChangeLabelStructList& change_labels_list) {
    data.ChangeLabelLog(change_labels_list);
}

TString TStorageClientStat::PrintDataLog() {
    return data.PrintToLog();
}

//***********************************************************************************************************************
//                                              TStorageClientStatMain
//***********************************************************************************************************************

TStorageClientStatMain::TStorageClientStatMain() {
}

TStorageClientStatMain::~TStorageClientStatMain() {
}

void TStorageClientStatMain::AddCount(const TString& db, const TString& collection, TStorageClientStat::TStorageActionType acttype, int count, bool good, ui32 tick) {
    m_Mutex.Acquire();

    TString longname = "";
    TStorageStatVectorIt it;

    longname = db + "::" + collection;
    it = find(dbcoll_stor.begin(), dbcoll_stor.end(), TStorageStat(longname));
    if (it != dbcoll_stor.end())
        (*it).m_stat.AddCount(acttype, count, good, tick);
    else {
        //TStorageStatVector::iterator it = dbcoll_stor.insert(dbcoll_stor.end(), TStorageStatVector::value_type(TStorageStat(longname, acttype, count, good, tick)));
        //if (it != dbcoll_stor.end())
        //   (*it).Init();

        dbcoll_stor.push_back(TStorageStat(longname, acttype, count, good, tick));
    }

    m_Mutex.Release();
}

void TStorageClientStatMain::Midnight() {
    m_Mutex.Acquire();

    TStorageStatVectorIt it;

    it = dbcoll_stor.begin();
    while (it != dbcoll_stor.end()) {
        (*it).Midnight();

        ++it;
    }

    m_Mutex.Release();
}

TStorageStatVector TStorageClientStatMain::GetWebStat() {
    return dbcoll_stor;
}

TStorageStatVector TStorageClientStatMain::GetMonStat() {
    TStorageStatVector res;

    m_Mutex.Acquire();

    res = dbcoll_stor;
    dbcoll_stor.Clear();

    m_Mutex.Release();

    return res;
}

void TStorageClientStatMain::ChangeLabelWeb(TStorageClientStat::TChangeLabelStructList& change_labels_list) {
    dbcoll_stor.ChangeLabelWeb(change_labels_list);
}

void TStorageClientStatMain::ChangeLabelLog(TStorageClientStat::TChangeLabelStructList& change_labels_list) {
    dbcoll_stor.ChangeLabelLog(change_labels_list);
}

//***********************************************************************************************************************
