#include "tstoragenosql.h"
#include "baniplist.h"

//*******************************************************************************************************************************
//                                                    TStorageNoSql
//*******************************************************************************************************************************

TStorageNoSql::TStorageNoSql()
{
   configobj = NULL;
   m_db      = "";
}

TStorageNoSql::~TStorageNoSql()
{


}

TString TStorageNoSql::GetDB()
{
   return m_db;
}

TString TStorageNoSql::GetCollectionName(TStorageType stortype)
{
   TString res = "";

   switch (stortype)
   {
   case MST_MEMBASE:
                        res = "membase";
                        break;
   case MST_MEMSTAT:
                        res = "memstat";
                        break;
   case MST_BANIP:
                        res = "banobj";
                        break;
   case MST_BAN7IP:
                        res = "ban7obj";
                        break;
   case MST_BANSETUP:
                        res = "setup";
                        break;
   case MST_RPS:
                        res = "rps";
                        break;
   default:
                        res = "";

   };

   return res;
}

stor_bt::TShingleStorageType TStorageNoSql::GetCollectionNameFromType(const TString &str)
{
 TStorageType stortype = MST_UNKNOWN;

 if (str == "membase")
  stortype = MST_MEMBASE;
 else if (str == "memstat")
  stortype = MST_MEMSTAT;
 else if (str == "banobj")
  stortype = MST_BANIP;
 else if (str == "ban7obj")
  stortype = MST_BAN7IP;
 else if (str == "setup")
  stortype = MST_BANSETUP;
 else if (str == "rps")
  stortype = MST_RPS;

 return GetCollectionName2(stortype);
}

stor_bt::TShingleStorageType TStorageNoSql::GetCollectionName2(TStorageType stortype)
{
 stor_bt::TShingleStorageType res = stor_bt::SST_USRCOLL_UNKNOWN;

 switch (stortype)
 {
 case MST_MEMBASE:
      res = stor_bt::SST_USRCOLL_01;
      break;
 case MST_MEMSTAT:
      res = stor_bt::SST_USRCOLL_02;
      break;
 case MST_BANIP:
      res = stor_bt::SST_USRCOLL_03;
      break;
 case MST_BAN7IP:
      res = stor_bt::SST_USRCOLL_04;
      break;
 case MST_BANSETUP:
      res = stor_bt::SST_USRCOLL_05;
      break;
 case MST_RPS:
      res = stor_bt::SST_USRCOLL_06;
      break;
 default:
      res = stor_bt::SST_USRCOLL_UNKNOWN;
 };

 return res;
}

TString TStorageNoSql::GetID(TStorageType stortype, TKIPv6 ip)
{
   TString res = "";

   switch (stortype)
   {
   case MST_MEMBASE:
                        res = TMemRecordSerialization::ConvertToId(ip);
                        break;
   case MST_MEMSTAT:
                        res = TIpStatSerialization::ConvertToId(ip);
                        break;
   case MST_BANIP:
                        res = TBanIpBasicSerialization::ConvertToId(ip);
                        break;
   case MST_BAN7IP:
                        res = TBanIpBasicSerialization::ConvertToId(ip);
                        break;
   case MST_BANSETUP:
                        res = TBanSetupSerialization::ConvertToId(ip);
                        break;
   case MST_RPS:
                        res = TDSLRpsSerialization::ConvertToId(ip);
                        break;
   default:
                        res = "";

   };

   return res;
}

ui64 TStorageNoSql::GetID2(TStorageType stortype, TKIPv6 ip)
{
 ui64 res = 0;

 switch (stortype)
 {
 case MST_MEMBASE:
      res = TMemRecordSerialization::ConvertToId2(ip);
      break;
 case MST_MEMSTAT:
      res = TIpStatSerialization::ConvertToId2(ip);
      break;
 case MST_BANIP:
      res = TBanIpBasicSerialization::ConvertToId2(ip);
      break;
 case MST_BAN7IP:
      res = TBanIpBasicSerialization::ConvertToId2(ip);
      break;
 case MST_BANSETUP:
      res = TBanSetupSerialization::ConvertToId2(ip);
      break;
 case MST_RPS:
      res = TDSLRpsSerialization::ConvertToId2(ip);
      break;
 default:
  res = 0;

 };

 return res;
}

bool TStorageNoSql::FindOneA( TString db, TString collection, TString id, nosql::HashMap& hash, bool& err )
{
   bool res = false;
   ui32 tick = 0;

   tick = CShingleTime::GetMs();

   res = FindOne(db, collection, id, hash, err);

   tick = CShingleTime::GetMs() - tick;

   webstat.AddCount(db, collection, NStorageStats::TStorageRequestStat::SAT_FINDONE, 1, NStorageStats::ToTSRSErrTypeB(!err), tick);
   monstat.AddCount(db, collection, NStorageStats::TStorageRequestStat::SAT_FINDONE, 1, NStorageStats::ToTSRSErrTypeB(!err), tick);

   return res;
}

bool TStorageNoSql::UpdateA( TString db, TString collection, TString id, const nosql::HashMap& incrs, const nosql::HashMap& sets, bool& err)
{
   bool res = false;
   ui32 tick = 0;

   tick = CShingleTime::GetMs();

   res = Update(db, collection, id, incrs, sets, err);

   tick = CShingleTime::GetMs() - tick;

   webstat.AddCount(db, collection, NStorageStats::TStorageRequestStat::SAT_UPDATE, 1, NStorageStats::ToTSRSErrTypeB(!err), tick);
   monstat.AddCount(db, collection, NStorageStats::TStorageRequestStat::SAT_UPDATE, 1, NStorageStats::ToTSRSErrTypeB(!err), tick);

   return res;
}

bool TStorageNoSql::FindAndModifyA( TString db, TString collection, TString id, const nosql::HashMap& incrs, const nosql::HashMap& sets, nosql::HashMap& hash, bool getnew, bool& err )
{
   bool res = false;
   ui32 tick = 0;

   tick = CShingleTime::GetMs();

   res = FindAndModify(db, collection, id, incrs, sets, hash, getnew, err);

   tick = CShingleTime::GetMs() - tick;

   webstat.AddCount(db, collection, NStorageStats::TStorageRequestStat::SAT_FINDANDMODIFY, 1, NStorageStats::ToTSRSErrTypeB(!err), tick);
   monstat.AddCount(db, collection, NStorageStats::TStorageRequestStat::SAT_FINDANDMODIFY, 1, NStorageStats::ToTSRSErrTypeB(!err), tick);

   return res;
}

i64 TStorageNoSql::SizeA( TString db, TString collection, bool& err)
{
   i64  res  = 0;
   ui32 tick = 0;

   tick = CShingleTime::GetMs();

   res = Size(db, collection, err);

   tick = CShingleTime::GetMs() - tick;

   webstat.AddCount(db, collection, NStorageStats::TStorageRequestStat::SAT_SIZE, 1, NStorageStats::ToTSRSErrTypeB(!err), tick);
   monstat.AddCount(db, collection, NStorageStats::TStorageRequestStat::SAT_SIZE, 1, NStorageStats::ToTSRSErrTypeB(!err), tick);

   return res;
}

bool TStorageNoSql::FindA( TString db, TString collection, TVector< nosql::HashMap >& hashes, bool& err )
{
   bool res = false;
   ui32 tick = 0;

   tick = CShingleTime::GetMs();

   res = Find(db, collection, hashes, err);

   tick = CShingleTime::GetMs() - tick;

   webstat.AddCount(db, collection, NStorageStats::TStorageRequestStat::SAT_FIND, 1, NStorageStats::ToTSRSErrTypeB(!err), tick);
   monstat.AddCount(db, collection, NStorageStats::TStorageRequestStat::SAT_FIND, 1, NStorageStats::ToTSRSErrTypeB(!err), tick);

   return res;
}

bool TStorageNoSql::EraseA( TString db, TString collection, TString id, bool& err )
{
   bool res = false;
   ui32 tick = 0;

   tick = CShingleTime::GetMs();

   res = Erase(db, collection, id, err);

   tick = CShingleTime::GetMs() - tick;

   webstat.AddCount(db, collection, NStorageStats::TStorageRequestStat::SAT_ERASE, 1, NStorageStats::ToTSRSErrTypeB(!err), tick);
   monstat.AddCount(db, collection, NStorageStats::TStorageRequestStat::SAT_ERASE, 1, NStorageStats::ToTSRSErrTypeB(!err), tick);

   return res;
}

void TStorageNoSql::SetDatabaseAndCollectionNames()
{
 m_database_name    = GetDB();
 m_usercoll_01_name = GetCollectionName(MST_MEMBASE);
 m_usercoll_02_name = GetCollectionName(MST_MEMSTAT);
 m_usercoll_03_name = GetCollectionName(MST_BANIP);
 m_usercoll_04_name = GetCollectionName(MST_BAN7IP);
 m_usercoll_05_name = GetCollectionName(MST_BANSETUP);
 m_usercoll_06_name = GetCollectionName(MST_RPS);
 m_usercoll_07_name = "";
 m_statcoll_name    = "STAT";

 if ((LogsGroupB != NULL) && (LogsGroupB->GetServerLog() != NULL))
  LogsGroupB->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "STOR: set database_name='%s' and collection_names='%s','%s','%s','%s','%s','%s','%s'.", m_database_name.c_str(), m_usercoll_01_name.c_str(), m_usercoll_02_name.c_str(), m_usercoll_03_name.c_str(), m_usercoll_04_name.c_str(), m_usercoll_05_name.c_str(), m_usercoll_06_name.c_str(), m_usercoll_07_name.c_str());

}

bool TStorageNoSql::InitBeforeFork_base(int index, const TString &server_hostname, const TString &server_code, const TString &server_start_time, const TString &server_version, TLogsGroupBase *LogsGroupA, TKConfig *configobjA)
{
   bool res = true;

   LogsGroupB = LogsGroupA;
   configobj = configobjA;
   if (configobj != NULL)
      m_db = configobjA->ReadStroka( "nosql", "db", "" );

   SetDatabaseAndCollectionNames();

   return res;
}

void TStorageNoSql::InitAfterFork_base()
{

}

bool TStorageNoSql::Midnight_base()
{
   bool res = true;

   webstat.Midnight();
   monstat.Midnight();

   return res;
}

void TStorageNoSql::EventTick_base()
{


}

TString TStorageNoSql::GetDBCollectionText(TStorageType stortype, const TString &separator)
{
   return GetDB() + separator + GetCollectionName(stortype);
}

bool TStorageNoSql::mongo_read_ip_data(TStorageType stortype, TKIPv6 ip, bool &mongo_err, TMemRecord &data, bool &empty)
{
   bool                    res             = false;
   TString                  db_name         = "";
   TString                  collection_name = "";
   TString                  id              = "";
   nosql::HashMap          hash;

   data.empty      = true;
   data.today.ip   = ip;
   mongo_err       = false;
   empty           = true;
   id              = GetID(stortype, ip);
   db_name         = GetDB();
   collection_name = GetCollectionName(stortype);

   if ( (!db_name.empty()) && (!collection_name.empty()) && (!id.empty()) )
   {
      if (FindOneA(db_name, collection_name, id, hash, mongo_err))
      {
         if (hash.size() > 0)
         {
            TMemRecordSerialization::Deserialize(hash, data);
            empty = false;
         }
         res = true;
      }
   }

   return res;
}

bool TStorageNoSql::mongo_read_ip_data_stat(TStorageType stortype, TKIPv6 ip, bool &mongo_err, TIpStat &data, bool &empty)
{
   bool                    res             = false;
   TString                  db_name         = "";
   TString                  collection_name = "";
   TString                  id              = "";
   nosql::HashMap          hash;

   data.Clear();
   mongo_err       = false;
   empty           = true;
   id              = GetID(stortype, ip);
   db_name         = GetDB();
   collection_name = GetCollectionName(stortype);

   if ( (!db_name.empty()) && (!collection_name.empty()) && (!id.empty()) )
   {
      if (FindOneA(db_name, collection_name, id, hash, mongo_err))
      {
         if (hash.size() > 0)
         {
            TIpStatSerialization::Deserialize(hash, data);
            empty = false;
         }
         res = true;
      }
   }

   return res;
}

bool TStorageNoSql::mongo_update_ip_data(TStorageType stortype, TKIPv6 ip, bool &mongo_err, nosql::HashMap &sets, nosql::HashMap &incrs)
{
   bool res = false;

   if ( (sets.size() > 0) || (incrs.size() > 0) )
   {
      TString                  db_name         = "";
      TString                  collection_name = "";
      TString                  id              = "";
      nosql::HashMap          hash;

      mongo_err       = false;
      id              = GetID(stortype, ip);
      db_name         = GetDB();
      collection_name = GetCollectionName(stortype);
      if ( (!db_name.empty()) && (!collection_name.empty()) && (!id.empty()) )
      {
         if (UpdateA(db_name, collection_name, id, incrs, sets, mongo_err))
         {

            res = true;
         }
      }

   } else
   {
      mongo_err = false;
      res       = true;
   }

   return res;
}

bool TStorageNoSql::mongo_update_id_data(TStorageType stortype, const TString &idA, bool &mongo_err, nosql::HashMap &sets, nosql::HashMap &incrs)
{
   bool res = false;

   if ( (sets.size() > 0) || (incrs.size() > 0) )
   {
      TString                  db_name         = "";
      TString                  collection_name = "";
      TString                  id              = "";
      nosql::HashMap          hash;

      mongo_err       = false;
      id              = idA;
      db_name         = GetDB();
      collection_name = GetCollectionName(stortype);
      if ( (!db_name.empty()) && (!collection_name.empty()) && (!id.empty()) )
      {
         if (UpdateA(db_name, collection_name, id, incrs, sets, mongo_err))
         {

            res = true;
         }
      }

   } else
   {
      mongo_err = false;
      res       = true;
   }

   return res;
}

bool TStorageNoSql::mongo_findandmodify(TStorageType stortype, TKIPv6 ip, bool &mongo_err, const nosql::HashMap& incrs, const nosql::HashMap& sets, nosql::HashMap& hash, bool getnew)
{
   bool res = false;

   if ( (sets.size() > 0) || (incrs.size() > 0) )
   {
      TString                  db_name         = "";
      TString                  collection_name = "";
      TString                  id              = "";

      mongo_err       = false;
      id              = GetID(stortype, ip);
      db_name         = GetDB();
      collection_name = GetCollectionName(stortype);
      if ( (!db_name.empty()) && (!collection_name.empty()) && (!id.empty()) )
      {
         if (FindAndModifyA(db_name, collection_name, id, incrs, sets, hash, getnew, mongo_err ))
         {

            res = true;
         }
      }

   } else
   {
      mongo_err = false;
      res       = true;
   }

   return res;
}

bool TStorageNoSql::mongo_read_banip(TStorageType stortype, TKIPv6 ip, bool &mongo_err, TBanIpBasic &data, bool &empty)
{
   bool                    res             = false;
   TString                  db_name         = "";
   TString                  collection_name = "";
   TString                  id              = "";
   nosql::HashMap          hash;
   TString                  lost_field      = "";

   mongo_err       = false;
   empty           = true;
   id              = GetID(stortype, ip);
   db_name         = GetDB();
   collection_name = GetCollectionName(stortype);

   if ( (!db_name.empty()) && (!collection_name.empty()) && (!id.empty()) )
   {
      if (FindOneA(db_name, collection_name, id, hash, mongo_err))
      {
         if (hash.size() > 0)
         {
            lost_field = "";
            if (!TBanIpBasicSerialization::ExistsAllFields(hash, lost_field))
            {
               if ( (GetLogsGroup() != NULL) && (GetLogsGroup()->ActionLog() != NULL) )
       GetLogsGroup()->ActionLog()->WriteMessageAndDataStatus(KERROR, "STOR_%s:LOST_FIELD_BAN ip=%s: %s", ip.toStroka().c_str(), lost_field.c_str());

            }

            TBanIpBasicSerialization::Deserialize(hash, data);
            empty = false;

         }
         res = true;
      }
   }

   return res;
}

bool TStorageNoSql::mongo_update_banip(TStorageType stortype, TKIPv6 ip, bool &mongo_err, nosql::HashMap &sets, nosql::HashMap &incrs)
{
   return mongo_update_ip_data(stortype, ip, mongo_err, sets, incrs);
}

bool TStorageNoSql::mongo_read_bansetup(bool &mongo_err, TBanSetup &data, bool &empty)
{
   bool                    res             = false;
   TStorageType            stortype        = MST_BANSETUP;
   TKIPv6                  ip              = TKIPv6("127.0.0.1");
   TString                  db_name         = "";
   TString                  collection_name = "";
   TString                  id              = "";
   nosql::HashMap          hash;

   mongo_err       = false;
   empty           = true;
   id              = GetID(stortype, ip);
   db_name         = GetDB();
   collection_name = GetCollectionName(stortype);

   if ( (!db_name.empty()) && (!collection_name.empty()) && (!id.empty()) )
   {
      if (FindOneA(db_name, collection_name, id, hash, mongo_err))
      {
         if (hash.size() > 0)
         {
            TBanSetupSerialization::Deserialize(hash, data);
            empty = false;
         }
         res = true;
      }
   }

   return res;
}

bool TStorageNoSql::mongo_update_bansetup(bool &mongo_err, nosql::HashMap &sets, nosql::HashMap &incrs)
{
   TStorageType stortype = MST_BANSETUP;
   TKIPv6       ip       = TKIPv6("127.0.0.1");

   return mongo_update_ip_data(stortype, ip, mongo_err, sets, incrs);
}

bool TStorageNoSql::mongo_read_rps(TKIPv6 ip, bool &mongo_err, TDSLRps &data, bool &empty)
{
   bool                    res             = false;
   TStorageType            stortype        = MST_RPS;
   TString                  db_name         = "";
   TString                  collection_name = "";
   TString                  id              = "";
   nosql::HashMap          hash;

   mongo_err       = false;
   empty           = true;
   id              = GetID(stortype, ip);
   db_name         = GetDB();
   collection_name = GetCollectionName(stortype);

   if ( (!db_name.empty()) && (!collection_name.empty()) && (!id.empty()) )
   {
      if (FindOneA(db_name, collection_name, id, hash, mongo_err))
      {
         if (hash.size() > 0)
         {
            TDSLRpsSerialization::Deserialize(hash, data);
            empty = false;
         }
         res = true;
      }
   }

   return res;
}

bool TStorageNoSql::mongo_update_rps(TKIPv6 ip, bool &mongo_err, nosql::HashMap &sets, nosql::HashMap &incrs)
{
   return mongo_update_ip_data(MST_RPS, ip, mongo_err, sets, incrs);
}

bool TStorageNoSql::mongo_findandmodify_rps(TKIPv6 ip, bool &mongo_err, const nosql::HashMap& incrs, const nosql::HashMap& sets, nosql::HashMap& hash, bool getnew)
{
   bool res = false;

   if ( (sets.size() > 0) || (incrs.size() > 0) )
   {
      TStorageType            stortype        = MST_RPS;
      TString                  db_name         = "";
      TString                  collection_name = "";
      TString                  id              = "";

      mongo_err       = false;
      id              = GetID(stortype, ip);
      db_name         = GetDB();
      collection_name = GetCollectionName(stortype);
      if ( (!db_name.empty()) && (!collection_name.empty()) && (!id.empty()) )
      {
         if (FindAndModifyA(db_name, collection_name, id, incrs, sets, hash, getnew, mongo_err ))
         {

            res = true;
         }
      }

   } else
   {
      mongo_err = false;
      res       = true;
   }

   return res;
}

i64 TStorageNoSql::mongo_basa_size(TStorageType stortype)
{
   i64      res             = 0;
   TString   db_name         = "";
   TString   collection_name = "";
   bool     mongo_err       = false;

   db_name         = GetDB();
   collection_name = GetCollectionName(stortype);
   if ( (!db_name.empty()) && (!collection_name.empty()) )
   {
      res = SizeA(db_name, collection_name, mongo_err);

      if (mongo_err)
         res = 0;
   }

   return res;
}

bool TStorageNoSql::mongo_find(TStorageType stortype, TVector< nosql::HashMap > &hashes)
{
   bool     res             = false;
   TString   db_name         = "";
   TString   collection_name = "";
   bool     mongo_err       = false;

   db_name         = GetDB();
   collection_name = GetCollectionName(stortype);

   hashes.clear();
   res = FindA(db_name, collection_name, hashes, mongo_err );

   return res;
}

bool TStorageNoSql::mongo_erase(TStorageType stortype, TKIPv6 ip, bool &mongo_err)
{
   bool                    res             = false;
   TString                  db_name         = "";
   TString                  collection_name = "";
   TString                  id              = "";
   nosql::HashMap          hash;

   mongo_err       = false;
   id              = GetID(stortype, ip);
   db_name         = GetDB();
   collection_name = GetCollectionName(stortype);

   if ( (!db_name.empty()) && (!collection_name.empty()) && (!id.empty()) )
   {
      if (EraseA( db_name, collection_name, id, mongo_err ))
      {
         res = true;

      }
   }

   return res;
}

bool TStorageNoSql::spamstat_savedump(const TString &filename, TStorageType stortype, bool& err, TFindToFileReport &report, i64 top_treshold)
{
   bool                    res             = false;
   TString                  db_name         = "";
   TString                  collection_name = "";

   db_name         = GetDB();
   collection_name = GetCollectionName(stortype);

   if ( (!db_name.empty()) && (!collection_name.empty()) )
      res = SPSTSaveDump(filename, db_name, collection_name, err, report, top_treshold);

   return res;
}

bool TStorageNoSql::spamstat_savetop(const TString &filename, TStorageType stortype, bool& err, TFindToFileReport &report, i64 top_treshold)
{
   bool                    res             = false;
   TString                  db_name         = "";
   TString                  collection_name = "";

   db_name         = GetDB();
   collection_name = GetCollectionName(stortype);

   if ( (!db_name.empty()) && (!collection_name.empty()) )
      res = SPSTSaveTop(filename, db_name, collection_name, err, report, top_treshold);

   return res;
}

bool TStorageNoSql::spamstat_savedump_with_sort_by_id(const TString &filename, TStorageType stortype, bool& err, TFindToFileReport &report)
{
   bool                    res             = false;
   TString                  db_name         = "";
   TString                  collection_name = "";

   db_name         = GetDB();
   collection_name = GetCollectionName(stortype);

   if ( (!db_name.empty()) && (!collection_name.empty()) )
      res = SPSTSaveDumpWithSortByID(filename, db_name, collection_name, err, report);

   return res;
}

bool TStorageNoSql::spamstat_savedump_step1(const TString &filename, TStorageType stortype, bool& err, TFindToFileReport &report)
{
   bool                    res             = false;
   TString                  db_name         = "";
   TString                  collection_name = "";

   db_name         = GetDB();
   collection_name = GetCollectionName(stortype);

   if ( (!db_name.empty()) && (!collection_name.empty()) )
      res = SPSTSaveDumpStep1(filename, db_name, collection_name, err, report);

   return res;
}

bool TStorageNoSql::spamstat_savedump_onlybanlist(const TString &filename, TStorageType stortype, bool& err, TFindToFileReport &report)
{
   bool                    res             = false;
   TString                  db_name         = "";
   TString                  collection_name = "";

   db_name         = GetDB();
   collection_name = GetCollectionName(stortype);

   if ( (!db_name.empty()) && (!collection_name.empty()) )
      res = SPSTSaveDumpOnlyBanList(filename, db_name, collection_name, err, report);

   return res;
}

TString TStorageNoSql::AnyValueByTypeToStr(nosql::HashMap::iterator &hit, TFindToFileReport &counters)
 {
   TString recstr = "";
   TString tstr   = "";

   switch ((*hit).second.Type())
   {
   case nosql::AnyValue::NOTYPE:
                           recstr += (*hit).first + "=#" + IntToStroka(nosql::AnyValue::NOTYPE) + "''&";
                           counters.count_by_type[static_cast<int>(nosql::AnyValue::NOTYPE)] = IncMax64(counters.count_by_type[static_cast<int>(nosql::AnyValue::NOTYPE)], 1);
                           break;
   case nosql::AnyValue::INTEGER:
                           recstr += (*hit).first + "=#" + IntToStroka(nosql::AnyValue::INTEGER) + "'" + IntToStroka((*hit).second.Integer()) + "'&";
                           counters.count_by_type[static_cast<int>(nosql::AnyValue::INTEGER)] = IncMax64(static_cast<int>(counters.count_by_type[nosql::AnyValue::INTEGER]), 1);
                           break;
   case nosql::AnyValue::INTEGER64:
                           recstr += (*hit).first + "=#" + IntToStroka(nosql::AnyValue::INTEGER64) + "'" + I64ToStroka((*hit).second.Long()) + "'&";
                           counters.count_by_type[static_cast<int>(nosql::AnyValue::INTEGER64)] = IncMax64(static_cast<int>(counters.count_by_type[nosql::AnyValue::INTEGER64]), 1);
                           break;
   case nosql::AnyValue::DOUBLE:
                           recstr += (*hit).first + "=#" + IntToStroka(nosql::AnyValue::DOUBLE) + "'" + DoubleToStr((*hit).second.Double()) + "'&";
                           counters.count_by_type[static_cast<int>(nosql::AnyValue::DOUBLE)] = IncMax64(counters.count_by_type[static_cast<int>(nosql::AnyValue::DOUBLE)], 1);
                           break;
   case nosql::AnyValue::VECTOR:
                           recstr += (*hit).first + "=#" + IntToStroka(nosql::AnyValue::VECTOR) + "''&";
                           counters.count_by_type[static_cast<int>(nosql::AnyValue::VECTOR)] = IncMax64(counters.count_by_type[static_cast<int>(nosql::AnyValue::VECTOR)], 1);
                           break;
   case nosql::AnyValue::STRING:
                           tstr = (*hit).second.String();
                           CGIEscape(tstr);
                           recstr += (*hit).first + "=#" + IntToStroka(nosql::AnyValue::STRING) + "'" + tstr + "'&";
                           counters.count_by_type[static_cast<int>(nosql::AnyValue::STRING)] = IncMax64(counters.count_by_type[static_cast<int>(nosql::AnyValue::STRING)], 1);
                           break;
   case nosql::AnyValue::LIST:
                           recstr += (*hit).first + "=#" + IntToStroka(nosql::AnyValue::LIST) + "''&";
                           counters.count_by_type[static_cast<int>(nosql::AnyValue::LIST)] = IncMax64(counters.count_by_type[static_cast<int>(nosql::AnyValue::LIST)], 1);
                           break;
   case nosql::AnyValue::HASH:
                           recstr += (*hit).first + "=#" + IntToStroka(nosql::AnyValue::HASH) + "''&";
                           counters.count_by_type[static_cast<int>(nosql::AnyValue::HASH)] = IncMax64(counters.count_by_type[static_cast<int>(nosql::AnyValue::HASH)], 1);
                           break;
   };

   return recstr;
 }

 TString TStorageNoSql::GetDataToLog(nosql::HashMap &hash, TFindToFileReport &counters, TString &id, TString &ip)
 {
     TString            recstr      = "";
     bool              exists_data = false;
     nosql::HashMap::iterator hit;

     id = "";
     ip = "";

     hit = hash.find("ip");
     if (hit != hash.end())
     {
        exists_data = true;
        ip = AnyValueByTypeToStr(hit, counters);
        recstr += ip;
     }

     hit = hash.find("_id");
     if (hit != hash.end())
     {
        exists_data = true;
        id = AnyValueByTypeToStr(hit, counters);
        recstr += id;
     }

     hit = hash.begin();
     while (hit != hash.end())
     {
         if ((*hit).first == "ip")
         {
            ++hit;
            continue;
         }

         if ((*hit).first == "_id")
         {
            ++hit;
            continue;
         }

         exists_data = true;
         recstr += AnyValueByTypeToStr(hit, counters);

         ++hit;
     }
     if (!exists_data)
       counters.empty_data = IncMax64(counters.empty_data, 1);

     return recstr;
 }

 TString TStorageNoSql::GetCollectionName(stor_bt::TShingleStorageType sstype, int type)
 {
  TString res = "";
  char tbuff[128];
  time_t t;
  tm  ttm;
  ui16 year = 0, mon = 0, day = 0;

  switch (sstype)
  {
  case stor_bt::SST_USRCOLL_01:
          res = m_usercoll_01_name;
          break;
  case stor_bt::SST_USRCOLL_02:
          res = m_usercoll_02_name;
          break;
  case stor_bt::SST_USRCOLL_03:
          res = m_usercoll_03_name;
          break;
  case stor_bt::SST_USRCOLL_04:
          res = m_usercoll_04_name;
          break;
  case stor_bt::SST_USRCOLL_05:
          res = m_usercoll_05_name;
          break;
  case stor_bt::SST_USRCOLL_06:
          res = m_usercoll_06_name;
          break;
  case stor_bt::SST_USRCOLL_07:
          res = m_usercoll_07_name;
          break;
  case stor_bt::SST_STAT:
          res = m_statcoll_name;
          break;
  };

  return res;
 };

void TStorageNoSql::IncrementStat(stor_bt::TShingleStorageType sstype, bool res)
{ /*
   switch (sstype)
   {
   case SST_USERREP:
   if (res)
   m_good_shinww_storage.Increment();
   else
   m_error_shinww_storage.Increment();

   break;
   case SST_STAT:
   if (res)
   m_good_stat_storage.Increment();
   else
   m_error_stat_storage.Increment();
   break;
   };
   */
 };

 void TStorageNoSql::AddStorageStat(stor_bt::TShingleStorageType stortype, stor_bt::TStorageActionType acttype, int count, NStorageStats::TSRSErrType good, ui32 tick)
 {
  NStorageStats::TStorageRequestStat::TStorageActionType acttype_cnv = NStorageStats::TStorageRequestStat::SAT_UPDATE;

  switch (acttype)
  {
  case stor_bt::SAT_UPDATE:
         acttype_cnv = NStorageStats::TStorageRequestStat::SAT_UPDATE;
         break;
  case stor_bt::SAT_FINDONE:
         acttype_cnv = NStorageStats::TStorageRequestStat::SAT_FINDONE;
         break;
  case stor_bt::SAT_ERASE:
         acttype_cnv = NStorageStats::TStorageRequestStat::SAT_ERASE;
         break;
  case stor_bt::SAT_SIZE:
         acttype_cnv = NStorageStats::TStorageRequestStat::SAT_SIZE;
         break;
  case stor_bt::SAT_MULTYACTION:
         acttype_cnv = NStorageStats::TStorageRequestStat::SAT_MULTYACTION;
         break;
  case stor_bt::SAT_FIND:
         acttype_cnv = NStorageStats::TStorageRequestStat::SAT_FIND;
         break;
  };

  switch (stortype)
  {
  case stor_bt::SST_USRCOLL_01:
          webstat.AddCount(m_database_name, m_usercoll_01_name, acttype_cnv, count, good, tick);
          monstat.AddCount(m_database_name, m_usercoll_01_name, acttype_cnv, count, good, tick);
          break;
  case stor_bt::SST_USRCOLL_02:
          webstat.AddCount(m_database_name, m_usercoll_02_name, acttype_cnv, count, good, tick);
          monstat.AddCount(m_database_name, m_usercoll_02_name, acttype_cnv, count, good, tick);
          break;
  case stor_bt::SST_USRCOLL_03:
          webstat.AddCount(m_database_name, m_usercoll_03_name, acttype_cnv, count, good, tick);
          monstat.AddCount(m_database_name, m_usercoll_03_name, acttype_cnv, count, good, tick);
          break;
  case stor_bt::SST_USRCOLL_04:
          webstat.AddCount(m_database_name, m_usercoll_04_name, acttype_cnv, count, good, tick);
          monstat.AddCount(m_database_name, m_usercoll_04_name, acttype_cnv, count, good, tick);
          break;
  case stor_bt::SST_USRCOLL_05:
          webstat.AddCount(m_database_name, m_usercoll_05_name, acttype_cnv, count, good, tick);
          monstat.AddCount(m_database_name, m_usercoll_05_name, acttype_cnv, count, good, tick);
          break;
  case stor_bt::SST_USRCOLL_06:
          webstat.AddCount(m_database_name, m_usercoll_06_name, acttype_cnv, count, good, tick);
          monstat.AddCount(m_database_name, m_usercoll_06_name, acttype_cnv, count, good, tick);
          break;
  case stor_bt::SST_USRCOLL_07:
          webstat.AddCount(m_database_name, m_usercoll_07_name, acttype_cnv, count, good, tick);
          monstat.AddCount(m_database_name, m_usercoll_07_name, acttype_cnv, count, good, tick);
          break;
  case stor_bt::SST_STAT:
          webstat.AddCount(m_database_name, m_statcoll_name, acttype_cnv, count, good, tick);
          monstat.AddCount(m_database_name, m_statcoll_name, acttype_cnv, count, good, tick);
          break;
  };
 }

//*******************************************************************************************************************************
