#pragma once

#include <util/generic/string.h>
#include <mail/so/spamstop/tools/so-common/anyvalue.h>
#include <mail/so/spamstop/tools/so-common/tkipv6.h>
#include <mail/so/spamstop/tools/so-common/tkconfig.h>
#include <mail/so/spamstop/tools/so-common/tstoragerequeststat.h>
#include <mail/so/spamstop/tools/so-common/tbasestoragetypes.h>
#include "tbasesstore_types.h"
#include "tbaniplist_types.h"
#include "tlogsgroup.h"
#include "tspamstat_stor_stat.h"

//*******************************************************************************************************************************
//                                                    TStorageNoSql
//*******************************************************************************************************************************

enum TStorageType {MST_UNKNOWN, MST_MEMBASE, MST_MEMSTAT, MST_BANIP, MST_BAN7IP, MST_BANSETUP, MST_RPS};

class TStorageNoSql: public stor_bt::TStorageNoSqlBase
{
public:
         TKConfig                *configobj;
         TString                 m_db;

         TString                      GetDB();
         TString                      GetCollectionName(TStorageType stortype);
   stor_bt::TShingleStorageType GetCollectionName2(TStorageType stortype);
   stor_bt::TShingleStorageType GetCollectionNameFromType(const TString &str);
         TString                      GetID(TStorageType stortype, TKIPv6 ip);
   ui64                         GetID2(TStorageType stortype, TKIPv6 ip);

         bool                    FindOneA( TString db, TString collection, TString id, nosql::HashMap& hash, bool& err );
         bool                    UpdateA( TString db, TString collection, TString id, const nosql::HashMap& incrs, const nosql::HashMap& sets, bool& err);
         bool                    FindAndModifyA( TString db, TString collection, TString id, const nosql::HashMap& incrs, const nosql::HashMap& sets, nosql::HashMap& hash, bool getnew, bool& err );
         i64                     SizeA( TString db, TString collection, bool& err);
         bool                    FindA( TString db, TString collection, TVector< nosql::HashMap >& hashes, bool& err );
         bool                    EraseA( TString db, TString collection, TString id, bool& err );
   void                    SetDatabaseAndCollectionNames();

public:
         virtual bool            InitBeforeFork(const TString &server_hostname, const TString &server_code, const TString &server_start_time, const TString &server_version, TLogsGroup *LogsGroupA, TKConfig *configobjA) = 0;
         virtual void            InitAfterFork() = 0;
         virtual bool            Midnight() = 0;
         virtual void            EventTick() = 0;

         virtual bool            FindOne( TString db, TString collection, TString id, nosql::HashMap& hash, bool& err ) = 0;
         virtual bool            Update( TString db, TString collection, TString id, const nosql::HashMap& incrs, const nosql::HashMap& sets, bool& err) = 0;
         virtual bool            FindAndModify( TString db, TString collection, TString id, const nosql::HashMap& incrs, const nosql::HashMap& sets, nosql::HashMap& hash, bool getnew, bool& err ) = 0;
         virtual i64             Size( TString db, TString collection, bool& err) = 0;
         virtual bool            Find( TString db, TString collection, TVector< nosql::HashMap >& hashes, bool& err ) = 0;
         virtual bool            Erase( TString db, TString collection, TString id, bool& err ) = 0;

         virtual bool            SPSTSaveDump( const TString &filename, TString db, TString collection, bool& err, TFindToFileReport &report, i64 top_treshold ) = 0;
         virtual bool            SPSTSaveTop( const TString &filename, TString db, TString collection, bool& err, TFindToFileReport &report, i64 top_treshold ) = 0;
         virtual bool            SPSTSaveDumpWithSortByID( const TString &filename, TString db, TString collection, bool& err, TFindToFileReport &report ) = 0;
         virtual bool            SPSTSaveDumpStep1( const TString &filename, TString db, TString collection, bool& err, TFindToFileReport &report ) = 0;
         virtual bool            SPSTSaveDumpOnlyBanList( const TString &filename, TString db, TString collection, bool& err, TFindToFileReport &report ) = 0;

public:
         TStorageNoSql();
         virtual ~TStorageNoSql();

         bool             InitBeforeFork_base(int index, const TString &server_hostname, const TString &server_code, const TString &server_start_time, const TString &server_version, TLogsGroupBase *LogsGroupA, TKConfig *configobjA);
         void             InitAfterFork_base();
         bool             Midnight_base();
         void             EventTick_base();

   TLogsGroup       *GetLogsGroup() { return (TLogsGroup *)LogsGroupB; }

         TString          GetDBCollectionText(TStorageType stortype, const TString &separator);

         bool             mongo_read_ip_data(TStorageType stortype, TKIPv6 ip, bool &mongo_err, TMemRecord &data, bool &empty);
         bool             mongo_read_ip_data_stat(TStorageType stortype, TKIPv6 ip, bool &mongo_err, TIpStat &data, bool &empty);
         bool             mongo_update_ip_data(TStorageType stortype, TKIPv6 ip, bool &mongo_err, nosql::HashMap &sets, nosql::HashMap &incrs);
         bool             mongo_update_id_data(TStorageType stortype, const TString &idA, bool &mongo_err, nosql::HashMap &sets, nosql::HashMap &incrs);
         bool             mongo_findandmodify(TStorageType stortype, TKIPv6 ip, bool &mongo_err, const nosql::HashMap& incrs, const nosql::HashMap& sets, nosql::HashMap& hash, bool getnew);

         bool             mongo_read_banip(TStorageType stortype, TKIPv6 ip, bool &mongo_err, TBanIpBasic &data, bool &empty);
         bool             mongo_update_banip(TStorageType stortype, TKIPv6 ip, bool &mongo_err, nosql::HashMap &sets, nosql::HashMap &incrs);
         bool             mongo_read_bansetup(bool &mongo_err, TBanSetup &data, bool &empty);
         bool             mongo_update_bansetup(bool &mongo_err, nosql::HashMap &sets, nosql::HashMap &incrs);

         bool             mongo_read_rps(TKIPv6 ip, bool &mongo_err, TDSLRps &data, bool &empty);
         bool             mongo_update_rps(TKIPv6 ip, bool &mongo_err, nosql::HashMap &sets, nosql::HashMap &incrs);
         bool             mongo_findandmodify_rps(TKIPv6 ip, bool &mongo_err, const nosql::HashMap& incrs, const nosql::HashMap& sets, nosql::HashMap& hash, bool getnew);

         i64              mongo_basa_size(TStorageType stortype);
         bool             mongo_find(TStorageType stortype, TVector< nosql::HashMap > &hashes);
         bool             mongo_erase(TStorageType stortype, TKIPv6 ip, bool &mongo_err);

         bool             spamstat_savedump(const TString &filename, TStorageType stortype, bool& err, TFindToFileReport &report, i64 top_treshold);
         bool             spamstat_savetop(const TString &filename, TStorageType stortype, bool& err, TFindToFileReport &report, i64 top_treshold);
         bool             spamstat_savedump_with_sort_by_id(const TString &filename, TStorageType stortype, bool& err, TFindToFileReport &report);
         bool             spamstat_savedump_step1(const TString &filename, TStorageType stortype, bool& err, TFindToFileReport &report);
         bool             spamstat_savedump_onlybanlist(const TString &filename, TStorageType stortype, bool& err, TFindToFileReport &report);

         static TString   AnyValueByTypeToStr(nosql::HashMap::iterator &hit, TFindToFileReport &counters);
         static TString   GetDataToLog(nosql::HashMap &hash, TFindToFileReport &counters, TString &id, TString &ip);

   TString          GetCollectionName(stor_bt::TShingleStorageType sstype, int type);
   void             IncrementStat(stor_bt::TShingleStorageType sstype, bool res);
   void             AddStorageStat(stor_bt::TShingleStorageType stortype, stor_bt::TStorageActionType acttype, int count, NStorageStats::TSRSErrType good, ui32 tick);
};

//*******************************************************************************************************************************

