#include "ttrap.h"

TTrap::TTrap()
{
   query_count = 0;
   fquit       = false;
}

TTrap::~TTrap()
{
   Quit();

   while (query_count > 0)
      ::usleep(50000);
}

void TTrap::Quit()
{
   m_Mutex.Acquire();
   fquit = true;
   m_Mutex.Release();
}

bool TTrap::AddMail(TKIPv6 ip, const TString &mail)
{
   bool           res = false;
   TTrapsHashIt   it;

   m_Mutex.Acquire();

   it = data.find(ip);
   if (it != data.end())
   {
      (*it).second.mailcount++;
      (*it).second.mails = (*it).second.mails + mail;
   }

   m_Mutex.Release();

   return res;
}

TString TTrap::EncodeStroka(TString s)
{
   TString      res = "";
   const char  *pb = NULL, *pe = NULL;
   TString      st = "", st1 = "";

   pb = s.c_str();
   pe = strstr(pb, "\n");
   if (pe != NULL)
   {
      while (pe != NULL)
      {
         st = TString(pb, pe - pb);

         st1 = "";
         for (int i = 0; i < st.size(); i++)
         {
            switch (st[i])
            {
               case '&':
                        st1 = st1 + "&amp;";
                        break;
               case '<':
                        st1 = st1 + "&lt;";
                        break;
               case '>':
                        st1 = st1 + "&gt;";
                        break;
               case '"':
                        st1 = st1 + "&quot;";
                        break;
               default:
                        st1 = st1 + st[i];
            };
         }
         if (strstr(st1.c_str(), "subj:") != NULL)
            st1 = "<B>" + st1 + "</B>";
         else if (strstr(st1.c_str(), "MESSAGEID:") != NULL)
            st1 = "<B><font color='green'>" + st1 + "</font></B>";
         res = res + st1 + "<br>";
         pb = pe + 1;
         pe = strstr(pb, "\n");
      }

      st = TString(pb);
      st1 = "";
      for (int i = 0; i < st.size(); i++)
      {
            switch (st[i])
            {
               case '&':
                        st1 = st1 + "&amp;";
                        break;
               case '<':
                        st1 = st1 + "&lt;";
                        break;
               case '>':
                        st1 = st1 + "&gt;";
                        break;
               case '"':
                        st1 = st1 + "&quot;";
                        break;
               default:
                        st1 = st1 + st[i];
            };
      }
      if (strstr(st1.c_str(), "subj:") != NULL)
         st1 = "<B>" + st1 + "</B>";
      else if (strstr(st1.c_str(), "MESSAGEID:") != NULL)
         st1 = "<B><font color='green'>" + st1 + "</font></B>";
      res = res + st1 + "<br>";

   } else
      res = s;

   return res;
}

TString TTrap::GetMail(TKIPv6 ip, ui32 delay, bool less)
{
   TString         res      = "";
   bool           flag     = false;
   TTrapsHashIt   it;
   time_t         tcurrent = time(NULL);
   bool           fexit    = false;
   time_t         t        = 0;
   TString         st       = "";

   m_Mutex.Acquire();
   query_count++;

   it = data.find(ip);
   if (it != data.end())
      data.erase(it);

   data[ip] = TTrapData();

   m_Mutex.Release();

   while (!flag)
   {
      tcurrent = time(NULL);

      m_Mutex.Acquire();

      if (!fquit)
      {
         it = data.find(ip);
         if (it != data.end())
         {
            if ((*it).second.mailcount > 0)
            {
               st = (*it).second.mails;
               if (less)
                  res = (*it).second.mails;
               else
                  res = EncodeStroka((*it).second.mails);
               data.erase(it);
               flag = true;
            } else if ((tcurrent - (*it).second.query_time) > delay)
            {
               if (less)
                  res = "no mail (timeout = " + IntToStroka(delay) + " sec)";
               else
                  res = EncodeStroka("no mail (timeout = " + IntToStroka(delay) + " sec)");
               data.erase(it);
               flag = true;
            }
         }
      }

      fexit = fquit;

      m_Mutex.Release();

      if (fexit)
         break;

      if (!flag)
         ::sleep(1);
   }

   m_Mutex.Acquire();
   query_count--;
   m_Mutex.Release();

   return res;
}
