#pragma once

#include <util/system/mutex.h>
#include <mail/so/spamstop/tools/so-common/kfunc.h>
#include <mail/so/spamstop/tools/so-common/tkipv6.h>
#include <time.h>

struct TTrapData
{
  ui8    mailcount;   //����� ���������� ����� � �������
  TString mails;       //���������� ���������� �����
  time_t query_time;  //����� ���������� �������

   TTrapData()
   {
      Clear();
      query_time = time(NULL);
   }

   ~TTrapData()
   {

   }

   void Clear()
   {
      mailcount  = 0;
      mails      = "";
      query_time = 0;
   }

};


typedef THashMap<TKIPv6, TTrapData> TTrapsHash;
typedef TTrapsHash::iterator     TTrapsHashIt;

class TTrap
{
private:
         TMutex               m_Mutex;
         TTrapsHash           data;
         volatile ui32        query_count;
         volatile bool        fquit;

         TString               EncodeStroka(TString s);
public:
         TTrap();
         ~TTrap();

         bool   AddMail(TKIPv6 ip, const TString &mail);
         TString GetMail(TKIPv6 ip, ui32 delay, bool less);
         void   Quit();
};

