#include "twritedisk.h"

#ifndef _win_
#include <unistd.h>
#include <sys/syscall.h>
#endif

//*************************************************************************************
//                                TWriteDiskQueue
//*************************************************************************************

TWriteDiskQueue::TWriteDiskQueue(TLogsGroup* LogsGroupA, const TString& ident) {
    m_today_in_count = 0;
    m_today_out_count = 0;
    m_today_lost_count = 0;
    m_yesterday_in_count = 0;
    m_yesterday_out_count = 0;
    m_yesterday_lost_count = 0;
    LogsGroup = LogsGroupA;
    m_ident = ident;
    m_cps = 0;
    m_request = 0;
    m_last_calc_cps = time(nullptr);
    m_stop_event = false;
}

TWriteDiskQueue::~TWriteDiskQueue() {
    TLockWBRDataListIt it;

    it = blist.begin();
    while (it != blist.end()) {
        if ((*it) != nullptr) {
            if ((*it)->buff != nullptr) {
                delete (*it)->buff;
                (*it)->buff = nullptr;
            }
            delete (*it);
            (*it) = nullptr;
        }

        ++it;
    }
    blist.clear();
}

void TWriteDiskQueue::SendEvent() {
    m_Event.Signal();
}

void TWriteDiskQueue::WaitEvent() {
    m_Event.Wait(1000);
    if (!m_stop_event)
        m_Event.Reset();
}

void TWriteDiskQueue::UnBlockAllEvent() {
    m_stop_event = true;
    SendEvent();
}

void TWriteDiskQueue::Lock() {
    m_Mutex.Acquire();
}

void TWriteDiskQueue::UnLock() {
    m_Mutex.Release();
}

void TWriteDiskQueue::CalcCPS() {
    time_t currenttime = time(nullptr);
    if ((currenttime - m_last_calc_cps) >= 10) {
        m_cps = (float)m_request / (float)(currenttime - m_last_calc_cps);
        m_last_calc_cps = currenttime;
        m_request = 0;
    } else {
        m_request = (m_request < 0xFFFFFFFF) ? (m_request + 1) : 0xFFFFFFFF;
    }
}

void TWriteDiskQueue::ReCalcCPS() {
    time_t currenttime = time(nullptr);
    if ((currenttime - m_last_calc_cps) >= 10) {
        m_cps = (float)m_request / (float)(currenttime - m_last_calc_cps);
        m_last_calc_cps = currenttime;
        m_request = 0;
    }
}

void TWriteDiskQueue::Add(TWriteBuffRec* value) {
    if (true) {
        bool lost = false;

        Lock();

        CalcCPS();

        m_today_in_count = (m_today_in_count < 0xFFFFFFFFFFFFFFFF) ? (m_today_in_count + 1) : 0xFFFFFFFFFFFFFFFF;

        if (blist.size() < MAX_ELEMENT_COUNT) {
            blist.push_back(value);
        } else {
            lost = true;
            m_today_lost_count = (m_today_lost_count < 0xFFFFFFFFFFFFFFFF) ? (m_today_lost_count + 1) : 0xFFFFFFFFFFFFFFFF;
        }

        UnLock();

        SendEvent();

        if ((lost) && (LogsGroup != nullptr) && (LogsGroup->ActionLog() != nullptr))
            LogsGroup->ActionLog()->WriteMessageAndDataStatus(KERROR, "WRITEDISKBUFF(%s): Cant's add data to queue, queue is full.", m_ident.c_str());
    }
}

TWriteBuffRec* TWriteDiskQueue::Get() {
    TWriteBuffRec* res = nullptr;
    TLockWBRDataListIt it;

    Lock();

    it = blist.begin();
    if (it != blist.end()) {
        res = (*it);
        blist.erase(it);
        m_today_out_count = (m_today_out_count < 0xFFFFFFFFFFFFFFFF) ? (m_today_out_count + 1) : 0xFFFFFFFFFFFFFFFF;
    } else {
        ReCalcCPS();
    }

    UnLock();

    return res;
}

TWriteBuffRec* TWriteDiskQueue::GetEvent() {
    TWriteBuffRec* res = nullptr;
    TLockWBRDataListIt it;

    //WaitEvent();
    Lock();

    it = blist.begin();
    if (it != blist.end()) {
        res = (*it);
        blist.erase(it);
        m_today_out_count = (m_today_out_count < 0xFFFFFFFFFFFFFFFF) ? (m_today_out_count + 1) : 0xFFFFFFFFFFFFFFFF;
    } else {
        ReCalcCPS();
    }

    UnLock();

    return res;
}

void TWriteDiskQueue::Midnight() {
    Lock();

    m_yesterday_in_count = m_today_in_count;
    m_yesterday_out_count = m_today_out_count;
    m_yesterday_lost_count = m_today_lost_count;
    m_today_in_count = 0;
    m_today_out_count = 0;
    m_today_lost_count = 0;

    UnLock();
}

TWriteDiskQueueStat TWriteDiskQueue::GetStat() {
    TWriteDiskQueueStat res;

    res.m_today_count = blist.size();
    res.m_today_in_count = m_today_in_count;
    res.m_today_out_count = m_today_out_count;
    res.m_today_lost_count = m_today_lost_count;
    res.m_yesterday_in_count = m_yesterday_in_count;
    res.m_yesterday_out_count = m_yesterday_out_count;
    res.m_yesterday_lost_count = m_yesterday_lost_count;
    res.m_cps = m_cps;

    return res;
}

void TWriteDiskQueue::Shutdown() {
    UnBlockAllEvent();
}

//*************************************************************************************
//                                TWriteDataDisk
//*************************************************************************************

TWriteDataDisk::TWriteDataDisk() {
    m_handle = nullptr;
    m_filename = "";
    m_write = true;
}

TWriteDataDisk::~TWriteDataDisk() {
    if (m_handle != nullptr) {
        fclose(m_handle);
        m_handle = nullptr;
    }
}

void TWriteDataDisk::Lock() {
    m_Mutex.Acquire();
}

void TWriteDataDisk::UnLock() {
    m_Mutex.Release();
}

void TWriteDataDisk::Init(TString filename, bool write) {
    m_filename = filename;
    m_write = write;
}

bool TWriteDataDisk::Write(char* BUFF, size_t sizebuff) {
    bool res = false;
    size_t count = 0;

    Lock();

    if (m_write) {
        if (m_handle == nullptr)
            m_handle = fopen(m_filename.c_str(), "a+b");
        if ((m_handle != nullptr) && (sizebuff > 0)) {
            count = fwrite(BUFF, sizebuff, 1, m_handle);
            if (count == 1)
                res = true;
        }
    }

    UnLock();

    return res;
}

bool TWriteDataDisk::ExistsFile(TString filename) {
    bool res = false;
    FILE* handle = nullptr;

    handle = fopen(filename.c_str(), "rb");
    if (handle != nullptr) {
        res = true;
        fclose(handle);
    }

    return res;
}

bool TWriteDataDisk::Rotate() {
    bool res = false;
    TString newfilename = "";
    int err = 0;

    Lock();

    if (m_write) {
        newfilename = m_filename + ".0";

        if (m_handle != nullptr) {
            fclose(m_handle);
            m_handle = nullptr;
        }
        //if (ExistsFile(newfilename.c_str()))
        //   err = remove(newfilename.c_str());
        if (ExistsFile(newfilename.c_str()))
            err = 1;
        if (err == 0) {
            err = rename(m_filename.c_str(), newfilename.c_str());
            if (err == 0) {
                res = true;
                if (m_write)
                    m_handle = fopen(m_filename.c_str(), "a+b");
            }
        }
    } else {
        res = true;
    }

    UnLock();

    return res;
}

//*************************************************************************************
//                                TWriteDataDisk2
//*************************************************************************************

TWriteDataDisk2::TWriteDataDisk2() {
    m_handle = nullptr;
    m_filename = "";
    m_filename_index = "";
    m_write = true;
    LogsGroup = nullptr;
    m_queue = nullptr;
    m_flushdel = 10;
    m_StopThread = false;
    m_Thread = nullptr;
    m_alllog = nullptr;
    m_mailcount = 0;
}

TWriteDataDisk2::~TWriteDataDisk2() {
    //if ( (LogsGroup != nullptr) && (LogsGroup->ActionLog() != nullptr))
    //   LogsGroup->ActionLog()->WriteMessageAndDataStatus(KWARNING, "WDD: step1");

    if (m_Thread != nullptr) {
        StopThread();
        while (!ThreadStopped())
            ::sleep(1);
        delete m_Thread;
        m_Thread = nullptr;
    }

    //if ( (LogsGroup != nullptr) && (LogsGroup->ActionLog() != nullptr))
    //   LogsGroup->ActionLog()->WriteMessageAndDataStatus(KWARNING, "WDD: step2");

    if (m_queue != nullptr) {
        delete m_queue;
        m_queue = nullptr;
    }

    //if ( (LogsGroup != nullptr) && (LogsGroup->ActionLog() != nullptr))
    //   LogsGroup->ActionLog()->WriteMessageAndDataStatus(KWARNING, "WDD: step3");

    if (m_handle != nullptr) {
        fclose(m_handle);
        m_handle = nullptr;
    }

    //if ( (LogsGroup != nullptr) && (LogsGroup->ActionLog() != nullptr))
    //   LogsGroup->ActionLog()->WriteMessageAndDataStatus(KWARNING, "WDD: step4");

    if (m_alllog != nullptr) {
        delete m_alllog;
        m_alllog = nullptr;
    }

    //if ( (LogsGroup != nullptr) && (LogsGroup->ActionLog() != nullptr))
    //   LogsGroup->ActionLog()->WriteMessageAndDataStatus(KWARNING, "WDD: step5");
}

void TWriteDataDisk2::Lock() {
    m_Mutex.Acquire();
}

void TWriteDataDisk2::UnLock() {
    m_Mutex.Release();
}

bool TWriteDataDisk2::InitBeforeFork(const TString& filename, const TString& filenameindex, bool write, TLogsGroup* LogsGroupA) {
    bool res = true;

    m_filename = filename;
    m_filename_index = filenameindex;
    m_MutexWrite.Acquire();
    m_write = write;
    m_MutexWrite.Release();
    LogsGroup = LogsGroupA;
    m_queue = new TWriteDiskQueue(LogsGroup, "writeindata");

    return res;
}

bool TWriteDataDisk2::InitAfterFork() {
    bool res = true;

    StartThread();

    return res;
}

bool TWriteDataDisk2::Write(const char* BUFF, size_t sizebuff) {
    bool res = true;
    TWriteBuffRec* qrec = nullptr;

    if ((m_write) && (m_queue != nullptr)) {
        qrec = new TWriteBuffRec(BUFF, sizebuff);
        if (qrec != nullptr)
            m_queue->Add(qrec);
    }

    return res;
}

bool TWriteDataDisk2::WriteDisk(char* BUFF, size_t sizebuff, ui32 flushdelA) {
    bool res = false;
    i32 count = 0;
    i64 start_pos = 0;
    unsigned int openmode = 0;
    TString openmodeindex = "";
    ui32 flushdel = flushdelA;

    Lock();

    if (m_write) {
        if (m_alllog == nullptr) {
            try {
                m_alllog = new TFile(m_filename, OpenAlways | RdWr);
                if ((m_alllog != nullptr) && (m_alllog->IsOpen()))
                    m_alllog->Seek(0, sEnd);
                else {
                    if (m_alllog != nullptr) {
                        delete m_alllog;
                        m_alllog = nullptr;
                    }
                }
            } catch (...) {
                if (m_alllog != nullptr) {
                    delete m_alllog;
                    m_alllog = nullptr;
                }
            }
        }
        if ((m_alllog != nullptr) && (m_alllog->IsOpen()) && (BUFF != nullptr) && (sizebuff > 0)) {
            start_pos = m_alllog->GetPosition();
            try {
                m_alllog->Write(BUFF, sizebuff);
                res = true;

                if (m_handle == nullptr) {
                    if (ExistsFile(m_filename_index))
                        openmodeindex = "a+b";
                    else
                        openmodeindex = "wb";
                    m_handle = fopen(m_filename_index.c_str(), openmodeindex.c_str());
                    if (m_handle != nullptr)
                        fseek(m_handle, 0, SEEK_END);
                }
                if (m_handle != nullptr) {
                    if (fprintf(m_handle, "<ADLI pos='%lld' size='%u'>\n", start_pos, sizebuff) >= 0) {
                        m_mailcount++;
                        if (flushdel != 0) {
                            if ((m_mailcount % flushdel) == 0) {
                                m_alllog->Flush();
                                if (m_handle != nullptr)
                                    fflush(m_handle);
                            }
                        }
                    } else {
                        fclose(m_handle);
                        m_handle = nullptr;
                        if ((LogsGroup != nullptr) && (LogsGroup->ActionLog() != nullptr))
                            LogsGroup->ActionLog()->WriteMessageAndDataStatus(KERROR, "WD: Bad write to savemessfileindex.");
                    }
                }
            } catch (...) {
                if (m_alllog != nullptr) {
                    delete m_alllog;
                    m_alllog = nullptr;
                }

                if ((LogsGroup != nullptr) && (LogsGroup->ActionLog() != nullptr))
                    LogsGroup->ActionLog()->WriteMessageAndDataStatus(KERROR, "WD: Bad write to savemessfile.");
            }

        } else {
            if (m_alllog != nullptr) {
                delete m_alllog;
                m_alllog = nullptr;
            }
            if ((LogsGroup != nullptr) && (LogsGroup->ActionLog() != nullptr))
                LogsGroup->ActionLog()->WriteMessageAndDataStatus(KERROR, "WD: Bad write to savemessfile.");
        }
    }

    UnLock();

    return res;
}

bool TWriteDataDisk2::ExistsFile(TString filename) {
    bool res = false;
    FILE* handle = nullptr;

    handle = fopen(filename.c_str(), "rb");
    if (handle != nullptr) {
        res = true;
        fclose(handle);
    }

    return res;
}

bool TWriteDataDisk2::Rotate() {
    bool res = false;
    TString newfilename = "";
    int err = 0;
    unsigned int openmode = 0;
    TString openmodeindex = "";

    Lock();

    if (m_write) {
        if (m_alllog != nullptr) {
            delete m_alllog;
            m_alllog = nullptr;
        }

        if (m_handle != nullptr) {
            fclose(m_handle);
            m_handle = nullptr;
        }

        if (m_alllog == nullptr) {
            try {
                m_alllog = new TFile(m_filename, OpenAlways | RdWr);
                if ((m_alllog != nullptr) && (m_alllog->IsOpen()))
                    m_alllog->Seek(0, sEnd);
                else {
                    if (m_alllog != nullptr) {
                        delete m_alllog;
                        m_alllog = nullptr;
                    }
                }
            } catch (...) {
                if (m_alllog != nullptr) {
                    delete m_alllog;
                    m_alllog = nullptr;
                }
            }
        }

        if (m_handle == nullptr) {
            if (ExistsFile(m_filename_index))
                openmodeindex = "a+b";
            else
                openmodeindex = "wb";
            m_handle = fopen(m_filename_index.c_str(), openmodeindex.c_str());
            if (m_handle != nullptr)
                fseek(m_handle, 0, SEEK_END);
        }

        if ((m_alllog != nullptr) && (m_alllog->IsOpen()) && (m_handle != nullptr))
            res = true;

    } else {
        res = true;
    }

    UnLock();

    return res;
}

#ifdef WIN32
void /*__stdcall*/ KThreadProc(void* par)
#else
void KThreadProc(void* par)
#endif
{
    TWriteBuffRec* qrec;

    TWriteDataDisk2* bilg = (TWriteDataDisk2*)par;
    while (!bilg->ThreadShouldStop()) {
        if (bilg->GetQueue() != nullptr) {
            qrec = bilg->GetQueue()->GetEvent();
            if (qrec != nullptr) {
                if ((qrec->buff != nullptr) && (qrec->buffsize > 0)) {
                    bilg->WriteDisk(qrec->buff, qrec->buffsize, bilg->GetFlushDel());

                    delete[] qrec->buff;
                    qrec->buff = nullptr;
                }

                delete qrec;
                qrec = nullptr;
            } else {
                bilg->GetQueue()->WaitEvent();
                //::usleep(10000);
            }
        }
    }

    bilg->ThreadStopped(true);
}

TWriteDiskQueueStat TWriteDataDisk2::GetQueueStat() {
    TWriteDiskQueueStat res;

    if (m_queue != nullptr)
        res = m_queue->GetStat();

    return res;
}

void TWriteDataDisk2::StartThread() {
    m_MutexThread.Acquire();
    m_StopThread = false;
    m_Thread = new TThread((TThread::TThreadProc)&KThreadProc, this);
    m_Thread->Start();
    m_MutexThread.Release();
}

void TWriteDataDisk2::StopThread() {
    m_MutexThread.Acquire();
    m_StopThread = true;
    m_MutexThread.Release();
}

void TWriteDataDisk2::ThreadStopped(bool Stopped) {
    m_MutexThread.Acquire();
    m_StopThread = !Stopped;
    m_MutexThread.Release();
}

bool TWriteDataDisk2::ThreadStopped() {
    return !m_StopThread;
}

void TWriteDataDisk2::Midnight() {
    if (m_queue != nullptr)
        m_queue->Midnight();
}

TWriteDataDiskStat TWriteDataDisk2::GetStat() {
    TWriteDataDiskStat res;
    TWriteDiskQueueStat wdqs;

    res.datafile = m_filename;
    res.indexfile = m_filename_index;
    res.write = m_write;
    if (m_queue != nullptr) {
        wdqs = m_queue->GetStat();
        res.today_in_count = wdqs.m_today_in_count;
        res.today_count = wdqs.m_today_count;
        res.today_lost_count = wdqs.m_today_lost_count;
        res.yesterday_in_count = wdqs.m_yesterday_in_count;
        res.yesterday_lost_count = wdqs.m_yesterday_lost_count;
    }

    return res;
}

void TWriteDataDisk2::SetWriteData(bool writeA) {
    m_MutexWrite.Acquire();

    m_write = writeA;

    m_MutexWrite.Release();
}

void TWriteDataDisk2::Shutdown() {
    if (m_queue != nullptr)
        m_queue->Shutdown();
}

void TWriteDataDisk2::WriteThreadIDToLog() {
    int thread_id = -1;

#ifndef _win_
    thread_id = syscall(SYS_gettid);
#endif

    if ((LogsGroup != nullptr) && (LogsGroup->GetDebugInfoLog() != nullptr))
        LogsGroup->GetDebugInfoLog()->WriteMessageAndDataStatus(KMESSAGE, "THREADID % 9d: Monitoring", thread_id);
}

//*********************************************************************************
