#pragma once

#ifndef twritedisk_H
#define twritedisk_H

#include "util/generic/stroka.h"
#include "util/system/thread.h"
#include "util/system/mutex.h"
#include "util/system/file.h"
#include "util/system/event.h"
#include "tlogsgroup.h"
#include <mail/so/spamstop/tools/so-clients/shtime.h>
#include <list>

//******************************************************************************************************************
//                                        TWriteDiskQueue
//******************************************************************************************************************

struct TWriteBuffRec {
    char* buff;
    ui32 buffsize;

    TWriteBuffRec() {
        buff = nullptr;
        buffsize = 0;
    }

    TWriteBuffRec(const char* buffA, ui32 buffsizeA) {
        if ((buffA != nullptr) && (buffsizeA > 0)) {
            buff = new char[buffsizeA];
            memcpy(buff, buffA, buffsizeA);
            buffsize = buffsizeA;
        } else {
            buff = nullptr;
            buffsize = 0;
        }
    }
};

struct TWriteDiskQueueStat {
    ui32 m_today_count;
    ui64 m_today_in_count;
    ui64 m_today_out_count;
    ui64 m_today_lost_count;
    ui64 m_yesterday_in_count;
    ui64 m_yesterday_out_count;
    ui64 m_yesterday_lost_count;
    float m_cps;

    TWriteDiskQueueStat() {
        m_today_count = 0;
        m_today_in_count = 0;
        m_today_out_count = 0;
        m_today_lost_count = 0;
        m_yesterday_in_count = 0;
        m_yesterday_out_count = 0;
        m_yesterday_lost_count = 0;
        m_cps = 0;
    }
};

typedef std::list<TWriteBuffRec*> TLockWBRDataList;
typedef TLockWBRDataList::iterator TLockWBRDataListIt;

class TWriteDiskQueue {
private:
    static const int MAX_ELEMENT_COUNT = 50000;

    TLockWBRDataList blist;
    TMutex m_Mutex;
    ui64 m_today_in_count;
    ui64 m_today_out_count;
    ui64 m_today_lost_count;
    ui64 m_yesterday_in_count;
    ui64 m_yesterday_out_count;
    ui64 m_yesterday_lost_count;
    float m_cps;
    TLogsGroup* LogsGroup;
    TString m_ident;
    TSystemEvent m_Event;
    bool m_stop_event;

    ui32 m_request;
    time_t m_last_calc_cps;

    void SendEvent();
    void UnBlockAllEvent();
    void Lock();
    void UnLock();
    void CalcCPS();
    void ReCalcCPS();

public:
    TWriteDiskQueue(TLogsGroup* LogsGroupA, const TString& ident);
    ~TWriteDiskQueue();

    void Add(TWriteBuffRec* value);
    TWriteBuffRec* Get();
    TWriteBuffRec* GetEvent();
    void Midnight();
    TWriteDiskQueueStat GetStat();
    void Shutdown();
    void WaitEvent();
};

//*************************************************************************************
//                                TWriteDataDisk
//*************************************************************************************

class TWriteDataDisk {
private:
    TMutex m_Mutex;
    TString m_filename;
    FILE* m_handle;
    bool m_write;

    void Lock();
    void UnLock();
    bool ExistsFile(TString filename);

public:
    TWriteDataDisk();
    ~TWriteDataDisk();

    void Init(TString filename, bool write);
    bool Write(char* BUFF, size_t sizebuff);
    bool Rotate();
};

//*************************************************************************************
//                                TWriteDataDisk
//*************************************************************************************

struct TWriteDataDiskStat {
    TString datafile;
    TString indexfile;
    bool write;
    ui64 today_in_count;
    ui32 today_count;
    ui64 today_lost_count;
    ui64 yesterday_in_count;
    ui64 yesterday_lost_count;

    TWriteDataDiskStat() {
        Clear();
    }

    void Clear() {
        datafile = "";
        indexfile = "";
        write = false;
        today_in_count = 0;
        today_count = 0;
        today_lost_count = 0;
        yesterday_in_count = 0;
        yesterday_lost_count = 0;
    }
};

class TWriteDataDisk2 {
private:
    TMutex m_Mutex;
    TString m_filename;
    TString m_filename_index;
    FILE* m_handle;
    TFile* m_alllog;
    bool m_write;
    TMutex m_MutexWrite;
    ui64 m_mailcount;
    TLogsGroup* LogsGroup;

    TWriteDiskQueue* m_queue;
    TThread* m_Thread;
    bool m_StopThread;
    TMutex m_MutexThread;
    ui32 m_flushdel;

    void Lock();
    void UnLock();
    bool ExistsFile(TString filename);

public:
    TWriteDataDisk2();
    ~TWriteDataDisk2();

    bool InitBeforeFork(const TString& filename, const TString& filenameindex, bool write, TLogsGroup* LogsGroupA);
    bool InitAfterFork();
    bool Write(const char* BUFF, size_t sizebuff);
    bool WriteDisk(char* BUFF, size_t sizebuff, ui32 flushdelA);
    bool Rotate();
    ui32 GetFlushDel() {
        return m_flushdel;
    }

    bool ThreadShouldStop() {
        return m_StopThread;
    }
    void ThreadStopped(bool Stopped);
    bool ThreadStopped();
    void StartThread();
    void StopThread();
    TWriteDiskQueue* GetQueue() {
        return m_queue;
    }
    TWriteDiskQueueStat GetQueueStat();
    void Midnight();
    TWriteDataDiskStat GetStat();

    void SetWriteData(bool writeA);
    bool GetWriteData() {
        return m_write;
    }
    void Shutdown();
    void WriteThreadIDToLog();
};

//*************************************************************************************

#endif
