#!/bin/bash
set -exo pipefail

export SPAMPKIN_PORT=9092
export ROOT=.
export ALL_CAS_DIR=.
export LOG_DIR=/logs
export TVM_API_HOST=https://tvm-api.yandex.net
export SPAM_SAMPLES=spam-samples.json
export SPAM_SAMPLES_LOCK_FILE=$SPAM_SAMPLES.lock
export SO_COMPAINS_SPAM_SAMPLES=so-compains-$SPAM_SAMPLES
export NEURO_HARDS_SPAM_SAMPLES=neuro-hards-$SPAM_SAMPLES
export ZOO_QUEUE=change_log
export ZOO_CORP_QUEUE=corp_change_log
export ADDITIONAL_CONFIG=empty.conf
export LIBUNPERSON=libunperson-jniwrapper.so
export LIBDEOBFUSCATOR=libdeobfuscator-jniwrapper.so
export LIBOCRAAS=libocraas-jniwrapper-jniwrapper.so
export OCRAAS_CONFIG=ocrdata/ocrdata/yt/ocr.OCRNNLiteEnRu.cfg
export FAST_TEXT_MODEL=pures-e15.model.bin
export HNSW_DSSM=model.dssm
export MAIL_DSSM=mail-model.dssm
export QUEUE_OCR_WORKERS=false
export SOSEARCH_PROXY_POOL_TIMEOUT=200ms
export SOSEARCH_PROXY_SOCKET_TIMEOUT=300ms
export TEMPLATE_MASTER_POOL_TIMEOUT=200ms
export TEMPLATE_MASTER_SOCKET_TIMEOUT=300ms
export TIMER_RESOLUTION=51ms
export SANITIZER_CONFIGS_ROOT=.
export SO2_TMPDIR=/dev/shm/tmp
export ACTIVITY_HOST=http://user-activity.so.yandex.net
export YADISK_HOST=http://intapi.disk.yandex.net:8080
export YADISK_TVM_CLIENT_ID=132

export BIGB_HOST=bigb-fast.yandex.ru
export BIGB_TVM_CLIENT_ID=2001337

export SP_LOGGER_PORT=9095
export SP_LOGGER_TVM2_ID=2025242
export SP_LOGGER_CPU_CORES=2
export PRODUCER_PORT=81
export SHARDS=434
export SHARDS_PER_HOST=62
export MDS_PROD_TVM2_ID=2000273
export MDS_TESTING_TVM2_ID=2000272
export EXECUTION_TIMEOUT=1s

case "$NANNY_SERVICE_ID" in
    spdaemon-prod-in-sas|spdaemon-prod-in-vla|spdaemon-prod-in-myt|spdaemon-prod-in-iva|spdaemon-canary-in)
        export TVM_CLIENT_ID=2001103
        export PANEL_TITLE="spdaemon-in"
        export PANEL_TAG="itype=spdaemon;prj=so;nanny=spdaemon-prod-in*,spdaemon-canary-in;ctype=prod"
        export CPU_CORES=12
        export XMX=16G
        export SOSEARCH_PROXY_POOL_TIMEOUT=1s
        export SOSEARCH_PROXY_SOCKET_TIMEOUT=1s
        export TEMPLATE_MASTER_POOL_TIMEOUT=1s
        export TEMPLATE_MASTER_SOCKET_TIMEOUT=1s
        export TIMER_RESOLUTION=201ms
        export SELENIUM_INSTANCES=1
        export OCRAAS_INSTANCES=1
        export OCRAAS_MAX_PROCESS_TIME=5000
        export ROUTE=in
        export CTYPE=prod
        export DELIVERYLOG_TTL=14d
        export SP_LOGGER_BATCH_SAVE_MAX_RPS=1
        export SP_LOGGER_BATCH_SAVE_TIMEOUT=2s
        export SP_LOGGER_STORAGE_RETRY_TIMEOUT=1m
        export SP_LOGGER_BATCHES_MEM_LIMIT=2G
        export SP_LOGGER_BATCH_MIN_SIZE=10M
        export SP_LOGGER_BATCH_MAX_SIZE=200M
        export EXECUTION_TIMEOUT=20s
        export BLACKBOX_HOST=http://blackbox-mail.yandex.net
        export BLACKBOX_TVM_CLIENT_ID=222
        export CORP_BLACKBOX_HOST=http://blackbox.yandex-team.ru
        export CORP_BLACKBOX_TVM_CLIENT_ID=223
        export TEMPLATE_MASTER_HOST=http://templatemaster.so.yandex.net
        export CRETUR_HOST=https://cretur.so.yandex.net
        export CRETUR_TVM_ID=2035323
        export SENDERS_HOST=http://sosearch-proxy.mail.yandex.net
        export SENDERS_PORT=80
        export SENDERS_TVM_CLIENT_ID=2000031
        ;;
    spdaemon-prod-out-sas|spdaemon-prod-out-vla|spdaemon-prod-out-myt|spdaemon-prod-out-iva|spdaemon-canary-out)
        export TVM_CLIENT_ID=2016973
        export PANEL_TITLE="spdaemon-out"
        export PANEL_TAG="itype=spdaemon;prj=so;nanny=spdaemon-prod-out*,spdaemon-canary-out;ctype=prod"
        export CPU_CORES=10
        export XMX=16G
        export ROUTE=out
        export CTYPE=prod
        export DELIVERYLOG_TTL=21d
        export SP_LOGGER_BATCH_SAVE_MAX_RPS=1
        export SP_LOGGER_BATCH_SAVE_TIMEOUT=4s
        export SP_LOGGER_STORAGE_RETRY_TIMEOUT=1m
        export SP_LOGGER_BATCHES_MEM_LIMIT=2G
        export SP_LOGGER_BATCH_MIN_SIZE=10M
        export SP_LOGGER_BATCH_MAX_SIZE=200M
        export EXECUTION_TIMEOUT=1s
        export BLACKBOX_HOST=http://blackbox-mail.yandex.net
        export BLACKBOX_TVM_CLIENT_ID=222
        export CORP_BLACKBOX_HOST=http://blackbox.yandex-team.ru
        export CORP_BLACKBOX_TVM_CLIENT_ID=223
        export TEMPLATE_MASTER_HOST=http://templatemaster.so.yandex.net
        export CRETUR_HOST=https://cretur.so.yandex.net
        export CRETUR_TVM_ID=2035323
        export SENDERS_HOST=http://sosearch-proxy.mail.yandex.net
        export SENDERS_PORT=80
        export SENDERS_TVM_CLIENT_ID=2000031
        ;;
    spdaemon-prod-corp-sas|spdaemon-prod-corp-vla|spdaemon-prod-corp-myt|spdaemon-prod-corp-iva|spdaemon-canary-corp)
        export TVM_CLIENT_ID=2001119
        export PANEL_TITLE="spdaemon-corp"
        export PANEL_TAG="itype=spdaemon;prj=so;nanny=spdaemon-prod-corp*,spdaemon-canary-corp;ctype=prod"
        export CPU_CORES=8
        export XMX=6G
        export SOSEARCH_PROXY_POOL_TIMEOUT=1s
        export SOSEARCH_PROXY_SOCKET_TIMEOUT=1s
        export TEMPLATE_MASTER_POOL_TIMEOUT=1s
        export TEMPLATE_MASTER_SOCKET_TIMEOUT=1s
        export ROUTE=corp
        export CTYPE=prod
        export DELIVERYLOG_TTL=30d
        export SP_LOGGER_BATCH_SAVE_MAX_RPS=1
        export SP_LOGGER_BATCH_SAVE_TIMEOUT=8s
        export SP_LOGGER_STORAGE_RETRY_TIMEOUT=1m
        export SP_LOGGER_BATCHES_MEM_LIMIT=1G
        export SP_LOGGER_BATCH_MIN_SIZE=10M
        export SP_LOGGER_BATCH_MAX_SIZE=200M
        export EXECUTION_TIMEOUT=3s
        export BLACKBOX_HOST=http://blackbox-mail.yandex.net
        export BLACKBOX_TVM_CLIENT_ID=222
        export CORP_BLACKBOX_HOST=http://blackbox.yandex-team.ru
        export CORP_BLACKBOX_TVM_CLIENT_ID=223
        export TEMPLATE_MASTER_HOST=http://templatemaster.so.yandex.net
        export CRETUR_HOST=https://cretur.so.yandex.net
        export CRETUR_TVM_ID=2035323
        export SENDERS_HOST=http://sosearch-proxy.mail.yandex.net
        export SENDERS_PORT=80
        export SENDERS_TVM_CLIENT_ID=2000031
        ;;
    spdaemon-testing-in)
        export ROUTE=in
        export CTYPE=testing
        export EXECUTION_TIMEOUT=27s
        export BLACKBOX_HOST=http://blackbox-mimino.yandex.net
        export BLACKBOX_TVM_CLIENT_ID=239
        export CORP_BLACKBOX_HOST=http://blackbox.yandex-team.ru
        export CORP_BLACKBOX_TVM_CLIENT_ID=223
        export TEMPLATE_MASTER_HOST=http://templatemaster.so.yandex.net
        export CRETUR_HOST=https://cretur.so.yandex.net
        export CRETUR_TVM_ID=2035323
        export SENDERS_HOST=http://sosearch-proxy.mail.yandex.net
        export SENDERS_PORT=80
        export SENDERS_TVM_CLIENT_ID=2000031
        ;;
    spdaemon-testing-out)
        export ROUTE=out
        export CTYPE=testing
        export BLACKBOX_HOST=http://blackbox-mimino.yandex.net
        export BLACKBOX_TVM_CLIENT_ID=239
        export CORP_BLACKBOX_HOST=http://blackbox.yandex-team.ru
        export CORP_BLACKBOX_TVM_CLIENT_ID=223
        export TEMPLATE_MASTER_HOST=http://templatemaster.so.yandex.net
        export CRETUR_HOST=https://cretur.so.yandex.net
        export CRETUR_TVM_ID=2035323
        export SENDERS_HOST=http://sosearch-proxy.mail.yandex.net
        export SENDERS_PORT=80
        export SENDERS_TVM_CLIENT_ID=2000031
        ;;
    spdaemon-testing-corp)
        export ROUTE=corp
        export CTYPE=testing
        export BLACKBOX_HOST=http://blackbox-mimino.yandex.net
        export BLACKBOX_TVM_CLIENT_ID=239
        export CORP_BLACKBOX_HOST=http://blackbox.yandex-team.ru
        export CORP_BLACKBOX_TVM_CLIENT_ID=223
        export TEMPLATE_MASTER_HOST=http://templatemaster.so.yandex.net
        export CRETUR_HOST=https://cretur.so.yandex.net
        export CRETUR_TVM_ID=2035323
        export SENDERS_HOST=http://sosearch-proxy.mail.yandex.net
        export SENDERS_PORT=80
        export SENDERS_TVM_CLIENT_ID=2000031
        ;;
    spdaemon-testing-mail-in)
        export ROUTE=in
        export CTYPE=testing
        export BLACKBOX_HOST=http://pass-test.yandex.ru
        export BLACKBOX_TVM_CLIENT_ID=224
        export CORP_BLACKBOX_HOST=http://blackbox-test.yandex-team.ru
        export CORP_BLACKBOX_TVM_CLIENT_ID=225
        export TEMPLATE_MASTER_HOST=http://testing.templatemaster.so.yandex.net
        export CRETUR_HOST=https://cretur-test.so.yandex.net
        export CRETUR_TVM_ID=2035325
        export YADISK_HOST=http://cloud-api.dst.yandex.net:8080
        export SENDERS_HOST=https://msearch-proxy-test.search.yandex.net
        export SENDERS_PORT=10431
        export SENDERS_TVM_CLIENT_ID=186
        ;;
    spdaemon-testing-mail-out)
        export ROUTE=out
        export CTYPE=testing
        export BLACKBOX_HOST=http://pass-test.yandex.ru
        export BLACKBOX_TVM_CLIENT_ID=224
        export CORP_BLACKBOX_HOST=http://blackbox-test.yandex-team.ru
        export CORP_BLACKBOX_TVM_CLIENT_ID=225
        export TEMPLATE_MASTER_HOST=http://testing.templatemaster.so.yandex.net
        export CRETUR_HOST=https://cretur-test.so.yandex.net
        export CRETUR_TVM_ID=2035325
        export YADISK_HOST=http://cloud-api.dst.yandex.net:8080
        export SENDERS_HOST=https://msearch-proxy-test.search.yandex.net
        export SENDERS_PORT=10431
        export SENDERS_TVM_CLIENT_ID=186
        ;;
    spdaemon-testing-mail-corp)
        export ROUTE=corp
        export CTYPE=testing
        export BLACKBOX_HOST=http://pass-test.yandex.ru
        export BLACKBOX_TVM_CLIENT_ID=224
        export CORP_BLACKBOX_HOST=http://blackbox-test.yandex-team.ru
        export CORP_BLACKBOX_TVM_CLIENT_ID=225
        export TEMPLATE_MASTER_HOST=http://testing.templatemaster.so.yandex.net
        export CRETUR_HOST=https://cretur-test.so.yandex.net
        export CRETUR_TVM_ID=2035325
        export YADISK_HOST=http://cloud-api.dst.yandex.net:8080
        export SENDERS_HOST=https://msearch-proxy-test.search.yandex.net
        export SENDERS_PORT=10431
        export SENDERS_TVM_CLIENT_ID=186
        ;;
esac

export MDS_DELETE_QUEUE_NAME=sologger_delete
export SEARCHMAP_PATH=searchmap-${CTYPE}.txt
export SP_LOGGER_CONFIG_PATH=sp-logger-${CTYPE}.conf
export DELIVERYLOG_PATH="${LOG_DIR}/delivery_so_${ROUTE}.log"
export SPARE_DELIVERYLOG_PATH="${LOG_DIR}/spare_delivery_${ROUTE}.log"

if [ "$CTYPE" == "prod" ]; then
    export QUEUE_NAME=sologger
    export MDS_NAMESPACE=$QUEUE_NAME
    export SP_LOGGER_MEM_LIMIT=3G
    export KITSUNE_CONFIG_PATH=sp-kitsune-${ROUTE}-service.conf
elif [ "$CTYPE" == "testing" ]; then
    export TVM_CLIENT_ID=2010396
    export PANEL_TITLE="$NANNY_SERVICE_ID"
    export PANEL_TAG="itype=spdaemon;prj=so;nanny=$NANNY_SERVICE_ID"
    export CPU_CORES=3
    export XMX=8G
    export SHARDS=14
    export SHARDS_PER_HOST=14
    export SP_LOGGER_MEM_LIMIT=2G
    export QUEUE_NAME=sologger-test
    export MDS_NAMESPACE=sologger
    export DELIVERYLOG_TTL=1d
    export SP_LOGGER_BATCH_SAVE_MAX_RPS=1
    export SP_LOGGER_BATCH_SAVE_TIMEOUT=3s
    export SP_LOGGER_STORAGE_RETRY_TIMEOUT=3m
    export SP_LOGGER_BATCHES_MEM_LIMIT=1G
    export SP_LOGGER_BATCH_MIN_SIZE=10M
    export SP_LOGGER_BATCH_MAX_SIZE=200M
    export KITSUNE_CONFIG_PATH=sp-kitsune-${CTYPE}-service.conf
fi

if [ "$ROUTE" == "in" ]; then
    export HTTP_PORT=2527
    export KITSUNE_PORT=2526
    export SO2_PORT=2528
elif [ "$ROUTE" == "out" ]; then
    export HTTP_PORT=5254
    export KITSUNE_PORT=5253
    export SO2_PORT=5255
elif [ "$ROUTE" == "corp" ]; then
    export HTTP_PORT=2527
    export KITSUNE_PORT=2526
    export SO2_PORT=2528
fi

export KITSUNE_HEAD_HOST=http://localhost:$SO2_PORT
export SPDAEMON_HOST=http://localhost:$HTTP_PORT

