#!/bin/bash
set -exo pipefail

source config.sh

export CORE_DIR="/cores"
export IBM_HEAPDUMP=1
export IBM_HEAP_DUMP=1
export IBM_COREDIR=$CORE_DIR
export IBM_HEAPDUMPDIR=$CORE_DIR
export IBM_JAVACOREDIR=$CORE_DIR
export LANG=en_US.UTF-8
export LD_LIBRARY_PATH=.

source classpath.sh

./spam-samples-so-compains-update.sh CLEAR

mkdir -p /dev/shm/gclogs
mkdir -p $SO2_TMPDIR

source configure_mkl.sh

GC_ARGS="
-XX:ActiveProcessorCount=$CPU_CORES
-XX:+IgnoreUnrecognizedVMOptions
-XX:+HeapDumpOnOutOfMemoryError
-XX:HeapDumpPath=$CORE_DIR
-XcompilationThreads1
-Xss16M
-Xmx${XMX}
-Xms2G
-XX:+PrintGC
-XX:+PrintGCDetails
-XX:+UnlockExperimentalVMOptions
-verbose:gc
-XX:+UseShenandoahGC
-XX:ConcGCThreads=2
-XX:ShenandoahGCMode=iu
-XX:-ShenandoahAlwaysClearSoftRefs
-XX:ShenandoahAllocationThreshold=5
-XX:ShenandoahUncommitDelay=100000
-XX:ShenandoahGuaranteedGCInterval=100000
-XX:ShenandoahGarbageThreshold=10
-XX:SoftRefLRUPolicyMSPerMB=1000
-XX:+PrintCodeCache
-XX:ParallelGCThreads=4
-XX:+UnlockDiagnosticVMOptions
-XX:+PrintGCDateStamps
-XX:+UseGCLogFileRotation -XX:NumberOfGCLogFiles=5 -XX:GCLogFileSize=2M
-Xlog:gc*:/dev/shm/gclogs/gc.log
"

NET_ARGS="-Djava.net.preferIPv4Stack=false -Djava.net.preferIPv6Addresses=true"
SPAMPKIN_ARGS="ru.yandex.mail.so.spampkin.Spampkin spampkin.conf"
SO2_ARGS="ru.yandex.mail.so2.So2HttpServer so2-service.conf"
SP_LOGGER_ARGS="ru.yandex.mail.so.logger.SpLogger $SP_LOGGER_CONFIG_PATH"
KITSUNE_ARGS="ru.yandex.sp_kitsune.SpKitsuneHttpServer $KITSUNE_CONFIG_PATH"
exec $BSCONFIG_IDIR/jdk/bin/java \
    $GC_ARGS $NET_ARGS \
    -DPORTO=1 \
    -Djava.library.path=spdaemon_accessories:. \
    -Djava.io.tmpdir=$SO2_TMPDIR \
    -cp $CLASSPATH ru.yandex.multistarter.MultiStarter \
    $SPAMPKIN_ARGS ";" $SO2_ARGS ";" $KITSUNE_ARGS

