#!/bin/bash
set -exo pipefail

source config.sh

tmpfile=$SO_COMPAINS_SPAM_SAMPLES.tmp
tmpcurl=$SO_COMPAINS_SPAM_SAMPLES.curltmp
tmpout=$SO_COMPAINS_SPAM_SAMPLES.outtmp
tmpbody=$SO_COMPAINS_SPAM_SAMPLES.tmpbody

neurofile=$NEURO_HARDS_SPAM_SAMPLES.tmp
neurocurl=$NEURO_HARDS_SPAM_SAMPLES.curltmp
neuroout=$NEURO_HARDS_SPAM_SAMPLES.outtmp
neurobody=$NEURO_HARDS_SPAM_SAMPLES.tmpbody

function cleanup() {
    /bin/rm -f $tmpfile $tmpcurl $tmpout $tmpbody
    /bin/rm -f $neurofile $neurocurl $neuroout $neurobody
    /bin/rm -f $SPAM_SAMPLES.tmp
}
trap cleanup EXIT

if [ "$1" != "LOCKED" ]
then
    exec flock $SPAM_SAMPLES_LOCK_FILE "$0" LOCKED "$@"
    exit 0
fi

if [ "$2" = "CLEAR" ]
then
    /bin/rm -f $SO_COMPAINS_SPAM_SAMPLES
    /bin/rm -f $NEURO_HARDS_SPAM_SAMPLES
fi

# so compains samples
if [ -f $SO_COMPAINS_SPAM_SAMPLES -a -s $SO_COMPAINS_SPAM_SAMPLES ]
then
    revision=$(tail -n1 $SO_COMPAINS_SPAM_SAMPLES|./jq -r .revision)
    url=$(tail -n1 $SO_COMPAINS_SPAM_SAMPLES|./jq -r .url)
    postfilter="&dp=const($revision+revisionstr)&dp=to-long(revisionstr+trevision)&dp=const($url+turl)&dp=multi(trevision,turl+threshold)&postfilter=sortkey+greaterthan+threshold"
else
    revision=0
fi

code=$(curl -s -m300 --retry 3 -w "%{http_code}" --compress -o $tmpcurl "$SENDERS_HOST:$SENDERS_PORT/sequential/search?prefix=991949281&service=change_log&get=*&dp=multi(spam_sample_revision,url+sortkey)&sort=sortkey&asc&text=spam_sample_type:so_compains$postfilter")
if [ "$code" != "200" ]
then
    >&2 echo Failed to load spam samples with code $code
    >&2 cat $tmpcurl
    exit 1
fi

./jq -cM '.hitsArray[] | {url:.url,revision:.spam_sample_revision,type:.spam_sample_type,labels:.spam_sample_labels,docs:(.spam_sample_data // "null"|fromjson|.docs)}' $tmpcurl >$tmpout

if [ "$2" = "CLEAR" ]
then
    /bin/chown loadbase $tmpout
    /bin/mv $tmpout $SO_COMPAINS_SPAM_SAMPLES
elif [ -s $tmpout ]
then
    code=$(curl -s -m300 -w "%{http_code}" -o $tmpbody --data-binary @$tmpout "http://localhost:$SO2_PORT/add-spam-samples?revision=$revision")
    if [ "$code" != "200" ]
    then
        >&2 echo Failed to add spam samples with code $code:
        >&2 cat $tmpbody
        exit 1
    fi
    /bin/cat $SO_COMPAINS_SPAM_SAMPLES $tmpout > $tmpfile
    /bin/chown loadbase $tmpfile
    /bin/mv $tmpfile $SO_COMPAINS_SPAM_SAMPLES
fi

# neuro hards samples
if [ -f $NEURO_HARDS_SPAM_SAMPLES -a -s $NEURO_HARDS_SPAM_SAMPLES ]
then
    neurorevision=$(tail -n1 $NEURO_HARDS_SPAM_SAMPLES|./jq -r .revision)
    neurourl=$(tail -n1 $NEURO_HARDS_SPAM_SAMPLES|./jq -r .url)
    neurofilter="&dp=const($neurorevision+revisionstr)&dp=to-long(revisionstr+trevision)&dp=const($neurourl+turl)&dp=multi(trevision,turl+threshold)&postfilter=sortkey+greaterthan+threshold"
else
    neurorevision=0
fi

code=$(curl -s -m300 --retry 3 -w "%{http_code}" --compress -o $neurocurl "$SENDERS_HOST:$SENDERS_PORT/sequential/search?prefix=991949281&service=change_log&get=*&dp=multi(spam_sample_revision,url+sortkey)&sort=sortkey&asc&text=spam_sample_type:neuro_hard$neurofilter")
if [ "$code" != "200" ]
then
    >&2 echo Failed to load neuro samples with code $code
    >&2 cat $neurocurl
    exit 1
fi

./jq -cM '.hitsArray[] | {url:.url,revision:.spam_sample_revision,type:.spam_sample_type,labels:.spam_sample_labels,docs:(.spam_sample_data // "null"|fromjson|.docs)}' $neurocurl >$neuroout

if [ "$2" = "CLEAR" ]
then
    /bin/chown loadbase $neuroout
    /bin/mv $neuroout $NEURO_HARDS_SPAM_SAMPLES
elif [ -s $neuroout ]
then
    code=$(curl -s -m300 -w "%{http_code}" -o $neurobody --data-binary @$neuroout "http://localhost:$SO2_PORT/add-spam-samples?neuro-sample&revision=$revision")
    if [ "$code" != "200" ]
    then
        >&2 echo Failed to add neuro samples with code $code:
        >&2 cat $neurobody
        exit 1
    fi
    /bin/cat $NEURO_HARDS_SPAM_SAMPLES $neuroout > $neurofile
    /bin/chown loadbase $neurofile
    /bin/mv $neurofile $NEURO_HARDS_SPAM_SAMPLES
fi

# save state
/bin/cat $SO_COMPAINS_SPAM_SAMPLES $NEURO_HARDS_SPAM_SAMPLES > $SPAM_SAMPLES.tmp
/bin/mv $SPAM_SAMPLES.tmp $SPAM_SAMPLES

